package eckcdsa

import (
	"testing"

	"github.com/RyuaNerin/go-krypto/internal"
)

func Test_Verify_K283_SHA224(t *testing.T) {
	testVerify(t, testCases_K283_SHA224, k283, hashSHA256_224)
}

var testCases_K283_SHA224 = []testCase{
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 암호알고리즘 검증기준 V3.0
	// 테스트 벡터
	// EC-KCDSA_(K-283)(SHA-224)_SGT.txt
	{
		M:    internal.HB(`8B9D4F2A6021066AEA3405CF51F7AC8B9904B066278CEC01031E30FC9A150D3A0B44F90DBCDCBB9B55197E39CBC08008A8F0B99F2A5666097642E1D774ACB09B82B72E8AB0A6B8919FE0CCA8AA01EFA19A81E54863F7F60E3F86D11AA978DBEE7C915E85CB167A15A62E445B6F7DF79DE1A4AA3985975B0FA061D9785E4E512D`),
		Qx:   internal.HI(`38470698513D87C84B262B0EAD199709A57F1CDCA62AF0162C4BD134BA72CD57AC85742`),
		Qy:   internal.HI(`26733EFCE9314EB92F324406460EC0FCB314535D26F5FEBF5BF762E149C95AF591B4884`),
		R:    internal.HI(`E3DF4D7C2EB631B6384422446FF8D6681E7DA968CA758D1B71914B81`),
		S:    internal.HI(`CB4B5731DB8411B4BBA438D942C921633E9C6636389AF0282723EDC3AE4187796A6740`),
		Fail: true,
	},
	{
		M:  internal.HB(`B813BEA088F83C16E4F713D78F0A235B45FC74C47E571A45D054FBFA01C8AF604E655102F6488299852F6334F144D4A10FE2BDAC5E45AB73C782845E3DB1A0F9DDBA0D4B88A344D185C718D532EB2A314984A639C82B91EDF999751CB215AC9D3EC7194814C48DDEC854B27A513DAABD229A485C270A0A3620B3C29975F70DDF`),
		Qx: internal.HI(`616A7E4EE2C85D1D0817BE7BBD31D2AB4B85B02DFF580FA37D9A8212A9A61FE6CE0F63B`),
		Qy: internal.HI(`61AE86989249DDEDB561CBC871D305CFCA3C0087B3F5B51991ADE187E8BA84A8FABA58D`),
		R:  internal.HI(`B2E05C1AAC8402A1A354DFBF33620EAA09F9C40E633D27BA1D26B451`),
		S:  internal.HI(`0129CDD3D48301650EAFAAE232770786254A277074FBCFB7785B84BA0DBD6AAF05FC152A`),
	},
	{
		M:  internal.HB(`4682109AF1D1A6DA73992A760142BD6EE3A5500D69BF999AF14780C2E1621D27FA3E003FF6EAD8EECA1D34F4854772AC26A8963458BE296F7CC9C4FDE5B57BA9B02CBE52271CECE0067732419F75E5013322F881717DBF4F87F2A3B49D77E7F43A11384A60111E34DDC50200AEF1E63BE1CE87FCD4DD009149589F9B2C811429`),
		Qx: internal.HI(`68DB582582608A24BC3D996894CF4D0D2CB7ECB25FA5A1112796FE71C9EF5060768FBB7`),
		Qy: internal.HI(`0C94979AF9BFF37BE793D13079F7A68BE1C09784FF36B122BF90E3FCAE0AD5394C870A0`),
		R:  internal.HI(`795DED747FD564F5236B070644D55125F36B65E781191EF6B7934A5B`),
		S:  internal.HI(`F437C28AA079FFEA28AFB99317307DDA10C5C9DE61FCA130C53109E44AC6A8DC789072`),
	},
	{
		M:  internal.HB(`9CA4C606DD78140B12CDF6984A0FCE0F4D9FD9282456340477848F3D15811240627F8B04FBC655564B0117CC73C0D9A52AE0729E01F3E103B1669300DA71218BE39089D04DA1718C4A587A3EC9232292D7344AEE8CD3E79555A2D532E4F26E4883E4D5651F678E81CFD1606F132715CDAECD0B5A42B83D1595DAA913A9D8BC71`),
		Qx: internal.HI(`696DD54380CBCE2E25D3799F8A340A886BE0C794C91A8CB924FE88DAD155495387D4ADD`),
		Qy: internal.HI(`6C9BB011C6562CD9D6A78FB7A1741FF20A303D65F190426DE98CD5E88B0E51F0B40F69D`),
		R:  internal.HI(`5FFE8816A23F23F81199C3E8AD37E99DA331F05FA03015E886DA5155`),
		S:  internal.HI(`D585471A64EBDD823B40495C373D9CB5D2F896B780BC03D298730E427A747EAF55C1AE`),
	},
	{
		M:    internal.HB(`D0AF49253F751481B432647D86C855F02588A80D2E83E38DFB8C6F0CC0740B42F47E8678179C28F18F7FAB9BC1F933C9FEBB293A86006942382397560FA820B634CFB29CA61CAC963D015B6C200E744961C7B780DDA519A00D396737F211C4F2BF59E97C6CBB95D2DB991254B414316CA0F7B00014086B7B3EC33FC85E1112E3`),
		Qx:   internal.HI(`7503A576403150BB74DA99C50651F0656A3F802293DE124FD285A4D85980F5043114FB8`),
		Qy:   internal.HI(`100394B08B5EEAAB1F2C533533137A776465FF37EF907F4800BD62EFC6A8DB2DBF385AF`),
		R:    internal.HI(`17C7F497AB90D9BBF7AAC5001C623EFC7F34D41CD9E1A6081DCF03BE`),
		S:    internal.HI(`010166B76A4B7EC9DA28168AFFA9A6513971B11A812F94A2A4D9430D88942100108E71AA`),
		Fail: true,
	},
	{
		M:  internal.HB(`4CAB777D40C6541E6DE776B21A7F38A71C3C7B02CD51800FA9A7D8A02C7C4490E735C8AF5CECB3BFAF85F3A6A2CA6A8600649AD8D7266D39BE885C1476C4C2C61A70A26F500CA910895FAA25DB14745F6F7A2BA224CE03F95703A0A26156D8D5DAB9327C1D5CD5701E53418011B492C2F71E8D838D045754A9B9FD808F8CB574`),
		Qx: internal.HI(`378F6DD74D6343BC2F59B5C208DD3AD07758E09782D37D1F4C80B09D6CC05611167946B`),
		Qy: internal.HI(`60C8858A0508AF5B4C45CF88CD5CEC9EA6471CD997EA84BF550D936917098B9DCD812AE`),
		R:  internal.HI(`8C2E5C8BC841DEE6C321B800D3D195A1844E548BA54CA3F01A31A908`),
		S:  internal.HI(`0111D946CD7D789F51F15A4FE7D17B356EB8E48867E0D9392563D21C17DA69EC907D47BF`),
	},
	{
		M:  internal.HB(`F2095C7118BF89B5C6C5CF3A0AE38B4A7988669088649510D534A94ACA6E9EA68A235E9E86D848BEA8AAF3F47C74D9423B49FE56240E51120A6FE3847C029B6775E29AA0F477E6D36ECE96847A3518E19C69C5AEA922625A913DBAD61457F8202D12EE1BB6DDE4B3177627D77B01F9535DE7000FF054EDBD2E9A84810E3B8B8F`),
		Qx: internal.HI(`3851E15FE580A7E1AB8D512CD59B4207C84C557CDEF0F81192D4D6CCF9F50BBF3D19E7C`),
		Qy: internal.HI(`2E54AE18A7BC6C5562037118238619924F25D41C1A0162667EB937B5B2C2E88D9093DD7`),
		R:  internal.HI(`35A35FCAA624AF8A6ADDF28ABF1647951624114169A9FF96FC765471`),
		S:  internal.HI(`0117EE249CCDDBEB535EFD786E87677C4C8CD385C420FBA7689FE115D89A0C219326AC4B`),
	},
	{
		M:    internal.HB(`E7005A2A3108482A4FE184009A76EAC629B698DA3F5E382AE55C6FED64729BA4FA4050B68462A2B46EC2C88CAAD020A8FEBD13526868EF57E729323D6F1354024FE59AC6CE4BFA4B509588B3C392985A9EAEED483A082F11D2970391E41BEE7051EC7BD0EE62AF0FDAEB530A5F8E1CBDA7EE3FB50B806C383E1AC4833080C912`),
		Qx:   internal.HI(`44488159D74B0703063ADF9282C97A2E4DCF1EFFB74D8D7879697E23774CCF5DE28CEA7`),
		Qy:   internal.HI(`64029E0964ED01A601D295E58078C9A7788CAEC54D7CAC2B4516B7A3B251C52EA583E0B`),
		R:    internal.HI(`33C68548CD255D53D57FF832D3A638BDC67EA08308068F7130EDFBAE`),
		S:    internal.HI(`5E2969ABFDEA3E7808F107B1779EF719842362D8B8388D317E0A4DB9C4D796BCBE4011`),
		Fail: true,
	},
	{
		M:  internal.HB(`69E3E03912E3CD27B22775393210E537E90520EB87589652955C00C13CBB712E6B9825841979D72CB58A19AA7B3D9586D5D48E5366D6A517EFFC2BDEBB9C07C2A81D79268E72C07D1036F0559A61F7F9A31F2566D8E131ED701714362FB5AEFB5FF5923F4F6CE83E94F9D3F4A2862D6EF43F1EB8622E5EADCDCF9774D0A3CDED`),
		Qx: internal.HI(`19B32DA15FBC4F4FEE6A6FA35ED98E395AFCA319E5BFF28CAE7DD67727151B32DB36CE0`),
		Qy: internal.HI(`67715BA90E84BF3490A007AFBAA6703AC43F7A31B892E724C26BE6026A374359F1B3EAF`),
		R:  internal.HI(`E1BAD85D194F01D49544DCC913921460CD2F48D953A02A90E579AD77`),
		S:  internal.HI(`0199B1048E7437EFE759D44869565512F2DE38223542193BABB162A83CC24040612B3116`),
	},
	{
		M:  internal.HB(`4C2CD7853335FDD9479F28EBDEDF2C3532BBC3CF99D79883EC9731192C4E131CF50DDF9EB415AE41403E7C17C53DE297A144ED3428CD57D6E100E9D340A650896D022F540B7FB0F3A79D6211BC00A816DA0B82EB06FAFCD4C6C40309F6D2EE3BD6E285A676F1C6E2EBB433096E66FC74D66AB59988A200515FDECC128A56A158`),
		Qx: internal.HI(`407B5F0D7ED4E2FD2D33D231600CFF26F2C1188EE9632584D890E8A8A22B50A93B5E633`),
		Qy: internal.HI(`661D45BF0F36D0DF4948BB3BBB11D14712D0CEED0CF5ACD275F938EA41B3C622F8AED9F`),
		R:  internal.HI(`24AEAC4F7E026ACA73DAE2E5CCDAF95109B3F4A71EADF3C7F99B3183`),
		S:  internal.HI(`01A7493F6538D5DB558FD413F381BD0AF7C8D0D1517DE25AB510EED06F961919348A006A`),
	},
	{
		M:  internal.HB(`888CDC5E711EC52283337BAF3AC53C34C1A32A2B8E42EB13537C8D653E85D053DAD285548E4D1E09118A2778CB53C13B7A50D193100D05F52E2F5D141F1B59F6C6D079115D5135046D4B18EBF25C1EDB06A70A8D0411CDBE81EDB34F144F73A941E6D8767D8D1B23AE719F540F0136ACDF7D9A0DCB6938D068A302F3C37563D8`),
		Qx: internal.HI(`1AE1A39B963ECA759D7EF520FF3E25E1B4E0A44CB6DF0ABAB578037A78C31D166BEBE38`),
		Qy: internal.HI(`0CF5681589F8D8A4988C00FE724CAE18D255E0C0248930F69D4FD4024F03F2E183AFC88`),
		R:  internal.HI(`C243712ABCA55EC9CC60913F7C96440ACE8B5EB74571A657A606F91B`),
		S:  internal.HI(`0BE90532664DD7931257E09B1CFF06ADA3B24EAC977F390C834D4601688CB5A6030760`),
	},
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 암호알고리즘 검증기준 V3.0
	// 테스트 벡터
	// EC-KCDSA_(K-283)(SHA-224)_SVT.txt
	{
		M:  internal.HB(`BA3C86829DDBB70702140F609916A9C1B597E8F985B5EEA9922338135EEA7E1F9182847D9C8E068B350262F296022B8DF4304D9CFAC4ECCFCC2E9E326C8C2E76E7B19AB9411C5A326E93B1E95FAA25EF7213C72839E37529FDAAB532EA9966D83D84D45274096F05D09CB94A1FC8A7FA337006CFEF4728124C5F61AF4800982B`),
		Qx: internal.HI(`8D7E405079DE71580D4618DBE8CBEE081201F5F38917504BAF61C3165622F888FB6524`),
		Qy: internal.HI(`283B692B1C6AA5A9087786C45DF2924EDDC911394DDE100A2F4039FF44E252E51A10B1D`),
		R:  internal.HI(`446759F14B8AC0D752D0ED8632BA38A10FD1DC16D40EA8AA0D0CB36B`),
		S:  internal.HI(`0106E3890FB3FD2E4969DD17DE6B95DCB3CF06BA322B86510B23A827104A7948439AB514`),
	},
	{
		M:  internal.HB(`1CA0868CAA3DCBB688DA82438A7F8769445F02E8538E6F91E901CA6B801A000016924BD5DC08B99EC7F6592CDE5B65A1BCE0FAF523BC7A530A29635111A49E8DC3CC08C08D244FC0CA7BD284DE4EA8ACB8DB769EA73F42AFEF5AE57303C63FB3C6ACE80AC6B26AC4D3E1CDEFD7B37D3F5C2046B3ABEB89A0E0FD530CE71076F9`),
		Qx: internal.HI(`528ADFC609FB7490680425BD2661C38733747E1ACDC9B11CBD315CEED35A947F3ADB345`),
		Qy: internal.HI(`7FD9E5EC55AE804C0E1B671309571108C40F0B1AED4D3E055824250174B3D41871A655F`),
		R:  internal.HI(`4D898B92D269BC9B4ED42F081917A6D574E936C4E49C45E8C4253BEF`),
		S:  internal.HI(`018759EF9E31B979876705FBCEBE3875BDCC7C5EC09552350C1C02F1AC0B74106A52A2E2`),
	},
	{
		M:  internal.HB(`C7755E991B3BAEFC2F86703F9C4EDDB4D667822D86FDD6CE2B64F57FD5779E8E78532777A5B089622FAE27678B4A85105C51892D171B7B8528CA5E556E5CD84B915A47DA076B2F98318AA9888839FCFD2A6504FBC45291BB37506842DA8411AED687091F6B2B9CE6962EF3E8FE1792D08613E2087C16F70DBE023521C820FAE0`),
		Qx: internal.HI(`6F2A579687B275C8564B3CD68E58BCED35C6911701042AF32ED13A82589229D970454DD`),
		Qy: internal.HI(`2FEDDE2410DC3F2BD79684B552FAD3465B6F2742605E341228A6A43A4A9DA8776F164E8`),
		R:  internal.HI(`4E7B7BAF42450D106E50BB74EE08FE20BC6C49376D996C1BD09C6D7C`),
		S:  internal.HI(`210944620D368EBAE9B63F3BD544A6684711ABBF773C0B9503489CB933CAAE1C2CAFF2`),
	},
	{
		M:  internal.HB(`0DBD01CA831B963ECB994CF6E3475D84BEB45CECB44658C22DD02DF372C60FAF0AC90B888ACBAA3B42B14147B2933CBD2688F0686A2524C7FB9504E398769294A55E4B2C42352C1D7743A89B7030D6C61DB66765266194B1A812B34482968EAEC0192DB5F6B939CEEE069FD8AAB79A93064ED0F2F60FA8BDBBF37B9000F6D6C4`),
		Qx: internal.HI(`6D3277F61E4DB8E2B3815892774F25784C16C26628E95CF37565BD7944CEFDDEA6A15C0`),
		Qy: internal.HI(`3E9D67AE5F44B935646B67A66422771A5B9A04ABE06AF3EFBE201171F92B9AD5438FBD8`),
		R:  internal.HI(`0856D06E5DE73576BDC9A0CAC871AFF5E9BE193CB977E942B1B8103B`),
		S:  internal.HI(`9C4F37037F39D3088F5C064122B9914D9704582EB0ADA438AAB83ABB7A12610B47CAD3`),
	},
	{
		M:  internal.HB(`447D64457720B6E031998B0C732DBDBF504A83496FAC29D3C2C8E76B6ACC054722F8EC2B209C508CD3801B6F67FB408D708821CAB11EA97E570DC89EA2B87E4D53DC0ADAD3C67CB4712B445FACF6E9EBE4D191FE61B07FF51723391C0FC06B96DA6648EFFB9E75E1ADEE4462ED58476A2FD50295AD19CE15AA549A00A154BF8A`),
		Qx: internal.HI(`69F3BE1D6785736B77FC4D24EB8D2DBA916AEA49DF6DA56C29D413E87816CF6DC570E0A`),
		Qy: internal.HI(`7FF5465984D9A12EE3E5CF5355E6BCB35547EF2C5CB94798BDCBAA0A5CE6983B04CD456`),
		R:  internal.HI(`CC7248D0394F95D850D7D7A0D9F5FE3B6F81E030080B558241313802`),
		S:  internal.HI(`B9C1AC6E7AA1F8627D591C7EF3DD68D8678A365E87B8E9654B09511477B02DB7367740`),
	},
	{
		M:  internal.HB(`BEBA7A2E8A8E43453309A1275FC4B147E12CED684D757C63C0D2968BD24B363913E4BE85FA67B0BAB6A12984BE4645648E5612777E493D0E0FB71F2AA0E45159EFD875074E6251C1F2C5F1794E50EA4FD3BC77EC078387EB57066E6E95C65C4B76724DF10F208583A969572BDCBD4F3A56AC6E1535779D7760A90512C1006915`),
		Qx: internal.HI(`5690456F935CC3624CA591DDF143CDD8FF2C3FE59A06D920EE98AD42AC6AA08A4AA1922`),
		Qy: internal.HI(`1F8694DB046C3362B92C557AA1CBADFBB133EDD003EB70FC6260AFBA770E4557C8EC3CA`),
		R:  internal.HI(`262768BDEC1FEB2B6167720334D237D1DE57885529CEE6ED0CC425B3`),
		S:  internal.HI(`95ECB2A927C2201C9238DECFC5316A0B3AA76E5CBFD0735F46FFA940C805A0D905AE2C`),
	},
	{
		M:  internal.HB(`D17738A851AA6FD2A76E02E9BCD1EC00C45F8D6DE1E386D8F970AEF8BC095469309173B9AD71FC28C098DE2ACA37FE26D3F6B59366EB15DCF8187B2BA7C0BF9CCD5682D7464EE1A7CE95228C6B018CD73F780E51AD1DE0F83E41C6DE296C15AFEA4230E0C6829B17B5FC4CD68BAB66E7CFD60696236E4A49B175306B74BD884A`),
		Qx: internal.HI(`5DCB4BAF6C936A7B2EA5D17A8BF27BA3C2C4C43C80ACD350A5927F1140B62C0FADB0F7B`),
		Qy: internal.HI(`775DCF8CADA6255F597A4811D3E3A8881814BC146327A06914391335999215AD3B1A59A`),
		R:  internal.HI(`33E2FB43BA99CDF8FF451C39EDA51538378DD6E65B7E3C27693CF597`),
		S:  internal.HI(`01B4C1C13DF6E1F7C845D03D90E7B4F479329BDC70E82A70D9C4073D987139D420FD93FE`),
	},
	{
		M:  internal.HB(`CFB892D85FB76FEB604B21F79E1822D04EE7577CBE3B7B954128A3553EC814BBCE0402EBCCFD6A3BC3E7AF04A1921FB7936C0042FE48644BE6B25246CA0F7CFB415B256F4FCD5FCBD9204D3D17CE83687C0C4852E7C4BE7E9E56B511DF7649A988D8E6DFB309ED02A52A97090EE53F55EC58C03C094209ED713E8FB0CC4ED00C`),
		Qx: internal.HI(`521C6D280011E4CC8B538C502D3F228F484646B09C8CF343B65EF44B550E2A6406B0E79`),
		Qy: internal.HI(`1943C3FC12DB84ECAB4388659A5F0F239C1733D78D13EE3C6422FBC379D2FEB5EFF83DD`),
		R:  internal.HI(`1578B1DCF2FF5A19542212A7C2AF587FD547FB26962A880B28575BD3`),
		S:  internal.HI(`BBA3F8F52DFC710A57CCD6BB5EFE99199DFC3AFE50EFA72717ADE867C168D28B1F5876`),
	},
	{
		M:  internal.HB(`0D817AE149F978F3332473F4195C079AD2C83FB97AC08EFE6E7CEA466C4E2B1442405D40EC4F2C57951510B7551C5CFB23BBE5A8D8A45FBEAC0A171E1D943C599FEA51F200240090E7E9E430667A84E4DD7A1B144ABA54E34CCAB0A9C9A8AE1AA63A63136BF8AEA74D77AB6679308E6703358F2B7D370DC973879784DF79F53F`),
		Qx: internal.HI(`20CF5E473BAD0723EB2DE9AFCA766D01463657F245096C3310B2028CF82B35D10DC0CDD`),
		Qy: internal.HI(`5AF7A49F3EFCBF4D17E9860C9C2EEF59F93196F8C53761F229BF4F086051197724955B6`),
		R:  internal.HI(`4BEC02A84957DE78BD4A4AE32757AD3D00560E3AA2EA1DB9F0FC29B1`),
		S:  internal.HI(`0135633A1AF0A9FACD9A25D6A3B03C6B801AD2F9F555A94B78697AE06C50C0E7B5336B09`),
	},
	{
		M:  internal.HB(`E0D6E7E8A3B5BD4EF27E6C8641615041A5053947A8B8F47752F1F66F595E4B57DE4978DCA1AC78DF09A375E7FB996AD6D7E85AE98A433A9B1FA43E57B515B29B3B06FA85E895F65BCD755B096CCA422FB6C779B96844D6891B222A4CFDC6F7E8966B9A9F8193126B8268FD91DF4F08036873668711908B408CD3BB8BC101AAC8`),
		Qx: internal.HI(`12CFC116FA3D1E5B796892DA0F82157DC38CBEF0483864938DC7B6F9AA5DE4DDAC2095D`),
		Qy: internal.HI(`5AF4350115F5C9482830A5B7EABBFEF02E7F4DB8A780BAE59B61286F8085BD17F858576`),
		R:  internal.HI(`D50A02CE18D25C5D3129D30EDB6420CA1DBA533596801FA3D6EC0F0B`),
		S:  internal.HI(`6F4F5D27FDDBC6DF49D290079D9BBACF944A43ED759F969271961CE4F4610642037110`),
	},
}
