package eckcdsa

import (
	"testing"

	"github.com/RyuaNerin/go-krypto/internal"
)

func Test_Verify_B283_SHA256(t *testing.T) {
	testVerify(t, testCases_B283_SHA256, b283, hashSHA256)
}

var testCases_B283_SHA256 = []testCase{
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 암호알고리즘 검증기준 V3.0
	// 테스트 벡터
	// EC-KCDSA_(B-283)(SHA-256)_SGT.txt
	{
		M:  internal.HB(`C439EAD23515CDBEB0D422885F56C3C4A2AA642381E9B42C22E7DFD995F4F881BC454BF0933D2D27A0364694DEEDE441D74359D34A76F4C21B7A96BFCA986C9A5404DBA9B0842101B0DEB27CA026E1E557A9D23D12844578CDA33FA47E471ED9E0BA0FDE255F8BE94CC0C56778C7A72FEDC35707246BDAEB997ECEF0B92DCD3F`),
		Qx: internal.HI(`4E07308A29A8A7BDA2D480CDD250913E4E25C1CA37955DF945C7D2A8ABE1DC264D4AABB`),
		Qy: internal.HI(`243ABC47B4D916683147E41AE90D9F22E28C5FBB5015A04ABE2E1E467DE52A20BC5BBF7`),
		R:  internal.HI(`A862E492CB0D6D9ACFA3BF5FE9E02D7BD8FE35893F5B69FDC6E4EB8D126710B6`),
		S:  internal.HI(`01FF132443E5E43B243C6453BBA73D2A0D0C385E03A4091335066A472FCB7875EA85B30F`),
	},
	{
		M:  internal.HB(`9CF383FAF20AF481CC1C0501A15FC9A348C09A61374C93C3CC6C5C94E93CE0D5AC83FBEE818B8E756D76227DBF4482CF00197300660FF5AF95172C07E73068AD1B856436A3AD3378559EF098DC96B649948EE22139662D681070A94BF08A1CDFDF5ED3D49106644693A770966B3BF2AC6E26108C9AC911AB3EB265E7AC955B8E`),
		Qx: internal.HI(`30D8E4655C565D7E92B6777B65F0BD7BCC3D0687FD893866CCD14D866EFD7EA9BDD8F14`),
		Qy: internal.HI(`F0B687B73D728499D7F64E1E9B00A208623B92364073E2095BF1BE01D8FA9AEC6ABB2A`),
		R:  internal.HI(`80ED7193D72FF6200E87D44B07F0361DDEED9B69020EF36B1B53A4974C1FAD19`),
		S:  internal.HI(`024EB1FEC0B5E3486D99F1EF6B8BA86EFA1D2FFD946EEF5307DDBD1D387837EA614EB4B6`),
	},
	{
		M:  internal.HB(`D3B98451EBF34AA11CF1C74548E267A0DD304D90E0781E41095D1BED2A662DE1BB89DCC0BC98B755CE2145F7B502F2D119461302C87E7AF8443DADF3E2D5420C430C67BC74E3253570255F895EDA16F44346014076ABF3A9A863271BB187F14700C3DA67EC87B61EB033B560567000C66158E0317897FD31D928BA0CE0E63AD3`),
		Qx: internal.HI(`100780917D648FEDCDFE1734A92DD2BFE540E1B6747D67DD8426FA61CA59B7C377684BF`),
		Qy: internal.HI(`7421E23F3C6FA807DC3FB06990AB6AD74DB1C0779BD7E03115BBFBB408EEF62CF1954CD`),
		R:  internal.HI(`25E59CA6DFCA461419931F6D8ED78D821BA67946E9C13FF277CC0D9A186B8393`),
		S:  internal.HI(`C143C92D8C3BEA1580D382398624EFD2A841D8CAD809E3898A7338B0FE7B11B0712DFF`),
	},
	{
		M:  internal.HB(`6D7D126A650332F123C80C681794820E66EDA144C3A3B87A5E2FC1F81D24C4FAEE4B13F9899A0C9A48AB541686DC189827BC5D6EB4F8E771AC61BF967F3DDF0CD08A09CE685A5C0D85E9A364ECA6E53A67C5532E0F87F90E1BF05F2685F3826447DE492B7B17E64527D837D9FC1BB6D1CC4FED8A02090451EF56727217D24D63`),
		Qx: internal.HI(`325A21ED77F1F819AA555EDCBE8E011345C87731DFC45D6668EB46A6E406800F7F2A2EE`),
		Qy: internal.HI(`1A5B580A3A18C67F90174EF0A0924DAAE0A3562B4E88A0F85B0CC5168036667DBB10D1C`),
		R:  internal.HI(`952415F255382E0F29B6090A1DA670608E079059C9E1C4EEA1F2FCE2ABD16697`),
		S:  internal.HI(`02AC727BA985895BD99E24769B6DD1212CB8204596BCD249B33185F0710A857F5AD4CFC7`),
	},
	{
		M:  internal.HB(`6E3350DAA36E114566157780D328FE42E6EBBA112300C4415055F3C9842B88724ABCC32E2BC4F0185E88F3EDF385D77A2E7075D96DB1A0ED51F60604821A2202C7F56D01C1463CD2165C5F3D47AF07700500FC7F4630A56CEC8BF4833182B28CB8A344B581E8578F7D099B1522EFF81FB0FE592C7C5588DF03AF302E170E7992`),
		Qx: internal.HI(`759061C7C7DE06B7BA23E42018AE517395C169E4907688C3E58D6991116E38462C680DF`),
		Qy: internal.HI(`4F81F8F1E6F1CB1585071EEF4D9A07CD8795E8B1EBBA722B61122B8CCF07C7DD7AB4841`),
		R:  internal.HI(`D28F377275F9CBE7413B938E9EFDE7B5E0244CF44C62926A6E5E426F1C28761A`),
		S:  internal.HI(`01503B326C633C1E6563B75605853753289FFA1422A62C32F2396508A3BED43AB6F9B675`),
	},
	{
		M:  internal.HB(`DBD06335EA684A71684CAE9F4053BE8E621EBC8B43C1A86B61435475242F5D9ED2D110F2E64AC8A3952BC592C2B115CB32567ED538DC0941B7702451AF22EF402A41B8E8C5DB285AAAF3382835A860E920E720C860D85A979FA98A4377E866125805EE9942306ED0353B85278CA0AA06145949A929ADEFAE9BA79852A34DA1B4`),
		Qx: internal.HI(`77DB59DBE86D75CEE5EAA02847840EFB3C2966E9BA2DB23D8A55552F058D3D88E702872`),
		Qy: internal.HI(`20616D6D69885745834E068CB7636E16C0EB9617340428A03BA27887D9D05E9C9476F3C`),
		R:  internal.HI(`B56D86A6CEA2338A62BDB38770FDC214CF4197C290D25127751AB8FC3BC57D40`),
		S:  internal.HI(`0334FFBEF3DAF1571903BD9EAE0EE0149AAEBA5CDEA7E4E14C2F76224AC38146C1A98EED`),
	},
	{
		M:  internal.HB(`B6476F0E7C254249ADE052DB21C7A849DE7ACB47681CC7CC166D880FC1E428D28A7D20DAFE60F7106F096F17B714B4DD36639EF859AE87406144BF92CA072B1B00610D18B84D8578C222D2397A46D3F9BD73E39BA1B37C63B7BDC57C1CD9814929F86B6A02218FDDD4E29824FDE3B0DAFA53E2964F459C933AB34EF47E45A91D`),
		Qx: internal.HI(`180BD993F28472E702C1B871B0D72E74F39D417A51B8080266401F2E4C856B59232C292`),
		Qy: internal.HI(`313B249B669EC56048D33E1451323CC13F92DA1EFA96AE9F6EF4D7340DECF2C34B2062B`),
		R:  internal.HI(`2497DCF349C8604CD120CEE3B771A2F2F0F0F0BCAD65928D6BCDF3D3ED29D75B`),
		S:  internal.HI(`030548CC04029F4703E654DFB09354148C701FE7FC2634E79E7824CA39316BFAFF577B1C`),
	},
	{
		M:  internal.HB(`058D97FA9FDA5DA2BA470A463A3B9EC55DF30BD7D6458537F34834AC20FECC6276B5147AB83AE2327396959195639A073F89F8D5135A7CC0D5E47ADA987EB9E7494A9025DCD1B700E45DD083D93C46F5E096698E4DF76FA3BA3B4A41E509E7863171E0BD06F11D89DD727A20396BEEEE67E246883053F3616346F6276EA97621`),
		Qx: internal.HI(`40C58EB69CFBA65B0A81F80D77B274B4CB74BF5728B86509F488F332FDD089F0CCAB7B9`),
		Qy: internal.HI(`E1F02C1B1526416B17A0DF48D097952018A117AEA191BD6A3B6353B4CE05CF751A606C`),
		R:  internal.HI(`E9C5A380AFC2D19237D643E807187C4BC4BAAF1844B62DCC0FD861AC0E1CD49B`),
		S:  internal.HI(`6F4E7AE5C473C02DED5B7FC53B2FBA87866C67FEDCE9B845B1E1046CE0DB7CE6184F50`),
	},
	{
		M:  internal.HB(`CB96008C97B9FE4E12F378F550608656E57CA0D1D06F46817C46FA5E03302DA29A6C1265570DECDD2245DB142152A99B51BDB000AC154E9396C6F93EDB3B7DF80CEF66A2779921C79417D71C173E9B318C44D633A8D6972C2A98BBA6942B7C1E7363702591D37DA8D45ECD2F05ED47975EF99A11100958EE9CD43500362CEB14`),
		Qx: internal.HI(`3EB42B12A42D36BCFE7A319DA071CB7546FCE51128904A91E7D914D80273C6B06242ED9`),
		Qy: internal.HI(`435C5C907A0CBB2D507D08AD48A2D13C6555FA4CE8E6FCEBC393F4623BFAB62AC1AB41E`),
		R:  internal.HI(`6E5EE3D2F7F69DEA0778DDB1DE81FBFD89675E47AD034A4A1204CDAD9B93256C`),
		S:  internal.HI(`01580700451049CD488558FED3B8C6ABFA3C7D47943C6614CA42BC724A7A144299EC80D0`),
	},
	{
		M:  internal.HB(`0C55CC59A6F88A233A5841FB27ED4251770BAEC79CD06E7E35DD803B303030E5FB963E301F0B7BE5038BE4B41F94C6ED6FF3EA0D66135F8D275EE0D158F25CA24C45B324CDDB279F55C58B16F801B700C6714E20F58458D28C46BEC0EFF52563F3C34037E8FB120E3E1B3565251CA128E48C03C7359B2F0C67D1AE929A83EC4A`),
		Qx: internal.HI(`C6EC114D8261BCDE724474B2F84CD30F4A24121AED4BA3CE92B1F2B9EAA5A3BE967BC4`),
		Qy: internal.HI(`4EF96DFC4B0F4E6FE9487A2C3E731116CCD6DA860CA7A7E0485512C811B3782AF9DE63A`),
		R:  internal.HI(`E85AFEDEED226EEDB5E1E71D3D599323F1D64D6AAADBAED3FC01C2918B9D446B`),
		S:  internal.HI(`01788579303DFA3115E10BC29A0E7FE0FBC0882BD18BC3400C941EDDB0722961EF5DC548`),
	},
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 암호알고리즘 검증기준 V3.0
	// 테스트 벡터
	// EC-KCDSA_(B-283)(SHA-256)_SVT.txt
	{
		M:  internal.HB(`0C2BCF178A17E14AEB59FA30284BBD5B9B3AB74009E212BE374F193AB227699FEEF3450B6063EA6BCB1256D257E35AD79D7171B85D96388FF5A6EE694B4DF77850A7A631C39D619F5CFA60AF07610DBE5A875D33EADA0467A60707B2E87075CD5A19BF665B13992A14EFC400D03DADCDDBA2478378900FBF242095C2C51C7D0F`),
		Qx: internal.HI(`3D44ED76EE76ED5D1A497245A7CDE60592E46045CF40F4A695B8712396C8480AB778321`),
		Qy: internal.HI(`54A2D52828021AE3C1348CE909F826949E5EE3FA6C9527A72C2D359635656816A0A8284`),
		R:  internal.HI(`092034A166C88F805B78A05C9BE4378A7F5221FF7AAFF6D0D75AB1C4DE3248FD`),
		S:  internal.HI(`039C8CD557A83EB3BA7A4CE3B3D199D402027FC7EE0E6E7A744290844C4CE9F233B3A15B`),
	},
	{
		M:    internal.HB(`C16271153C70B6317339E391179728F08F09641BC37A75124AD02C65073317DBC16A0027B64958BBB27C6273B8B25D33C581752BA6EDD0DB83FB6C940B3F2684E3BCA70E481188807F516DE5116C61056097434A939880B2735FE7672FD5E5389941E790E03C2C175687DB9F3BBC908D263A3E630C339A926A4DE8389EAE6601`),
		Qx:   internal.HI(`0F6A0B9A98BE119475988E3F6F3C2626D7E2F214728E271287BB099B94F0221331A15D2`),
		Qy:   internal.HI(`72C8CA27917115D1C3E778AC320AC45EDF120F1129B3C2C7F10B4D877F9FC686592470A`),
		R:    internal.HI(`2B7C937FCE80D23B1587D78FB5A9FFB6641EC3096037DA5E3B533CAE9D30EED8`),
		S:    internal.HI(`0382BAF0B6A56A0E3109A8CDD8445677F88E55D2074A3C6ACDDB0210C6E5125C71EC4F90`),
		Fail: true,
	},
	{
		M:    internal.HB(`4AB5F2C8FD93ABF67CCF4C8BEC38368190DD2275B4016A7555A67E418F03B479179A13D9C7484EED8C0B8B5AB2D1223FE20600B0D043D0DCEACC92DD0732D2C267EA18D60105C3AE79F3F805A980C3EF2CDB1D6BC6F3FAD723EC075EBBFA40CB666106EE62EDE1F6519F8CE509E581979D0FA166906623F58F947A2EA6AC4BEE`),
		Qx:   internal.HI(`0DBD79CB65D09F28B29BFA4A95D7EC318AB14ECF44170CCD9F095658A1C84F9C579614A`),
		Qy:   internal.HI(`676D60E1E9C61010A68A8D863091DFE2AAFC32C198399462CA5F4D7B8A20BA09DAACB0D`),
		R:    internal.HI(`8A20FE3C0DE934ACEC4A646344CB0B39F9861C782114A6CA1D5B9772A1E96E39`),
		S:    internal.HI(`020427A3612DEDA4C657927100EB56E44ACD17ACBBEAA7D2BBDD011D141F1EC34838716D`),
		Fail: true,
	},
	{
		M:    internal.HB(`7FDF48523A66D54E31436A9D53FA16CA5EB2ABFE789D2FD1598EB9D15DE648203F829320C6D7677E2FD38BA293C3C1CA22D3E3D86753A825687A1249F0AC1C43BA19A0E1D3B001D7F82FAD6A3367EB1B83600F2EDB859186328512B00409DD90EDE7DB8BC4089EA5E691686E1090D92F73C3303A6BACBAC6848D68402B892379`),
		Qx:   internal.HI(`7BAEB5C13B2C807302D10D4540A2FCDFB8BA09DA6A86720D1999F2D86CC5EAFBB39A058`),
		Qy:   internal.HI(`6C61F01284D99BC2E6BDA78104E72CBB6A4F151F85A913F2D21EC2266E64DDC73114271`),
		R:    internal.HI(`905C05DC036F0BCDE42D347EC02EF69D9FB33F1F09DBB3DAE7EA3239D72C955F`),
		S:    internal.HI(`0335C537334E54B3D6ED507F885424952EC62B84C591F3EBFD9E91F94433FAEC45559A93`),
		Fail: true,
	},
	{
		M:  internal.HB(`7ADA0ECB03304C2A17D64A99DC7057076B86FAFC4C95E564348F9944104D260D1504F4F3F541F2EDEB6D22C5B76CD8EA4260A55A07044B61EBC7A67FB210F037B1C45014E6970A9C2A2950999373065BB4A07056F3C029D9816D532332EC5EABD4C757D12D6D22D04EE28B32590B908B6B8CD2C7CCD890D9126B1C035CBB238E`),
		Qx: internal.HI(`7305322DA016BB55BAE2E18D8B0398F31515971673659F1D8A8CFEDC6324E652B5D641F`),
		Qy: internal.HI(`54DA9D674D03ED1ADE4E744695BF3350683D5D68BAFC0B7C9D4559489AF351C16D7EB67`),
		R:  internal.HI(`F4E10E1D58356366A7B97F17E6B6C6B7E0D9CBD14EF52AD71FFEB1D0BC9D0B7A`),
		S:  internal.HI(`022E329CE49C8B5935ECDB3AD6DA5C78A02685A853B1C1F34AD14E29F43A3F3838F4EAC7`),
	},
	{
		M:    internal.HB(`E5C535E8A5CF0A159A1216BB612E94598CCDEC13049A5501D70256C4FEFAEE2D1CDEB4FECCAFB08779AA31314BA079B633E86C14A3692AFAED90BEC8DEA7C1D7926F291F166613F4D0A2D9FD46AB23073C3456E2BD241BF112D8458D2DF5E6F097CCD6C05DA26CF317D1CA26782064138A4921570200D321D2755A0066B72364`),
		Qx:   internal.HI(`2CF494D86212FD99B7B58CDD4C3280F2BE345C11D7EAA52436CDFA85661B8344F1390F9`),
		Qy:   internal.HI(`786E956F0EEBBCBF9D404492D330D6035D151BE605CB04D484F0A82E3F609002D975470`),
		R:    internal.HI(`151B4E3400DC969432F051E7BFA4A13CFF054454A5EB1633DC0A57188F25614C`),
		S:    internal.HI(`FFF03C176BB6DB020772347DEEDA984F553629A8221122D908ECF77F2F8DF334A493BC`),
		Fail: true,
	},
	{
		M:  internal.HB(`482263957FA1FEF4661957BE23B49BFA7EFE07CAFE2254D6C00D6FB06837403B17628991D112A37F2F062D0ED47E5D3889941B365D6A8782C0831E15F9001EDBE1104FED4661E1A6EAC87EFD7AFE404D67ACB2F8138E76022D00D316A7ABB81D39B06DC3CA069021AF5C93EF23464E5AF0FDE602937B9E21E034BC6D833E3DB8`),
		Qx: internal.HI(`510F542A60B1ECE8F3724E57BE502AF934E39B91C58DE783660D82FE6A0D175DC973C8A`),
		Qy: internal.HI(`02A4D39E5E1584E3C299097009B787D3E35D5C560FFAE2A2CDFE8E26FB38BADC400EE7E`),
		R:  internal.HI(`CFC18A3315CA63A53883BAA86668B3B18944EF8A5F8EC1EFE7920CA2BF4DCDF2`),
		S:  internal.HI(`D11FECDD4087B35490CE1F37E046B45BB131F35FF4A0F90FA5328BF41B5D7C84B41A36`),
	},
	{
		M:  internal.HB(`2B61D75461D1D11A277DF2E94FD8AB86A89CEB5505C1D53D39CE7AA9A7238B8ED67294DFB90BBF53F615BBE9FD78B20F327CF1DBE8ED392E90C5473DBC269D5C6BAF0E723FED1C08FEFCA94B19100AFE8AFBFEAEC8749324212686693B4D1B590DEE011A0C703F6FDD9BC03F56C975490953A06031F3501B3E3F9162CBE65DC2`),
		Qx: internal.HI(`37101388C3A3263226398B12CCFBC6FFA03BED84CA32146A5887EC592E5B8FCD253293D`),
		Qy: internal.HI(`442F3F455EEAE6741BB9DAFF0B1AEB0AF7069B471AD241559930684C5A8CF8845725A7F`),
		R:  internal.HI(`6A49933CA812038B48E563B6F16A6280405C8C6743BA81B91BE935AE0073AC66`),
		S:  internal.HI(`03463005E26C9CEAD6CCAB6DE9251BDB763B648C3AA70E4EB58F1D8BAF68926DA60DC6A9`),
	},
	{
		M:  internal.HB(`CFCFEC1ED3A9469722AFFB4C17DE716C870E8A974C0394A0236962F986E15C0EB986065F9F04D49A8BCABF7FB1577FDC612ACD56AD699A68B0B7AC3C0B4E72BAD9D88C9DA21FE6BA9510D3599B1B03E67579D2B38967BF208ACE8DF09C72DA102720AC92F5F3D534CA26852B1E8C15821D2C4BD89C091EB71EA6575EA643EE3B`),
		Qx: internal.HI(`3D04BE94F32584E5C2F1DBAF082FD0829FE0C2BC8F78A8E582AE7E23A1422202F9D2B3F`),
		Qy: internal.HI(`48CA2EC323B8B6872E67085598949233637F37384EFCE8A68E4E7E6384735F5BDB1E8F2`),
		R:  internal.HI(`A32322F924C0C6C9AB725E3BB5F28873B1DC4F7EA64CC2A289D7315310B144D5`),
		S:  internal.HI(`0233FB919D12413C6A422F084C60F75D8B6D5812905D73D27775E366DF519756B22091A8`),
	},
	{
		M:  internal.HB(`639CDEF8A17CAE7B592E2FCC3555107D1AF1DBE9845987A2E266B2DEE194CD114C990753714435C19F2B887EC9ED567EC285B7BD35995211CA1C03439239C2822EE77FF4D31A3E7B96E64057228B83D44DD151AAA092403151E64E1AC4CF7DCC06D59E156175A55483CC49C043692EFA8AA6748E717EE28F10367AF10ED4C8CE`),
		Qx: internal.HI(`591F1C7B70826902652A8970EEB075802D191EE032391134B81B5A8004361B05771F00E`),
		Qy: internal.HI(`56235F18F5EFAD0F4545892F878D110BDAAB01077477883389B26EEE4100955C65D7480`),
		R:  internal.HI(`E383E5FC7D5284F02F92CF94B503061D41DC61CE18F2CB47BBE1B3138F01C6BF`),
		S:  internal.HI(`02FC155AC755C5CBEF5F90E59498A50441E382FECCA862A46BDC847E4C3DDED43507DF4B`),
	},
	{
		M:    internal.HB(`B7A334DB52B0BC54557C6B56465632F0DDD58B7D1F317F4889559F2F4CD82ECAECB61B29390CEB9F019C52AE6B64879F580F0EC1BF8F1EE46095400CC3465DF6D8E8D75C37CEE3A05753B7C5A924CC5F00A8CB6230C5517448D83BB64D178F95E831C2ADE3746C3DE633233E57CF9C9EC609BCABCE03C532D4A43D6187B5C5EB`),
		Qx:   internal.HI(`48E481261B70051685A336CB72298D153791E60871A4CC9782916DD925C654962405AEF`),
		Qy:   internal.HI(`59A25EFBED3CA8492885B2C2D53027E6587A39FBBB059674B006C8CE98DB5CAFC5E501C`),
		R:    internal.HI(`2D105C6B17346E61F0A61B0A8EA426E765230549A597BCF28AB24194D669AC55`),
		S:    internal.HI(`0239BC32DD18AE4AB94AE300A54B8CBBF6047342D6915F0B190D75C711381C3CE8DE06E5`),
		Fail: true,
	},
}
