package aria

import (
	"testing"

	. "github.com/RyuaNerin/go-krypto/testingutil"
)

func Test_ARIA128_Encrypt(t *testing.T) { BTE(t, BIW(NewCipher), CE, testCases128, false) }
func Test_ARIA128_Decrypt(t *testing.T) { BTD(t, BIW(NewCipher), CD, testCases128, false) }

// 암호알고리즘 검증기준 V3.0
// 테스트 벡터
// ARIA128(ECB)KAT.txt
var testCases128 = []BlockTestCase{
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `80000000000000000000000000000000`,
		Secure: `92E51E737DABB6BFD0EABC8D32224F77`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `C0000000000000000000000000000000`,
		Secure: `E9515AF69763E19B4FBCA0D7034CCE63`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `E0000000000000000000000000000000`,
		Secure: `44765262352E389BB0307BFEA5BC7805`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `F0000000000000000000000000000000`,
		Secure: `891CA8815D2A8E6314665AC4E8559724`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `F8000000000000000000000000000000`,
		Secure: `A0A51301A065BE26EDB1DF1273DD3A6B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FC000000000000000000000000000000`,
		Secure: `CFD53E940C554436A38121FF4B707A01`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FE000000000000000000000000000000`,
		Secure: `029A6A1975299401E35DD5E7B137C396`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FF000000000000000000000000000000`,
		Secure: `8BD17C1DBA030815EB581933F338B813`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FF800000000000000000000000000000`,
		Secure: `4670627DB7CA03A41A32016E6551FF9D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFC00000000000000000000000000000`,
		Secure: `3A621F83D8FF3B056A2251392DF9EB0D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFE00000000000000000000000000000`,
		Secure: `9E218C0879D127C898015C4945E9BCDC`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFF00000000000000000000000000000`,
		Secure: `4C0B68E37400F899C14C4967EA8CDDF3`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFF80000000000000000000000000000`,
		Secure: `11A520A1D1ABC7EA4A37268D522E0B26`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFC0000000000000000000000000000`,
		Secure: `FED1DF2FBACEA8DD1C7DFD61B384A538`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFE0000000000000000000000000000`,
		Secure: `17B9A4FF71CA553CA3017D551FBE38E3`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFF0000000000000000000000000000`,
		Secure: `E545A7D97E58407C8EEC8C33BCFB1469`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFF8000000000000000000000000000`,
		Secure: `EFAC5DE1716B44FB9A821709C155AC06`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFC000000000000000000000000000`,
		Secure: `75D024B0FE4254E3C659286A2B6C0832`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFE000000000000000000000000000`,
		Secure: `1770C2C4A6CE426404AAE2B9030764BB`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFF000000000000000000000000000`,
		Secure: `EBB178064F506B8D784C9F045EA8EE04`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFF800000000000000000000000000`,
		Secure: `8F0191416805A13BAA049976D27EDA92`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFC00000000000000000000000000`,
		Secure: `BF3B42765654ABE0B56A08B4264DE8AD`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFE00000000000000000000000000`,
		Secure: `72E25CD2D13714B0D99C1576AF7476C3`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFF00000000000000000000000000`,
		Secure: `A943B64FBCAAB761E1253ACDC0D0AF4B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFF80000000000000000000000000`,
		Secure: `A1B2D6F70C7E81151125A5560457D383`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFC0000000000000000000000000`,
		Secure: `962FC72EF992123E084F4E15DD5D194D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFE0000000000000000000000000`,
		Secure: `3602816E412DF5266DABF7EBB6834A37`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFF0000000000000000000000000`,
		Secure: `76BC8563839EB138A62E4AD0374571C0`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFF8000000000000000000000000`,
		Secure: `7B8C4F0B163E71EE4A25FC838FAC7A42`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFC000000000000000000000000`,
		Secure: `B02688D4505E847DF4F844A2FA49414B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFE000000000000000000000000`,
		Secure: `F75B9773E50739DDD43B9D5150B39AF0`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFF000000000000000000000000`,
		Secure: `C80BE5AFC9F2D741896772FE59B75A1C`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFF800000000000000000000000`,
		Secure: `A13D640ECC12081D7FDDAA190E4934CC`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFC00000000000000000000000`,
		Secure: `547CCFF1DF38F3E1227E2BF535E8A4A0`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFE00000000000000000000000`,
		Secure: `19DA112A28F743840A3BC05BE47EC786`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFF00000000000000000000000`,
		Secure: `8922F5685BF9885692DA9FDBA7EEE158`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFF80000000000000000000000`,
		Secure: `E902A002EDFD231BB434F0E2DB808758`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFC0000000000000000000000`,
		Secure: `331A6B3C149A1E8D1E2633BD3CF72AE9`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFE0000000000000000000000`,
		Secure: `EEBD0D19906CB8781A28A7223B1B166A`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFF0000000000000000000000`,
		Secure: `F157D5DB3FEA75889D54722CF416BED6`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFF8000000000000000000000`,
		Secure: `ED9850F5EA7E5566C657ABBE28836314`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFC000000000000000000000`,
		Secure: `1F079167239258374B511614401625E1`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFE000000000000000000000`,
		Secure: `AA1C6B7FEAC4408DE1B9D63DA99703C3`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFF000000000000000000000`,
		Secure: `EEB815F36F9DD064A1023E9C190EB590`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFF800000000000000000000`,
		Secure: `678BBEDA7EAEF695901382209ED31AA3`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFC00000000000000000000`,
		Secure: `590C7058A1FAD113404F2B84B1D78511`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFE00000000000000000000`,
		Secure: `85B124D08CBEE63E4146BEE98D26A824`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFF00000000000000000000`,
		Secure: `20F79BEF7DF57648868C0ABE2C7E1FC5`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFF80000000000000000000`,
		Secure: `0CEFF4FE5B0C5E7CF154608CCFC79D0D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFC0000000000000000000`,
		Secure: `24671B3BC96B7F8BC360795F3BBD1400`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFE0000000000000000000`,
		Secure: `EDED9643017C945F9AA684E0D9E3B71D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFF0000000000000000000`,
		Secure: `6F50B32291FD4D19994AF84F6ECB8290`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFF8000000000000000000`,
		Secure: `512063D9AFFB7B6F7DB5F42B85D93D92`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFC000000000000000000`,
		Secure: `2814464502025AC7278772679BCFAE5E`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFE000000000000000000`,
		Secure: `3EBE415F83194FA8EA2C51030C715CA7`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFF000000000000000000`,
		Secure: `74C080D400FA2E09808E169CE623AD0D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFF800000000000000000`,
		Secure: `856DF41225EB0F86929A3705412208E9`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFC00000000000000000`,
		Secure: `D323706445D5E086DFE7BB6CBF3AB733`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFE00000000000000000`,
		Secure: `540CD41A5B9AF8C6EC73A85ED2B576AB`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFF00000000000000000`,
		Secure: `4F186E88552CF4E08A6157C18261BF0F`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFF80000000000000000`,
		Secure: `EE21E605F99BC00A783714F92A85F2E9`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFC0000000000000000`,
		Secure: `E434D265AF38C2D08EF7E97BC3000201`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFE0000000000000000`,
		Secure: `69CB09AF513E5DB71CFF81EAA284D230`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFF0000000000000000`,
		Secure: `3CEA88898433B9A51AD4955B1BA98078`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFF8000000000000000`,
		Secure: `3C5A01FA83BD62EA796EA867C4BA13ED`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFC000000000000000`,
		Secure: `1B3C24369569A47559FF88BA04BE2BBC`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFE000000000000000`,
		Secure: `0123C51EC49BD004B5CF3997C2A1F4DA`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFF000000000000000`,
		Secure: `BFEC690F87D143B04C77FAC7203AEB58`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFF800000000000000`,
		Secure: `FB9779B65FDF8E2867A57A5979B15357`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFC00000000000000`,
		Secure: `7E9A9DAF95722D3BFD2F18C275D4FDDB`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFE00000000000000`,
		Secure: `0A53B303C4363F792698E00D772F209F`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFF00000000000000`,
		Secure: `66C00D748CCE27A94F13C84770CB238B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFF80000000000000`,
		Secure: `8AD906722515DDA423AF1F1F87FAE132`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFC0000000000000`,
		Secure: `2285FB8CBFEAC963CC40629B3499B2ED`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFE0000000000000`,
		Secure: `A82A21AF65F86EDAC5C430BEDD674107`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFF0000000000000`,
		Secure: `5B71D540DE0919ED9685B7AC4375E6CB`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFF8000000000000`,
		Secure: `1C980494C5CF88EB421BD2C795932981`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFC000000000000`,
		Secure: `A46013E36A8E2E04E941A0A163AEAB50`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFE000000000000`,
		Secure: `A7BFBA4FE0AF24DADA2ABB61F2A78A31`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFF000000000000`,
		Secure: `5D92C91CE63657B3930D0F2CA52E9133`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFF800000000000`,
		Secure: `DD8A1885B9B68D563DC75A391100F993`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFC00000000000`,
		Secure: `237FC03B4F28CFD12330440DA4096176`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFE00000000000`,
		Secure: `893FA4B6439C76AEB453467216AA896A`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFF00000000000`,
		Secure: `613927300E633FDAFDA030D832BB0ED5`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFF80000000000`,
		Secure: `574B767BD22116B384C69D238769064D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFC0000000000`,
		Secure: `4C1C59CF77A482C1A3A869E406F20E27`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFE0000000000`,
		Secure: `7B6C1FC2C06A4CE8BAEA98D0A1E23C16`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFF0000000000`,
		Secure: `98162A6250C2D8CD522D86E8D2BAF87F`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFF8000000000`,
		Secure: `F1B49E6BB1A49AEFB51E22CDA5BB5B4A`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFC000000000`,
		Secure: `CCC2B4141AF28FD9A34AEA918F082761`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFE000000000`,
		Secure: `F80E7720DA3A23447065861F6EB65FF2`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFF000000000`,
		Secure: `8AB6F1DA1F21CA7EBB875F4E11596B81`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFF800000000`,
		Secure: `6C6E4B184320E9B3028145063B4D4E12`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFC00000000`,
		Secure: `DAD54DD193291CE5CB1D626DCD4D5439`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFE00000000`,
		Secure: `5E69CCAF969ED304DD43FAD5AD63CB51`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFF00000000`,
		Secure: `4BE1CC8BE097EDD87E5F692EF1EEC0EC`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFF80000000`,
		Secure: `73A0AFDD60431D570072A18FD9EF0493`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFC0000000`,
		Secure: `9BE6B8CDD151450D3FD4EB53D51E4561`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFE0000000`,
		Secure: `8FE01DE387DAE078EDC9D1CB11C6C983`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFF0000000`,
		Secure: `63EBDEC377DF4BB368DF4CCA4C1E172D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFF8000000`,
		Secure: `BF0EFAF2899D565AEE7668C6A22F54F0`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFC000000`,
		Secure: `8B2460101357EFAE9C10AC3AE52357DF`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFE000000`,
		Secure: `B937B57A46B3E78FFBAA749B69A42BA6`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFF000000`,
		Secure: `E5B8DA7A12EAC9640114C76BB50DCF84`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFF800000`,
		Secure: `9A9243213188AA6CF5E67453D244470B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFC00000`,
		Secure: `27194B0D0D23DAFBE5DF05383630201D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFE00000`,
		Secure: `BC557D86A402054E4726B7B618DBCE6E`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFF00000`,
		Secure: `7BE2424404BDFF199ED0F1CA7C688021`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFF80000`,
		Secure: `3B3FA447D6A386D52AB0554C6134A48D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFC0000`,
		Secure: `7F6AC240046EBC3ABAF9DC429B10032A`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFE0000`,
		Secure: `3E353F6AFAD644E972631846489BC2BD`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000`,
		Secure: `C47E26E4E51B17384F0C3BC77702D9B9`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFF8000`,
		Secure: `FEA05F46244CDC31025E790A9C4F5AA5`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFC000`,
		Secure: `36BE5A306DAD6BFD61A24B6DC6F58294`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFE000`,
		Secure: `8FA61B88F072E1B66B1E892990D80D1D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF000`,
		Secure: `D30CFAC15BEB520967404B64B55D6964`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF800`,
		Secure: `F10DB1A893801A3B7135B4E975EC9E80`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00`,
		Secure: `C22782F687D0052DB80D47ADFAFC8CA8`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00`,
		Secure: `4ED1341F9D2A200F493AAC24EB65455D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00`,
		Secure: `A80C57D178D7DB362FE4C7979004A874`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80`,
		Secure: `9FBF916173E275C4F9DF3E85DF0C5E5F`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0`,
		Secure: `7E0C9E6732BA3FD65A5A794DB972B7A4`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0`,
		Secure: `A628828E0E1BA81BEE663DDAB11F89A5`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0`,
		Secure: `3431DAEDD9655726BE9350A1FBBAD201`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8`,
		Secure: `2290C37164AE77602551D96482536121`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC`,
		Secure: `E5CE4BFB82C1770EE794A0597CE94419`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE`,
		Secure: `79657F04E1C8960083885CD1BFBEB5B4`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF`,
		Secure: `9184211622C2BE38CBE0957C12363D96`,
	},
	{
		Key:    `80000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4ABA3055788204D82F4539D81BC9384B`,
	},
	{
		Key:    `C0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3E96654A75D69E6EA756C330A92B9D41`,
	},
	{
		Key:    `E0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0FDFB82E9EA8EA5A0C5761F76870A83E`,
	},
	{
		Key:    `F0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DD1B1531C7A9AA1CA70CE44C426D3CCD`,
	},
	{
		Key:    `F8000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0B08D53ECF496F2726136FF63FBF9CE0`,
	},
	{
		Key:    `FC000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C09BBCFF7CEA4C470CDDB92027770F59`,
	},
	{
		Key:    `FE000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BF9832EED35714119CA22122BEB2EAA9`,
	},
	{
		Key:    `FF000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2CB1FE2F807CEC3D4AACA2BCC7C62471`,
	},
	{
		Key:    `FF800000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FB145038D4951843DF5ECCD921246ADA`,
	},
	{
		Key:    `FFC00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9EC4AFE7DCEFD41E086B6D4F8EE7A623`,
	},
	{
		Key:    `FFE00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4E142DBC0CB7167120A6C16D1489A6A8`,
	},
	{
		Key:    `FFF00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AEF352DDE94AE0A1C68AF793E93A4C1A`,
	},
	{
		Key:    `FFF80000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `79B374D074C70AB74E94960B558BAB40`,
	},
	{
		Key:    `FFFC0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B06BB21B28B803C8EF2D694740E85CF2`,
	},
	{
		Key:    `FFFE0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `60856A06273DD1C082DC3AA7BD5FE0E2`,
	},
	{
		Key:    `FFFF0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B2F382DC194DF23C33FEEF5E3B2898B2`,
	},
	{
		Key:    `FFFF8000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `260368589B8FD57EE5FEC418DF98084B`,
	},
	{
		Key:    `FFFFC000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CBF42989E91FF54F80787B1DD8BB2367`,
	},
	{
		Key:    `FFFFE000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EE5AFEA1A8E13AD1E1AC5A5C977BC6E6`,
	},
	{
		Key:    `FFFFF000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `21446EF6A32290CFF1B460B55814BE76`,
	},
	{
		Key:    `FFFFF800000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9F560CE56E2039BBA0E4AF5604608419`,
	},
	{
		Key:    `FFFFFC00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DCEE50827A41D9A9F94A66F614472756`,
	},
	{
		Key:    `FFFFFE00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3FF673EECF3FE8888699815E557C85C6`,
	},
	{
		Key:    `FFFFFF00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5097B5016000E3BFBA840F10C9228F51`,
	},
	{
		Key:    `FFFFFF80000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `740F5278BC0CEF9DA040C1D1FF2B1215`,
	},
	{
		Key:    `FFFFFFC0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A1B471668D3C9994B4F475F6A02DB283`,
	},
	{
		Key:    `FFFFFFE0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0A59B505E42ECC27FADF6773419C644F`,
	},
	{
		Key:    `FFFFFFF0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0D515D601395E180E38FCB798B0670A1`,
	},
	{
		Key:    `FFFFFFF8000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `00FBC6FBA94BFE2528FE0A99FA042693`,
	},
	{
		Key:    `FFFFFFFC000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7C9211C2E53C71F076AC09143BCA3678`,
	},
	{
		Key:    `FFFFFFFE000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7EFF4DBA488D6D6D39A3E76B0488A0B5`,
	},
	{
		Key:    `FFFFFFFF000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D1FFBD125B550389B0832D8100B9274A`,
	},
	{
		Key:    `FFFFFFFF800000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F0F7B0847976DF48FBDE0D31D30A9AFE`,
	},
	{
		Key:    `FFFFFFFFC00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1F10A2336B86F947B303BC7CB5FFAD32`,
	},
	{
		Key:    `FFFFFFFFE00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CD7847C19E42C3FBE837787143E4A0EC`,
	},
	{
		Key:    `FFFFFFFFF00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9D1738BB51746289F73AA4BC8168B1EF`,
	},
	{
		Key:    `FFFFFFFFF80000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7A4305AEF5DBBE17A01375515F5702EA`,
	},
	{
		Key:    `FFFFFFFFFC0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `087ABABE17B432753E6EB3DE0994CCEA`,
	},
	{
		Key:    `FFFFFFFFFE0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3F5CE42A4FA3D4C8BE0BFDCBC3E79831`,
	},
	{
		Key:    `FFFFFFFFFF0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3E49A6381C690918666D832C51EB206A`,
	},
	{
		Key:    `FFFFFFFFFF8000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0CC49AD159B3947E62FFB11EE409C4F2`,
	},
	{
		Key:    `FFFFFFFFFFC000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D1727B2C9FD7686C73C8054BE726E8E4`,
	},
	{
		Key:    `FFFFFFFFFFE000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9EC6EA226E5D64354D5F5E49DDF1F0CA`,
	},
	{
		Key:    `FFFFFFFFFFF000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7499AFB93029F108AE9E7C6E436D18A0`,
	},
	{
		Key:    `FFFFFFFFFFF800000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `393D0D05DD819233D497ABED82460925`,
	},
	{
		Key:    `FFFFFFFFFFFC00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8A5D1BBF1FDC5C792677EC6978F1F908`,
	},
	{
		Key:    `FFFFFFFFFFFE00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C4EB1D95564BCFED54B28AE03474CA69`,
	},
	{
		Key:    `FFFFFFFFFFFF00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5145E3920783A82F7D8D862E1FB6C7C2`,
	},
	{
		Key:    `FFFFFFFFFFFF80000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0DC8ADEE25106109F6B4492089A02653`,
	},
	{
		Key:    `FFFFFFFFFFFFC0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BC3D0DACD271E35850E60BD406AEE318`,
	},
	{
		Key:    `FFFFFFFFFFFFE0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1FA8AD80615352619F3F58EC0C080C26`,
	},
	{
		Key:    `FFFFFFFFFFFFF0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B21C77354937134BCA95812F306CBB24`,
	},
	{
		Key:    `FFFFFFFFFFFFF8000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `858BBBD76DB7DACEC62221B9307D54AE`,
	},
	{
		Key:    `FFFFFFFFFFFFFC000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0E60B7D6EF0227CAB9E0F78D53093544`,
	},
	{
		Key:    `FFFFFFFFFFFFFE000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FB7FACF2E3CE0A876D64575E768FB42E`,
	},
	{
		Key:    `FFFFFFFFFFFFFF000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6E30A03D0D367C489EA538065B0E49C9`,
	},
	{
		Key:    `FFFFFFFFFFFFFF800000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3F45694731DA8FE9F744BAF949036120`,
	},
	{
		Key:    `FFFFFFFFFFFFFFC00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `918CDE7607246AD2472B78A21031A261`,
	},
	{
		Key:    `FFFFFFFFFFFFFFE00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D02C822E3F9E2976DF46E622BBBBCFCD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFF00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `07C17615E10A4AEF346403DB12B76AD2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFF80000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `12B076B45BDF85C57A9E558B2EED39C4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFC0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `91FCE24D047D76F44EC123C07848E51C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFE0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5F58C79A0EAF7E9DD708D191A2C23769`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFF0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `00959F8E9B10D3D4A855E060B44F4FFD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFF8000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3A231250A144CFF9A1F2B613A53E4C1D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFC000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0EBAFA847FAE08E23EA1F313A2D47328`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFE000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BDB65848B72DD2970AE215DE02BA1FAF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFF000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `445C3446F036F2B8A6C92005CF21234C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFF800000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `61909F897F2478F7EBE1810F52488CA3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFC00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BF4EE9D0376D8ADBB81B8F1B722F5663`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFE00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7CBD5515C682E21D3E831FF0962A83B1`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFF00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `379B98AC834710AD8F7751EF04F984D8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFF80000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0AE630FE3E3D68C73E5DE140085EEA20`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFC0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F522D5546186A0AD395CAFE9A002B562`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFE0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B0043A3DA36126D5E182B48DB341319D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFF0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `59E23FC825656A88DE210E8BEA8A5F92`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFF8000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `723CECAD4DEB7CA86C7E84ECE42A2A60`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFC000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `04C912077BA38D180BD24E271A22F060`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFE000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `63BC4530E1AF012549F7954BFF8929B4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFF000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `12376C684E261AF6FD64D967636D8A9D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFF800000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B46162C5ABB2B51556D3D11EFA7F396D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFC00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9A5211A9F4CC23BB5E326C2E38AD29E0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFE00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5E0033CD14595A8BFF417556C4166D33`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFF00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `604C9090192A350596BC6B2D33162CDF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFF80000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0B2EACF9B8659A81F1A593C0C0027B41`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFC0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `02AAEFBFC1B9D4D23CFD28428BBE352B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFE0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DB602BEAF3A95690EA4292FD6191C0F8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFF0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D5410EC4737DAC33C1341061DBB26335`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFF8000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6D9D31C7DBE99F597294800CD9756672`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFC000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E416F36986CC0E5CB5A3CCDBCB3D660D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFE000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `503F3FA66940D85FD4F0AF9D6BD63823`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFF000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5BC8BED17980F1CD778CA3E8307B2B0F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFF800000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8A264D3C73C1AD0F3270408630C271AD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFC00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D5BAB0ACADA6A72EC04B8F5F9A07F6C5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFE00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E5DE8BC11B0CF9A765E941CDECF87FE9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFF00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9A9EEC5DC53087AC23033AC7ED4DC883`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFF80000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `33B9A415A82DA183847F69961E152EE2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFC0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D540FCC9201513519644D0CC1B07C619`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFE0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9E88106B9C3DFEDDFBA8E4F05D696F66`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFF0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `37CC757257D4C7C02C0A034E32EC8927`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFF8000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `26F3EAEC9ED8557BC6B619CFF26E2DA2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFC000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A907B539BE7F9F8C4CF90A0F6E364531`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFE000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7D7A5360CDCCA054B915ED7957A3065F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFF000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `79E7654FFEEF44E4EA6B8118586BD198`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFF800000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `583115733B2E25013626A11B15A935D5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFC00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `06BE0C433F8ACA54650388C94BEAE31E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFE00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F97ADC869E2242B75BCF6DA770141119`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFF00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DE75253DD65AC0BA4A41196653C0C7B4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFF80000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2726E1C0C620852E77C330D7106C622E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFC0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3191CF33BE8D3C4F1D49EC107BC6906D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFE0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7924A863BFDA7239D8004BE5A968B5EB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5B4C91F5232DAD2B623A1927A7FA8D4D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFF8000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `62CAA687AF9126238EFC568BDF9E3D25`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFC000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `414B18C9A6846DBEE4831AB06677200E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFE000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `485DF9D6189FC39E8F4DFA9F56420469`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F397CE271C16F51107BB6253CDA88B94`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF800`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1E958861DF1038FF63D33D96F1D7A10D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `427D70D7B29DC96C78E370C7CAA1CCD6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `61CDD874E7828A660A0A5B1A48A78D9C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2160B75C3AB7B99BC904B16A010DAA2F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `545C95032B4536AC8C9CC151AA763493`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6A37F528D2FA7913E65B57A266A6F9FB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4912C9A1EDEEA08BCA55A5D6C8C94779`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6BF3BF8BD4A98C9377265B5D34F16153`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A032988631F44C42A5F3BD2FF0738037`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1CF2BABFD18D28FC0FF2CF2EF0229EB7`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `30E347B16832CBECE83C8B54CB6EF909`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2E582A95A18CBB64F26CBE02E5E20944`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `0B8625968082C927C38BEB98712C3F50`,
		Secure: `B7CBA5F9E11CED3A1B5ED109E03A8EF3`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `991A70739B014281C80273E4D16CB673`,
		Secure: `C3D833DB1CBA0D8FB7AA3028BB02B0B2`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FC717F6890AE6A2BB8F0C3E6E30FEA26`,
		Secure: `FA55A1828A6354E9D0ECC09AD509A506`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `0FB2D6C33A935A885542819E773AB2D6`,
		Secure: `E0047204DD08CE4AF76F5EBCB8F7B558`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `1C2326CE69C0C28A382FDEF2DE557B78`,
		Secure: `3402D2F950907872613BEE0428AC92BE`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `7866ABE7CFF16B462292EDB8484FAF9C`,
		Secure: `427EF5DA973CA28C2D476C4BDF05D867`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `DB31EF82956B9F8A3A23BD2E4CCF2B4C`,
		Secure: `BB3F350A77C0828AD55B1D71F8C057C6`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `91634F3CB26603D3F5F23E516F071A8F`,
		Secure: `7DF9726A9AC875CFDE066C16C567C4F4`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `23943C00C065F8CFF71184FF602F1673`,
		Secure: `E7C48663C4021B6822C31360D728BA08`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `27A870BBB37A40C4AEA007D621E60E57`,
		Secure: `7B85094AAB8FB31E14E74CA449FC0F8B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `4E30817C55BA630381E132E9F211C1B3`,
		Secure: `6C3FAC4B8111DD8ED50CBB2025E93520`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `4C83C9B2E1EF168E062E7884136D801E`,
		Secure: `36B2622BCFF0A892955B9FADB2FAA53D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `893F897D1C1035431C91BBE36917FC49`,
		Secure: `B37E76808A45FBDD7C933725504C84FB`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `1C994CFDB55B35602B29746D2D2F7DDA`,
		Secure: `FB3B81D51F00E842444B3D72497C7FFA`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `585205566672BA9DCAE0FE6062AFDF88`,
		Secure: `78D4BE592BFE85DDE5C628E5080E6C4D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `C1B7FF6C0C04094445490EE95EBA83DE`,
		Secure: `F1CC0364DD4F8F92760FF030AD2909F8`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `5F472D94947062CFC0A9D39B85169E7C`,
		Secure: `170C59E7A9B9F1606F90FD6250F02963`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `9B6F208F08CBF31638E3AB2ECCFCE113`,
		Secure: `3B91174EF1459C8933288E8E1BE592A4`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `2E5BC5C36670416F48457654380FF935`,
		Secure: `5F7ABBE66A69C2509EA12DC044E2736A`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `BA8C2B53F29B7FD6D3377FBA2912217D`,
		Secure: `EA727DCA26305CB6887533954D3B919A`,
	},
}
