//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// ExtendedSQLPoolBlobAuditingPoliciesServer is a fake server for instances of the armsynapse.ExtendedSQLPoolBlobAuditingPoliciesClient type.
type ExtendedSQLPoolBlobAuditingPoliciesServer struct {
	// CreateOrUpdate is the fake for method ExtendedSQLPoolBlobAuditingPoliciesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, parameters armsynapse.ExtendedSQLPoolBlobAuditingPolicy, options *armsynapse.ExtendedSQLPoolBlobAuditingPoliciesClientCreateOrUpdateOptions) (resp azfake.Responder[armsynapse.ExtendedSQLPoolBlobAuditingPoliciesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ExtendedSQLPoolBlobAuditingPoliciesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, options *armsynapse.ExtendedSQLPoolBlobAuditingPoliciesClientGetOptions) (resp azfake.Responder[armsynapse.ExtendedSQLPoolBlobAuditingPoliciesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySQLPoolPager is the fake for method ExtendedSQLPoolBlobAuditingPoliciesClient.NewListBySQLPoolPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySQLPoolPager func(resourceGroupName string, workspaceName string, sqlPoolName string, options *armsynapse.ExtendedSQLPoolBlobAuditingPoliciesClientListBySQLPoolOptions) (resp azfake.PagerResponder[armsynapse.ExtendedSQLPoolBlobAuditingPoliciesClientListBySQLPoolResponse])
}

// NewExtendedSQLPoolBlobAuditingPoliciesServerTransport creates a new instance of ExtendedSQLPoolBlobAuditingPoliciesServerTransport with the provided implementation.
// The returned ExtendedSQLPoolBlobAuditingPoliciesServerTransport instance is connected to an instance of armsynapse.ExtendedSQLPoolBlobAuditingPoliciesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewExtendedSQLPoolBlobAuditingPoliciesServerTransport(srv *ExtendedSQLPoolBlobAuditingPoliciesServer) *ExtendedSQLPoolBlobAuditingPoliciesServerTransport {
	return &ExtendedSQLPoolBlobAuditingPoliciesServerTransport{
		srv:                   srv,
		newListBySQLPoolPager: newTracker[azfake.PagerResponder[armsynapse.ExtendedSQLPoolBlobAuditingPoliciesClientListBySQLPoolResponse]](),
	}
}

// ExtendedSQLPoolBlobAuditingPoliciesServerTransport connects instances of armsynapse.ExtendedSQLPoolBlobAuditingPoliciesClient to instances of ExtendedSQLPoolBlobAuditingPoliciesServer.
// Don't use this type directly, use NewExtendedSQLPoolBlobAuditingPoliciesServerTransport instead.
type ExtendedSQLPoolBlobAuditingPoliciesServerTransport struct {
	srv                   *ExtendedSQLPoolBlobAuditingPoliciesServer
	newListBySQLPoolPager *tracker[azfake.PagerResponder[armsynapse.ExtendedSQLPoolBlobAuditingPoliciesClientListBySQLPoolResponse]]
}

// Do implements the policy.Transporter interface for ExtendedSQLPoolBlobAuditingPoliciesServerTransport.
func (e *ExtendedSQLPoolBlobAuditingPoliciesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ExtendedSQLPoolBlobAuditingPoliciesClient.CreateOrUpdate":
		resp, err = e.dispatchCreateOrUpdate(req)
	case "ExtendedSQLPoolBlobAuditingPoliciesClient.Get":
		resp, err = e.dispatchGet(req)
	case "ExtendedSQLPoolBlobAuditingPoliciesClient.NewListBySQLPoolPager":
		resp, err = e.dispatchNewListBySQLPoolPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *ExtendedSQLPoolBlobAuditingPoliciesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if e.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extendedAuditingSettings/(?P<blobAuditingPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsynapse.ExtendedSQLPoolBlobAuditingPolicy](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ExtendedSQLPoolBlobAuditingPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExtendedSQLPoolBlobAuditingPoliciesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extendedAuditingSettings/(?P<blobAuditingPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ExtendedSQLPoolBlobAuditingPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExtendedSQLPoolBlobAuditingPoliciesServerTransport) dispatchNewListBySQLPoolPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListBySQLPoolPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySQLPoolPager not implemented")}
	}
	newListBySQLPoolPager := e.newListBySQLPoolPager.get(req)
	if newListBySQLPoolPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extendedAuditingSettings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListBySQLPoolPager(resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, nil)
		newListBySQLPoolPager = &resp
		e.newListBySQLPoolPager.add(req, newListBySQLPoolPager)
		server.PagerResponderInjectNextLinks(newListBySQLPoolPager, req, func(page *armsynapse.ExtendedSQLPoolBlobAuditingPoliciesClientListBySQLPoolResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySQLPoolPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListBySQLPoolPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySQLPoolPager) {
		e.newListBySQLPoolPager.remove(req)
	}
	return resp, nil
}
