//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/streamanalytics/armstreamanalytics/v2"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// StreamingJobsServer is a fake server for instances of the armstreamanalytics.StreamingJobsClient type.
type StreamingJobsServer struct {
	// BeginCreateOrReplace is the fake for method StreamingJobsClient.BeginCreateOrReplace
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrReplace func(ctx context.Context, resourceGroupName string, jobName string, streamingJob armstreamanalytics.StreamingJob, options *armstreamanalytics.StreamingJobsClientBeginCreateOrReplaceOptions) (resp azfake.PollerResponder[armstreamanalytics.StreamingJobsClientCreateOrReplaceResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method StreamingJobsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, jobName string, options *armstreamanalytics.StreamingJobsClientBeginDeleteOptions) (resp azfake.PollerResponder[armstreamanalytics.StreamingJobsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method StreamingJobsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, jobName string, options *armstreamanalytics.StreamingJobsClientGetOptions) (resp azfake.Responder[armstreamanalytics.StreamingJobsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method StreamingJobsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armstreamanalytics.StreamingJobsClientListOptions) (resp azfake.PagerResponder[armstreamanalytics.StreamingJobsClientListResponse])

	// NewListByResourceGroupPager is the fake for method StreamingJobsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armstreamanalytics.StreamingJobsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armstreamanalytics.StreamingJobsClientListByResourceGroupResponse])

	// BeginScale is the fake for method StreamingJobsClient.BeginScale
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginScale func(ctx context.Context, resourceGroupName string, jobName string, options *armstreamanalytics.StreamingJobsClientBeginScaleOptions) (resp azfake.PollerResponder[armstreamanalytics.StreamingJobsClientScaleResponse], errResp azfake.ErrorResponder)

	// BeginStart is the fake for method StreamingJobsClient.BeginStart
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStart func(ctx context.Context, resourceGroupName string, jobName string, options *armstreamanalytics.StreamingJobsClientBeginStartOptions) (resp azfake.PollerResponder[armstreamanalytics.StreamingJobsClientStartResponse], errResp azfake.ErrorResponder)

	// BeginStop is the fake for method StreamingJobsClient.BeginStop
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStop func(ctx context.Context, resourceGroupName string, jobName string, options *armstreamanalytics.StreamingJobsClientBeginStopOptions) (resp azfake.PollerResponder[armstreamanalytics.StreamingJobsClientStopResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method StreamingJobsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, jobName string, streamingJob armstreamanalytics.StreamingJob, options *armstreamanalytics.StreamingJobsClientUpdateOptions) (resp azfake.Responder[armstreamanalytics.StreamingJobsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewStreamingJobsServerTransport creates a new instance of StreamingJobsServerTransport with the provided implementation.
// The returned StreamingJobsServerTransport instance is connected to an instance of armstreamanalytics.StreamingJobsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewStreamingJobsServerTransport(srv *StreamingJobsServer) *StreamingJobsServerTransport {
	return &StreamingJobsServerTransport{
		srv:                         srv,
		beginCreateOrReplace:        newTracker[azfake.PollerResponder[armstreamanalytics.StreamingJobsClientCreateOrReplaceResponse]](),
		beginDelete:                 newTracker[azfake.PollerResponder[armstreamanalytics.StreamingJobsClientDeleteResponse]](),
		newListPager:                newTracker[azfake.PagerResponder[armstreamanalytics.StreamingJobsClientListResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armstreamanalytics.StreamingJobsClientListByResourceGroupResponse]](),
		beginScale:                  newTracker[azfake.PollerResponder[armstreamanalytics.StreamingJobsClientScaleResponse]](),
		beginStart:                  newTracker[azfake.PollerResponder[armstreamanalytics.StreamingJobsClientStartResponse]](),
		beginStop:                   newTracker[azfake.PollerResponder[armstreamanalytics.StreamingJobsClientStopResponse]](),
	}
}

// StreamingJobsServerTransport connects instances of armstreamanalytics.StreamingJobsClient to instances of StreamingJobsServer.
// Don't use this type directly, use NewStreamingJobsServerTransport instead.
type StreamingJobsServerTransport struct {
	srv                         *StreamingJobsServer
	beginCreateOrReplace        *tracker[azfake.PollerResponder[armstreamanalytics.StreamingJobsClientCreateOrReplaceResponse]]
	beginDelete                 *tracker[azfake.PollerResponder[armstreamanalytics.StreamingJobsClientDeleteResponse]]
	newListPager                *tracker[azfake.PagerResponder[armstreamanalytics.StreamingJobsClientListResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armstreamanalytics.StreamingJobsClientListByResourceGroupResponse]]
	beginScale                  *tracker[azfake.PollerResponder[armstreamanalytics.StreamingJobsClientScaleResponse]]
	beginStart                  *tracker[azfake.PollerResponder[armstreamanalytics.StreamingJobsClientStartResponse]]
	beginStop                   *tracker[azfake.PollerResponder[armstreamanalytics.StreamingJobsClientStopResponse]]
}

// Do implements the policy.Transporter interface for StreamingJobsServerTransport.
func (s *StreamingJobsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "StreamingJobsClient.BeginCreateOrReplace":
		resp, err = s.dispatchBeginCreateOrReplace(req)
	case "StreamingJobsClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "StreamingJobsClient.Get":
		resp, err = s.dispatchGet(req)
	case "StreamingJobsClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	case "StreamingJobsClient.NewListByResourceGroupPager":
		resp, err = s.dispatchNewListByResourceGroupPager(req)
	case "StreamingJobsClient.BeginScale":
		resp, err = s.dispatchBeginScale(req)
	case "StreamingJobsClient.BeginStart":
		resp, err = s.dispatchBeginStart(req)
	case "StreamingJobsClient.BeginStop":
		resp, err = s.dispatchBeginStop(req)
	case "StreamingJobsClient.Update":
		resp, err = s.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *StreamingJobsServerTransport) dispatchBeginCreateOrReplace(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateOrReplace == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrReplace not implemented")}
	}
	beginCreateOrReplace := s.beginCreateOrReplace.get(req)
	if beginCreateOrReplace == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstreamanalytics.StreamingJob](req)
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		ifNoneMatchParam := getOptional(getHeaderValue(req.Header, "If-None-Match"))
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
		if err != nil {
			return nil, err
		}
		var options *armstreamanalytics.StreamingJobsClientBeginCreateOrReplaceOptions
		if ifMatchParam != nil || ifNoneMatchParam != nil {
			options = &armstreamanalytics.StreamingJobsClientBeginCreateOrReplaceOptions{
				IfMatch:     ifMatchParam,
				IfNoneMatch: ifNoneMatchParam,
			}
		}
		respr, errRespr := s.srv.BeginCreateOrReplace(req.Context(), resourceGroupNameParam, jobNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrReplace = &respr
		s.beginCreateOrReplace.add(req, beginCreateOrReplace)
	}

	resp, err := server.PollerResponderNext(beginCreateOrReplace, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		s.beginCreateOrReplace.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrReplace) {
		s.beginCreateOrReplace.remove(req)
	}

	return resp, nil
}

func (s *StreamingJobsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, jobNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *StreamingJobsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
	if err != nil {
		return nil, err
	}
	var options *armstreamanalytics.StreamingJobsClientGetOptions
	if expandParam != nil {
		options = &armstreamanalytics.StreamingJobsClientGetOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, jobNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StreamingJob, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (s *StreamingJobsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		var options *armstreamanalytics.StreamingJobsClientListOptions
		if expandParam != nil {
			options = &armstreamanalytics.StreamingJobsClientListOptions{
				Expand: expandParam,
			}
		}
		resp := s.srv.NewListPager(options)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armstreamanalytics.StreamingJobsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}

func (s *StreamingJobsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := s.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		var options *armstreamanalytics.StreamingJobsClientListByResourceGroupOptions
		if expandParam != nil {
			options = &armstreamanalytics.StreamingJobsClientListByResourceGroupOptions{
				Expand: expandParam,
			}
		}
		resp := s.srv.NewListByResourceGroupPager(resourceGroupNameParam, options)
		newListByResourceGroupPager = &resp
		s.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armstreamanalytics.StreamingJobsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		s.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (s *StreamingJobsServerTransport) dispatchBeginScale(req *http.Request) (*http.Response, error) {
	if s.srv.BeginScale == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginScale not implemented")}
	}
	beginScale := s.beginScale.get(req)
	if beginScale == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scale`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstreamanalytics.ScaleStreamingJobParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
		if err != nil {
			return nil, err
		}
		var options *armstreamanalytics.StreamingJobsClientBeginScaleOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armstreamanalytics.StreamingJobsClientBeginScaleOptions{
				ScaleJobParameters: &body,
			}
		}
		respr, errRespr := s.srv.BeginScale(req.Context(), resourceGroupNameParam, jobNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginScale = &respr
		s.beginScale.add(req, beginScale)
	}

	resp, err := server.PollerResponderNext(beginScale, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginScale.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginScale) {
		s.beginScale.remove(req)
	}

	return resp, nil
}

func (s *StreamingJobsServerTransport) dispatchBeginStart(req *http.Request) (*http.Response, error) {
	if s.srv.BeginStart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStart not implemented")}
	}
	beginStart := s.beginStart.get(req)
	if beginStart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstreamanalytics.StartStreamingJobParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
		if err != nil {
			return nil, err
		}
		var options *armstreamanalytics.StreamingJobsClientBeginStartOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armstreamanalytics.StreamingJobsClientBeginStartOptions{
				StartJobParameters: &body,
			}
		}
		respr, errRespr := s.srv.BeginStart(req.Context(), resourceGroupNameParam, jobNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStart = &respr
		s.beginStart.add(req, beginStart)
	}

	resp, err := server.PollerResponderNext(beginStart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginStart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStart) {
		s.beginStart.remove(req)
	}

	return resp, nil
}

func (s *StreamingJobsServerTransport) dispatchBeginStop(req *http.Request) (*http.Response, error) {
	if s.srv.BeginStop == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStop not implemented")}
	}
	beginStop := s.beginStop.get(req)
	if beginStop == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginStop(req.Context(), resourceGroupNameParam, jobNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStop = &respr
		s.beginStop.add(req, beginStop)
	}

	resp, err := server.PollerResponderNext(beginStop, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginStop.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStop) {
		s.beginStop.remove(req)
	}

	return resp, nil
}

func (s *StreamingJobsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstreamanalytics.StreamingJob](req)
	if err != nil {
		return nil, err
	}
	ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
	if err != nil {
		return nil, err
	}
	var options *armstreamanalytics.StreamingJobsClientUpdateOptions
	if ifMatchParam != nil {
		options = &armstreamanalytics.StreamingJobsClientUpdateOptions{
			IfMatch: ifMatchParam,
		}
	}
	respr, errRespr := s.srv.Update(req.Context(), resourceGroupNameParam, jobNameParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StreamingJob, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}
