//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstoragesync_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storagesync/armstoragesync"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/CloudEndpoints_Create.json
func ExampleCloudEndpointsClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCloudEndpointsClient().BeginCreate(ctx, "SampleResourceGroup_1", "SampleStorageSyncService_1", "SampleSyncGroup_1", "SampleCloudEndpoint_1", armstoragesync.CloudEndpointCreateParameters{
		Properties: &armstoragesync.CloudEndpointCreateParametersProperties{
			AzureFileShareName:       to.Ptr("cvcloud-afscv-0719-058-a94a1354-a1fd-4e9a-9a50-919fad8c4ba4"),
			FriendlyName:             to.Ptr("ankushbsubscriptionmgmtmab"),
			StorageAccountResourceID: to.Ptr("/subscriptions/744f4d70-6d17-4921-8970-a765d14f763f/resourceGroups/tminienv59svc/providers/Microsoft.Storage/storageAccounts/tminienv59storage"),
			StorageAccountTenantID:   to.Ptr("\"72f988bf-86f1-41af-91ab-2d7cd011db47\""),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CloudEndpoint = armstoragesync.CloudEndpoint{
	// 	Name: to.Ptr("SampleCloudEndpoint_1"),
	// 	Type: to.Ptr("Microsoft.StorageSync/storageSyncServices/syncGroups/cloudEndpoints"),
	// 	ID: to.Ptr("/subscriptions/52b8da2f-61e0-4a1f-8dde-336911f367fb/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_1/syncGroups/SampleSyncGroup_1/cloudEndpoints/SampleCloudEndpoint_1"),
	// 	Properties: &armstoragesync.CloudEndpointProperties{
	// 		AzureFileShareName: to.Ptr("cvcloud-afscv-0719-058-a94a1354-a1fd-4e9a-9a50-919fad8c4ba4"),
	// 		BackupEnabled: to.Ptr("false"),
	// 		FriendlyName: to.Ptr("ankushbsubscriptionmgmtmab"),
	// 		LastOperationName: to.Ptr("ICreateCloudEndpointWorkflow"),
	// 		LastWorkflowID: to.Ptr("storageSyncServices/GATest/workflows/24ba0c4a-348e-419b-8f7a-091d0d9f07a4"),
	// 		PartnershipID: to.Ptr("1|U0VSVkVSQVNTWU5DQ0xJRU5USEZTVjJ8RjhDODcwQTItMkFGNi00NDUyLTgzMDgtRjJCQTZEQjI3RkEwfEdFTkVSSUN8NTJCOERBMkYtNjFFMC00QTFGLThEREUtMzM2OTExRjM2N0ZC"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		StorageAccountResourceID: to.Ptr("/subscriptions/744f4d70-6d17-4921-8970-a765d14f763f/resourceGroups/tminienv59svc/providers/Microsoft.Storage/storageAccounts/tminienv59storage"),
	// 		StorageAccountTenantID: to.Ptr("\"72f988bf-86f1-41af-91ab-2d7cd011db47\""),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/CloudEndpoints_Get.json
func ExampleCloudEndpointsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCloudEndpointsClient().Get(ctx, "SampleResourceGroup_1", "SampleStorageSyncService_1", "SampleSyncGroup_1", "SampleCloudEndpoint_1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CloudEndpoint = armstoragesync.CloudEndpoint{
	// 	Name: to.Ptr("SampleCloudEndpoint_1"),
	// 	Type: to.Ptr("Microsoft.StorageSync/storageSyncServices/syncGroups/cloudEndpoints"),
	// 	ID: to.Ptr("/subscriptions/3a048283-338f-4002-a9dd-a50fdadcb392/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_1/syncGroups/SyncGroup_Restore_08-08_Test112/cloudEndpoints/CEP_Restore_08-08_Test112"),
	// 	Properties: &armstoragesync.CloudEndpointProperties{
	// 		AzureFileShareName: to.Ptr(""),
	// 		ChangeEnumerationStatus: &armstoragesync.CloudEndpointChangeEnumerationStatus{
	// 			Activity: &armstoragesync.CloudEndpointChangeEnumerationActivity{
	// 				DeletesProgressPercent: to.Ptr[int32](12),
	// 				LastUpdatedTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-17T19:14:59.096Z"); return t}()),
	// 				MinutesRemaining: to.Ptr[int32](589),
	// 				OperationState: to.Ptr(armstoragesync.CloudEndpointChangeEnumerationActivityStateEnumerationInProgress),
	// 				ProcessedDirectoriesCount: to.Ptr[int64](364),
	// 				ProcessedFilesCount: to.Ptr[int64](6948),
	// 				ProgressPercent: to.Ptr[int32](67),
	// 				StartedTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-17T19:14:59.096Z"); return t}()),
	// 				StatusCode: to.Ptr[int32](0),
	// 				TotalCountsState: to.Ptr(armstoragesync.CloudEndpointChangeEnumerationTotalCountsStateFinal),
	// 				TotalDirectoriesCount: to.Ptr[int64](694),
	// 				TotalFilesCount: to.Ptr[int64](12834),
	// 				TotalSizeBytes: to.Ptr[int64](5782301239408),
	// 			},
	// 			LastEnumerationStatus: &armstoragesync.CloudEndpointLastChangeEnumerationStatus{
	// 				CompletedTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-17T19:14:59.096Z"); return t}()),
	// 				NamespaceDirectoriesCount: to.Ptr[int64](28),
	// 				NamespaceFilesCount: to.Ptr[int64](3489),
	// 				NamespaceSizeBytes: to.Ptr[int64](3248804),
	// 				NextRunTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-17T19:14:59.096Z"); return t}()),
	// 				StartedTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-17T19:14:59.096Z"); return t}()),
	// 			},
	// 			LastUpdatedTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-17T19:14:59.096Z"); return t}()),
	// 		},
	// 		FriendlyName: to.Ptr("SampleAzureFileShareName_1"),
	// 		LastOperationName: to.Ptr("ICreateCloudEndpointWorkflow"),
	// 		LastWorkflowID: to.Ptr("/subscriptions/3a048283-338f-4002-a9dd-a50fdadcb392/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_1/workflows/a377fdd5-949a-40ab-9629-06cd0e9852f9"),
	// 		PartnershipID: to.Ptr("1|U0VSVkVSQVNTWU5DQ0xJRU5USEZTVjJ8MTkxNjYwQ0QtNkExQS00RjhDLTk3ODctQTZCRUQyMDZBMUREfEdFTkVSSUN8M0EwNDgyODMtMzM4Ri00MDAyLUE5REQtQTUwRkRBRENCMzky"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		StorageAccountResourceID: to.Ptr(""),
	// 		StorageAccountTenantID: to.Ptr("\"a4d1b191-c1af-4cef-a14b-f670e0beea52\""),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/CloudEndpoints_Delete.json
func ExampleCloudEndpointsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCloudEndpointsClient().BeginDelete(ctx, "SampleResourceGroup_1", "SampleStorageSyncService_1", "SampleSyncGroup_1", "SampleCloudEndpoint_1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/CloudEndpoints_ListBySyncGroup.json
func ExampleCloudEndpointsClient_NewListBySyncGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCloudEndpointsClient().NewListBySyncGroupPager("SampleResourceGroup_1", "SampleStorageSyncService_1", "SampleSyncGroup_1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CloudEndpointArray = armstoragesync.CloudEndpointArray{
		// 	Value: []*armstoragesync.CloudEndpoint{
		// 		{
		// 			Name: to.Ptr("CEP_Restore_08-08_Test112"),
		// 			Type: to.Ptr("Microsoft.StorageSync/storageSyncServices/syncGroups/cloudEndpoints"),
		// 			ID: to.Ptr("/subscriptions/3a048283-338f-4002-a9dd-a50fdadcb392/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_1/syncGroups/SyncGroup_Restore_08-08_Test112/cloudEndpoints/CEP_Restore_08-08_Test112"),
		// 			Properties: &armstoragesync.CloudEndpointProperties{
		// 				AzureFileShareName: to.Ptr(""),
		// 				ChangeEnumerationStatus: &armstoragesync.CloudEndpointChangeEnumerationStatus{
		// 					Activity: &armstoragesync.CloudEndpointChangeEnumerationActivity{
		// 						LastUpdatedTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-17T19:14:59.096Z"); return t}()),
		// 						MinutesRemaining: to.Ptr[int32](589),
		// 						OperationState: to.Ptr(armstoragesync.CloudEndpointChangeEnumerationActivityState("Delayed")),
		// 						ProcessedDirectoriesCount: to.Ptr[int64](364),
		// 						ProcessedFilesCount: to.Ptr[int64](6948),
		// 						ProgressPercent: to.Ptr[int32](67),
		// 						StartedTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-17T19:14:59.096Z"); return t}()),
		// 						StatusCode: to.Ptr[int32](-1),
		// 						TotalCountsState: to.Ptr(armstoragesync.CloudEndpointChangeEnumerationTotalCountsStateCalculating),
		// 						TotalDirectoriesCount: to.Ptr[int64](694),
		// 						TotalFilesCount: to.Ptr[int64](12834),
		// 						TotalSizeBytes: to.Ptr[int64](5782301239408),
		// 					},
		// 					LastEnumerationStatus: &armstoragesync.CloudEndpointLastChangeEnumerationStatus{
		// 						CompletedTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-17T19:14:59.096Z"); return t}()),
		// 						NamespaceDirectoriesCount: to.Ptr[int64](28),
		// 						NamespaceFilesCount: to.Ptr[int64](3489),
		// 						NamespaceSizeBytes: to.Ptr[int64](3248804),
		// 						NextRunTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-17T19:14:59.096Z"); return t}()),
		// 						StartedTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-17T19:14:59.096Z"); return t}()),
		// 					},
		// 					LastUpdatedTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-17T19:14:59.096Z"); return t}()),
		// 				},
		// 				FriendlyName: to.Ptr("SampleAzureFileShareName_1"),
		// 				LastOperationName: to.Ptr("ICreateCloudEndpointWorkflow"),
		// 				LastWorkflowID: to.Ptr("/subscriptions/3a048283-338f-4002-a9dd-a50fdadcb392/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_1/workflows/a377fdd5-949a-40ab-9629-06cd0e9852f9"),
		// 				PartnershipID: to.Ptr("1|U0VSVkVSQVNTWU5DQ0xJRU5Udfsdfdsfs8MTkxNjYwQ0QtNkExQS00RjhDLTk3ODctQTZCRUQyMDZBMUREfEdFTkVSSUN8M0EwNDgyODMtMzM4Ri00MDAyLUE5REQtQTUwRkRBRENCMzky"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				StorageAccountResourceID: to.Ptr(""),
		// 				StorageAccountTenantID: to.Ptr("\"a4d1b191-c1af-4cef-a14b-f670e0beea52\""),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/CloudEndpoints_PreBackup.json
func ExampleCloudEndpointsClient_BeginPreBackup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCloudEndpointsClient().BeginPreBackup(ctx, "SampleResourceGroup_1", "SampleStorageSyncService_1", "SampleSyncGroup_1", "SampleCloudEndpoint_1", armstoragesync.BackupRequest{
		AzureFileShare: to.Ptr("https://sampleserver.file.core.test-cint.azure-test.net/sampleFileShare"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/CloudEndpoints_PostBackup.json
func ExampleCloudEndpointsClient_BeginPostBackup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCloudEndpointsClient().BeginPostBackup(ctx, "SampleResourceGroup_1", "SampleStorageSyncService_1", "SampleSyncGroup_1", "SampleCloudEndpoint_1", armstoragesync.BackupRequest{
		AzureFileShare: to.Ptr("https://sampleserver.file.core.test-cint.azure-test.net/sampleFileShare"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PostBackupResponse = armstoragesync.PostBackupResponse{
	// 	BackupMetadata: &armstoragesync.PostBackupResponseProperties{
	// 		CloudEndpointName: to.Ptr("subscriptions/52b8da2f-61e0-4a1f-8dde-336911f367fb/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_1/syncGroups/SampleSyncGroup_1/cloudEndpoints/SampleCloudEndpoint_1"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/CloudEndpoints_PreRestore.json
func ExampleCloudEndpointsClient_BeginPreRestore() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCloudEndpointsClient().BeginPreRestore(ctx, "SampleResourceGroup_1", "SampleStorageSyncService_1", "SampleSyncGroup_1", "SampleCloudEndpoint_1", armstoragesync.PreRestoreRequest{
		AzureFileShareURI: to.Ptr("https://hfsazbackupdevintncus2.file.core.test-cint.azure-test.net/sampleFileShare"),
		RestoreFileSpec: []*armstoragesync.RestoreFileSpec{
			{
				Path:  to.Ptr("text1.txt"),
				Isdir: to.Ptr(false),
			},
			{
				Path:  to.Ptr("MyDir"),
				Isdir: to.Ptr(true),
			},
			{
				Path:  to.Ptr("MyDir/SubDir"),
				Isdir: to.Ptr(false),
			},
			{
				Path:  to.Ptr("MyDir/SubDir/File1.pdf"),
				Isdir: to.Ptr(false),
			}},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/CloudEndpoints_RestoreHeatbeat.json
func ExampleCloudEndpointsClient_Restoreheartbeat() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewCloudEndpointsClient().Restoreheartbeat(ctx, "SampleResourceGroup_1", "SampleStorageSyncService_1", "SampleSyncGroup_1", "SampleCloudEndpoint_1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/CloudEndpoints_PostRestore.json
func ExampleCloudEndpointsClient_BeginPostRestore() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCloudEndpointsClient().BeginPostRestore(ctx, "SampleResourceGroup_1", "SampleStorageSyncService_1", "SampleSyncGroup_1", "SampleCloudEndpoint_1", armstoragesync.PostRestoreRequest{
		AzureFileShareURI: to.Ptr("https://hfsazbackupdevintncus2.file.core.test-cint.azure-test.net/sampleFileShare"),
		RestoreFileSpec: []*armstoragesync.RestoreFileSpec{
			{
				Path:  to.Ptr("text1.txt"),
				Isdir: to.Ptr(false),
			},
			{
				Path:  to.Ptr("MyDir"),
				Isdir: to.Ptr(true),
			},
			{
				Path:  to.Ptr("MyDir/SubDir"),
				Isdir: to.Ptr(false),
			},
			{
				Path:  to.Ptr("MyDir/SubDir/File1.pdf"),
				Isdir: to.Ptr(false),
			}},
		SourceAzureFileShareURI: to.Ptr("https://hfsazbackupdevintncus2.file.core.test-cint.azure-test.net/sampleFileShare"),
		Status:                  to.Ptr("Succeeded"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/CloudEndpoints_TriggerChangeDetection.json
func ExampleCloudEndpointsClient_BeginTriggerChangeDetection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCloudEndpointsClient().BeginTriggerChangeDetection(ctx, "SampleResourceGroup_1", "SampleStorageSyncService_1", "SampleSyncGroup_1", "SampleCloudEndpoint_1", armstoragesync.TriggerChangeDetectionParameters{
		ChangeDetectionMode: to.Ptr(armstoragesync.ChangeDetectionModeRecursive),
		DirectoryPath:       to.Ptr("NewDirectory"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
