//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorage

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAccountsClient creates a new instance of AccountsClient.
func (c *ClientFactory) NewAccountsClient() *AccountsClient {
	subClient, _ := NewAccountsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewBlobContainersClient creates a new instance of BlobContainersClient.
func (c *ClientFactory) NewBlobContainersClient() *BlobContainersClient {
	subClient, _ := NewBlobContainersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewBlobInventoryPoliciesClient creates a new instance of BlobInventoryPoliciesClient.
func (c *ClientFactory) NewBlobInventoryPoliciesClient() *BlobInventoryPoliciesClient {
	subClient, _ := NewBlobInventoryPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewBlobServicesClient creates a new instance of BlobServicesClient.
func (c *ClientFactory) NewBlobServicesClient() *BlobServicesClient {
	subClient, _ := NewBlobServicesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDeletedAccountsClient creates a new instance of DeletedAccountsClient.
func (c *ClientFactory) NewDeletedAccountsClient() *DeletedAccountsClient {
	subClient, _ := NewDeletedAccountsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewEncryptionScopesClient creates a new instance of EncryptionScopesClient.
func (c *ClientFactory) NewEncryptionScopesClient() *EncryptionScopesClient {
	subClient, _ := NewEncryptionScopesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewFileServicesClient creates a new instance of FileServicesClient.
func (c *ClientFactory) NewFileServicesClient() *FileServicesClient {
	subClient, _ := NewFileServicesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewFileSharesClient creates a new instance of FileSharesClient.
func (c *ClientFactory) NewFileSharesClient() *FileSharesClient {
	subClient, _ := NewFileSharesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLocalUsersClient creates a new instance of LocalUsersClient.
func (c *ClientFactory) NewLocalUsersClient() *LocalUsersClient {
	subClient, _ := NewLocalUsersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagementPoliciesClient creates a new instance of ManagementPoliciesClient.
func (c *ClientFactory) NewManagementPoliciesClient() *ManagementPoliciesClient {
	subClient, _ := NewManagementPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewObjectReplicationPoliciesClient creates a new instance of ObjectReplicationPoliciesClient.
func (c *ClientFactory) NewObjectReplicationPoliciesClient() *ObjectReplicationPoliciesClient {
	subClient, _ := NewObjectReplicationPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsClient creates a new instance of PrivateEndpointConnectionsClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsClient() *PrivateEndpointConnectionsClient {
	subClient, _ := NewPrivateEndpointConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	subClient, _ := NewPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewQueueClient creates a new instance of QueueClient.
func (c *ClientFactory) NewQueueClient() *QueueClient {
	subClient, _ := NewQueueClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewQueueServicesClient creates a new instance of QueueServicesClient.
func (c *ClientFactory) NewQueueServicesClient() *QueueServicesClient {
	subClient, _ := NewQueueServicesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSKUsClient creates a new instance of SKUsClient.
func (c *ClientFactory) NewSKUsClient() *SKUsClient {
	subClient, _ := NewSKUsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTableClient creates a new instance of TableClient.
func (c *ClientFactory) NewTableClient() *TableClient {
	subClient, _ := NewTableClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTableServicesClient creates a new instance of TableServicesClient.
func (c *ClientFactory) NewTableServicesClient() *TableServicesClient {
	subClient, _ := NewTableServicesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewUsagesClient creates a new instance of UsagesClient.
func (c *ClientFactory) NewUsagesClient() *UsagesClient {
	subClient, _ := NewUsagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
