//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/securitydevops/armsecuritydevops"
	"net/http"
	"net/url"
	"regexp"
)

// AzureDevOpsProjectServer is a fake server for instances of the armsecuritydevops.AzureDevOpsProjectClient type.
type AzureDevOpsProjectServer struct {
	// BeginCreateOrUpdate is the fake for method AzureDevOpsProjectClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, azureDevOpsConnectorName string, azureDevOpsOrgName string, azureDevOpsProjectName string, azureDevOpsProject armsecuritydevops.AzureDevOpsProject, options *armsecuritydevops.AzureDevOpsProjectClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsecuritydevops.AzureDevOpsProjectClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method AzureDevOpsProjectClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, azureDevOpsConnectorName string, azureDevOpsOrgName string, azureDevOpsProjectName string, options *armsecuritydevops.AzureDevOpsProjectClientGetOptions) (resp azfake.Responder[armsecuritydevops.AzureDevOpsProjectClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method AzureDevOpsProjectClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, azureDevOpsConnectorName string, azureDevOpsOrgName string, options *armsecuritydevops.AzureDevOpsProjectClientListOptions) (resp azfake.PagerResponder[armsecuritydevops.AzureDevOpsProjectClientListResponse])

	// BeginUpdate is the fake for method AzureDevOpsProjectClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, azureDevOpsConnectorName string, azureDevOpsOrgName string, azureDevOpsProjectName string, azureDevOpsProject armsecuritydevops.AzureDevOpsProject, options *armsecuritydevops.AzureDevOpsProjectClientBeginUpdateOptions) (resp azfake.PollerResponder[armsecuritydevops.AzureDevOpsProjectClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewAzureDevOpsProjectServerTransport creates a new instance of AzureDevOpsProjectServerTransport with the provided implementation.
// The returned AzureDevOpsProjectServerTransport instance is connected to an instance of armsecuritydevops.AzureDevOpsProjectClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAzureDevOpsProjectServerTransport(srv *AzureDevOpsProjectServer) *AzureDevOpsProjectServerTransport {
	return &AzureDevOpsProjectServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armsecuritydevops.AzureDevOpsProjectClientCreateOrUpdateResponse]](),
		newListPager:        newTracker[azfake.PagerResponder[armsecuritydevops.AzureDevOpsProjectClientListResponse]](),
		beginUpdate:         newTracker[azfake.PollerResponder[armsecuritydevops.AzureDevOpsProjectClientUpdateResponse]](),
	}
}

// AzureDevOpsProjectServerTransport connects instances of armsecuritydevops.AzureDevOpsProjectClient to instances of AzureDevOpsProjectServer.
// Don't use this type directly, use NewAzureDevOpsProjectServerTransport instead.
type AzureDevOpsProjectServerTransport struct {
	srv                 *AzureDevOpsProjectServer
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armsecuritydevops.AzureDevOpsProjectClientCreateOrUpdateResponse]]
	newListPager        *tracker[azfake.PagerResponder[armsecuritydevops.AzureDevOpsProjectClientListResponse]]
	beginUpdate         *tracker[azfake.PollerResponder[armsecuritydevops.AzureDevOpsProjectClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for AzureDevOpsProjectServerTransport.
func (a *AzureDevOpsProjectServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AzureDevOpsProjectClient.BeginCreateOrUpdate":
		resp, err = a.dispatchBeginCreateOrUpdate(req)
	case "AzureDevOpsProjectClient.Get":
		resp, err = a.dispatchGet(req)
	case "AzureDevOpsProjectClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	case "AzureDevOpsProjectClient.BeginUpdate":
		resp, err = a.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AzureDevOpsProjectServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := a.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityDevOps/azureDevOpsConnectors/(?P<azureDevOpsConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/orgs/(?P<azureDevOpsOrgName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/projects/(?P<azureDevOpsProjectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsecuritydevops.AzureDevOpsProject](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		azureDevOpsConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureDevOpsConnectorName")])
		if err != nil {
			return nil, err
		}
		azureDevOpsOrgNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureDevOpsOrgName")])
		if err != nil {
			return nil, err
		}
		azureDevOpsProjectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureDevOpsProjectName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, azureDevOpsConnectorNameParam, azureDevOpsOrgNameParam, azureDevOpsProjectNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		a.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		a.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		a.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (a *AzureDevOpsProjectServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityDevOps/azureDevOpsConnectors/(?P<azureDevOpsConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/orgs/(?P<azureDevOpsOrgName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/projects/(?P<azureDevOpsProjectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	azureDevOpsConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureDevOpsConnectorName")])
	if err != nil {
		return nil, err
	}
	azureDevOpsOrgNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureDevOpsOrgName")])
	if err != nil {
		return nil, err
	}
	azureDevOpsProjectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureDevOpsProjectName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, azureDevOpsConnectorNameParam, azureDevOpsOrgNameParam, azureDevOpsProjectNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AzureDevOpsProject, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AzureDevOpsProjectServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityDevOps/azureDevOpsConnectors/(?P<azureDevOpsConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/orgs/(?P<azureDevOpsOrgName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/projects`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		azureDevOpsConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureDevOpsConnectorName")])
		if err != nil {
			return nil, err
		}
		azureDevOpsOrgNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureDevOpsOrgName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListPager(resourceGroupNameParam, azureDevOpsConnectorNameParam, azureDevOpsOrgNameParam, nil)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsecuritydevops.AzureDevOpsProjectClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}

func (a *AzureDevOpsProjectServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := a.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityDevOps/azureDevOpsConnectors/(?P<azureDevOpsConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/orgs/(?P<azureDevOpsOrgName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/projects/(?P<azureDevOpsProjectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsecuritydevops.AzureDevOpsProject](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		azureDevOpsConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureDevOpsConnectorName")])
		if err != nil {
			return nil, err
		}
		azureDevOpsOrgNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureDevOpsOrgName")])
		if err != nil {
			return nil, err
		}
		azureDevOpsProjectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureDevOpsProjectName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginUpdate(req.Context(), resourceGroupNameParam, azureDevOpsConnectorNameParam, azureDevOpsOrgNameParam, azureDevOpsProjectNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		a.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		a.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		a.beginUpdate.remove(req)
	}

	return resp, nil
}
