//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpanngfw

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewCertificateObjectGlobalRulestackClient creates a new instance of CertificateObjectGlobalRulestackClient.
func (c *ClientFactory) NewCertificateObjectGlobalRulestackClient() *CertificateObjectGlobalRulestackClient {
	subClient, _ := NewCertificateObjectGlobalRulestackClient(c.credential, c.options)
	return subClient
}

// NewCertificateObjectLocalRulestackClient creates a new instance of CertificateObjectLocalRulestackClient.
func (c *ClientFactory) NewCertificateObjectLocalRulestackClient() *CertificateObjectLocalRulestackClient {
	subClient, _ := NewCertificateObjectLocalRulestackClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewFirewallStatusClient creates a new instance of FirewallStatusClient.
func (c *ClientFactory) NewFirewallStatusClient() *FirewallStatusClient {
	subClient, _ := NewFirewallStatusClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewFirewallsClient creates a new instance of FirewallsClient.
func (c *ClientFactory) NewFirewallsClient() *FirewallsClient {
	subClient, _ := NewFirewallsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewFqdnListGlobalRulestackClient creates a new instance of FqdnListGlobalRulestackClient.
func (c *ClientFactory) NewFqdnListGlobalRulestackClient() *FqdnListGlobalRulestackClient {
	subClient, _ := NewFqdnListGlobalRulestackClient(c.credential, c.options)
	return subClient
}

// NewFqdnListLocalRulestackClient creates a new instance of FqdnListLocalRulestackClient.
func (c *ClientFactory) NewFqdnListLocalRulestackClient() *FqdnListLocalRulestackClient {
	subClient, _ := NewFqdnListLocalRulestackClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGlobalRulestackClient creates a new instance of GlobalRulestackClient.
func (c *ClientFactory) NewGlobalRulestackClient() *GlobalRulestackClient {
	subClient, _ := NewGlobalRulestackClient(c.credential, c.options)
	return subClient
}

// NewLocalRulesClient creates a new instance of LocalRulesClient.
func (c *ClientFactory) NewLocalRulesClient() *LocalRulesClient {
	subClient, _ := NewLocalRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLocalRulestacksClient creates a new instance of LocalRulestacksClient.
func (c *ClientFactory) NewLocalRulestacksClient() *LocalRulestacksClient {
	subClient, _ := NewLocalRulestacksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPostRulesClient creates a new instance of PostRulesClient.
func (c *ClientFactory) NewPostRulesClient() *PostRulesClient {
	subClient, _ := NewPostRulesClient(c.credential, c.options)
	return subClient
}

// NewPreRulesClient creates a new instance of PreRulesClient.
func (c *ClientFactory) NewPreRulesClient() *PreRulesClient {
	subClient, _ := NewPreRulesClient(c.credential, c.options)
	return subClient
}

// NewPrefixListGlobalRulestackClient creates a new instance of PrefixListGlobalRulestackClient.
func (c *ClientFactory) NewPrefixListGlobalRulestackClient() *PrefixListGlobalRulestackClient {
	subClient, _ := NewPrefixListGlobalRulestackClient(c.credential, c.options)
	return subClient
}

// NewPrefixListLocalRulestackClient creates a new instance of PrefixListLocalRulestackClient.
func (c *ClientFactory) NewPrefixListLocalRulestackClient() *PrefixListLocalRulestackClient {
	subClient, _ := NewPrefixListLocalRulestackClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
