//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mysql/armmysqlflexibleservers/v2"
	"net/http"
	"net/url"
	"regexp"
)

// BackupAndExportServer is a fake server for instances of the armmysqlflexibleservers.BackupAndExportClient type.
type BackupAndExportServer struct {
	// BeginCreate is the fake for method BackupAndExportClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreate func(ctx context.Context, resourceGroupName string, serverName string, parameters armmysqlflexibleservers.BackupAndExportRequest, options *armmysqlflexibleservers.BackupAndExportClientBeginCreateOptions) (resp azfake.PollerResponder[armmysqlflexibleservers.BackupAndExportClientCreateResponse], errResp azfake.ErrorResponder)

	// ValidateBackup is the fake for method BackupAndExportClient.ValidateBackup
	// HTTP status codes to indicate success: http.StatusOK
	ValidateBackup func(ctx context.Context, resourceGroupName string, serverName string, options *armmysqlflexibleservers.BackupAndExportClientValidateBackupOptions) (resp azfake.Responder[armmysqlflexibleservers.BackupAndExportClientValidateBackupResponse], errResp azfake.ErrorResponder)
}

// NewBackupAndExportServerTransport creates a new instance of BackupAndExportServerTransport with the provided implementation.
// The returned BackupAndExportServerTransport instance is connected to an instance of armmysqlflexibleservers.BackupAndExportClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewBackupAndExportServerTransport(srv *BackupAndExportServer) *BackupAndExportServerTransport {
	return &BackupAndExportServerTransport{
		srv:         srv,
		beginCreate: newTracker[azfake.PollerResponder[armmysqlflexibleservers.BackupAndExportClientCreateResponse]](),
	}
}

// BackupAndExportServerTransport connects instances of armmysqlflexibleservers.BackupAndExportClient to instances of BackupAndExportServer.
// Don't use this type directly, use NewBackupAndExportServerTransport instead.
type BackupAndExportServerTransport struct {
	srv         *BackupAndExportServer
	beginCreate *tracker[azfake.PollerResponder[armmysqlflexibleservers.BackupAndExportClientCreateResponse]]
}

// Do implements the policy.Transporter interface for BackupAndExportServerTransport.
func (b *BackupAndExportServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "BackupAndExportClient.BeginCreate":
		resp, err = b.dispatchBeginCreate(req)
	case "BackupAndExportClient.ValidateBackup":
		resp, err = b.dispatchValidateBackup(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (b *BackupAndExportServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if b.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := b.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMySQL/flexibleServers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupAndExport`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmysqlflexibleservers.BackupAndExportRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginCreate(req.Context(), resourceGroupNameParam, serverNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		b.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		b.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		b.beginCreate.remove(req)
	}

	return resp, nil
}

func (b *BackupAndExportServerTransport) dispatchValidateBackup(req *http.Request) (*http.Response, error) {
	if b.srv.ValidateBackup == nil {
		return nil, &nonRetriableError{errors.New("fake for method ValidateBackup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMySQL/flexibleServers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validateBackup`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.ValidateBackup(req.Context(), resourceGroupNameParam, serverNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ValidateBackupResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
