//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmysqlflexibleservers

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	internal       *arm.Client
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	internal, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID,
		internal:       internal,
	}, nil
}

// NewAdvancedThreatProtectionSettingsClient creates a new instance of AdvancedThreatProtectionSettingsClient.
func (c *ClientFactory) NewAdvancedThreatProtectionSettingsClient() *AdvancedThreatProtectionSettingsClient {
	return &AdvancedThreatProtectionSettingsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewAzureADAdministratorsClient creates a new instance of AzureADAdministratorsClient.
func (c *ClientFactory) NewAzureADAdministratorsClient() *AzureADAdministratorsClient {
	return &AzureADAdministratorsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewBackupAndExportClient creates a new instance of BackupAndExportClient.
func (c *ClientFactory) NewBackupAndExportClient() *BackupAndExportClient {
	return &BackupAndExportClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewBackupsClient creates a new instance of BackupsClient.
func (c *ClientFactory) NewBackupsClient() *BackupsClient {
	return &BackupsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewCheckNameAvailabilityClient creates a new instance of CheckNameAvailabilityClient.
func (c *ClientFactory) NewCheckNameAvailabilityClient() *CheckNameAvailabilityClient {
	return &CheckNameAvailabilityClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewCheckNameAvailabilityWithoutLocationClient creates a new instance of CheckNameAvailabilityWithoutLocationClient.
func (c *ClientFactory) NewCheckNameAvailabilityWithoutLocationClient() *CheckNameAvailabilityWithoutLocationClient {
	return &CheckNameAvailabilityWithoutLocationClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewCheckVirtualNetworkSubnetUsageClient creates a new instance of CheckVirtualNetworkSubnetUsageClient.
func (c *ClientFactory) NewCheckVirtualNetworkSubnetUsageClient() *CheckVirtualNetworkSubnetUsageClient {
	return &CheckVirtualNetworkSubnetUsageClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewConfigurationsClient creates a new instance of ConfigurationsClient.
func (c *ClientFactory) NewConfigurationsClient() *ConfigurationsClient {
	return &ConfigurationsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDatabasesClient creates a new instance of DatabasesClient.
func (c *ClientFactory) NewDatabasesClient() *DatabasesClient {
	return &DatabasesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewFirewallRulesClient creates a new instance of FirewallRulesClient.
func (c *ClientFactory) NewFirewallRulesClient() *FirewallRulesClient {
	return &FirewallRulesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewGetPrivateDNSZoneSuffixClient creates a new instance of GetPrivateDNSZoneSuffixClient.
func (c *ClientFactory) NewGetPrivateDNSZoneSuffixClient() *GetPrivateDNSZoneSuffixClient {
	return &GetPrivateDNSZoneSuffixClient{
		internal: c.internal,
	}
}

// NewLocationBasedCapabilitiesClient creates a new instance of LocationBasedCapabilitiesClient.
func (c *ClientFactory) NewLocationBasedCapabilitiesClient() *LocationBasedCapabilitiesClient {
	return &LocationBasedCapabilitiesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewLocationBasedCapabilitySetClient creates a new instance of LocationBasedCapabilitySetClient.
func (c *ClientFactory) NewLocationBasedCapabilitySetClient() *LocationBasedCapabilitySetClient {
	return &LocationBasedCapabilitySetClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewLogFilesClient creates a new instance of LogFilesClient.
func (c *ClientFactory) NewLogFilesClient() *LogFilesClient {
	return &LogFilesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewLongRunningBackupClient creates a new instance of LongRunningBackupClient.
func (c *ClientFactory) NewLongRunningBackupClient() *LongRunningBackupClient {
	return &LongRunningBackupClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewLongRunningBackupsClient creates a new instance of LongRunningBackupsClient.
func (c *ClientFactory) NewLongRunningBackupsClient() *LongRunningBackupsClient {
	return &LongRunningBackupsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewMaintenancesClient creates a new instance of MaintenancesClient.
func (c *ClientFactory) NewMaintenancesClient() *MaintenancesClient {
	return &MaintenancesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewOperationProgressClient creates a new instance of OperationProgressClient.
func (c *ClientFactory) NewOperationProgressClient() *OperationProgressClient {
	return &OperationProgressClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewOperationResultsClient creates a new instance of OperationResultsClient.
func (c *ClientFactory) NewOperationResultsClient() *OperationResultsClient {
	return &OperationResultsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	return &OperationsClient{
		internal: c.internal,
	}
}

// NewReplicasClient creates a new instance of ReplicasClient.
func (c *ClientFactory) NewReplicasClient() *ReplicasClient {
	return &ReplicasClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewServersClient creates a new instance of ServersClient.
func (c *ClientFactory) NewServersClient() *ServersClient {
	return &ServersClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewServersMigrationClient creates a new instance of ServersMigrationClient.
func (c *ClientFactory) NewServersMigrationClient() *ServersMigrationClient {
	return &ServersMigrationClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}
