//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
	"net/http"
	"net/url"
	"regexp"
)

// LogProfilesServer is a fake server for instances of the armmonitor.LogProfilesClient type.
type LogProfilesServer struct {
	// CreateOrUpdate is the fake for method LogProfilesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, logProfileName string, parameters armmonitor.LogProfileResource, options *armmonitor.LogProfilesClientCreateOrUpdateOptions) (resp azfake.Responder[armmonitor.LogProfilesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method LogProfilesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK
	Delete func(ctx context.Context, logProfileName string, options *armmonitor.LogProfilesClientDeleteOptions) (resp azfake.Responder[armmonitor.LogProfilesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method LogProfilesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, logProfileName string, options *armmonitor.LogProfilesClientGetOptions) (resp azfake.Responder[armmonitor.LogProfilesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method LogProfilesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armmonitor.LogProfilesClientListOptions) (resp azfake.PagerResponder[armmonitor.LogProfilesClientListResponse])

	// Update is the fake for method LogProfilesClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, logProfileName string, logProfilesResource armmonitor.LogProfileResourcePatch, options *armmonitor.LogProfilesClientUpdateOptions) (resp azfake.Responder[armmonitor.LogProfilesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewLogProfilesServerTransport creates a new instance of LogProfilesServerTransport with the provided implementation.
// The returned LogProfilesServerTransport instance is connected to an instance of armmonitor.LogProfilesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLogProfilesServerTransport(srv *LogProfilesServer) *LogProfilesServerTransport {
	return &LogProfilesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armmonitor.LogProfilesClientListResponse]](),
	}
}

// LogProfilesServerTransport connects instances of armmonitor.LogProfilesClient to instances of LogProfilesServer.
// Don't use this type directly, use NewLogProfilesServerTransport instead.
type LogProfilesServerTransport struct {
	srv          *LogProfilesServer
	newListPager *tracker[azfake.PagerResponder[armmonitor.LogProfilesClientListResponse]]
}

// Do implements the policy.Transporter interface for LogProfilesServerTransport.
func (l *LogProfilesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LogProfilesClient.CreateOrUpdate":
		resp, err = l.dispatchCreateOrUpdate(req)
	case "LogProfilesClient.Delete":
		resp, err = l.dispatchDelete(req)
	case "LogProfilesClient.Get":
		resp, err = l.dispatchGet(req)
	case "LogProfilesClient.NewListPager":
		resp, err = l.dispatchNewListPager(req)
	case "LogProfilesClient.Update":
		resp, err = l.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LogProfilesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if l.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/logprofiles/(?P<logProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmonitor.LogProfileResource](req)
	if err != nil {
		return nil, err
	}
	logProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("logProfileName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.CreateOrUpdate(req.Context(), logProfileNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LogProfileResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LogProfilesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if l.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/logprofiles/(?P<logProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	logProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("logProfileName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.Delete(req.Context(), logProfileNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LogProfilesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if l.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/logprofiles/(?P<logProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	logProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("logProfileName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.Get(req.Context(), logProfileNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LogProfileResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LogProfilesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := l.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/logprofiles`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := l.srv.NewListPager(nil)
		newListPager = &resp
		l.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		l.newListPager.remove(req)
	}
	return resp, nil
}

func (l *LogProfilesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if l.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/logprofiles/(?P<logProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmonitor.LogProfileResourcePatch](req)
	if err != nil {
		return nil, err
	}
	logProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("logProfileName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.Update(req.Context(), logProfileNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LogProfileResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
