//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mariadb/armmariadb"
	"net/http"
	"net/url"
	"regexp"
)

// LocationBasedRecommendedActionSessionsResultServer is a fake server for instances of the armmariadb.LocationBasedRecommendedActionSessionsResultClient type.
type LocationBasedRecommendedActionSessionsResultServer struct {
	// NewListPager is the fake for method LocationBasedRecommendedActionSessionsResultClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	NewListPager func(locationName string, operationID string, options *armmariadb.LocationBasedRecommendedActionSessionsResultClientListOptions) (resp azfake.PagerResponder[armmariadb.LocationBasedRecommendedActionSessionsResultClientListResponse])
}

// NewLocationBasedRecommendedActionSessionsResultServerTransport creates a new instance of LocationBasedRecommendedActionSessionsResultServerTransport with the provided implementation.
// The returned LocationBasedRecommendedActionSessionsResultServerTransport instance is connected to an instance of armmariadb.LocationBasedRecommendedActionSessionsResultClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLocationBasedRecommendedActionSessionsResultServerTransport(srv *LocationBasedRecommendedActionSessionsResultServer) *LocationBasedRecommendedActionSessionsResultServerTransport {
	return &LocationBasedRecommendedActionSessionsResultServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armmariadb.LocationBasedRecommendedActionSessionsResultClientListResponse]](),
	}
}

// LocationBasedRecommendedActionSessionsResultServerTransport connects instances of armmariadb.LocationBasedRecommendedActionSessionsResultClient to instances of LocationBasedRecommendedActionSessionsResultServer.
// Don't use this type directly, use NewLocationBasedRecommendedActionSessionsResultServerTransport instead.
type LocationBasedRecommendedActionSessionsResultServerTransport struct {
	srv          *LocationBasedRecommendedActionSessionsResultServer
	newListPager *tracker[azfake.PagerResponder[armmariadb.LocationBasedRecommendedActionSessionsResultClientListResponse]]
}

// Do implements the policy.Transporter interface for LocationBasedRecommendedActionSessionsResultServerTransport.
func (l *LocationBasedRecommendedActionSessionsResultServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LocationBasedRecommendedActionSessionsResultClient.NewListPager":
		resp, err = l.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LocationBasedRecommendedActionSessionsResultServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := l.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMariaDB/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recommendedActionSessionsOperationResults/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
		if err != nil {
			return nil, err
		}
		resp := l.srv.NewListPager(locationNameParam, operationIDParam, nil)
		newListPager = &resp
		l.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armmariadb.LocationBasedRecommendedActionSessionsResultClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		l.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		l.newListPager.remove(req)
	}
	return resp, nil
}
