//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armlogz.ClientFactory type.
type ServerFactory struct {
	MonitorServer            MonitorServer
	MonitorsServer           MonitorsServer
	OperationsServer         OperationsServer
	SingleSignOnServer       SingleSignOnServer
	SubAccountServer         SubAccountServer
	SubAccountTagRulesServer SubAccountTagRulesServer
	TagRulesServer           TagRulesServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armlogz.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armlogz.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                        *ServerFactory
	trMu                       sync.Mutex
	trMonitorServer            *MonitorServerTransport
	trMonitorsServer           *MonitorsServerTransport
	trOperationsServer         *OperationsServerTransport
	trSingleSignOnServer       *SingleSignOnServerTransport
	trSubAccountServer         *SubAccountServerTransport
	trSubAccountTagRulesServer *SubAccountTagRulesServerTransport
	trTagRulesServer           *TagRulesServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "MonitorClient":
		initServer(s, &s.trMonitorServer, func() *MonitorServerTransport { return NewMonitorServerTransport(&s.srv.MonitorServer) })
		resp, err = s.trMonitorServer.Do(req)
	case "MonitorsClient":
		initServer(s, &s.trMonitorsServer, func() *MonitorsServerTransport { return NewMonitorsServerTransport(&s.srv.MonitorsServer) })
		resp, err = s.trMonitorsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "SingleSignOnClient":
		initServer(s, &s.trSingleSignOnServer, func() *SingleSignOnServerTransport { return NewSingleSignOnServerTransport(&s.srv.SingleSignOnServer) })
		resp, err = s.trSingleSignOnServer.Do(req)
	case "SubAccountClient":
		initServer(s, &s.trSubAccountServer, func() *SubAccountServerTransport { return NewSubAccountServerTransport(&s.srv.SubAccountServer) })
		resp, err = s.trSubAccountServer.Do(req)
	case "SubAccountTagRulesClient":
		initServer(s, &s.trSubAccountTagRulesServer, func() *SubAccountTagRulesServerTransport {
			return NewSubAccountTagRulesServerTransport(&s.srv.SubAccountTagRulesServer)
		})
		resp, err = s.trSubAccountTagRulesServer.Do(req)
	case "TagRulesClient":
		initServer(s, &s.trTagRulesServer, func() *TagRulesServerTransport { return NewTagRulesServerTransport(&s.srv.TagRulesServer) })
		resp, err = s.trTagRulesServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
