//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armiothub_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/iothub/armiothub"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_get.json
func ExampleResourceClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewResourceClient().Get(ctx, "myResourceGroup", "testHub", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Description = armiothub.Description{
	// 	Name: to.Ptr("testHub"),
	// 	Type: to.Ptr("Microsoft.Devices/IotHubs"),
	// 	ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups/myResourceGroup/providers/Microsoft.Devices/IotHubs/testHub"),
	// 	Location: to.Ptr("centraluseuap"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Etag: to.Ptr("AAAAAAFD6M4="),
	// 	Properties: &armiothub.Properties{
	// 		CloudToDevice: &armiothub.CloudToDeviceProperties{
	// 			DefaultTTLAsIso8601: to.Ptr("PT1H"),
	// 			Feedback: &armiothub.FeedbackProperties{
	// 				LockDurationAsIso8601: to.Ptr("PT1M"),
	// 				MaxDeliveryCount: to.Ptr[int32](10),
	// 				TTLAsIso8601: to.Ptr("PT1H"),
	// 			},
	// 			MaxDeliveryCount: to.Ptr[int32](10),
	// 		},
	// 		EnableFileUploadNotifications: to.Ptr(false),
	// 		EventHubEndpoints: map[string]*armiothub.EventHubProperties{
	// 			"events": &armiothub.EventHubProperties{
	// 				Path: to.Ptr("iot-dps-cit-hub-1"),
	// 				Endpoint: to.Ptr("sb://iothub-ns-iot-dps-ci-245306-76aca8e13b.servicebus.windows.net/"),
	// 				PartitionCount: to.Ptr[int32](2),
	// 				PartitionIDs: []*string{
	// 					to.Ptr("0"),
	// 					to.Ptr("1")},
	// 					RetentionTimeInDays: to.Ptr[int64](1),
	// 				},
	// 			},
	// 			Features: to.Ptr(armiothub.CapabilitiesNone),
	// 			HostName: to.Ptr("iot-dps-cit-hub-1.azure-devices.net"),
	// 			IPFilterRules: []*armiothub.IPFilterRule{
	// 				{
	// 					Action: to.Ptr(armiothub.IPFilterActionTypeAccept),
	// 					FilterName: to.Ptr("rule1"),
	// 					IPMask: to.Ptr("131.117.159.53"),
	// 				},
	// 				{
	// 					Action: to.Ptr(armiothub.IPFilterActionTypeAccept),
	// 					FilterName: to.Ptr("rule2"),
	// 					IPMask: to.Ptr("157.55.59.128/25"),
	// 			}},
	// 			Locations: []*armiothub.LocationDescription{
	// 				{
	// 					Location: to.Ptr("West US"),
	// 					Role: to.Ptr(armiothub.IotHubReplicaRoleTypePrimary),
	// 				},
	// 				{
	// 					Location: to.Ptr("East US"),
	// 					Role: to.Ptr(armiothub.IotHubReplicaRoleTypeSecondary),
	// 			}},
	// 			MessagingEndpoints: map[string]*armiothub.MessagingEndpointProperties{
	// 				"fileNotifications": &armiothub.MessagingEndpointProperties{
	// 					LockDurationAsIso8601: to.Ptr("PT1M"),
	// 					MaxDeliveryCount: to.Ptr[int32](10),
	// 					TTLAsIso8601: to.Ptr("PT1H"),
	// 				},
	// 			},
	// 			MinTLSVersion: to.Ptr("1.2"),
	// 			NetworkRuleSets: &armiothub.NetworkRuleSetProperties{
	// 				ApplyToBuiltInEventHubEndpoint: to.Ptr(true),
	// 				DefaultAction: to.Ptr(armiothub.DefaultActionDeny),
	// 				IPRules: []*armiothub.NetworkRuleSetIPRule{
	// 					{
	// 						Action: to.Ptr(armiothub.NetworkRuleIPActionAllow),
	// 						FilterName: to.Ptr("rule1"),
	// 						IPMask: to.Ptr("131.117.159.53"),
	// 					},
	// 					{
	// 						Action: to.Ptr(armiothub.NetworkRuleIPActionAllow),
	// 						FilterName: to.Ptr("rule2"),
	// 						IPMask: to.Ptr("157.55.59.128/25"),
	// 				}},
	// 			},
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			Routing: &armiothub.RoutingProperties{
	// 				Endpoints: &armiothub.RoutingEndpoints{
	// 					EventHubs: []*armiothub.RoutingEventHubProperties{
	// 					},
	// 					ServiceBusQueues: []*armiothub.RoutingServiceBusQueueEndpointProperties{
	// 					},
	// 					ServiceBusTopics: []*armiothub.RoutingServiceBusTopicEndpointProperties{
	// 					},
	// 					StorageContainers: []*armiothub.RoutingStorageContainerProperties{
	// 					},
	// 				},
	// 				FallbackRoute: &armiothub.FallbackRouteProperties{
	// 					Condition: to.Ptr("true"),
	// 					EndpointNames: []*string{
	// 						to.Ptr("events")},
	// 						IsEnabled: to.Ptr(true),
	// 						Source: to.Ptr(armiothub.RoutingSourceDeviceMessages),
	// 					},
	// 					Routes: []*armiothub.RouteProperties{
	// 					},
	// 				},
	// 				State: to.Ptr("Active"),
	// 				StorageEndpoints: map[string]*armiothub.StorageEndpointProperties{
	// 					"$default": &armiothub.StorageEndpointProperties{
	// 						ConnectionString: to.Ptr(""),
	// 						ContainerName: to.Ptr(""),
	// 						SasTTLAsIso8601: to.Ptr("PT1H"),
	// 					},
	// 				},
	// 			},
	// 			SKU: &armiothub.SKUInfo{
	// 				Name: to.Ptr(armiothub.IotHubSKUS1),
	// 				Capacity: to.Ptr[int64](1),
	// 				Tier: to.Ptr(armiothub.IotHubSKUTierStandard),
	// 			},
	// 			SystemData: &armiothub.SystemData{
	// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-30T00:28:38.963Z"); return t}()),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_addRoutingCosmosDBEndpoint.json
func ExampleResourceClient_BeginCreateOrUpdate_iotHubResourceAddCosmosDbEndpoint() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewResourceClient().BeginCreateOrUpdate(ctx, "myResourceGroup", "testHub", armiothub.Description{
		Location: to.Ptr("centraluseuap"),
		Tags:     map[string]*string{},
		Etag:     to.Ptr("AAAAAAFD6M4="),
		Properties: &armiothub.Properties{
			CloudToDevice: &armiothub.CloudToDeviceProperties{
				DefaultTTLAsIso8601: to.Ptr("PT1H"),
				Feedback: &armiothub.FeedbackProperties{
					LockDurationAsIso8601: to.Ptr("PT1M"),
					MaxDeliveryCount:      to.Ptr[int32](10),
					TTLAsIso8601:          to.Ptr("PT1H"),
				},
				MaxDeliveryCount: to.Ptr[int32](10),
			},
			EnableDataResidency:           to.Ptr(false),
			EnableFileUploadNotifications: to.Ptr(false),
			EventHubEndpoints: map[string]*armiothub.EventHubProperties{
				"events": {
					PartitionCount:      to.Ptr[int32](2),
					RetentionTimeInDays: to.Ptr[int64](1),
				},
			},
			Features:      to.Ptr(armiothub.CapabilitiesNone),
			IPFilterRules: []*armiothub.IPFilterRule{},
			MessagingEndpoints: map[string]*armiothub.MessagingEndpointProperties{
				"fileNotifications": {
					LockDurationAsIso8601: to.Ptr("PT1M"),
					MaxDeliveryCount:      to.Ptr[int32](10),
					TTLAsIso8601:          to.Ptr("PT1H"),
				},
			},
			MinTLSVersion: to.Ptr("1.2"),
			NetworkRuleSets: &armiothub.NetworkRuleSetProperties{
				ApplyToBuiltInEventHubEndpoint: to.Ptr(true),
				DefaultAction:                  to.Ptr(armiothub.DefaultActionDeny),
				IPRules: []*armiothub.NetworkRuleSetIPRule{
					{
						Action:     to.Ptr(armiothub.NetworkRuleIPActionAllow),
						FilterName: to.Ptr("rule1"),
						IPMask:     to.Ptr("131.117.159.53"),
					},
					{
						Action:     to.Ptr(armiothub.NetworkRuleIPActionAllow),
						FilterName: to.Ptr("rule2"),
						IPMask:     to.Ptr("157.55.59.128/25"),
					}},
			},
			Routing: &armiothub.RoutingProperties{
				Endpoints: &armiothub.RoutingEndpoints{
					CosmosDBSQLContainers: []*armiothub.RoutingCosmosDBSQLAPIProperties{
						{
							Name:                 to.Ptr("endpointcosmos"),
							AuthenticationType:   to.Ptr(armiothub.AuthenticationTypeKeyBased),
							ContainerName:        to.Ptr("test"),
							DatabaseName:         to.Ptr("systemstore"),
							EndpointURI:          to.Ptr("https://test-systemstore-test2.documents.azure.com"),
							PartitionKeyName:     to.Ptr("keystamped"),
							PartitionKeyTemplate: to.Ptr("{deviceid}-{YYYY}-{MM}"),
							PrimaryKey:           to.Ptr("<primary-key>"),
							ResourceGroup:        to.Ptr("rg-test"),
							SecondaryKey:         to.Ptr("<secondary-key>"),
							SubscriptionID:       to.Ptr("<subscription-id>"),
						}},
					EventHubs:         []*armiothub.RoutingEventHubProperties{},
					ServiceBusQueues:  []*armiothub.RoutingServiceBusQueueEndpointProperties{},
					ServiceBusTopics:  []*armiothub.RoutingServiceBusTopicEndpointProperties{},
					StorageContainers: []*armiothub.RoutingStorageContainerProperties{},
				},
				FallbackRoute: &armiothub.FallbackRouteProperties{
					Name:      to.Ptr("$fallback"),
					Condition: to.Ptr("true"),
					EndpointNames: []*string{
						to.Ptr("events")},
					IsEnabled: to.Ptr(true),
					Source:    to.Ptr(armiothub.RoutingSourceDeviceMessages),
				},
				Routes: []*armiothub.RouteProperties{},
			},
			StorageEndpoints: map[string]*armiothub.StorageEndpointProperties{
				"$default": {
					ConnectionString: to.Ptr(""),
					ContainerName:    to.Ptr(""),
					SasTTLAsIso8601:  to.Ptr("PT1H"),
				},
			},
		},
		SKU: &armiothub.SKUInfo{
			Name:     to.Ptr(armiothub.IotHubSKUS1),
			Capacity: to.Ptr[int64](1),
		},
	}, &armiothub.ResourceClientBeginCreateOrUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Description = armiothub.Description{
	// 	Name: to.Ptr("testHub"),
	// 	Type: to.Ptr("Microsoft.Devices/IotHubs"),
	// 	ID: to.Ptr("/subscriptions/ae24ff83-d2ca-4fc8-9717-05dae4bba489/resourceGroups/myResourceGroup/providers/Microsoft.Devices/IotHubs/testHub"),
	// 	Location: to.Ptr("centraluseuap"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Etag: to.Ptr("AAAAAAFD6M4="),
	// 	Properties: &armiothub.Properties{
	// 		CloudToDevice: &armiothub.CloudToDeviceProperties{
	// 			DefaultTTLAsIso8601: to.Ptr("PT1H"),
	// 			Feedback: &armiothub.FeedbackProperties{
	// 				LockDurationAsIso8601: to.Ptr("PT1M"),
	// 				MaxDeliveryCount: to.Ptr[int32](10),
	// 				TTLAsIso8601: to.Ptr("PT1H"),
	// 			},
	// 			MaxDeliveryCount: to.Ptr[int32](10),
	// 		},
	// 		EnableDataResidency: to.Ptr(false),
	// 		EnableFileUploadNotifications: to.Ptr(false),
	// 		EventHubEndpoints: map[string]*armiothub.EventHubProperties{
	// 			"events": &armiothub.EventHubProperties{
	// 				Path: to.Ptr("iot-dps-cit-hub-1"),
	// 				Endpoint: to.Ptr("sb://iothub-ns-iot-dps-ci-245306-76aca8e13b.servicebus.windows.net/"),
	// 				PartitionCount: to.Ptr[int32](2),
	// 				PartitionIDs: []*string{
	// 					to.Ptr("0"),
	// 					to.Ptr("1")},
	// 					RetentionTimeInDays: to.Ptr[int64](1),
	// 				},
	// 			},
	// 			Features: to.Ptr(armiothub.CapabilitiesNone),
	// 			HostName: to.Ptr("iot-dps-cit-hub-1.azure-devices.net"),
	// 			IPFilterRules: []*armiothub.IPFilterRule{
	// 				{
	// 					Action: to.Ptr(armiothub.IPFilterActionTypeAccept),
	// 					FilterName: to.Ptr("rule1"),
	// 					IPMask: to.Ptr("131.117.159.53"),
	// 				},
	// 				{
	// 					Action: to.Ptr(armiothub.IPFilterActionTypeAccept),
	// 					FilterName: to.Ptr("rule2"),
	// 					IPMask: to.Ptr("157.55.59.128/25"),
	// 			}},
	// 			MessagingEndpoints: map[string]*armiothub.MessagingEndpointProperties{
	// 				"fileNotifications": &armiothub.MessagingEndpointProperties{
	// 					LockDurationAsIso8601: to.Ptr("PT1M"),
	// 					MaxDeliveryCount: to.Ptr[int32](10),
	// 					TTLAsIso8601: to.Ptr("PT1H"),
	// 				},
	// 			},
	// 			MinTLSVersion: to.Ptr("1.2"),
	// 			NetworkRuleSets: &armiothub.NetworkRuleSetProperties{
	// 				ApplyToBuiltInEventHubEndpoint: to.Ptr(true),
	// 				DefaultAction: to.Ptr(armiothub.DefaultActionDeny),
	// 				IPRules: []*armiothub.NetworkRuleSetIPRule{
	// 					{
	// 						Action: to.Ptr(armiothub.NetworkRuleIPActionAllow),
	// 						FilterName: to.Ptr("rule1"),
	// 						IPMask: to.Ptr("131.117.159.53"),
	// 					},
	// 					{
	// 						Action: to.Ptr(armiothub.NetworkRuleIPActionAllow),
	// 						FilterName: to.Ptr("rule2"),
	// 						IPMask: to.Ptr("157.55.59.128/25"),
	// 				}},
	// 			},
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			Routing: &armiothub.RoutingProperties{
	// 				Endpoints: &armiothub.RoutingEndpoints{
	// 					CosmosDBSQLContainers: []*armiothub.RoutingCosmosDBSQLAPIProperties{
	// 						{
	// 							Name: to.Ptr("endpointcosmos"),
	// 							AuthenticationType: to.Ptr(armiothub.AuthenticationTypeKeyBased),
	// 							ContainerName: to.Ptr("test"),
	// 							DatabaseName: to.Ptr("systemstore"),
	// 							EndpointURI: to.Ptr("https://test-systemstore-test2.documents.azure.com"),
	// 							ID: to.Ptr("009208fa-9cb7-4b90-bfbd-f40086e766c9"),
	// 							PartitionKeyName: to.Ptr("keystamped"),
	// 							PartitionKeyTemplate: to.Ptr("{deviceid}-{YYYY}-{MM}"),
	// 							ResourceGroup: to.Ptr("rg-test"),
	// 							SubscriptionID: to.Ptr("<subscription-id>"),
	// 					}},
	// 					EventHubs: []*armiothub.RoutingEventHubProperties{
	// 					},
	// 					ServiceBusQueues: []*armiothub.RoutingServiceBusQueueEndpointProperties{
	// 					},
	// 					ServiceBusTopics: []*armiothub.RoutingServiceBusTopicEndpointProperties{
	// 					},
	// 					StorageContainers: []*armiothub.RoutingStorageContainerProperties{
	// 					},
	// 				},
	// 				FallbackRoute: &armiothub.FallbackRouteProperties{
	// 					Name: to.Ptr("$fallback"),
	// 					Condition: to.Ptr("true"),
	// 					EndpointNames: []*string{
	// 						to.Ptr("events")},
	// 						IsEnabled: to.Ptr(true),
	// 						Source: to.Ptr(armiothub.RoutingSourceDeviceMessages),
	// 					},
	// 					Routes: []*armiothub.RouteProperties{
	// 					},
	// 				},
	// 				State: to.Ptr("Active"),
	// 				StorageEndpoints: map[string]*armiothub.StorageEndpointProperties{
	// 					"$default": &armiothub.StorageEndpointProperties{
	// 						ConnectionString: to.Ptr(""),
	// 						ContainerName: to.Ptr(""),
	// 						SasTTLAsIso8601: to.Ptr("PT1H"),
	// 					},
	// 				},
	// 			},
	// 			SKU: &armiothub.SKUInfo{
	// 				Name: to.Ptr(armiothub.IotHubSKUS1),
	// 				Capacity: to.Ptr[int64](1),
	// 				Tier: to.Ptr(armiothub.IotHubSKUTierStandard),
	// 			},
	// 			SystemData: &armiothub.SystemData{
	// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-30T00:28:38.963Z"); return t}()),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_createOrUpdate.json
func ExampleResourceClient_BeginCreateOrUpdate_iotHubResourceCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewResourceClient().BeginCreateOrUpdate(ctx, "myResourceGroup", "testHub", armiothub.Description{
		Location: to.Ptr("centraluseuap"),
		Tags:     map[string]*string{},
		Etag:     to.Ptr("AAAAAAFD6M4="),
		Properties: &armiothub.Properties{
			CloudToDevice: &armiothub.CloudToDeviceProperties{
				DefaultTTLAsIso8601: to.Ptr("PT1H"),
				Feedback: &armiothub.FeedbackProperties{
					LockDurationAsIso8601: to.Ptr("PT1M"),
					MaxDeliveryCount:      to.Ptr[int32](10),
					TTLAsIso8601:          to.Ptr("PT1H"),
				},
				MaxDeliveryCount: to.Ptr[int32](10),
			},
			EnableDataResidency:           to.Ptr(false),
			EnableFileUploadNotifications: to.Ptr(false),
			EventHubEndpoints: map[string]*armiothub.EventHubProperties{
				"events": {
					PartitionCount:      to.Ptr[int32](2),
					RetentionTimeInDays: to.Ptr[int64](1),
				},
			},
			Features:      to.Ptr(armiothub.CapabilitiesNone),
			IPFilterRules: []*armiothub.IPFilterRule{},
			MessagingEndpoints: map[string]*armiothub.MessagingEndpointProperties{
				"fileNotifications": {
					LockDurationAsIso8601: to.Ptr("PT1M"),
					MaxDeliveryCount:      to.Ptr[int32](10),
					TTLAsIso8601:          to.Ptr("PT1H"),
				},
			},
			MinTLSVersion: to.Ptr("1.2"),
			NetworkRuleSets: &armiothub.NetworkRuleSetProperties{
				ApplyToBuiltInEventHubEndpoint: to.Ptr(true),
				DefaultAction:                  to.Ptr(armiothub.DefaultActionDeny),
				IPRules: []*armiothub.NetworkRuleSetIPRule{
					{
						Action:     to.Ptr(armiothub.NetworkRuleIPActionAllow),
						FilterName: to.Ptr("rule1"),
						IPMask:     to.Ptr("131.117.159.53"),
					},
					{
						Action:     to.Ptr(armiothub.NetworkRuleIPActionAllow),
						FilterName: to.Ptr("rule2"),
						IPMask:     to.Ptr("157.55.59.128/25"),
					}},
			},
			Routing: &armiothub.RoutingProperties{
				Endpoints: &armiothub.RoutingEndpoints{
					EventHubs:         []*armiothub.RoutingEventHubProperties{},
					ServiceBusQueues:  []*armiothub.RoutingServiceBusQueueEndpointProperties{},
					ServiceBusTopics:  []*armiothub.RoutingServiceBusTopicEndpointProperties{},
					StorageContainers: []*armiothub.RoutingStorageContainerProperties{},
				},
				FallbackRoute: &armiothub.FallbackRouteProperties{
					Name:      to.Ptr("$fallback"),
					Condition: to.Ptr("true"),
					EndpointNames: []*string{
						to.Ptr("events")},
					IsEnabled: to.Ptr(true),
					Source:    to.Ptr(armiothub.RoutingSourceDeviceMessages),
				},
				Routes: []*armiothub.RouteProperties{},
			},
			StorageEndpoints: map[string]*armiothub.StorageEndpointProperties{
				"$default": {
					ConnectionString: to.Ptr(""),
					ContainerName:    to.Ptr(""),
					SasTTLAsIso8601:  to.Ptr("PT1H"),
				},
			},
		},
		SKU: &armiothub.SKUInfo{
			Name:     to.Ptr(armiothub.IotHubSKUS1),
			Capacity: to.Ptr[int64](1),
		},
	}, &armiothub.ResourceClientBeginCreateOrUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Description = armiothub.Description{
	// 	Name: to.Ptr("testHub"),
	// 	Type: to.Ptr("Microsoft.Devices/IotHubs"),
	// 	ID: to.Ptr("/subscriptions/ae24ff83-d2ca-4fc8-9717-05dae4bba489/resourceGroups/myResourceGroup/providers/Microsoft.Devices/IotHubs/testHub"),
	// 	Location: to.Ptr("centraluseuap"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Etag: to.Ptr("AAAAAAFD6M4="),
	// 	Properties: &armiothub.Properties{
	// 		CloudToDevice: &armiothub.CloudToDeviceProperties{
	// 			DefaultTTLAsIso8601: to.Ptr("PT1H"),
	// 			Feedback: &armiothub.FeedbackProperties{
	// 				LockDurationAsIso8601: to.Ptr("PT1M"),
	// 				MaxDeliveryCount: to.Ptr[int32](10),
	// 				TTLAsIso8601: to.Ptr("PT1H"),
	// 			},
	// 			MaxDeliveryCount: to.Ptr[int32](10),
	// 		},
	// 		EnableDataResidency: to.Ptr(false),
	// 		EnableFileUploadNotifications: to.Ptr(false),
	// 		EventHubEndpoints: map[string]*armiothub.EventHubProperties{
	// 			"events": &armiothub.EventHubProperties{
	// 				Path: to.Ptr("iot-dps-cit-hub-1"),
	// 				Endpoint: to.Ptr("sb://iothub-ns-iot-dps-ci-245306-76aca8e13b.servicebus.windows.net/"),
	// 				PartitionCount: to.Ptr[int32](2),
	// 				PartitionIDs: []*string{
	// 					to.Ptr("0"),
	// 					to.Ptr("1")},
	// 					RetentionTimeInDays: to.Ptr[int64](1),
	// 				},
	// 			},
	// 			Features: to.Ptr(armiothub.CapabilitiesNone),
	// 			HostName: to.Ptr("iot-dps-cit-hub-1.azure-devices.net"),
	// 			IPFilterRules: []*armiothub.IPFilterRule{
	// 				{
	// 					Action: to.Ptr(armiothub.IPFilterActionTypeAccept),
	// 					FilterName: to.Ptr("rule1"),
	// 					IPMask: to.Ptr("131.117.159.53"),
	// 				},
	// 				{
	// 					Action: to.Ptr(armiothub.IPFilterActionTypeAccept),
	// 					FilterName: to.Ptr("rule2"),
	// 					IPMask: to.Ptr("157.55.59.128/25"),
	// 			}},
	// 			MessagingEndpoints: map[string]*armiothub.MessagingEndpointProperties{
	// 				"fileNotifications": &armiothub.MessagingEndpointProperties{
	// 					LockDurationAsIso8601: to.Ptr("PT1M"),
	// 					MaxDeliveryCount: to.Ptr[int32](10),
	// 					TTLAsIso8601: to.Ptr("PT1H"),
	// 				},
	// 			},
	// 			MinTLSVersion: to.Ptr("1.2"),
	// 			NetworkRuleSets: &armiothub.NetworkRuleSetProperties{
	// 				ApplyToBuiltInEventHubEndpoint: to.Ptr(true),
	// 				DefaultAction: to.Ptr(armiothub.DefaultActionDeny),
	// 				IPRules: []*armiothub.NetworkRuleSetIPRule{
	// 					{
	// 						Action: to.Ptr(armiothub.NetworkRuleIPActionAllow),
	// 						FilterName: to.Ptr("rule1"),
	// 						IPMask: to.Ptr("131.117.159.53"),
	// 					},
	// 					{
	// 						Action: to.Ptr(armiothub.NetworkRuleIPActionAllow),
	// 						FilterName: to.Ptr("rule2"),
	// 						IPMask: to.Ptr("157.55.59.128/25"),
	// 				}},
	// 			},
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			Routing: &armiothub.RoutingProperties{
	// 				Endpoints: &armiothub.RoutingEndpoints{
	// 					EventHubs: []*armiothub.RoutingEventHubProperties{
	// 					},
	// 					ServiceBusQueues: []*armiothub.RoutingServiceBusQueueEndpointProperties{
	// 					},
	// 					ServiceBusTopics: []*armiothub.RoutingServiceBusTopicEndpointProperties{
	// 					},
	// 					StorageContainers: []*armiothub.RoutingStorageContainerProperties{
	// 					},
	// 				},
	// 				FallbackRoute: &armiothub.FallbackRouteProperties{
	// 					Name: to.Ptr("$fallback"),
	// 					Condition: to.Ptr("true"),
	// 					EndpointNames: []*string{
	// 						to.Ptr("events")},
	// 						IsEnabled: to.Ptr(true),
	// 						Source: to.Ptr(armiothub.RoutingSourceDeviceMessages),
	// 					},
	// 					Routes: []*armiothub.RouteProperties{
	// 					},
	// 				},
	// 				State: to.Ptr("Active"),
	// 				StorageEndpoints: map[string]*armiothub.StorageEndpointProperties{
	// 					"$default": &armiothub.StorageEndpointProperties{
	// 						ConnectionString: to.Ptr(""),
	// 						ContainerName: to.Ptr(""),
	// 						SasTTLAsIso8601: to.Ptr("PT1H"),
	// 					},
	// 				},
	// 			},
	// 			SKU: &armiothub.SKUInfo{
	// 				Name: to.Ptr(armiothub.IotHubSKUS1),
	// 				Capacity: to.Ptr[int64](1),
	// 				Tier: to.Ptr(armiothub.IotHubSKUTierStandard),
	// 			},
	// 			SystemData: &armiothub.SystemData{
	// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-30T00:28:38.963Z"); return t}()),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_patch.json
func ExampleResourceClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewResourceClient().BeginUpdate(ctx, "myResourceGroup", "myHub", armiothub.TagsResource{
		Tags: map[string]*string{
			"foo": to.Ptr("bar"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Description = armiothub.Description{
	// 	Name: to.Ptr("testHub"),
	// 	Type: to.Ptr("Microsoft.Devices/IotHubs"),
	// 	ID: to.Ptr("/subscriptions/ae24ff83-d2ca-4fc8-9717-05dae4bba489/resourceGroups/myResourceGroup/providers/Microsoft.Devices/IotHubs/testHub"),
	// 	Location: to.Ptr("centraluseuap"),
	// 	Tags: map[string]*string{
	// 		"foo": to.Ptr("bar"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAFD6M4="),
	// 	Properties: &armiothub.Properties{
	// 		CloudToDevice: &armiothub.CloudToDeviceProperties{
	// 			DefaultTTLAsIso8601: to.Ptr("PT1H"),
	// 			Feedback: &armiothub.FeedbackProperties{
	// 				LockDurationAsIso8601: to.Ptr("PT1M"),
	// 				MaxDeliveryCount: to.Ptr[int32](10),
	// 				TTLAsIso8601: to.Ptr("PT1H"),
	// 			},
	// 			MaxDeliveryCount: to.Ptr[int32](10),
	// 		},
	// 		EnableFileUploadNotifications: to.Ptr(false),
	// 		EventHubEndpoints: map[string]*armiothub.EventHubProperties{
	// 			"events": &armiothub.EventHubProperties{
	// 				Path: to.Ptr("iot-dps-cit-hub-1"),
	// 				Endpoint: to.Ptr("sb://iothub-ns-iot-dps-ci-245306-76aca8e13b.servicebus.windows.net/"),
	// 				PartitionCount: to.Ptr[int32](2),
	// 				PartitionIDs: []*string{
	// 					to.Ptr("0"),
	// 					to.Ptr("1")},
	// 					RetentionTimeInDays: to.Ptr[int64](1),
	// 				},
	// 			},
	// 			Features: to.Ptr(armiothub.CapabilitiesNone),
	// 			HostName: to.Ptr("iot-dps-cit-hub-1.azure-devices.net"),
	// 			IPFilterRules: []*armiothub.IPFilterRule{
	// 				{
	// 					Action: to.Ptr(armiothub.IPFilterActionTypeAccept),
	// 					FilterName: to.Ptr("rule1"),
	// 					IPMask: to.Ptr("131.117.159.53"),
	// 				},
	// 				{
	// 					Action: to.Ptr(armiothub.IPFilterActionTypeAccept),
	// 					FilterName: to.Ptr("rule2"),
	// 					IPMask: to.Ptr("157.55.59.128/25"),
	// 			}},
	// 			MessagingEndpoints: map[string]*armiothub.MessagingEndpointProperties{
	// 				"fileNotifications": &armiothub.MessagingEndpointProperties{
	// 					LockDurationAsIso8601: to.Ptr("PT1M"),
	// 					MaxDeliveryCount: to.Ptr[int32](10),
	// 					TTLAsIso8601: to.Ptr("PT1H"),
	// 				},
	// 			},
	// 			NetworkRuleSets: &armiothub.NetworkRuleSetProperties{
	// 				ApplyToBuiltInEventHubEndpoint: to.Ptr(true),
	// 				DefaultAction: to.Ptr(armiothub.DefaultActionDeny),
	// 				IPRules: []*armiothub.NetworkRuleSetIPRule{
	// 					{
	// 						Action: to.Ptr(armiothub.NetworkRuleIPActionAllow),
	// 						FilterName: to.Ptr("rule1"),
	// 						IPMask: to.Ptr("131.117.159.53"),
	// 					},
	// 					{
	// 						Action: to.Ptr(armiothub.NetworkRuleIPActionAllow),
	// 						FilterName: to.Ptr("rule2"),
	// 						IPMask: to.Ptr("157.55.59.128/25"),
	// 				}},
	// 			},
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			Routing: &armiothub.RoutingProperties{
	// 				Endpoints: &armiothub.RoutingEndpoints{
	// 					EventHubs: []*armiothub.RoutingEventHubProperties{
	// 					},
	// 					ServiceBusQueues: []*armiothub.RoutingServiceBusQueueEndpointProperties{
	// 					},
	// 					ServiceBusTopics: []*armiothub.RoutingServiceBusTopicEndpointProperties{
	// 					},
	// 					StorageContainers: []*armiothub.RoutingStorageContainerProperties{
	// 					},
	// 				},
	// 				FallbackRoute: &armiothub.FallbackRouteProperties{
	// 					Name: to.Ptr("$fallback"),
	// 					Condition: to.Ptr("true"),
	// 					EndpointNames: []*string{
	// 						to.Ptr("events")},
	// 						IsEnabled: to.Ptr(true),
	// 						Source: to.Ptr(armiothub.RoutingSourceDeviceMessages),
	// 					},
	// 					Routes: []*armiothub.RouteProperties{
	// 					},
	// 				},
	// 				State: to.Ptr("Active"),
	// 				StorageEndpoints: map[string]*armiothub.StorageEndpointProperties{
	// 					"$default": &armiothub.StorageEndpointProperties{
	// 						ConnectionString: to.Ptr(""),
	// 						ContainerName: to.Ptr(""),
	// 						SasTTLAsIso8601: to.Ptr("PT1H"),
	// 					},
	// 				},
	// 			},
	// 			SKU: &armiothub.SKUInfo{
	// 				Name: to.Ptr(armiothub.IotHubSKUS1),
	// 				Capacity: to.Ptr[int64](1),
	// 				Tier: to.Ptr(armiothub.IotHubSKUTierStandard),
	// 			},
	// 			SystemData: &armiothub.SystemData{
	// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-30T00:28:38.963Z"); return t}()),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_delete.json
func ExampleResourceClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewResourceClient().BeginDelete(ctx, "myResourceGroup", "testHub", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Description = armiothub.Description{
	// 	Name: to.Ptr("testHub"),
	// 	Type: to.Ptr("Microsoft.Devices/IotHubs"),
	// 	ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups/myResourceGroup/providers/Microsoft.Devices/IotHubs/testHub"),
	// 	Location: to.Ptr("centraluseuap"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Etag: to.Ptr("AAAAAAFD6M4="),
	// 	Properties: &armiothub.Properties{
	// 		CloudToDevice: &armiothub.CloudToDeviceProperties{
	// 			DefaultTTLAsIso8601: to.Ptr("PT1H"),
	// 			Feedback: &armiothub.FeedbackProperties{
	// 				LockDurationAsIso8601: to.Ptr("PT1M"),
	// 				MaxDeliveryCount: to.Ptr[int32](10),
	// 				TTLAsIso8601: to.Ptr("PT1H"),
	// 			},
	// 			MaxDeliveryCount: to.Ptr[int32](10),
	// 		},
	// 		EnableFileUploadNotifications: to.Ptr(false),
	// 		EventHubEndpoints: map[string]*armiothub.EventHubProperties{
	// 			"events": &armiothub.EventHubProperties{
	// 				Path: to.Ptr("iot-dps-cit-hub-1"),
	// 				Endpoint: to.Ptr("sb://iothub-ns-iot-dps-ci-245306-76aca8e13b.servicebus.windows.net/"),
	// 				PartitionCount: to.Ptr[int32](2),
	// 				PartitionIDs: []*string{
	// 					to.Ptr("0"),
	// 					to.Ptr("1")},
	// 					RetentionTimeInDays: to.Ptr[int64](1),
	// 				},
	// 			},
	// 			Features: to.Ptr(armiothub.CapabilitiesNone),
	// 			HostName: to.Ptr("iot-dps-cit-hub-1.azure-devices.net"),
	// 			IPFilterRules: []*armiothub.IPFilterRule{
	// 				{
	// 					Action: to.Ptr(armiothub.IPFilterActionTypeAccept),
	// 					FilterName: to.Ptr("rule1"),
	// 					IPMask: to.Ptr("131.117.159.53"),
	// 				},
	// 				{
	// 					Action: to.Ptr(armiothub.IPFilterActionTypeAccept),
	// 					FilterName: to.Ptr("rule2"),
	// 					IPMask: to.Ptr("157.55.59.128/25"),
	// 			}},
	// 			MessagingEndpoints: map[string]*armiothub.MessagingEndpointProperties{
	// 				"fileNotifications": &armiothub.MessagingEndpointProperties{
	// 					LockDurationAsIso8601: to.Ptr("PT1M"),
	// 					MaxDeliveryCount: to.Ptr[int32](10),
	// 					TTLAsIso8601: to.Ptr("PT1H"),
	// 				},
	// 			},
	// 			NetworkRuleSets: &armiothub.NetworkRuleSetProperties{
	// 				ApplyToBuiltInEventHubEndpoint: to.Ptr(true),
	// 				DefaultAction: to.Ptr(armiothub.DefaultActionDeny),
	// 				IPRules: []*armiothub.NetworkRuleSetIPRule{
	// 					{
	// 						Action: to.Ptr(armiothub.NetworkRuleIPActionAllow),
	// 						FilterName: to.Ptr("rule1"),
	// 						IPMask: to.Ptr("131.117.159.53"),
	// 					},
	// 					{
	// 						Action: to.Ptr(armiothub.NetworkRuleIPActionAllow),
	// 						FilterName: to.Ptr("rule2"),
	// 						IPMask: to.Ptr("157.55.59.128/25"),
	// 				}},
	// 			},
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			Routing: &armiothub.RoutingProperties{
	// 				Endpoints: &armiothub.RoutingEndpoints{
	// 					EventHubs: []*armiothub.RoutingEventHubProperties{
	// 					},
	// 					ServiceBusQueues: []*armiothub.RoutingServiceBusQueueEndpointProperties{
	// 					},
	// 					ServiceBusTopics: []*armiothub.RoutingServiceBusTopicEndpointProperties{
	// 					},
	// 					StorageContainers: []*armiothub.RoutingStorageContainerProperties{
	// 					},
	// 				},
	// 				FallbackRoute: &armiothub.FallbackRouteProperties{
	// 					Condition: to.Ptr("true"),
	// 					EndpointNames: []*string{
	// 						to.Ptr("events")},
	// 						IsEnabled: to.Ptr(true),
	// 						Source: to.Ptr(armiothub.RoutingSourceDeviceMessages),
	// 					},
	// 					Routes: []*armiothub.RouteProperties{
	// 					},
	// 				},
	// 				State: to.Ptr("Active"),
	// 				StorageEndpoints: map[string]*armiothub.StorageEndpointProperties{
	// 					"$default": &armiothub.StorageEndpointProperties{
	// 						ConnectionString: to.Ptr(""),
	// 						ContainerName: to.Ptr(""),
	// 						SasTTLAsIso8601: to.Ptr("PT1H"),
	// 					},
	// 				},
	// 			},
	// 			SKU: &armiothub.SKUInfo{
	// 				Name: to.Ptr(armiothub.IotHubSKUS1),
	// 				Capacity: to.Ptr[int64](1),
	// 				Tier: to.Ptr(armiothub.IotHubSKUTierStandard),
	// 			},
	// 			SystemData: &armiothub.SystemData{
	// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-30T00:28:38.963Z"); return t}()),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_listbysubscription.json
func ExampleResourceClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewResourceClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DescriptionListResult = armiothub.DescriptionListResult{
		// 	Value: []*armiothub.Description{
		// 		{
		// 			Name: to.Ptr("testHub"),
		// 			Type: to.Ptr("Microsoft.Devices/IotHubs"),
		// 			ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups/myResourceGroup/providers/Microsoft.Devices/IotHubs/testHub"),
		// 			Location: to.Ptr("centraluseuap"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Etag: to.Ptr("AAAAAAFD6M4="),
		// 			Properties: &armiothub.Properties{
		// 				CloudToDevice: &armiothub.CloudToDeviceProperties{
		// 					DefaultTTLAsIso8601: to.Ptr("PT1H"),
		// 					Feedback: &armiothub.FeedbackProperties{
		// 						LockDurationAsIso8601: to.Ptr("PT1M"),
		// 						MaxDeliveryCount: to.Ptr[int32](10),
		// 						TTLAsIso8601: to.Ptr("PT1H"),
		// 					},
		// 					MaxDeliveryCount: to.Ptr[int32](10),
		// 				},
		// 				EnableFileUploadNotifications: to.Ptr(false),
		// 				EventHubEndpoints: map[string]*armiothub.EventHubProperties{
		// 					"events": &armiothub.EventHubProperties{
		// 						Path: to.Ptr("iot-dps-cit-hub-1"),
		// 						Endpoint: to.Ptr("sb://iothub-ns-iot-dps-ci-245306-76aca8e13b.servicebus.windows.net/"),
		// 						PartitionCount: to.Ptr[int32](2),
		// 						PartitionIDs: []*string{
		// 							to.Ptr("0"),
		// 							to.Ptr("1")},
		// 							RetentionTimeInDays: to.Ptr[int64](1),
		// 						},
		// 					},
		// 					Features: to.Ptr(armiothub.CapabilitiesNone),
		// 					HostName: to.Ptr("iot-dps-cit-hub-1.azure-devices.net"),
		// 					IPFilterRules: []*armiothub.IPFilterRule{
		// 						{
		// 							Action: to.Ptr(armiothub.IPFilterActionTypeAccept),
		// 							FilterName: to.Ptr("rule1"),
		// 							IPMask: to.Ptr("131.117.159.53"),
		// 						},
		// 						{
		// 							Action: to.Ptr(armiothub.IPFilterActionTypeAccept),
		// 							FilterName: to.Ptr("rule2"),
		// 							IPMask: to.Ptr("157.55.59.128/25"),
		// 					}},
		// 					MessagingEndpoints: map[string]*armiothub.MessagingEndpointProperties{
		// 						"fileNotifications": &armiothub.MessagingEndpointProperties{
		// 							LockDurationAsIso8601: to.Ptr("PT1M"),
		// 							MaxDeliveryCount: to.Ptr[int32](10),
		// 							TTLAsIso8601: to.Ptr("PT1H"),
		// 						},
		// 					},
		// 					NetworkRuleSets: &armiothub.NetworkRuleSetProperties{
		// 						ApplyToBuiltInEventHubEndpoint: to.Ptr(true),
		// 						DefaultAction: to.Ptr(armiothub.DefaultActionDeny),
		// 						IPRules: []*armiothub.NetworkRuleSetIPRule{
		// 							{
		// 								Action: to.Ptr(armiothub.NetworkRuleIPActionAllow),
		// 								FilterName: to.Ptr("rule1"),
		// 								IPMask: to.Ptr("131.117.159.53"),
		// 							},
		// 							{
		// 								Action: to.Ptr(armiothub.NetworkRuleIPActionAllow),
		// 								FilterName: to.Ptr("rule2"),
		// 								IPMask: to.Ptr("157.55.59.128/25"),
		// 						}},
		// 					},
		// 					ProvisioningState: to.Ptr("Succeeded"),
		// 					Routing: &armiothub.RoutingProperties{
		// 						Endpoints: &armiothub.RoutingEndpoints{
		// 							EventHubs: []*armiothub.RoutingEventHubProperties{
		// 							},
		// 							ServiceBusQueues: []*armiothub.RoutingServiceBusQueueEndpointProperties{
		// 							},
		// 							ServiceBusTopics: []*armiothub.RoutingServiceBusTopicEndpointProperties{
		// 							},
		// 							StorageContainers: []*armiothub.RoutingStorageContainerProperties{
		// 							},
		// 						},
		// 						FallbackRoute: &armiothub.FallbackRouteProperties{
		// 							Name: to.Ptr("$fallback"),
		// 							Condition: to.Ptr("true"),
		// 							EndpointNames: []*string{
		// 								to.Ptr("events")},
		// 								IsEnabled: to.Ptr(true),
		// 								Source: to.Ptr(armiothub.RoutingSourceDeviceMessages),
		// 							},
		// 							Routes: []*armiothub.RouteProperties{
		// 							},
		// 						},
		// 						State: to.Ptr("Active"),
		// 						StorageEndpoints: map[string]*armiothub.StorageEndpointProperties{
		// 							"$default": &armiothub.StorageEndpointProperties{
		// 								ConnectionString: to.Ptr(""),
		// 								ContainerName: to.Ptr(""),
		// 								SasTTLAsIso8601: to.Ptr("PT1H"),
		// 							},
		// 						},
		// 					},
		// 					SKU: &armiothub.SKUInfo{
		// 						Name: to.Ptr(armiothub.IotHubSKUS1),
		// 						Capacity: to.Ptr[int64](1),
		// 						Tier: to.Ptr(armiothub.IotHubSKUTierStandard),
		// 					},
		// 					SystemData: &armiothub.SystemData{
		// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-30T00:28:38.963Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_listbyrg.json
func ExampleResourceClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewResourceClient().NewListByResourceGroupPager("myResourceGroup", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DescriptionListResult = armiothub.DescriptionListResult{
		// 	Value: []*armiothub.Description{
		// 		{
		// 			Name: to.Ptr("testHub"),
		// 			Type: to.Ptr("Microsoft.Devices/IotHubs"),
		// 			ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups/myResourceGroup/providers/Microsoft.Devices/IotHubs/testHub"),
		// 			Location: to.Ptr("centraluseuap"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Etag: to.Ptr("AAAAAAFD6M4="),
		// 			Properties: &armiothub.Properties{
		// 				CloudToDevice: &armiothub.CloudToDeviceProperties{
		// 					DefaultTTLAsIso8601: to.Ptr("PT1H"),
		// 					Feedback: &armiothub.FeedbackProperties{
		// 						LockDurationAsIso8601: to.Ptr("PT1M"),
		// 						MaxDeliveryCount: to.Ptr[int32](10),
		// 						TTLAsIso8601: to.Ptr("PT1H"),
		// 					},
		// 					MaxDeliveryCount: to.Ptr[int32](10),
		// 				},
		// 				EnableFileUploadNotifications: to.Ptr(false),
		// 				EventHubEndpoints: map[string]*armiothub.EventHubProperties{
		// 					"events": &armiothub.EventHubProperties{
		// 						Path: to.Ptr("iot-dps-cit-hub-1"),
		// 						Endpoint: to.Ptr("sb://iothub-ns-iot-dps-ci-245306-76aca8e13b.servicebus.windows.net/"),
		// 						PartitionCount: to.Ptr[int32](2),
		// 						PartitionIDs: []*string{
		// 							to.Ptr("0"),
		// 							to.Ptr("1")},
		// 							RetentionTimeInDays: to.Ptr[int64](1),
		// 						},
		// 					},
		// 					Features: to.Ptr(armiothub.CapabilitiesNone),
		// 					HostName: to.Ptr("iot-dps-cit-hub-1.azure-devices.net"),
		// 					IPFilterRules: []*armiothub.IPFilterRule{
		// 						{
		// 							Action: to.Ptr(armiothub.IPFilterActionTypeAccept),
		// 							FilterName: to.Ptr("rule1"),
		// 							IPMask: to.Ptr("131.117.159.53"),
		// 						},
		// 						{
		// 							Action: to.Ptr(armiothub.IPFilterActionTypeAccept),
		// 							FilterName: to.Ptr("rule2"),
		// 							IPMask: to.Ptr("157.55.59.128/25"),
		// 					}},
		// 					MessagingEndpoints: map[string]*armiothub.MessagingEndpointProperties{
		// 						"fileNotifications": &armiothub.MessagingEndpointProperties{
		// 							LockDurationAsIso8601: to.Ptr("PT1M"),
		// 							MaxDeliveryCount: to.Ptr[int32](10),
		// 							TTLAsIso8601: to.Ptr("PT1H"),
		// 						},
		// 					},
		// 					NetworkRuleSets: &armiothub.NetworkRuleSetProperties{
		// 						ApplyToBuiltInEventHubEndpoint: to.Ptr(true),
		// 						DefaultAction: to.Ptr(armiothub.DefaultActionDeny),
		// 						IPRules: []*armiothub.NetworkRuleSetIPRule{
		// 							{
		// 								Action: to.Ptr(armiothub.NetworkRuleIPActionAllow),
		// 								FilterName: to.Ptr("rule1"),
		// 								IPMask: to.Ptr("131.117.159.53"),
		// 							},
		// 							{
		// 								Action: to.Ptr(armiothub.NetworkRuleIPActionAllow),
		// 								FilterName: to.Ptr("rule2"),
		// 								IPMask: to.Ptr("157.55.59.128/25"),
		// 						}},
		// 					},
		// 					ProvisioningState: to.Ptr("Succeeded"),
		// 					Routing: &armiothub.RoutingProperties{
		// 						Endpoints: &armiothub.RoutingEndpoints{
		// 							EventHubs: []*armiothub.RoutingEventHubProperties{
		// 							},
		// 							ServiceBusQueues: []*armiothub.RoutingServiceBusQueueEndpointProperties{
		// 							},
		// 							ServiceBusTopics: []*armiothub.RoutingServiceBusTopicEndpointProperties{
		// 							},
		// 							StorageContainers: []*armiothub.RoutingStorageContainerProperties{
		// 							},
		// 						},
		// 						FallbackRoute: &armiothub.FallbackRouteProperties{
		// 							Name: to.Ptr("$fallback"),
		// 							Condition: to.Ptr("true"),
		// 							EndpointNames: []*string{
		// 								to.Ptr("events")},
		// 								IsEnabled: to.Ptr(true),
		// 								Source: to.Ptr(armiothub.RoutingSourceDeviceMessages),
		// 							},
		// 							Routes: []*armiothub.RouteProperties{
		// 							},
		// 						},
		// 						State: to.Ptr("Active"),
		// 						StorageEndpoints: map[string]*armiothub.StorageEndpointProperties{
		// 							"$default": &armiothub.StorageEndpointProperties{
		// 								ConnectionString: to.Ptr(""),
		// 								ContainerName: to.Ptr(""),
		// 								SasTTLAsIso8601: to.Ptr("PT1H"),
		// 							},
		// 						},
		// 					},
		// 					SKU: &armiothub.SKUInfo{
		// 						Name: to.Ptr(armiothub.IotHubSKUS1),
		// 						Capacity: to.Ptr[int64](1),
		// 						Tier: to.Ptr(armiothub.IotHubSKUTierStandard),
		// 					},
		// 					SystemData: &armiothub.SystemData{
		// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-30T00:28:38.963Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_stats.json
func ExampleResourceClient_GetStats() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewResourceClient().GetStats(ctx, "myResourceGroup", "testHub", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RegistryStatistics = armiothub.RegistryStatistics{
	// 	DisabledDeviceCount: to.Ptr[int64](0),
	// 	EnabledDeviceCount: to.Ptr[int64](0),
	// 	TotalDeviceCount: to.Ptr[int64](0),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_getskus.json
func ExampleResourceClient_NewGetValidSKUsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewResourceClient().NewGetValidSKUsPager("myResourceGroup", "testHub", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SKUDescriptionListResult = armiothub.SKUDescriptionListResult{
		// 	Value: []*armiothub.SKUDescription{
		// 		{
		// 			Capacity: &armiothub.Capacity{
		// 				Default: to.Ptr[int64](1),
		// 				ScaleType: to.Ptr(armiothub.IotHubScaleTypeManual),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Devices/IotHubs"),
		// 			SKU: &armiothub.SKUInfo{
		// 				Name: to.Ptr(armiothub.IotHubSKUS1),
		// 				Tier: to.Ptr(armiothub.IotHubSKUTierStandard),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armiothub.Capacity{
		// 				Default: to.Ptr[int64](1),
		// 				Maximum: to.Ptr[int64](200),
		// 				Minimum: to.Ptr[int64](1),
		// 				ScaleType: to.Ptr(armiothub.IotHubScaleTypeManual),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Devices/IotHubs"),
		// 			SKU: &armiothub.SKUInfo{
		// 				Name: to.Ptr(armiothub.IotHubSKUS2),
		// 				Tier: to.Ptr(armiothub.IotHubSKUTierStandard),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armiothub.Capacity{
		// 				Default: to.Ptr[int64](1),
		// 				Maximum: to.Ptr[int64](10),
		// 				Minimum: to.Ptr[int64](1),
		// 				ScaleType: to.Ptr(armiothub.IotHubScaleTypeManual),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Devices/IotHubs"),
		// 			SKU: &armiothub.SKUInfo{
		// 				Name: to.Ptr(armiothub.IotHubSKUS3),
		// 				Tier: to.Ptr(armiothub.IotHubSKUTierStandard),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_listehgroups.json
func ExampleResourceClient_NewListEventHubConsumerGroupsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewResourceClient().NewListEventHubConsumerGroupsPager("myResourceGroup", "testHub", "events", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.EventHubConsumerGroupsListResult = armiothub.EventHubConsumerGroupsListResult{
		// 	Value: []*armiothub.EventHubConsumerGroupInfo{
		// 		{
		// 			Name: to.Ptr("$Default"),
		// 			Type: to.Ptr("Microsoft.Devices/IotHubs/EventHubEndpoints/ConsumerGroups"),
		// 			Etag: to.Ptr("AAAAAAFD6M4="),
		// 			ID: to.Ptr("/subscriptions/cmd-sub-1/resourceGroups/cmd-rg-1/providers/Microsoft.Devices/IotHubs/test-hub-2/eventHubEndpoints/events/ConsumerGroups/%24Default"),
		// 			Properties: map[string]any{
		// 				"created": "Thu, 15 Jun 2017 19:20:58 GMT",
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_getconsumergroup.json
func ExampleResourceClient_GetEventHubConsumerGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewResourceClient().GetEventHubConsumerGroup(ctx, "myResourceGroup", "testHub", "events", "test", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EventHubConsumerGroupInfo = armiothub.EventHubConsumerGroupInfo{
	// 	Name: to.Ptr("test"),
	// 	Type: to.Ptr("Microsoft.Devices/IotHubs/EventHubEndpoints/ConsumerGroups"),
	// 	Etag: to.Ptr("AAAAAAFD6M4="),
	// 	ID: to.Ptr("/subscriptions/cmd-sub-1/resourceGroups/cmd-rg-1/providers/Microsoft.Devices/IotHubs/test-hub-2/eventHubEndpoints/events/ConsumerGroups/%24Default"),
	// 	Properties: map[string]any{
	// 		"created": "Thu, 15 Jun 2017 19:20:58 GMT",
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_createconsumergroup.json
func ExampleResourceClient_CreateEventHubConsumerGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewResourceClient().CreateEventHubConsumerGroup(ctx, "myResourceGroup", "testHub", "events", "test", armiothub.EventHubConsumerGroupBodyDescription{
		Properties: &armiothub.EventHubConsumerGroupName{
			Name: to.Ptr("test"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EventHubConsumerGroupInfo = armiothub.EventHubConsumerGroupInfo{
	// 	Name: to.Ptr("test"),
	// 	Type: to.Ptr("Microsoft.Devices/IotHubs/EventHubEndpoints/ConsumerGroups"),
	// 	Etag: to.Ptr("AAAAAAFD6M4="),
	// 	ID: to.Ptr("/subscriptions/cmd-sub-1/resourceGroups/cmd-rg-1/providers/Microsoft.Devices/IotHubs/test-hub-2/eventHubEndpoints/events/ConsumerGroups/%24Default"),
	// 	Properties: map[string]any{
	// 		"created": "Thu, 15 Jun 2017 19:20:58 GMT",
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_deleteconsumergroup.json
func ExampleResourceClient_DeleteEventHubConsumerGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewResourceClient().DeleteEventHubConsumerGroup(ctx, "myResourceGroup", "testHub", "events", "test", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_listjobs.json
func ExampleResourceClient_NewListJobsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewResourceClient().NewListJobsPager("myResourceGroup", "testHub", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.JobResponseListResult = armiothub.JobResponseListResult{
		// 	Value: []*armiothub.JobResponse{
		// 		{
		// 			Type: to.Ptr(armiothub.JobTypeUnknown),
		// 			EndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC1123, "2017-06-15T19:20:58.000Z"); return t}()),
		// 			JobID: to.Ptr("test"),
		// 			StartTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC1123, "2017-06-15T19:20:58.000Z"); return t}()),
		// 			Status: to.Ptr(armiothub.JobStatusUnknown),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_getjob.json
func ExampleResourceClient_GetJob() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewResourceClient().GetJob(ctx, "myResourceGroup", "testHub", "test", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.JobResponse = armiothub.JobResponse{
	// 	Type: to.Ptr(armiothub.JobTypeUnknown),
	// 	EndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC1123, "2017-06-15T19:20:58.000Z"); return t}()),
	// 	JobID: to.Ptr("test"),
	// 	StartTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC1123, "2017-06-15T19:20:58.000Z"); return t}()),
	// 	Status: to.Ptr(armiothub.JobStatusUnknown),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_quotametrics.json
func ExampleResourceClient_NewGetQuotaMetricsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewResourceClient().NewGetQuotaMetricsPager("myResourceGroup", "testHub", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.QuotaMetricInfoListResult = armiothub.QuotaMetricInfoListResult{
		// 	Value: []*armiothub.QuotaMetricInfo{
		// 		{
		// 			Name: to.Ptr("TotalMessages"),
		// 			CurrentValue: to.Ptr[int64](0),
		// 			MaxValue: to.Ptr[int64](400000),
		// 		},
		// 		{
		// 			Name: to.Ptr("TotalDeviceCount"),
		// 			CurrentValue: to.Ptr[int64](0),
		// 			MaxValue: to.Ptr[int64](500000),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_routingendpointhealth.json
func ExampleResourceClient_NewGetEndpointHealthPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewResourceClient().NewGetEndpointHealthPager("myResourceGroup", "testHub", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.EndpointHealthDataListResult = armiothub.EndpointHealthDataListResult{
		// 	Value: []*armiothub.EndpointHealthData{
		// 		{
		// 			EndpointID: to.Ptr("id1"),
		// 			HealthStatus: to.Ptr(armiothub.EndpointHealthStatusHealthy),
		// 			LastSendAttemptTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC1123, "2022-09-13T18:04:32.000Z"); return t}()),
		// 			LastSuccessfulSendAttemptTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC1123, "2022-09-13T18:04:32.000Z"); return t}()),
		// 		},
		// 		{
		// 			EndpointID: to.Ptr("id2"),
		// 			HealthStatus: to.Ptr(armiothub.EndpointHealthStatusUnknown),
		// 		},
		// 		{
		// 			EndpointID: to.Ptr("id3"),
		// 			HealthStatus: to.Ptr(armiothub.EndpointHealthStatusUnhealthy),
		// 			LastKnownError: to.Ptr("NotFound"),
		// 			LastKnownErrorTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC1123, "2022-09-13T18:04:32.000Z"); return t}()),
		// 			LastSendAttemptTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC1123, "2022-09-13T18:04:32.000Z"); return t}()),
		// 			LastSuccessfulSendAttemptTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC1123, "2022-09-13T18:04:32.000Z"); return t}()),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/checkNameAvailability.json
func ExampleResourceClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewResourceClient().CheckNameAvailability(ctx, armiothub.OperationInputs{
		Name: to.Ptr("test-request"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NameAvailabilityInfo = armiothub.NameAvailabilityInfo{
	// 	Message: to.Ptr(""),
	// 	NameAvailable: to.Ptr(true),
	// 	Reason: to.Ptr(armiothub.IotHubNameUnavailabilityReasonInvalid),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_testallroutes.json
func ExampleResourceClient_TestAllRoutes() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewResourceClient().TestAllRoutes(ctx, "testHub", "myResourceGroup", armiothub.TestAllRoutesInput{
		Message: &armiothub.RoutingMessage{
			AppProperties: map[string]*string{
				"key1": to.Ptr("value1"),
			},
			Body: to.Ptr("Body of message"),
			SystemProperties: map[string]*string{
				"key1": to.Ptr("value1"),
			},
		},
		RoutingSource: to.Ptr(armiothub.RoutingSourceDeviceMessages),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TestAllRoutesResult = armiothub.TestAllRoutesResult{
	// 	Routes: []*armiothub.MatchedRoute{
	// 		{
	// 			Properties: &armiothub.RouteProperties{
	// 				Name: to.Ptr("Routeid"),
	// 				EndpointNames: []*string{
	// 					to.Ptr("id1")},
	// 					IsEnabled: to.Ptr(true),
	// 					Source: to.Ptr(armiothub.RoutingSourceDeviceMessages),
	// 				},
	// 		}},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_testnewroute.json
func ExampleResourceClient_TestRoute() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewResourceClient().TestRoute(ctx, "testHub", "myResourceGroup", armiothub.TestRouteInput{
		Message: &armiothub.RoutingMessage{
			AppProperties: map[string]*string{
				"key1": to.Ptr("value1"),
			},
			Body: to.Ptr("Body of message"),
			SystemProperties: map[string]*string{
				"key1": to.Ptr("value1"),
			},
		},
		Route: &armiothub.RouteProperties{
			Name: to.Ptr("Routeid"),
			EndpointNames: []*string{
				to.Ptr("id1")},
			IsEnabled: to.Ptr(true),
			Source:    to.Ptr(armiothub.RoutingSourceDeviceMessages),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TestRouteResult = armiothub.TestRouteResult{
	// 	Result: to.Ptr(armiothub.TestResultStatusFalse),
	// 	Details: &armiothub.TestRouteResultDetails{
	// 		CompilationErrors: []*armiothub.RouteCompilationError{
	// 			{
	// 				Location: &armiothub.RouteErrorRange{
	// 					End: &armiothub.RouteErrorPosition{
	// 						Column: to.Ptr[int32](24),
	// 						Line: to.Ptr[int32](12),
	// 					},
	// 					Start: &armiothub.RouteErrorPosition{
	// 						Column: to.Ptr[int32](12),
	// 						Line: to.Ptr[int32](12),
	// 					},
	// 				},
	// 				Message: to.Ptr("string response"),
	// 				Severity: to.Ptr(armiothub.RouteErrorSeverityError),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_listkeys.json
func ExampleResourceClient_NewListKeysPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewResourceClient().NewListKeysPager("myResourceGroup", "testHub", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SharedAccessSignatureAuthorizationRuleListResult = armiothub.SharedAccessSignatureAuthorizationRuleListResult{
		// 	Value: []*armiothub.SharedAccessSignatureAuthorizationRule{
		// 		{
		// 			KeyName: to.Ptr("iothubowner"),
		// 			PrimaryKey: to.Ptr("<primaryKey>"),
		// 			Rights: to.Ptr(armiothub.AccessRightsRegistryWriteServiceConnectDeviceConnect),
		// 			SecondaryKey: to.Ptr("<secondaryKey>"),
		// 		},
		// 		{
		// 			KeyName: to.Ptr("service"),
		// 			PrimaryKey: to.Ptr("<primaryKey>"),
		// 			Rights: to.Ptr(armiothub.AccessRightsServiceConnect),
		// 			SecondaryKey: to.Ptr("<secondaryKey>"),
		// 		},
		// 		{
		// 			KeyName: to.Ptr("device"),
		// 			PrimaryKey: to.Ptr("<primaryKey>"),
		// 			Rights: to.Ptr(armiothub.AccessRightsDeviceConnect),
		// 			SecondaryKey: to.Ptr("<secondaryKey>"),
		// 		},
		// 		{
		// 			KeyName: to.Ptr("registryRead"),
		// 			PrimaryKey: to.Ptr("<primaryKey>"),
		// 			Rights: to.Ptr(armiothub.AccessRightsRegistryRead),
		// 			SecondaryKey: to.Ptr("<secondaryKey>"),
		// 		},
		// 		{
		// 			KeyName: to.Ptr("registryReadWrite"),
		// 			PrimaryKey: to.Ptr("<primaryKey>"),
		// 			Rights: to.Ptr(armiothub.AccessRightsRegistryWrite),
		// 			SecondaryKey: to.Ptr("<secondaryKey>"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_getkey.json
func ExampleResourceClient_GetKeysForKeyName() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewResourceClient().GetKeysForKeyName(ctx, "myResourceGroup", "testHub", "iothubowner", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SharedAccessSignatureAuthorizationRule = armiothub.SharedAccessSignatureAuthorizationRule{
	// 	KeyName: to.Ptr("iothubowner"),
	// 	PrimaryKey: to.Ptr("<primaryKey>"),
	// 	Rights: to.Ptr(armiothub.AccessRightsRegistryWriteServiceConnectDeviceConnect),
	// 	SecondaryKey: to.Ptr("<secondaryKey>"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_exportdevices.json
func ExampleResourceClient_ExportDevices() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewResourceClient().ExportDevices(ctx, "myResourceGroup", "testHub", armiothub.ExportDevicesRequest{
		ExcludeKeys:            to.Ptr(true),
		ExportBlobContainerURI: to.Ptr("testBlob"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.JobResponse = armiothub.JobResponse{
	// 	Type: to.Ptr(armiothub.JobTypeUnknown),
	// 	EndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC1123, "2017-06-15T19:20:58.000Z"); return t}()),
	// 	JobID: to.Ptr("test"),
	// 	StartTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC1123, "2017-06-15T19:20:58.000Z"); return t}()),
	// 	Status: to.Ptr(armiothub.JobStatusUnknown),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_importdevices.json
func ExampleResourceClient_ImportDevices() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewResourceClient().ImportDevices(ctx, "myResourceGroup", "testHub", armiothub.ImportDevicesRequest{
		InputBlobContainerURI:  to.Ptr("testBlob"),
		OutputBlobContainerURI: to.Ptr("testBlob"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.JobResponse = armiothub.JobResponse{
	// 	Type: to.Ptr(armiothub.JobTypeUnknown),
	// 	EndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC1123, "2017-06-15T19:20:58.000Z"); return t}()),
	// 	JobID: to.Ptr("test"),
	// 	StartTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC1123, "2017-06-15T19:20:58.000Z"); return t}()),
	// 	Status: to.Ptr(armiothub.JobStatusUnknown),
	// }
}
