//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armfrontdoor

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/frontdoor/armfrontdoor"
	moduleVersion = "v1.4.0"
)

// ActionType - Defines the action to take on rule match.
type ActionType string

const (
	ActionTypeAllow          ActionType = "Allow"
	ActionTypeAnomalyScoring ActionType = "AnomalyScoring"
	ActionTypeBlock          ActionType = "Block"
	ActionTypeJSChallenge    ActionType = "JSChallenge"
	ActionTypeLog            ActionType = "Log"
	ActionTypeRedirect       ActionType = "Redirect"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeAllow,
		ActionTypeAnomalyScoring,
		ActionTypeBlock,
		ActionTypeJSChallenge,
		ActionTypeLog,
		ActionTypeRedirect,
	}
}

// AggregationInterval - The aggregation interval of the Timeseries
type AggregationInterval string

const (
	AggregationIntervalDaily  AggregationInterval = "Daily"
	AggregationIntervalHourly AggregationInterval = "Hourly"
)

// PossibleAggregationIntervalValues returns the possible values for the AggregationInterval const type.
func PossibleAggregationIntervalValues() []AggregationInterval {
	return []AggregationInterval{
		AggregationIntervalDaily,
		AggregationIntervalHourly,
	}
}

// Availability - Indicates whether the name is available.
type Availability string

const (
	AvailabilityAvailable   Availability = "Available"
	AvailabilityUnavailable Availability = "Unavailable"
)

// PossibleAvailabilityValues returns the possible values for the Availability const type.
func PossibleAvailabilityValues() []Availability {
	return []Availability{
		AvailabilityAvailable,
		AvailabilityUnavailable,
	}
}

// BackendEnabledState - Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
type BackendEnabledState string

const (
	BackendEnabledStateDisabled BackendEnabledState = "Disabled"
	BackendEnabledStateEnabled  BackendEnabledState = "Enabled"
)

// PossibleBackendEnabledStateValues returns the possible values for the BackendEnabledState const type.
func PossibleBackendEnabledStateValues() []BackendEnabledState {
	return []BackendEnabledState{
		BackendEnabledStateDisabled,
		BackendEnabledStateEnabled,
	}
}

// CustomHTTPSProvisioningState - Provisioning status of Custom Https of the frontendEndpoint.
type CustomHTTPSProvisioningState string

const (
	CustomHTTPSProvisioningStateDisabled  CustomHTTPSProvisioningState = "Disabled"
	CustomHTTPSProvisioningStateDisabling CustomHTTPSProvisioningState = "Disabling"
	CustomHTTPSProvisioningStateEnabled   CustomHTTPSProvisioningState = "Enabled"
	CustomHTTPSProvisioningStateEnabling  CustomHTTPSProvisioningState = "Enabling"
	CustomHTTPSProvisioningStateFailed    CustomHTTPSProvisioningState = "Failed"
)

// PossibleCustomHTTPSProvisioningStateValues returns the possible values for the CustomHTTPSProvisioningState const type.
func PossibleCustomHTTPSProvisioningStateValues() []CustomHTTPSProvisioningState {
	return []CustomHTTPSProvisioningState{
		CustomHTTPSProvisioningStateDisabled,
		CustomHTTPSProvisioningStateDisabling,
		CustomHTTPSProvisioningStateEnabled,
		CustomHTTPSProvisioningStateEnabling,
		CustomHTTPSProvisioningStateFailed,
	}
}

// CustomHTTPSProvisioningSubstate - Provisioning substate shows the progress of custom HTTPS enabling/disabling process step
// by step.
type CustomHTTPSProvisioningSubstate string

const (
	CustomHTTPSProvisioningSubstateCertificateDeleted                            CustomHTTPSProvisioningSubstate = "CertificateDeleted"
	CustomHTTPSProvisioningSubstateCertificateDeployed                           CustomHTTPSProvisioningSubstate = "CertificateDeployed"
	CustomHTTPSProvisioningSubstateDeletingCertificate                           CustomHTTPSProvisioningSubstate = "DeletingCertificate"
	CustomHTTPSProvisioningSubstateDeployingCertificate                          CustomHTTPSProvisioningSubstate = "DeployingCertificate"
	CustomHTTPSProvisioningSubstateDomainControlValidationRequestApproved        CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestApproved"
	CustomHTTPSProvisioningSubstateDomainControlValidationRequestRejected        CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestRejected"
	CustomHTTPSProvisioningSubstateDomainControlValidationRequestTimedOut        CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestTimedOut"
	CustomHTTPSProvisioningSubstateIssuingCertificate                            CustomHTTPSProvisioningSubstate = "IssuingCertificate"
	CustomHTTPSProvisioningSubstatePendingDomainControlValidationREquestApproval CustomHTTPSProvisioningSubstate = "PendingDomainControlValidationREquestApproval"
	CustomHTTPSProvisioningSubstateSubmittingDomainControlValidationRequest      CustomHTTPSProvisioningSubstate = "SubmittingDomainControlValidationRequest"
)

// PossibleCustomHTTPSProvisioningSubstateValues returns the possible values for the CustomHTTPSProvisioningSubstate const type.
func PossibleCustomHTTPSProvisioningSubstateValues() []CustomHTTPSProvisioningSubstate {
	return []CustomHTTPSProvisioningSubstate{
		CustomHTTPSProvisioningSubstateCertificateDeleted,
		CustomHTTPSProvisioningSubstateCertificateDeployed,
		CustomHTTPSProvisioningSubstateDeletingCertificate,
		CustomHTTPSProvisioningSubstateDeployingCertificate,
		CustomHTTPSProvisioningSubstateDomainControlValidationRequestApproved,
		CustomHTTPSProvisioningSubstateDomainControlValidationRequestRejected,
		CustomHTTPSProvisioningSubstateDomainControlValidationRequestTimedOut,
		CustomHTTPSProvisioningSubstateIssuingCertificate,
		CustomHTTPSProvisioningSubstatePendingDomainControlValidationREquestApproval,
		CustomHTTPSProvisioningSubstateSubmittingDomainControlValidationRequest,
	}
}

// CustomRuleEnabledState - Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
type CustomRuleEnabledState string

const (
	CustomRuleEnabledStateDisabled CustomRuleEnabledState = "Disabled"
	CustomRuleEnabledStateEnabled  CustomRuleEnabledState = "Enabled"
)

// PossibleCustomRuleEnabledStateValues returns the possible values for the CustomRuleEnabledState const type.
func PossibleCustomRuleEnabledStateValues() []CustomRuleEnabledState {
	return []CustomRuleEnabledState{
		CustomRuleEnabledStateDisabled,
		CustomRuleEnabledStateEnabled,
	}
}

// DynamicCompressionEnabled - Whether to use dynamic compression for cached content
type DynamicCompressionEnabled string

const (
	DynamicCompressionEnabledDisabled DynamicCompressionEnabled = "Disabled"
	DynamicCompressionEnabledEnabled  DynamicCompressionEnabled = "Enabled"
)

// PossibleDynamicCompressionEnabledValues returns the possible values for the DynamicCompressionEnabled const type.
func PossibleDynamicCompressionEnabledValues() []DynamicCompressionEnabled {
	return []DynamicCompressionEnabled{
		DynamicCompressionEnabledDisabled,
		DynamicCompressionEnabledEnabled,
	}
}

// EndpointType - The type of endpoint
type EndpointType string

const (
	EndpointTypeAFD         EndpointType = "AFD"
	EndpointTypeATM         EndpointType = "ATM"
	EndpointTypeAzureRegion EndpointType = "AzureRegion"
	EndpointTypeCDN         EndpointType = "CDN"
)

// PossibleEndpointTypeValues returns the possible values for the EndpointType const type.
func PossibleEndpointTypeValues() []EndpointType {
	return []EndpointType{
		EndpointTypeAFD,
		EndpointTypeATM,
		EndpointTypeAzureRegion,
		EndpointTypeCDN,
	}
}

// EnforceCertificateNameCheckEnabledState - Whether to enforce certificate name check on HTTPS requests to all backend pools.
// No effect on non-HTTPS requests.
type EnforceCertificateNameCheckEnabledState string

const (
	EnforceCertificateNameCheckEnabledStateDisabled EnforceCertificateNameCheckEnabledState = "Disabled"
	EnforceCertificateNameCheckEnabledStateEnabled  EnforceCertificateNameCheckEnabledState = "Enabled"
)

// PossibleEnforceCertificateNameCheckEnabledStateValues returns the possible values for the EnforceCertificateNameCheckEnabledState const type.
func PossibleEnforceCertificateNameCheckEnabledStateValues() []EnforceCertificateNameCheckEnabledState {
	return []EnforceCertificateNameCheckEnabledState{
		EnforceCertificateNameCheckEnabledStateDisabled,
		EnforceCertificateNameCheckEnabledStateEnabled,
	}
}

// FrontDoorCertificateSource - Defines the source of the SSL certificate
type FrontDoorCertificateSource string

const (
	FrontDoorCertificateSourceAzureKeyVault FrontDoorCertificateSource = "AzureKeyVault"
	FrontDoorCertificateSourceFrontDoor     FrontDoorCertificateSource = "FrontDoor"
)

// PossibleFrontDoorCertificateSourceValues returns the possible values for the FrontDoorCertificateSource const type.
func PossibleFrontDoorCertificateSourceValues() []FrontDoorCertificateSource {
	return []FrontDoorCertificateSource{
		FrontDoorCertificateSourceAzureKeyVault,
		FrontDoorCertificateSourceFrontDoor,
	}
}

// FrontDoorCertificateType - Defines the type of the certificate used for secure connections to a frontendEndpoint
type FrontDoorCertificateType string

const (
	FrontDoorCertificateTypeDedicated FrontDoorCertificateType = "Dedicated"
)

// PossibleFrontDoorCertificateTypeValues returns the possible values for the FrontDoorCertificateType const type.
func PossibleFrontDoorCertificateTypeValues() []FrontDoorCertificateType {
	return []FrontDoorCertificateType{
		FrontDoorCertificateTypeDedicated,
	}
}

// FrontDoorEnabledState - Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
type FrontDoorEnabledState string

const (
	FrontDoorEnabledStateDisabled FrontDoorEnabledState = "Disabled"
	FrontDoorEnabledStateEnabled  FrontDoorEnabledState = "Enabled"
)

// PossibleFrontDoorEnabledStateValues returns the possible values for the FrontDoorEnabledState const type.
func PossibleFrontDoorEnabledStateValues() []FrontDoorEnabledState {
	return []FrontDoorEnabledState{
		FrontDoorEnabledStateDisabled,
		FrontDoorEnabledStateEnabled,
	}
}

// FrontDoorForwardingProtocol - Protocol this rule will use when forwarding traffic to backends.
type FrontDoorForwardingProtocol string

const (
	FrontDoorForwardingProtocolHTTPOnly     FrontDoorForwardingProtocol = "HttpOnly"
	FrontDoorForwardingProtocolHTTPSOnly    FrontDoorForwardingProtocol = "HttpsOnly"
	FrontDoorForwardingProtocolMatchRequest FrontDoorForwardingProtocol = "MatchRequest"
)

// PossibleFrontDoorForwardingProtocolValues returns the possible values for the FrontDoorForwardingProtocol const type.
func PossibleFrontDoorForwardingProtocolValues() []FrontDoorForwardingProtocol {
	return []FrontDoorForwardingProtocol{
		FrontDoorForwardingProtocolHTTPOnly,
		FrontDoorForwardingProtocolHTTPSOnly,
		FrontDoorForwardingProtocolMatchRequest,
	}
}

// FrontDoorHealthProbeMethod - Configures which HTTP method to use to probe the backends defined under backendPools.
type FrontDoorHealthProbeMethod string

const (
	FrontDoorHealthProbeMethodGET  FrontDoorHealthProbeMethod = "GET"
	FrontDoorHealthProbeMethodHEAD FrontDoorHealthProbeMethod = "HEAD"
)

// PossibleFrontDoorHealthProbeMethodValues returns the possible values for the FrontDoorHealthProbeMethod const type.
func PossibleFrontDoorHealthProbeMethodValues() []FrontDoorHealthProbeMethod {
	return []FrontDoorHealthProbeMethod{
		FrontDoorHealthProbeMethodGET,
		FrontDoorHealthProbeMethodHEAD,
	}
}

// FrontDoorProtocol - Accepted protocol schemes.
type FrontDoorProtocol string

const (
	FrontDoorProtocolHTTP  FrontDoorProtocol = "Http"
	FrontDoorProtocolHTTPS FrontDoorProtocol = "Https"
)

// PossibleFrontDoorProtocolValues returns the possible values for the FrontDoorProtocol const type.
func PossibleFrontDoorProtocolValues() []FrontDoorProtocol {
	return []FrontDoorProtocol{
		FrontDoorProtocolHTTP,
		FrontDoorProtocolHTTPS,
	}
}

// FrontDoorQuery - Treatment of URL query terms when forming the cache key.
type FrontDoorQuery string

const (
	FrontDoorQueryStripAll       FrontDoorQuery = "StripAll"
	FrontDoorQueryStripAllExcept FrontDoorQuery = "StripAllExcept"
	FrontDoorQueryStripNone      FrontDoorQuery = "StripNone"
	FrontDoorQueryStripOnly      FrontDoorQuery = "StripOnly"
)

// PossibleFrontDoorQueryValues returns the possible values for the FrontDoorQuery const type.
func PossibleFrontDoorQueryValues() []FrontDoorQuery {
	return []FrontDoorQuery{
		FrontDoorQueryStripAll,
		FrontDoorQueryStripAllExcept,
		FrontDoorQueryStripNone,
		FrontDoorQueryStripOnly,
	}
}

// FrontDoorRedirectProtocol - The protocol of the destination to where the traffic is redirected
type FrontDoorRedirectProtocol string

const (
	FrontDoorRedirectProtocolHTTPOnly     FrontDoorRedirectProtocol = "HttpOnly"
	FrontDoorRedirectProtocolHTTPSOnly    FrontDoorRedirectProtocol = "HttpsOnly"
	FrontDoorRedirectProtocolMatchRequest FrontDoorRedirectProtocol = "MatchRequest"
)

// PossibleFrontDoorRedirectProtocolValues returns the possible values for the FrontDoorRedirectProtocol const type.
func PossibleFrontDoorRedirectProtocolValues() []FrontDoorRedirectProtocol {
	return []FrontDoorRedirectProtocol{
		FrontDoorRedirectProtocolHTTPOnly,
		FrontDoorRedirectProtocolHTTPSOnly,
		FrontDoorRedirectProtocolMatchRequest,
	}
}

// FrontDoorRedirectType - The redirect type the rule will use when redirecting traffic.
type FrontDoorRedirectType string

const (
	FrontDoorRedirectTypeFound             FrontDoorRedirectType = "Found"
	FrontDoorRedirectTypeMoved             FrontDoorRedirectType = "Moved"
	FrontDoorRedirectTypePermanentRedirect FrontDoorRedirectType = "PermanentRedirect"
	FrontDoorRedirectTypeTemporaryRedirect FrontDoorRedirectType = "TemporaryRedirect"
)

// PossibleFrontDoorRedirectTypeValues returns the possible values for the FrontDoorRedirectType const type.
func PossibleFrontDoorRedirectTypeValues() []FrontDoorRedirectType {
	return []FrontDoorRedirectType{
		FrontDoorRedirectTypeFound,
		FrontDoorRedirectTypeMoved,
		FrontDoorRedirectTypePermanentRedirect,
		FrontDoorRedirectTypeTemporaryRedirect,
	}
}

// FrontDoorResourceState - Resource status of the Front Door or Front Door SubResource.
type FrontDoorResourceState string

const (
	FrontDoorResourceStateCreating  FrontDoorResourceState = "Creating"
	FrontDoorResourceStateDeleting  FrontDoorResourceState = "Deleting"
	FrontDoorResourceStateDisabled  FrontDoorResourceState = "Disabled"
	FrontDoorResourceStateDisabling FrontDoorResourceState = "Disabling"
	FrontDoorResourceStateEnabled   FrontDoorResourceState = "Enabled"
	FrontDoorResourceStateEnabling  FrontDoorResourceState = "Enabling"
	FrontDoorResourceStateMigrated  FrontDoorResourceState = "Migrated"
	FrontDoorResourceStateMigrating FrontDoorResourceState = "Migrating"
)

// PossibleFrontDoorResourceStateValues returns the possible values for the FrontDoorResourceState const type.
func PossibleFrontDoorResourceStateValues() []FrontDoorResourceState {
	return []FrontDoorResourceState{
		FrontDoorResourceStateCreating,
		FrontDoorResourceStateDeleting,
		FrontDoorResourceStateDisabled,
		FrontDoorResourceStateDisabling,
		FrontDoorResourceStateEnabled,
		FrontDoorResourceStateEnabling,
		FrontDoorResourceStateMigrated,
		FrontDoorResourceStateMigrating,
	}
}

// FrontDoorTLSProtocolType - Defines the TLS extension protocol that is used for secure delivery
type FrontDoorTLSProtocolType string

const (
	FrontDoorTLSProtocolTypeServerNameIndication FrontDoorTLSProtocolType = "ServerNameIndication"
)

// PossibleFrontDoorTLSProtocolTypeValues returns the possible values for the FrontDoorTLSProtocolType const type.
func PossibleFrontDoorTLSProtocolTypeValues() []FrontDoorTLSProtocolType {
	return []FrontDoorTLSProtocolType{
		FrontDoorTLSProtocolTypeServerNameIndication,
	}
}

// HeaderActionType - Which type of manipulation to apply to the header.
type HeaderActionType string

const (
	HeaderActionTypeAppend    HeaderActionType = "Append"
	HeaderActionTypeDelete    HeaderActionType = "Delete"
	HeaderActionTypeOverwrite HeaderActionType = "Overwrite"
)

// PossibleHeaderActionTypeValues returns the possible values for the HeaderActionType const type.
func PossibleHeaderActionTypeValues() []HeaderActionType {
	return []HeaderActionType{
		HeaderActionTypeAppend,
		HeaderActionTypeDelete,
		HeaderActionTypeOverwrite,
	}
}

// HealthProbeEnabled - Whether to enable health probes to be made against backends defined under backendPools. Health probes
// can only be disabled if there is a single enabled backend in single enabled backend pool.
type HealthProbeEnabled string

const (
	HealthProbeEnabledDisabled HealthProbeEnabled = "Disabled"
	HealthProbeEnabledEnabled  HealthProbeEnabled = "Enabled"
)

// PossibleHealthProbeEnabledValues returns the possible values for the HealthProbeEnabled const type.
func PossibleHealthProbeEnabledValues() []HealthProbeEnabled {
	return []HealthProbeEnabled{
		HealthProbeEnabledDisabled,
		HealthProbeEnabledEnabled,
	}
}

type LatencyScorecardAggregationInterval string

const (
	LatencyScorecardAggregationIntervalDaily   LatencyScorecardAggregationInterval = "Daily"
	LatencyScorecardAggregationIntervalMonthly LatencyScorecardAggregationInterval = "Monthly"
	LatencyScorecardAggregationIntervalWeekly  LatencyScorecardAggregationInterval = "Weekly"
)

// PossibleLatencyScorecardAggregationIntervalValues returns the possible values for the LatencyScorecardAggregationInterval const type.
func PossibleLatencyScorecardAggregationIntervalValues() []LatencyScorecardAggregationInterval {
	return []LatencyScorecardAggregationInterval{
		LatencyScorecardAggregationIntervalDaily,
		LatencyScorecardAggregationIntervalMonthly,
		LatencyScorecardAggregationIntervalWeekly,
	}
}

// ManagedRuleEnabledState - Describes if the managed rule is in enabled or disabled state.
type ManagedRuleEnabledState string

const (
	ManagedRuleEnabledStateDisabled ManagedRuleEnabledState = "Disabled"
	ManagedRuleEnabledStateEnabled  ManagedRuleEnabledState = "Enabled"
)

// PossibleManagedRuleEnabledStateValues returns the possible values for the ManagedRuleEnabledState const type.
func PossibleManagedRuleEnabledStateValues() []ManagedRuleEnabledState {
	return []ManagedRuleEnabledState{
		ManagedRuleEnabledStateDisabled,
		ManagedRuleEnabledStateEnabled,
	}
}

// ManagedRuleExclusionMatchVariable - The variable type to be excluded.
type ManagedRuleExclusionMatchVariable string

const (
	ManagedRuleExclusionMatchVariableQueryStringArgNames     ManagedRuleExclusionMatchVariable = "QueryStringArgNames"
	ManagedRuleExclusionMatchVariableRequestBodyJSONArgNames ManagedRuleExclusionMatchVariable = "RequestBodyJsonArgNames"
	ManagedRuleExclusionMatchVariableRequestBodyPostArgNames ManagedRuleExclusionMatchVariable = "RequestBodyPostArgNames"
	ManagedRuleExclusionMatchVariableRequestCookieNames      ManagedRuleExclusionMatchVariable = "RequestCookieNames"
	ManagedRuleExclusionMatchVariableRequestHeaderNames      ManagedRuleExclusionMatchVariable = "RequestHeaderNames"
)

// PossibleManagedRuleExclusionMatchVariableValues returns the possible values for the ManagedRuleExclusionMatchVariable const type.
func PossibleManagedRuleExclusionMatchVariableValues() []ManagedRuleExclusionMatchVariable {
	return []ManagedRuleExclusionMatchVariable{
		ManagedRuleExclusionMatchVariableQueryStringArgNames,
		ManagedRuleExclusionMatchVariableRequestBodyJSONArgNames,
		ManagedRuleExclusionMatchVariableRequestBodyPostArgNames,
		ManagedRuleExclusionMatchVariableRequestCookieNames,
		ManagedRuleExclusionMatchVariableRequestHeaderNames,
	}
}

// ManagedRuleExclusionSelectorMatchOperator - Comparison operator to apply to the selector when specifying which elements
// in the collection this exclusion applies to.
type ManagedRuleExclusionSelectorMatchOperator string

const (
	ManagedRuleExclusionSelectorMatchOperatorContains   ManagedRuleExclusionSelectorMatchOperator = "Contains"
	ManagedRuleExclusionSelectorMatchOperatorEndsWith   ManagedRuleExclusionSelectorMatchOperator = "EndsWith"
	ManagedRuleExclusionSelectorMatchOperatorEquals     ManagedRuleExclusionSelectorMatchOperator = "Equals"
	ManagedRuleExclusionSelectorMatchOperatorEqualsAny  ManagedRuleExclusionSelectorMatchOperator = "EqualsAny"
	ManagedRuleExclusionSelectorMatchOperatorStartsWith ManagedRuleExclusionSelectorMatchOperator = "StartsWith"
)

// PossibleManagedRuleExclusionSelectorMatchOperatorValues returns the possible values for the ManagedRuleExclusionSelectorMatchOperator const type.
func PossibleManagedRuleExclusionSelectorMatchOperatorValues() []ManagedRuleExclusionSelectorMatchOperator {
	return []ManagedRuleExclusionSelectorMatchOperator{
		ManagedRuleExclusionSelectorMatchOperatorContains,
		ManagedRuleExclusionSelectorMatchOperatorEndsWith,
		ManagedRuleExclusionSelectorMatchOperatorEquals,
		ManagedRuleExclusionSelectorMatchOperatorEqualsAny,
		ManagedRuleExclusionSelectorMatchOperatorStartsWith,
	}
}

// ManagedRuleSetActionType - Defines the action to take when a managed rule set score threshold is met.
type ManagedRuleSetActionType string

const (
	ManagedRuleSetActionTypeBlock    ManagedRuleSetActionType = "Block"
	ManagedRuleSetActionTypeLog      ManagedRuleSetActionType = "Log"
	ManagedRuleSetActionTypeRedirect ManagedRuleSetActionType = "Redirect"
)

// PossibleManagedRuleSetActionTypeValues returns the possible values for the ManagedRuleSetActionType const type.
func PossibleManagedRuleSetActionTypeValues() []ManagedRuleSetActionType {
	return []ManagedRuleSetActionType{
		ManagedRuleSetActionTypeBlock,
		ManagedRuleSetActionTypeLog,
		ManagedRuleSetActionTypeRedirect,
	}
}

// MatchProcessingBehavior - If this rule is a match should the rules engine continue running the remaining rules or stop.
// If not present, defaults to Continue.
type MatchProcessingBehavior string

const (
	MatchProcessingBehaviorContinue MatchProcessingBehavior = "Continue"
	MatchProcessingBehaviorStop     MatchProcessingBehavior = "Stop"
)

// PossibleMatchProcessingBehaviorValues returns the possible values for the MatchProcessingBehavior const type.
func PossibleMatchProcessingBehaviorValues() []MatchProcessingBehavior {
	return []MatchProcessingBehavior{
		MatchProcessingBehaviorContinue,
		MatchProcessingBehaviorStop,
	}
}

// MatchVariable - Request variable to compare with.
type MatchVariable string

const (
	MatchVariableCookies       MatchVariable = "Cookies"
	MatchVariablePostArgs      MatchVariable = "PostArgs"
	MatchVariableQueryString   MatchVariable = "QueryString"
	MatchVariableRemoteAddr    MatchVariable = "RemoteAddr"
	MatchVariableRequestBody   MatchVariable = "RequestBody"
	MatchVariableRequestHeader MatchVariable = "RequestHeader"
	MatchVariableRequestMethod MatchVariable = "RequestMethod"
	MatchVariableRequestURI    MatchVariable = "RequestUri"
	MatchVariableSocketAddr    MatchVariable = "SocketAddr"
)

// PossibleMatchVariableValues returns the possible values for the MatchVariable const type.
func PossibleMatchVariableValues() []MatchVariable {
	return []MatchVariable{
		MatchVariableCookies,
		MatchVariablePostArgs,
		MatchVariableQueryString,
		MatchVariableRemoteAddr,
		MatchVariableRequestBody,
		MatchVariableRequestHeader,
		MatchVariableRequestMethod,
		MatchVariableRequestURI,
		MatchVariableSocketAddr,
	}
}

// MinimumTLSVersion - The minimum TLS version required from the clients to establish an SSL handshake with Front Door.
type MinimumTLSVersion string

const (
	MinimumTLSVersionOne0 MinimumTLSVersion = "1.0"
	MinimumTLSVersionOne2 MinimumTLSVersion = "1.2"
)

// PossibleMinimumTLSVersionValues returns the possible values for the MinimumTLSVersion const type.
func PossibleMinimumTLSVersionValues() []MinimumTLSVersion {
	return []MinimumTLSVersion{
		MinimumTLSVersionOne0,
		MinimumTLSVersionOne2,
	}
}

// NetworkExperimentResourceState - Defines the server side resource status
type NetworkExperimentResourceState string

const (
	NetworkExperimentResourceStateCreating  NetworkExperimentResourceState = "Creating"
	NetworkExperimentResourceStateDeleting  NetworkExperimentResourceState = "Deleting"
	NetworkExperimentResourceStateDisabled  NetworkExperimentResourceState = "Disabled"
	NetworkExperimentResourceStateDisabling NetworkExperimentResourceState = "Disabling"
	NetworkExperimentResourceStateEnabled   NetworkExperimentResourceState = "Enabled"
	NetworkExperimentResourceStateEnabling  NetworkExperimentResourceState = "Enabling"
)

// PossibleNetworkExperimentResourceStateValues returns the possible values for the NetworkExperimentResourceState const type.
func PossibleNetworkExperimentResourceStateValues() []NetworkExperimentResourceState {
	return []NetworkExperimentResourceState{
		NetworkExperimentResourceStateCreating,
		NetworkExperimentResourceStateDeleting,
		NetworkExperimentResourceStateDisabled,
		NetworkExperimentResourceStateDisabling,
		NetworkExperimentResourceStateEnabled,
		NetworkExperimentResourceStateEnabling,
	}
}

// NetworkOperationStatus - Status of the Azure async operation.
type NetworkOperationStatus string

const (
	NetworkOperationStatusFailed     NetworkOperationStatus = "Failed"
	NetworkOperationStatusInProgress NetworkOperationStatus = "InProgress"
	NetworkOperationStatusSucceeded  NetworkOperationStatus = "Succeeded"
)

// PossibleNetworkOperationStatusValues returns the possible values for the NetworkOperationStatus const type.
func PossibleNetworkOperationStatusValues() []NetworkOperationStatus {
	return []NetworkOperationStatus{
		NetworkOperationStatusFailed,
		NetworkOperationStatusInProgress,
		NetworkOperationStatusSucceeded,
	}
}

// Operator - Comparison type to use for matching with the variable value.
type Operator string

const (
	OperatorAny                Operator = "Any"
	OperatorBeginsWith         Operator = "BeginsWith"
	OperatorContains           Operator = "Contains"
	OperatorEndsWith           Operator = "EndsWith"
	OperatorEqual              Operator = "Equal"
	OperatorGeoMatch           Operator = "GeoMatch"
	OperatorGreaterThan        Operator = "GreaterThan"
	OperatorGreaterThanOrEqual Operator = "GreaterThanOrEqual"
	OperatorIPMatch            Operator = "IPMatch"
	OperatorLessThan           Operator = "LessThan"
	OperatorLessThanOrEqual    Operator = "LessThanOrEqual"
	OperatorRegEx              Operator = "RegEx"
)

// PossibleOperatorValues returns the possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{
		OperatorAny,
		OperatorBeginsWith,
		OperatorContains,
		OperatorEndsWith,
		OperatorEqual,
		OperatorGeoMatch,
		OperatorGreaterThan,
		OperatorGreaterThanOrEqual,
		OperatorIPMatch,
		OperatorLessThan,
		OperatorLessThanOrEqual,
		OperatorRegEx,
	}
}

// PolicyEnabledState - Describes if the policy is in enabled or disabled state. Defaults to Enabled if not specified.
type PolicyEnabledState string

const (
	PolicyEnabledStateDisabled PolicyEnabledState = "Disabled"
	PolicyEnabledStateEnabled  PolicyEnabledState = "Enabled"
)

// PossiblePolicyEnabledStateValues returns the possible values for the PolicyEnabledState const type.
func PossiblePolicyEnabledStateValues() []PolicyEnabledState {
	return []PolicyEnabledState{
		PolicyEnabledStateDisabled,
		PolicyEnabledStateEnabled,
	}
}

// PolicyMode - Describes if it is in detection mode or prevention mode at policy level.
type PolicyMode string

const (
	PolicyModeDetection  PolicyMode = "Detection"
	PolicyModePrevention PolicyMode = "Prevention"
)

// PossiblePolicyModeValues returns the possible values for the PolicyMode const type.
func PossiblePolicyModeValues() []PolicyMode {
	return []PolicyMode{
		PolicyModeDetection,
		PolicyModePrevention,
	}
}

// PolicyRequestBodyCheck - Describes if policy managed rules will inspect the request body content.
type PolicyRequestBodyCheck string

const (
	PolicyRequestBodyCheckDisabled PolicyRequestBodyCheck = "Disabled"
	PolicyRequestBodyCheckEnabled  PolicyRequestBodyCheck = "Enabled"
)

// PossiblePolicyRequestBodyCheckValues returns the possible values for the PolicyRequestBodyCheck const type.
func PossiblePolicyRequestBodyCheckValues() []PolicyRequestBodyCheck {
	return []PolicyRequestBodyCheck{
		PolicyRequestBodyCheckDisabled,
		PolicyRequestBodyCheckEnabled,
	}
}

// PolicyResourceState - Resource status of the policy.
type PolicyResourceState string

const (
	PolicyResourceStateCreating  PolicyResourceState = "Creating"
	PolicyResourceStateDeleting  PolicyResourceState = "Deleting"
	PolicyResourceStateDisabled  PolicyResourceState = "Disabled"
	PolicyResourceStateDisabling PolicyResourceState = "Disabling"
	PolicyResourceStateEnabled   PolicyResourceState = "Enabled"
	PolicyResourceStateEnabling  PolicyResourceState = "Enabling"
)

// PossiblePolicyResourceStateValues returns the possible values for the PolicyResourceState const type.
func PossiblePolicyResourceStateValues() []PolicyResourceState {
	return []PolicyResourceState{
		PolicyResourceStateCreating,
		PolicyResourceStateDeleting,
		PolicyResourceStateDisabled,
		PolicyResourceStateDisabling,
		PolicyResourceStateEnabled,
		PolicyResourceStateEnabling,
	}
}

// PrivateEndpointStatus - The Approval status for the connection to the Private Link
type PrivateEndpointStatus string

const (
	PrivateEndpointStatusApproved     PrivateEndpointStatus = "Approved"
	PrivateEndpointStatusDisconnected PrivateEndpointStatus = "Disconnected"
	PrivateEndpointStatusPending      PrivateEndpointStatus = "Pending"
	PrivateEndpointStatusRejected     PrivateEndpointStatus = "Rejected"
	PrivateEndpointStatusTimeout      PrivateEndpointStatus = "Timeout"
)

// PossiblePrivateEndpointStatusValues returns the possible values for the PrivateEndpointStatus const type.
func PossiblePrivateEndpointStatusValues() []PrivateEndpointStatus {
	return []PrivateEndpointStatus{
		PrivateEndpointStatusApproved,
		PrivateEndpointStatusDisconnected,
		PrivateEndpointStatusPending,
		PrivateEndpointStatusRejected,
		PrivateEndpointStatusTimeout,
	}
}

// ResourceType - Type of Front Door resource used in CheckNameAvailability.
type ResourceType string

const (
	ResourceTypeMicrosoftNetworkFrontDoors                  ResourceType = "Microsoft.Network/frontDoors"
	ResourceTypeMicrosoftNetworkFrontDoorsFrontendEndpoints ResourceType = "Microsoft.Network/frontDoors/frontendEndpoints"
)

// PossibleResourceTypeValues returns the possible values for the ResourceType const type.
func PossibleResourceTypeValues() []ResourceType {
	return []ResourceType{
		ResourceTypeMicrosoftNetworkFrontDoors,
		ResourceTypeMicrosoftNetworkFrontDoorsFrontendEndpoints,
	}
}

// RoutingRuleEnabledState - Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
type RoutingRuleEnabledState string

const (
	RoutingRuleEnabledStateDisabled RoutingRuleEnabledState = "Disabled"
	RoutingRuleEnabledStateEnabled  RoutingRuleEnabledState = "Enabled"
)

// PossibleRoutingRuleEnabledStateValues returns the possible values for the RoutingRuleEnabledState const type.
func PossibleRoutingRuleEnabledStateValues() []RoutingRuleEnabledState {
	return []RoutingRuleEnabledState{
		RoutingRuleEnabledStateDisabled,
		RoutingRuleEnabledStateEnabled,
	}
}

// RuleType - Describes type of rule.
type RuleType string

const (
	RuleTypeMatchRule     RuleType = "MatchRule"
	RuleTypeRateLimitRule RuleType = "RateLimitRule"
)

// PossibleRuleTypeValues returns the possible values for the RuleType const type.
func PossibleRuleTypeValues() []RuleType {
	return []RuleType{
		RuleTypeMatchRule,
		RuleTypeRateLimitRule,
	}
}

// RulesEngineMatchVariable - Match Variable
type RulesEngineMatchVariable string

const (
	RulesEngineMatchVariableIsMobile                 RulesEngineMatchVariable = "IsMobile"
	RulesEngineMatchVariablePostArgs                 RulesEngineMatchVariable = "PostArgs"
	RulesEngineMatchVariableQueryString              RulesEngineMatchVariable = "QueryString"
	RulesEngineMatchVariableRemoteAddr               RulesEngineMatchVariable = "RemoteAddr"
	RulesEngineMatchVariableRequestBody              RulesEngineMatchVariable = "RequestBody"
	RulesEngineMatchVariableRequestFilename          RulesEngineMatchVariable = "RequestFilename"
	RulesEngineMatchVariableRequestFilenameExtension RulesEngineMatchVariable = "RequestFilenameExtension"
	RulesEngineMatchVariableRequestHeader            RulesEngineMatchVariable = "RequestHeader"
	RulesEngineMatchVariableRequestMethod            RulesEngineMatchVariable = "RequestMethod"
	RulesEngineMatchVariableRequestPath              RulesEngineMatchVariable = "RequestPath"
	RulesEngineMatchVariableRequestScheme            RulesEngineMatchVariable = "RequestScheme"
	RulesEngineMatchVariableRequestURI               RulesEngineMatchVariable = "RequestUri"
)

// PossibleRulesEngineMatchVariableValues returns the possible values for the RulesEngineMatchVariable const type.
func PossibleRulesEngineMatchVariableValues() []RulesEngineMatchVariable {
	return []RulesEngineMatchVariable{
		RulesEngineMatchVariableIsMobile,
		RulesEngineMatchVariablePostArgs,
		RulesEngineMatchVariableQueryString,
		RulesEngineMatchVariableRemoteAddr,
		RulesEngineMatchVariableRequestBody,
		RulesEngineMatchVariableRequestFilename,
		RulesEngineMatchVariableRequestFilenameExtension,
		RulesEngineMatchVariableRequestHeader,
		RulesEngineMatchVariableRequestMethod,
		RulesEngineMatchVariableRequestPath,
		RulesEngineMatchVariableRequestScheme,
		RulesEngineMatchVariableRequestURI,
	}
}

// RulesEngineOperator - Describes operator to apply to the match condition.
type RulesEngineOperator string

const (
	RulesEngineOperatorAny                RulesEngineOperator = "Any"
	RulesEngineOperatorBeginsWith         RulesEngineOperator = "BeginsWith"
	RulesEngineOperatorContains           RulesEngineOperator = "Contains"
	RulesEngineOperatorEndsWith           RulesEngineOperator = "EndsWith"
	RulesEngineOperatorEqual              RulesEngineOperator = "Equal"
	RulesEngineOperatorGeoMatch           RulesEngineOperator = "GeoMatch"
	RulesEngineOperatorGreaterThan        RulesEngineOperator = "GreaterThan"
	RulesEngineOperatorGreaterThanOrEqual RulesEngineOperator = "GreaterThanOrEqual"
	RulesEngineOperatorIPMatch            RulesEngineOperator = "IPMatch"
	RulesEngineOperatorLessThan           RulesEngineOperator = "LessThan"
	RulesEngineOperatorLessThanOrEqual    RulesEngineOperator = "LessThanOrEqual"
)

// PossibleRulesEngineOperatorValues returns the possible values for the RulesEngineOperator const type.
func PossibleRulesEngineOperatorValues() []RulesEngineOperator {
	return []RulesEngineOperator{
		RulesEngineOperatorAny,
		RulesEngineOperatorBeginsWith,
		RulesEngineOperatorContains,
		RulesEngineOperatorEndsWith,
		RulesEngineOperatorEqual,
		RulesEngineOperatorGeoMatch,
		RulesEngineOperatorGreaterThan,
		RulesEngineOperatorGreaterThanOrEqual,
		RulesEngineOperatorIPMatch,
		RulesEngineOperatorLessThan,
		RulesEngineOperatorLessThanOrEqual,
	}
}

// SKUName - Name of the pricing tier.
type SKUName string

const (
	SKUNameClassicAzureFrontDoor  SKUName = "Classic_AzureFrontDoor"
	SKUNamePremiumAzureFrontDoor  SKUName = "Premium_AzureFrontDoor"
	SKUNameStandardAzureFrontDoor SKUName = "Standard_AzureFrontDoor"
)

// PossibleSKUNameValues returns the possible values for the SKUName const type.
func PossibleSKUNameValues() []SKUName {
	return []SKUName{
		SKUNameClassicAzureFrontDoor,
		SKUNamePremiumAzureFrontDoor,
		SKUNameStandardAzureFrontDoor,
	}
}

// ScrubbingRuleEntryMatchOperator - When matchVariable is a collection, operate on the selector to specify which elements
// in the collection this rule applies to.
type ScrubbingRuleEntryMatchOperator string

const (
	ScrubbingRuleEntryMatchOperatorEquals    ScrubbingRuleEntryMatchOperator = "Equals"
	ScrubbingRuleEntryMatchOperatorEqualsAny ScrubbingRuleEntryMatchOperator = "EqualsAny"
)

// PossibleScrubbingRuleEntryMatchOperatorValues returns the possible values for the ScrubbingRuleEntryMatchOperator const type.
func PossibleScrubbingRuleEntryMatchOperatorValues() []ScrubbingRuleEntryMatchOperator {
	return []ScrubbingRuleEntryMatchOperator{
		ScrubbingRuleEntryMatchOperatorEquals,
		ScrubbingRuleEntryMatchOperatorEqualsAny,
	}
}

// ScrubbingRuleEntryMatchVariable - The variable to be scrubbed from the logs.
type ScrubbingRuleEntryMatchVariable string

const (
	ScrubbingRuleEntryMatchVariableQueryStringArgNames     ScrubbingRuleEntryMatchVariable = "QueryStringArgNames"
	ScrubbingRuleEntryMatchVariableRequestBodyJSONArgNames ScrubbingRuleEntryMatchVariable = "RequestBodyJsonArgNames"
	ScrubbingRuleEntryMatchVariableRequestBodyPostArgNames ScrubbingRuleEntryMatchVariable = "RequestBodyPostArgNames"
	ScrubbingRuleEntryMatchVariableRequestCookieNames      ScrubbingRuleEntryMatchVariable = "RequestCookieNames"
	ScrubbingRuleEntryMatchVariableRequestHeaderNames      ScrubbingRuleEntryMatchVariable = "RequestHeaderNames"
	ScrubbingRuleEntryMatchVariableRequestIPAddress        ScrubbingRuleEntryMatchVariable = "RequestIPAddress"
	ScrubbingRuleEntryMatchVariableRequestURI              ScrubbingRuleEntryMatchVariable = "RequestUri"
)

// PossibleScrubbingRuleEntryMatchVariableValues returns the possible values for the ScrubbingRuleEntryMatchVariable const type.
func PossibleScrubbingRuleEntryMatchVariableValues() []ScrubbingRuleEntryMatchVariable {
	return []ScrubbingRuleEntryMatchVariable{
		ScrubbingRuleEntryMatchVariableQueryStringArgNames,
		ScrubbingRuleEntryMatchVariableRequestBodyJSONArgNames,
		ScrubbingRuleEntryMatchVariableRequestBodyPostArgNames,
		ScrubbingRuleEntryMatchVariableRequestCookieNames,
		ScrubbingRuleEntryMatchVariableRequestHeaderNames,
		ScrubbingRuleEntryMatchVariableRequestIPAddress,
		ScrubbingRuleEntryMatchVariableRequestURI,
	}
}

// ScrubbingRuleEntryState - Defines the state of a log scrubbing rule. Default value is enabled.
type ScrubbingRuleEntryState string

const (
	ScrubbingRuleEntryStateDisabled ScrubbingRuleEntryState = "Disabled"
	ScrubbingRuleEntryStateEnabled  ScrubbingRuleEntryState = "Enabled"
)

// PossibleScrubbingRuleEntryStateValues returns the possible values for the ScrubbingRuleEntryState const type.
func PossibleScrubbingRuleEntryStateValues() []ScrubbingRuleEntryState {
	return []ScrubbingRuleEntryState{
		ScrubbingRuleEntryStateDisabled,
		ScrubbingRuleEntryStateEnabled,
	}
}

// SessionAffinityEnabledState - Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
type SessionAffinityEnabledState string

const (
	SessionAffinityEnabledStateDisabled SessionAffinityEnabledState = "Disabled"
	SessionAffinityEnabledStateEnabled  SessionAffinityEnabledState = "Enabled"
)

// PossibleSessionAffinityEnabledStateValues returns the possible values for the SessionAffinityEnabledState const type.
func PossibleSessionAffinityEnabledStateValues() []SessionAffinityEnabledState {
	return []SessionAffinityEnabledState{
		SessionAffinityEnabledStateDisabled,
		SessionAffinityEnabledStateEnabled,
	}
}

// State - The state of the Experiment
type State string

const (
	StateDisabled State = "Disabled"
	StateEnabled  State = "Enabled"
)

// PossibleStateValues returns the possible values for the State const type.
func PossibleStateValues() []State {
	return []State{
		StateDisabled,
		StateEnabled,
	}
}

type TimeseriesAggregationInterval string

const (
	TimeseriesAggregationIntervalDaily  TimeseriesAggregationInterval = "Daily"
	TimeseriesAggregationIntervalHourly TimeseriesAggregationInterval = "Hourly"
)

// PossibleTimeseriesAggregationIntervalValues returns the possible values for the TimeseriesAggregationInterval const type.
func PossibleTimeseriesAggregationIntervalValues() []TimeseriesAggregationInterval {
	return []TimeseriesAggregationInterval{
		TimeseriesAggregationIntervalDaily,
		TimeseriesAggregationIntervalHourly,
	}
}

// TimeseriesType - The type of Timeseries
type TimeseriesType string

const (
	TimeseriesTypeLatencyP50        TimeseriesType = "LatencyP50"
	TimeseriesTypeLatencyP75        TimeseriesType = "LatencyP75"
	TimeseriesTypeLatencyP95        TimeseriesType = "LatencyP95"
	TimeseriesTypeMeasurementCounts TimeseriesType = "MeasurementCounts"
)

// PossibleTimeseriesTypeValues returns the possible values for the TimeseriesType const type.
func PossibleTimeseriesTypeValues() []TimeseriesType {
	return []TimeseriesType{
		TimeseriesTypeLatencyP50,
		TimeseriesTypeLatencyP75,
		TimeseriesTypeLatencyP95,
		TimeseriesTypeMeasurementCounts,
	}
}

// Transform - Describes what transforms are applied before matching
type Transform string

const (
	TransformLowercase   Transform = "Lowercase"
	TransformRemoveNulls Transform = "RemoveNulls"
	TransformTrim        Transform = "Trim"
	TransformURLDecode   Transform = "UrlDecode"
	TransformURLEncode   Transform = "UrlEncode"
	TransformUppercase   Transform = "Uppercase"
)

// PossibleTransformValues returns the possible values for the Transform const type.
func PossibleTransformValues() []Transform {
	return []Transform{
		TransformLowercase,
		TransformRemoveNulls,
		TransformTrim,
		TransformURLDecode,
		TransformURLEncode,
		TransformUppercase,
	}
}

// TransformType - Describes what transforms applied before matching.
type TransformType string

const (
	TransformTypeLowercase   TransformType = "Lowercase"
	TransformTypeRemoveNulls TransformType = "RemoveNulls"
	TransformTypeTrim        TransformType = "Trim"
	TransformTypeURLDecode   TransformType = "UrlDecode"
	TransformTypeURLEncode   TransformType = "UrlEncode"
	TransformTypeUppercase   TransformType = "Uppercase"
)

// PossibleTransformTypeValues returns the possible values for the TransformType const type.
func PossibleTransformTypeValues() []TransformType {
	return []TransformType{
		TransformTypeLowercase,
		TransformTypeRemoveNulls,
		TransformTypeTrim,
		TransformTypeURLDecode,
		TransformTypeURLEncode,
		TransformTypeUppercase,
	}
}

// VariableName - Describes the supported variable for group by
type VariableName string

const (
	VariableNameGeoLocation VariableName = "GeoLocation"
	VariableNameNone        VariableName = "None"
	VariableNameSocketAddr  VariableName = "SocketAddr"
)

// PossibleVariableNameValues returns the possible values for the VariableName const type.
func PossibleVariableNameValues() []VariableName {
	return []VariableName{
		VariableNameGeoLocation,
		VariableNameNone,
		VariableNameSocketAddr,
	}
}

// WebApplicationFirewallScrubbingState - State of the log scrubbing config. Default value is Enabled.
type WebApplicationFirewallScrubbingState string

const (
	WebApplicationFirewallScrubbingStateDisabled WebApplicationFirewallScrubbingState = "Disabled"
	WebApplicationFirewallScrubbingStateEnabled  WebApplicationFirewallScrubbingState = "Enabled"
)

// PossibleWebApplicationFirewallScrubbingStateValues returns the possible values for the WebApplicationFirewallScrubbingState const type.
func PossibleWebApplicationFirewallScrubbingStateValues() []WebApplicationFirewallScrubbingState {
	return []WebApplicationFirewallScrubbingState{
		WebApplicationFirewallScrubbingStateDisabled,
		WebApplicationFirewallScrubbingStateEnabled,
	}
}
