//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devhub/armdevhub"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// DeveloperHubServiceServer is a fake server for instances of the armdevhub.DeveloperHubServiceClient type.
type DeveloperHubServiceServer struct {
	// GeneratePreviewArtifacts is the fake for method DeveloperHubServiceClient.GeneratePreviewArtifacts
	// HTTP status codes to indicate success: http.StatusOK
	GeneratePreviewArtifacts func(ctx context.Context, location string, parameters armdevhub.ArtifactGenerationProperties, options *armdevhub.DeveloperHubServiceClientGeneratePreviewArtifactsOptions) (resp azfake.Responder[armdevhub.DeveloperHubServiceClientGeneratePreviewArtifactsResponse], errResp azfake.ErrorResponder)

	// GitHubOAuth is the fake for method DeveloperHubServiceClient.GitHubOAuth
	// HTTP status codes to indicate success: http.StatusOK
	GitHubOAuth func(ctx context.Context, location string, options *armdevhub.DeveloperHubServiceClientGitHubOAuthOptions) (resp azfake.Responder[armdevhub.DeveloperHubServiceClientGitHubOAuthResponse], errResp azfake.ErrorResponder)

	// GitHubOAuthCallback is the fake for method DeveloperHubServiceClient.GitHubOAuthCallback
	// HTTP status codes to indicate success: http.StatusOK
	GitHubOAuthCallback func(ctx context.Context, location string, code string, state string, options *armdevhub.DeveloperHubServiceClientGitHubOAuthCallbackOptions) (resp azfake.Responder[armdevhub.DeveloperHubServiceClientGitHubOAuthCallbackResponse], errResp azfake.ErrorResponder)

	// ListGitHubOAuth is the fake for method DeveloperHubServiceClient.ListGitHubOAuth
	// HTTP status codes to indicate success: http.StatusOK
	ListGitHubOAuth func(ctx context.Context, location string, options *armdevhub.DeveloperHubServiceClientListGitHubOAuthOptions) (resp azfake.Responder[armdevhub.DeveloperHubServiceClientListGitHubOAuthResponse], errResp azfake.ErrorResponder)
}

// NewDeveloperHubServiceServerTransport creates a new instance of DeveloperHubServiceServerTransport with the provided implementation.
// The returned DeveloperHubServiceServerTransport instance is connected to an instance of armdevhub.DeveloperHubServiceClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDeveloperHubServiceServerTransport(srv *DeveloperHubServiceServer) *DeveloperHubServiceServerTransport {
	return &DeveloperHubServiceServerTransport{srv: srv}
}

// DeveloperHubServiceServerTransport connects instances of armdevhub.DeveloperHubServiceClient to instances of DeveloperHubServiceServer.
// Don't use this type directly, use NewDeveloperHubServiceServerTransport instead.
type DeveloperHubServiceServerTransport struct {
	srv *DeveloperHubServiceServer
}

// Do implements the policy.Transporter interface for DeveloperHubServiceServerTransport.
func (d *DeveloperHubServiceServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DeveloperHubServiceClient.GeneratePreviewArtifacts":
		resp, err = d.dispatchGeneratePreviewArtifacts(req)
	case "DeveloperHubServiceClient.GitHubOAuth":
		resp, err = d.dispatchGitHubOAuth(req)
	case "DeveloperHubServiceClient.GitHubOAuthCallback":
		resp, err = d.dispatchGitHubOAuthCallback(req)
	case "DeveloperHubServiceClient.ListGitHubOAuth":
		resp, err = d.dispatchListGitHubOAuth(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DeveloperHubServiceServerTransport) dispatchGeneratePreviewArtifacts(req *http.Request) (*http.Response, error) {
	if d.srv.GeneratePreviewArtifacts == nil {
		return nil, &nonRetriableError{errors.New("fake for method GeneratePreviewArtifacts not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevHub/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generatePreviewArtifacts`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdevhub.ArtifactGenerationProperties](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GeneratePreviewArtifacts(req.Context(), locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Value, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeveloperHubServiceServerTransport) dispatchGitHubOAuth(req *http.Request) (*http.Response, error) {
	if d.srv.GitHubOAuth == nil {
		return nil, &nonRetriableError{errors.New("fake for method GitHubOAuth not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevHub/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/githuboauth/default/getGitHubOAuthInfo`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdevhub.GitHubOAuthCallRequest](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	var options *armdevhub.DeveloperHubServiceClientGitHubOAuthOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armdevhub.DeveloperHubServiceClientGitHubOAuthOptions{
			Parameters: &body,
		}
	}
	respr, errRespr := d.srv.GitHubOAuth(req.Context(), locationParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GitHubOAuthInfoResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeveloperHubServiceServerTransport) dispatchGitHubOAuthCallback(req *http.Request) (*http.Response, error) {
	if d.srv.GitHubOAuthCallback == nil {
		return nil, &nonRetriableError{errors.New("fake for method GitHubOAuthCallback not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevHub/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/githuboauth/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	codeParam, err := url.QueryUnescape(qp.Get("code"))
	if err != nil {
		return nil, err
	}
	stateParam, err := url.QueryUnescape(qp.Get("state"))
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GitHubOAuthCallback(req.Context(), locationParam, codeParam, stateParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GitHubOAuthResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeveloperHubServiceServerTransport) dispatchListGitHubOAuth(req *http.Request) (*http.Response, error) {
	if d.srv.ListGitHubOAuth == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListGitHubOAuth not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevHub/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/githuboauth`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.ListGitHubOAuth(req.Context(), locationParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GitHubOAuthListResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
