//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdataprotection

import "time"

// AbsoluteDeleteOption - Delete option with duration
type AbsoluteDeleteOption struct {
	// REQUIRED; Duration of deletion after given timespan
	Duration *string

	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string
}

// GetDeleteOption implements the DeleteOptionClassification interface for type AbsoluteDeleteOption.
func (a *AbsoluteDeleteOption) GetDeleteOption() *DeleteOption {
	return &DeleteOption{
		Duration:   a.Duration,
		ObjectType: a.ObjectType,
	}
}

// AdHocBackupRuleOptions - Adhoc backup rules
type AdHocBackupRuleOptions struct {
	// REQUIRED
	RuleName *string

	// REQUIRED; Adhoc backup trigger option
	TriggerOption *AdhocBackupTriggerOption
}

// AdhocBackupTriggerOption - Adhoc backup trigger option
type AdhocBackupTriggerOption struct {
	RetentionTagOverride *string
}

// AdhocBasedTaggingCriteria - Adhoc backup tagging criteria
type AdhocBasedTaggingCriteria struct {
	// Retention tag information
	TagInfo *RetentionTag
}

// AdhocBasedTriggerContext - Adhoc trigger context
type AdhocBasedTriggerContext struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string

	// REQUIRED; Tagging Criteria containing retention tag for adhoc backup.
	TaggingCriteria *AdhocBasedTaggingCriteria
}

// GetTriggerContext implements the TriggerContextClassification interface for type AdhocBasedTriggerContext.
func (a *AdhocBasedTriggerContext) GetTriggerContext() *TriggerContext {
	return &TriggerContext{
		ObjectType: a.ObjectType,
	}
}

// AuthCredentials - Base class for different types of authentication credentials.
type AuthCredentials struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string
}

// GetAuthCredentials implements the AuthCredentialsClassification interface for type AuthCredentials.
func (a *AuthCredentials) GetAuthCredentials() *AuthCredentials { return a }

// AzureBackupDiscreteRecoveryPoint - Azure backup discrete RecoveryPoint
type AzureBackupDiscreteRecoveryPoint struct {
	// REQUIRED
	ObjectType *string

	// REQUIRED
	RecoveryPointTime              *time.Time
	FriendlyName                   *string
	PolicyName                     *string
	PolicyVersion                  *string
	RecoveryPointDataStoresDetails []*RecoveryPointDataStoreDetails
	RecoveryPointID                *string

	// Specifies recovery point completeness. Partial (i.e., only some of the intended items were backed up), or Completed (i.e.,
	// ALL intended items were backed up).
	RecoveryPointState  *RecoveryPointCompletionState
	RecoveryPointType   *string
	RetentionTagName    *string
	RetentionTagVersion *string

	// READ-ONLY
	ExpiryTime *time.Time
}

// GetAzureBackupRecoveryPoint implements the AzureBackupRecoveryPointClassification interface for type AzureBackupDiscreteRecoveryPoint.
func (a *AzureBackupDiscreteRecoveryPoint) GetAzureBackupRecoveryPoint() *AzureBackupRecoveryPoint {
	return &AzureBackupRecoveryPoint{
		ObjectType: a.ObjectType,
	}
}

// AzureBackupFindRestorableTimeRangesRequest - List Restore Ranges Request
type AzureBackupFindRestorableTimeRangesRequest struct {
	// REQUIRED; Gets or sets the type of the source data store.
	SourceDataStoreType *RestoreSourceDataStoreType

	// End time for the List Restore Ranges request. ISO 8601 format.
	EndTime *string

	// Start time for the List Restore Ranges request. ISO 8601 format.
	StartTime *string
}

// AzureBackupFindRestorableTimeRangesRequestResource - List Restore Ranges Request
type AzureBackupFindRestorableTimeRangesRequestResource struct {
	// AzureBackupFindRestorableTimeRangesRequestResource content
	Content     *AzureBackupFindRestorableTimeRangesRequest
	CultureInfo *string
	HTTPMethod  *string

	// Dictionary of
	Headers map[string][]*string

	// Dictionary of
	Parameters             map[string]*string
	SubscriptionID         *string
	SupportedGroupVersions []*string
	URI                    *string
}

// AzureBackupFindRestorableTimeRangesResponse - List Restore Ranges Response
type AzureBackupFindRestorableTimeRangesResponse struct {
	ObjectType *string

	// Returns the Restore Ranges available on the Backup Instance.
	RestorableTimeRanges []*RestorableTimeRange
}

// AzureBackupFindRestorableTimeRangesResponseResource - List Restore Ranges Response
type AzureBackupFindRestorableTimeRangesResponseResource struct {
	// AzureBackupFindRestorableTimeRangesResponseResource properties
	Properties *AzureBackupFindRestorableTimeRangesResponse

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// AzureBackupJob - AzureBackup Job Class
type AzureBackupJob struct {
	// REQUIRED; Job Activity Id
	ActivityID *string

	// REQUIRED; Name of the Backup Instance
	BackupInstanceFriendlyName *string

	// REQUIRED; ARM ID of the DataSource
	DataSourceID *string

	// REQUIRED; Location of the DataSource
	DataSourceLocation *string

	// REQUIRED; User Friendly Name of the DataSource
	DataSourceName *string

	// REQUIRED; Type of DataSource
	DataSourceType *string

	// REQUIRED; Indicated that whether the job is adhoc(true) or scheduled(false)
	IsUserTriggered *bool

	// REQUIRED; It indicates the type of Job i.e. Backup:full/log/diff ;Restore:ALR/OLR; Tiering:Backup/Archive ; Management:ConfigureProtection/UnConfigure
	Operation *string

	// REQUIRED; It indicates the type of Job i.e. Backup/Restore/Tiering/Management
	OperationCategory *string

	// REQUIRED; Indicated whether progress is enabled for the job
	ProgressEnabled *bool

	// REQUIRED; Resource Group Name of the Datasource
	SourceResourceGroup *string

	// REQUIRED; SubscriptionId corresponding to the DataSource
	SourceSubscriptionID *string

	// REQUIRED; StartTime of the job(in UTC)
	StartTime *time.Time

	// REQUIRED; Status of the job like InProgress/Success/Failed/Cancelled/SuccessWithWarning
	Status *string

	// REQUIRED; Subscription Id of the corresponding backup vault
	SubscriptionID *string

	// REQUIRED; List of supported actions
	SupportedActions []*string

	// REQUIRED; Name of the vault
	VaultName *string

	// Data Source Set Name of the DataSource
	DataSourceSetName        *string
	DestinationDataStoreName *string

	// Total run time of the job. ISO 8601 format.
	Duration            *string
	Etag                *string
	SourceDataStoreName *string

	// READ-ONLY; ARM ID of the Backup Instance
	BackupInstanceID *string

	// READ-ONLY; EndTime of the job(in UTC)
	EndTime *time.Time

	// READ-ONLY; A List, detailing the errors related to the job
	ErrorDetails []*UserFacingError

	// READ-ONLY; Extended Information about the job
	ExtendedInfo *JobExtendedInfo

	// READ-ONLY; ARM ID of the policy
	PolicyID *string

	// READ-ONLY; Name of the policy
	PolicyName *string

	// READ-ONLY; Url which contains job's progress
	ProgressURL *string

	// READ-ONLY; Priority to be used for rehydration
	RehydrationPriority *string

	// READ-ONLY; It indicates the sub type of operation i.e. in case of Restore it can be ALR/OLR
	RestoreType *string
}

// AzureBackupJobResource - AzureBackup Job Resource Class
type AzureBackupJobResource struct {
	// AzureBackupJobResource properties
	Properties *AzureBackupJob

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// AzureBackupJobResourceList - List of AzureBackup Job resources
type AzureBackupJobResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*AzureBackupJobResource
}

// AzureBackupParams - Azure backup parameters
type AzureBackupParams struct {
	// REQUIRED; BackupType ; Full/Incremental etc
	BackupType *string

	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string
}

// GetBackupParameters implements the BackupParametersClassification interface for type AzureBackupParams.
func (a *AzureBackupParams) GetBackupParameters() *BackupParameters {
	return &BackupParameters{
		ObjectType: a.ObjectType,
	}
}

// AzureBackupRecoveryPoint - Azure backup recoveryPoint
type AzureBackupRecoveryPoint struct {
	// REQUIRED
	ObjectType *string
}

// GetAzureBackupRecoveryPoint implements the AzureBackupRecoveryPointClassification interface for type AzureBackupRecoveryPoint.
func (a *AzureBackupRecoveryPoint) GetAzureBackupRecoveryPoint() *AzureBackupRecoveryPoint { return a }

// AzureBackupRecoveryPointBasedRestoreRequest - Azure backup recoveryPoint based restore request
type AzureBackupRecoveryPointBasedRestoreRequest struct {
	// REQUIRED
	ObjectType *string

	// REQUIRED
	RecoveryPointID *string

	// REQUIRED; Gets or sets the restore target information.
	RestoreTargetInfo RestoreTargetInfoBaseClassification

	// REQUIRED; Gets or sets the type of the source data store.
	SourceDataStoreType *SourceDataStoreType

	// Contains information of the Identity Details for the BI. If it is null, default will be considered as System Assigned.
	IdentityDetails *IdentityDetails

	// Fully qualified Azure Resource Manager ID of the datasource which is being recovered.
	SourceResourceID *string
}

// GetAzureBackupRecoveryPointBasedRestoreRequest implements the AzureBackupRecoveryPointBasedRestoreRequestClassification
// interface for type AzureBackupRecoveryPointBasedRestoreRequest.
func (a *AzureBackupRecoveryPointBasedRestoreRequest) GetAzureBackupRecoveryPointBasedRestoreRequest() *AzureBackupRecoveryPointBasedRestoreRequest {
	return a
}

// GetAzureBackupRestoreRequest implements the AzureBackupRestoreRequestClassification interface for type AzureBackupRecoveryPointBasedRestoreRequest.
func (a *AzureBackupRecoveryPointBasedRestoreRequest) GetAzureBackupRestoreRequest() *AzureBackupRestoreRequest {
	return &AzureBackupRestoreRequest{
		IdentityDetails:     a.IdentityDetails,
		ObjectType:          a.ObjectType,
		RestoreTargetInfo:   a.RestoreTargetInfo,
		SourceDataStoreType: a.SourceDataStoreType,
		SourceResourceID:    a.SourceResourceID,
	}
}

// AzureBackupRecoveryPointResource - Azure backup recoveryPoint resource
type AzureBackupRecoveryPointResource struct {
	// AzureBackupRecoveryPointResource properties
	Properties AzureBackupRecoveryPointClassification

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// AzureBackupRecoveryPointResourceList - Azure backup recoveryPoint resource list
type AzureBackupRecoveryPointResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*AzureBackupRecoveryPointResource
}

// AzureBackupRecoveryTimeBasedRestoreRequest - AzureBackup RecoveryPointTime Based Restore Request
type AzureBackupRecoveryTimeBasedRestoreRequest struct {
	// REQUIRED
	ObjectType *string

	// REQUIRED; The recovery time in ISO 8601 format example - 2020-08-14T17:30:00.0000000Z.
	RecoveryPointTime *string

	// REQUIRED; Gets or sets the restore target information.
	RestoreTargetInfo RestoreTargetInfoBaseClassification

	// REQUIRED; Gets or sets the type of the source data store.
	SourceDataStoreType *SourceDataStoreType

	// Contains information of the Identity Details for the BI. If it is null, default will be considered as System Assigned.
	IdentityDetails *IdentityDetails

	// Fully qualified Azure Resource Manager ID of the datasource which is being recovered.
	SourceResourceID *string
}

// GetAzureBackupRestoreRequest implements the AzureBackupRestoreRequestClassification interface for type AzureBackupRecoveryTimeBasedRestoreRequest.
func (a *AzureBackupRecoveryTimeBasedRestoreRequest) GetAzureBackupRestoreRequest() *AzureBackupRestoreRequest {
	return &AzureBackupRestoreRequest{
		IdentityDetails:     a.IdentityDetails,
		ObjectType:          a.ObjectType,
		RestoreTargetInfo:   a.RestoreTargetInfo,
		SourceDataStoreType: a.SourceDataStoreType,
		SourceResourceID:    a.SourceResourceID,
	}
}

// AzureBackupRehydrationRequest - Azure Backup Rehydrate Request
type AzureBackupRehydrationRequest struct {
	// REQUIRED; Id of the recovery point to be recovered
	RecoveryPointID *string

	// REQUIRED; Retention duration in ISO 8601 format i.e P10D .
	RehydrationRetentionDuration *string

	// Priority to be used for rehydration. Values High or Standard
	RehydrationPriority *RehydrationPriority
}

// AzureBackupRestoreRequest - Azure backup restore request
type AzureBackupRestoreRequest struct {
	// REQUIRED
	ObjectType *string

	// REQUIRED; Gets or sets the restore target information.
	RestoreTargetInfo RestoreTargetInfoBaseClassification

	// REQUIRED; Gets or sets the type of the source data store.
	SourceDataStoreType *SourceDataStoreType

	// Contains information of the Identity Details for the BI. If it is null, default will be considered as System Assigned.
	IdentityDetails *IdentityDetails

	// Fully qualified Azure Resource Manager ID of the datasource which is being recovered.
	SourceResourceID *string
}

// GetAzureBackupRestoreRequest implements the AzureBackupRestoreRequestClassification interface for type AzureBackupRestoreRequest.
func (a *AzureBackupRestoreRequest) GetAzureBackupRestoreRequest() *AzureBackupRestoreRequest {
	return a
}

// AzureBackupRestoreWithRehydrationRequest - AzureBackup Restore with Rehydration Request
type AzureBackupRestoreWithRehydrationRequest struct {
	// REQUIRED
	ObjectType *string

	// REQUIRED
	RecoveryPointID *string

	// REQUIRED; Priority to be used for rehydration. Values High or Standard
	RehydrationPriority *RehydrationPriority

	// REQUIRED; Retention duration in ISO 8601 format i.e P10D .
	RehydrationRetentionDuration *string

	// REQUIRED; Gets or sets the restore target information.
	RestoreTargetInfo RestoreTargetInfoBaseClassification

	// REQUIRED; Gets or sets the type of the source data store.
	SourceDataStoreType *SourceDataStoreType

	// Contains information of the Identity Details for the BI. If it is null, default will be considered as System Assigned.
	IdentityDetails *IdentityDetails

	// Fully qualified Azure Resource Manager ID of the datasource which is being recovered.
	SourceResourceID *string
}

// GetAzureBackupRecoveryPointBasedRestoreRequest implements the AzureBackupRecoveryPointBasedRestoreRequestClassification
// interface for type AzureBackupRestoreWithRehydrationRequest.
func (a *AzureBackupRestoreWithRehydrationRequest) GetAzureBackupRecoveryPointBasedRestoreRequest() *AzureBackupRecoveryPointBasedRestoreRequest {
	return &AzureBackupRecoveryPointBasedRestoreRequest{
		IdentityDetails:     a.IdentityDetails,
		ObjectType:          a.ObjectType,
		RecoveryPointID:     a.RecoveryPointID,
		RestoreTargetInfo:   a.RestoreTargetInfo,
		SourceDataStoreType: a.SourceDataStoreType,
		SourceResourceID:    a.SourceResourceID,
	}
}

// GetAzureBackupRestoreRequest implements the AzureBackupRestoreRequestClassification interface for type AzureBackupRestoreWithRehydrationRequest.
func (a *AzureBackupRestoreWithRehydrationRequest) GetAzureBackupRestoreRequest() *AzureBackupRestoreRequest {
	return &AzureBackupRestoreRequest{
		IdentityDetails:     a.IdentityDetails,
		ObjectType:          a.ObjectType,
		RestoreTargetInfo:   a.RestoreTargetInfo,
		SourceDataStoreType: a.SourceDataStoreType,
		SourceResourceID:    a.SourceResourceID,
	}
}

// AzureBackupRule - Azure backup rule
type AzureBackupRule struct {
	// REQUIRED; DataStoreInfo base
	DataStore *DataStoreInfoBase

	// REQUIRED
	Name *string

	// REQUIRED
	ObjectType *string

	// REQUIRED; Trigger context
	Trigger TriggerContextClassification

	// BackupParameters base
	BackupParameters BackupParametersClassification
}

// GetBasePolicyRule implements the BasePolicyRuleClassification interface for type AzureBackupRule.
func (a *AzureBackupRule) GetBasePolicyRule() *BasePolicyRule {
	return &BasePolicyRule{
		Name:       a.Name,
		ObjectType: a.ObjectType,
	}
}

// AzureMonitorAlertSettings - Settings for Azure Monitor based alerts
type AzureMonitorAlertSettings struct {
	AlertsForAllJobFailures *AlertsState
}

// AzureOperationalStoreParameters - Parameters for Operational-Tier DataStore
type AzureOperationalStoreParameters struct {
	// REQUIRED; type of datastore; Operational/Vault/Archive
	DataStoreType *DataStoreTypes

	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string

	// Gets or sets the Snapshot Resource Group Uri.
	ResourceGroupID *string
}

// GetDataStoreParameters implements the DataStoreParametersClassification interface for type AzureOperationalStoreParameters.
func (a *AzureOperationalStoreParameters) GetDataStoreParameters() *DataStoreParameters {
	return &DataStoreParameters{
		DataStoreType: a.DataStoreType,
		ObjectType:    a.ObjectType,
	}
}

// AzureRetentionRule - Azure retention rule
type AzureRetentionRule struct {
	// REQUIRED
	Lifecycles []*SourceLifeCycle

	// REQUIRED
	Name *string

	// REQUIRED
	ObjectType *string
	IsDefault  *bool
}

// GetBasePolicyRule implements the BasePolicyRuleClassification interface for type AzureRetentionRule.
func (a *AzureRetentionRule) GetBasePolicyRule() *BasePolicyRule {
	return &BasePolicyRule{
		Name:       a.Name,
		ObjectType: a.ObjectType,
	}
}

// BackupCriteria base class
type BackupCriteria struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string
}

// GetBackupCriteria implements the BackupCriteriaClassification interface for type BackupCriteria.
func (b *BackupCriteria) GetBackupCriteria() *BackupCriteria { return b }

// BackupDatasourceParameters - Parameters for Backup Datasource
type BackupDatasourceParameters struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string
}

// GetBackupDatasourceParameters implements the BackupDatasourceParametersClassification interface for type BackupDatasourceParameters.
func (b *BackupDatasourceParameters) GetBackupDatasourceParameters() *BackupDatasourceParameters {
	return b
}

// BackupInstance - Backup Instance
type BackupInstance struct {
	// REQUIRED; Gets or sets the data source information.
	DataSourceInfo *Datasource

	// REQUIRED
	ObjectType *string

	// REQUIRED; Gets or sets the policy information.
	PolicyInfo *PolicyInfo

	// Gets or sets the data source set information.
	DataSourceSetInfo *DatasourceSet

	// Credentials to use to authenticate with data source provider.
	DatasourceAuthCredentials AuthCredentialsClassification

	// Gets or sets the Backup Instance friendly name.
	FriendlyName *string

	// Contains information of the Identity Details for the BI. If it is null, default will be considered as System Assigned.
	IdentityDetails *IdentityDetails

	// Specifies the type of validation. In case of DeepValidation, all validations from /validateForBackup API will run again.
	ValidationType *ValidationType

	// READ-ONLY; Specifies the current protection state of the resource
	CurrentProtectionState *CurrentProtectionState

	// READ-ONLY; Specifies the protection error of the resource
	ProtectionErrorDetails *UserFacingError

	// READ-ONLY; Specifies the protection status of the resource
	ProtectionStatus *ProtectionStatusDetails

	// READ-ONLY; Specifies the provisioning state of the resource i.e. provisioning/updating/Succeeded/Failed
	ProvisioningState *string
}

// BackupInstanceResource - BackupInstance Resource
type BackupInstanceResource struct {
	// BackupInstanceResource properties
	Properties *BackupInstance

	// Proxy Resource tags.
	Tags map[string]*string

	// READ-ONLY; Proxy Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Proxy Resource name associated with the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Proxy Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// BackupInstanceResourceList - BackupInstance Resource list response
type BackupInstanceResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*BackupInstanceResource
}

// BackupParameters base
type BackupParameters struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string
}

// GetBackupParameters implements the BackupParametersClassification interface for type BackupParameters.
func (b *BackupParameters) GetBackupParameters() *BackupParameters { return b }

// BackupPolicy - Rule based backup policy
type BackupPolicy struct {
	// REQUIRED; Type of datasource for the backup management
	DatasourceTypes []*string

	// REQUIRED
	ObjectType *string

	// REQUIRED; Policy rule dictionary that contains rules for each backuptype i.e Full/Incremental/Logs etc
	PolicyRules []BasePolicyRuleClassification
}

// GetBaseBackupPolicy implements the BaseBackupPolicyClassification interface for type BackupPolicy.
func (b *BackupPolicy) GetBaseBackupPolicy() *BaseBackupPolicy {
	return &BaseBackupPolicy{
		DatasourceTypes: b.DatasourceTypes,
		ObjectType:      b.ObjectType,
	}
}

// BackupSchedule - Schedule for backup
type BackupSchedule struct {
	// REQUIRED; ISO 8601 repeating time interval format
	RepeatingTimeIntervals []*string

	// Time zone for a schedule. Example: Pacific Standard Time
	TimeZone *string
}

// BackupVault - Backup Vault
type BackupVault struct {
	// REQUIRED; Storage Settings
	StorageSettings []*StorageSetting

	// Feature Settings
	FeatureSettings *FeatureSettings

	// Monitoring Settings
	MonitoringSettings *MonitoringSettings

	// List of replicated regions for Backup Vault
	ReplicatedRegions []*string

	// Security Settings
	SecuritySettings *SecuritySettings

	// READ-ONLY; Is vault protected by resource guard
	IsVaultProtectedByResourceGuard *bool

	// READ-ONLY; Provisioning state of the BackupVault resource
	ProvisioningState *ProvisioningState

	// READ-ONLY; Resource move details for backup vault
	ResourceMoveDetails *ResourceMoveDetails

	// READ-ONLY; Resource move state for backup vault
	ResourceMoveState *ResourceMoveState

	// READ-ONLY; Secure Score of Backup Vault
	SecureScore *SecureScoreLevel
}

// BackupVaultResource - Backup Vault Resource
type BackupVaultResource struct {
	// REQUIRED; BackupVaultResource properties
	Properties *BackupVault

	// Optional ETag.
	ETag *string

	// Input Managed Identity Details
	Identity *DppIdentityDetails

	// Resource location.
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// BackupVaultResourceList - List of BackupVault resources
type BackupVaultResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*BackupVaultResource
}

// BaseBackupPolicy - BackupPolicy base
type BaseBackupPolicy struct {
	// REQUIRED; Type of datasource for the backup management
	DatasourceTypes []*string

	// REQUIRED
	ObjectType *string
}

// GetBaseBackupPolicy implements the BaseBackupPolicyClassification interface for type BaseBackupPolicy.
func (b *BaseBackupPolicy) GetBaseBackupPolicy() *BaseBackupPolicy { return b }

// BaseBackupPolicyResource - BaseBackupPolicy resource
type BaseBackupPolicyResource struct {
	// BaseBackupPolicyResource properties
	Properties BaseBackupPolicyClassification

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// BaseBackupPolicyResourceList - List of BaseBackupPolicy resources
type BaseBackupPolicyResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*BaseBackupPolicyResource
}

// BasePolicyRule - BasePolicy Rule
type BasePolicyRule struct {
	// REQUIRED
	Name *string

	// REQUIRED
	ObjectType *string
}

// GetBasePolicyRule implements the BasePolicyRuleClassification interface for type BasePolicyRule.
func (b *BasePolicyRule) GetBasePolicyRule() *BasePolicyRule { return b }

// BaseResourceProperties - Properties which are specific to datasource/datasourceSets
type BaseResourceProperties struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *ResourcePropertiesObjectType
}

// GetBaseResourceProperties implements the BaseResourcePropertiesClassification interface for type BaseResourceProperties.
func (b *BaseResourceProperties) GetBaseResourceProperties() *BaseResourceProperties { return b }

// BlobBackupDatasourceParameters - Parameters to be used during configuration of backup of blobs
type BlobBackupDatasourceParameters struct {
	// REQUIRED; List of containers to be backed up during configuration of backup of blobs
	ContainersList []*string

	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string
}

// GetBackupDatasourceParameters implements the BackupDatasourceParametersClassification interface for type BlobBackupDatasourceParameters.
func (b *BlobBackupDatasourceParameters) GetBackupDatasourceParameters() *BackupDatasourceParameters {
	return &BackupDatasourceParameters{
		ObjectType: b.ObjectType,
	}
}

// CheckNameAvailabilityRequest - CheckNameAvailability Request
type CheckNameAvailabilityRequest struct {
	// Resource name for which availability needs to be checked
	Name *string

	// Describes the Resource type: Microsoft.DataProtection/BackupVaults
	Type *string
}

// CheckNameAvailabilityResult - CheckNameAvailability Result
type CheckNameAvailabilityResult struct {
	// Gets or sets the message.
	Message *string

	// Gets or sets a value indicating whether [name available].
	NameAvailable *bool

	// Gets or sets the reason.
	Reason *string
}

// ClientDiscoveryDisplay - Localized display information of an operation.
type ClientDiscoveryDisplay struct {
	// Description of the operation having details of what operation is about.
	Description *string

	// Operations Name itself.
	Operation *string

	// Name of the provider for display purposes
	Provider *string

	// ResourceType for which this Operation can be performed.
	Resource *string
}

// ClientDiscoveryForLogSpecification - Class to represent shoebox log specification in json client discovery.
type ClientDiscoveryForLogSpecification struct {
	// blob duration of shoebox log specification
	BlobDuration *string

	// Localized display name
	DisplayName *string

	// Name for shoebox log specification.
	Name *string
}

// ClientDiscoveryForProperties - Class to represent shoebox properties in json client discovery.
type ClientDiscoveryForProperties struct {
	// Operation properties.
	ServiceSpecification *ClientDiscoveryForServiceSpecification
}

// ClientDiscoveryForServiceSpecification - Class to represent shoebox service specification in json client discovery.
type ClientDiscoveryForServiceSpecification struct {
	// List of log specifications of this operation.
	LogSpecifications []*ClientDiscoveryForLogSpecification
}

// ClientDiscoveryResponse - Operations List response which contains list of available APIs.
type ClientDiscoveryResponse struct {
	// Link to the next chunk of Response.
	NextLink *string

	// List of available operations.
	Value []*ClientDiscoveryValueForSingleAPI
}

// ClientDiscoveryValueForSingleAPI - Available operation details.
type ClientDiscoveryValueForSingleAPI struct {
	// Contains the localized display information for this particular operation
	Display *ClientDiscoveryDisplay

	// Indicates whether the operation is a data action
	IsDataAction *bool

	// Name of the Operation.
	Name *string

	// The intended executor of the operation;governs the display of the operation in the RBAC UX and the audit logs UX
	Origin *string

	// Properties for the given operation.
	Properties *ClientDiscoveryForProperties
}

// CopyOnExpiryOption - Copy on Expiry Option
type CopyOnExpiryOption struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string
}

// GetCopyOption implements the CopyOptionClassification interface for type CopyOnExpiryOption.
func (c *CopyOnExpiryOption) GetCopyOption() *CopyOption {
	return &CopyOption{
		ObjectType: c.ObjectType,
	}
}

// CopyOption - Options to copy
type CopyOption struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string
}

// GetCopyOption implements the CopyOptionClassification interface for type CopyOption.
func (c *CopyOption) GetCopyOption() *CopyOption { return c }

// CrossRegionRestoreDetails - Cross Region Restore details
type CrossRegionRestoreDetails struct {
	// REQUIRED
	SourceBackupInstanceID *string

	// REQUIRED
	SourceRegion *string
}

// CrossRegionRestoreJobRequest - Details of CRR Job to be fetched
type CrossRegionRestoreJobRequest struct {
	// REQUIRED
	JobID *string

	// REQUIRED
	SourceBackupVaultID *string

	// REQUIRED
	SourceRegion *string
}

// CrossRegionRestoreJobsRequest - Details of Backup Vault for which CRR Jobs are to be fetched
type CrossRegionRestoreJobsRequest struct {
	// REQUIRED
	SourceBackupVaultID *string

	// REQUIRED
	SourceRegion *string
}

// CrossRegionRestoreRequestObject - Cross Region Restore Request Object
type CrossRegionRestoreRequestObject struct {
	// REQUIRED; Cross region restore details.
	CrossRegionRestoreDetails *CrossRegionRestoreDetails

	// REQUIRED; Gets or sets the restore request object.
	RestoreRequestObject AzureBackupRestoreRequestClassification
}

type CrossRegionRestoreSettings struct {
	// CrossRegionRestore state
	State *CrossRegionRestoreState
}

// CrossSubscriptionRestoreSettings - CrossSubscriptionRestore Settings
type CrossSubscriptionRestoreSettings struct {
	// CrossSubscriptionRestore state
	State *CrossSubscriptionRestoreState
}

// CustomCopyOption - Duration based custom options to copy
type CustomCopyOption struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string

	// Data copied after given timespan
	Duration *string
}

// GetCopyOption implements the CopyOptionClassification interface for type CustomCopyOption.
func (c *CustomCopyOption) GetCopyOption() *CopyOption {
	return &CopyOption{
		ObjectType: c.ObjectType,
	}
}

// DataStoreInfoBase - DataStoreInfo base
type DataStoreInfoBase struct {
	// REQUIRED; type of datastore; Operational/Vault/Archive
	DataStoreType *DataStoreTypes

	// REQUIRED; Type of Datasource object, used to initialize the right inherited type
	ObjectType *string
}

// DataStoreParameters - Parameters for DataStore
type DataStoreParameters struct {
	// REQUIRED; type of datastore; Operational/Vault/Archive
	DataStoreType *DataStoreTypes

	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string
}

// GetDataStoreParameters implements the DataStoreParametersClassification interface for type DataStoreParameters.
func (d *DataStoreParameters) GetDataStoreParameters() *DataStoreParameters { return d }

// Datasource to be backed up
type Datasource struct {
	// REQUIRED; Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this will be the ID
	// created by backup service via Fabric/Vault.
	ResourceID *string

	// DatasourceType of the resource.
	DatasourceType *string

	// Type of Datasource object, used to initialize the right inherited type
	ObjectType *string

	// Location of datasource.
	ResourceLocation *string

	// Unique identifier of the resource in the context of parent.
	ResourceName *string

	// Properties specific to data source
	ResourceProperties BaseResourcePropertiesClassification

	// Resource Type of Datasource.
	ResourceType *string

	// Uri of the resource.
	ResourceURI *string
}

// DatasourceSet details of datasource to be backed up
type DatasourceSet struct {
	// REQUIRED; Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this will be the ID
	// created by backup service via Fabric/Vault.
	ResourceID *string

	// DatasourceType of the resource.
	DatasourceType *string

	// Type of Datasource object, used to initialize the right inherited type
	ObjectType *string

	// Location of datasource.
	ResourceLocation *string

	// Unique identifier of the resource in the context of parent.
	ResourceName *string

	// Properties specific to data source set
	ResourceProperties BaseResourcePropertiesClassification

	// Resource Type of Datasource.
	ResourceType *string

	// Uri of the resource.
	ResourceURI *string
}

// Day of the week
type Day struct {
	// Date of the month
	Date *int32

	// Whether Date is last date of month
	IsLast *bool
}

// DefaultResourceProperties - Default source properties
type DefaultResourceProperties struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *ResourcePropertiesObjectType
}

// GetBaseResourceProperties implements the BaseResourcePropertiesClassification interface for type DefaultResourceProperties.
func (d *DefaultResourceProperties) GetBaseResourceProperties() *BaseResourceProperties {
	return &BaseResourceProperties{
		ObjectType: d.ObjectType,
	}
}

// DeleteOption - Delete Option
type DeleteOption struct {
	// REQUIRED; Duration of deletion after given timespan
	Duration *string

	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string
}

// GetDeleteOption implements the DeleteOptionClassification interface for type DeleteOption.
func (d *DeleteOption) GetDeleteOption() *DeleteOption { return d }

// DeletedBackupInstance - Deleted Backup Instance
type DeletedBackupInstance struct {
	// REQUIRED; Gets or sets the data source information.
	DataSourceInfo *Datasource

	// REQUIRED
	ObjectType *string

	// REQUIRED; Gets or sets the policy information.
	PolicyInfo *PolicyInfo

	// Gets or sets the data source set information.
	DataSourceSetInfo *DatasourceSet

	// Credentials to use to authenticate with data source provider.
	DatasourceAuthCredentials AuthCredentialsClassification

	// Gets or sets the Backup Instance friendly name.
	FriendlyName *string

	// Contains information of the Identity Details for the BI. If it is null, default will be considered as System Assigned.
	IdentityDetails *IdentityDetails

	// Specifies the type of validation. In case of DeepValidation, all validations from /validateForBackup API will run again.
	ValidationType *ValidationType

	// READ-ONLY; Specifies the current protection state of the resource
	CurrentProtectionState *CurrentProtectionState

	// READ-ONLY; Deletion info of Backup Instance
	DeletionInfo *DeletionInfo

	// READ-ONLY; Specifies the protection error of the resource
	ProtectionErrorDetails *UserFacingError

	// READ-ONLY; Specifies the protection status of the resource
	ProtectionStatus *ProtectionStatusDetails

	// READ-ONLY; Specifies the provisioning state of the resource i.e. provisioning/updating/Succeeded/Failed
	ProvisioningState *string
}

// DeletedBackupInstanceResource - Deleted Backup Instance
type DeletedBackupInstanceResource struct {
	// DeletedBackupInstanceResource properties
	Properties *DeletedBackupInstance

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// DeletedBackupInstanceResourceList - List of DeletedBackupInstance resources
type DeletedBackupInstanceResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*DeletedBackupInstanceResource
}

// DeletionInfo - Deletion Info
type DeletionInfo struct {
	// READ-ONLY; Specifies billing end date
	BillingEndDate *string

	// READ-ONLY; Delete activity ID for troubleshooting purpose
	DeleteActivityID *string

	// READ-ONLY; Specifies time of deletion
	DeletionTime *string

	// READ-ONLY; Specifies purge time
	ScheduledPurgeTime *string
}

// DppBaseResource - Base resource under Microsoft.DataProtection provider namespace
type DppBaseResource struct {
	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// DppBaseResourceList - Base for all lists of V2 resources.
type DppBaseResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of Dpp resources.
	Value []*DppBaseResource
}

type DppBaseTrackedResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// DppIdentityDetails - Identity details
type DppIdentityDetails struct {
	// The identityType which can be either SystemAssigned, UserAssigned, 'SystemAssigned,UserAssigned' or None
	Type *string

	// Gets or sets the user assigned identities.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The object ID of the service principal object for the managed identity that is used to grant role-based access
	// to an Azure resource.
	PrincipalID *string

	// READ-ONLY; A Globally Unique Identifier (GUID) that represents the Azure AD tenant where the resource is now a member.
	TenantID *string
}

type DppProxyResource struct {
	// Proxy Resource tags.
	Tags map[string]*string

	// READ-ONLY; Proxy Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Proxy Resource name associated with the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Proxy Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// DppResource - Resource class
type DppResource struct {
	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// DppResourceList - ListResource
type DppResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string
}

type DppTrackedResource struct {
	// Optional ETag.
	ETag *string

	// Input Managed Identity Details
	Identity *DppIdentityDetails

	// Resource location.
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

type DppTrackedResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string
}

type DppWorkerRequest struct {
	CultureInfo *string
	HTTPMethod  *string

	// Dictionary of
	Headers map[string][]*string

	// Dictionary of
	Parameters             map[string]*string
	SubscriptionID         *string
	SupportedGroupVersions []*string
	URI                    *string
}

// Error - The resource management error response.
type Error struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*Error

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// ExportJobsResult - The result for export jobs containing blob details.
type ExportJobsResult struct {
	// READ-ONLY; SAS key to access the blob.
	BlobSasKey *string

	// READ-ONLY; URL of the blob into which the serialized string of list of jobs is exported.
	BlobURL *string

	// READ-ONLY; SAS key to access the ExcelFile blob.
	ExcelFileBlobSasKey *string

	// READ-ONLY; URL of the blob into which the ExcelFile is uploaded.
	ExcelFileBlobURL *string
}

// FeatureSettings - Class containing feature settings of vault
type FeatureSettings struct {
	CrossRegionRestoreSettings *CrossRegionRestoreSettings

	// CrossSubscriptionRestore Settings
	CrossSubscriptionRestoreSettings *CrossSubscriptionRestoreSettings
}

// FeatureValidationRequest - Base class for feature object
type FeatureValidationRequest struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string

	// backup support feature name.
	FeatureName *string

	// backup support feature type.
	FeatureType *FeatureType
}

// GetFeatureValidationRequestBase implements the FeatureValidationRequestBaseClassification interface for type FeatureValidationRequest.
func (f *FeatureValidationRequest) GetFeatureValidationRequestBase() *FeatureValidationRequestBase {
	return &FeatureValidationRequestBase{
		ObjectType: f.ObjectType,
	}
}

// FeatureValidationRequestBase - Base class for Backup Feature support
type FeatureValidationRequestBase struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string
}

// GetFeatureValidationRequestBase implements the FeatureValidationRequestBaseClassification interface for type FeatureValidationRequestBase.
func (f *FeatureValidationRequestBase) GetFeatureValidationRequestBase() *FeatureValidationRequestBase {
	return f
}

// FeatureValidationResponse - Feature Validation Response
type FeatureValidationResponse struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string

	// backup support feature type.
	FeatureType *FeatureType

	// Response features
	Features []*SupportedFeature
}

// GetFeatureValidationResponseBase implements the FeatureValidationResponseBaseClassification interface for type FeatureValidationResponse.
func (f *FeatureValidationResponse) GetFeatureValidationResponseBase() *FeatureValidationResponseBase {
	return &FeatureValidationResponseBase{
		ObjectType: f.ObjectType,
	}
}

// FeatureValidationResponseBase - Base class for Backup Feature support
type FeatureValidationResponseBase struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string
}

// GetFeatureValidationResponseBase implements the FeatureValidationResponseBaseClassification interface for type FeatureValidationResponseBase.
func (f *FeatureValidationResponseBase) GetFeatureValidationResponseBase() *FeatureValidationResponseBase {
	return f
}

// FetchSecondaryRPsRequestParameters - Information about BI whose secondary RecoveryPoints are requested Source region and
// BI ARM path
type FetchSecondaryRPsRequestParameters struct {
	// ARM Path of BackupInstance
	SourceBackupInstanceID *string

	// Source region in which BackupInstance is located
	SourceRegion *string
}

type IdentityDetails struct {
	// Specifies if the BI is protected by System Identity.
	UseSystemAssignedIdentity *bool

	// ARM URL for User Assigned Identity.
	UserAssignedIdentityArmURL *string
}

// ImmediateCopyOption - Immediate copy Option
type ImmediateCopyOption struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string
}

// GetCopyOption implements the CopyOptionClassification interface for type ImmediateCopyOption.
func (i *ImmediateCopyOption) GetCopyOption() *CopyOption {
	return &CopyOption{
		ObjectType: i.ObjectType,
	}
}

// ImmutabilitySettings - Immutability Settings at vault level
type ImmutabilitySettings struct {
	// Immutability state
	State *ImmutabilityState
}

// InnerError - Inner Error
type InnerError struct {
	// Any Key value pairs that can be provided to the client for additional verbose information.
	AdditionalInfo map[string]*string

	// Unique code for this error
	Code *string

	// Child Inner Error, to allow Nesting.
	EmbeddedInnerError *InnerError
}

// ItemLevelRestoreCriteria - Class to contain criteria for item level restore
type ItemLevelRestoreCriteria struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string
}

// GetItemLevelRestoreCriteria implements the ItemLevelRestoreCriteriaClassification interface for type ItemLevelRestoreCriteria.
func (i *ItemLevelRestoreCriteria) GetItemLevelRestoreCriteria() *ItemLevelRestoreCriteria { return i }

// ItemLevelRestoreTargetInfo - Restore target info for Item level restore operation
type ItemLevelRestoreTargetInfo struct {
	// REQUIRED; Information of target DS
	DatasourceInfo *Datasource

	// REQUIRED; Type of Datasource object, used to initialize the right inherited type
	ObjectType *string

	// REQUIRED; Recovery Option
	RecoveryOption *RecoveryOption

	// REQUIRED; Restore Criteria
	RestoreCriteria []ItemLevelRestoreCriteriaClassification

	// Credentials to use to authenticate with data source provider.
	DatasourceAuthCredentials AuthCredentialsClassification

	// Information of target DS Set
	DatasourceSetInfo *DatasourceSet

	// Target Restore region
	RestoreLocation *string
}

// GetRestoreTargetInfoBase implements the RestoreTargetInfoBaseClassification interface for type ItemLevelRestoreTargetInfo.
func (i *ItemLevelRestoreTargetInfo) GetRestoreTargetInfoBase() *RestoreTargetInfoBase {
	return &RestoreTargetInfoBase{
		ObjectType:      i.ObjectType,
		RecoveryOption:  i.RecoveryOption,
		RestoreLocation: i.RestoreLocation,
	}
}

// ItemPathBasedRestoreCriteria - Prefix criteria to be used to during restore
type ItemPathBasedRestoreCriteria struct {
	// REQUIRED; Flag to specify if the path is relative to backup item or full path
	IsPathRelativeToBackupItem *bool

	// REQUIRED; The path of the item to be restored. It could be the full path of the item or the path relative to the backup
	// item
	ItemPath *string

	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string

	// The list of prefix strings to be used as filter criteria during restore. These are relative to the item path specified.
	SubItemPathPrefix []*string
}

// GetItemLevelRestoreCriteria implements the ItemLevelRestoreCriteriaClassification interface for type ItemPathBasedRestoreCriteria.
func (i *ItemPathBasedRestoreCriteria) GetItemLevelRestoreCriteria() *ItemLevelRestoreCriteria {
	return &ItemLevelRestoreCriteria{
		ObjectType: i.ObjectType,
	}
}

// JobExtendedInfo - Extended Information about the job
type JobExtendedInfo struct {
	// Job's Additional Details
	AdditionalDetails map[string]*string

	// READ-ONLY; State of the Backup Instance
	BackupInstanceState *string

	// READ-ONLY; Number of bytes transferred
	DataTransferredInBytes *float64

	// READ-ONLY; Destination where restore is done
	RecoveryDestination *string

	// READ-ONLY; Details of the Source Recovery Point
	SourceRecoverPoint *RestoreJobRecoveryPointDetails

	// READ-ONLY; List of Sub Tasks of the job
	SubTasks []*JobSubTask

	// READ-ONLY; Details of the Target Recovery Point
	TargetRecoverPoint *RestoreJobRecoveryPointDetails

	// READ-ONLY; A List, detailing the warnings related to the job
	WarningDetails []*UserFacingWarningDetail
}

// JobSubTask - Details of Job's Sub Task
type JobSubTask struct {
	// REQUIRED; Task Id of the Sub Task
	TaskID *int32

	// REQUIRED; Name of the Sub Task
	TaskName *string

	// REQUIRED; Status of the Sub Task
	TaskStatus *string

	// Additional details of Sub Tasks
	AdditionalDetails map[string]*string

	// READ-ONLY; Progress of the Sub Task
	TaskProgress *string
}

// KubernetesClusterBackupDatasourceParameters - Parameters for Kubernetes Cluster Backup Datasource
type KubernetesClusterBackupDatasourceParameters struct {
	// REQUIRED; Gets or sets the include cluster resources property. This property if enabled will include cluster scope resources
	// during backup.
	IncludeClusterScopeResources *bool

	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string

	// REQUIRED; Gets or sets the volume snapshot property. This property if enabled will take volume snapshots during backup.
	SnapshotVolumes *bool

	// Gets or sets the backup hook references. This property sets the hook reference to be executed during backup.
	BackupHookReferences []*NamespacedNameResource

	// Gets or sets the exclude namespaces property. This property sets the namespaces to be excluded during backup.
	ExcludedNamespaces []*string

	// Gets or sets the exclude resource types property. This property sets the resource types to be excluded during backup.
	ExcludedResourceTypes []*string

	// Gets or sets the include namespaces property. This property sets the namespaces to be included during backup.
	IncludedNamespaces []*string

	// Gets or sets the include resource types property. This property sets the resource types to be included during backup.
	IncludedResourceTypes []*string

	// Gets or sets the LabelSelectors property. This property sets the resource with such label selectors to be included during
	// backup.
	LabelSelectors []*string
}

// GetBackupDatasourceParameters implements the BackupDatasourceParametersClassification interface for type KubernetesClusterBackupDatasourceParameters.
func (k *KubernetesClusterBackupDatasourceParameters) GetBackupDatasourceParameters() *BackupDatasourceParameters {
	return &BackupDatasourceParameters{
		ObjectType: k.ObjectType,
	}
}

// KubernetesClusterRestoreCriteria - kubernetes Cluster Backup target info for restore operation
type KubernetesClusterRestoreCriteria struct {
	// REQUIRED; Gets or sets the include cluster resources property. This property if enabled will include cluster scope resources
	// during restore.
	IncludeClusterScopeResources *bool

	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string

	// Gets or sets the Conflict Policy property. This property sets policy during conflict of resources during restore.
	ConflictPolicy *ExistingResourcePolicy

	// Gets or sets the exclude namespaces property. This property sets the namespaces to be excluded during restore.
	ExcludedNamespaces []*string

	// Gets or sets the exclude resource types property. This property sets the resource types to be excluded during restore.
	ExcludedResourceTypes []*string

	// Gets or sets the include namespaces property. This property sets the namespaces to be included during restore.
	IncludedNamespaces []*string

	// Gets or sets the include resource types property. This property sets the resource types to be included during restore.
	IncludedResourceTypes []*string

	// Gets or sets the LabelSelectors property. This property sets the resource with such label selectors to be included during
	// restore.
	LabelSelectors []*string

	// Gets or sets the Namespace Mappings property. This property sets if namespace needs to be change during restore.
	NamespaceMappings map[string]*string

	// Gets or sets the PV (Persistent Volume) Restore Mode property. This property sets whether volumes needs to be restored.
	PersistentVolumeRestoreMode *PersistentVolumeRestoreMode

	// Gets or sets the restore hook references. This property sets the hook reference to be executed during restore.
	RestoreHookReferences []*NamespacedNameResource
}

// GetItemLevelRestoreCriteria implements the ItemLevelRestoreCriteriaClassification interface for type KubernetesClusterRestoreCriteria.
func (k *KubernetesClusterRestoreCriteria) GetItemLevelRestoreCriteria() *ItemLevelRestoreCriteria {
	return &ItemLevelRestoreCriteria{
		ObjectType: k.ObjectType,
	}
}

// KubernetesClusterVaultTierRestoreCriteria - kubernetes Cluster Backup target info for restore operation from vault
type KubernetesClusterVaultTierRestoreCriteria struct {
	// REQUIRED; Gets or sets the include cluster resources property. This property if enabled will include cluster scope resources
	// during restore from vault.
	IncludeClusterScopeResources *bool

	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string

	// Gets or sets the Conflict Policy property. This property sets policy during conflict of resources during restore from vault.
	ConflictPolicy *ExistingResourcePolicy

	// Gets or sets the exclude namespaces property. This property sets the namespaces to be excluded during restore from vault.
	ExcludedNamespaces []*string

	// Gets or sets the exclude resource types property. This property sets the resource types to be excluded during restore from
	// vault.
	ExcludedResourceTypes []*string

	// Gets or sets the include namespaces property. This property sets the namespaces to be included during restore from vault.
	IncludedNamespaces []*string

	// Gets or sets the include resource types property. This property sets the resource types to be included during restore from
	// vault.
	IncludedResourceTypes []*string

	// Gets or sets the LabelSelectors property. This property sets the resource with such label selectors to be included during
	// restore from vault.
	LabelSelectors []*string

	// Gets or sets the Namespace Mappings property. This property sets if namespace needs to be change during restore from vault.
	NamespaceMappings map[string]*string

	// Gets or sets the PV (Persistent Volume) Restore Mode property. This property sets whether volumes needs to be restored
	// from vault.
	PersistentVolumeRestoreMode *PersistentVolumeRestoreMode

	// Gets or sets the restore hook references. This property sets the hook reference to be executed during restore from vault.
	RestoreHookReferences []*NamespacedNameResource

	// Gets or sets the staging RG Id for creating staging disks and snapshots during restore from vault.
	StagingResourceGroupID *string

	// Gets or sets the staging Storage Account Id for creating backup extension object store data during restore from vault.
	StagingStorageAccountID *string
}

// GetItemLevelRestoreCriteria implements the ItemLevelRestoreCriteriaClassification interface for type KubernetesClusterVaultTierRestoreCriteria.
func (k *KubernetesClusterVaultTierRestoreCriteria) GetItemLevelRestoreCriteria() *ItemLevelRestoreCriteria {
	return &ItemLevelRestoreCriteria{
		ObjectType: k.ObjectType,
	}
}

// KubernetesPVRestoreCriteria - Item Level kubernetes persistent volume target info for restore operation
type KubernetesPVRestoreCriteria struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string

	// Selected persistent volume claim name
	Name *string

	// Selected storage class name for restore operation
	StorageClassName *string
}

// GetItemLevelRestoreCriteria implements the ItemLevelRestoreCriteriaClassification interface for type KubernetesPVRestoreCriteria.
func (k *KubernetesPVRestoreCriteria) GetItemLevelRestoreCriteria() *ItemLevelRestoreCriteria {
	return &ItemLevelRestoreCriteria{
		ObjectType: k.ObjectType,
	}
}

// KubernetesStorageClassRestoreCriteria - Item Level kubernetes storage class target info for restore operation
type KubernetesStorageClassRestoreCriteria struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string

	// Provisioner of the storage class
	Provisioner *string

	// Selected storage class name
	SelectedStorageClassName *string
}

// GetItemLevelRestoreCriteria implements the ItemLevelRestoreCriteriaClassification interface for type KubernetesStorageClassRestoreCriteria.
func (k *KubernetesStorageClassRestoreCriteria) GetItemLevelRestoreCriteria() *ItemLevelRestoreCriteria {
	return &ItemLevelRestoreCriteria{
		ObjectType: k.ObjectType,
	}
}

// MonitoringSettings - Monitoring Settings
type MonitoringSettings struct {
	// Settings for Azure Monitor based alerts
	AzureMonitorAlertSettings *AzureMonitorAlertSettings
}

// NamespacedNameResource - Class to refer resources which contains namespace and name
type NamespacedNameResource struct {
	// Name of the resource
	Name *string

	// Namespace in which the resource exists
	Namespace *string
}

// OperationExtendedInfo - Operation Extended Info
type OperationExtendedInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string
}

// GetOperationExtendedInfo implements the OperationExtendedInfoClassification interface for type OperationExtendedInfo.
func (o *OperationExtendedInfo) GetOperationExtendedInfo() *OperationExtendedInfo { return o }

// OperationJobExtendedInfo - Operation Job Extended Info
type OperationJobExtendedInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Name or Arm Id of the job created for this operation.
	JobID *string
}

// GetOperationExtendedInfo implements the OperationExtendedInfoClassification interface for type OperationJobExtendedInfo.
func (o *OperationJobExtendedInfo) GetOperationExtendedInfo() *OperationExtendedInfo {
	return &OperationExtendedInfo{
		ObjectType: o.ObjectType,
	}
}

// OperationResource - Operation Resource
type OperationResource struct {
	// End time of the operation
	EndTime *time.Time

	// Required if status == failed or status == canceled. This is the OData v4 error format, used by the RPC and will go into
	// the v2.2 Azure REST API guidelines. The full set of optional properties (e.g.
	// inner errors / details) can be found in the "Error Response" section.
	Error *Error

	// It should match what is used to GET the operation result
	ID *string

	// It must match the last segment of the "id" field, and will typically be a GUID / system generated value
	Name *string

	// End time of the operation
	Properties OperationExtendedInfoClassification

	// Start time of the operation
	StartTime *time.Time
	Status    *string
}

// PatchBackupVaultInput - Backup Vault Contract for Patch Backup Vault API.
type PatchBackupVaultInput struct {
	// Feature Settings
	FeatureSettings *FeatureSettings

	// Monitoring Settings
	MonitoringSettings *MonitoringSettings

	// Security Settings
	SecuritySettings *SecuritySettings
}

// PatchResourceGuardInput - Patch Request content for Microsoft.DataProtection Resource Guard resources
type PatchResourceGuardInput struct {
	// Resource Guard tags.
	Tags map[string]*string
}

// PatchResourceRequestInput - Patch Request content for Microsoft.DataProtection resources
type PatchResourceRequestInput struct {
	// Input Managed Identity Details
	Identity *DppIdentityDetails

	// Resource properties.
	Properties *PatchBackupVaultInput

	// Resource tags.
	Tags map[string]*string
}

// PolicyInfo - Policy Info in backupInstance
type PolicyInfo struct {
	// REQUIRED
	PolicyID *string

	// Policy parameters for the backup instance
	PolicyParameters *PolicyParameters

	// READ-ONLY
	PolicyVersion *string
}

// PolicyParameters - Parameters in Policy
type PolicyParameters struct {
	// Gets or sets the Backup Data Source Parameters
	BackupDatasourceParametersList []BackupDatasourceParametersClassification

	// Gets or sets the DataStore Parameters
	DataStoreParametersList []DataStoreParametersClassification
}

// ProtectionStatusDetails - Protection status details
type ProtectionStatusDetails struct {
	// Specifies the protection status error of the resource
	ErrorDetails *UserFacingError

	// Specifies the protection status of the resource
	Status *Status
}

// RangeBasedItemLevelRestoreCriteria - Item Level target info for restore operation
type RangeBasedItemLevelRestoreCriteria struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string

	// maximum value for range prefix match
	MaxMatchingValue *string

	// minimum value for range prefix match
	MinMatchingValue *string
}

// GetItemLevelRestoreCriteria implements the ItemLevelRestoreCriteriaClassification interface for type RangeBasedItemLevelRestoreCriteria.
func (r *RangeBasedItemLevelRestoreCriteria) GetItemLevelRestoreCriteria() *ItemLevelRestoreCriteria {
	return &ItemLevelRestoreCriteria{
		ObjectType: r.ObjectType,
	}
}

// RecoveryPointDataStoreDetails - RecoveryPoint datastore details
type RecoveryPointDataStoreDetails struct {
	CreationTime *time.Time
	ExpiryTime   *time.Time
	ID           *string
	MetaData     *string
	State        *string
	Type         *string
	Visible      *bool

	// READ-ONLY
	RehydrationExpiryTime *time.Time

	// READ-ONLY
	RehydrationStatus *RehydrationStatus
}

type RecoveryPointsFilters struct {
	EndDate                 *string
	ExtendedInfo            *bool
	IsVisible               *bool
	RestorePointDataStoreID *string
	RestorePointState       *string
	StartDate               *string
}

type ResourceGuard struct {
	// List of critical operations which are not protected by this resourceGuard
	VaultCriticalOperationExclusionList []*string

	// READ-ONLY; This flag indicates whether auto approval is allowed or not.
	AllowAutoApprovals *bool

	// READ-ONLY; Description about the pre-req steps to perform all the critical operations.
	Description *string

	// READ-ONLY; Provisioning state of the BackupVault resource
	ProvisioningState *ProvisioningState

	// READ-ONLY; {readonly} List of operation details those are protected by the ResourceGuard resource
	ResourceGuardOperations []*ResourceGuardOperation
}

// ResourceGuardOperation - This class contains all the details about a critical operation.
type ResourceGuardOperation struct {
	// READ-ONLY; Type of resource request.
	RequestResourceType *string

	// READ-ONLY; Name of the critical operation.
	VaultCriticalOperation *string
}

// ResourceGuardOperationDetail - VaultCritical Operation protected by a resource guard
type ResourceGuardOperationDetail struct {
	DefaultResourceRequest *string
	VaultCriticalOperation *string
}

// ResourceGuardProxyBase object, used in ResourceGuardProxyBaseResource
type ResourceGuardProxyBase struct {
	Description                   *string
	LastUpdatedTime               *string
	ResourceGuardOperationDetails []*ResourceGuardOperationDetail
	ResourceGuardResourceID       *string
}

// ResourceGuardProxyBaseResource object, used for response and request bodies for ResourceGuardProxy APIs
type ResourceGuardProxyBaseResource struct {
	// ResourceGuardProxyBaseResource properties
	Properties *ResourceGuardProxyBase

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// ResourceGuardProxyBaseResourceList - List of ResourceGuardProxyBase resources
type ResourceGuardProxyBaseResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*ResourceGuardProxyBaseResource
}

type ResourceGuardResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// ResourceGuardResource properties
	Properties *ResourceGuard

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// ResourceGuardResourceList - List of ResourceGuard resources
type ResourceGuardResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*ResourceGuardResource
}

// ResourceMoveDetails will be returned in response to GetResource call from ARM
type ResourceMoveDetails struct {
	// Completion time in UTC of latest ResourceMove operation attempted. ISO 8601 format.
	CompletionTimeUTC *string

	// CorrelationId of latest ResourceMove operation attempted
	OperationID *string

	// ARM resource path of source resource
	SourceResourcePath *string

	// Start time in UTC of latest ResourceMove operation attempted. ISO 8601 format.
	StartTimeUTC *string

	// ARM resource path of target resource used in latest ResourceMove operation
	TargetResourcePath *string
}

type RestorableTimeRange struct {
	// REQUIRED; End time for the available restore range
	EndTime *string

	// REQUIRED; Start time for the available restore range
	StartTime  *string
	ObjectType *string
}

// RestoreFilesTargetInfo - Class encapsulating restore as files target parameters
type RestoreFilesTargetInfo struct {
	// REQUIRED; Type of Datasource object, used to initialize the right inherited type
	ObjectType *string

	// REQUIRED; Recovery Option
	RecoveryOption *RecoveryOption

	// REQUIRED; Destination of RestoreAsFiles operation, when destination is not a datasource
	TargetDetails *TargetDetails

	// Target Restore region
	RestoreLocation *string
}

// GetRestoreTargetInfoBase implements the RestoreTargetInfoBaseClassification interface for type RestoreFilesTargetInfo.
func (r *RestoreFilesTargetInfo) GetRestoreTargetInfoBase() *RestoreTargetInfoBase {
	return &RestoreTargetInfoBase{
		ObjectType:      r.ObjectType,
		RecoveryOption:  r.RecoveryOption,
		RestoreLocation: r.RestoreLocation,
	}
}

type RestoreJobRecoveryPointDetails struct {
	RecoveryPointID   *string
	RecoveryPointTime *time.Time
}

// RestoreTargetInfo - Class encapsulating restore target parameters
type RestoreTargetInfo struct {
	// REQUIRED; Information of target DS
	DatasourceInfo *Datasource

	// REQUIRED; Type of Datasource object, used to initialize the right inherited type
	ObjectType *string

	// REQUIRED; Recovery Option
	RecoveryOption *RecoveryOption

	// Credentials to use to authenticate with data source provider.
	DatasourceAuthCredentials AuthCredentialsClassification

	// Information of target DS Set
	DatasourceSetInfo *DatasourceSet

	// Target Restore region
	RestoreLocation *string
}

// GetRestoreTargetInfoBase implements the RestoreTargetInfoBaseClassification interface for type RestoreTargetInfo.
func (r *RestoreTargetInfo) GetRestoreTargetInfoBase() *RestoreTargetInfoBase {
	return &RestoreTargetInfoBase{
		ObjectType:      r.ObjectType,
		RecoveryOption:  r.RecoveryOption,
		RestoreLocation: r.RestoreLocation,
	}
}

// RestoreTargetInfoBase - Base class common to RestoreTargetInfo and RestoreFilesTargetInfo
type RestoreTargetInfoBase struct {
	// REQUIRED; Type of Datasource object, used to initialize the right inherited type
	ObjectType *string

	// REQUIRED; Recovery Option
	RecoveryOption *RecoveryOption

	// Target Restore region
	RestoreLocation *string
}

// GetRestoreTargetInfoBase implements the RestoreTargetInfoBaseClassification interface for type RestoreTargetInfoBase.
func (r *RestoreTargetInfoBase) GetRestoreTargetInfoBase() *RestoreTargetInfoBase { return r }

// RetentionTag - Retention tag
type RetentionTag struct {
	// REQUIRED; Retention Tag Name to relate it to retention rule.
	TagName *string

	// READ-ONLY; Retention Tag version.
	ETag *string

	// READ-ONLY; Retention Tag version.
	ID *string
}

// ScheduleBasedBackupCriteria - Schedule based backup criteria
type ScheduleBasedBackupCriteria struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string

	// it contains absolute values like "AllBackup" / "FirstOfDay" / "FirstOfWeek" / "FirstOfMonth" and should be part of AbsoluteMarker
	// enum
	AbsoluteCriteria []*AbsoluteMarker

	// This is day of the month from 1 to 28 other wise last of month
	DaysOfMonth []*Day

	// It should be Sunday/Monday/T…./Saturday
	DaysOfTheWeek []*DayOfWeek

	// It should be January/February/……/December
	MonthsOfYear []*Month

	// List of schedule times for backup
	ScheduleTimes []*time.Time

	// It should be First/Second/Third/Fourth/Last
	WeeksOfTheMonth []*WeekNumber
}

// GetBackupCriteria implements the BackupCriteriaClassification interface for type ScheduleBasedBackupCriteria.
func (s *ScheduleBasedBackupCriteria) GetBackupCriteria() *BackupCriteria {
	return &BackupCriteria{
		ObjectType: s.ObjectType,
	}
}

// ScheduleBasedTriggerContext - Schedule based trigger context
type ScheduleBasedTriggerContext struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string

	// REQUIRED; Schedule for this backup
	Schedule *BackupSchedule

	// REQUIRED; List of tags that can be applicable for given schedule.
	TaggingCriteria []*TaggingCriteria
}

// GetTriggerContext implements the TriggerContextClassification interface for type ScheduleBasedTriggerContext.
func (s *ScheduleBasedTriggerContext) GetTriggerContext() *TriggerContext {
	return &TriggerContext{
		ObjectType: s.ObjectType,
	}
}

// SecretStoreBasedAuthCredentials - Secret store based authentication credentials.
type SecretStoreBasedAuthCredentials struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string

	// Secret store resource
	SecretStoreResource *SecretStoreResource
}

// GetAuthCredentials implements the AuthCredentialsClassification interface for type SecretStoreBasedAuthCredentials.
func (s *SecretStoreBasedAuthCredentials) GetAuthCredentials() *AuthCredentials {
	return &AuthCredentials{
		ObjectType: s.ObjectType,
	}
}

// SecretStoreResource - Class representing a secret store resource.
type SecretStoreResource struct {
	// REQUIRED; Gets or sets the type of secret store
	SecretStoreType *SecretStoreType

	// Uri to get to the resource
	URI *string

	// Gets or sets value stored in secret store resource
	Value *string
}

// SecuritySettings - Class containing security settings of vault
type SecuritySettings struct {
	// Immutability Settings at vault level
	ImmutabilitySettings *ImmutabilitySettings

	// Soft delete related settings
	SoftDeleteSettings *SoftDeleteSettings
}

// SoftDeleteSettings - Soft delete related settings
type SoftDeleteSettings struct {
	// Soft delete retention duration
	RetentionDurationInDays *float64

	// State of soft delete
	State *SoftDeleteState
}

// SourceLifeCycle - Source LifeCycle
type SourceLifeCycle struct {
	// REQUIRED; Delete Option
	DeleteAfter DeleteOptionClassification

	// REQUIRED; DataStoreInfo base
	SourceDataStore             *DataStoreInfoBase
	TargetDataStoreCopySettings []*TargetCopySetting
}

// StorageSetting - Storage setting
type StorageSetting struct {
	// Gets or sets the type of the datastore.
	DatastoreType *StorageSettingStoreTypes

	// Gets or sets the type.
	Type *StorageSettingTypes
}

// SupportedFeature - Elements class for feature request
type SupportedFeature struct {
	// support feature type.
	ExposureControlledFeatures []*string

	// support feature type.
	FeatureName *string

	// feature support status
	SupportStatus *FeatureSupportStatus
}

// SyncBackupInstanceRequest - Sync BackupInstance Request
type SyncBackupInstanceRequest struct {
	// Field indicating sync type e.g. to sync only in case of failure or in all cases
	SyncType *SyncType
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TaggingCriteria - Tagging criteria
type TaggingCriteria struct {
	// REQUIRED; Specifies if tag is default.
	IsDefault *bool

	// REQUIRED; Retention tag information
	TagInfo *RetentionTag

	// REQUIRED; Retention Tag priority.
	TaggingPriority *int64

	// Criteria which decides whether the tag can be applied to a triggered backup.
	Criteria []BackupCriteriaClassification
}

// TargetCopySetting - Target copy settings
type TargetCopySetting struct {
	// REQUIRED; It can be CustomCopyOption or ImmediateCopyOption.
	CopyAfter CopyOptionClassification

	// REQUIRED; Info of target datastore
	DataStore *DataStoreInfoBase
}

// TargetDetails - Class encapsulating target details, used where the destination is not a datasource
type TargetDetails struct {
	// REQUIRED; Restore operation may create multiple files inside location pointed by Url Below will be the common prefix for
	// all of them
	FilePrefix *string

	// REQUIRED; Denotes the target location where the data will be restored, string value for the enum {Microsoft.Internal.AzureBackup.DataProtection.Common.Interface.RestoreTargetLocationType}
	RestoreTargetLocationType *RestoreTargetLocationType

	// REQUIRED; Url denoting the restore destination. It can point to container / file share etc
	URL *string

	// Full ARM Id denoting the restore destination. It is the ARM Id pointing to container / file share This is optional if the
	// target subscription can be identified with the URL field. If not then this is
	// needed if CrossSubscriptionRestore field of BackupVault is in any of the disabled states
	TargetResourceArmID *string
}

// TriggerBackupRequest - Trigger backup request
type TriggerBackupRequest struct {
	// REQUIRED; Name for the Rule of the Policy which needs to be applied for this backup
	BackupRuleOptions *AdHocBackupRuleOptions
}

// TriggerContext - Trigger context
type TriggerContext struct {
	// REQUIRED; Type of the specific object - used for deserializing
	ObjectType *string
}

// GetTriggerContext implements the TriggerContextClassification interface for type TriggerContext.
func (t *TriggerContext) GetTriggerContext() *TriggerContext { return t }

// UnlockDeleteRequest - Request body of unlock delete API.
type UnlockDeleteRequest struct {
	ResourceGuardOperationRequests []*string
	ResourceToBeDeleted            *string
}

// UnlockDeleteResponse - Response of Unlock Delete API.
type UnlockDeleteResponse struct {
	// This is the time when unlock delete privileges will get expired.
	UnlockDeleteExpiryTime *string
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string
}

// UserFacingError - Error object used by layers that have access to localized content, and propagate that to user
type UserFacingError struct {
	// Unique code for this error
	Code *string

	// Additional related Errors
	Details []*UserFacingError

	// Inner Error
	InnerError *InnerError

	// Whether the operation will be retryable or not
	IsRetryable *bool

	// Whether the operation is due to a user error or service error
	IsUserError *bool
	Message     *string

	// Any key value pairs that can be injected inside error object
	Properties map[string]*string

	// RecommendedAction � localized.
	RecommendedAction []*string

	// Target of the error.
	Target *string
}

// UserFacingWarningDetail - Warning object used by layers that have access to localized content, and propagate that to user
type UserFacingWarningDetail struct {
	// REQUIRED; Error details for the warning.
	Warning *UserFacingError

	// Name of resource for which warning is raised.
	ResourceName *string
}

// ValidateCrossRegionRestoreRequestObject - Cross Region Restore Request Object
type ValidateCrossRegionRestoreRequestObject struct {
	// REQUIRED; Cross region restore details.
	CrossRegionRestoreDetails *CrossRegionRestoreDetails

	// REQUIRED; Gets or sets the restore request object.
	RestoreRequestObject AzureBackupRestoreRequestClassification
}

// ValidateForBackupRequest - Validate for backup request
type ValidateForBackupRequest struct {
	// REQUIRED; Backup Instance
	BackupInstance *BackupInstance
}

// ValidateRestoreRequestObject - Validate restore request object
type ValidateRestoreRequestObject struct {
	// REQUIRED; Gets or sets the restore request object.
	RestoreRequestObject AzureBackupRestoreRequestClassification
}
