//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcontainerinstance_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/containerinstance/armcontainerinstance/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e60df62e9e0d88462e6abba81a76d94eab000f0d/specification/containerinstance/resource-manager/Microsoft.ContainerInstance/stable/2023-05-01/examples/ContainerGroupsList.json
func ExampleContainerGroupsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerinstance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewContainerGroupsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ContainerGroupListResult = armcontainerinstance.ContainerGroupListResult{
		// 	Value: []*armcontainerinstance.ContainerGroup{
		// 		{
		// 			Properties: &armcontainerinstance.ContainerGroupPropertiesProperties{
		// 				Containers: []*armcontainerinstance.Container{
		// 					{
		// 						Name: to.Ptr("demo1"),
		// 						Properties: &armcontainerinstance.ContainerProperties{
		// 							Command: []*string{
		// 							},
		// 							EnvironmentVariables: []*armcontainerinstance.EnvironmentVariable{
		// 							},
		// 							Image: to.Ptr("nginx"),
		// 							InstanceView: &armcontainerinstance.ContainerPropertiesInstanceView{
		// 								CurrentState: &armcontainerinstance.ContainerState{
		// 									DetailStatus: to.Ptr(""),
		// 									StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-10-17T17:27:21.000Z"); return t}()),
		// 									State: to.Ptr("Running"),
		// 								},
		// 								Events: []*armcontainerinstance.Event{
		// 								},
		// 								RestartCount: to.Ptr[int32](0),
		// 							},
		// 							Ports: []*armcontainerinstance.ContainerPort{
		// 								{
		// 									Port: to.Ptr[int32](80),
		// 							}},
		// 							Resources: &armcontainerinstance.ResourceRequirements{
		// 								Requests: &armcontainerinstance.ResourceRequests{
		// 									CPU: to.Ptr[float64](1),
		// 									MemoryInGB: to.Ptr[float64](1.5),
		// 								},
		// 							},
		// 							VolumeMounts: []*armcontainerinstance.VolumeMount{
		// 								{
		// 									Name: to.Ptr("volume1"),
		// 									MountPath: to.Ptr("/mnt/volume1"),
		// 									ReadOnly: to.Ptr(false),
		// 							}},
		// 						},
		// 				}},
		// 				ImageRegistryCredentials: []*armcontainerinstance.ImageRegistryCredential{
		// 					{
		// 						Server: to.Ptr("azcloudconsoleregistry.azurecr.io"),
		// 						Username: to.Ptr("azcloudconsoleregistry"),
		// 				}},
		// 				IPAddress: &armcontainerinstance.IPAddress{
		// 					Type: to.Ptr(armcontainerinstance.ContainerGroupIPAddressTypePublic),
		// 					IP: to.Ptr("10.0.0.1"),
		// 					Ports: []*armcontainerinstance.Port{
		// 						{
		// 							Port: to.Ptr[int32](80),
		// 							Protocol: to.Ptr(armcontainerinstance.ContainerGroupNetworkProtocolTCP),
		// 					}},
		// 				},
		// 				OSType: to.Ptr(armcontainerinstance.OperatingSystemTypesLinux),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				Volumes: []*armcontainerinstance.Volume{
		// 					{
		// 						Name: to.Ptr("volume1"),
		// 						AzureFile: &armcontainerinstance.AzureFileVolume{
		// 							ReadOnly: to.Ptr(false),
		// 							ShareName: to.Ptr("share1"),
		// 							StorageAccountName: to.Ptr("storage1"),
		// 						},
		// 				}},
		// 			},
		// 			Name: to.Ptr("demo1"),
		// 			Type: to.Ptr("Microsoft.ContainerInstance/containerGroups"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/demo/providers/Microsoft.ContainerInstance/containerGroups/demo1"),
		// 			Location: to.Ptr("WestUs"),
		// 			Zones: []*string{
		// 				to.Ptr("1")},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e60df62e9e0d88462e6abba81a76d94eab000f0d/specification/containerinstance/resource-manager/Microsoft.ContainerInstance/stable/2023-05-01/examples/ContainerGroupsListByResourceGroup.json
func ExampleContainerGroupsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerinstance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewContainerGroupsClient().NewListByResourceGroupPager("demo", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ContainerGroupListResult = armcontainerinstance.ContainerGroupListResult{
		// 	Value: []*armcontainerinstance.ContainerGroup{
		// 		{
		// 			Properties: &armcontainerinstance.ContainerGroupPropertiesProperties{
		// 				Containers: []*armcontainerinstance.Container{
		// 					{
		// 						Name: to.Ptr("demo1"),
		// 						Properties: &armcontainerinstance.ContainerProperties{
		// 							Command: []*string{
		// 							},
		// 							EnvironmentVariables: []*armcontainerinstance.EnvironmentVariable{
		// 							},
		// 							Image: to.Ptr("nginx"),
		// 							Ports: []*armcontainerinstance.ContainerPort{
		// 								{
		// 									Port: to.Ptr[int32](80),
		// 							}},
		// 							Resources: &armcontainerinstance.ResourceRequirements{
		// 								Requests: &armcontainerinstance.ResourceRequests{
		// 									CPU: to.Ptr[float64](1),
		// 									MemoryInGB: to.Ptr[float64](1.5),
		// 								},
		// 							},
		// 							VolumeMounts: []*armcontainerinstance.VolumeMount{
		// 								{
		// 									Name: to.Ptr("volume1"),
		// 									MountPath: to.Ptr("/mnt/volume1"),
		// 									ReadOnly: to.Ptr(false),
		// 							}},
		// 						},
		// 				}},
		// 				ImageRegistryCredentials: []*armcontainerinstance.ImageRegistryCredential{
		// 					{
		// 						Server: to.Ptr("azcloudconsoleregistry.azurecr.io"),
		// 						Username: to.Ptr("azcloudconsoleregistry"),
		// 				}},
		// 				IPAddress: &armcontainerinstance.IPAddress{
		// 					Type: to.Ptr(armcontainerinstance.ContainerGroupIPAddressTypePublic),
		// 					IP: to.Ptr("10.0.0.1"),
		// 					Ports: []*armcontainerinstance.Port{
		// 						{
		// 							Port: to.Ptr[int32](80),
		// 							Protocol: to.Ptr(armcontainerinstance.ContainerGroupNetworkProtocolTCP),
		// 					}},
		// 				},
		// 				OSType: to.Ptr(armcontainerinstance.OperatingSystemTypesLinux),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				Volumes: []*armcontainerinstance.Volume{
		// 					{
		// 						Name: to.Ptr("volume1"),
		// 						AzureFile: &armcontainerinstance.AzureFileVolume{
		// 							ReadOnly: to.Ptr(false),
		// 							ShareName: to.Ptr("share1"),
		// 							StorageAccountName: to.Ptr("storage1"),
		// 						},
		// 				}},
		// 			},
		// 			Name: to.Ptr("demo1"),
		// 			Type: to.Ptr("Microsoft.ContainerInstance/containerGroups"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/demo/providers/Microsoft.ContainerInstance/containerGroups/demo1"),
		// 			Location: to.Ptr("WestUs"),
		// 			Zones: []*string{
		// 				to.Ptr("1")},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e60df62e9e0d88462e6abba81a76d94eab000f0d/specification/containerinstance/resource-manager/Microsoft.ContainerInstance/stable/2023-05-01/examples/ContainerGroupsGetPriority.json
func ExampleContainerGroupsClient_Get_containerGroupsGetWithPriority() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerinstance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewContainerGroupsClient().Get(ctx, "demo", "demo1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContainerGroup = armcontainerinstance.ContainerGroup{
	// 	Properties: &armcontainerinstance.ContainerGroupPropertiesProperties{
	// 		Containers: []*armcontainerinstance.Container{
	// 			{
	// 				Name: to.Ptr("test-container-001"),
	// 				Properties: &armcontainerinstance.ContainerProperties{
	// 					Command: []*string{
	// 						to.Ptr("/bin/sh"),
	// 						to.Ptr("-c"),
	// 						to.Ptr("sleep 10")},
	// 						EnvironmentVariables: []*armcontainerinstance.EnvironmentVariable{
	// 						},
	// 						Image: to.Ptr("alpine:latest"),
	// 						InstanceView: &armcontainerinstance.ContainerPropertiesInstanceView{
	// 							CurrentState: &armcontainerinstance.ContainerState{
	// 								DetailStatus: to.Ptr("Completed"),
	// 								ExitCode: to.Ptr[int32](0),
	// 								FinishTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-11T19:33:55.565Z"); return t}()),
	// 								StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-11T19:33:44.217Z"); return t}()),
	// 								State: to.Ptr("Terminated"),
	// 							},
	// 							Events: []*armcontainerinstance.Event{
	// 								{
	// 									Name: to.Ptr("Pulling"),
	// 									Type: to.Ptr("Normal"),
	// 									Count: to.Ptr[int32](2),
	// 									FirstTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-11T19:28:22.000Z"); return t}()),
	// 									LastTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-11T19:32:09.000Z"); return t}()),
	// 									Message: to.Ptr("pulling image \"alpine@sha256:1304f174557314a7ed9eddb4eab12fed12cb0cd9809e4c28f29af86979a3c870\""),
	// 								},
	// 								{
	// 									Name: to.Ptr("Pulled"),
	// 									Type: to.Ptr("Normal"),
	// 									Count: to.Ptr[int32](2),
	// 									FirstTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-11T19:32:08.000Z"); return t}()),
	// 									LastTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-11T19:32:38.000Z"); return t}()),
	// 									Message: to.Ptr("Successfully pulled image \"alpine@sha256:1304f174557314a7ed9eddb4eab12fed12cb0cd9809e4c28f29af86979a3c870\""),
	// 								},
	// 								{
	// 									Name: to.Ptr("Started"),
	// 									Type: to.Ptr("Normal"),
	// 									Count: to.Ptr[int32](1),
	// 									FirstTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-11T19:33:44.000Z"); return t}()),
	// 									LastTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-11T19:33:44.000Z"); return t}()),
	// 									Message: to.Ptr("Started container"),
	// 							}},
	// 							RestartCount: to.Ptr[int32](0),
	// 						},
	// 						Ports: []*armcontainerinstance.ContainerPort{
	// 						},
	// 						Resources: &armcontainerinstance.ResourceRequirements{
	// 							Requests: &armcontainerinstance.ResourceRequests{
	// 								CPU: to.Ptr[float64](1),
	// 								MemoryInGB: to.Ptr[float64](1),
	// 							},
	// 						},
	// 					},
	// 			}},
	// 			InitContainers: []*armcontainerinstance.InitContainerDefinition{
	// 			},
	// 			InstanceView: &armcontainerinstance.ContainerGroupPropertiesInstanceView{
	// 				Events: []*armcontainerinstance.Event{
	// 				},
	// 				State: to.Ptr("Succeeded"),
	// 			},
	// 			OSType: to.Ptr(armcontainerinstance.OperatingSystemTypesLinux),
	// 			Priority: to.Ptr(armcontainerinstance.ContainerGroupPrioritySpot),
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			RestartPolicy: to.Ptr(armcontainerinstance.ContainerGroupRestartPolicyNever),
	// 			SKU: to.Ptr(armcontainerinstance.ContainerGroupSKUStandard),
	// 		},
	// 		Name: to.Ptr("demo1"),
	// 		Type: to.Ptr("Microsoft.ContainerInstance/containerGroups"),
	// 		ID: to.Ptr("/subscriptions/subId/resourceGroups/demo/providers/Microsoft.ContainerInstance/containerGroups/demo1"),
	// 		Location: to.Ptr("eastus"),
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e60df62e9e0d88462e6abba81a76d94eab000f0d/specification/containerinstance/resource-manager/Microsoft.ContainerInstance/stable/2023-05-01/examples/ContainerGroupsGet_Failed.json
func ExampleContainerGroupsClient_Get_containerGroupsGetFailed() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerinstance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewContainerGroupsClient().Get(ctx, "demo", "demo1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContainerGroup = armcontainerinstance.ContainerGroup{
	// 	Properties: &armcontainerinstance.ContainerGroupPropertiesProperties{
	// 		Containers: []*armcontainerinstance.Container{
	// 			{
	// 				Name: to.Ptr("demo1"),
	// 				Properties: &armcontainerinstance.ContainerProperties{
	// 					Command: []*string{
	// 					},
	// 					EnvironmentVariables: []*armcontainerinstance.EnvironmentVariable{
	// 					},
	// 					Image: to.Ptr("nginx"),
	// 					InstanceView: &armcontainerinstance.ContainerPropertiesInstanceView{
	// 						CurrentState: &armcontainerinstance.ContainerState{
	// 							DetailStatus: to.Ptr(""),
	// 							StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-08T00:09:10.000Z"); return t}()),
	// 							State: to.Ptr("Waiting"),
	// 						},
	// 						Events: []*armcontainerinstance.Event{
	// 							{
	// 								Name: to.Ptr("Pulling"),
	// 								Type: to.Ptr("Normal"),
	// 								Count: to.Ptr[int32](1),
	// 								FirstTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-08T00:09:01.000Z"); return t}()),
	// 								LastTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-08T00:09:01.000Z"); return t}()),
	// 								Message: to.Ptr("pulling image \"nginx\""),
	// 							},
	// 							{
	// 								Name: to.Ptr("Pulled"),
	// 								Type: to.Ptr("Normal"),
	// 								Count: to.Ptr[int32](1),
	// 								FirstTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-08T00:09:10.000Z"); return t}()),
	// 								LastTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-08T00:09:10.000Z"); return t}()),
	// 								Message: to.Ptr("Successfully pulled image \"nginx\""),
	// 						}},
	// 						RestartCount: to.Ptr[int32](0),
	// 					},
	// 					Ports: []*armcontainerinstance.ContainerPort{
	// 						{
	// 							Port: to.Ptr[int32](80),
	// 					}},
	// 					Resources: &armcontainerinstance.ResourceRequirements{
	// 						Requests: &armcontainerinstance.ResourceRequests{
	// 							CPU: to.Ptr[float64](1),
	// 							MemoryInGB: to.Ptr[float64](1.5),
	// 						},
	// 					},
	// 					VolumeMounts: []*armcontainerinstance.VolumeMount{
	// 						{
	// 							Name: to.Ptr("volume1"),
	// 							MountPath: to.Ptr("/mnt/volume1"),
	// 							ReadOnly: to.Ptr(false),
	// 					}},
	// 				},
	// 		}},
	// 		ImageRegistryCredentials: []*armcontainerinstance.ImageRegistryCredential{
	// 			{
	// 				Server: to.Ptr("azcloudconsoleregistry.azurecr.io"),
	// 				Username: to.Ptr("azcloudconsoleregistry"),
	// 		}},
	// 		InstanceView: &armcontainerinstance.ContainerGroupPropertiesInstanceView{
	// 			Events: []*armcontainerinstance.Event{
	// 				{
	// 					Name: to.Ptr("FailedMount"),
	// 					Type: to.Ptr("Normal"),
	// 					Count: to.Ptr[int32](1),
	// 					FirstTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-10-08T00:19:10.000Z"); return t}()),
	// 					LastTimestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-10-08T00:19:10.000Z"); return t}()),
	// 					Message: to.Ptr("Output: mount error(2): Permission denied"),
	// 			}},
	// 			State: to.Ptr("Pending"),
	// 		},
	// 		IPAddress: &armcontainerinstance.IPAddress{
	// 			Type: to.Ptr(armcontainerinstance.ContainerGroupIPAddressTypePublic),
	// 			IP: to.Ptr("10.0.0.1"),
	// 			Ports: []*armcontainerinstance.Port{
	// 				{
	// 					Port: to.Ptr[int32](80),
	// 					Protocol: to.Ptr(armcontainerinstance.ContainerGroupNetworkProtocolTCP),
	// 			}},
	// 		},
	// 		OSType: to.Ptr(armcontainerinstance.OperatingSystemTypesLinux),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		Volumes: []*armcontainerinstance.Volume{
	// 			{
	// 				Name: to.Ptr("volume1"),
	// 				AzureFile: &armcontainerinstance.AzureFileVolume{
	// 					ReadOnly: to.Ptr(false),
	// 					ShareName: to.Ptr("share1"),
	// 					StorageAccountName: to.Ptr("storage1"),
	// 				},
	// 		}},
	// 	},
	// 	Name: to.Ptr("demo1"),
	// 	Type: to.Ptr("Microsoft.ContainerInstance/containerGroups"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/demo/providers/Microsoft.ContainerInstance/containerGroups/demo1"),
	// 	Location: to.Ptr("WestUs"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e60df62e9e0d88462e6abba81a76d94eab000f0d/specification/containerinstance/resource-manager/Microsoft.ContainerInstance/stable/2023-05-01/examples/ContainerGroupsGet_Succeeded.json
func ExampleContainerGroupsClient_Get_containerGroupsGetSucceeded() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerinstance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewContainerGroupsClient().Get(ctx, "demo", "demo1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContainerGroup = armcontainerinstance.ContainerGroup{
	// 	Properties: &armcontainerinstance.ContainerGroupPropertiesProperties{
	// 		Containers: []*armcontainerinstance.Container{
	// 			{
	// 				Name: to.Ptr("demo1"),
	// 				Properties: &armcontainerinstance.ContainerProperties{
	// 					Command: []*string{
	// 					},
	// 					EnvironmentVariables: []*armcontainerinstance.EnvironmentVariable{
	// 					},
	// 					Image: to.Ptr("nginx"),
	// 					Ports: []*armcontainerinstance.ContainerPort{
	// 						{
	// 							Port: to.Ptr[int32](80),
	// 					}},
	// 					Resources: &armcontainerinstance.ResourceRequirements{
	// 						Requests: &armcontainerinstance.ResourceRequests{
	// 							CPU: to.Ptr[float64](1),
	// 							MemoryInGB: to.Ptr[float64](1.5),
	// 						},
	// 					},
	// 					VolumeMounts: []*armcontainerinstance.VolumeMount{
	// 						{
	// 							Name: to.Ptr("volume1"),
	// 							MountPath: to.Ptr("/mnt/volume1"),
	// 							ReadOnly: to.Ptr(false),
	// 					}},
	// 				},
	// 		}},
	// 		ImageRegistryCredentials: []*armcontainerinstance.ImageRegistryCredential{
	// 			{
	// 				Server: to.Ptr("azcloudconsoleregistry.azurecr.io"),
	// 				Username: to.Ptr("azcloudconsoleregistry"),
	// 		}},
	// 		IPAddress: &armcontainerinstance.IPAddress{
	// 			Type: to.Ptr(armcontainerinstance.ContainerGroupIPAddressTypePublic),
	// 			IP: to.Ptr("10.0.0.1"),
	// 			Ports: []*armcontainerinstance.Port{
	// 				{
	// 					Port: to.Ptr[int32](80),
	// 					Protocol: to.Ptr(armcontainerinstance.ContainerGroupNetworkProtocolTCP),
	// 			}},
	// 		},
	// 		OSType: to.Ptr(armcontainerinstance.OperatingSystemTypesLinux),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		Volumes: []*armcontainerinstance.Volume{
	// 			{
	// 				Name: to.Ptr("volume1"),
	// 				AzureFile: &armcontainerinstance.AzureFileVolume{
	// 					ReadOnly: to.Ptr(false),
	// 					ShareName: to.Ptr("share1"),
	// 					StorageAccountName: to.Ptr("storage1"),
	// 				},
	// 		}},
	// 	},
	// 	Name: to.Ptr("demo1"),
	// 	Type: to.Ptr("Microsoft.ContainerInstance/containerGroups"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/demo/providers/Microsoft.ContainerInstance/containerGroups/demo1"),
	// 	Location: to.Ptr("WestUs"),
	// 	Zones: []*string{
	// 		to.Ptr("1")},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e60df62e9e0d88462e6abba81a76d94eab000f0d/specification/containerinstance/resource-manager/Microsoft.ContainerInstance/stable/2023-05-01/examples/ContainerGroupCreateConfidential.json
func ExampleContainerGroupsClient_BeginCreateOrUpdate_confidentialContainerGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerinstance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewContainerGroupsClient().BeginCreateOrUpdate(ctx, "demo", "demo1", armcontainerinstance.ContainerGroup{
		Properties: &armcontainerinstance.ContainerGroupPropertiesProperties{
			ConfidentialComputeProperties: &armcontainerinstance.ConfidentialComputeProperties{
				CcePolicy: to.Ptr("eyJhbGxvd19hbGwiOiB0cnVlLCAiY29udGFpbmVycyI6IHsibGVuZ3RoIjogMCwgImVsZW1lbnRzIjogbnVsbH19"),
			},
			Containers: []*armcontainerinstance.Container{
				{
					Name: to.Ptr("accdemo"),
					Properties: &armcontainerinstance.ContainerProperties{
						Command:              []*string{},
						EnvironmentVariables: []*armcontainerinstance.EnvironmentVariable{},
						Image:                to.Ptr("confiimage"),
						Ports: []*armcontainerinstance.ContainerPort{
							{
								Port: to.Ptr[int32](8000),
							}},
						Resources: &armcontainerinstance.ResourceRequirements{
							Requests: &armcontainerinstance.ResourceRequests{
								CPU:        to.Ptr[float64](1),
								MemoryInGB: to.Ptr[float64](1.5),
							},
						},
						SecurityContext: &armcontainerinstance.SecurityContextDefinition{
							Capabilities: &armcontainerinstance.SecurityContextCapabilitiesDefinition{
								Add: []*string{
									to.Ptr("CAP_NET_ADMIN")},
							},
							Privileged: to.Ptr(false),
						},
					},
				}},
			ImageRegistryCredentials: []*armcontainerinstance.ImageRegistryCredential{},
			IPAddress: &armcontainerinstance.IPAddress{
				Type: to.Ptr(armcontainerinstance.ContainerGroupIPAddressTypePublic),
				Ports: []*armcontainerinstance.Port{
					{
						Port:     to.Ptr[int32](8000),
						Protocol: to.Ptr(armcontainerinstance.ContainerGroupNetworkProtocolTCP),
					}},
			},
			OSType: to.Ptr(armcontainerinstance.OperatingSystemTypesLinux),
			SKU:    to.Ptr(armcontainerinstance.ContainerGroupSKUConfidential),
		},
		Location: to.Ptr("westeurope"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContainerGroup = armcontainerinstance.ContainerGroup{
	// 	Properties: &armcontainerinstance.ContainerGroupPropertiesProperties{
	// 		ConfidentialComputeProperties: &armcontainerinstance.ConfidentialComputeProperties{
	// 			CcePolicy: to.Ptr("eyJhbGxvd19hbGwiOiB0cnVlLCAiY29udGFpbmVycyI6IHsibGVuZ3RoIjogMCwgImVsZW1lbnRzIjogbnVsbH19"),
	// 		},
	// 		Containers: []*armcontainerinstance.Container{
	// 			{
	// 				Name: to.Ptr("accdemo"),
	// 				Properties: &armcontainerinstance.ContainerProperties{
	// 					Command: []*string{
	// 					},
	// 					EnvironmentVariables: []*armcontainerinstance.EnvironmentVariable{
	// 					},
	// 					Image: to.Ptr("confiimage"),
	// 					Ports: []*armcontainerinstance.ContainerPort{
	// 						{
	// 							Port: to.Ptr[int32](8000),
	// 					}},
	// 					Resources: &armcontainerinstance.ResourceRequirements{
	// 						Requests: &armcontainerinstance.ResourceRequests{
	// 							CPU: to.Ptr[float64](1),
	// 							MemoryInGB: to.Ptr[float64](1.5),
	// 						},
	// 					},
	// 					SecurityContext: &armcontainerinstance.SecurityContextDefinition{
	// 						Capabilities: &armcontainerinstance.SecurityContextCapabilitiesDefinition{
	// 							Add: []*string{
	// 								to.Ptr("CAP_NET_ADMIN")},
	// 							},
	// 							Privileged: to.Ptr(false),
	// 						},
	// 					},
	// 			}},
	// 			ImageRegistryCredentials: []*armcontainerinstance.ImageRegistryCredential{
	// 			},
	// 			InitContainers: []*armcontainerinstance.InitContainerDefinition{
	// 			},
	// 			InstanceView: &armcontainerinstance.ContainerGroupPropertiesInstanceView{
	// 				Events: []*armcontainerinstance.Event{
	// 				},
	// 				State: to.Ptr("Running"),
	// 			},
	// 			IPAddress: &armcontainerinstance.IPAddress{
	// 				Type: to.Ptr(armcontainerinstance.ContainerGroupIPAddressTypePublic),
	// 				Ports: []*armcontainerinstance.Port{
	// 					{
	// 						Port: to.Ptr[int32](8000),
	// 						Protocol: to.Ptr(armcontainerinstance.ContainerGroupNetworkProtocolTCP),
	// 				}},
	// 			},
	// 			OSType: to.Ptr(armcontainerinstance.OperatingSystemTypesLinux),
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			SKU: to.Ptr(armcontainerinstance.ContainerGroupSKUConfidential),
	// 		},
	// 		Name: to.Ptr("demo1"),
	// 		Type: to.Ptr("Microsoft.ContainerInstance/containerGroups"),
	// 		ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000/resourceGroups/test-rg/providers/Microsoft.ContainerInstance/containerGroups/demo1"),
	// 		Location: to.Ptr("westeurope"),
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e60df62e9e0d88462e6abba81a76d94eab000f0d/specification/containerinstance/resource-manager/Microsoft.ContainerInstance/stable/2023-05-01/examples/ContainerGroupExtensions.json
func ExampleContainerGroupsClient_BeginCreateOrUpdate_containerGroupCreateWithExtensions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerinstance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewContainerGroupsClient().BeginCreateOrUpdate(ctx, "demo", "demo1", armcontainerinstance.ContainerGroup{
		Properties: &armcontainerinstance.ContainerGroupPropertiesProperties{
			Containers: []*armcontainerinstance.Container{
				{
					Name: to.Ptr("demo1"),
					Properties: &armcontainerinstance.ContainerProperties{
						Command:              []*string{},
						EnvironmentVariables: []*armcontainerinstance.EnvironmentVariable{},
						Image:                to.Ptr("nginx"),
						Ports: []*armcontainerinstance.ContainerPort{
							{
								Port: to.Ptr[int32](80),
							}},
						Resources: &armcontainerinstance.ResourceRequirements{
							Requests: &armcontainerinstance.ResourceRequests{
								CPU:        to.Ptr[float64](1),
								MemoryInGB: to.Ptr[float64](1.5),
							},
						},
					},
				}},
			ImageRegistryCredentials: []*armcontainerinstance.ImageRegistryCredential{},
			IPAddress: &armcontainerinstance.IPAddress{
				Type: to.Ptr(armcontainerinstance.ContainerGroupIPAddressTypePrivate),
				Ports: []*armcontainerinstance.Port{
					{
						Port:     to.Ptr[int32](80),
						Protocol: to.Ptr(armcontainerinstance.ContainerGroupNetworkProtocolTCP),
					}},
			},
			OSType: to.Ptr(armcontainerinstance.OperatingSystemTypesLinux),
			SubnetIDs: []*armcontainerinstance.ContainerGroupSubnetID{
				{
					ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-rg-vnet/subnets/test-subnet"),
				}},
			Extensions: []*armcontainerinstance.DeploymentExtensionSpec{
				{
					Name: to.Ptr("kube-proxy"),
					Properties: &armcontainerinstance.DeploymentExtensionSpecProperties{
						ExtensionType: to.Ptr("kube-proxy"),
						ProtectedSettings: map[string]any{
							"kubeConfig": "<kubeconfig encoded string>",
						},
						Settings: map[string]any{
							"clusterCidr": "10.240.0.0/16",
							"kubeVersion": "v1.9.10",
						},
						Version: to.Ptr("1.0"),
					},
				},
				{
					Name: to.Ptr("vk-realtime-metrics"),
					Properties: &armcontainerinstance.DeploymentExtensionSpecProperties{
						ExtensionType: to.Ptr("realtime-metrics"),
						Version:       to.Ptr("1.0"),
					},
				}},
		},
		Location: to.Ptr("eastus2"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContainerGroup = armcontainerinstance.ContainerGroup{
	// 	Properties: &armcontainerinstance.ContainerGroupPropertiesProperties{
	// 		Containers: []*armcontainerinstance.Container{
	// 			{
	// 				Name: to.Ptr("demo1"),
	// 				Properties: &armcontainerinstance.ContainerProperties{
	// 					Command: []*string{
	// 					},
	// 					EnvironmentVariables: []*armcontainerinstance.EnvironmentVariable{
	// 					},
	// 					Image: to.Ptr("nginx"),
	// 					Ports: []*armcontainerinstance.ContainerPort{
	// 						{
	// 							Port: to.Ptr[int32](80),
	// 					}},
	// 					Resources: &armcontainerinstance.ResourceRequirements{
	// 						Requests: &armcontainerinstance.ResourceRequests{
	// 							CPU: to.Ptr[float64](1),
	// 							MemoryInGB: to.Ptr[float64](1.5),
	// 						},
	// 					},
	// 				},
	// 		}},
	// 		ImageRegistryCredentials: []*armcontainerinstance.ImageRegistryCredential{
	// 		},
	// 		InitContainers: []*armcontainerinstance.InitContainerDefinition{
	// 		},
	// 		InstanceView: &armcontainerinstance.ContainerGroupPropertiesInstanceView{
	// 			Events: []*armcontainerinstance.Event{
	// 			},
	// 			State: to.Ptr("Pending"),
	// 		},
	// 		OSType: to.Ptr(armcontainerinstance.OperatingSystemTypesLinux),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		SKU: to.Ptr(armcontainerinstance.ContainerGroupSKUStandard),
	// 		SubnetIDs: []*armcontainerinstance.ContainerGroupSubnetID{
	// 			{
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-rg-vnet/subnets/test-subnet"),
	// 		}},
	// 		Extensions: []*armcontainerinstance.DeploymentExtensionSpec{
	// 			{
	// 				Name: to.Ptr("kube-proxy"),
	// 				Properties: &armcontainerinstance.DeploymentExtensionSpecProperties{
	// 					ExtensionType: to.Ptr("kube-proxy"),
	// 					Settings: map[string]any{
	// 						"clusterCidr": "10.240.0.0/16",
	// 						"kubeVersion": "v1.9.10",
	// 					},
	// 					Version: to.Ptr("1.0"),
	// 				},
	// 			},
	// 			{
	// 				Name: to.Ptr("vk-realtime-metrics"),
	// 				Properties: &armcontainerinstance.DeploymentExtensionSpecProperties{
	// 					ExtensionType: to.Ptr("realtime-metrics"),
	// 					Version: to.Ptr("1.0"),
	// 				},
	// 		}},
	// 	},
	// 	Name: to.Ptr("demo1"),
	// 	Type: to.Ptr("Microsoft.ContainerInstance/containerGroups"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000/resourceGroups/test-rg/providers/Microsoft.ContainerInstance/containerGroups/demo1"),
	// 	Location: to.Ptr("eastus2"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e60df62e9e0d88462e6abba81a76d94eab000f0d/specification/containerinstance/resource-manager/Microsoft.ContainerInstance/stable/2023-05-01/examples/ContainerGroupEncryptionProperties.json
func ExampleContainerGroupsClient_BeginCreateOrUpdate_containerGroupWithEncryptionProperties() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerinstance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewContainerGroupsClient().BeginCreateOrUpdate(ctx, "demo", "demo1", armcontainerinstance.ContainerGroup{
		Identity: &armcontainerinstance.ContainerGroupIdentity{
			Type: to.Ptr(armcontainerinstance.ResourceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armcontainerinstance.UserAssignedIdentities{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/test-rg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/container-group-identity": {},
			},
		},
		Properties: &armcontainerinstance.ContainerGroupPropertiesProperties{
			Containers: []*armcontainerinstance.Container{
				{
					Name: to.Ptr("demo1"),
					Properties: &armcontainerinstance.ContainerProperties{
						Command:              []*string{},
						EnvironmentVariables: []*armcontainerinstance.EnvironmentVariable{},
						Image:                to.Ptr("nginx"),
						Ports: []*armcontainerinstance.ContainerPort{
							{
								Port: to.Ptr[int32](80),
							}},
						Resources: &armcontainerinstance.ResourceRequirements{
							Requests: &armcontainerinstance.ResourceRequests{
								CPU:        to.Ptr[float64](1),
								MemoryInGB: to.Ptr[float64](1.5),
							},
						},
					},
				}},
			EncryptionProperties: &armcontainerinstance.EncryptionProperties{
				Identity:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/test-rg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/container-group-identity"),
				KeyName:      to.Ptr("test-key"),
				KeyVersion:   to.Ptr("<key version>"),
				VaultBaseURL: to.Ptr("https://testkeyvault.vault.azure.net"),
			},
			ImageRegistryCredentials: []*armcontainerinstance.ImageRegistryCredential{},
			IPAddress: &armcontainerinstance.IPAddress{
				Type: to.Ptr(armcontainerinstance.ContainerGroupIPAddressTypePublic),
				Ports: []*armcontainerinstance.Port{
					{
						Port:     to.Ptr[int32](80),
						Protocol: to.Ptr(armcontainerinstance.ContainerGroupNetworkProtocolTCP),
					}},
			},
			OSType: to.Ptr(armcontainerinstance.OperatingSystemTypesLinux),
		},
		Location: to.Ptr("eastus2"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContainerGroup = armcontainerinstance.ContainerGroup{
	// 	Identity: &armcontainerinstance.ContainerGroupIdentity{
	// 		Type: to.Ptr(armcontainerinstance.ResourceIdentityTypeUserAssigned),
	// 		TenantID: to.Ptr("<tenant id>"),
	// 		UserAssignedIdentities: map[string]*armcontainerinstance.UserAssignedIdentities{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/test-rg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/container-group-identity": &armcontainerinstance.UserAssignedIdentities{
	// 				ClientID: to.Ptr("<client id>"),
	// 				PrincipalID: to.Ptr("<principal id>"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armcontainerinstance.ContainerGroupPropertiesProperties{
	// 		Containers: []*armcontainerinstance.Container{
	// 			{
	// 				Name: to.Ptr("demo1"),
	// 				Properties: &armcontainerinstance.ContainerProperties{
	// 					Command: []*string{
	// 					},
	// 					EnvironmentVariables: []*armcontainerinstance.EnvironmentVariable{
	// 					},
	// 					Image: to.Ptr("nginx"),
	// 					Ports: []*armcontainerinstance.ContainerPort{
	// 						{
	// 							Port: to.Ptr[int32](80),
	// 					}},
	// 					Resources: &armcontainerinstance.ResourceRequirements{
	// 						Requests: &armcontainerinstance.ResourceRequests{
	// 							CPU: to.Ptr[float64](1),
	// 							MemoryInGB: to.Ptr[float64](1.5),
	// 						},
	// 					},
	// 				},
	// 		}},
	// 		EncryptionProperties: &armcontainerinstance.EncryptionProperties{
	// 			Identity: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/test-rg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/container-group-identity"),
	// 			KeyName: to.Ptr("test-key"),
	// 			KeyVersion: to.Ptr("<key version>"),
	// 			VaultBaseURL: to.Ptr("https://testkeyvault.vault.azure.net/"),
	// 		},
	// 		ImageRegistryCredentials: []*armcontainerinstance.ImageRegistryCredential{
	// 		},
	// 		InitContainers: []*armcontainerinstance.InitContainerDefinition{
	// 		},
	// 		InstanceView: &armcontainerinstance.ContainerGroupPropertiesInstanceView{
	// 			Events: []*armcontainerinstance.Event{
	// 			},
	// 			State: to.Ptr("Pending"),
	// 		},
	// 		IPAddress: &armcontainerinstance.IPAddress{
	// 			Type: to.Ptr(armcontainerinstance.ContainerGroupIPAddressTypePublic),
	// 			Ports: []*armcontainerinstance.Port{
	// 				{
	// 					Port: to.Ptr[int32](80),
	// 					Protocol: to.Ptr(armcontainerinstance.ContainerGroupNetworkProtocolTCP),
	// 			}},
	// 		},
	// 		OSType: to.Ptr(armcontainerinstance.OperatingSystemTypesLinux),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		SKU: to.Ptr(armcontainerinstance.ContainerGroupSKUStandard),
	// 	},
	// 	Name: to.Ptr("demo1"),
	// 	Type: to.Ptr("Microsoft.ContainerInstance/containerGroups"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/test-rg/providers/Microsoft.ContainerInstance/containerGroups/demo1"),
	// 	Location: to.Ptr("eastus2"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e60df62e9e0d88462e6abba81a76d94eab000f0d/specification/containerinstance/resource-manager/Microsoft.ContainerInstance/stable/2023-05-01/examples/ContainerGroupsCreateOrUpdate.json
func ExampleContainerGroupsClient_BeginCreateOrUpdate_containerGroupsCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerinstance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewContainerGroupsClient().BeginCreateOrUpdate(ctx, "demo", "demo1", armcontainerinstance.ContainerGroup{
		Identity: &armcontainerinstance.ContainerGroupIdentity{
			Type: to.Ptr(armcontainerinstance.ResourceIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armcontainerinstance.UserAssignedIdentities{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity-name": {},
			},
		},
		Properties: &armcontainerinstance.ContainerGroupPropertiesProperties{
			Containers: []*armcontainerinstance.Container{
				{
					Name: to.Ptr("demo1"),
					Properties: &armcontainerinstance.ContainerProperties{
						Command:              []*string{},
						EnvironmentVariables: []*armcontainerinstance.EnvironmentVariable{},
						Image:                to.Ptr("nginx"),
						Ports: []*armcontainerinstance.ContainerPort{
							{
								Port: to.Ptr[int32](80),
							}},
						Resources: &armcontainerinstance.ResourceRequirements{
							Requests: &armcontainerinstance.ResourceRequests{
								CPU: to.Ptr[float64](1),
								Gpu: &armcontainerinstance.GpuResource{
									Count: to.Ptr[int32](1),
									SKU:   to.Ptr(armcontainerinstance.GpuSKUK80),
								},
								MemoryInGB: to.Ptr[float64](1.5),
							},
						},
						VolumeMounts: []*armcontainerinstance.VolumeMount{
							{
								Name:      to.Ptr("volume1"),
								MountPath: to.Ptr("/mnt/volume1"),
								ReadOnly:  to.Ptr(false),
							},
							{
								Name:      to.Ptr("volume2"),
								MountPath: to.Ptr("/mnt/volume2"),
								ReadOnly:  to.Ptr(false),
							},
							{
								Name:      to.Ptr("volume3"),
								MountPath: to.Ptr("/mnt/volume3"),
								ReadOnly:  to.Ptr(true),
							}},
					},
				}},
			Diagnostics: &armcontainerinstance.ContainerGroupDiagnostics{
				LogAnalytics: &armcontainerinstance.LogAnalytics{
					LogType: to.Ptr(armcontainerinstance.LogAnalyticsLogTypeContainerInsights),
					Metadata: map[string]*string{
						"test-key": to.Ptr("test-metadata-value"),
					},
					WorkspaceID:         to.Ptr("workspaceid"),
					WorkspaceKey:        to.Ptr("workspaceKey"),
					WorkspaceResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg/providers/microsoft.operationalinsights/workspaces/workspace"),
				},
			},
			DNSConfig: &armcontainerinstance.DNSConfiguration{
				NameServers: []*string{
					to.Ptr("1.1.1.1")},
				Options:       to.Ptr("ndots:2"),
				SearchDomains: to.Ptr("cluster.local svc.cluster.local"),
			},
			ImageRegistryCredentials: []*armcontainerinstance.ImageRegistryCredential{},
			IPAddress: &armcontainerinstance.IPAddress{
				Type:                              to.Ptr(armcontainerinstance.ContainerGroupIPAddressTypePublic),
				AutoGeneratedDomainNameLabelScope: to.Ptr(armcontainerinstance.DNSNameLabelReusePolicyUnsecure),
				DNSNameLabel:                      to.Ptr("dnsnamelabel1"),
				Ports: []*armcontainerinstance.Port{
					{
						Port:     to.Ptr[int32](80),
						Protocol: to.Ptr(armcontainerinstance.ContainerGroupNetworkProtocolTCP),
					}},
			},
			OSType: to.Ptr(armcontainerinstance.OperatingSystemTypesLinux),
			SubnetIDs: []*armcontainerinstance.ContainerGroupSubnetID{
				{
					ID: to.Ptr("[resourceId('Microsoft.Network/virtualNetworks/subnets', parameters('vnetName'), parameters('subnetName'))]"),
				}},
			Volumes: []*armcontainerinstance.Volume{
				{
					Name: to.Ptr("volume1"),
					AzureFile: &armcontainerinstance.AzureFileVolume{
						ShareName:          to.Ptr("shareName"),
						StorageAccountKey:  to.Ptr("accountKey"),
						StorageAccountName: to.Ptr("accountName"),
					},
				},
				{
					Name:     to.Ptr("volume2"),
					EmptyDir: map[string]any{},
				},
				{
					Name: to.Ptr("volume3"),
					Secret: map[string]*string{
						"secretKey1": to.Ptr("SecretValue1InBase64"),
						"secretKey2": to.Ptr("SecretValue2InBase64"),
					},
				}},
		},
		Location: to.Ptr("west us"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContainerGroup = armcontainerinstance.ContainerGroup{
	// 	Properties: &armcontainerinstance.ContainerGroupPropertiesProperties{
	// 		Containers: []*armcontainerinstance.Container{
	// 			{
	// 				Name: to.Ptr("demo1"),
	// 				Properties: &armcontainerinstance.ContainerProperties{
	// 					Command: []*string{
	// 					},
	// 					EnvironmentVariables: []*armcontainerinstance.EnvironmentVariable{
	// 					},
	// 					Image: to.Ptr("nginx"),
	// 					Ports: []*armcontainerinstance.ContainerPort{
	// 						{
	// 							Port: to.Ptr[int32](80),
	// 					}},
	// 					Resources: &armcontainerinstance.ResourceRequirements{
	// 						Requests: &armcontainerinstance.ResourceRequests{
	// 							CPU: to.Ptr[float64](1),
	// 							Gpu: &armcontainerinstance.GpuResource{
	// 								Count: to.Ptr[int32](1),
	// 								SKU: to.Ptr(armcontainerinstance.GpuSKUK80),
	// 							},
	// 							MemoryInGB: to.Ptr[float64](1.5),
	// 						},
	// 					},
	// 					VolumeMounts: []*armcontainerinstance.VolumeMount{
	// 						{
	// 							Name: to.Ptr("volume1"),
	// 							MountPath: to.Ptr("/mnt/volume1"),
	// 							ReadOnly: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("volume2"),
	// 							MountPath: to.Ptr("/mnt/volume2"),
	// 							ReadOnly: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("volume3"),
	// 							MountPath: to.Ptr("/mnt/volume3"),
	// 							ReadOnly: to.Ptr(true),
	// 					}},
	// 				},
	// 		}},
	// 		Diagnostics: &armcontainerinstance.ContainerGroupDiagnostics{
	// 			LogAnalytics: &armcontainerinstance.LogAnalytics{
	// 				WorkspaceID: to.Ptr("workspaceid"),
	// 			},
	// 		},
	// 		DNSConfig: &armcontainerinstance.DNSConfiguration{
	// 			NameServers: []*string{
	// 				to.Ptr("1.1.1.1")},
	// 				Options: to.Ptr("ndots:2"),
	// 				SearchDomains: to.Ptr("cluster.local svc.cluster.local"),
	// 			},
	// 			ImageRegistryCredentials: []*armcontainerinstance.ImageRegistryCredential{
	// 			},
	// 			IPAddress: &armcontainerinstance.IPAddress{
	// 				Type: to.Ptr(armcontainerinstance.ContainerGroupIPAddressTypePublic),
	// 				AutoGeneratedDomainNameLabelScope: to.Ptr(armcontainerinstance.DNSNameLabelReusePolicyUnsecure),
	// 				DNSNameLabel: to.Ptr("dnsnamelabel1"),
	// 				Fqdn: to.Ptr("dnsnamelabel1.azure-container.io"),
	// 				IP: to.Ptr("10.0.0.1"),
	// 				Ports: []*armcontainerinstance.Port{
	// 					{
	// 						Port: to.Ptr[int32](80),
	// 						Protocol: to.Ptr(armcontainerinstance.ContainerGroupNetworkProtocolTCP),
	// 				}},
	// 			},
	// 			OSType: to.Ptr(armcontainerinstance.OperatingSystemTypesLinux),
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			Volumes: []*armcontainerinstance.Volume{
	// 				{
	// 					Name: to.Ptr("volume1"),
	// 					AzureFile: &armcontainerinstance.AzureFileVolume{
	// 						ShareName: to.Ptr("shareName"),
	// 						StorageAccountName: to.Ptr("accountName"),
	// 					},
	// 				},
	// 				{
	// 					Name: to.Ptr("volume2"),
	// 					EmptyDir: map[string]any{
	// 					},
	// 				},
	// 				{
	// 					Name: to.Ptr("volume3"),
	// 					Secret: map[string]*string{
	// 					},
	// 			}},
	// 		},
	// 		Name: to.Ptr("demo1"),
	// 		Type: to.Ptr("Microsoft.ContainerInstance/containerGroups"),
	// 		ID: to.Ptr("/subscriptions/subid/resourceGroups/demo/providers/Microsoft.ContainerInstance/containerGroups/demo1"),
	// 		Location: to.Ptr("WestUs"),
	// 		Zones: []*string{
	// 			to.Ptr("1")},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e60df62e9e0d88462e6abba81a76d94eab000f0d/specification/containerinstance/resource-manager/Microsoft.ContainerInstance/stable/2023-05-01/examples/ContainerGroupsCreatePriority.json
func ExampleContainerGroupsClient_BeginCreateOrUpdate_containerGroupsCreateWithPriority() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerinstance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewContainerGroupsClient().BeginCreateOrUpdate(ctx, "demo", "demo1", armcontainerinstance.ContainerGroup{
		Properties: &armcontainerinstance.ContainerGroupPropertiesProperties{
			Containers: []*armcontainerinstance.Container{
				{
					Name: to.Ptr("test-container-001"),
					Properties: &armcontainerinstance.ContainerProperties{
						Command: []*string{
							to.Ptr("/bin/sh"),
							to.Ptr("-c"),
							to.Ptr("sleep 10")},
						Image: to.Ptr("alpine:latest"),
						Resources: &armcontainerinstance.ResourceRequirements{
							Requests: &armcontainerinstance.ResourceRequests{
								CPU:        to.Ptr[float64](1),
								MemoryInGB: to.Ptr[float64](1),
							},
						},
					},
				}},
			OSType:        to.Ptr(armcontainerinstance.OperatingSystemTypesLinux),
			Priority:      to.Ptr(armcontainerinstance.ContainerGroupPrioritySpot),
			RestartPolicy: to.Ptr(armcontainerinstance.ContainerGroupRestartPolicyNever),
			SKU:           to.Ptr(armcontainerinstance.ContainerGroupSKUStandard),
		},
		Location: to.Ptr("eastus"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContainerGroup = armcontainerinstance.ContainerGroup{
	// 	Properties: &armcontainerinstance.ContainerGroupPropertiesProperties{
	// 		Containers: []*armcontainerinstance.Container{
	// 			{
	// 				Name: to.Ptr("test-container-001"),
	// 				Properties: &armcontainerinstance.ContainerProperties{
	// 					Command: []*string{
	// 						to.Ptr("/bin/sh"),
	// 						to.Ptr("-c"),
	// 						to.Ptr("sleep 10")},
	// 						EnvironmentVariables: []*armcontainerinstance.EnvironmentVariable{
	// 						},
	// 						Image: to.Ptr("alpine:latest"),
	// 						Ports: []*armcontainerinstance.ContainerPort{
	// 						},
	// 						Resources: &armcontainerinstance.ResourceRequirements{
	// 							Requests: &armcontainerinstance.ResourceRequests{
	// 								CPU: to.Ptr[float64](1),
	// 								MemoryInGB: to.Ptr[float64](1),
	// 							},
	// 						},
	// 					},
	// 			}},
	// 			InitContainers: []*armcontainerinstance.InitContainerDefinition{
	// 			},
	// 			InstanceView: &armcontainerinstance.ContainerGroupPropertiesInstanceView{
	// 				Events: []*armcontainerinstance.Event{
	// 				},
	// 				State: to.Ptr("Succeeded"),
	// 			},
	// 			OSType: to.Ptr(armcontainerinstance.OperatingSystemTypesLinux),
	// 			Priority: to.Ptr(armcontainerinstance.ContainerGroupPrioritySpot),
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			RestartPolicy: to.Ptr(armcontainerinstance.ContainerGroupRestartPolicyNever),
	// 			SKU: to.Ptr(armcontainerinstance.ContainerGroupSKUStandard),
	// 		},
	// 		Name: to.Ptr("demo1"),
	// 		Type: to.Ptr("Microsoft.ContainerInstance/containerGroups"),
	// 		ID: to.Ptr("/subscriptions/subId/resourceGroups/demo/providers/Microsoft.ContainerInstance/containerGroups/demo1"),
	// 		Location: to.Ptr("eastus"),
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e60df62e9e0d88462e6abba81a76d94eab000f0d/specification/containerinstance/resource-manager/Microsoft.ContainerInstance/stable/2023-05-01/examples/ContainerGroupsUpdate.json
func ExampleContainerGroupsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerinstance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewContainerGroupsClient().Update(ctx, "demoResource", "demo1", armcontainerinstance.Resource{
		Tags: map[string]*string{
			"tag1key": to.Ptr("tag1Value"),
			"tag2key": to.Ptr("tag2Value"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContainerGroup = armcontainerinstance.ContainerGroup{
	// 	Properties: &armcontainerinstance.ContainerGroupPropertiesProperties{
	// 		Containers: []*armcontainerinstance.Container{
	// 			{
	// 				Name: to.Ptr("demo1"),
	// 				Properties: &armcontainerinstance.ContainerProperties{
	// 					Command: []*string{
	// 					},
	// 					EnvironmentVariables: []*armcontainerinstance.EnvironmentVariable{
	// 					},
	// 					Image: to.Ptr("nginx"),
	// 					Ports: []*armcontainerinstance.ContainerPort{
	// 						{
	// 							Port: to.Ptr[int32](80),
	// 					}},
	// 					Resources: &armcontainerinstance.ResourceRequirements{
	// 						Requests: &armcontainerinstance.ResourceRequests{
	// 							CPU: to.Ptr[float64](1),
	// 							MemoryInGB: to.Ptr[float64](1.5),
	// 						},
	// 					},
	// 					VolumeMounts: []*armcontainerinstance.VolumeMount{
	// 						{
	// 							Name: to.Ptr("volume1"),
	// 							MountPath: to.Ptr("/mnt/volume1"),
	// 							ReadOnly: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("volume2"),
	// 							MountPath: to.Ptr("/mnt/volume2"),
	// 							ReadOnly: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("volume3"),
	// 							MountPath: to.Ptr("/mnt/volume3"),
	// 							ReadOnly: to.Ptr(true),
	// 					}},
	// 				},
	// 		}},
	// 		ImageRegistryCredentials: []*armcontainerinstance.ImageRegistryCredential{
	// 		},
	// 		IPAddress: &armcontainerinstance.IPAddress{
	// 			Type: to.Ptr(armcontainerinstance.ContainerGroupIPAddressTypePublic),
	// 			DNSNameLabel: to.Ptr("dnsnamelabel1"),
	// 			Fqdn: to.Ptr("dnsnamelabel1.azure-container.io"),
	// 			IP: to.Ptr("10.0.0.1"),
	// 			Ports: []*armcontainerinstance.Port{
	// 				{
	// 					Port: to.Ptr[int32](80),
	// 					Protocol: to.Ptr(armcontainerinstance.ContainerGroupNetworkProtocolTCP),
	// 			}},
	// 		},
	// 		OSType: to.Ptr(armcontainerinstance.OperatingSystemTypesLinux),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		Volumes: []*armcontainerinstance.Volume{
	// 			{
	// 				Name: to.Ptr("volume1"),
	// 				AzureFile: &armcontainerinstance.AzureFileVolume{
	// 					ShareName: to.Ptr("shareName"),
	// 					StorageAccountName: to.Ptr("accountName"),
	// 				},
	// 			},
	// 			{
	// 				Name: to.Ptr("volume2"),
	// 				EmptyDir: map[string]any{
	// 				},
	// 			},
	// 			{
	// 				Name: to.Ptr("volume3"),
	// 				Secret: map[string]*string{
	// 				},
	// 		}},
	// 	},
	// 	Name: to.Ptr("demo1"),
	// 	Type: to.Ptr("Microsoft.ContainerInstance/containerGroups"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/demoResource/providers/Microsoft.ContainerInstance/containerGroups/demo1"),
	// 	Location: to.Ptr("WestUs"),
	// 	Tags: map[string]*string{
	// 		"tag1key": to.Ptr("tag1Value"),
	// 		"tag2key": to.Ptr("tag2Value"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e60df62e9e0d88462e6abba81a76d94eab000f0d/specification/containerinstance/resource-manager/Microsoft.ContainerInstance/stable/2023-05-01/examples/ContainerGroupsDelete.json
func ExampleContainerGroupsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerinstance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewContainerGroupsClient().BeginDelete(ctx, "demo", "demo1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContainerGroup = armcontainerinstance.ContainerGroup{
	// 	Properties: &armcontainerinstance.ContainerGroupPropertiesProperties{
	// 		Containers: []*armcontainerinstance.Container{
	// 			{
	// 				Name: to.Ptr("demo1"),
	// 				Properties: &armcontainerinstance.ContainerProperties{
	// 					Command: []*string{
	// 					},
	// 					EnvironmentVariables: []*armcontainerinstance.EnvironmentVariable{
	// 					},
	// 					Image: to.Ptr("nginx"),
	// 					Ports: []*armcontainerinstance.ContainerPort{
	// 						{
	// 							Port: to.Ptr[int32](80),
	// 					}},
	// 					Resources: &armcontainerinstance.ResourceRequirements{
	// 						Requests: &armcontainerinstance.ResourceRequests{
	// 							CPU: to.Ptr[float64](1),
	// 							MemoryInGB: to.Ptr[float64](1.5),
	// 						},
	// 					},
	// 					VolumeMounts: []*armcontainerinstance.VolumeMount{
	// 						{
	// 							Name: to.Ptr("volume1"),
	// 							MountPath: to.Ptr("/mnt/volume1"),
	// 							ReadOnly: to.Ptr(false),
	// 					}},
	// 				},
	// 		}},
	// 		ImageRegistryCredentials: []*armcontainerinstance.ImageRegistryCredential{
	// 			{
	// 				Server: to.Ptr("azcloudconsoleregistry.azurecr.io"),
	// 				Username: to.Ptr("azcloudconsoleregistry"),
	// 		}},
	// 		IPAddress: &armcontainerinstance.IPAddress{
	// 			Type: to.Ptr(armcontainerinstance.ContainerGroupIPAddressTypePublic),
	// 			IP: to.Ptr("10.0.0.1"),
	// 			Ports: []*armcontainerinstance.Port{
	// 				{
	// 					Port: to.Ptr[int32](80),
	// 					Protocol: to.Ptr(armcontainerinstance.ContainerGroupNetworkProtocolTCP),
	// 			}},
	// 		},
	// 		OSType: to.Ptr(armcontainerinstance.OperatingSystemTypesLinux),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		Volumes: []*armcontainerinstance.Volume{
	// 			{
	// 				Name: to.Ptr("volume1"),
	// 				AzureFile: &armcontainerinstance.AzureFileVolume{
	// 					ReadOnly: to.Ptr(false),
	// 					ShareName: to.Ptr("share1"),
	// 					StorageAccountName: to.Ptr("storage1"),
	// 				},
	// 		}},
	// 	},
	// 	Name: to.Ptr("demo1"),
	// 	Type: to.Ptr("Microsoft.ContainerInstance/containerGroups"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/demo/providers/Microsoft.ContainerInstance/containerGroups/demo1"),
	// 	Location: to.Ptr("WestUs"),
	// 	Zones: []*string{
	// 		to.Ptr("1")},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e60df62e9e0d88462e6abba81a76d94eab000f0d/specification/containerinstance/resource-manager/Microsoft.ContainerInstance/stable/2023-05-01/examples/ContainerGroupsRestart.json
func ExampleContainerGroupsClient_BeginRestart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerinstance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewContainerGroupsClient().BeginRestart(ctx, "demo", "demo1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e60df62e9e0d88462e6abba81a76d94eab000f0d/specification/containerinstance/resource-manager/Microsoft.ContainerInstance/stable/2023-05-01/examples/ContainerGroupsStop.json
func ExampleContainerGroupsClient_Stop() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerinstance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewContainerGroupsClient().Stop(ctx, "demo", "demo1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e60df62e9e0d88462e6abba81a76d94eab000f0d/specification/containerinstance/resource-manager/Microsoft.ContainerInstance/stable/2023-05-01/examples/ContainerGroupsStart.json
func ExampleContainerGroupsClient_BeginStart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerinstance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewContainerGroupsClient().BeginStart(ctx, "demo", "demo1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
