//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappcontainers

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AllowedAudiencesValidation.
func (a AllowedAudiencesValidation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedAudiences", a.AllowedAudiences)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AllowedAudiencesValidation.
func (a *AllowedAudiencesValidation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAudiences":
			err = unpopulate(val, "AllowedAudiences", &a.AllowedAudiences)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AllowedPrincipals.
func (a AllowedPrincipals) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groups", a.Groups)
	populate(objectMap, "identities", a.Identities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AllowedPrincipals.
func (a *AllowedPrincipals) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groups":
			err = unpopulate(val, "Groups", &a.Groups)
			delete(rawMsg, key)
		case "identities":
			err = unpopulate(val, "Identities", &a.Identities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppInsightsConfiguration.
func (a AppInsightsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionString", a.ConnectionString)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppInsightsConfiguration.
func (a *AppInsightsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &a.ConnectionString)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppLogsConfiguration.
func (a AppLogsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destination", a.Destination)
	populate(objectMap, "logAnalyticsConfiguration", a.LogAnalyticsConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppLogsConfiguration.
func (a *AppLogsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destination":
			err = unpopulate(val, "Destination", &a.Destination)
			delete(rawMsg, key)
		case "logAnalyticsConfiguration":
			err = unpopulate(val, "LogAnalyticsConfiguration", &a.LogAnalyticsConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppRegistration.
func (a AppRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appId", a.AppID)
	populate(objectMap, "appSecretSettingName", a.AppSecretSettingName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppRegistration.
func (a *AppRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appId":
			err = unpopulate(val, "AppID", &a.AppID)
			delete(rawMsg, key)
		case "appSecretSettingName":
			err = unpopulate(val, "AppSecretSettingName", &a.AppSecretSettingName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppResiliency.
func (a AppResiliency) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppResiliency.
func (a *AppResiliency) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppResiliencyCollection.
func (a AppResiliencyCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppResiliencyCollection.
func (a *AppResiliencyCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppResiliencyProperties.
func (a AppResiliencyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "circuitBreakerPolicy", a.CircuitBreakerPolicy)
	populate(objectMap, "httpConnectionPool", a.HTTPConnectionPool)
	populate(objectMap, "httpRetryPolicy", a.HTTPRetryPolicy)
	populate(objectMap, "tcpConnectionPool", a.TCPConnectionPool)
	populate(objectMap, "tcpRetryPolicy", a.TCPRetryPolicy)
	populate(objectMap, "timeoutPolicy", a.TimeoutPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppResiliencyProperties.
func (a *AppResiliencyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "circuitBreakerPolicy":
			err = unpopulate(val, "CircuitBreakerPolicy", &a.CircuitBreakerPolicy)
			delete(rawMsg, key)
		case "httpConnectionPool":
			err = unpopulate(val, "HTTPConnectionPool", &a.HTTPConnectionPool)
			delete(rawMsg, key)
		case "httpRetryPolicy":
			err = unpopulate(val, "HTTPRetryPolicy", &a.HTTPRetryPolicy)
			delete(rawMsg, key)
		case "tcpConnectionPool":
			err = unpopulate(val, "TCPConnectionPool", &a.TCPConnectionPool)
			delete(rawMsg, key)
		case "tcpRetryPolicy":
			err = unpopulate(val, "TCPRetryPolicy", &a.TCPRetryPolicy)
			delete(rawMsg, key)
		case "timeoutPolicy":
			err = unpopulate(val, "TimeoutPolicy", &a.TimeoutPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Apple.
func (a Apple) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "login", a.Login)
	populate(objectMap, "registration", a.Registration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Apple.
func (a *Apple) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "login":
			err = unpopulate(val, "Login", &a.Login)
			delete(rawMsg, key)
		case "registration":
			err = unpopulate(val, "Registration", &a.Registration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppleRegistration.
func (a AppleRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", a.ClientID)
	populate(objectMap, "clientSecretSettingName", a.ClientSecretSettingName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppleRegistration.
func (a *AppleRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &a.ClientID)
			delete(rawMsg, key)
		case "clientSecretSettingName":
			err = unpopulate(val, "ClientSecretSettingName", &a.ClientSecretSettingName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthConfig.
func (a AuthConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthConfig.
func (a *AuthConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthConfigCollection.
func (a AuthConfigCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthConfigCollection.
func (a *AuthConfigCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthConfigProperties.
func (a AuthConfigProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptionSettings", a.EncryptionSettings)
	populate(objectMap, "globalValidation", a.GlobalValidation)
	populate(objectMap, "httpSettings", a.HTTPSettings)
	populate(objectMap, "identityProviders", a.IdentityProviders)
	populate(objectMap, "login", a.Login)
	populate(objectMap, "platform", a.Platform)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthConfigProperties.
func (a *AuthConfigProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptionSettings":
			err = unpopulate(val, "EncryptionSettings", &a.EncryptionSettings)
			delete(rawMsg, key)
		case "globalValidation":
			err = unpopulate(val, "GlobalValidation", &a.GlobalValidation)
			delete(rawMsg, key)
		case "httpSettings":
			err = unpopulate(val, "HTTPSettings", &a.HTTPSettings)
			delete(rawMsg, key)
		case "identityProviders":
			err = unpopulate(val, "IdentityProviders", &a.IdentityProviders)
			delete(rawMsg, key)
		case "login":
			err = unpopulate(val, "Login", &a.Login)
			delete(rawMsg, key)
		case "platform":
			err = unpopulate(val, "Platform", &a.Platform)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthPlatform.
func (a AuthPlatform) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "runtimeVersion", a.RuntimeVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthPlatform.
func (a *AuthPlatform) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "runtimeVersion":
			err = unpopulate(val, "RuntimeVersion", &a.RuntimeVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableOperations.
func (a AvailableOperations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableOperations.
func (a *AvailableOperations) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableWorkloadProfile.
func (a AvailableWorkloadProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableWorkloadProfile.
func (a *AvailableWorkloadProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableWorkloadProfileProperties.
func (a AvailableWorkloadProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicability", a.Applicability)
	populate(objectMap, "category", a.Category)
	populate(objectMap, "cores", a.Cores)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "gpus", a.Gpus)
	populate(objectMap, "memoryGiB", a.MemoryGiB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableWorkloadProfileProperties.
func (a *AvailableWorkloadProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicability":
			err = unpopulate(val, "Applicability", &a.Applicability)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &a.Category)
			delete(rawMsg, key)
		case "cores":
			err = unpopulate(val, "Cores", &a.Cores)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "gpus":
			err = unpopulate(val, "Gpus", &a.Gpus)
			delete(rawMsg, key)
		case "memoryGiB":
			err = unpopulate(val, "MemoryGiB", &a.MemoryGiB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableWorkloadProfilesCollection.
func (a AvailableWorkloadProfilesCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableWorkloadProfilesCollection.
func (a *AvailableWorkloadProfilesCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureActiveDirectory.
func (a AzureActiveDirectory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "isAutoProvisioned", a.IsAutoProvisioned)
	populate(objectMap, "login", a.Login)
	populate(objectMap, "registration", a.Registration)
	populate(objectMap, "validation", a.Validation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureActiveDirectory.
func (a *AzureActiveDirectory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "isAutoProvisioned":
			err = unpopulate(val, "IsAutoProvisioned", &a.IsAutoProvisioned)
			delete(rawMsg, key)
		case "login":
			err = unpopulate(val, "Login", &a.Login)
			delete(rawMsg, key)
		case "registration":
			err = unpopulate(val, "Registration", &a.Registration)
			delete(rawMsg, key)
		case "validation":
			err = unpopulate(val, "Validation", &a.Validation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureActiveDirectoryLogin.
func (a AzureActiveDirectoryLogin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disableWWWAuthenticate", a.DisableWWWAuthenticate)
	populate(objectMap, "loginParameters", a.LoginParameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureActiveDirectoryLogin.
func (a *AzureActiveDirectoryLogin) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableWWWAuthenticate":
			err = unpopulate(val, "DisableWWWAuthenticate", &a.DisableWWWAuthenticate)
			delete(rawMsg, key)
		case "loginParameters":
			err = unpopulate(val, "LoginParameters", &a.LoginParameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureActiveDirectoryRegistration.
func (a AzureActiveDirectoryRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", a.ClientID)
	populate(objectMap, "clientSecretCertificateIssuer", a.ClientSecretCertificateIssuer)
	populate(objectMap, "clientSecretCertificateSubjectAlternativeName", a.ClientSecretCertificateSubjectAlternativeName)
	populate(objectMap, "clientSecretCertificateThumbprint", a.ClientSecretCertificateThumbprint)
	populate(objectMap, "clientSecretSettingName", a.ClientSecretSettingName)
	populate(objectMap, "openIdIssuer", a.OpenIDIssuer)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureActiveDirectoryRegistration.
func (a *AzureActiveDirectoryRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &a.ClientID)
			delete(rawMsg, key)
		case "clientSecretCertificateIssuer":
			err = unpopulate(val, "ClientSecretCertificateIssuer", &a.ClientSecretCertificateIssuer)
			delete(rawMsg, key)
		case "clientSecretCertificateSubjectAlternativeName":
			err = unpopulate(val, "ClientSecretCertificateSubjectAlternativeName", &a.ClientSecretCertificateSubjectAlternativeName)
			delete(rawMsg, key)
		case "clientSecretCertificateThumbprint":
			err = unpopulate(val, "ClientSecretCertificateThumbprint", &a.ClientSecretCertificateThumbprint)
			delete(rawMsg, key)
		case "clientSecretSettingName":
			err = unpopulate(val, "ClientSecretSettingName", &a.ClientSecretSettingName)
			delete(rawMsg, key)
		case "openIdIssuer":
			err = unpopulate(val, "OpenIDIssuer", &a.OpenIDIssuer)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureActiveDirectoryValidation.
func (a AzureActiveDirectoryValidation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedAudiences", a.AllowedAudiences)
	populate(objectMap, "defaultAuthorizationPolicy", a.DefaultAuthorizationPolicy)
	populate(objectMap, "jwtClaimChecks", a.JwtClaimChecks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureActiveDirectoryValidation.
func (a *AzureActiveDirectoryValidation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAudiences":
			err = unpopulate(val, "AllowedAudiences", &a.AllowedAudiences)
			delete(rawMsg, key)
		case "defaultAuthorizationPolicy":
			err = unpopulate(val, "DefaultAuthorizationPolicy", &a.DefaultAuthorizationPolicy)
			delete(rawMsg, key)
		case "jwtClaimChecks":
			err = unpopulate(val, "JwtClaimChecks", &a.JwtClaimChecks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureCredentials.
func (a AzureCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", a.ClientID)
	populate(objectMap, "clientSecret", a.ClientSecret)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "subscriptionId", a.SubscriptionID)
	populate(objectMap, "tenantId", a.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureCredentials.
func (a *AzureCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &a.ClientID)
			delete(rawMsg, key)
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &a.ClientSecret)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &a.SubscriptionID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFileProperties.
func (a AzureFileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessMode", a.AccessMode)
	populate(objectMap, "accountKey", a.AccountKey)
	populate(objectMap, "accountName", a.AccountName)
	populate(objectMap, "shareName", a.ShareName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFileProperties.
func (a *AzureFileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessMode":
			err = unpopulate(val, "AccessMode", &a.AccessMode)
			delete(rawMsg, key)
		case "accountKey":
			err = unpopulate(val, "AccountKey", &a.AccountKey)
			delete(rawMsg, key)
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "shareName":
			err = unpopulate(val, "ShareName", &a.ShareName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureStaticWebApps.
func (a AzureStaticWebApps) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "registration", a.Registration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStaticWebApps.
func (a *AzureStaticWebApps) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "registration":
			err = unpopulate(val, "Registration", &a.Registration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureStaticWebAppsRegistration.
func (a AzureStaticWebAppsRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", a.ClientID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStaticWebAppsRegistration.
func (a *AzureStaticWebAppsRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &a.ClientID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BaseContainer.
func (b BaseContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "args", b.Args)
	populate(objectMap, "command", b.Command)
	populate(objectMap, "env", b.Env)
	populate(objectMap, "image", b.Image)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "resources", b.Resources)
	populate(objectMap, "volumeMounts", b.VolumeMounts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BaseContainer.
func (b *BaseContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "args":
			err = unpopulate(val, "Args", &b.Args)
			delete(rawMsg, key)
		case "command":
			err = unpopulate(val, "Command", &b.Command)
			delete(rawMsg, key)
		case "env":
			err = unpopulate(val, "Env", &b.Env)
			delete(rawMsg, key)
		case "image":
			err = unpopulate(val, "Image", &b.Image)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &b.Resources)
			delete(rawMsg, key)
		case "volumeMounts":
			err = unpopulate(val, "VolumeMounts", &b.VolumeMounts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingMeter.
func (b BillingMeter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingMeter.
func (b *BillingMeter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &b.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingMeterCollection.
func (b BillingMeterCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingMeterCollection.
func (b *BillingMeterCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingMeterProperties.
func (b BillingMeterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", b.Category)
	populate(objectMap, "displayName", b.DisplayName)
	populate(objectMap, "meterType", b.MeterType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingMeterProperties.
func (b *BillingMeterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &b.Category)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &b.DisplayName)
			delete(rawMsg, key)
		case "meterType":
			err = unpopulate(val, "MeterType", &b.MeterType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobStorageTokenStore.
func (b BlobStorageTokenStore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sasUrlSettingName", b.SasURLSettingName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobStorageTokenStore.
func (b *BlobStorageTokenStore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sasUrlSettingName":
			err = unpopulate(val, "SasURLSettingName", &b.SasURLSettingName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BuildCollection.
func (b BuildCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BuildCollection.
func (b *BuildCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BuildConfiguration.
func (b BuildConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "baseOs", b.BaseOs)
	populate(objectMap, "environmentVariables", b.EnvironmentVariables)
	populate(objectMap, "platform", b.Platform)
	populate(objectMap, "platformVersion", b.PlatformVersion)
	populate(objectMap, "preBuildSteps", b.PreBuildSteps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BuildConfiguration.
func (b *BuildConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "baseOs":
			err = unpopulate(val, "BaseOs", &b.BaseOs)
			delete(rawMsg, key)
		case "environmentVariables":
			err = unpopulate(val, "EnvironmentVariables", &b.EnvironmentVariables)
			delete(rawMsg, key)
		case "platform":
			err = unpopulate(val, "Platform", &b.Platform)
			delete(rawMsg, key)
		case "platformVersion":
			err = unpopulate(val, "PlatformVersion", &b.PlatformVersion)
			delete(rawMsg, key)
		case "preBuildSteps":
			err = unpopulate(val, "PreBuildSteps", &b.PreBuildSteps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BuildProperties.
func (b BuildProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "buildStatus", b.BuildStatus)
	populate(objectMap, "configuration", b.Configuration)
	populate(objectMap, "destinationContainerRegistry", b.DestinationContainerRegistry)
	populate(objectMap, "logStreamEndpoint", b.LogStreamEndpoint)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "tokenEndpoint", b.TokenEndpoint)
	populate(objectMap, "uploadEndpoint", b.UploadEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BuildProperties.
func (b *BuildProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "buildStatus":
			err = unpopulate(val, "BuildStatus", &b.BuildStatus)
			delete(rawMsg, key)
		case "configuration":
			err = unpopulate(val, "Configuration", &b.Configuration)
			delete(rawMsg, key)
		case "destinationContainerRegistry":
			err = unpopulate(val, "DestinationContainerRegistry", &b.DestinationContainerRegistry)
			delete(rawMsg, key)
		case "logStreamEndpoint":
			err = unpopulate(val, "LogStreamEndpoint", &b.LogStreamEndpoint)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		case "tokenEndpoint":
			err = unpopulate(val, "TokenEndpoint", &b.TokenEndpoint)
			delete(rawMsg, key)
		case "uploadEndpoint":
			err = unpopulate(val, "UploadEndpoint", &b.UploadEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BuildResource.
func (b BuildResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BuildResource.
func (b *BuildResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &b.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BuildToken.
func (b BuildToken) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "expires", b.Expires)
	populate(objectMap, "token", b.Token)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BuildToken.
func (b *BuildToken) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expires":
			err = unpopulateDateTimeRFC3339(val, "Expires", &b.Expires)
			delete(rawMsg, key)
		case "token":
			err = unpopulate(val, "Token", &b.Token)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BuilderCollection.
func (b BuilderCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BuilderCollection.
func (b *BuilderCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BuilderProperties.
func (b BuilderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerRegistries", b.ContainerRegistries)
	populate(objectMap, "environmentId", b.EnvironmentID)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BuilderProperties.
func (b *BuilderProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerRegistries":
			err = unpopulate(val, "ContainerRegistries", &b.ContainerRegistries)
			delete(rawMsg, key)
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &b.EnvironmentID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BuilderResource.
func (b BuilderResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "identity", b.Identity)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BuilderResource.
func (b *BuilderResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &b.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &b.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BuilderResourceUpdate.
func (b BuilderResourceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", b.Identity)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "tags", b.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BuilderResourceUpdate.
func (b *BuilderResourceUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &b.Identity)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BuilderResourceUpdateProperties.
func (b BuilderResourceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "environmentId", b.EnvironmentID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BuilderResourceUpdateProperties.
func (b *BuilderResourceUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &b.EnvironmentID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Certificate.
func (c Certificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Certificate.
func (c *Certificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateCollection.
func (c CertificateCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateCollection.
func (c *CertificateCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateKeyVaultProperties.
func (c CertificateKeyVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", c.Identity)
	populate(objectMap, "keyVaultUrl", c.KeyVaultURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateKeyVaultProperties.
func (c *CertificateKeyVaultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &c.Identity)
			delete(rawMsg, key)
		case "keyVaultUrl":
			err = unpopulate(val, "KeyVaultURL", &c.KeyVaultURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificatePatch.
func (c CertificatePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificatePatch.
func (c *CertificatePatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateProperties.
func (c CertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateKeyVaultProperties", c.CertificateKeyVaultProperties)
	populate(objectMap, "certificateType", c.CertificateType)
	populateDateTimeRFC3339(objectMap, "expirationDate", c.ExpirationDate)
	populateDateTimeRFC3339(objectMap, "issueDate", c.IssueDate)
	populate(objectMap, "issuer", c.Issuer)
	populate(objectMap, "password", c.Password)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "publicKeyHash", c.PublicKeyHash)
	populate(objectMap, "subjectAlternativeNames", c.SubjectAlternativeNames)
	populate(objectMap, "subjectName", c.SubjectName)
	populate(objectMap, "thumbprint", c.Thumbprint)
	populate(objectMap, "valid", c.Valid)
	populateByteArray(objectMap, "value", c.Value, func() any {
		return runtime.EncodeByteArray(c.Value, runtime.Base64StdFormat)
	})
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateProperties.
func (c *CertificateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateKeyVaultProperties":
			err = unpopulate(val, "CertificateKeyVaultProperties", &c.CertificateKeyVaultProperties)
			delete(rawMsg, key)
		case "certificateType":
			err = unpopulate(val, "CertificateType", &c.CertificateType)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateDateTimeRFC3339(val, "ExpirationDate", &c.ExpirationDate)
			delete(rawMsg, key)
		case "issueDate":
			err = unpopulateDateTimeRFC3339(val, "IssueDate", &c.IssueDate)
			delete(rawMsg, key)
		case "issuer":
			err = unpopulate(val, "Issuer", &c.Issuer)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &c.Password)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "publicKeyHash":
			err = unpopulate(val, "PublicKeyHash", &c.PublicKeyHash)
			delete(rawMsg, key)
		case "subjectAlternativeNames":
			err = unpopulate(val, "SubjectAlternativeNames", &c.SubjectAlternativeNames)
			delete(rawMsg, key)
		case "subjectName":
			err = unpopulate(val, "SubjectName", &c.SubjectName)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &c.Thumbprint)
			delete(rawMsg, key)
		case "valid":
			err = unpopulate(val, "Valid", &c.Valid)
			delete(rawMsg, key)
		case "value":
			if val != nil && string(val) != "null" {
				err = runtime.DecodeByteArray(string(val), &c.Value, runtime.Base64StdFormat)
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityRequest.
func (c CheckNameAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityRequest.
func (c *CheckNameAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityResponse.
func (c CheckNameAvailabilityResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "nameAvailable", c.NameAvailable)
	populate(objectMap, "reason", c.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityResponse.
func (c *CheckNameAvailabilityResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &c.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CircuitBreakerPolicy.
func (c CircuitBreakerPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consecutiveErrors", c.ConsecutiveErrors)
	populate(objectMap, "intervalInSeconds", c.IntervalInSeconds)
	populate(objectMap, "maxEjectionPercent", c.MaxEjectionPercent)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CircuitBreakerPolicy.
func (c *CircuitBreakerPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consecutiveErrors":
			err = unpopulate(val, "ConsecutiveErrors", &c.ConsecutiveErrors)
			delete(rawMsg, key)
		case "intervalInSeconds":
			err = unpopulate(val, "IntervalInSeconds", &c.IntervalInSeconds)
			delete(rawMsg, key)
		case "maxEjectionPercent":
			err = unpopulate(val, "MaxEjectionPercent", &c.MaxEjectionPercent)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClientRegistration.
func (c ClientRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", c.ClientID)
	populate(objectMap, "clientSecretSettingName", c.ClientSecretSettingName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientRegistration.
func (c *ClientRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &c.ClientID)
			delete(rawMsg, key)
		case "clientSecretSettingName":
			err = unpopulate(val, "ClientSecretSettingName", &c.ClientSecretSettingName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Configuration.
func (c Configuration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeRevisionsMode", c.ActiveRevisionsMode)
	populate(objectMap, "dapr", c.Dapr)
	populate(objectMap, "ingress", c.Ingress)
	populate(objectMap, "maxInactiveRevisions", c.MaxInactiveRevisions)
	populate(objectMap, "registries", c.Registries)
	populate(objectMap, "secrets", c.Secrets)
	populate(objectMap, "service", c.Service)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Configuration.
func (c *Configuration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeRevisionsMode":
			err = unpopulate(val, "ActiveRevisionsMode", &c.ActiveRevisionsMode)
			delete(rawMsg, key)
		case "dapr":
			err = unpopulate(val, "Dapr", &c.Dapr)
			delete(rawMsg, key)
		case "ingress":
			err = unpopulate(val, "Ingress", &c.Ingress)
			delete(rawMsg, key)
		case "maxInactiveRevisions":
			err = unpopulate(val, "MaxInactiveRevisions", &c.MaxInactiveRevisions)
			delete(rawMsg, key)
		case "registries":
			err = unpopulate(val, "Registries", &c.Registries)
			delete(rawMsg, key)
		case "secrets":
			err = unpopulate(val, "Secrets", &c.Secrets)
			delete(rawMsg, key)
		case "service":
			err = unpopulate(val, "Service", &c.Service)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectedEnvironment.
func (c ConnectedEnvironment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", c.ExtendedLocation)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectedEnvironment.
func (c *ConnectedEnvironment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &c.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectedEnvironmentCollection.
func (c ConnectedEnvironmentCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectedEnvironmentCollection.
func (c *ConnectedEnvironmentCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectedEnvironmentProperties.
func (c ConnectedEnvironmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customDomainConfiguration", c.CustomDomainConfiguration)
	populate(objectMap, "daprAIConnectionString", c.DaprAIConnectionString)
	populate(objectMap, "defaultDomain", c.DefaultDomain)
	populate(objectMap, "deploymentErrors", c.DeploymentErrors)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "staticIp", c.StaticIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectedEnvironmentProperties.
func (c *ConnectedEnvironmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customDomainConfiguration":
			err = unpopulate(val, "CustomDomainConfiguration", &c.CustomDomainConfiguration)
			delete(rawMsg, key)
		case "daprAIConnectionString":
			err = unpopulate(val, "DaprAIConnectionString", &c.DaprAIConnectionString)
			delete(rawMsg, key)
		case "defaultDomain":
			err = unpopulate(val, "DefaultDomain", &c.DefaultDomain)
			delete(rawMsg, key)
		case "deploymentErrors":
			err = unpopulate(val, "DeploymentErrors", &c.DeploymentErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "staticIp":
			err = unpopulate(val, "StaticIP", &c.StaticIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectedEnvironmentStorage.
func (c ConnectedEnvironmentStorage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectedEnvironmentStorage.
func (c *ConnectedEnvironmentStorage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectedEnvironmentStorageProperties.
func (c ConnectedEnvironmentStorageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureFile", c.AzureFile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectedEnvironmentStorageProperties.
func (c *ConnectedEnvironmentStorageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureFile":
			err = unpopulate(val, "AzureFile", &c.AzureFile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectedEnvironmentStoragesCollection.
func (c ConnectedEnvironmentStoragesCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectedEnvironmentStoragesCollection.
func (c *ConnectedEnvironmentStoragesCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Container.
func (c Container) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "args", c.Args)
	populate(objectMap, "command", c.Command)
	populate(objectMap, "env", c.Env)
	populate(objectMap, "image", c.Image)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "probes", c.Probes)
	populate(objectMap, "resources", c.Resources)
	populate(objectMap, "volumeMounts", c.VolumeMounts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Container.
func (c *Container) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "args":
			err = unpopulate(val, "Args", &c.Args)
			delete(rawMsg, key)
		case "command":
			err = unpopulate(val, "Command", &c.Command)
			delete(rawMsg, key)
		case "env":
			err = unpopulate(val, "Env", &c.Env)
			delete(rawMsg, key)
		case "image":
			err = unpopulate(val, "Image", &c.Image)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "probes":
			err = unpopulate(val, "Probes", &c.Probes)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &c.Resources)
			delete(rawMsg, key)
		case "volumeMounts":
			err = unpopulate(val, "VolumeMounts", &c.VolumeMounts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerApp.
func (c ContainerApp) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", c.ExtendedLocation)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "identity", c.Identity)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "managedBy", c.ManagedBy)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerApp.
func (c *ContainerApp) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &c.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &c.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "managedBy":
			err = unpopulate(val, "ManagedBy", &c.ManagedBy)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerAppAuthToken.
func (c ContainerAppAuthToken) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerAppAuthToken.
func (c *ContainerAppAuthToken) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerAppAuthTokenProperties.
func (c ContainerAppAuthTokenProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "expires", c.Expires)
	populate(objectMap, "token", c.Token)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerAppAuthTokenProperties.
func (c *ContainerAppAuthTokenProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expires":
			err = unpopulateDateTimeRFC3339(val, "Expires", &c.Expires)
			delete(rawMsg, key)
		case "token":
			err = unpopulate(val, "Token", &c.Token)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerAppCollection.
func (c ContainerAppCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerAppCollection.
func (c *ContainerAppCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerAppJobExecutions.
func (c ContainerAppJobExecutions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerAppJobExecutions.
func (c *ContainerAppJobExecutions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerAppProbe.
func (c ContainerAppProbe) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failureThreshold", c.FailureThreshold)
	populate(objectMap, "httpGet", c.HTTPGet)
	populate(objectMap, "initialDelaySeconds", c.InitialDelaySeconds)
	populate(objectMap, "periodSeconds", c.PeriodSeconds)
	populate(objectMap, "successThreshold", c.SuccessThreshold)
	populate(objectMap, "tcpSocket", c.TCPSocket)
	populate(objectMap, "terminationGracePeriodSeconds", c.TerminationGracePeriodSeconds)
	populate(objectMap, "timeoutSeconds", c.TimeoutSeconds)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerAppProbe.
func (c *ContainerAppProbe) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failureThreshold":
			err = unpopulate(val, "FailureThreshold", &c.FailureThreshold)
			delete(rawMsg, key)
		case "httpGet":
			err = unpopulate(val, "HTTPGet", &c.HTTPGet)
			delete(rawMsg, key)
		case "initialDelaySeconds":
			err = unpopulate(val, "InitialDelaySeconds", &c.InitialDelaySeconds)
			delete(rawMsg, key)
		case "periodSeconds":
			err = unpopulate(val, "PeriodSeconds", &c.PeriodSeconds)
			delete(rawMsg, key)
		case "successThreshold":
			err = unpopulate(val, "SuccessThreshold", &c.SuccessThreshold)
			delete(rawMsg, key)
		case "tcpSocket":
			err = unpopulate(val, "TCPSocket", &c.TCPSocket)
			delete(rawMsg, key)
		case "terminationGracePeriodSeconds":
			err = unpopulate(val, "TerminationGracePeriodSeconds", &c.TerminationGracePeriodSeconds)
			delete(rawMsg, key)
		case "timeoutSeconds":
			err = unpopulate(val, "TimeoutSeconds", &c.TimeoutSeconds)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerAppProbeHTTPGet.
func (c ContainerAppProbeHTTPGet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "httpHeaders", c.HTTPHeaders)
	populate(objectMap, "host", c.Host)
	populate(objectMap, "path", c.Path)
	populate(objectMap, "port", c.Port)
	populate(objectMap, "scheme", c.Scheme)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerAppProbeHTTPGet.
func (c *ContainerAppProbeHTTPGet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "httpHeaders":
			err = unpopulate(val, "HTTPHeaders", &c.HTTPHeaders)
			delete(rawMsg, key)
		case "host":
			err = unpopulate(val, "Host", &c.Host)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &c.Path)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &c.Port)
			delete(rawMsg, key)
		case "scheme":
			err = unpopulate(val, "Scheme", &c.Scheme)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerAppProbeHTTPGetHTTPHeadersItem.
func (c ContainerAppProbeHTTPGetHTTPHeadersItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerAppProbeHTTPGetHTTPHeadersItem.
func (c *ContainerAppProbeHTTPGetHTTPHeadersItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerAppProbeTCPSocket.
func (c ContainerAppProbeTCPSocket) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "host", c.Host)
	populate(objectMap, "port", c.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerAppProbeTCPSocket.
func (c *ContainerAppProbeTCPSocket) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "host":
			err = unpopulate(val, "Host", &c.Host)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &c.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerAppProperties.
func (c ContainerAppProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configuration", c.Configuration)
	populate(objectMap, "customDomainVerificationId", c.CustomDomainVerificationID)
	populate(objectMap, "environmentId", c.EnvironmentID)
	populate(objectMap, "eventStreamEndpoint", c.EventStreamEndpoint)
	populate(objectMap, "latestReadyRevisionName", c.LatestReadyRevisionName)
	populate(objectMap, "latestRevisionFqdn", c.LatestRevisionFqdn)
	populate(objectMap, "latestRevisionName", c.LatestRevisionName)
	populate(objectMap, "managedEnvironmentId", c.ManagedEnvironmentID)
	populate(objectMap, "outboundIpAddresses", c.OutboundIPAddresses)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "template", c.Template)
	populate(objectMap, "workloadProfileName", c.WorkloadProfileName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerAppProperties.
func (c *ContainerAppProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &c.Configuration)
			delete(rawMsg, key)
		case "customDomainVerificationId":
			err = unpopulate(val, "CustomDomainVerificationID", &c.CustomDomainVerificationID)
			delete(rawMsg, key)
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &c.EnvironmentID)
			delete(rawMsg, key)
		case "eventStreamEndpoint":
			err = unpopulate(val, "EventStreamEndpoint", &c.EventStreamEndpoint)
			delete(rawMsg, key)
		case "latestReadyRevisionName":
			err = unpopulate(val, "LatestReadyRevisionName", &c.LatestReadyRevisionName)
			delete(rawMsg, key)
		case "latestRevisionFqdn":
			err = unpopulate(val, "LatestRevisionFqdn", &c.LatestRevisionFqdn)
			delete(rawMsg, key)
		case "latestRevisionName":
			err = unpopulate(val, "LatestRevisionName", &c.LatestRevisionName)
			delete(rawMsg, key)
		case "managedEnvironmentId":
			err = unpopulate(val, "ManagedEnvironmentID", &c.ManagedEnvironmentID)
			delete(rawMsg, key)
		case "outboundIpAddresses":
			err = unpopulate(val, "OutboundIPAddresses", &c.OutboundIPAddresses)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "template":
			err = unpopulate(val, "Template", &c.Template)
			delete(rawMsg, key)
		case "workloadProfileName":
			err = unpopulate(val, "WorkloadProfileName", &c.WorkloadProfileName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerAppSecret.
func (c ContainerAppSecret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", c.Identity)
	populate(objectMap, "keyVaultUrl", c.KeyVaultURL)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerAppSecret.
func (c *ContainerAppSecret) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &c.Identity)
			delete(rawMsg, key)
		case "keyVaultUrl":
			err = unpopulate(val, "KeyVaultURL", &c.KeyVaultURL)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerRegistry.
func (c ContainerRegistry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerRegistryServer", c.ContainerRegistryServer)
	populate(objectMap, "identityResourceId", c.IdentityResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerRegistry.
func (c *ContainerRegistry) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerRegistryServer":
			err = unpopulate(val, "ContainerRegistryServer", &c.ContainerRegistryServer)
			delete(rawMsg, key)
		case "identityResourceId":
			err = unpopulate(val, "IdentityResourceID", &c.IdentityResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerRegistryWithCustomImage.
func (c ContainerRegistryWithCustomImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "image", c.Image)
	populate(objectMap, "server", c.Server)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerRegistryWithCustomImage.
func (c *ContainerRegistryWithCustomImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "image":
			err = unpopulate(val, "Image", &c.Image)
			delete(rawMsg, key)
		case "server":
			err = unpopulate(val, "Server", &c.Server)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerResources.
func (c ContainerResources) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cpu", c.CPU)
	populate(objectMap, "ephemeralStorage", c.EphemeralStorage)
	populate(objectMap, "memory", c.Memory)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerResources.
func (c *ContainerResources) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cpu":
			err = unpopulate(val, "CPU", &c.CPU)
			delete(rawMsg, key)
		case "ephemeralStorage":
			err = unpopulate(val, "EphemeralStorage", &c.EphemeralStorage)
			delete(rawMsg, key)
		case "memory":
			err = unpopulate(val, "Memory", &c.Memory)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CookieExpiration.
func (c CookieExpiration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "convention", c.Convention)
	populate(objectMap, "timeToExpiration", c.TimeToExpiration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CookieExpiration.
func (c *CookieExpiration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "convention":
			err = unpopulate(val, "Convention", &c.Convention)
			delete(rawMsg, key)
		case "timeToExpiration":
			err = unpopulate(val, "TimeToExpiration", &c.TimeToExpiration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CorsPolicy.
func (c CorsPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowCredentials", c.AllowCredentials)
	populate(objectMap, "allowedHeaders", c.AllowedHeaders)
	populate(objectMap, "allowedMethods", c.AllowedMethods)
	populate(objectMap, "allowedOrigins", c.AllowedOrigins)
	populate(objectMap, "exposeHeaders", c.ExposeHeaders)
	populate(objectMap, "maxAge", c.MaxAge)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CorsPolicy.
func (c *CorsPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowCredentials":
			err = unpopulate(val, "AllowCredentials", &c.AllowCredentials)
			delete(rawMsg, key)
		case "allowedHeaders":
			err = unpopulate(val, "AllowedHeaders", &c.AllowedHeaders)
			delete(rawMsg, key)
		case "allowedMethods":
			err = unpopulate(val, "AllowedMethods", &c.AllowedMethods)
			delete(rawMsg, key)
		case "allowedOrigins":
			err = unpopulate(val, "AllowedOrigins", &c.AllowedOrigins)
			delete(rawMsg, key)
		case "exposeHeaders":
			err = unpopulate(val, "ExposeHeaders", &c.ExposeHeaders)
			delete(rawMsg, key)
		case "maxAge":
			err = unpopulate(val, "MaxAge", &c.MaxAge)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomDomain.
func (c CustomDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bindingType", c.BindingType)
	populate(objectMap, "certificateId", c.CertificateID)
	populate(objectMap, "name", c.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomDomain.
func (c *CustomDomain) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bindingType":
			err = unpopulate(val, "BindingType", &c.BindingType)
			delete(rawMsg, key)
		case "certificateId":
			err = unpopulate(val, "CertificateID", &c.CertificateID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomDomainConfiguration.
func (c CustomDomainConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateKeyVaultProperties", c.CertificateKeyVaultProperties)
	populate(objectMap, "certificatePassword", c.CertificatePassword)
	populateByteArray(objectMap, "certificateValue", c.CertificateValue, func() any {
		return runtime.EncodeByteArray(c.CertificateValue, runtime.Base64StdFormat)
	})
	populate(objectMap, "customDomainVerificationId", c.CustomDomainVerificationID)
	populate(objectMap, "dnsSuffix", c.DNSSuffix)
	populateDateTimeRFC3339(objectMap, "expirationDate", c.ExpirationDate)
	populate(objectMap, "subjectName", c.SubjectName)
	populate(objectMap, "thumbprint", c.Thumbprint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomDomainConfiguration.
func (c *CustomDomainConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateKeyVaultProperties":
			err = unpopulate(val, "CertificateKeyVaultProperties", &c.CertificateKeyVaultProperties)
			delete(rawMsg, key)
		case "certificatePassword":
			err = unpopulate(val, "CertificatePassword", &c.CertificatePassword)
			delete(rawMsg, key)
		case "certificateValue":
			if val != nil && string(val) != "null" {
				err = runtime.DecodeByteArray(string(val), &c.CertificateValue, runtime.Base64StdFormat)
			}
			delete(rawMsg, key)
		case "customDomainVerificationId":
			err = unpopulate(val, "CustomDomainVerificationID", &c.CustomDomainVerificationID)
			delete(rawMsg, key)
		case "dnsSuffix":
			err = unpopulate(val, "DNSSuffix", &c.DNSSuffix)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateDateTimeRFC3339(val, "ExpirationDate", &c.ExpirationDate)
			delete(rawMsg, key)
		case "subjectName":
			err = unpopulate(val, "SubjectName", &c.SubjectName)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &c.Thumbprint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomHostnameAnalysisResult.
func (c CustomHostnameAnalysisResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aRecords", c.ARecords)
	populate(objectMap, "alternateCNameRecords", c.AlternateCNameRecords)
	populate(objectMap, "alternateTxtRecords", c.AlternateTxtRecords)
	populate(objectMap, "cNameRecords", c.CNameRecords)
	populate(objectMap, "conflictWithEnvironmentCustomDomain", c.ConflictWithEnvironmentCustomDomain)
	populate(objectMap, "conflictingContainerAppResourceId", c.ConflictingContainerAppResourceID)
	populate(objectMap, "customDomainVerificationFailureInfo", c.CustomDomainVerificationFailureInfo)
	populate(objectMap, "customDomainVerificationTest", c.CustomDomainVerificationTest)
	populate(objectMap, "hasConflictOnManagedEnvironment", c.HasConflictOnManagedEnvironment)
	populate(objectMap, "hostName", c.HostName)
	populate(objectMap, "isHostnameAlreadyVerified", c.IsHostnameAlreadyVerified)
	populate(objectMap, "txtRecords", c.TxtRecords)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomHostnameAnalysisResult.
func (c *CustomHostnameAnalysisResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aRecords":
			err = unpopulate(val, "ARecords", &c.ARecords)
			delete(rawMsg, key)
		case "alternateCNameRecords":
			err = unpopulate(val, "AlternateCNameRecords", &c.AlternateCNameRecords)
			delete(rawMsg, key)
		case "alternateTxtRecords":
			err = unpopulate(val, "AlternateTxtRecords", &c.AlternateTxtRecords)
			delete(rawMsg, key)
		case "cNameRecords":
			err = unpopulate(val, "CNameRecords", &c.CNameRecords)
			delete(rawMsg, key)
		case "conflictWithEnvironmentCustomDomain":
			err = unpopulate(val, "ConflictWithEnvironmentCustomDomain", &c.ConflictWithEnvironmentCustomDomain)
			delete(rawMsg, key)
		case "conflictingContainerAppResourceId":
			err = unpopulate(val, "ConflictingContainerAppResourceID", &c.ConflictingContainerAppResourceID)
			delete(rawMsg, key)
		case "customDomainVerificationFailureInfo":
			err = unpopulate(val, "CustomDomainVerificationFailureInfo", &c.CustomDomainVerificationFailureInfo)
			delete(rawMsg, key)
		case "customDomainVerificationTest":
			err = unpopulate(val, "CustomDomainVerificationTest", &c.CustomDomainVerificationTest)
			delete(rawMsg, key)
		case "hasConflictOnManagedEnvironment":
			err = unpopulate(val, "HasConflictOnManagedEnvironment", &c.HasConflictOnManagedEnvironment)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &c.HostName)
			delete(rawMsg, key)
		case "isHostnameAlreadyVerified":
			err = unpopulate(val, "IsHostnameAlreadyVerified", &c.IsHostnameAlreadyVerified)
			delete(rawMsg, key)
		case "txtRecords":
			err = unpopulate(val, "TxtRecords", &c.TxtRecords)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo.
func (c CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", c.Code)
	populate(objectMap, "details", c.Details)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "target", c.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo.
func (c *CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &c.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &c.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &c.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem.
func (c CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", c.Code)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "target", c.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem.
func (c *CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &c.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &c.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomOpenIDConnectProvider.
func (c CustomOpenIDConnectProvider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", c.Enabled)
	populate(objectMap, "login", c.Login)
	populate(objectMap, "registration", c.Registration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomOpenIDConnectProvider.
func (c *CustomOpenIDConnectProvider) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &c.Enabled)
			delete(rawMsg, key)
		case "login":
			err = unpopulate(val, "Login", &c.Login)
			delete(rawMsg, key)
		case "registration":
			err = unpopulate(val, "Registration", &c.Registration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomScaleRule.
func (c CustomScaleRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auth", c.Auth)
	populate(objectMap, "metadata", c.Metadata)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomScaleRule.
func (c *CustomScaleRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auth":
			err = unpopulate(val, "Auth", &c.Auth)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &c.Metadata)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Dapr.
func (d Dapr) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appId", d.AppID)
	populate(objectMap, "appPort", d.AppPort)
	populate(objectMap, "appProtocol", d.AppProtocol)
	populate(objectMap, "enableApiLogging", d.EnableAPILogging)
	populate(objectMap, "enabled", d.Enabled)
	populate(objectMap, "httpMaxRequestSize", d.HTTPMaxRequestSize)
	populate(objectMap, "httpReadBufferSize", d.HTTPReadBufferSize)
	populate(objectMap, "logLevel", d.LogLevel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Dapr.
func (d *Dapr) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appId":
			err = unpopulate(val, "AppID", &d.AppID)
			delete(rawMsg, key)
		case "appPort":
			err = unpopulate(val, "AppPort", &d.AppPort)
			delete(rawMsg, key)
		case "appProtocol":
			err = unpopulate(val, "AppProtocol", &d.AppProtocol)
			delete(rawMsg, key)
		case "enableApiLogging":
			err = unpopulate(val, "EnableAPILogging", &d.EnableAPILogging)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		case "httpMaxRequestSize":
			err = unpopulate(val, "HTTPMaxRequestSize", &d.HTTPMaxRequestSize)
			delete(rawMsg, key)
		case "httpReadBufferSize":
			err = unpopulate(val, "HTTPReadBufferSize", &d.HTTPReadBufferSize)
			delete(rawMsg, key)
		case "logLevel":
			err = unpopulate(val, "LogLevel", &d.LogLevel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprComponent.
func (d DaprComponent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprComponent.
func (d *DaprComponent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprComponentProperties.
func (d DaprComponentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "componentType", d.ComponentType)
	populate(objectMap, "ignoreErrors", d.IgnoreErrors)
	populate(objectMap, "initTimeout", d.InitTimeout)
	populate(objectMap, "metadata", d.Metadata)
	populate(objectMap, "scopes", d.Scopes)
	populate(objectMap, "secretStoreComponent", d.SecretStoreComponent)
	populate(objectMap, "secrets", d.Secrets)
	populate(objectMap, "serviceComponentBind", d.ServiceComponentBind)
	populate(objectMap, "version", d.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprComponentProperties.
func (d *DaprComponentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentType":
			err = unpopulate(val, "ComponentType", &d.ComponentType)
			delete(rawMsg, key)
		case "ignoreErrors":
			err = unpopulate(val, "IgnoreErrors", &d.IgnoreErrors)
			delete(rawMsg, key)
		case "initTimeout":
			err = unpopulate(val, "InitTimeout", &d.InitTimeout)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &d.Metadata)
			delete(rawMsg, key)
		case "scopes":
			err = unpopulate(val, "Scopes", &d.Scopes)
			delete(rawMsg, key)
		case "secretStoreComponent":
			err = unpopulate(val, "SecretStoreComponent", &d.SecretStoreComponent)
			delete(rawMsg, key)
		case "secrets":
			err = unpopulate(val, "Secrets", &d.Secrets)
			delete(rawMsg, key)
		case "serviceComponentBind":
			err = unpopulate(val, "ServiceComponentBind", &d.ServiceComponentBind)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &d.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprComponentResiliencyPoliciesCollection.
func (d DaprComponentResiliencyPoliciesCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprComponentResiliencyPoliciesCollection.
func (d *DaprComponentResiliencyPoliciesCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprComponentResiliencyPolicy.
func (d DaprComponentResiliencyPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprComponentResiliencyPolicy.
func (d *DaprComponentResiliencyPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration.
func (d DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consecutiveErrors", d.ConsecutiveErrors)
	populate(objectMap, "intervalInSeconds", d.IntervalInSeconds)
	populate(objectMap, "timeoutInSeconds", d.TimeoutInSeconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration.
func (d *DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consecutiveErrors":
			err = unpopulate(val, "ConsecutiveErrors", &d.ConsecutiveErrors)
			delete(rawMsg, key)
		case "intervalInSeconds":
			err = unpopulate(val, "IntervalInSeconds", &d.IntervalInSeconds)
			delete(rawMsg, key)
		case "timeoutInSeconds":
			err = unpopulate(val, "TimeoutInSeconds", &d.TimeoutInSeconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprComponentResiliencyPolicyConfiguration.
func (d DaprComponentResiliencyPolicyConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "circuitBreakerPolicy", d.CircuitBreakerPolicy)
	populate(objectMap, "httpRetryPolicy", d.HTTPRetryPolicy)
	populate(objectMap, "timeoutPolicy", d.TimeoutPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprComponentResiliencyPolicyConfiguration.
func (d *DaprComponentResiliencyPolicyConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "circuitBreakerPolicy":
			err = unpopulate(val, "CircuitBreakerPolicy", &d.CircuitBreakerPolicy)
			delete(rawMsg, key)
		case "httpRetryPolicy":
			err = unpopulate(val, "HTTPRetryPolicy", &d.HTTPRetryPolicy)
			delete(rawMsg, key)
		case "timeoutPolicy":
			err = unpopulate(val, "TimeoutPolicy", &d.TimeoutPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration.
func (d DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "initialDelayInMilliseconds", d.InitialDelayInMilliseconds)
	populate(objectMap, "maxIntervalInMilliseconds", d.MaxIntervalInMilliseconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration.
func (d *DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "initialDelayInMilliseconds":
			err = unpopulate(val, "InitialDelayInMilliseconds", &d.InitialDelayInMilliseconds)
			delete(rawMsg, key)
		case "maxIntervalInMilliseconds":
			err = unpopulate(val, "MaxIntervalInMilliseconds", &d.MaxIntervalInMilliseconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration.
func (d DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxRetries", d.MaxRetries)
	populate(objectMap, "retryBackOff", d.RetryBackOff)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration.
func (d *DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxRetries":
			err = unpopulate(val, "MaxRetries", &d.MaxRetries)
			delete(rawMsg, key)
		case "retryBackOff":
			err = unpopulate(val, "RetryBackOff", &d.RetryBackOff)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprComponentResiliencyPolicyProperties.
func (d DaprComponentResiliencyPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "inboundPolicy", d.InboundPolicy)
	populate(objectMap, "outboundPolicy", d.OutboundPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprComponentResiliencyPolicyProperties.
func (d *DaprComponentResiliencyPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inboundPolicy":
			err = unpopulate(val, "InboundPolicy", &d.InboundPolicy)
			delete(rawMsg, key)
		case "outboundPolicy":
			err = unpopulate(val, "OutboundPolicy", &d.OutboundPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprComponentResiliencyPolicyTimeoutPolicyConfiguration.
func (d DaprComponentResiliencyPolicyTimeoutPolicyConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "responseTimeoutInSeconds", d.ResponseTimeoutInSeconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprComponentResiliencyPolicyTimeoutPolicyConfiguration.
func (d *DaprComponentResiliencyPolicyTimeoutPolicyConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "responseTimeoutInSeconds":
			err = unpopulate(val, "ResponseTimeoutInSeconds", &d.ResponseTimeoutInSeconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprComponentServiceBinding.
func (d DaprComponentServiceBinding) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metadata", d.Metadata)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "serviceId", d.ServiceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprComponentServiceBinding.
func (d *DaprComponentServiceBinding) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metadata":
			err = unpopulate(val, "Metadata", &d.Metadata)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "serviceId":
			err = unpopulate(val, "ServiceID", &d.ServiceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprComponentsCollection.
func (d DaprComponentsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprComponentsCollection.
func (d *DaprComponentsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprConfiguration.
func (d DaprConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "version", d.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprConfiguration.
func (d *DaprConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "version":
			err = unpopulate(val, "Version", &d.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprMetadata.
func (d DaprMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "secretRef", d.SecretRef)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprMetadata.
func (d *DaprMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "secretRef":
			err = unpopulate(val, "SecretRef", &d.SecretRef)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprSecret.
func (d DaprSecret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprSecret.
func (d *DaprSecret) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprSecretsCollection.
func (d DaprSecretsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprSecretsCollection.
func (d *DaprSecretsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprServiceBindMetadata.
func (d DaprServiceBindMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprServiceBindMetadata.
func (d *DaprServiceBindMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprSubscription.
func (d DaprSubscription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprSubscription.
func (d *DaprSubscription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprSubscriptionBulkSubscribeOptions.
func (d DaprSubscriptionBulkSubscribeOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", d.Enabled)
	populate(objectMap, "maxAwaitDurationMs", d.MaxAwaitDurationMs)
	populate(objectMap, "maxMessagesCount", d.MaxMessagesCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprSubscriptionBulkSubscribeOptions.
func (d *DaprSubscriptionBulkSubscribeOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		case "maxAwaitDurationMs":
			err = unpopulate(val, "MaxAwaitDurationMs", &d.MaxAwaitDurationMs)
			delete(rawMsg, key)
		case "maxMessagesCount":
			err = unpopulate(val, "MaxMessagesCount", &d.MaxMessagesCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprSubscriptionProperties.
func (d DaprSubscriptionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bulkSubscribe", d.BulkSubscribe)
	populate(objectMap, "deadLetterTopic", d.DeadLetterTopic)
	populate(objectMap, "metadata", d.Metadata)
	populate(objectMap, "pubsubName", d.PubsubName)
	populate(objectMap, "routes", d.Routes)
	populate(objectMap, "scopes", d.Scopes)
	populate(objectMap, "topic", d.Topic)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprSubscriptionProperties.
func (d *DaprSubscriptionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bulkSubscribe":
			err = unpopulate(val, "BulkSubscribe", &d.BulkSubscribe)
			delete(rawMsg, key)
		case "deadLetterTopic":
			err = unpopulate(val, "DeadLetterTopic", &d.DeadLetterTopic)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &d.Metadata)
			delete(rawMsg, key)
		case "pubsubName":
			err = unpopulate(val, "PubsubName", &d.PubsubName)
			delete(rawMsg, key)
		case "routes":
			err = unpopulate(val, "Routes", &d.Routes)
			delete(rawMsg, key)
		case "scopes":
			err = unpopulate(val, "Scopes", &d.Scopes)
			delete(rawMsg, key)
		case "topic":
			err = unpopulate(val, "Topic", &d.Topic)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprSubscriptionRouteRule.
func (d DaprSubscriptionRouteRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "match", d.Match)
	populate(objectMap, "path", d.Path)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprSubscriptionRouteRule.
func (d *DaprSubscriptionRouteRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "match":
			err = unpopulate(val, "Match", &d.Match)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &d.Path)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprSubscriptionRoutes.
func (d DaprSubscriptionRoutes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "default", d.Default)
	populate(objectMap, "rules", d.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprSubscriptionRoutes.
func (d *DaprSubscriptionRoutes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &d.Default)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &d.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaprSubscriptionsCollection.
func (d DaprSubscriptionsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaprSubscriptionsCollection.
func (d *DaprSubscriptionsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataDogConfiguration.
func (d DataDogConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", d.Key)
	populate(objectMap, "site", d.Site)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataDogConfiguration.
func (d *DataDogConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &d.Key)
			delete(rawMsg, key)
		case "site":
			err = unpopulate(val, "Site", &d.Site)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultAuthorizationPolicy.
func (d DefaultAuthorizationPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedApplications", d.AllowedApplications)
	populate(objectMap, "allowedPrincipals", d.AllowedPrincipals)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultAuthorizationPolicy.
func (d *DefaultAuthorizationPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedApplications":
			err = unpopulate(val, "AllowedApplications", &d.AllowedApplications)
			delete(rawMsg, key)
		case "allowedPrincipals":
			err = unpopulate(val, "AllowedPrincipals", &d.AllowedPrincipals)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultErrorResponse.
func (d DefaultErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", d.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultErrorResponse.
func (d *DefaultErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &d.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultErrorResponseError.
func (d DefaultErrorResponseError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", d.Code)
	populate(objectMap, "details", d.Details)
	populate(objectMap, "innererror", d.Innererror)
	populate(objectMap, "message", d.Message)
	populate(objectMap, "target", d.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultErrorResponseError.
func (d *DefaultErrorResponseError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &d.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &d.Details)
			delete(rawMsg, key)
		case "innererror":
			err = unpopulate(val, "Innererror", &d.Innererror)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &d.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &d.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultErrorResponseErrorDetailsItem.
func (d DefaultErrorResponseErrorDetailsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", d.Code)
	populate(objectMap, "message", d.Message)
	populate(objectMap, "target", d.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultErrorResponseErrorDetailsItem.
func (d *DefaultErrorResponseErrorDetailsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &d.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &d.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &d.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DestinationsConfiguration.
func (d DestinationsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataDogConfiguration", d.DataDogConfiguration)
	populate(objectMap, "otlpConfigurations", d.OtlpConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DestinationsConfiguration.
func (d *DestinationsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDogConfiguration":
			err = unpopulate(val, "DataDogConfiguration", &d.DataDogConfiguration)
			delete(rawMsg, key)
		case "otlpConfigurations":
			err = unpopulate(val, "OtlpConfigurations", &d.OtlpConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticDataProviderMetadata.
func (d DiagnosticDataProviderMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "propertyBag", d.PropertyBag)
	populate(objectMap, "providerName", d.ProviderName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticDataProviderMetadata.
func (d *DiagnosticDataProviderMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "propertyBag":
			err = unpopulate(val, "PropertyBag", &d.PropertyBag)
			delete(rawMsg, key)
		case "providerName":
			err = unpopulate(val, "ProviderName", &d.ProviderName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticDataProviderMetadataPropertyBagItem.
func (d DiagnosticDataProviderMetadataPropertyBagItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticDataProviderMetadataPropertyBagItem.
func (d *DiagnosticDataProviderMetadataPropertyBagItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticDataTableResponseColumn.
func (d DiagnosticDataTableResponseColumn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "columnName", d.ColumnName)
	populate(objectMap, "columnType", d.ColumnType)
	populate(objectMap, "dataType", d.DataType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticDataTableResponseColumn.
func (d *DiagnosticDataTableResponseColumn) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columnName":
			err = unpopulate(val, "ColumnName", &d.ColumnName)
			delete(rawMsg, key)
		case "columnType":
			err = unpopulate(val, "ColumnType", &d.ColumnType)
			delete(rawMsg, key)
		case "dataType":
			err = unpopulate(val, "DataType", &d.DataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticDataTableResponseObject.
func (d DiagnosticDataTableResponseObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "columns", d.Columns)
	populate(objectMap, "rows", d.Rows)
	populate(objectMap, "tableName", d.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticDataTableResponseObject.
func (d *DiagnosticDataTableResponseObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columns":
			err = unpopulate(val, "Columns", &d.Columns)
			delete(rawMsg, key)
		case "rows":
			err = unpopulate(val, "Rows", &d.Rows)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &d.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticRendering.
func (d DiagnosticRendering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "isVisible", d.IsVisible)
	populate(objectMap, "title", d.Title)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticRendering.
func (d *DiagnosticRendering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "isVisible":
			err = unpopulate(val, "IsVisible", &d.IsVisible)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &d.Title)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticSupportTopic.
func (d DiagnosticSupportTopic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "pesId", d.PesID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticSupportTopic.
func (d *DiagnosticSupportTopic) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "pesId":
			err = unpopulate(val, "PesID", &d.PesID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Diagnostics.
func (d Diagnostics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Diagnostics.
func (d *Diagnostics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticsCollection.
func (d DiagnosticsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticsCollection.
func (d *DiagnosticsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticsDataAPIResponse.
func (d DiagnosticsDataAPIResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "renderingProperties", d.RenderingProperties)
	populate(objectMap, "table", d.Table)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticsDataAPIResponse.
func (d *DiagnosticsDataAPIResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "renderingProperties":
			err = unpopulate(val, "RenderingProperties", &d.RenderingProperties)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &d.Table)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticsDefinition.
func (d DiagnosticsDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "analysisTypes", d.AnalysisTypes)
	populate(objectMap, "author", d.Author)
	populate(objectMap, "category", d.Category)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "score", d.Score)
	populate(objectMap, "supportTopicList", d.SupportTopicList)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticsDefinition.
func (d *DiagnosticsDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisTypes":
			err = unpopulate(val, "AnalysisTypes", &d.AnalysisTypes)
			delete(rawMsg, key)
		case "author":
			err = unpopulate(val, "Author", &d.Author)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &d.Category)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "score":
			err = unpopulate(val, "Score", &d.Score)
			delete(rawMsg, key)
		case "supportTopicList":
			err = unpopulate(val, "SupportTopicList", &d.SupportTopicList)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticsProperties.
func (d DiagnosticsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataProviderMetadata", d.DataProviderMetadata)
	populate(objectMap, "dataset", d.Dataset)
	populate(objectMap, "metadata", d.Metadata)
	populate(objectMap, "status", d.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticsProperties.
func (d *DiagnosticsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataProviderMetadata":
			err = unpopulate(val, "DataProviderMetadata", &d.DataProviderMetadata)
			delete(rawMsg, key)
		case "dataset":
			err = unpopulate(val, "Dataset", &d.Dataset)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &d.Metadata)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticsStatus.
func (d DiagnosticsStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", d.Message)
	populate(objectMap, "statusId", d.StatusID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticsStatus.
func (d *DiagnosticsStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &d.Message)
			delete(rawMsg, key)
		case "statusId":
			err = unpopulate(val, "StatusID", &d.StatusID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DotNetComponent.
func (d DotNetComponent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DotNetComponent.
func (d *DotNetComponent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DotNetComponentConfigurationProperty.
func (d DotNetComponentConfigurationProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "propertyName", d.PropertyName)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DotNetComponentConfigurationProperty.
func (d *DotNetComponentConfigurationProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "propertyName":
			err = unpopulate(val, "PropertyName", &d.PropertyName)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DotNetComponentProperties.
func (d DotNetComponentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "componentType", d.ComponentType)
	populate(objectMap, "configurations", d.Configurations)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "serviceBinds", d.ServiceBinds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DotNetComponentProperties.
func (d *DotNetComponentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentType":
			err = unpopulate(val, "ComponentType", &d.ComponentType)
			delete(rawMsg, key)
		case "configurations":
			err = unpopulate(val, "Configurations", &d.Configurations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "serviceBinds":
			err = unpopulate(val, "ServiceBinds", &d.ServiceBinds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DotNetComponentServiceBind.
func (d DotNetComponentServiceBind) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "serviceId", d.ServiceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DotNetComponentServiceBind.
func (d *DotNetComponentServiceBind) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "serviceId":
			err = unpopulate(val, "ServiceID", &d.ServiceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DotNetComponentsCollection.
func (d DotNetComponentsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DotNetComponentsCollection.
func (d *DotNetComponentsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionSettings.
func (e EncryptionSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerAppAuthEncryptionSecretName", e.ContainerAppAuthEncryptionSecretName)
	populate(objectMap, "containerAppAuthSigningSecretName", e.ContainerAppAuthSigningSecretName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionSettings.
func (e *EncryptionSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerAppAuthEncryptionSecretName":
			err = unpopulate(val, "ContainerAppAuthEncryptionSecretName", &e.ContainerAppAuthEncryptionSecretName)
			delete(rawMsg, key)
		case "containerAppAuthSigningSecretName":
			err = unpopulate(val, "ContainerAppAuthSigningSecretName", &e.ContainerAppAuthSigningSecretName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentAuthToken.
func (e EnvironmentAuthToken) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "tags", e.Tags)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentAuthToken.
func (e *EnvironmentAuthToken) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentAuthTokenProperties.
func (e EnvironmentAuthTokenProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "expires", e.Expires)
	populate(objectMap, "token", e.Token)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentAuthTokenProperties.
func (e *EnvironmentAuthTokenProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expires":
			err = unpopulateDateTimeRFC3339(val, "Expires", &e.Expires)
			delete(rawMsg, key)
		case "token":
			err = unpopulate(val, "Token", &e.Token)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentVar.
func (e EnvironmentVar) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "secretRef", e.SecretRef)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentVar.
func (e *EnvironmentVar) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "secretRef":
			err = unpopulate(val, "SecretRef", &e.SecretRef)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentVariable.
func (e EnvironmentVariable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentVariable.
func (e *EnvironmentVariable) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorAdditionalInfo.
func (e ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "info", e.Info)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorAdditionalInfo.
func (e *ErrorAdditionalInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &e.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetail.
func (e *ErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedLocation.
func (e ExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedLocation.
func (e *ExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Facebook.
func (f Facebook) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", f.Enabled)
	populate(objectMap, "graphApiVersion", f.GraphAPIVersion)
	populate(objectMap, "login", f.Login)
	populate(objectMap, "registration", f.Registration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Facebook.
func (f *Facebook) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &f.Enabled)
			delete(rawMsg, key)
		case "graphApiVersion":
			err = unpopulate(val, "GraphAPIVersion", &f.GraphAPIVersion)
			delete(rawMsg, key)
		case "login":
			err = unpopulate(val, "Login", &f.Login)
			delete(rawMsg, key)
		case "registration":
			err = unpopulate(val, "Registration", &f.Registration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForwardProxy.
func (f ForwardProxy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "convention", f.Convention)
	populate(objectMap, "customHostHeaderName", f.CustomHostHeaderName)
	populate(objectMap, "customProtoHeaderName", f.CustomProtoHeaderName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForwardProxy.
func (f *ForwardProxy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "convention":
			err = unpopulate(val, "Convention", &f.Convention)
			delete(rawMsg, key)
		case "customHostHeaderName":
			err = unpopulate(val, "CustomHostHeaderName", &f.CustomHostHeaderName)
			delete(rawMsg, key)
		case "customProtoHeaderName":
			err = unpopulate(val, "CustomProtoHeaderName", &f.CustomProtoHeaderName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GitHub.
func (g GitHub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", g.Enabled)
	populate(objectMap, "login", g.Login)
	populate(objectMap, "registration", g.Registration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GitHub.
func (g *GitHub) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &g.Enabled)
			delete(rawMsg, key)
		case "login":
			err = unpopulate(val, "Login", &g.Login)
			delete(rawMsg, key)
		case "registration":
			err = unpopulate(val, "Registration", &g.Registration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GithubActionConfiguration.
func (g GithubActionConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureCredentials", g.AzureCredentials)
	populate(objectMap, "buildEnvironmentVariables", g.BuildEnvironmentVariables)
	populate(objectMap, "contextPath", g.ContextPath)
	populate(objectMap, "githubPersonalAccessToken", g.GithubPersonalAccessToken)
	populate(objectMap, "image", g.Image)
	populate(objectMap, "os", g.OS)
	populate(objectMap, "publishType", g.PublishType)
	populate(objectMap, "registryInfo", g.RegistryInfo)
	populate(objectMap, "runtimeStack", g.RuntimeStack)
	populate(objectMap, "runtimeVersion", g.RuntimeVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GithubActionConfiguration.
func (g *GithubActionConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureCredentials":
			err = unpopulate(val, "AzureCredentials", &g.AzureCredentials)
			delete(rawMsg, key)
		case "buildEnvironmentVariables":
			err = unpopulate(val, "BuildEnvironmentVariables", &g.BuildEnvironmentVariables)
			delete(rawMsg, key)
		case "contextPath":
			err = unpopulate(val, "ContextPath", &g.ContextPath)
			delete(rawMsg, key)
		case "githubPersonalAccessToken":
			err = unpopulate(val, "GithubPersonalAccessToken", &g.GithubPersonalAccessToken)
			delete(rawMsg, key)
		case "image":
			err = unpopulate(val, "Image", &g.Image)
			delete(rawMsg, key)
		case "os":
			err = unpopulate(val, "OS", &g.OS)
			delete(rawMsg, key)
		case "publishType":
			err = unpopulate(val, "PublishType", &g.PublishType)
			delete(rawMsg, key)
		case "registryInfo":
			err = unpopulate(val, "RegistryInfo", &g.RegistryInfo)
			delete(rawMsg, key)
		case "runtimeStack":
			err = unpopulate(val, "RuntimeStack", &g.RuntimeStack)
			delete(rawMsg, key)
		case "runtimeVersion":
			err = unpopulate(val, "RuntimeVersion", &g.RuntimeVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GlobalValidation.
func (g GlobalValidation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "excludedPaths", g.ExcludedPaths)
	populate(objectMap, "redirectToProvider", g.RedirectToProvider)
	populate(objectMap, "unauthenticatedClientAction", g.UnauthenticatedClientAction)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GlobalValidation.
func (g *GlobalValidation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "excludedPaths":
			err = unpopulate(val, "ExcludedPaths", &g.ExcludedPaths)
			delete(rawMsg, key)
		case "redirectToProvider":
			err = unpopulate(val, "RedirectToProvider", &g.RedirectToProvider)
			delete(rawMsg, key)
		case "unauthenticatedClientAction":
			err = unpopulate(val, "UnauthenticatedClientAction", &g.UnauthenticatedClientAction)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Google.
func (g Google) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", g.Enabled)
	populate(objectMap, "login", g.Login)
	populate(objectMap, "registration", g.Registration)
	populate(objectMap, "validation", g.Validation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Google.
func (g *Google) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &g.Enabled)
			delete(rawMsg, key)
		case "login":
			err = unpopulate(val, "Login", &g.Login)
			delete(rawMsg, key)
		case "registration":
			err = unpopulate(val, "Registration", &g.Registration)
			delete(rawMsg, key)
		case "validation":
			err = unpopulate(val, "Validation", &g.Validation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPConnectionPool.
func (h HTTPConnectionPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "http1MaxPendingRequests", h.HTTP1MaxPendingRequests)
	populate(objectMap, "http2MaxRequests", h.HTTP2MaxRequests)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPConnectionPool.
func (h *HTTPConnectionPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "http1MaxPendingRequests":
			err = unpopulate(val, "HTTP1MaxPendingRequests", &h.HTTP1MaxPendingRequests)
			delete(rawMsg, key)
		case "http2MaxRequests":
			err = unpopulate(val, "HTTP2MaxRequests", &h.HTTP2MaxRequests)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPGet.
func (h HTTPGet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fileName", h.FileName)
	populate(objectMap, "headers", h.Headers)
	populate(objectMap, "url", h.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPGet.
func (h *HTTPGet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fileName":
			err = unpopulate(val, "FileName", &h.FileName)
			delete(rawMsg, key)
		case "headers":
			err = unpopulate(val, "Headers", &h.Headers)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &h.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPRetryPolicy.
func (h HTTPRetryPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matches", h.Matches)
	populate(objectMap, "maxRetries", h.MaxRetries)
	populate(objectMap, "retryBackOff", h.RetryBackOff)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPRetryPolicy.
func (h *HTTPRetryPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matches":
			err = unpopulate(val, "Matches", &h.Matches)
			delete(rawMsg, key)
		case "maxRetries":
			err = unpopulate(val, "MaxRetries", &h.MaxRetries)
			delete(rawMsg, key)
		case "retryBackOff":
			err = unpopulate(val, "RetryBackOff", &h.RetryBackOff)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPRetryPolicyMatches.
func (h HTTPRetryPolicyMatches) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errors", h.Errors)
	populate(objectMap, "httpStatusCodes", h.HTTPStatusCodes)
	populate(objectMap, "headers", h.Headers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPRetryPolicyMatches.
func (h *HTTPRetryPolicyMatches) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errors":
			err = unpopulate(val, "Errors", &h.Errors)
			delete(rawMsg, key)
		case "httpStatusCodes":
			err = unpopulate(val, "HTTPStatusCodes", &h.HTTPStatusCodes)
			delete(rawMsg, key)
		case "headers":
			err = unpopulate(val, "Headers", &h.Headers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPRetryPolicyRetryBackOff.
func (h HTTPRetryPolicyRetryBackOff) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "initialDelayInMilliseconds", h.InitialDelayInMilliseconds)
	populate(objectMap, "maxIntervalInMilliseconds", h.MaxIntervalInMilliseconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPRetryPolicyRetryBackOff.
func (h *HTTPRetryPolicyRetryBackOff) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "initialDelayInMilliseconds":
			err = unpopulate(val, "InitialDelayInMilliseconds", &h.InitialDelayInMilliseconds)
			delete(rawMsg, key)
		case "maxIntervalInMilliseconds":
			err = unpopulate(val, "MaxIntervalInMilliseconds", &h.MaxIntervalInMilliseconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPScaleRule.
func (h HTTPScaleRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auth", h.Auth)
	populate(objectMap, "metadata", h.Metadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPScaleRule.
func (h *HTTPScaleRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auth":
			err = unpopulate(val, "Auth", &h.Auth)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &h.Metadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPSettings.
func (h HTTPSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "forwardProxy", h.ForwardProxy)
	populate(objectMap, "requireHttps", h.RequireHTTPS)
	populate(objectMap, "routes", h.Routes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPSettings.
func (h *HTTPSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "forwardProxy":
			err = unpopulate(val, "ForwardProxy", &h.ForwardProxy)
			delete(rawMsg, key)
		case "requireHttps":
			err = unpopulate(val, "RequireHTTPS", &h.RequireHTTPS)
			delete(rawMsg, key)
		case "routes":
			err = unpopulate(val, "Routes", &h.Routes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPSettingsRoutes.
func (h HTTPSettingsRoutes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiPrefix", h.APIPrefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPSettingsRoutes.
func (h *HTTPSettingsRoutes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiPrefix":
			err = unpopulate(val, "APIPrefix", &h.APIPrefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Header.
func (h Header) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", h.Key)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Header.
func (h *Header) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &h.Key)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HeaderMatch.
func (h HeaderMatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "header", h.Header)
	populate(objectMap, "match", h.Match)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HeaderMatch.
func (h *HeaderMatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "header":
			err = unpopulate(val, "Header", &h.Header)
			delete(rawMsg, key)
		case "match":
			err = unpopulate(val, "Match", &h.Match)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HeaderMatchMatch.
func (h HeaderMatchMatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exactMatch", h.ExactMatch)
	populate(objectMap, "prefixMatch", h.PrefixMatch)
	populate(objectMap, "regexMatch", h.RegexMatch)
	populate(objectMap, "suffixMatch", h.SuffixMatch)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HeaderMatchMatch.
func (h *HeaderMatchMatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exactMatch":
			err = unpopulate(val, "ExactMatch", &h.ExactMatch)
			delete(rawMsg, key)
		case "prefixMatch":
			err = unpopulate(val, "PrefixMatch", &h.PrefixMatch)
			delete(rawMsg, key)
		case "regexMatch":
			err = unpopulate(val, "RegexMatch", &h.RegexMatch)
			delete(rawMsg, key)
		case "suffixMatch":
			err = unpopulate(val, "SuffixMatch", &h.SuffixMatch)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPSecurityRestrictionRule.
func (i IPSecurityRestrictionRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", i.Action)
	populate(objectMap, "description", i.Description)
	populate(objectMap, "ipAddressRange", i.IPAddressRange)
	populate(objectMap, "name", i.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPSecurityRestrictionRule.
func (i *IPSecurityRestrictionRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &i.Action)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "ipAddressRange":
			err = unpopulate(val, "IPAddressRange", &i.IPAddressRange)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProviders.
func (i IdentityProviders) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apple", i.Apple)
	populate(objectMap, "azureActiveDirectory", i.AzureActiveDirectory)
	populate(objectMap, "azureStaticWebApps", i.AzureStaticWebApps)
	populate(objectMap, "customOpenIdConnectProviders", i.CustomOpenIDConnectProviders)
	populate(objectMap, "facebook", i.Facebook)
	populate(objectMap, "gitHub", i.GitHub)
	populate(objectMap, "google", i.Google)
	populate(objectMap, "twitter", i.Twitter)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityProviders.
func (i *IdentityProviders) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apple":
			err = unpopulate(val, "Apple", &i.Apple)
			delete(rawMsg, key)
		case "azureActiveDirectory":
			err = unpopulate(val, "AzureActiveDirectory", &i.AzureActiveDirectory)
			delete(rawMsg, key)
		case "azureStaticWebApps":
			err = unpopulate(val, "AzureStaticWebApps", &i.AzureStaticWebApps)
			delete(rawMsg, key)
		case "customOpenIdConnectProviders":
			err = unpopulate(val, "CustomOpenIDConnectProviders", &i.CustomOpenIDConnectProviders)
			delete(rawMsg, key)
		case "facebook":
			err = unpopulate(val, "Facebook", &i.Facebook)
			delete(rawMsg, key)
		case "gitHub":
			err = unpopulate(val, "GitHub", &i.GitHub)
			delete(rawMsg, key)
		case "google":
			err = unpopulate(val, "Google", &i.Google)
			delete(rawMsg, key)
		case "twitter":
			err = unpopulate(val, "Twitter", &i.Twitter)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Ingress.
func (i Ingress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalPortMappings", i.AdditionalPortMappings)
	populate(objectMap, "allowInsecure", i.AllowInsecure)
	populate(objectMap, "clientCertificateMode", i.ClientCertificateMode)
	populate(objectMap, "corsPolicy", i.CorsPolicy)
	populate(objectMap, "customDomains", i.CustomDomains)
	populate(objectMap, "exposedPort", i.ExposedPort)
	populate(objectMap, "external", i.External)
	populate(objectMap, "fqdn", i.Fqdn)
	populate(objectMap, "ipSecurityRestrictions", i.IPSecurityRestrictions)
	populate(objectMap, "stickySessions", i.StickySessions)
	populate(objectMap, "targetPort", i.TargetPort)
	populate(objectMap, "targetPortHttpScheme", i.TargetPortHTTPScheme)
	populate(objectMap, "traffic", i.Traffic)
	populate(objectMap, "transport", i.Transport)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Ingress.
func (i *Ingress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalPortMappings":
			err = unpopulate(val, "AdditionalPortMappings", &i.AdditionalPortMappings)
			delete(rawMsg, key)
		case "allowInsecure":
			err = unpopulate(val, "AllowInsecure", &i.AllowInsecure)
			delete(rawMsg, key)
		case "clientCertificateMode":
			err = unpopulate(val, "ClientCertificateMode", &i.ClientCertificateMode)
			delete(rawMsg, key)
		case "corsPolicy":
			err = unpopulate(val, "CorsPolicy", &i.CorsPolicy)
			delete(rawMsg, key)
		case "customDomains":
			err = unpopulate(val, "CustomDomains", &i.CustomDomains)
			delete(rawMsg, key)
		case "exposedPort":
			err = unpopulate(val, "ExposedPort", &i.ExposedPort)
			delete(rawMsg, key)
		case "external":
			err = unpopulate(val, "External", &i.External)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &i.Fqdn)
			delete(rawMsg, key)
		case "ipSecurityRestrictions":
			err = unpopulate(val, "IPSecurityRestrictions", &i.IPSecurityRestrictions)
			delete(rawMsg, key)
		case "stickySessions":
			err = unpopulate(val, "StickySessions", &i.StickySessions)
			delete(rawMsg, key)
		case "targetPort":
			err = unpopulate(val, "TargetPort", &i.TargetPort)
			delete(rawMsg, key)
		case "targetPortHttpScheme":
			err = unpopulate(val, "TargetPortHTTPScheme", &i.TargetPortHTTPScheme)
			delete(rawMsg, key)
		case "traffic":
			err = unpopulate(val, "Traffic", &i.Traffic)
			delete(rawMsg, key)
		case "transport":
			err = unpopulate(val, "Transport", &i.Transport)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IngressPortMapping.
func (i IngressPortMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exposedPort", i.ExposedPort)
	populate(objectMap, "external", i.External)
	populate(objectMap, "targetPort", i.TargetPort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IngressPortMapping.
func (i *IngressPortMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exposedPort":
			err = unpopulate(val, "ExposedPort", &i.ExposedPort)
			delete(rawMsg, key)
		case "external":
			err = unpopulate(val, "External", &i.External)
			delete(rawMsg, key)
		case "targetPort":
			err = unpopulate(val, "TargetPort", &i.TargetPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IngressStickySessions.
func (i IngressStickySessions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affinity", i.Affinity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IngressStickySessions.
func (i *IngressStickySessions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affinity":
			err = unpopulate(val, "Affinity", &i.Affinity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InitContainer.
func (i InitContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "args", i.Args)
	populate(objectMap, "command", i.Command)
	populate(objectMap, "env", i.Env)
	populate(objectMap, "image", i.Image)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "resources", i.Resources)
	populate(objectMap, "volumeMounts", i.VolumeMounts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InitContainer.
func (i *InitContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "args":
			err = unpopulate(val, "Args", &i.Args)
			delete(rawMsg, key)
		case "command":
			err = unpopulate(val, "Command", &i.Command)
			delete(rawMsg, key)
		case "env":
			err = unpopulate(val, "Env", &i.Env)
			delete(rawMsg, key)
		case "image":
			err = unpopulate(val, "Image", &i.Image)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &i.Resources)
			delete(rawMsg, key)
		case "volumeMounts":
			err = unpopulate(val, "VolumeMounts", &i.VolumeMounts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JavaComponent.
func (j JavaComponent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", j.ID)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "systemData", j.SystemData)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JavaComponent.
func (j *JavaComponent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &j.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JavaComponentConfigurationProperty.
func (j JavaComponentConfigurationProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "propertyName", j.PropertyName)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JavaComponentConfigurationProperty.
func (j *JavaComponentConfigurationProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "propertyName":
			err = unpopulate(val, "PropertyName", &j.PropertyName)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JavaComponentProperties.
func (j JavaComponentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "componentType", j.ComponentType)
	populate(objectMap, "configurations", j.Configurations)
	populate(objectMap, "provisioningState", j.ProvisioningState)
	populate(objectMap, "serviceBinds", j.ServiceBinds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JavaComponentProperties.
func (j *JavaComponentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentType":
			err = unpopulate(val, "ComponentType", &j.ComponentType)
			delete(rawMsg, key)
		case "configurations":
			err = unpopulate(val, "Configurations", &j.Configurations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &j.ProvisioningState)
			delete(rawMsg, key)
		case "serviceBinds":
			err = unpopulate(val, "ServiceBinds", &j.ServiceBinds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JavaComponentServiceBind.
func (j JavaComponentServiceBind) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "serviceId", j.ServiceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JavaComponentServiceBind.
func (j *JavaComponentServiceBind) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "serviceId":
			err = unpopulate(val, "ServiceID", &j.ServiceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JavaComponentsCollection.
func (j JavaComponentsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", j.NextLink)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JavaComponentsCollection.
func (j *JavaComponentsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &j.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", j.ExtendedLocation)
	populate(objectMap, "id", j.ID)
	populate(objectMap, "identity", j.Identity)
	populate(objectMap, "location", j.Location)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "systemData", j.SystemData)
	populate(objectMap, "tags", j.Tags)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Job.
func (j *Job) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &j.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &j.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &j.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &j.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &j.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobConfiguration.
func (j JobConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eventTriggerConfig", j.EventTriggerConfig)
	populate(objectMap, "manualTriggerConfig", j.ManualTriggerConfig)
	populate(objectMap, "registries", j.Registries)
	populate(objectMap, "replicaRetryLimit", j.ReplicaRetryLimit)
	populate(objectMap, "replicaTimeout", j.ReplicaTimeout)
	populate(objectMap, "scheduleTriggerConfig", j.ScheduleTriggerConfig)
	populate(objectMap, "secrets", j.Secrets)
	populate(objectMap, "triggerType", j.TriggerType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobConfiguration.
func (j *JobConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eventTriggerConfig":
			err = unpopulate(val, "EventTriggerConfig", &j.EventTriggerConfig)
			delete(rawMsg, key)
		case "manualTriggerConfig":
			err = unpopulate(val, "ManualTriggerConfig", &j.ManualTriggerConfig)
			delete(rawMsg, key)
		case "registries":
			err = unpopulate(val, "Registries", &j.Registries)
			delete(rawMsg, key)
		case "replicaRetryLimit":
			err = unpopulate(val, "ReplicaRetryLimit", &j.ReplicaRetryLimit)
			delete(rawMsg, key)
		case "replicaTimeout":
			err = unpopulate(val, "ReplicaTimeout", &j.ReplicaTimeout)
			delete(rawMsg, key)
		case "scheduleTriggerConfig":
			err = unpopulate(val, "ScheduleTriggerConfig", &j.ScheduleTriggerConfig)
			delete(rawMsg, key)
		case "secrets":
			err = unpopulate(val, "Secrets", &j.Secrets)
			delete(rawMsg, key)
		case "triggerType":
			err = unpopulate(val, "TriggerType", &j.TriggerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobConfigurationEventTriggerConfig.
func (j JobConfigurationEventTriggerConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "parallelism", j.Parallelism)
	populate(objectMap, "replicaCompletionCount", j.ReplicaCompletionCount)
	populate(objectMap, "scale", j.Scale)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobConfigurationEventTriggerConfig.
func (j *JobConfigurationEventTriggerConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parallelism":
			err = unpopulate(val, "Parallelism", &j.Parallelism)
			delete(rawMsg, key)
		case "replicaCompletionCount":
			err = unpopulate(val, "ReplicaCompletionCount", &j.ReplicaCompletionCount)
			delete(rawMsg, key)
		case "scale":
			err = unpopulate(val, "Scale", &j.Scale)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobConfigurationManualTriggerConfig.
func (j JobConfigurationManualTriggerConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "parallelism", j.Parallelism)
	populate(objectMap, "replicaCompletionCount", j.ReplicaCompletionCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobConfigurationManualTriggerConfig.
func (j *JobConfigurationManualTriggerConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parallelism":
			err = unpopulate(val, "Parallelism", &j.Parallelism)
			delete(rawMsg, key)
		case "replicaCompletionCount":
			err = unpopulate(val, "ReplicaCompletionCount", &j.ReplicaCompletionCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobConfigurationScheduleTriggerConfig.
func (j JobConfigurationScheduleTriggerConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cronExpression", j.CronExpression)
	populate(objectMap, "parallelism", j.Parallelism)
	populate(objectMap, "replicaCompletionCount", j.ReplicaCompletionCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobConfigurationScheduleTriggerConfig.
func (j *JobConfigurationScheduleTriggerConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cronExpression":
			err = unpopulate(val, "CronExpression", &j.CronExpression)
			delete(rawMsg, key)
		case "parallelism":
			err = unpopulate(val, "Parallelism", &j.Parallelism)
			delete(rawMsg, key)
		case "replicaCompletionCount":
			err = unpopulate(val, "ReplicaCompletionCount", &j.ReplicaCompletionCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobExecution.
func (j JobExecution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", j.ID)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobExecution.
func (j *JobExecution) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobExecutionBase.
func (j JobExecutionBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", j.ID)
	populate(objectMap, "name", j.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobExecutionBase.
func (j *JobExecutionBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobExecutionContainer.
func (j JobExecutionContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "args", j.Args)
	populate(objectMap, "command", j.Command)
	populate(objectMap, "env", j.Env)
	populate(objectMap, "image", j.Image)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "resources", j.Resources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobExecutionContainer.
func (j *JobExecutionContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "args":
			err = unpopulate(val, "Args", &j.Args)
			delete(rawMsg, key)
		case "command":
			err = unpopulate(val, "Command", &j.Command)
			delete(rawMsg, key)
		case "env":
			err = unpopulate(val, "Env", &j.Env)
			delete(rawMsg, key)
		case "image":
			err = unpopulate(val, "Image", &j.Image)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &j.Resources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobExecutionNamesCollection.
func (j JobExecutionNamesCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobExecutionNamesCollection.
func (j *JobExecutionNamesCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobExecutionProperties.
func (j JobExecutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", j.EndTime)
	populateDateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "status", j.Status)
	populate(objectMap, "template", j.Template)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobExecutionProperties.
func (j *JobExecutionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		case "template":
			err = unpopulate(val, "Template", &j.Template)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobExecutionTemplate.
func (j JobExecutionTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containers", j.Containers)
	populate(objectMap, "initContainers", j.InitContainers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobExecutionTemplate.
func (j *JobExecutionTemplate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containers":
			err = unpopulate(val, "Containers", &j.Containers)
			delete(rawMsg, key)
		case "initContainers":
			err = unpopulate(val, "InitContainers", &j.InitContainers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobPatchProperties.
func (j JobPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", j.ExtendedLocation)
	populate(objectMap, "identity", j.Identity)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "tags", j.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobPatchProperties.
func (j *JobPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &j.ExtendedLocation)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &j.Identity)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &j.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobPatchPropertiesProperties.
func (j JobPatchPropertiesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configuration", j.Configuration)
	populate(objectMap, "environmentId", j.EnvironmentID)
	populate(objectMap, "eventStreamEndpoint", j.EventStreamEndpoint)
	populate(objectMap, "outboundIpAddresses", j.OutboundIPAddresses)
	populate(objectMap, "template", j.Template)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobPatchPropertiesProperties.
func (j *JobPatchPropertiesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &j.Configuration)
			delete(rawMsg, key)
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &j.EnvironmentID)
			delete(rawMsg, key)
		case "eventStreamEndpoint":
			err = unpopulate(val, "EventStreamEndpoint", &j.EventStreamEndpoint)
			delete(rawMsg, key)
		case "outboundIpAddresses":
			err = unpopulate(val, "OutboundIPAddresses", &j.OutboundIPAddresses)
			delete(rawMsg, key)
		case "template":
			err = unpopulate(val, "Template", &j.Template)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobProperties.
func (j JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configuration", j.Configuration)
	populate(objectMap, "environmentId", j.EnvironmentID)
	populate(objectMap, "eventStreamEndpoint", j.EventStreamEndpoint)
	populate(objectMap, "outboundIpAddresses", j.OutboundIPAddresses)
	populate(objectMap, "provisioningState", j.ProvisioningState)
	populate(objectMap, "template", j.Template)
	populate(objectMap, "workloadProfileName", j.WorkloadProfileName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobProperties.
func (j *JobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &j.Configuration)
			delete(rawMsg, key)
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &j.EnvironmentID)
			delete(rawMsg, key)
		case "eventStreamEndpoint":
			err = unpopulate(val, "EventStreamEndpoint", &j.EventStreamEndpoint)
			delete(rawMsg, key)
		case "outboundIpAddresses":
			err = unpopulate(val, "OutboundIPAddresses", &j.OutboundIPAddresses)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &j.ProvisioningState)
			delete(rawMsg, key)
		case "template":
			err = unpopulate(val, "Template", &j.Template)
			delete(rawMsg, key)
		case "workloadProfileName":
			err = unpopulate(val, "WorkloadProfileName", &j.WorkloadProfileName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobScale.
func (j JobScale) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxExecutions", j.MaxExecutions)
	populate(objectMap, "minExecutions", j.MinExecutions)
	populate(objectMap, "pollingInterval", j.PollingInterval)
	populate(objectMap, "rules", j.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobScale.
func (j *JobScale) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxExecutions":
			err = unpopulate(val, "MaxExecutions", &j.MaxExecutions)
			delete(rawMsg, key)
		case "minExecutions":
			err = unpopulate(val, "MinExecutions", &j.MinExecutions)
			delete(rawMsg, key)
		case "pollingInterval":
			err = unpopulate(val, "PollingInterval", &j.PollingInterval)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &j.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobScaleRule.
func (j JobScaleRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auth", j.Auth)
	populateAny(objectMap, "metadata", j.Metadata)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobScaleRule.
func (j *JobScaleRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auth":
			err = unpopulate(val, "Auth", &j.Auth)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &j.Metadata)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobSecretsCollection.
func (j JobSecretsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobSecretsCollection.
func (j *JobSecretsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobTemplate.
func (j JobTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containers", j.Containers)
	populate(objectMap, "initContainers", j.InitContainers)
	populate(objectMap, "volumes", j.Volumes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobTemplate.
func (j *JobTemplate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containers":
			err = unpopulate(val, "Containers", &j.Containers)
			delete(rawMsg, key)
		case "initContainers":
			err = unpopulate(val, "InitContainers", &j.InitContainers)
			delete(rawMsg, key)
		case "volumes":
			err = unpopulate(val, "Volumes", &j.Volumes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobsCollection.
func (j JobsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", j.NextLink)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobsCollection.
func (j *JobsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &j.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JwtClaimChecks.
func (j JwtClaimChecks) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedClientApplications", j.AllowedClientApplications)
	populate(objectMap, "allowedGroups", j.AllowedGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JwtClaimChecks.
func (j *JwtClaimChecks) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedClientApplications":
			err = unpopulate(val, "AllowedClientApplications", &j.AllowedClientApplications)
			delete(rawMsg, key)
		case "allowedGroups":
			err = unpopulate(val, "AllowedGroups", &j.AllowedGroups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KedaConfiguration.
func (k KedaConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "version", k.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KedaConfiguration.
func (k *KedaConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "version":
			err = unpopulate(val, "Version", &k.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListUsagesResult.
func (l ListUsagesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListUsagesResult.
func (l *ListUsagesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogAnalyticsConfiguration.
func (l LogAnalyticsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customerId", l.CustomerID)
	populate(objectMap, "dynamicJsonColumns", l.DynamicJSONColumns)
	populate(objectMap, "sharedKey", l.SharedKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogAnalyticsConfiguration.
func (l *LogAnalyticsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customerId":
			err = unpopulate(val, "CustomerID", &l.CustomerID)
			delete(rawMsg, key)
		case "dynamicJsonColumns":
			err = unpopulate(val, "DynamicJSONColumns", &l.DynamicJSONColumns)
			delete(rawMsg, key)
		case "sharedKey":
			err = unpopulate(val, "SharedKey", &l.SharedKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Login.
func (l Login) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedExternalRedirectUrls", l.AllowedExternalRedirectUrls)
	populate(objectMap, "cookieExpiration", l.CookieExpiration)
	populate(objectMap, "nonce", l.Nonce)
	populate(objectMap, "preserveUrlFragmentsForLogins", l.PreserveURLFragmentsForLogins)
	populate(objectMap, "routes", l.Routes)
	populate(objectMap, "tokenStore", l.TokenStore)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Login.
func (l *Login) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedExternalRedirectUrls":
			err = unpopulate(val, "AllowedExternalRedirectUrls", &l.AllowedExternalRedirectUrls)
			delete(rawMsg, key)
		case "cookieExpiration":
			err = unpopulate(val, "CookieExpiration", &l.CookieExpiration)
			delete(rawMsg, key)
		case "nonce":
			err = unpopulate(val, "Nonce", &l.Nonce)
			delete(rawMsg, key)
		case "preserveUrlFragmentsForLogins":
			err = unpopulate(val, "PreserveURLFragmentsForLogins", &l.PreserveURLFragmentsForLogins)
			delete(rawMsg, key)
		case "routes":
			err = unpopulate(val, "Routes", &l.Routes)
			delete(rawMsg, key)
		case "tokenStore":
			err = unpopulate(val, "TokenStore", &l.TokenStore)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoginRoutes.
func (l LoginRoutes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logoutEndpoint", l.LogoutEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoginRoutes.
func (l *LoginRoutes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logoutEndpoint":
			err = unpopulate(val, "LogoutEndpoint", &l.LogoutEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoginScopes.
func (l LoginScopes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "scopes", l.Scopes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoginScopes.
func (l *LoginScopes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scopes":
			err = unpopulate(val, "Scopes", &l.Scopes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogsConfiguration.
func (l LogsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinations", l.Destinations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogsConfiguration.
func (l *LogsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinations":
			err = unpopulate(val, "Destinations", &l.Destinations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedCertificate.
func (m ManagedCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedCertificate.
func (m *ManagedCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedCertificateCollection.
func (m ManagedCertificateCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedCertificateCollection.
func (m *ManagedCertificateCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedCertificatePatch.
func (m ManagedCertificatePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", m.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedCertificatePatch.
func (m *ManagedCertificatePatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedCertificateProperties.
func (m ManagedCertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domainControlValidation", m.DomainControlValidation)
	populate(objectMap, "error", m.Error)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "subjectName", m.SubjectName)
	populate(objectMap, "validationToken", m.ValidationToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedCertificateProperties.
func (m *ManagedCertificateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainControlValidation":
			err = unpopulate(val, "DomainControlValidation", &m.DomainControlValidation)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "subjectName":
			err = unpopulate(val, "SubjectName", &m.SubjectName)
			delete(rawMsg, key)
		case "validationToken":
			err = unpopulate(val, "ValidationToken", &m.ValidationToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedEnvironment.
func (m ManagedEnvironment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "identity", m.Identity)
	populate(objectMap, "kind", m.Kind)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedEnvironment.
func (m *ManagedEnvironment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &m.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedEnvironmentProperties.
func (m ManagedEnvironmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appInsightsConfiguration", m.AppInsightsConfiguration)
	populate(objectMap, "appLogsConfiguration", m.AppLogsConfiguration)
	populate(objectMap, "customDomainConfiguration", m.CustomDomainConfiguration)
	populate(objectMap, "daprAIConnectionString", m.DaprAIConnectionString)
	populate(objectMap, "daprAIInstrumentationKey", m.DaprAIInstrumentationKey)
	populate(objectMap, "daprConfiguration", m.DaprConfiguration)
	populate(objectMap, "defaultDomain", m.DefaultDomain)
	populate(objectMap, "deploymentErrors", m.DeploymentErrors)
	populate(objectMap, "eventStreamEndpoint", m.EventStreamEndpoint)
	populate(objectMap, "infrastructureResourceGroup", m.InfrastructureResourceGroup)
	populate(objectMap, "kedaConfiguration", m.KedaConfiguration)
	populate(objectMap, "openTelemetryConfiguration", m.OpenTelemetryConfiguration)
	populate(objectMap, "peerAuthentication", m.PeerAuthentication)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "staticIp", m.StaticIP)
	populate(objectMap, "vnetConfiguration", m.VnetConfiguration)
	populate(objectMap, "workloadProfiles", m.WorkloadProfiles)
	populate(objectMap, "zoneRedundant", m.ZoneRedundant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedEnvironmentProperties.
func (m *ManagedEnvironmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appInsightsConfiguration":
			err = unpopulate(val, "AppInsightsConfiguration", &m.AppInsightsConfiguration)
			delete(rawMsg, key)
		case "appLogsConfiguration":
			err = unpopulate(val, "AppLogsConfiguration", &m.AppLogsConfiguration)
			delete(rawMsg, key)
		case "customDomainConfiguration":
			err = unpopulate(val, "CustomDomainConfiguration", &m.CustomDomainConfiguration)
			delete(rawMsg, key)
		case "daprAIConnectionString":
			err = unpopulate(val, "DaprAIConnectionString", &m.DaprAIConnectionString)
			delete(rawMsg, key)
		case "daprAIInstrumentationKey":
			err = unpopulate(val, "DaprAIInstrumentationKey", &m.DaprAIInstrumentationKey)
			delete(rawMsg, key)
		case "daprConfiguration":
			err = unpopulate(val, "DaprConfiguration", &m.DaprConfiguration)
			delete(rawMsg, key)
		case "defaultDomain":
			err = unpopulate(val, "DefaultDomain", &m.DefaultDomain)
			delete(rawMsg, key)
		case "deploymentErrors":
			err = unpopulate(val, "DeploymentErrors", &m.DeploymentErrors)
			delete(rawMsg, key)
		case "eventStreamEndpoint":
			err = unpopulate(val, "EventStreamEndpoint", &m.EventStreamEndpoint)
			delete(rawMsg, key)
		case "infrastructureResourceGroup":
			err = unpopulate(val, "InfrastructureResourceGroup", &m.InfrastructureResourceGroup)
			delete(rawMsg, key)
		case "kedaConfiguration":
			err = unpopulate(val, "KedaConfiguration", &m.KedaConfiguration)
			delete(rawMsg, key)
		case "openTelemetryConfiguration":
			err = unpopulate(val, "OpenTelemetryConfiguration", &m.OpenTelemetryConfiguration)
			delete(rawMsg, key)
		case "peerAuthentication":
			err = unpopulate(val, "PeerAuthentication", &m.PeerAuthentication)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "staticIp":
			err = unpopulate(val, "StaticIP", &m.StaticIP)
			delete(rawMsg, key)
		case "vnetConfiguration":
			err = unpopulate(val, "VnetConfiguration", &m.VnetConfiguration)
			delete(rawMsg, key)
		case "workloadProfiles":
			err = unpopulate(val, "WorkloadProfiles", &m.WorkloadProfiles)
			delete(rawMsg, key)
		case "zoneRedundant":
			err = unpopulate(val, "ZoneRedundant", &m.ZoneRedundant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedEnvironmentPropertiesPeerAuthentication.
func (m ManagedEnvironmentPropertiesPeerAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "mtls", m.Mtls)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedEnvironmentPropertiesPeerAuthentication.
func (m *ManagedEnvironmentPropertiesPeerAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mtls":
			err = unpopulate(val, "Mtls", &m.Mtls)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedEnvironmentStorage.
func (m ManagedEnvironmentStorage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedEnvironmentStorage.
func (m *ManagedEnvironmentStorage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedEnvironmentStorageProperties.
func (m ManagedEnvironmentStorageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureFile", m.AzureFile)
	populate(objectMap, "nfsAzureFile", m.NfsAzureFile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedEnvironmentStorageProperties.
func (m *ManagedEnvironmentStorageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureFile":
			err = unpopulate(val, "AzureFile", &m.AzureFile)
			delete(rawMsg, key)
		case "nfsAzureFile":
			err = unpopulate(val, "NfsAzureFile", &m.NfsAzureFile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedEnvironmentStoragesCollection.
func (m ManagedEnvironmentStoragesCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedEnvironmentStoragesCollection.
func (m *ManagedEnvironmentStoragesCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedEnvironmentsCollection.
func (m ManagedEnvironmentsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedEnvironmentsCollection.
func (m *ManagedEnvironmentsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedServiceIdentity.
func (m ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedServiceIdentity.
func (m *ManagedServiceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &m.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricsConfiguration.
func (m MetricsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinations", m.Destinations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricsConfiguration.
func (m *MetricsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinations":
			err = unpopulate(val, "Destinations", &m.Destinations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Mtls.
func (m Mtls) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", m.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Mtls.
func (m *Mtls) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NfsAzureFileProperties.
func (n NfsAzureFileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessMode", n.AccessMode)
	populate(objectMap, "server", n.Server)
	populate(objectMap, "shareName", n.ShareName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NfsAzureFileProperties.
func (n *NfsAzureFileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessMode":
			err = unpopulate(val, "AccessMode", &n.AccessMode)
			delete(rawMsg, key)
		case "server":
			err = unpopulate(val, "Server", &n.Server)
			delete(rawMsg, key)
		case "shareName":
			err = unpopulate(val, "ShareName", &n.ShareName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Nonce.
func (n Nonce) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nonceExpirationInterval", n.NonceExpirationInterval)
	populate(objectMap, "validateNonce", n.ValidateNonce)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Nonce.
func (n *Nonce) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nonceExpirationInterval":
			err = unpopulate(val, "NonceExpirationInterval", &n.NonceExpirationInterval)
			delete(rawMsg, key)
		case "validateNonce":
			err = unpopulate(val, "ValidateNonce", &n.ValidateNonce)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenIDConnectClientCredential.
func (o OpenIDConnectClientCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientSecretSettingName", o.ClientSecretSettingName)
	objectMap["method"] = "ClientSecretPost"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenIDConnectClientCredential.
func (o *OpenIDConnectClientCredential) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientSecretSettingName":
			err = unpopulate(val, "ClientSecretSettingName", &o.ClientSecretSettingName)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &o.Method)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenIDConnectConfig.
func (o OpenIDConnectConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationEndpoint", o.AuthorizationEndpoint)
	populate(objectMap, "certificationUri", o.CertificationURI)
	populate(objectMap, "issuer", o.Issuer)
	populate(objectMap, "tokenEndpoint", o.TokenEndpoint)
	populate(objectMap, "wellKnownOpenIdConfiguration", o.WellKnownOpenIDConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenIDConnectConfig.
func (o *OpenIDConnectConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationEndpoint":
			err = unpopulate(val, "AuthorizationEndpoint", &o.AuthorizationEndpoint)
			delete(rawMsg, key)
		case "certificationUri":
			err = unpopulate(val, "CertificationURI", &o.CertificationURI)
			delete(rawMsg, key)
		case "issuer":
			err = unpopulate(val, "Issuer", &o.Issuer)
			delete(rawMsg, key)
		case "tokenEndpoint":
			err = unpopulate(val, "TokenEndpoint", &o.TokenEndpoint)
			delete(rawMsg, key)
		case "wellKnownOpenIdConfiguration":
			err = unpopulate(val, "WellKnownOpenIDConfiguration", &o.WellKnownOpenIDConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenIDConnectLogin.
func (o OpenIDConnectLogin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nameClaimType", o.NameClaimType)
	populate(objectMap, "scopes", o.Scopes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenIDConnectLogin.
func (o *OpenIDConnectLogin) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nameClaimType":
			err = unpopulate(val, "NameClaimType", &o.NameClaimType)
			delete(rawMsg, key)
		case "scopes":
			err = unpopulate(val, "Scopes", &o.Scopes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenIDConnectRegistration.
func (o OpenIDConnectRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientCredential", o.ClientCredential)
	populate(objectMap, "clientId", o.ClientID)
	populate(objectMap, "openIdConnectConfiguration", o.OpenIDConnectConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenIDConnectRegistration.
func (o *OpenIDConnectRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientCredential":
			err = unpopulate(val, "ClientCredential", &o.ClientCredential)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &o.ClientID)
			delete(rawMsg, key)
		case "openIdConnectConfiguration":
			err = unpopulate(val, "OpenIDConnectConfiguration", &o.OpenIDConnectConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenTelemetryConfiguration.
func (o OpenTelemetryConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationsConfiguration", o.DestinationsConfiguration)
	populate(objectMap, "logsConfiguration", o.LogsConfiguration)
	populate(objectMap, "metricsConfiguration", o.MetricsConfiguration)
	populate(objectMap, "tracesConfiguration", o.TracesConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenTelemetryConfiguration.
func (o *OpenTelemetryConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationsConfiguration":
			err = unpopulate(val, "DestinationsConfiguration", &o.DestinationsConfiguration)
			delete(rawMsg, key)
		case "logsConfiguration":
			err = unpopulate(val, "LogsConfiguration", &o.LogsConfiguration)
			delete(rawMsg, key)
		case "metricsConfiguration":
			err = unpopulate(val, "MetricsConfiguration", &o.MetricsConfiguration)
			delete(rawMsg, key)
		case "tracesConfiguration":
			err = unpopulate(val, "TracesConfiguration", &o.TracesConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDetail.
func (o OperationDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDetail.
func (o *OperationDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OtlpConfiguration.
func (o OtlpConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpoint", o.Endpoint)
	populate(objectMap, "headers", o.Headers)
	populate(objectMap, "insecure", o.Insecure)
	populate(objectMap, "name", o.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OtlpConfiguration.
func (o *OtlpConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpoint":
			err = unpopulate(val, "Endpoint", &o.Endpoint)
			delete(rawMsg, key)
		case "headers":
			err = unpopulate(val, "Headers", &o.Headers)
			delete(rawMsg, key)
		case "insecure":
			err = unpopulate(val, "Insecure", &o.Insecure)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PreBuildStep.
func (p PreBuildStep) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "httpGet", p.HTTPGet)
	populate(objectMap, "scripts", p.Scripts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PreBuildStep.
func (p *PreBuildStep) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "httpGet":
			err = unpopulate(val, "HTTPGet", &p.HTTPGet)
			delete(rawMsg, key)
		case "scripts":
			err = unpopulate(val, "Scripts", &p.Scripts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueueScaleRule.
func (q QueueScaleRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auth", q.Auth)
	populate(objectMap, "queueLength", q.QueueLength)
	populate(objectMap, "queueName", q.QueueName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueueScaleRule.
func (q *QueueScaleRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auth":
			err = unpopulate(val, "Auth", &q.Auth)
			delete(rawMsg, key)
		case "queueLength":
			err = unpopulate(val, "QueueLength", &q.QueueLength)
			delete(rawMsg, key)
		case "queueName":
			err = unpopulate(val, "QueueName", &q.QueueName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegistryCredentials.
func (r RegistryCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", r.Identity)
	populate(objectMap, "passwordSecretRef", r.PasswordSecretRef)
	populate(objectMap, "server", r.Server)
	populate(objectMap, "username", r.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegistryCredentials.
func (r *RegistryCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &r.Identity)
			delete(rawMsg, key)
		case "passwordSecretRef":
			err = unpopulate(val, "PasswordSecretRef", &r.PasswordSecretRef)
			delete(rawMsg, key)
		case "server":
			err = unpopulate(val, "Server", &r.Server)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &r.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegistryInfo.
func (r RegistryInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "registryPassword", r.RegistryPassword)
	populate(objectMap, "registryUrl", r.RegistryURL)
	populate(objectMap, "registryUserName", r.RegistryUserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegistryInfo.
func (r *RegistryInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "registryPassword":
			err = unpopulate(val, "RegistryPassword", &r.RegistryPassword)
			delete(rawMsg, key)
		case "registryUrl":
			err = unpopulate(val, "RegistryURL", &r.RegistryURL)
			delete(rawMsg, key)
		case "registryUserName":
			err = unpopulate(val, "RegistryUserName", &r.RegistryUserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Replica.
func (r Replica) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Replica.
func (r *Replica) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicaCollection.
func (r ReplicaCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicaCollection.
func (r *ReplicaCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicaContainer.
func (r ReplicaContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerId", r.ContainerID)
	populate(objectMap, "execEndpoint", r.ExecEndpoint)
	populate(objectMap, "logStreamEndpoint", r.LogStreamEndpoint)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "ready", r.Ready)
	populate(objectMap, "restartCount", r.RestartCount)
	populate(objectMap, "runningState", r.RunningState)
	populate(objectMap, "runningStateDetails", r.RunningStateDetails)
	populate(objectMap, "started", r.Started)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicaContainer.
func (r *ReplicaContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerId":
			err = unpopulate(val, "ContainerID", &r.ContainerID)
			delete(rawMsg, key)
		case "execEndpoint":
			err = unpopulate(val, "ExecEndpoint", &r.ExecEndpoint)
			delete(rawMsg, key)
		case "logStreamEndpoint":
			err = unpopulate(val, "LogStreamEndpoint", &r.LogStreamEndpoint)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "ready":
			err = unpopulate(val, "Ready", &r.Ready)
			delete(rawMsg, key)
		case "restartCount":
			err = unpopulate(val, "RestartCount", &r.RestartCount)
			delete(rawMsg, key)
		case "runningState":
			err = unpopulate(val, "RunningState", &r.RunningState)
			delete(rawMsg, key)
		case "runningStateDetails":
			err = unpopulate(val, "RunningStateDetails", &r.RunningStateDetails)
			delete(rawMsg, key)
		case "started":
			err = unpopulate(val, "Started", &r.Started)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicaProperties.
func (r ReplicaProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containers", r.Containers)
	populateDateTimeRFC3339(objectMap, "createdTime", r.CreatedTime)
	populate(objectMap, "initContainers", r.InitContainers)
	populate(objectMap, "runningState", r.RunningState)
	populate(objectMap, "runningStateDetails", r.RunningStateDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicaProperties.
func (r *ReplicaProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containers":
			err = unpopulate(val, "Containers", &r.Containers)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &r.CreatedTime)
			delete(rawMsg, key)
		case "initContainers":
			err = unpopulate(val, "InitContainers", &r.InitContainers)
			delete(rawMsg, key)
		case "runningState":
			err = unpopulate(val, "RunningState", &r.RunningState)
			delete(rawMsg, key)
		case "runningStateDetails":
			err = unpopulate(val, "RunningStateDetails", &r.RunningStateDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Revision.
func (r Revision) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Revision.
func (r *Revision) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RevisionCollection.
func (r RevisionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RevisionCollection.
func (r *RevisionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RevisionProperties.
func (r RevisionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "active", r.Active)
	populateDateTimeRFC3339(objectMap, "createdTime", r.CreatedTime)
	populate(objectMap, "fqdn", r.Fqdn)
	populate(objectMap, "healthState", r.HealthState)
	populateDateTimeRFC3339(objectMap, "lastActiveTime", r.LastActiveTime)
	populate(objectMap, "provisioningError", r.ProvisioningError)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "replicas", r.Replicas)
	populate(objectMap, "runningState", r.RunningState)
	populate(objectMap, "template", r.Template)
	populate(objectMap, "trafficWeight", r.TrafficWeight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RevisionProperties.
func (r *RevisionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "active":
			err = unpopulate(val, "Active", &r.Active)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &r.CreatedTime)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &r.Fqdn)
			delete(rawMsg, key)
		case "healthState":
			err = unpopulate(val, "HealthState", &r.HealthState)
			delete(rawMsg, key)
		case "lastActiveTime":
			err = unpopulateDateTimeRFC3339(val, "LastActiveTime", &r.LastActiveTime)
			delete(rawMsg, key)
		case "provisioningError":
			err = unpopulate(val, "ProvisioningError", &r.ProvisioningError)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "replicas":
			err = unpopulate(val, "Replicas", &r.Replicas)
			delete(rawMsg, key)
		case "runningState":
			err = unpopulate(val, "RunningState", &r.RunningState)
			delete(rawMsg, key)
		case "template":
			err = unpopulate(val, "Template", &r.Template)
			delete(rawMsg, key)
		case "trafficWeight":
			err = unpopulate(val, "TrafficWeight", &r.TrafficWeight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Scale.
func (s Scale) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxReplicas", s.MaxReplicas)
	populate(objectMap, "minReplicas", s.MinReplicas)
	populate(objectMap, "rules", s.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Scale.
func (s *Scale) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxReplicas":
			err = unpopulate(val, "MaxReplicas", &s.MaxReplicas)
			delete(rawMsg, key)
		case "minReplicas":
			err = unpopulate(val, "MinReplicas", &s.MinReplicas)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &s.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScaleRule.
func (s ScaleRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureQueue", s.AzureQueue)
	populate(objectMap, "custom", s.Custom)
	populate(objectMap, "http", s.HTTP)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "tcp", s.TCP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScaleRule.
func (s *ScaleRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureQueue":
			err = unpopulate(val, "AzureQueue", &s.AzureQueue)
			delete(rawMsg, key)
		case "custom":
			err = unpopulate(val, "Custom", &s.Custom)
			delete(rawMsg, key)
		case "http":
			err = unpopulate(val, "HTTP", &s.HTTP)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "tcp":
			err = unpopulate(val, "TCP", &s.TCP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScaleRuleAuth.
func (s ScaleRuleAuth) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "secretRef", s.SecretRef)
	populate(objectMap, "triggerParameter", s.TriggerParameter)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScaleRuleAuth.
func (s *ScaleRuleAuth) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secretRef":
			err = unpopulate(val, "SecretRef", &s.SecretRef)
			delete(rawMsg, key)
		case "triggerParameter":
			err = unpopulate(val, "TriggerParameter", &s.TriggerParameter)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Secret.
func (s Secret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "keyVaultUrl", s.KeyVaultURL)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Secret.
func (s *Secret) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "keyVaultUrl":
			err = unpopulate(val, "KeyVaultURL", &s.KeyVaultURL)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretVolumeItem.
func (s SecretVolumeItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "path", s.Path)
	populate(objectMap, "secretRef", s.SecretRef)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretVolumeItem.
func (s *SecretVolumeItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "path":
			err = unpopulate(val, "Path", &s.Path)
			delete(rawMsg, key)
		case "secretRef":
			err = unpopulate(val, "SecretRef", &s.SecretRef)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretsCollection.
func (s SecretsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretsCollection.
func (s *SecretsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Service.
func (s Service) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Service.
func (s *Service) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBind.
func (s ServiceBind) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientType", s.ClientType)
	populate(objectMap, "customizedKeys", s.CustomizedKeys)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "serviceId", s.ServiceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBind.
func (s *ServiceBind) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientType":
			err = unpopulate(val, "ClientType", &s.ClientType)
			delete(rawMsg, key)
		case "customizedKeys":
			err = unpopulate(val, "CustomizedKeys", &s.CustomizedKeys)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "serviceId":
			err = unpopulate(val, "ServiceID", &s.ServiceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControl.
func (s SourceControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControl.
func (s *SourceControl) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlCollection.
func (s SourceControlCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlCollection.
func (s *SourceControlCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlProperties.
func (s SourceControlProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "branch", s.Branch)
	populate(objectMap, "githubActionConfiguration", s.GithubActionConfiguration)
	populate(objectMap, "operationState", s.OperationState)
	populate(objectMap, "repoUrl", s.RepoURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlProperties.
func (s *SourceControlProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "branch":
			err = unpopulate(val, "Branch", &s.Branch)
			delete(rawMsg, key)
		case "githubActionConfiguration":
			err = unpopulate(val, "GithubActionConfiguration", &s.GithubActionConfiguration)
			delete(rawMsg, key)
		case "operationState":
			err = unpopulate(val, "OperationState", &s.OperationState)
			delete(rawMsg, key)
		case "repoUrl":
			err = unpopulate(val, "RepoURL", &s.RepoURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TCPConnectionPool.
func (t TCPConnectionPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxConnections", t.MaxConnections)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TCPConnectionPool.
func (t *TCPConnectionPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxConnections":
			err = unpopulate(val, "MaxConnections", &t.MaxConnections)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TCPRetryPolicy.
func (t TCPRetryPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxConnectAttempts", t.MaxConnectAttempts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TCPRetryPolicy.
func (t *TCPRetryPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxConnectAttempts":
			err = unpopulate(val, "MaxConnectAttempts", &t.MaxConnectAttempts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TCPScaleRule.
func (t TCPScaleRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auth", t.Auth)
	populate(objectMap, "metadata", t.Metadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TCPScaleRule.
func (t *TCPScaleRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auth":
			err = unpopulate(val, "Auth", &t.Auth)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &t.Metadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Template.
func (t Template) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containers", t.Containers)
	populate(objectMap, "initContainers", t.InitContainers)
	populate(objectMap, "revisionSuffix", t.RevisionSuffix)
	populate(objectMap, "scale", t.Scale)
	populate(objectMap, "serviceBinds", t.ServiceBinds)
	populate(objectMap, "terminationGracePeriodSeconds", t.TerminationGracePeriodSeconds)
	populate(objectMap, "volumes", t.Volumes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Template.
func (t *Template) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containers":
			err = unpopulate(val, "Containers", &t.Containers)
			delete(rawMsg, key)
		case "initContainers":
			err = unpopulate(val, "InitContainers", &t.InitContainers)
			delete(rawMsg, key)
		case "revisionSuffix":
			err = unpopulate(val, "RevisionSuffix", &t.RevisionSuffix)
			delete(rawMsg, key)
		case "scale":
			err = unpopulate(val, "Scale", &t.Scale)
			delete(rawMsg, key)
		case "serviceBinds":
			err = unpopulate(val, "ServiceBinds", &t.ServiceBinds)
			delete(rawMsg, key)
		case "terminationGracePeriodSeconds":
			err = unpopulate(val, "TerminationGracePeriodSeconds", &t.TerminationGracePeriodSeconds)
			delete(rawMsg, key)
		case "volumes":
			err = unpopulate(val, "Volumes", &t.Volumes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TimeoutPolicy.
func (t TimeoutPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionTimeoutInSeconds", t.ConnectionTimeoutInSeconds)
	populate(objectMap, "responseTimeoutInSeconds", t.ResponseTimeoutInSeconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TimeoutPolicy.
func (t *TimeoutPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionTimeoutInSeconds":
			err = unpopulate(val, "ConnectionTimeoutInSeconds", &t.ConnectionTimeoutInSeconds)
			delete(rawMsg, key)
		case "responseTimeoutInSeconds":
			err = unpopulate(val, "ResponseTimeoutInSeconds", &t.ResponseTimeoutInSeconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TokenStore.
func (t TokenStore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureBlobStorage", t.AzureBlobStorage)
	populate(objectMap, "enabled", t.Enabled)
	populate(objectMap, "tokenRefreshExtensionHours", t.TokenRefreshExtensionHours)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TokenStore.
func (t *TokenStore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureBlobStorage":
			err = unpopulate(val, "AzureBlobStorage", &t.AzureBlobStorage)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &t.Enabled)
			delete(rawMsg, key)
		case "tokenRefreshExtensionHours":
			err = unpopulate(val, "TokenRefreshExtensionHours", &t.TokenRefreshExtensionHours)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TracesConfiguration.
func (t TracesConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinations", t.Destinations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TracesConfiguration.
func (t *TracesConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinations":
			err = unpopulate(val, "Destinations", &t.Destinations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &t.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrafficWeight.
func (t TrafficWeight) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "label", t.Label)
	populate(objectMap, "latestRevision", t.LatestRevision)
	populate(objectMap, "revisionName", t.RevisionName)
	populate(objectMap, "weight", t.Weight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrafficWeight.
func (t *TrafficWeight) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "label":
			err = unpopulate(val, "Label", &t.Label)
			delete(rawMsg, key)
		case "latestRevision":
			err = unpopulate(val, "LatestRevision", &t.LatestRevision)
			delete(rawMsg, key)
		case "revisionName":
			err = unpopulate(val, "RevisionName", &t.RevisionName)
			delete(rawMsg, key)
		case "weight":
			err = unpopulate(val, "Weight", &t.Weight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Twitter.
func (t Twitter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", t.Enabled)
	populate(objectMap, "registration", t.Registration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Twitter.
func (t *Twitter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &t.Enabled)
			delete(rawMsg, key)
		case "registration":
			err = unpopulate(val, "Registration", &t.Registration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TwitterRegistration.
func (t TwitterRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consumerKey", t.ConsumerKey)
	populate(objectMap, "consumerSecretSettingName", t.ConsumerSecretSettingName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TwitterRegistration.
func (t *TwitterRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consumerKey":
			err = unpopulate(val, "ConsumerKey", &t.ConsumerKey)
			delete(rawMsg, key)
		case "consumerSecretSettingName":
			err = unpopulate(val, "ConsumerSecretSettingName", &t.ConsumerSecretSettingName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", u.CurrentValue)
	populate(objectMap, "limit", u.Limit)
	populate(objectMap, "name", u.Name)
	objectMap["unit"] = "Count"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Usage.
func (u *Usage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &u.CurrentValue)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &u.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &u.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsageName.
func (u UsageName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", u.LocalizedValue)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageName.
func (u *UsageName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &u.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentity.
func (u UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentity.
func (u *UserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetConfiguration.
func (v VnetConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dockerBridgeCidr", v.DockerBridgeCidr)
	populate(objectMap, "infrastructureSubnetId", v.InfrastructureSubnetID)
	populate(objectMap, "internal", v.Internal)
	populate(objectMap, "platformReservedCidr", v.PlatformReservedCidr)
	populate(objectMap, "platformReservedDnsIP", v.PlatformReservedDNSIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetConfiguration.
func (v *VnetConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dockerBridgeCidr":
			err = unpopulate(val, "DockerBridgeCidr", &v.DockerBridgeCidr)
			delete(rawMsg, key)
		case "infrastructureSubnetId":
			err = unpopulate(val, "InfrastructureSubnetID", &v.InfrastructureSubnetID)
			delete(rawMsg, key)
		case "internal":
			err = unpopulate(val, "Internal", &v.Internal)
			delete(rawMsg, key)
		case "platformReservedCidr":
			err = unpopulate(val, "PlatformReservedCidr", &v.PlatformReservedCidr)
			delete(rawMsg, key)
		case "platformReservedDnsIP":
			err = unpopulate(val, "PlatformReservedDNSIP", &v.PlatformReservedDNSIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Volume.
func (v Volume) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "mountOptions", v.MountOptions)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "secrets", v.Secrets)
	populate(objectMap, "storageName", v.StorageName)
	populate(objectMap, "storageType", v.StorageType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Volume.
func (v *Volume) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mountOptions":
			err = unpopulate(val, "MountOptions", &v.MountOptions)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "secrets":
			err = unpopulate(val, "Secrets", &v.Secrets)
			delete(rawMsg, key)
		case "storageName":
			err = unpopulate(val, "StorageName", &v.StorageName)
			delete(rawMsg, key)
		case "storageType":
			err = unpopulate(val, "StorageType", &v.StorageType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeMount.
func (v VolumeMount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "mountPath", v.MountPath)
	populate(objectMap, "subPath", v.SubPath)
	populate(objectMap, "volumeName", v.VolumeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeMount.
func (v *VolumeMount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mountPath":
			err = unpopulate(val, "MountPath", &v.MountPath)
			delete(rawMsg, key)
		case "subPath":
			err = unpopulate(val, "SubPath", &v.SubPath)
			delete(rawMsg, key)
		case "volumeName":
			err = unpopulate(val, "VolumeName", &v.VolumeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkloadProfile.
func (w WorkloadProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maximumCount", w.MaximumCount)
	populate(objectMap, "minimumCount", w.MinimumCount)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "workloadProfileType", w.WorkloadProfileType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkloadProfile.
func (w *WorkloadProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maximumCount":
			err = unpopulate(val, "MaximumCount", &w.MaximumCount)
			delete(rawMsg, key)
		case "minimumCount":
			err = unpopulate(val, "MinimumCount", &w.MinimumCount)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "workloadProfileType":
			err = unpopulate(val, "WorkloadProfileType", &w.WorkloadProfileType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkloadProfileStates.
func (w WorkloadProfileStates) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "systemData", w.SystemData)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkloadProfileStates.
func (w *WorkloadProfileStates) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &w.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkloadProfileStatesCollection.
func (w WorkloadProfileStatesCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkloadProfileStatesCollection.
func (w *WorkloadProfileStatesCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkloadProfileStatesProperties.
func (w WorkloadProfileStatesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentCount", w.CurrentCount)
	populate(objectMap, "maximumCount", w.MaximumCount)
	populate(objectMap, "minimumCount", w.MinimumCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkloadProfileStatesProperties.
func (w *WorkloadProfileStatesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentCount":
			err = unpopulate(val, "CurrentCount", &w.CurrentCount)
			delete(rawMsg, key)
		case "maximumCount":
			err = unpopulate(val, "MaximumCount", &w.MaximumCount)
			delete(rawMsg, key)
		case "minimumCount":
			err = unpopulate(val, "MinimumCount", &w.MinimumCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func populateByteArray[T any](m map[string]any, k string, b []T, convert func() any) {
	if azcore.IsNullValue(b) {
		m[k] = nil
	} else if len(b) == 0 {
		return
	} else {
		m[k] = convert()
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil || string(data) == "null" {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
