//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappcontainers_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appcontainers/armappcontainers/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/DaprSubscriptions_List.json
func ExampleDaprSubscriptionsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDaprSubscriptionsClient().NewListPager("examplerg", "myenvironment", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DaprSubscriptionsCollection = armappcontainers.DaprSubscriptionsCollection{
		// 	Value: []*armappcontainers.DaprSubscription{
		// 		{
		// 			Name: to.Ptr("mybulksubscription"),
		// 			Type: to.Ptr("Microsoft.App/managedEnvironments/daprSubscriptions"),
		// 			ID: to.Ptr("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/daprSubscriptions/mybulksubscription"),
		// 			Properties: &armappcontainers.DaprSubscriptionProperties{
		// 				BulkSubscribe: &armappcontainers.DaprSubscriptionBulkSubscribeOptions{
		// 					Enabled: to.Ptr(true),
		// 					MaxAwaitDurationMs: to.Ptr[int32](500),
		// 					MaxMessagesCount: to.Ptr[int32](123),
		// 				},
		// 				PubsubName: to.Ptr("mypubsubcomponent"),
		// 				Routes: &armappcontainers.DaprSubscriptionRoutes{
		// 					Default: to.Ptr("/products"),
		// 					Rules: []*armappcontainers.DaprSubscriptionRouteRule{
		// 					},
		// 				},
		// 				Topic: to.Ptr("inventory"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mydefaultsubscription"),
		// 			Type: to.Ptr("Microsoft.App/managedEnvironments/daprSubscriptions"),
		// 			ID: to.Ptr("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/daprSubscriptions/mydefaultsubscription"),
		// 			Properties: &armappcontainers.DaprSubscriptionProperties{
		// 				PubsubName: to.Ptr("mypubsubcomponent"),
		// 				Routes: &armappcontainers.DaprSubscriptionRoutes{
		// 					Default: to.Ptr("/products"),
		// 					Rules: []*armappcontainers.DaprSubscriptionRouteRule{
		// 					},
		// 				},
		// 				Topic: to.Ptr("inventory"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myroutingsubscription"),
		// 			Type: to.Ptr("Microsoft.App/managedEnvironments/daprSubscriptions"),
		// 			ID: to.Ptr("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/daprSubscriptions/myroutingsubscription"),
		// 			Properties: &armappcontainers.DaprSubscriptionProperties{
		// 				Metadata: map[string]*string{
		// 					"foo": to.Ptr("bar"),
		// 					"hello": to.Ptr("world"),
		// 				},
		// 				PubsubName: to.Ptr("mypubsubcomponent"),
		// 				Routes: &armappcontainers.DaprSubscriptionRoutes{
		// 					Default: to.Ptr("/products"),
		// 					Rules: []*armappcontainers.DaprSubscriptionRouteRule{
		// 						{
		// 							Path: to.Ptr("/widgets"),
		// 							Match: to.Ptr("event.type == 'widget'"),
		// 						},
		// 						{
		// 							Path: to.Ptr("/gadgets"),
		// 							Match: to.Ptr("event.type == 'gadget'"),
		// 					}},
		// 				},
		// 				Topic: to.Ptr("inventory"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/DaprSubscriptions_Get_DefaultRoute.json
func ExampleDaprSubscriptionsClient_Get_getDaprSubscriptionWithBulkSubscribeConfigurationAndScopes() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDaprSubscriptionsClient().Get(ctx, "examplerg", "myenvironment", "mypubsubcomponent", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DaprSubscription = armappcontainers.DaprSubscription{
	// 	Name: to.Ptr("mysubscription"),
	// 	Type: to.Ptr("Microsoft.App/managedEnvironments/daprSubscriptions"),
	// 	ID: to.Ptr("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/daprSubscriptions/mysubscription"),
	// 	Properties: &armappcontainers.DaprSubscriptionProperties{
	// 		PubsubName: to.Ptr("mypubsubcomponent"),
	// 		Routes: &armappcontainers.DaprSubscriptionRoutes{
	// 			Default: to.Ptr("/products"),
	// 			Rules: []*armappcontainers.DaprSubscriptionRouteRule{
	// 			},
	// 		},
	// 		Topic: to.Ptr("inventory"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/DaprSubscriptions_Get_BulkSubscribeAndScopes.json
func ExampleDaprSubscriptionsClient_Get_getDaprSubscriptionWithDefaultRouteOnly() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDaprSubscriptionsClient().Get(ctx, "examplerg", "myenvironment", "mypubsubcomponent", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DaprSubscription = armappcontainers.DaprSubscription{
	// 	Name: to.Ptr("mysubscription"),
	// 	Type: to.Ptr("Microsoft.App/managedEnvironments/daprSubscriptions"),
	// 	ID: to.Ptr("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/daprSubscriptions/mysubscription"),
	// 	Properties: &armappcontainers.DaprSubscriptionProperties{
	// 		BulkSubscribe: &armappcontainers.DaprSubscriptionBulkSubscribeOptions{
	// 			Enabled: to.Ptr(true),
	// 			MaxAwaitDurationMs: to.Ptr[int32](500),
	// 			MaxMessagesCount: to.Ptr[int32](123),
	// 		},
	// 		PubsubName: to.Ptr("mypubsubcomponent"),
	// 		Routes: &armappcontainers.DaprSubscriptionRoutes{
	// 			Default: to.Ptr("/products"),
	// 			Rules: []*armappcontainers.DaprSubscriptionRouteRule{
	// 			},
	// 		},
	// 		Scopes: []*string{
	// 			to.Ptr("warehouseapp"),
	// 			to.Ptr("customersupportapp")},
	// 			Topic: to.Ptr("inventory"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/DaprSubscriptions_Get_RouteRulesAndMetadata.json
func ExampleDaprSubscriptionsClient_Get_getDaprSubscriptionWithRouteRulesAndMetadata() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDaprSubscriptionsClient().Get(ctx, "examplerg", "myenvironment", "mypubsubcomponent", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DaprSubscription = armappcontainers.DaprSubscription{
	// 	Name: to.Ptr("mysubscription"),
	// 	Type: to.Ptr("Microsoft.App/managedEnvironments/daprSubscriptions"),
	// 	ID: to.Ptr("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/daprSubscriptions/mysubscription"),
	// 	Properties: &armappcontainers.DaprSubscriptionProperties{
	// 		Metadata: map[string]*string{
	// 			"foo": to.Ptr("bar"),
	// 			"hello": to.Ptr("world"),
	// 		},
	// 		PubsubName: to.Ptr("mypubsubcomponent"),
	// 		Routes: &armappcontainers.DaprSubscriptionRoutes{
	// 			Default: to.Ptr("/products"),
	// 			Rules: []*armappcontainers.DaprSubscriptionRouteRule{
	// 				{
	// 					Path: to.Ptr("/widgets"),
	// 					Match: to.Ptr("event.type == 'widget'"),
	// 				},
	// 				{
	// 					Path: to.Ptr("/gadgets"),
	// 					Match: to.Ptr("event.type == 'gadget'"),
	// 			}},
	// 		},
	// 		Topic: to.Ptr("inventory"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/DaprSubscriptions_CreateOrUpdate_BulkSubscribeAndScopes.json
func ExampleDaprSubscriptionsClient_CreateOrUpdate_createOrUpdateDaprSubscriptionWithBulkSubscribeConfigurationAndScopes() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDaprSubscriptionsClient().CreateOrUpdate(ctx, "examplerg", "myenvironment", "mysubscription", armappcontainers.DaprSubscription{
		Properties: &armappcontainers.DaprSubscriptionProperties{
			BulkSubscribe: &armappcontainers.DaprSubscriptionBulkSubscribeOptions{
				Enabled:            to.Ptr(true),
				MaxAwaitDurationMs: to.Ptr[int32](500),
				MaxMessagesCount:   to.Ptr[int32](123),
			},
			PubsubName: to.Ptr("mypubsubcomponent"),
			Routes: &armappcontainers.DaprSubscriptionRoutes{
				Default: to.Ptr("/products"),
			},
			Scopes: []*string{
				to.Ptr("warehouseapp"),
				to.Ptr("customersupportapp")},
			Topic: to.Ptr("inventory"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DaprSubscription = armappcontainers.DaprSubscription{
	// 	Name: to.Ptr("mysubscription"),
	// 	Type: to.Ptr("Microsoft.App/managedEnvironments/daprSubscriptions"),
	// 	ID: to.Ptr("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/daprSubscriptions/mysubscription"),
	// 	Properties: &armappcontainers.DaprSubscriptionProperties{
	// 		BulkSubscribe: &armappcontainers.DaprSubscriptionBulkSubscribeOptions{
	// 			Enabled: to.Ptr(true),
	// 			MaxAwaitDurationMs: to.Ptr[int32](500),
	// 			MaxMessagesCount: to.Ptr[int32](123),
	// 		},
	// 		PubsubName: to.Ptr("mypubsubcomponent"),
	// 		Routes: &armappcontainers.DaprSubscriptionRoutes{
	// 			Default: to.Ptr("/products"),
	// 			Rules: []*armappcontainers.DaprSubscriptionRouteRule{
	// 			},
	// 		},
	// 		Scopes: []*string{
	// 			to.Ptr("warehouseapp"),
	// 			to.Ptr("customersupportapp")},
	// 			Topic: to.Ptr("inventory"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/DaprSubscriptions_CreateOrUpdate_DefaultRoute.json
func ExampleDaprSubscriptionsClient_CreateOrUpdate_createOrUpdateDaprSubscriptionWithDefaultRouteOnly() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDaprSubscriptionsClient().CreateOrUpdate(ctx, "examplerg", "myenvironment", "mysubscription", armappcontainers.DaprSubscription{
		Properties: &armappcontainers.DaprSubscriptionProperties{
			PubsubName: to.Ptr("mypubsubcomponent"),
			Routes: &armappcontainers.DaprSubscriptionRoutes{
				Default: to.Ptr("/products"),
			},
			Topic: to.Ptr("inventory"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DaprSubscription = armappcontainers.DaprSubscription{
	// 	Name: to.Ptr("mysubscription"),
	// 	Type: to.Ptr("Microsoft.App/managedEnvironments/daprSubscriptions"),
	// 	ID: to.Ptr("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/daprSubscriptions/mysubscription"),
	// 	Properties: &armappcontainers.DaprSubscriptionProperties{
	// 		PubsubName: to.Ptr("mypubsubcomponent"),
	// 		Routes: &armappcontainers.DaprSubscriptionRoutes{
	// 			Default: to.Ptr("/products"),
	// 			Rules: []*armappcontainers.DaprSubscriptionRouteRule{
	// 			},
	// 		},
	// 		Topic: to.Ptr("inventory"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/DaprSubscriptions_CreateOrUpdate_RouteRulesAndMetadata.json
func ExampleDaprSubscriptionsClient_CreateOrUpdate_createOrUpdateDaprSubscriptionWithRouteRulesAndMetadata() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDaprSubscriptionsClient().CreateOrUpdate(ctx, "examplerg", "myenvironment", "mysubscription", armappcontainers.DaprSubscription{
		Properties: &armappcontainers.DaprSubscriptionProperties{
			Metadata: map[string]*string{
				"foo":   to.Ptr("bar"),
				"hello": to.Ptr("world"),
			},
			PubsubName: to.Ptr("mypubsubcomponent"),
			Routes: &armappcontainers.DaprSubscriptionRoutes{
				Default: to.Ptr("/products"),
				Rules: []*armappcontainers.DaprSubscriptionRouteRule{
					{
						Path:  to.Ptr("/widgets"),
						Match: to.Ptr("event.type == 'widget'"),
					},
					{
						Path:  to.Ptr("/gadgets"),
						Match: to.Ptr("event.type == 'gadget'"),
					}},
			},
			Topic: to.Ptr("inventory"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DaprSubscription = armappcontainers.DaprSubscription{
	// 	Name: to.Ptr("mysubscription"),
	// 	Type: to.Ptr("Microsoft.App/managedEnvironments/daprSubscriptions"),
	// 	ID: to.Ptr("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/daprSubscriptions/mysubscription"),
	// 	Properties: &armappcontainers.DaprSubscriptionProperties{
	// 		Metadata: map[string]*string{
	// 			"foo": to.Ptr("bar"),
	// 			"hello": to.Ptr("world"),
	// 		},
	// 		PubsubName: to.Ptr("mypubsubcomponent"),
	// 		Routes: &armappcontainers.DaprSubscriptionRoutes{
	// 			Default: to.Ptr("/products"),
	// 			Rules: []*armappcontainers.DaprSubscriptionRouteRule{
	// 				{
	// 					Path: to.Ptr("/widgets"),
	// 					Match: to.Ptr("event.type == 'widget'"),
	// 				},
	// 				{
	// 					Path: to.Ptr("/gadgets"),
	// 					Match: to.Ptr("event.type == 'gadget'"),
	// 			}},
	// 		},
	// 		Topic: to.Ptr("inventory"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/DaprSubscriptions_Delete.json
func ExampleDaprSubscriptionsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewDaprSubscriptionsClient().Delete(ctx, "examplerg", "myenvironment", "mysubscription", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
