//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azopenaiassistants

import (
	"context"
	"errors"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
)

// Client contains the methods for the OpenAIAssistants group.
// Don't use this type directly, use a constructor function instead.
type Client struct {
	cd       clientData
	internal *azcore.Client
	endpoint string
}

// CancelRun - Cancels a run of an in progress thread.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - threadID - The ID of the thread being run.
//   - runID - The ID of the run to cancel.
//   - options - CancelRunOptions contains the optional parameters for the Client.CancelRun method.
func (client *Client) CancelRun(ctx context.Context, threadID string, runID string, options *CancelRunOptions) (CancelRunResponse, error) {
	var err error
	req, err := client.cancelRunCreateRequest(ctx, threadID, runID, options)
	if err != nil {
		return CancelRunResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CancelRunResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return CancelRunResponse{}, err
	}
	resp, err := client.cancelRunHandleResponse(httpResp)
	return resp, err
}

// cancelRunCreateRequest creates the CancelRun request.
func (client *Client) cancelRunCreateRequest(ctx context.Context, threadID string, runID string, options *CancelRunOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/{threadId}/runs/{runId}/cancel")
	if threadID == "" {
		return nil, errors.New("parameter threadID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{threadId}", url.PathEscape(threadID))
	if runID == "" {
		return nil, errors.New("parameter runID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{runId}", url.PathEscape(runID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// cancelRunHandleResponse handles the CancelRun response.
func (client *Client) cancelRunHandleResponse(resp *http.Response) (CancelRunResponse, error) {
	result := CancelRunResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ThreadRun); err != nil {
		return CancelRunResponse{}, err
	}
	return result, nil
}

// CreateAssistant - Creates a new assistant.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - options - CreateAssistantOptions contains the optional parameters for the Client.CreateAssistant method.
func (client *Client) CreateAssistant(ctx context.Context, body AssistantCreationBody, options *CreateAssistantOptions) (CreateAssistantResponse, error) {
	var err error
	req, err := client.createAssistantCreateRequest(ctx, body, options)
	if err != nil {
		return CreateAssistantResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CreateAssistantResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return CreateAssistantResponse{}, err
	}
	resp, err := client.createAssistantHandleResponse(httpResp)
	return resp, err
}

// createAssistantCreateRequest creates the CreateAssistant request.
func (client *Client) createAssistantCreateRequest(ctx context.Context, body AssistantCreationBody, options *CreateAssistantOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/assistants")
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// createAssistantHandleResponse handles the CreateAssistant response.
func (client *Client) createAssistantHandleResponse(resp *http.Response) (CreateAssistantResponse, error) {
	result := CreateAssistantResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Assistant); err != nil {
		return CreateAssistantResponse{}, err
	}
	return result, nil
}

// CreateAssistantFile - Attaches a previously uploaded file to an assistant for use by tools that can read files.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - assistantID - The ID of the assistant to attach the file to.
//   - options - CreateAssistantFileOptions contains the optional parameters for the Client.CreateAssistantFile method.
func (client *Client) CreateAssistantFile(ctx context.Context, assistantID string, body CreateAssistantFileBody, options *CreateAssistantFileOptions) (CreateAssistantFileResponse, error) {
	var err error
	req, err := client.createAssistantFileCreateRequest(ctx, assistantID, body, options)
	if err != nil {
		return CreateAssistantFileResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CreateAssistantFileResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return CreateAssistantFileResponse{}, err
	}
	resp, err := client.createAssistantFileHandleResponse(httpResp)
	return resp, err
}

// createAssistantFileCreateRequest creates the CreateAssistantFile request.
func (client *Client) createAssistantFileCreateRequest(ctx context.Context, assistantID string, body CreateAssistantFileBody, options *CreateAssistantFileOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/assistants/{assistantId}/files")
	if assistantID == "" {
		return nil, errors.New("parameter assistantID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{assistantId}", url.PathEscape(assistantID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// createAssistantFileHandleResponse handles the CreateAssistantFile response.
func (client *Client) createAssistantFileHandleResponse(resp *http.Response) (CreateAssistantFileResponse, error) {
	result := CreateAssistantFileResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AssistantFile); err != nil {
		return CreateAssistantFileResponse{}, err
	}
	return result, nil
}

// CreateMessage - Creates a new message on a specified thread.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - threadID - The ID of the thread to create the new message on.
//   - options - CreateMessageOptions contains the optional parameters for the Client.CreateMessage method.
func (client *Client) CreateMessage(ctx context.Context, threadID string, body CreateMessageBody, options *CreateMessageOptions) (CreateMessageResponse, error) {
	var err error
	req, err := client.createMessageCreateRequest(ctx, threadID, body, options)
	if err != nil {
		return CreateMessageResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CreateMessageResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return CreateMessageResponse{}, err
	}
	resp, err := client.createMessageHandleResponse(httpResp)
	return resp, err
}

// createMessageCreateRequest creates the CreateMessage request.
func (client *Client) createMessageCreateRequest(ctx context.Context, threadID string, body CreateMessageBody, options *CreateMessageOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/{threadId}/messages")
	if threadID == "" {
		return nil, errors.New("parameter threadID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{threadId}", url.PathEscape(threadID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// createMessageHandleResponse handles the CreateMessage response.
func (client *Client) createMessageHandleResponse(resp *http.Response) (CreateMessageResponse, error) {
	result := CreateMessageResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ThreadMessage); err != nil {
		return CreateMessageResponse{}, err
	}
	return result, nil
}

// CreateRun - Creates a new run for an assistant thread.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - threadID - The ID of the thread to run.
//   - createRunOptions - The details for the run to create.
//   - options - CreateRunOptions contains the optional parameters for the Client.CreateRun method.
func (client *Client) CreateRun(ctx context.Context, threadID string, body CreateRunBody, options *CreateRunOptions) (CreateRunResponse, error) {
	var err error
	req, err := client.createRunCreateRequest(ctx, threadID, body, options)
	if err != nil {
		return CreateRunResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CreateRunResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return CreateRunResponse{}, err
	}
	resp, err := client.createRunHandleResponse(httpResp)
	return resp, err
}

// createRunCreateRequest creates the CreateRun request.
func (client *Client) createRunCreateRequest(ctx context.Context, threadID string, body CreateRunBody, options *CreateRunOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/{threadId}/runs")
	if threadID == "" {
		return nil, errors.New("parameter threadID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{threadId}", url.PathEscape(threadID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// createRunHandleResponse handles the CreateRun response.
func (client *Client) createRunHandleResponse(resp *http.Response) (CreateRunResponse, error) {
	result := CreateRunResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ThreadRun); err != nil {
		return CreateRunResponse{}, err
	}
	return result, nil
}

// CreateThread - Creates a new thread. Threads contain messages and can be run by assistants.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - options - CreateThreadOptions contains the optional parameters for the Client.CreateThread method.
func (client *Client) CreateThread(ctx context.Context, body AssistantThreadCreationOptions, options *CreateThreadOptions) (CreateThreadResponse, error) {
	var err error
	req, err := client.createThreadCreateRequest(ctx, body, options)
	if err != nil {
		return CreateThreadResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CreateThreadResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return CreateThreadResponse{}, err
	}
	resp, err := client.createThreadHandleResponse(httpResp)
	return resp, err
}

// createThreadCreateRequest creates the CreateThread request.
func (client *Client) createThreadCreateRequest(ctx context.Context, body AssistantThreadCreationOptions, options *CreateThreadOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads")
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// createThreadHandleResponse handles the CreateThread response.
func (client *Client) createThreadHandleResponse(resp *http.Response) (CreateThreadResponse, error) {
	result := CreateThreadResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AssistantThread); err != nil {
		return CreateThreadResponse{}, err
	}
	return result, nil
}

// CreateThreadAndRun - Creates a new assistant thread and immediately starts a run using that new thread.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - options - CreateThreadAndRunOptions contains the optional parameters for the Client.CreateThreadAndRun method.
func (client *Client) CreateThreadAndRun(ctx context.Context, body CreateAndRunThreadOptions, options *CreateThreadAndRunOptions) (CreateThreadAndRunResponse, error) {
	var err error
	req, err := client.createThreadAndRunCreateRequest(ctx, body, options)
	if err != nil {
		return CreateThreadAndRunResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CreateThreadAndRunResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return CreateThreadAndRunResponse{}, err
	}
	resp, err := client.createThreadAndRunHandleResponse(httpResp)
	return resp, err
}

// createThreadAndRunCreateRequest creates the CreateThreadAndRun request.
func (client *Client) createThreadAndRunCreateRequest(ctx context.Context, body CreateAndRunThreadOptions, options *CreateThreadAndRunOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/runs")
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// createThreadAndRunHandleResponse handles the CreateThreadAndRun response.
func (client *Client) createThreadAndRunHandleResponse(resp *http.Response) (CreateThreadAndRunResponse, error) {
	result := CreateThreadAndRunResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ThreadRun); err != nil {
		return CreateThreadAndRunResponse{}, err
	}
	return result, nil
}

// DeleteAssistant - Deletes an assistant.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - assistantID - The ID of the assistant to delete.
//   - options - DeleteAssistantOptions contains the optional parameters for the Client.DeleteAssistant method.
func (client *Client) DeleteAssistant(ctx context.Context, assistantID string, options *DeleteAssistantOptions) (DeleteAssistantResponse, error) {
	var err error
	req, err := client.deleteAssistantCreateRequest(ctx, assistantID, options)
	if err != nil {
		return DeleteAssistantResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DeleteAssistantResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DeleteAssistantResponse{}, err
	}
	resp, err := client.deleteAssistantHandleResponse(httpResp)
	return resp, err
}

// deleteAssistantCreateRequest creates the DeleteAssistant request.
func (client *Client) deleteAssistantCreateRequest(ctx context.Context, assistantID string, options *DeleteAssistantOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/assistants/{assistantId}")
	if assistantID == "" {
		return nil, errors.New("parameter assistantID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{assistantId}", url.PathEscape(assistantID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteAssistantHandleResponse handles the DeleteAssistant response.
func (client *Client) deleteAssistantHandleResponse(resp *http.Response) (DeleteAssistantResponse, error) {
	result := DeleteAssistantResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AssistantDeletionStatus); err != nil {
		return DeleteAssistantResponse{}, err
	}
	return result, nil
}

// DeleteAssistantFile - Unlinks a previously attached file from an assistant, rendering it unavailable for use by tools that
// can read files.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - assistantID - The ID of the assistant from which the specified file should be unlinked.
//   - fileID - The ID of the file to unlink from the specified assistant.
//   - options - DeleteAssistantFileOptions contains the optional parameters for the Client.DeleteAssistantFile method.
func (client *Client) DeleteAssistantFile(ctx context.Context, assistantID string, fileID string, options *DeleteAssistantFileOptions) (DeleteAssistantFileResponse, error) {
	var err error
	req, err := client.deleteAssistantFileCreateRequest(ctx, assistantID, fileID, options)
	if err != nil {
		return DeleteAssistantFileResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DeleteAssistantFileResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DeleteAssistantFileResponse{}, err
	}
	resp, err := client.deleteAssistantFileHandleResponse(httpResp)
	return resp, err
}

// deleteAssistantFileCreateRequest creates the DeleteAssistantFile request.
func (client *Client) deleteAssistantFileCreateRequest(ctx context.Context, assistantID string, fileID string, options *DeleteAssistantFileOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/assistants/{assistantId}/files/{fileId}")
	if assistantID == "" {
		return nil, errors.New("parameter assistantID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{assistantId}", url.PathEscape(assistantID))
	if fileID == "" {
		return nil, errors.New("parameter fileID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileId}", url.PathEscape(fileID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteAssistantFileHandleResponse handles the DeleteAssistantFile response.
func (client *Client) deleteAssistantFileHandleResponse(resp *http.Response) (DeleteAssistantFileResponse, error) {
	result := DeleteAssistantFileResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AssistantFileDeletionStatus); err != nil {
		return DeleteAssistantFileResponse{}, err
	}
	return result, nil
}

// DeleteFile - Delete a previously uploaded file.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - fileID - The ID of the file to delete.
//   - options - DeleteFileOptions contains the optional parameters for the Client.DeleteFile method.
func (client *Client) DeleteFile(ctx context.Context, fileID string, options *DeleteFileOptions) (DeleteFileResponse, error) {
	var err error
	req, err := client.deleteFileCreateRequest(ctx, fileID, options)
	if err != nil {
		return DeleteFileResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DeleteFileResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DeleteFileResponse{}, err
	}
	resp, err := client.deleteFileHandleResponse(httpResp)
	return resp, err
}

// deleteFileCreateRequest creates the DeleteFile request.
func (client *Client) deleteFileCreateRequest(ctx context.Context, fileID string, options *DeleteFileOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/files/{fileId}")
	if fileID == "" {
		return nil, errors.New("parameter fileID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileId}", url.PathEscape(fileID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteFileHandleResponse handles the DeleteFile response.
func (client *Client) deleteFileHandleResponse(resp *http.Response) (DeleteFileResponse, error) {
	result := DeleteFileResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FileDeletionStatus); err != nil {
		return DeleteFileResponse{}, err
	}
	return result, nil
}

// DeleteThread - Deletes an existing thread.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - threadID - The ID of the thread to delete.
//   - options - DeleteThreadOptions contains the optional parameters for the Client.DeleteThread method.
func (client *Client) DeleteThread(ctx context.Context, threadID string, options *DeleteThreadOptions) (DeleteThreadResponse, error) {
	var err error
	req, err := client.deleteThreadCreateRequest(ctx, threadID, options)
	if err != nil {
		return DeleteThreadResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DeleteThreadResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DeleteThreadResponse{}, err
	}
	resp, err := client.deleteThreadHandleResponse(httpResp)
	return resp, err
}

// deleteThreadCreateRequest creates the DeleteThread request.
func (client *Client) deleteThreadCreateRequest(ctx context.Context, threadID string, options *DeleteThreadOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/{threadId}")
	if threadID == "" {
		return nil, errors.New("parameter threadID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{threadId}", url.PathEscape(threadID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteThreadHandleResponse handles the DeleteThread response.
func (client *Client) deleteThreadHandleResponse(resp *http.Response) (DeleteThreadResponse, error) {
	result := DeleteThreadResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ThreadDeletionStatus); err != nil {
		return DeleteThreadResponse{}, err
	}
	return result, nil
}

// GetAssistant - Retrieves an existing assistant.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - assistantID - The ID of the assistant to retrieve.
//   - options - GetAssistantOptions contains the optional parameters for the Client.GetAssistant method.
func (client *Client) GetAssistant(ctx context.Context, assistantID string, options *GetAssistantOptions) (GetAssistantResponse, error) {
	var err error
	req, err := client.getAssistantCreateRequest(ctx, assistantID, options)
	if err != nil {
		return GetAssistantResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetAssistantResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetAssistantResponse{}, err
	}
	resp, err := client.getAssistantHandleResponse(httpResp)
	return resp, err
}

// getAssistantCreateRequest creates the GetAssistant request.
func (client *Client) getAssistantCreateRequest(ctx context.Context, assistantID string, options *GetAssistantOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/assistants/{assistantId}")
	if assistantID == "" {
		return nil, errors.New("parameter assistantID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{assistantId}", url.PathEscape(assistantID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAssistantHandleResponse handles the GetAssistant response.
func (client *Client) getAssistantHandleResponse(resp *http.Response) (GetAssistantResponse, error) {
	result := GetAssistantResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Assistant); err != nil {
		return GetAssistantResponse{}, err
	}
	return result, nil
}

// GetAssistantFile - Retrieves a file attached to an assistant.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - assistantID - The ID of the assistant associated with the attached file.
//   - fileID - The ID of the file to retrieve.
//   - options - GetAssistantFileOptions contains the optional parameters for the Client.GetAssistantFile method.
func (client *Client) GetAssistantFile(ctx context.Context, assistantID string, fileID string, options *GetAssistantFileOptions) (GetAssistantFileResponse, error) {
	var err error
	req, err := client.getAssistantFileCreateRequest(ctx, assistantID, fileID, options)
	if err != nil {
		return GetAssistantFileResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetAssistantFileResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetAssistantFileResponse{}, err
	}
	resp, err := client.getAssistantFileHandleResponse(httpResp)
	return resp, err
}

// getAssistantFileCreateRequest creates the GetAssistantFile request.
func (client *Client) getAssistantFileCreateRequest(ctx context.Context, assistantID string, fileID string, options *GetAssistantFileOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/assistants/{assistantId}/files/{fileId}")
	if assistantID == "" {
		return nil, errors.New("parameter assistantID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{assistantId}", url.PathEscape(assistantID))
	if fileID == "" {
		return nil, errors.New("parameter fileID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileId}", url.PathEscape(fileID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAssistantFileHandleResponse handles the GetAssistantFile response.
func (client *Client) getAssistantFileHandleResponse(resp *http.Response) (GetAssistantFileResponse, error) {
	result := GetAssistantFileResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AssistantFile); err != nil {
		return GetAssistantFileResponse{}, err
	}
	return result, nil
}

// GetFile - Returns information about a specific file. Does not retrieve file content.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - fileID - The ID of the file to retrieve.
//   - options - GetFileOptions contains the optional parameters for the Client.GetFile method.
func (client *Client) GetFile(ctx context.Context, fileID string, options *GetFileOptions) (GetFileResponse, error) {
	var err error
	req, err := client.getFileCreateRequest(ctx, fileID, options)
	if err != nil {
		return GetFileResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetFileResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetFileResponse{}, err
	}
	resp, err := client.getFileHandleResponse(httpResp)
	return resp, err
}

// getFileCreateRequest creates the GetFile request.
func (client *Client) getFileCreateRequest(ctx context.Context, fileID string, options *GetFileOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/files/{fileId}")
	if fileID == "" {
		return nil, errors.New("parameter fileID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileId}", url.PathEscape(fileID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getFileHandleResponse handles the GetFile response.
func (client *Client) getFileHandleResponse(resp *http.Response) (GetFileResponse, error) {
	result := GetFileResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OpenAIFile); err != nil {
		return GetFileResponse{}, err
	}
	return result, nil
}

// GetMessage - Gets an existing message from an existing thread.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - threadID - The ID of the thread to retrieve the specified message from.
//   - messageID - The ID of the message to retrieve from the specified thread.
//   - options - GetMessageOptions contains the optional parameters for the Client.GetMessage method.
func (client *Client) GetMessage(ctx context.Context, threadID string, messageID string, options *GetMessageOptions) (GetMessageResponse, error) {
	var err error
	req, err := client.getMessageCreateRequest(ctx, threadID, messageID, options)
	if err != nil {
		return GetMessageResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetMessageResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetMessageResponse{}, err
	}
	resp, err := client.getMessageHandleResponse(httpResp)
	return resp, err
}

// getMessageCreateRequest creates the GetMessage request.
func (client *Client) getMessageCreateRequest(ctx context.Context, threadID string, messageID string, options *GetMessageOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/{threadId}/messages/{messageId}")
	if threadID == "" {
		return nil, errors.New("parameter threadID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{threadId}", url.PathEscape(threadID))
	if messageID == "" {
		return nil, errors.New("parameter messageID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{messageId}", url.PathEscape(messageID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getMessageHandleResponse handles the GetMessage response.
func (client *Client) getMessageHandleResponse(resp *http.Response) (GetMessageResponse, error) {
	result := GetMessageResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ThreadMessage); err != nil {
		return GetMessageResponse{}, err
	}
	return result, nil
}

// GetMessageFile - Gets information about a file attachment to a message within a thread.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - threadID - The ID of the thread containing the message to get information from.
//   - messageID - The ID of the message to get information from.
//   - fileID - The ID of the file to get information about.
//   - options - GetMessageFileOptions contains the optional parameters for the Client.GetMessageFile method.
func (client *Client) GetMessageFile(ctx context.Context, threadID string, messageID string, fileID string, options *GetMessageFileOptions) (GetMessageFileResponse, error) {
	var err error
	req, err := client.getMessageFileCreateRequest(ctx, threadID, messageID, fileID, options)
	if err != nil {
		return GetMessageFileResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetMessageFileResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetMessageFileResponse{}, err
	}
	resp, err := client.getMessageFileHandleResponse(httpResp)
	return resp, err
}

// getMessageFileCreateRequest creates the GetMessageFile request.
func (client *Client) getMessageFileCreateRequest(ctx context.Context, threadID string, messageID string, fileID string, options *GetMessageFileOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/{threadId}/messages/{messageId}/files/{fileId}")
	if threadID == "" {
		return nil, errors.New("parameter threadID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{threadId}", url.PathEscape(threadID))
	if messageID == "" {
		return nil, errors.New("parameter messageID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{messageId}", url.PathEscape(messageID))
	if fileID == "" {
		return nil, errors.New("parameter fileID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileId}", url.PathEscape(fileID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getMessageFileHandleResponse handles the GetMessageFile response.
func (client *Client) getMessageFileHandleResponse(resp *http.Response) (GetMessageFileResponse, error) {
	result := GetMessageFileResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MessageFile); err != nil {
		return GetMessageFileResponse{}, err
	}
	return result, nil
}

// GetRun - Gets an existing run from an existing thread.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - threadID - The ID of the thread to retrieve run information from.
//   - runID - The ID of the thread to retrieve information about.
//   - options - GetRunOptions contains the optional parameters for the Client.GetRun method.
func (client *Client) GetRun(ctx context.Context, threadID string, runID string, options *GetRunOptions) (GetRunResponse, error) {
	var err error
	req, err := client.getRunCreateRequest(ctx, threadID, runID, options)
	if err != nil {
		return GetRunResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetRunResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetRunResponse{}, err
	}
	resp, err := client.getRunHandleResponse(httpResp)
	return resp, err
}

// getRunCreateRequest creates the GetRun request.
func (client *Client) getRunCreateRequest(ctx context.Context, threadID string, runID string, options *GetRunOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/{threadId}/runs/{runId}")
	if threadID == "" {
		return nil, errors.New("parameter threadID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{threadId}", url.PathEscape(threadID))
	if runID == "" {
		return nil, errors.New("parameter runID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{runId}", url.PathEscape(runID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getRunHandleResponse handles the GetRun response.
func (client *Client) getRunHandleResponse(resp *http.Response) (GetRunResponse, error) {
	result := GetRunResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ThreadRun); err != nil {
		return GetRunResponse{}, err
	}
	return result, nil
}

// GetRunStep - Gets a single run step from a thread run.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - threadID - The ID of the thread that was run.
//   - runID - The ID of the specific run to retrieve the step from.
//   - stepID - The ID of the step to retrieve information about.
//   - options - GetRunStepOptions contains the optional parameters for the Client.GetRunStep method.
func (client *Client) GetRunStep(ctx context.Context, threadID string, runID string, stepID string, options *GetRunStepOptions) (GetRunStepResponse, error) {
	var err error
	req, err := client.getRunStepCreateRequest(ctx, threadID, runID, stepID, options)
	if err != nil {
		return GetRunStepResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetRunStepResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetRunStepResponse{}, err
	}
	resp, err := client.getRunStepHandleResponse(httpResp)
	return resp, err
}

// getRunStepCreateRequest creates the GetRunStep request.
func (client *Client) getRunStepCreateRequest(ctx context.Context, threadID string, runID string, stepID string, options *GetRunStepOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/{threadId}/runs/{runId}/steps/{stepId}")
	if threadID == "" {
		return nil, errors.New("parameter threadID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{threadId}", url.PathEscape(threadID))
	if runID == "" {
		return nil, errors.New("parameter runID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{runId}", url.PathEscape(runID))
	if stepID == "" {
		return nil, errors.New("parameter stepID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{stepId}", url.PathEscape(stepID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getRunStepHandleResponse handles the GetRunStep response.
func (client *Client) getRunStepHandleResponse(resp *http.Response) (GetRunStepResponse, error) {
	result := GetRunStepResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RunStep); err != nil {
		return GetRunStepResponse{}, err
	}
	return result, nil
}

// GetThread - Gets information about an existing thread.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - threadID - The ID of the thread to retrieve information about.
//   - options - GetThreadOptions contains the optional parameters for the Client.GetThread method.
func (client *Client) GetThread(ctx context.Context, threadID string, options *GetThreadOptions) (GetThreadResponse, error) {
	var err error
	req, err := client.getThreadCreateRequest(ctx, threadID, options)
	if err != nil {
		return GetThreadResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetThreadResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetThreadResponse{}, err
	}
	resp, err := client.getThreadHandleResponse(httpResp)
	return resp, err
}

// getThreadCreateRequest creates the GetThread request.
func (client *Client) getThreadCreateRequest(ctx context.Context, threadID string, options *GetThreadOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/{threadId}")
	if threadID == "" {
		return nil, errors.New("parameter threadID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{threadId}", url.PathEscape(threadID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getThreadHandleResponse handles the GetThread response.
func (client *Client) getThreadHandleResponse(resp *http.Response) (GetThreadResponse, error) {
	result := GetThreadResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AssistantThread); err != nil {
		return GetThreadResponse{}, err
	}
	return result, nil
}

// ListAssistantFiles - Gets a list of files attached to a specific assistant, as used by tools that can read files.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - assistantID - The ID of the assistant to retrieve the list of attached files for.
//   - options - ListAssistantFilesOptions contains the optional parameters for the Client.ListAssistantFiles method.
func (client *Client) internalListAssistantFiles(ctx context.Context, assistantID string, options *ListAssistantFilesOptions) (ListAssistantFilesResponse, error) {
	var err error
	req, err := client.listAssistantFilesCreateRequest(ctx, assistantID, options)
	if err != nil {
		return ListAssistantFilesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ListAssistantFilesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ListAssistantFilesResponse{}, err
	}
	resp, err := client.listAssistantFilesHandleResponse(httpResp)
	return resp, err
}

// listAssistantFilesCreateRequest creates the ListAssistantFiles request.
func (client *Client) listAssistantFilesCreateRequest(ctx context.Context, assistantID string, options *ListAssistantFilesOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/assistants/{assistantId}/files")
	if assistantID == "" {
		return nil, errors.New("parameter assistantID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{assistantId}", url.PathEscape(assistantID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.After != nil {
		reqQP.Set("after", *options.After)
	}
	if options != nil && options.Before != nil {
		reqQP.Set("before", *options.Before)
	}
	if options != nil && options.Limit != nil {
		reqQP.Set("limit", strconv.FormatInt(int64(*options.Limit), 10))
	}
	if options != nil && options.Order != nil {
		reqQP.Set("order", string(*options.Order))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAssistantFilesHandleResponse handles the ListAssistantFiles response.
func (client *Client) listAssistantFilesHandleResponse(resp *http.Response) (ListAssistantFilesResponse, error) {
	result := ListAssistantFilesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AssistantFilesPage); err != nil {
		return ListAssistantFilesResponse{}, err
	}
	return result, nil
}

// ListAssistants - Gets a list of assistants that were previously created.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - options - ListAssistantsOptions contains the optional parameters for the Client.ListAssistants method.
func (client *Client) internalListAssistants(ctx context.Context, options *ListAssistantsOptions) (ListAssistantsResponse, error) {
	var err error
	req, err := client.listAssistantsCreateRequest(ctx, options)
	if err != nil {
		return ListAssistantsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ListAssistantsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ListAssistantsResponse{}, err
	}
	resp, err := client.listAssistantsHandleResponse(httpResp)
	return resp, err
}

// listAssistantsCreateRequest creates the ListAssistants request.
func (client *Client) listAssistantsCreateRequest(ctx context.Context, options *ListAssistantsOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/assistants")
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.After != nil {
		reqQP.Set("after", *options.After)
	}
	if options != nil && options.Before != nil {
		reqQP.Set("before", *options.Before)
	}
	if options != nil && options.Limit != nil {
		reqQP.Set("limit", strconv.FormatInt(int64(*options.Limit), 10))
	}
	if options != nil && options.Order != nil {
		reqQP.Set("order", string(*options.Order))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAssistantsHandleResponse handles the ListAssistants response.
func (client *Client) listAssistantsHandleResponse(resp *http.Response) (ListAssistantsResponse, error) {
	result := ListAssistantsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AssistantsPage); err != nil {
		return ListAssistantsResponse{}, err
	}
	return result, nil
}

// ListFiles - Gets a list of previously uploaded files.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - options - ListFilesOptions contains the optional parameters for the Client.ListFiles method.
func (client *Client) ListFiles(ctx context.Context, options *ListFilesOptions) (ListFilesResponse, error) {
	var err error
	req, err := client.listFilesCreateRequest(ctx, options)
	if err != nil {
		return ListFilesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ListFilesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ListFilesResponse{}, err
	}
	resp, err := client.listFilesHandleResponse(httpResp)
	return resp, err
}

// listFilesCreateRequest creates the ListFiles request.
func (client *Client) listFilesCreateRequest(ctx context.Context, options *ListFilesOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/files")
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Purpose != nil {
		reqQP.Set("purpose", string(*options.Purpose))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listFilesHandleResponse handles the ListFiles response.
func (client *Client) listFilesHandleResponse(resp *http.Response) (ListFilesResponse, error) {
	result := ListFilesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FileListResponse); err != nil {
		return ListFilesResponse{}, err
	}
	return result, nil
}

// ListMessageFiles - Gets a list of previously uploaded files associated with a message from a thread.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - threadID - The ID of the thread containing the message to list files from.
//   - messageID - The ID of the message to list files from.
//   - options - ListMessageFilesOptions contains the optional parameters for the Client.ListMessageFiles method.
func (client *Client) internalListMessageFiles(ctx context.Context, threadID string, messageID string, options *ListMessageFilesOptions) (ListMessageFilesResponse, error) {
	var err error
	req, err := client.listMessageFilesCreateRequest(ctx, threadID, messageID, options)
	if err != nil {
		return ListMessageFilesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ListMessageFilesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ListMessageFilesResponse{}, err
	}
	resp, err := client.listMessageFilesHandleResponse(httpResp)
	return resp, err
}

// listMessageFilesCreateRequest creates the ListMessageFiles request.
func (client *Client) listMessageFilesCreateRequest(ctx context.Context, threadID string, messageID string, options *ListMessageFilesOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/{threadId}/messages/{messageId}/files")
	if threadID == "" {
		return nil, errors.New("parameter threadID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{threadId}", url.PathEscape(threadID))
	if messageID == "" {
		return nil, errors.New("parameter messageID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{messageId}", url.PathEscape(messageID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.After != nil {
		reqQP.Set("after", *options.After)
	}
	if options != nil && options.Before != nil {
		reqQP.Set("before", *options.Before)
	}
	if options != nil && options.Limit != nil {
		reqQP.Set("limit", strconv.FormatInt(int64(*options.Limit), 10))
	}
	if options != nil && options.Order != nil {
		reqQP.Set("order", string(*options.Order))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMessageFilesHandleResponse handles the ListMessageFiles response.
func (client *Client) listMessageFilesHandleResponse(resp *http.Response) (ListMessageFilesResponse, error) {
	result := ListMessageFilesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MessageFilesPage); err != nil {
		return ListMessageFilesResponse{}, err
	}
	return result, nil
}

// ListMessages - Gets a list of messages that exist on a thread.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - threadID - The ID of the thread to list messages from.
//   - options - ListMessagesOptions contains the optional parameters for the Client.ListMessages method.
func (client *Client) internalListMessages(ctx context.Context, threadID string, options *ListMessagesOptions) (ListMessagesResponse, error) {
	var err error
	req, err := client.listMessagesCreateRequest(ctx, threadID, options)
	if err != nil {
		return ListMessagesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ListMessagesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ListMessagesResponse{}, err
	}
	resp, err := client.listMessagesHandleResponse(httpResp)
	return resp, err
}

// listMessagesCreateRequest creates the ListMessages request.
func (client *Client) listMessagesCreateRequest(ctx context.Context, threadID string, options *ListMessagesOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/{threadId}/messages")
	if threadID == "" {
		return nil, errors.New("parameter threadID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{threadId}", url.PathEscape(threadID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.After != nil {
		reqQP.Set("after", *options.After)
	}
	if options != nil && options.Before != nil {
		reqQP.Set("before", *options.Before)
	}
	if options != nil && options.Limit != nil {
		reqQP.Set("limit", strconv.FormatInt(int64(*options.Limit), 10))
	}
	if options != nil && options.Order != nil {
		reqQP.Set("order", string(*options.Order))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMessagesHandleResponse handles the ListMessages response.
func (client *Client) listMessagesHandleResponse(resp *http.Response) (ListMessagesResponse, error) {
	result := ListMessagesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MessagesPage); err != nil {
		return ListMessagesResponse{}, err
	}
	return result, nil
}

// ListRunSteps - Gets a list of run steps from a thread run.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - threadID - The ID of the thread that was run.
//   - runID - The ID of the run to list steps from.
//   - options - ListRunStepsOptions contains the optional parameters for the Client.ListRunSteps method.
func (client *Client) internalListRunSteps(ctx context.Context, threadID string, runID string, options *ListRunStepsOptions) (ListRunStepsResponse, error) {
	var err error
	req, err := client.listRunStepsCreateRequest(ctx, threadID, runID, options)
	if err != nil {
		return ListRunStepsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ListRunStepsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ListRunStepsResponse{}, err
	}
	resp, err := client.listRunStepsHandleResponse(httpResp)
	return resp, err
}

// listRunStepsCreateRequest creates the ListRunSteps request.
func (client *Client) listRunStepsCreateRequest(ctx context.Context, threadID string, runID string, options *ListRunStepsOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/{threadId}/runs/{runId}/steps")
	if threadID == "" {
		return nil, errors.New("parameter threadID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{threadId}", url.PathEscape(threadID))
	if runID == "" {
		return nil, errors.New("parameter runID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{runId}", url.PathEscape(runID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.After != nil {
		reqQP.Set("after", *options.After)
	}
	if options != nil && options.Before != nil {
		reqQP.Set("before", *options.Before)
	}
	if options != nil && options.Limit != nil {
		reqQP.Set("limit", strconv.FormatInt(int64(*options.Limit), 10))
	}
	if options != nil && options.Order != nil {
		reqQP.Set("order", string(*options.Order))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listRunStepsHandleResponse handles the ListRunSteps response.
func (client *Client) listRunStepsHandleResponse(resp *http.Response) (ListRunStepsResponse, error) {
	result := ListRunStepsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RunStepsPage); err != nil {
		return ListRunStepsResponse{}, err
	}
	return result, nil
}

// ListRuns - Gets a list of runs for a specified thread.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - threadID - The ID of the thread to list runs from.
//   - options - ListRunsOptions contains the optional parameters for the Client.ListRuns method.
func (client *Client) internalListRuns(ctx context.Context, threadID string, options *ListRunsOptions) (ListRunsResponse, error) {
	var err error
	req, err := client.listRunsCreateRequest(ctx, threadID, options)
	if err != nil {
		return ListRunsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ListRunsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ListRunsResponse{}, err
	}
	resp, err := client.listRunsHandleResponse(httpResp)
	return resp, err
}

// listRunsCreateRequest creates the ListRuns request.
func (client *Client) listRunsCreateRequest(ctx context.Context, threadID string, options *ListRunsOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/{threadId}/runs")
	if threadID == "" {
		return nil, errors.New("parameter threadID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{threadId}", url.PathEscape(threadID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.After != nil {
		reqQP.Set("after", *options.After)
	}
	if options != nil && options.Before != nil {
		reqQP.Set("before", *options.Before)
	}
	if options != nil && options.Limit != nil {
		reqQP.Set("limit", strconv.FormatInt(int64(*options.Limit), 10))
	}
	if options != nil && options.Order != nil {
		reqQP.Set("order", string(*options.Order))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listRunsHandleResponse handles the ListRuns response.
func (client *Client) listRunsHandleResponse(resp *http.Response) (ListRunsResponse, error) {
	result := ListRunsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ThreadRunsPage); err != nil {
		return ListRunsResponse{}, err
	}
	return result, nil
}

// SubmitToolOutputsToRun - Submits outputs from tools as requested by tool calls in a run. Runs that need submitted tool
// outputs will have a status of 'requiresaction' with a requiredaction.type of 'submittooloutputs'.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - threadID - The ID of the thread that was run.
//   - runID - The ID of the run that requires tool outputs.
//   - options - SubmitToolOutputsToRunOptions contains the optional parameters for the Client.SubmitToolOutputsToRun method.
func (client *Client) SubmitToolOutputsToRun(ctx context.Context, threadID string, runID string, body SubmitToolOutputsToRunBody, options *SubmitToolOutputsToRunOptions) (SubmitToolOutputsToRunResponse, error) {
	var err error
	req, err := client.submitToolOutputsToRunCreateRequest(ctx, threadID, runID, body, options)
	if err != nil {
		return SubmitToolOutputsToRunResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SubmitToolOutputsToRunResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SubmitToolOutputsToRunResponse{}, err
	}
	resp, err := client.submitToolOutputsToRunHandleResponse(httpResp)
	return resp, err
}

// submitToolOutputsToRunCreateRequest creates the SubmitToolOutputsToRun request.
func (client *Client) submitToolOutputsToRunCreateRequest(ctx context.Context, threadID string, runID string, body SubmitToolOutputsToRunBody, options *SubmitToolOutputsToRunOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/{threadId}/runs/{runId}/submit_tool_outputs")
	if threadID == "" {
		return nil, errors.New("parameter threadID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{threadId}", url.PathEscape(threadID))
	if runID == "" {
		return nil, errors.New("parameter runID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{runId}", url.PathEscape(runID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// submitToolOutputsToRunHandleResponse handles the SubmitToolOutputsToRun response.
func (client *Client) submitToolOutputsToRunHandleResponse(resp *http.Response) (SubmitToolOutputsToRunResponse, error) {
	result := SubmitToolOutputsToRunResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ThreadRun); err != nil {
		return SubmitToolOutputsToRunResponse{}, err
	}
	return result, nil
}

// UpdateAssistant - Modifies an existing assistant.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - assistantID - The ID of the assistant to modify.
//   - options - UpdateAssistantOptions contains the optional parameters for the Client.UpdateAssistant method.
func (client *Client) UpdateAssistant(ctx context.Context, assistantID string, body UpdateAssistantOptions, options *UpdateAssistantOptions) (UpdateAssistantResponse, error) {
	var err error
	req, err := client.updateAssistantCreateRequest(ctx, assistantID, body, options)
	if err != nil {
		return UpdateAssistantResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return UpdateAssistantResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return UpdateAssistantResponse{}, err
	}
	resp, err := client.updateAssistantHandleResponse(httpResp)
	return resp, err
}

// updateAssistantCreateRequest creates the UpdateAssistant request.
func (client *Client) updateAssistantCreateRequest(ctx context.Context, assistantID string, body UpdateAssistantOptions, options *UpdateAssistantOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/assistants/{assistantId}")
	if assistantID == "" {
		return nil, errors.New("parameter assistantID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{assistantId}", url.PathEscape(assistantID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// updateAssistantHandleResponse handles the UpdateAssistant response.
func (client *Client) updateAssistantHandleResponse(resp *http.Response) (UpdateAssistantResponse, error) {
	result := UpdateAssistantResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Assistant); err != nil {
		return UpdateAssistantResponse{}, err
	}
	return result, nil
}

// UpdateMessage - Modifies an existing message on an existing thread.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - threadID - The ID of the thread containing the specified message to modify.
//   - messageID - The ID of the message to modify on the specified thread.
//   - options - UpdateMessageOptions contains the optional parameters for the Client.UpdateMessage method.
func (client *Client) UpdateMessage(ctx context.Context, threadID string, messageID string, body UpdateMessageBody, options *UpdateMessageOptions) (UpdateMessageResponse, error) {
	var err error
	req, err := client.updateMessageCreateRequest(ctx, threadID, messageID, body, options)
	if err != nil {
		return UpdateMessageResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return UpdateMessageResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return UpdateMessageResponse{}, err
	}
	resp, err := client.updateMessageHandleResponse(httpResp)
	return resp, err
}

// updateMessageCreateRequest creates the UpdateMessage request.
func (client *Client) updateMessageCreateRequest(ctx context.Context, threadID string, messageID string, body UpdateMessageBody, options *UpdateMessageOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/{threadId}/messages/{messageId}")
	if threadID == "" {
		return nil, errors.New("parameter threadID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{threadId}", url.PathEscape(threadID))
	if messageID == "" {
		return nil, errors.New("parameter messageID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{messageId}", url.PathEscape(messageID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// updateMessageHandleResponse handles the UpdateMessage response.
func (client *Client) updateMessageHandleResponse(resp *http.Response) (UpdateMessageResponse, error) {
	result := UpdateMessageResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ThreadMessage); err != nil {
		return UpdateMessageResponse{}, err
	}
	return result, nil
}

// UpdateRun - Modifies an existing thread run.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - threadID - The ID of the thread associated with the specified run.
//   - runID - The ID of the run to modify.
//   - options - UpdateRunOptions contains the optional parameters for the Client.UpdateRun method.
func (client *Client) UpdateRun(ctx context.Context, threadID string, runID string, body UpdateRunBody, options *UpdateRunOptions) (UpdateRunResponse, error) {
	var err error
	req, err := client.updateRunCreateRequest(ctx, threadID, runID, body, options)
	if err != nil {
		return UpdateRunResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return UpdateRunResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return UpdateRunResponse{}, err
	}
	resp, err := client.updateRunHandleResponse(httpResp)
	return resp, err
}

// updateRunCreateRequest creates the UpdateRun request.
func (client *Client) updateRunCreateRequest(ctx context.Context, threadID string, runID string, body UpdateRunBody, options *UpdateRunOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/{threadId}/runs/{runId}")
	if threadID == "" {
		return nil, errors.New("parameter threadID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{threadId}", url.PathEscape(threadID))
	if runID == "" {
		return nil, errors.New("parameter runID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{runId}", url.PathEscape(runID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// updateRunHandleResponse handles the UpdateRun response.
func (client *Client) updateRunHandleResponse(resp *http.Response) (UpdateRunResponse, error) {
	result := UpdateRunResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ThreadRun); err != nil {
		return UpdateRunResponse{}, err
	}
	return result, nil
}

// UpdateThread - Modifies an existing thread.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - threadID - The ID of the thread to modify.
//   - options - UpdateThreadOptions contains the optional parameters for the Client.UpdateThread method.
func (client *Client) UpdateThread(ctx context.Context, threadID string, body UpdateThreadBody, options *UpdateThreadOptions) (UpdateThreadResponse, error) {
	var err error
	req, err := client.updateThreadCreateRequest(ctx, threadID, body, options)
	if err != nil {
		return UpdateThreadResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return UpdateThreadResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return UpdateThreadResponse{}, err
	}
	resp, err := client.updateThreadHandleResponse(httpResp)
	return resp, err
}

// updateThreadCreateRequest creates the UpdateThread request.
func (client *Client) updateThreadCreateRequest(ctx context.Context, threadID string, body UpdateThreadBody, options *UpdateThreadOptions) (*policy.Request, error) {
	urlPath := client.formatURL("/threads/{threadId}")
	if threadID == "" {
		return nil, errors.New("parameter threadID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{threadId}", url.PathEscape(threadID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// updateThreadHandleResponse handles the UpdateThread response.
func (client *Client) updateThreadHandleResponse(resp *http.Response) (UpdateThreadResponse, error) {
	result := UpdateThreadResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AssistantThread); err != nil {
		return UpdateThreadResponse{}, err
	}
	return result, nil
}

// UploadFile - Uploads a file for use by other operations.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-15-preview
//   - file - The file data (not filename) to upload.
//   - purpose - The intended purpose of the file.
//   - options - UploadFileOptions contains the optional parameters for the Client.UploadFile method.
func (client *Client) UploadFile(ctx context.Context, file io.ReadSeeker, purpose FilePurpose, options *UploadFileOptions) (UploadFileResponse, error) {
	var err error
	req, err := client.uploadFileCreateRequest(ctx, file, purpose, options)
	if err != nil {
		return UploadFileResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return UploadFileResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return UploadFileResponse{}, err
	}
	resp, err := client.uploadFileHandleResponse(httpResp)
	return resp, err
}

// uploadFileHandleResponse handles the UploadFile response.
func (client *Client) uploadFileHandleResponse(resp *http.Response) (UploadFileResponse, error) {
	result := UploadFileResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OpenAIFile); err != nil {
		return UploadFileResponse{}, err
	}
	return result, nil
}
