package main

import "bytes"

var (
	frontmatterOpen  = []byte("---")
	frontmatterClose = []byte("\n---")
	lf               = []byte("\n")
	crlf             = []byte("\r\n")
)

func extractFrontmatter(b []byte) (frontmatter, content []byte) {
	if !bytes.HasPrefix(b, frontmatterOpen) {
		return nil, b
	}
	next := b[len(frontmatterOpen):]
	if len(next) > 0 && !bytes.HasPrefix(next, lf) && !bytes.HasPrefix(next, crlf) {
		return nil, b
	}
	b = next
	i := bytes.Index(b, frontmatterClose)
	if i == -1 {
		return b, nil
	}
	return b[:i], b[i+len(frontmatterClose):]
}
