/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (sort-opts.h)
 *
 *  It has been AutoGen-ed
 *  From the definitions    sort-opts.def
 *  and the template file   options
 *
 * Generated from AutoOpts 42:2:17 templates.
 *
 *  AutoOpts is a copyrighted work.  This header file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the sort-pw-cfg author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 */
/**
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the sort-pw-cfg program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_SORT_OPTS_H_GUARD
#define AUTOOPTS_SORT_OPTS_H_GUARD 1
#include "config.h"
#include <autoopts/options.h>
#include <stdarg.h>
#include <stdnoreturn.h>

/**
 *  Ensure that the library used for compiling this generated header is at
 *  least as new as the version current when the header template was released
 *  (not counting patch version increments).  Also ensure that the oldest
 *  tolerable version is at least as old as what was current when the header
 *  template was released.
 */
#define AO_TEMPLATE_VERSION 172034
#if (AO_TEMPLATE_VERSION < OPTIONS_MINIMUM_VERSION) \
 || (AO_TEMPLATE_VERSION > OPTIONS_STRUCT_VERSION)
# error option template version mismatches autoopts/options.h header
  Choke Me.
#endif

#if GCC_VERSION > 40400
#define NOT_REACHED __builtin_unreachable();
#else
#define NOT_REACHED
#endif

/**
 *  Enumeration of each option type for sort-pw-cfg
 */
typedef enum {
    INDEX_OPT_OUTPUT      =  0,
    INDEX_OPT_DEFAULT     =  1,
    INDEX_OPT_VERSION     =  2,
    INDEX_OPT_HELP        =  3,
    INDEX_OPT_MORE_HELP   =  4
} teOptIndex;
/** count of all options for sort-pw-cfg */
#define OPTION_CT    5
/** sort-pw-cfg version */
#define SORT_PW_CFG_VERSION       "2.7.3"
/** Full sort-pw-cfg version text */
#define SORT_PW_CFG_FULL_VERSION  "sort-pw-cfg 2.7.3"

/**
 *  Interface defines for all options.  Replace "n" with the UPPER_CASED
 *  option name (as in the teOptIndex enumeration above).
 *  e.g. HAVE_OPT(OUTPUT)
 */
#define         DESC(n) (sort_pw_cfgOptions.pOptDesc[INDEX_OPT_## n])
/** 'true' if an option has been specified in any way */
#define     HAVE_OPT(n) (! UNUSED_OPT(& DESC(n)))
/** The string argument to an option. The argument type must be \"string\". */
#define      OPT_ARG(n) (DESC(n).optArg.argString)
/** Mask the option state revealing how an option was specified.
 *  It will be one and only one of \a OPTST_SET, \a OPTST_PRESET,
 * \a OPTST_DEFINED, \a OPTST_RESET or zero.
 */
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
/** Count of option's occurrances *on the command line*. */
#define    COUNT_OPT(n) (DESC(n).optOccCt)
/** mask of \a OPTST_SET and \a OPTST_DEFINED. */
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
/** 'true' if \a HAVE_OPT would yield 'false'. */
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
/** 'true' if OPTST_DISABLED bit not set. */
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
/** number of stacked option arguments.
 *  Valid only for stacked option arguments. */
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
/** stacked argument vector.
 *  Valid only for stacked option arguments. */
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
/** Reset an option. */
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT_MASK;   \
                if ((DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 *  Enumeration of sort-pw-cfg exit codes
 */
typedef enum {
    SORT_PW_CFG_EXIT_SUCCESS          = 0,
    SORT_PW_CFG_EXIT_INVALID          = 1,
    SORT_PW_CFG_EXIT_NO_MEM           = 2,
    SORT_PW_CFG_EXIT_BAD_USER         = 3,
    SORT_PW_CFG_EXIT_HOMELESS         = 4,
    SORT_PW_CFG_EXIT_PERM             = 5,
    SORT_PW_CFG_EXIT_NO_CONFIG        = 6,
    SORT_PW_CFG_EXIT_BAD_CONFIG       = 7,
    SORT_PW_CFG_EXIT_NO_SEED          = 8,
    SORT_PW_CFG_EXIT_BAD_SEED         = 9,
    SORT_PW_CFG_EXIT_BAD_SELECT_CHARS = 10,
    SORT_PW_CFG_EXIT_NO_PWID          = 11,
    SORT_PW_CFG_EXIT_CODING_ERROR     = 16,
    SORT_PW_CFG_EXIT_USAGE_ERROR      = 64,
    SORT_PW_CFG_EXIT_LIBOPTS_FAILURE  = 70
}   sort_pw_cfg_exit_code_t;
/**
 *  Interface defines for specific options.
 * @{
 */
#define VALUE_OPT_OUTPUT         'o'
#define VALUE_OPT_DEFAULT        'd'
/** option flag (value) for help-value option */
#define VALUE_OPT_HELP          'h'
/** option flag (value) for more-help-value option */
#define VALUE_OPT_MORE_HELP     'M'
/** option flag (value) for version-value option */
#define VALUE_OPT_VERSION       'v'
/*
 *  Interface defines not associated with particular options
 */
#define ERRSKIP_OPTERR  STMTS(sort_pw_cfgOptions.fOptSet &= ~OPTPROC_ERRSTOP)
#define ERRSTOP_OPTERR  STMTS(sort_pw_cfgOptions.fOptSet |= OPTPROC_ERRSTOP)
#define RESTART_OPT(n)  STMTS( \
                sort_pw_cfgOptions.curOptIdx = (n); \
                sort_pw_cfgOptions.pzCurOpt  = NULL )
#define START_OPT       RESTART_OPT(1)
#define USAGE(c)        (*sort_pw_cfgOptions.pUsageProc)(&sort_pw_cfgOptions, c)

#ifdef  __cplusplus
extern "C" {
#endif
/*
 *  global exported definitions
 */
#include "gpw-str.h"

        static unsigned int const secure_mask = S_IRWXG | S_IRWXO;
extern char const * config_file_name;
extern char const * leader_text;
extern size_t       config_file_size;


/* * * * * *
 *
 *  Declare the sort-pw-cfg option descriptor.
 */
extern tOptions sort_pw_cfgOptions;
# define OPT_NO_XLAT_CFG_NAMES
# define OPT_NO_XLAT_OPT_NAMES

# define OPT_XLAT_CFG_NAMES
# define OPT_XLAT_OPT_NAMES

# ifndef _
#   define _(_s)  _s
# endif


noreturn extern void
vusage_message(char const * fmt, va_list ap);
noreturn extern void
usage_message(char const * fmt, ...);
noreturn extern void
vdie( int exit_code, char const * fmt, va_list);
noreturn extern void
die(  int exit_code, char const * fmt, ...);
noreturn extern void
fserr(int exit_code, char const * op, char const * fn);

/**
 * Print a SORT_PW_CFG_EXIT_NO_MEM fatal error message and die.
 *
 * @param[in] sz     the object size that was not allocated
 * @param[in] what   what that object was going to be
 * @noreturn
 */
noreturn static inline void nomem_err(size_t sz, char const * what)
{
    char const * fmt = _("could not allocate %zu bytes for %s\n");
    die(SORT_PW_CFG_EXIT_NO_MEM, fmt, sz, what);
}
extern void vwarning_msg( char const * fmt, va_list);
extern void warning_msg(  char const * fmt, ...);
#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_SORT_OPTS_H_GUARD */

/* sort-opts.h ends here */
