/*
 * SPDX-FileCopyrightText: (c) 2003, 2004 Lev Walkin <vlm@lionet.info>. All rights reserved.
 * SPDX-License-Identifier: BSD-1-Clause
 * Generated by asn1c-0.9.22 (http://lionet.info/asn1c)
 * From ASN.1 module "ULP-Components"
 *     found in "../supl-common.asn"
 */

#include "SETId.h"

static int check_permitted_alphabet_6(const void *sptr)
{
    /* The underlying type is IA5String */
    const IA5String_t *st = (const IA5String_t *)sptr;
    const uint8_t *ch = st->buf;
    const uint8_t *end = ch + st->size;

    for (; ch < end; ch++)
        {
            uint8_t cv = *ch;
            if (!(cv <= 127))
                {
                    return -1;
                }
        }
    return 0;
}

static int memb_msisdn_constraint_1(asn_TYPE_descriptor_t *td, const void *sptr,
    asn_app_constraint_failed_f *ctfailcb,
    void *app_key)
{
    const OCTET_STRING_t *st = (const OCTET_STRING_t *)sptr;
    size_t size;

    if (!sptr)
        {
            _ASN_CTFAIL(app_key, td, sptr, "%s: value not given (%s:%d)",
                td->name, __FILE__, __LINE__);
            return -1;
        }

    size = st->size;

    if (size == 8)
        {
            /* Constraint check succeeded */
            return 0;
        }
    else
        {
            _ASN_CTFAIL(app_key, td, sptr, "%s: constraint failed (%s:%d)",
                td->name, __FILE__, __LINE__);
            return -1;
        }
}

static int memb_mdn_constraint_1(asn_TYPE_descriptor_t *td, const void *sptr,
    asn_app_constraint_failed_f *ctfailcb,
    void *app_key)
{
    const OCTET_STRING_t *st = (const OCTET_STRING_t *)sptr;
    size_t size;

    if (!sptr)
        {
            _ASN_CTFAIL(app_key, td, sptr, "%s: value not given (%s:%d)",
                td->name, __FILE__, __LINE__);
            return -1;
        }

    size = st->size;

    if (size == 8)
        {
            /* Constraint check succeeded */
            return 0;
        }
    else
        {
            _ASN_CTFAIL(app_key, td, sptr, "%s: constraint failed (%s:%d)",
                td->name, __FILE__, __LINE__);
            return -1;
        }
}

static int memb_min_constraint_1(asn_TYPE_descriptor_t *td, const void *sptr,
    asn_app_constraint_failed_f *ctfailcb,
    void *app_key)
{
    const BIT_STRING_t *st = (const BIT_STRING_t *)sptr;
    size_t size;

    if (!sptr)
        {
            _ASN_CTFAIL(app_key, td, sptr, "%s: value not given (%s:%d)",
                td->name, __FILE__, __LINE__);
            return -1;
        }

    if (st->size > 0)
        {
            /* Size in bits */
            size = 8 * st->size - (st->bits_unused & 0x07);
        }
    else
        {
            size = 0;
        }

    if (size == 34)
        {
            /* Constraint check succeeded */
            return 0;
        }
    else
        {
            _ASN_CTFAIL(app_key, td, sptr, "%s: constraint failed (%s:%d)",
                td->name, __FILE__, __LINE__);
            return -1;
        }
}

static int memb_imsi_constraint_1(asn_TYPE_descriptor_t *td, const void *sptr,
    asn_app_constraint_failed_f *ctfailcb,
    void *app_key)
{
    const OCTET_STRING_t *st = (const OCTET_STRING_t *)sptr;
    size_t size;

    if (!sptr)
        {
            _ASN_CTFAIL(app_key, td, sptr, "%s: value not given (%s:%d)",
                td->name, __FILE__, __LINE__);
            return -1;
        }

    size = st->size;

    if (size == 8)
        {
            /* Constraint check succeeded */
            return 0;
        }
    else
        {
            _ASN_CTFAIL(app_key, td, sptr, "%s: constraint failed (%s:%d)",
                td->name, __FILE__, __LINE__);
            return -1;
        }
}

static int memb_nai_constraint_1(asn_TYPE_descriptor_t *td, const void *sptr,
    asn_app_constraint_failed_f *ctfailcb,
    void *app_key)
{
    const IA5String_t *st = (const IA5String_t *)sptr;
    size_t size;

    if (!sptr)
        {
            _ASN_CTFAIL(app_key, td, sptr, "%s: value not given (%s:%d)",
                td->name, __FILE__, __LINE__);
            return -1;
        }

    size = st->size;

    if ((size >= 1 && size <= 1000) && !check_permitted_alphabet_6(st))
        {
            /* Constraint check succeeded */
            return 0;
        }
    else
        {
            _ASN_CTFAIL(app_key, td, sptr, "%s: constraint failed (%s:%d)",
                td->name, __FILE__, __LINE__);
            return -1;
        }
}

static asn_per_constraints_t ASN_PER_MEMB_MSISDN_CONSTR_2 = {
    {APC_UNCONSTRAINED, -1, -1, 0, 0},
    {APC_CONSTRAINED, 0, 0, 8, 8} /* (SIZE(8..8)) */,
    0,
    0 /* No PER value map */
};
static asn_per_constraints_t ASN_PER_MEMB_MDN_CONSTR_3 = {
    {APC_UNCONSTRAINED, -1, -1, 0, 0},
    {APC_CONSTRAINED, 0, 0, 8, 8} /* (SIZE(8..8)) */,
    0,
    0 /* No PER value map */
};
static asn_per_constraints_t ASN_PER_MEMB_MIN_CONSTR_4 = {
    {APC_UNCONSTRAINED, -1, -1, 0, 0},
    {APC_CONSTRAINED, 0, 0, 34, 34} /* (SIZE(34..34)) */,
    0,
    0 /* No PER value map */
};
static asn_per_constraints_t ASN_PER_MEMB_IMSI_CONSTR_5 = {
    {APC_UNCONSTRAINED, -1, -1, 0, 0},
    {APC_CONSTRAINED, 0, 0, 8, 8} /* (SIZE(8..8)) */,
    0,
    0 /* No PER value map */
};
static asn_per_constraints_t ASN_PER_MEMB_NAI_CONSTR_6 = {
    {APC_CONSTRAINED, 7, 7, 0, 127} /* (0..127) */,
    {APC_CONSTRAINED, 10, 10, 1, 1000} /* (SIZE(1..1000)) */,
    0,
    0 /* No PER character map necessary */
};
static asn_per_constraints_t ASN_PER_TYPE_SET_ID_CONSTR_1 = {
    {APC_CONSTRAINED | APC_EXTENSIBLE, 3, 3, 0, 5} /* (0..5,...) */,
    {APC_UNCONSTRAINED, -1, -1, 0, 0},
    0,
    0 /* No PER value map */
};
static asn_TYPE_member_t asn_MBR_SETId_1[] = {
    {ATF_NOFLAGS, 0, offsetof(struct SETId, choice.msisdn),
        (ASN_TAG_CLASS_CONTEXT | (0 << 2)), -1, /* IMPLICIT tag at current level */
        &asn_DEF_OCTET_STRING, memb_msisdn_constraint_1,
        &ASN_PER_MEMB_MSISDN_CONSTR_2, 0, "msisdn"},
    {ATF_NOFLAGS, 0, offsetof(struct SETId, choice.mdn),
        (ASN_TAG_CLASS_CONTEXT | (1 << 2)), -1, /* IMPLICIT tag at current level */
        &asn_DEF_OCTET_STRING, memb_mdn_constraint_1, &ASN_PER_MEMB_MDN_CONSTR_3,
        0, "mdn"},
    {ATF_NOFLAGS, 0, offsetof(struct SETId, choice.min),
        (ASN_TAG_CLASS_CONTEXT | (2 << 2)), -1, /* IMPLICIT tag at current level */
        &asn_DEF_BIT_STRING, memb_min_constraint_1, &ASN_PER_MEMB_MIN_CONSTR_4, 0,
        "min"},
    {ATF_NOFLAGS, 0, offsetof(struct SETId, choice.imsi),
        (ASN_TAG_CLASS_CONTEXT | (3 << 2)), -1, /* IMPLICIT tag at current level */
        &asn_DEF_OCTET_STRING, memb_imsi_constraint_1, &ASN_PER_MEMB_IMSI_CONSTR_5,
        0, "imsi"},
    {ATF_NOFLAGS, 0, offsetof(struct SETId, choice.nai),
        (ASN_TAG_CLASS_CONTEXT | (4 << 2)), -1, /* IMPLICIT tag at current level */
        &asn_DEF_IA5String, memb_nai_constraint_1, &ASN_PER_MEMB_NAI_CONSTR_6, 0,
        "nai"},
    {ATF_NOFLAGS, 0, offsetof(struct SETId, choice.iPAddress),
        (ASN_TAG_CLASS_CONTEXT | (5 << 2)), +1, /* EXPLICIT tag at current level */
        &asn_DEF_IPAddress, 0,                  /* Defer constraints checking to the member type */
        0,                                      /* No PER visible constraints */
        0, "iPAddress"},
};
static asn_TYPE_tag2member_t asn_MAP_SETId_tag2el_1[] = {
    {(ASN_TAG_CLASS_CONTEXT | (0 << 2)), 0, 0, 0}, /* msisdn at 22 */
    {(ASN_TAG_CLASS_CONTEXT | (1 << 2)), 1, 0, 0}, /* mdn at 23 */
    {(ASN_TAG_CLASS_CONTEXT | (2 << 2)), 2, 0, 0}, /* min at 24 */
    {(ASN_TAG_CLASS_CONTEXT | (3 << 2)), 3, 0, 0}, /* imsi at 25 */
    {(ASN_TAG_CLASS_CONTEXT | (4 << 2)), 4, 0, 0}, /* nai at 26 */
    {(ASN_TAG_CLASS_CONTEXT | (5 << 2)), 5, 0, 0}  /* iPAddress at 27 */
};
static asn_CHOICE_specifics_t asn_SPC_SETId_specs_1 = {
    sizeof(struct SETId),
    offsetof(struct SETId, _asn_ctx),
    offsetof(struct SETId, present),
    sizeof(((struct SETId *)0)->present),
    asn_MAP_SETId_tag2el_1,
    6, /* Count of tags in the map */
    0,
    6 /* Extensions start */
};
asn_TYPE_descriptor_t asn_DEF_SETId = {
    "SETId",
    "SETId",
    CHOICE_free,
    CHOICE_print,
    CHOICE_constraint,
    CHOICE_decode_ber,
    CHOICE_encode_der,
    CHOICE_decode_xer,
    CHOICE_encode_xer,
    CHOICE_decode_uper,
    CHOICE_encode_uper,
    CHOICE_outmost_tag,
    0, /* No effective tags (pointer) */
    0, /* No effective tags (count) */
    0, /* No tags (pointer) */
    0, /* No tags (count) */
    &ASN_PER_TYPE_SET_ID_CONSTR_1,
    asn_MBR_SETId_1,
    6,                     /* Elements count */
    &asn_SPC_SETId_specs_1 /* Additional specs */
};
