/* gnome-sudoku.c generated by valac 0.32.0.45-49b63, the Vala compiler
 * generated from gnome-sudoku.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libsudoku.h"
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gee.h>


#define TYPE_SUDOKU (sudoku_get_type ())
#define SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU, Sudoku))
#define SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU, SudokuClass))
#define IS_SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU))
#define IS_SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU))
#define SUDOKU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU, SudokuClass))

typedef struct _Sudoku Sudoku;
typedef struct _SudokuClass SudokuClass;
typedef struct _SudokuPrivate SudokuPrivate;

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;

#define TYPE_PRINT_DIALOG (print_dialog_get_type ())
#define PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_DIALOG, PrintDialog))
#define PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_DIALOG, PrintDialogClass))
#define IS_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_DIALOG))
#define IS_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_DIALOG))
#define PRINT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_DIALOG, PrintDialogClass))

typedef struct _PrintDialog PrintDialog;
typedef struct _PrintDialogClass PrintDialogClass;

struct _Sudoku {
	GtkApplication parent_instance;
	SudokuPrivate * priv;
};

struct _SudokuClass {
	GtkApplicationClass parent_class;
};

struct _SudokuPrivate {
	GSettings* settings;
	gboolean is_maximized;
	gboolean is_tiled;
	gint window_width;
	gint window_height;
	GtkButton* play_custom_game_button;
	GtkButton* play_pause_button;
	GtkLabel* play_pause_label;
	GtkLabel* clock_label;
	GtkImage* clock_image;
	GtkApplicationWindow* window;
	SudokuGame* game;
	SudokuView* view;
	GtkHeaderBar* headerbar;
	GtkStack* main_stack;
	GtkBox* game_box;
	GtkBox* undo_redo_box;
	GtkButton* back_button;
	SudokuSaver* saver;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
	GSimpleAction* clear_action;
	GSimpleAction* print_action;
	GSimpleAction* print_multiple_action;
	GSimpleAction* pause_action;
	GSimpleAction* play_custom_game_action;
	GSimpleAction* new_game_action;
	gboolean show_possibilities;
	GameMode current_game_mode;
};

struct _Block1Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

struct _Block2Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

struct _Block3Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};


static gpointer sudoku_parent_class = NULL;

GType sudoku_get_type (void) G_GNUC_CONST;
GType sudoku_view_get_type (void) G_GNUC_CONST;
#define SUDOKU_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU, SudokuPrivate))
enum  {
	SUDOKU_DUMMY_PROPERTY
};
static void sudoku_new_game_cb (Sudoku* self);
static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty);
static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_create_game_cb (Sudoku* self);
static void _sudoku_create_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_reset_cb (Sudoku* self);
static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_back_cb (Sudoku* self);
static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_undo_cb (Sudoku* self);
static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_redo_cb (Sudoku* self);
static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_cb (Sudoku* self);
static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_play_custom_game_cb (Sudoku* self);
static void _sudoku_play_custom_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_toggle_pause_cb (Sudoku* self);
static void _sudoku_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_multiple_cb (Sudoku* self);
static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_help_cb (Sudoku* self);
static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_about_cb (Sudoku* self);
static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Sudoku* sudoku_new (void);
Sudoku* sudoku_construct (GType object_type);
static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options);
static gboolean sudoku_is_desktop (Sudoku* self, const gchar* name);
static void sudoku_real_startup (GApplication* base);
static void __lambda26_ (Sudoku* self);
void sudoku_view_set_show_warnings (SudokuView* self, gboolean value);
static void ___lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda27_ (Sudoku* self);
void sudoku_view_set_highlighter (SudokuView* self, gboolean value);
static void ___lambda27__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void sudoku_size_allocate_cb (Sudoku* self, GtkAllocation* allocation);
static void _sudoku_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event);
static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void sudoku_start_game (Sudoku* self, SudokuBoard* board);
static void sudoku_show_new_game_screen (Sudoku* self);
static void sudoku_real_activate (GApplication* base);
static void sudoku_real_shutdown (GApplication* base);
static void sudoku_paused_changed_cb (Sudoku* self);
static void sudoku_display_unpause_button (Sudoku* self);
static void sudoku_display_pause_button (Sudoku* self);
static void sudoku_start_custom_game (Sudoku* self, SudokuBoard* board);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ____lambda21_ (Block1Data* _data1_, gint response_id);
static void _____lambda21__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void sudoku_tick_cb (Sudoku* self);
static void sudoku_show_game_view (Sudoku* self);
static void sudoku_set_headerbar_title (Sudoku* self);
static void _sudoku_tick_cb_sudoku_game_tick (SudokuGame* _sender, gpointer self);
static void _sudoku_paused_changed_cb_sudoku_game_paused_changed (SudokuGame* _sender, gpointer self);
SudokuView* sudoku_view_new (SudokuGame* game);
SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game);
void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value);
static void __lambda16_ (Sudoku* self);
static void ___lambda16__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self);
static void __lambda17_ (Sudoku* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda18_ (Block2Data* _data2_, gint response_id);
static void ___lambda18__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void ___lambda17__sudoku_board_completed (SudokuBoard* _sender, gpointer self);
static void __lambda19_ (Sudoku* self, GObject* obj, GAsyncResult* res);
static void ___lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda15_ (Sudoku* self, GObject* obj, GAsyncResult* res);
static void ___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda20_ (Block3Data* _data3_, gint response_id);
void sudoku_view_clear (SudokuView* self);
static void ___lambda20__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
GType sudoku_printer_get_type (void) G_GNUC_CONST;
SudokuPrinter* sudoku_printer_new (GeeList* boards, GtkWindow* window);
SudokuPrinter* sudoku_printer_construct (GType object_type, GeeList* boards, GtkWindow* window);
GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
GType print_dialog_get_type (void) G_GNUC_CONST;
PrintDialog* print_dialog_new (SudokuSaver* saver, GtkWindow* window);
PrintDialog* print_dialog_construct (GType object_type, SudokuSaver* saver, GtkWindow* window);
static void __lambda25_ (Sudoku* self);
static void ___lambda25__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
gint sudoku_main (gchar** args, int args_length1);
static void sudoku_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry SUDOKU_action_entries[14] = {{"new-game", _sudoku_new_game_cb_gsimple_action_activate_callback}, {"start-game", _sudoku_start_game_cb_gsimple_action_activate_callback, "i"}, {"create-game", _sudoku_create_game_cb_gsimple_action_activate_callback}, {"reset", _sudoku_reset_cb_gsimple_action_activate_callback}, {"back", _sudoku_back_cb_gsimple_action_activate_callback}, {"undo", _sudoku_undo_cb_gsimple_action_activate_callback}, {"redo", _sudoku_redo_cb_gsimple_action_activate_callback}, {"print", _sudoku_print_cb_gsimple_action_activate_callback}, {"play-custom-game", _sudoku_play_custom_game_cb_gsimple_action_activate_callback}, {"pause", _sudoku_toggle_pause_cb_gsimple_action_activate_callback}, {"print-multiple", _sudoku_print_multiple_cb_gsimple_action_activate_callback}, {"help", _sudoku_help_cb_gsimple_action_activate_callback}, {"about", _sudoku_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GOptionEntry SUDOKU_option_entries[3] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Show release version", NULL}, {"show-possible-values", 's', 0, G_OPTION_ARG_NONE, NULL, "Show the possible values for each cell", NULL}, {NULL}};
static const gchar* SUDOKU_authors[6] = {"Robert Ancell <robert.ancell@gmail.com>", "Christopher Baines <cbaines8@gmail.com>", "Thomas M. Hinkle <Thomas_Hinkle@alumni.brown.edu>", "Parin Porecha <parinporecha@gmail.com>", "John Stowers <john.stowers@gmail.com>", NULL};

static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_new_game_cb ((Sudoku*) self);
#line 258 "gnome-sudoku.c"
}


static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_start_game_cb ((Sudoku*) self, action, parameter);
#line 265 "gnome-sudoku.c"
}


static void _sudoku_create_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_create_game_cb ((Sudoku*) self);
#line 272 "gnome-sudoku.c"
}


static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_reset_cb ((Sudoku*) self);
#line 279 "gnome-sudoku.c"
}


static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_back_cb ((Sudoku*) self);
#line 286 "gnome-sudoku.c"
}


static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_undo_cb ((Sudoku*) self);
#line 293 "gnome-sudoku.c"
}


static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_redo_cb ((Sudoku*) self);
#line 300 "gnome-sudoku.c"
}


static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_print_cb ((Sudoku*) self);
#line 307 "gnome-sudoku.c"
}


static void _sudoku_play_custom_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_play_custom_game_cb ((Sudoku*) self);
#line 314 "gnome-sudoku.c"
}


static void _sudoku_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_toggle_pause_cb ((Sudoku*) self);
#line 321 "gnome-sudoku.c"
}


static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_print_multiple_cb ((Sudoku*) self);
#line 328 "gnome-sudoku.c"
}


static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_help_cb ((Sudoku*) self);
#line 335 "gnome-sudoku.c"
}


static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_about_cb ((Sudoku*) self);
#line 342 "gnome-sudoku.c"
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_application_quit ((GApplication*) self);
#line 349 "gnome-sudoku.c"
}


Sudoku* sudoku_construct (GType object_type) {
	Sudoku * self = NULL;
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	setlocale (LC_ALL, "");
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	textdomain (GETTEXT_PACKAGE);
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) g_object_new (object_type, "application-id", "org.gnome.sudoku", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_application_add_main_option_entries ((GApplication*) self, SUDOKU_option_entries);
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return self;
#line 369 "gnome-sudoku.c"
}


Sudoku* sudoku_new (void) {
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return sudoku_construct (TYPE_SUDOKU);
#line 376 "gnome-sudoku.c"
}


static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Sudoku * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GVariantDict* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = options;
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp1_) {
#line 397 "gnome-sudoku.c"
		FILE* _tmp2_ = NULL;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = stderr;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		fprintf (_tmp2_, "gnome-sudoku %s\n", VERSION);
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		result = EXIT_SUCCESS;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return result;
#line 407 "gnome-sudoku.c"
	}
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = options;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = g_variant_dict_contains (_tmp3_, "show-possible-values");
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp4_) {
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->show_possibilities = TRUE;
#line 417 "gnome-sudoku.c"
	}
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = -1;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 423 "gnome-sudoku.c"
}


static gboolean sudoku_is_desktop (Sudoku* self, const gchar* name) {
	gboolean result = FALSE;
	gchar* desktop_name_list = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	desktop_name_list = _tmp1_;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = desktop_name_list;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp2_ == NULL) {
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		result = FALSE;
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (desktop_name_list);
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return result;
#line 456 "gnome-sudoku.c"
	}
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = desktop_name_list;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ":", 0);
#line 462 "gnome-sudoku.c"
	{
		gchar** n_collection = NULL;
		gint n_collection_length1 = 0;
		gint _n_collection_size_ = 0;
		gint n_it = 0;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		n_collection = _tmp5_;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		n_collection_length1 = _vala_array_length (_tmp4_);
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		for (n_it = 0; n_it < _vala_array_length (_tmp4_); n_it = n_it + 1) {
#line 474 "gnome-sudoku.c"
			gchar* _tmp6_ = NULL;
			gchar* n = NULL;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp6_ = g_strdup (n_collection[n_it]);
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			n = _tmp6_;
#line 481 "gnome-sudoku.c"
			{
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp7_ = n;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp8_ = name;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					result = TRUE;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					_g_free0 (n);
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					n_collection = (_vala_array_free (n_collection, n_collection_length1, (GDestroyNotify) g_free), NULL);
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					_g_free0 (desktop_name_list);
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					return result;
#line 501 "gnome-sudoku.c"
				}
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_g_free0 (n);
#line 505 "gnome-sudoku.c"
			}
		}
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		n_collection = (_vala_array_free (n_collection, n_collection_length1, (GDestroyNotify) g_free), NULL);
#line 510 "gnome-sudoku.c"
	}
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = FALSE;
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (desktop_name_list);
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 518 "gnome-sudoku.c"
}


static void __lambda26_ (Sudoku* self) {
	gboolean _tmp0_ = FALSE;
	SudokuView* _tmp1_ = NULL;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->view;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp1_ != NULL) {
#line 529 "gnome-sudoku.c"
		GameMode _tmp2_ = 0;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->current_game_mode;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = _tmp2_ == GAME_MODE_PLAY;
#line 535 "gnome-sudoku.c"
	} else {
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = FALSE;
#line 539 "gnome-sudoku.c"
	}
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_) {
#line 543 "gnome-sudoku.c"
		SudokuView* _tmp3_ = NULL;
		GSettings* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->view;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->settings;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = g_settings_get_boolean (_tmp4_, "show-warnings");
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_set_show_warnings (_tmp3_, _tmp5_);
#line 555 "gnome-sudoku.c"
	}
}


static void ___lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda26_ ((Sudoku*) self);
#line 563 "gnome-sudoku.c"
}


static void __lambda27_ (Sudoku* self) {
	SudokuView* _tmp0_ = NULL;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->view;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ != NULL) {
#line 573 "gnome-sudoku.c"
		SudokuView* _tmp1_ = NULL;
		GSettings* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->view;
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->settings;
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = g_settings_get_boolean (_tmp2_, "highlighter");
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_set_highlighter (_tmp1_, _tmp3_);
#line 585 "gnome-sudoku.c"
	}
}


static void ___lambda27__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda27_ ((Sudoku*) self);
#line 593 "gnome-sudoku.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return self ? g_object_ref (self) : NULL;
#line 600 "gnome-sudoku.c"
}


static void _sudoku_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_size_allocate_cb ((Sudoku*) self, allocation);
#line 607 "gnome-sudoku.c"
}


static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = sudoku_window_state_event_cb ((Sudoku*) self, event);
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 616 "gnome-sudoku.c"
}


static void sudoku_real_startup (GApplication* base) {
	Sudoku * self;
	GSettings* _tmp0_ = NULL;
	GAction* action = NULL;
	GSettings* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	GAction* _tmp3_ = NULL;
	GAction* _tmp4_ = NULL;
	GAction* highlighter_action = NULL;
	GSettings* _tmp5_ = NULL;
	GAction* _tmp6_ = NULL;
	GAction* _tmp7_ = NULL;
	GAction* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gchar* _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gchar* _tmp24_ = NULL;
	gchar** _tmp25_ = NULL;
	gchar** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	gchar* _tmp27_ = NULL;
	gchar** _tmp28_ = NULL;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp30_ = NULL;
	GtkCssProvider* _tmp31_ = NULL;
	GdkScreen* _tmp32_ = NULL;
	GtkCssProvider* _tmp33_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp34_ = NULL;
	GtkBuilder* _tmp35_ = NULL;
	GObject* _tmp36_ = NULL;
	GtkApplicationWindow* _tmp37_ = NULL;
	GtkApplicationWindow* _tmp38_ = NULL;
	GtkApplicationWindow* _tmp39_ = NULL;
	GtkApplicationWindow* _tmp40_ = NULL;
	GSettings* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	GSettings* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	GSettings* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	GtkApplicationWindow* _tmp48_ = NULL;
	GtkBuilder* _tmp49_ = NULL;
	GObject* _tmp50_ = NULL;
	GtkHeaderBar* _tmp51_ = NULL;
	GtkBuilder* _tmp52_ = NULL;
	GObject* _tmp53_ = NULL;
	GtkStack* _tmp54_ = NULL;
	GtkBuilder* _tmp55_ = NULL;
	GObject* _tmp56_ = NULL;
	GtkBox* _tmp57_ = NULL;
	GtkBuilder* _tmp58_ = NULL;
	GObject* _tmp59_ = NULL;
	GtkBox* _tmp60_ = NULL;
	GtkBuilder* _tmp61_ = NULL;
	GObject* _tmp62_ = NULL;
	GtkButton* _tmp63_ = NULL;
	GtkBuilder* _tmp64_ = NULL;
	GObject* _tmp65_ = NULL;
	GtkLabel* _tmp66_ = NULL;
	GtkBuilder* _tmp67_ = NULL;
	GObject* _tmp68_ = NULL;
	GtkImage* _tmp69_ = NULL;
	GtkBuilder* _tmp70_ = NULL;
	GObject* _tmp71_ = NULL;
	GtkButton* _tmp72_ = NULL;
	GtkBuilder* _tmp73_ = NULL;
	GObject* _tmp74_ = NULL;
	GtkButton* _tmp75_ = NULL;
	GtkBuilder* _tmp76_ = NULL;
	GObject* _tmp77_ = NULL;
	GtkLabel* _tmp78_ = NULL;
	GAction* _tmp79_ = NULL;
	GSimpleAction* _tmp80_ = NULL;
	GAction* _tmp81_ = NULL;
	GSimpleAction* _tmp82_ = NULL;
	GAction* _tmp83_ = NULL;
	GSimpleAction* _tmp84_ = NULL;
	GAction* _tmp85_ = NULL;
	GSimpleAction* _tmp86_ = NULL;
	GAction* _tmp87_ = NULL;
	GSimpleAction* _tmp88_ = NULL;
	GAction* _tmp89_ = NULL;
	GSimpleAction* _tmp90_ = NULL;
	GAction* _tmp91_ = NULL;
	GSimpleAction* _tmp92_ = NULL;
	GAction* _tmp93_ = NULL;
	GSimpleAction* _tmp94_ = NULL;
	gboolean _tmp95_ = FALSE;
	SudokuSaver* _tmp104_ = NULL;
	SudokuGame* savegame = NULL;
	SudokuSaver* _tmp105_ = NULL;
	SudokuGame* _tmp106_ = NULL;
	SudokuGame* _tmp107_ = NULL;
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_APPLICATION_CLASS (sudoku_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action_entries ((GActionMap*) self, SUDOKU_action_entries, G_N_ELEMENTS (SUDOKU_action_entries), self);
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = g_settings_new ("org.gnome.sudoku");
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->settings);
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->settings = _tmp0_;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->settings;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = g_settings_create_action (_tmp1_, "show-warnings");
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	action = _tmp2_;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = action;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GObject*) _tmp3_, "notify::state", (GCallback) ___lambda26__g_object_notify, self, 0);
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = action;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp4_);
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->settings;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = g_settings_create_action (_tmp5_, "highlighter");
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	highlighter_action = _tmp6_;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = highlighter_action;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GObject*) _tmp7_, "notify::state", (GCallback) ___lambda27__g_object_notify, self, 0);
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = highlighter_action;
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp8_);
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = g_strdup ("<Primary>n");
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = g_new0 (gchar*, 1 + 1);
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_[0] = _tmp9_;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = _tmp10_;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11__length1 = 1;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp11_);
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = g_strdup ("<Primary>p");
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = g_new0 (gchar*, 1 + 1);
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_[0] = _tmp12_;
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = _tmp13_;
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14__length1 = 1;
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.print", _tmp14_);
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = g_strdup ("<Primary>q");
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_ = g_new0 (gchar*, 1 + 1);
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_[0] = _tmp15_;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = _tmp16_;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17__length1 = 1;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp17_);
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = g_strdup ("<Primary>r");
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = g_new0 (gchar*, 1 + 1);
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_[0] = _tmp18_;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = _tmp19_;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20__length1 = 1;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.reset", _tmp20_);
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = g_strdup ("<Primary>z");
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = g_new0 (gchar*, 1 + 1);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_[0] = _tmp21_;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = _tmp22_;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23__length1 = 1;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo", _tmp23_);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = g_strdup ("<Primary><Shift>z");
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = g_new0 (gchar*, 1 + 1);
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_[0] = _tmp24_;
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = _tmp25_;
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26__length1 = 1;
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.redo", _tmp26_);
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = g_strdup ("F1");
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_ = g_new0 (gchar*, 1 + 1);
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_[0] = _tmp27_;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = _tmp28_;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29__length1 = 1;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp29_);
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_set_default_icon_name ("gnome-sudoku");
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp30_ = gtk_css_provider_new ();
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	css_provider = _tmp30_;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp31_ = css_provider;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_css_provider_load_from_resource (_tmp31_, "/org/gnome/sudoku/ui/gnome-sudoku.css");
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp32_ = gdk_screen_get_default ();
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp33_ = css_provider;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_style_context_add_provider_for_screen (_tmp32_, (GtkStyleProvider*) _tmp33_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp34_ = gtk_builder_new_from_resource ("/org/gnome/sudoku/ui/gnome-sudoku.ui");
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	builder = _tmp34_;
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp35_ = builder;
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp36_ = gtk_builder_get_object (_tmp35_, "sudoku_app");
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_application_window_get_type (), GtkApplicationWindow));
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->window);
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->window = _tmp37_;
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp38_ = self->priv->window;
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GtkWidget*) _tmp38_, "size-allocate", (GCallback) _sudoku_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp39_ = self->priv->window;
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GtkWidget*) _tmp39_, "window-state-event", (GCallback) _sudoku_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp40_ = self->priv->window;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp41_ = self->priv->settings;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp42_ = g_settings_get_int (_tmp41_, "window-width");
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp43_ = self->priv->settings;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp44_ = g_settings_get_int (_tmp43_, "window-height");
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_set_default_size ((GtkWindow*) _tmp40_, _tmp42_, _tmp44_);
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp45_ = self->priv->settings;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp46_ = g_settings_get_boolean (_tmp45_, "window-is-maximized");
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp46_) {
#line 927 "gnome-sudoku.c"
		GtkApplicationWindow* _tmp47_ = NULL;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp47_ = self->priv->window;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_window_maximize ((GtkWindow*) _tmp47_);
#line 933 "gnome-sudoku.c"
	}
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp48_ = self->priv->window;
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp48_);
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp49_ = builder;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp50_ = gtk_builder_get_object (_tmp49_, "headerbar");
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_header_bar_get_type (), GtkHeaderBar));
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->headerbar = _tmp51_;
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp52_ = builder;
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp53_ = gtk_builder_get_object (_tmp52_, "main_stack");
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_stack_get_type (), GtkStack));
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->main_stack = _tmp54_;
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp55_ = builder;
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp56_ = gtk_builder_get_object (_tmp55_, "game_box");
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_box_get_type (), GtkBox));
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game_box);
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->game_box = _tmp57_;
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp58_ = builder;
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp59_ = gtk_builder_get_object (_tmp58_, "undo_redo_box");
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_box_get_type (), GtkBox));
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_redo_box);
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->undo_redo_box = _tmp60_;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp61_ = builder;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp62_ = gtk_builder_get_object (_tmp61_, "back_button");
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp63_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_button_get_type (), GtkButton));
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->back_button);
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->back_button = _tmp63_;
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp64_ = builder;
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp65_ = gtk_builder_get_object (_tmp64_, "clock_label");
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, gtk_label_get_type (), GtkLabel));
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clock_label);
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->clock_label = _tmp66_;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp67_ = builder;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp68_ = gtk_builder_get_object (_tmp67_, "clock_image");
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp69_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, gtk_image_get_type (), GtkImage));
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clock_image);
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->clock_image = _tmp69_;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp70_ = builder;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp71_ = gtk_builder_get_object (_tmp70_, "play_custom_game_button");
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp72_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, gtk_button_get_type (), GtkButton));
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_custom_game_button);
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->play_custom_game_button = _tmp72_;
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp73_ = builder;
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp74_ = gtk_builder_get_object (_tmp73_, "play_pause_button");
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp75_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, gtk_button_get_type (), GtkButton));
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_pause_button);
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->play_pause_button = _tmp75_;
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp76_ = builder;
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp77_ = gtk_builder_get_object (_tmp76_, "play_pause_label");
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp78_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, gtk_label_get_type (), GtkLabel));
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_pause_label);
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->play_pause_label = _tmp78_;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp79_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp80_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, g_simple_action_get_type (), GSimpleAction));
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_action);
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->undo_action = _tmp80_;
#line 191 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp81_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
#line 191 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, g_simple_action_get_type (), GSimpleAction));
#line 191 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->redo_action);
#line 191 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->redo_action = _tmp82_;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp83_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp84_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, g_simple_action_get_type (), GSimpleAction));
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->new_game_action);
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->new_game_action = _tmp84_;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp85_ = g_action_map_lookup_action ((GActionMap*) self, "reset");
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp86_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, g_simple_action_get_type (), GSimpleAction));
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clear_action);
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->clear_action = _tmp86_;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp87_ = g_action_map_lookup_action ((GActionMap*) self, "print");
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp88_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, g_simple_action_get_type (), GSimpleAction));
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_action);
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->print_action = _tmp88_;
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp89_ = g_action_map_lookup_action ((GActionMap*) self, "print-multiple");
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp90_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, g_simple_action_get_type (), GSimpleAction));
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_multiple_action);
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->print_multiple_action = _tmp90_;
#line 196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp91_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
#line 196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp92_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, g_simple_action_get_type (), GSimpleAction));
#line 196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->pause_action);
#line 196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->pause_action = _tmp92_;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp93_ = g_action_map_lookup_action ((GActionMap*) self, "play-custom-game");
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, g_simple_action_get_type (), GSimpleAction));
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_custom_game_action);
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->play_custom_game_action = _tmp94_;
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp95_ = sudoku_is_desktop (self, "Unity");
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (!_tmp95_) {
#line 1107 "gnome-sudoku.c"
		GtkHeaderBar* _tmp96_ = NULL;
		GtkApplicationWindow* _tmp97_ = NULL;
		GtkHeaderBar* _tmp98_ = NULL;
#line 201 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp96_ = self->priv->headerbar;
#line 201 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_show_close_button (_tmp96_, TRUE);
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp97_ = self->priv->window;
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp98_ = self->priv->headerbar;
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_window_set_titlebar ((GtkWindow*) _tmp97_, (GtkWidget*) _tmp98_);
#line 1121 "gnome-sudoku.c"
	} else {
		GtkBox* vbox = NULL;
		GtkBuilder* _tmp99_ = NULL;
		GObject* _tmp100_ = NULL;
		GtkBox* _tmp101_ = NULL;
		GtkBox* _tmp102_ = NULL;
		GtkHeaderBar* _tmp103_ = NULL;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp99_ = builder;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp100_ = gtk_builder_get_object (_tmp99_, "vbox");
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp101_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, gtk_box_get_type (), GtkBox));
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		vbox = _tmp101_;
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp102_ = vbox;
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp103_ = self->priv->headerbar;
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_box_pack_start (_tmp102_, (GtkWidget*) _tmp103_, FALSE, FALSE, (guint) 0);
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (vbox);
#line 1145 "gnome-sudoku.c"
	}
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp104_ = sudoku_saver_new ();
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->saver);
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->saver = _tmp104_;
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp105_ = self->priv->saver;
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp106_ = sudoku_saver_get_savedgame (_tmp105_);
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	savegame = _tmp106_;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp107_ = savegame;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp107_ != NULL) {
#line 1163 "gnome-sudoku.c"
		SudokuGame* _tmp108_ = NULL;
		SudokuBoard* _tmp109_ = NULL;
		DifficultyCategory _tmp110_ = 0;
		DifficultyCategory _tmp111_ = 0;
		SudokuGame* _tmp121_ = NULL;
		SudokuBoard* _tmp122_ = NULL;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp108_ = savegame;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp109_ = _tmp108_->board;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp110_ = sudoku_board_get_difficulty_category (_tmp109_);
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp111_ = _tmp110_;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp111_ == DIFFICULTY_CATEGORY_CUSTOM) {
#line 1180 "gnome-sudoku.c"
			GameMode _tmp112_ = 0;
			SudokuGame* _tmp113_ = NULL;
			SudokuBoard* _tmp114_ = NULL;
			gint _tmp115_ = 0;
			gint _tmp116_ = 0;
			SudokuGame* _tmp117_ = NULL;
			SudokuBoard* _tmp118_ = NULL;
			gint _tmp119_ = 0;
			gint _tmp120_ = 0;
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp113_ = savegame;
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp114_ = _tmp113_->board;
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp115_ = sudoku_board_get_filled (_tmp114_);
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp116_ = _tmp115_;
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp117_ = savegame;
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp118_ = _tmp117_->board;
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp119_ = sudoku_board_get_fixed (_tmp118_);
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp120_ = _tmp119_;
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			if (_tmp116_ == _tmp120_) {
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp112_ = GAME_MODE_CREATE;
#line 1210 "gnome-sudoku.c"
			} else {
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp112_ = GAME_MODE_PLAY;
#line 1214 "gnome-sudoku.c"
			}
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			self->priv->current_game_mode = _tmp112_;
#line 1218 "gnome-sudoku.c"
		}
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp121_ = savegame;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp122_ = _tmp121_->board;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_game (self, _tmp122_);
#line 1226 "gnome-sudoku.c"
	} else {
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_show_new_game_screen (self);
#line 1230 "gnome-sudoku.c"
	}
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (savegame);
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (builder);
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (css_provider);
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (highlighter_action);
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (action);
#line 1242 "gnome-sudoku.c"
}


static void sudoku_real_activate (GApplication* base) {
	Sudoku * self;
	GtkApplicationWindow* _tmp0_ = NULL;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 1255 "gnome-sudoku.c"
}


static void sudoku_real_shutdown (GApplication* base) {
	Sudoku * self;
	SudokuGame* _tmp0_ = NULL;
	GSettings* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	GSettings* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GSettings* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	GError * _inner_error_ = NULL;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ != NULL) {
#line 1275 "gnome-sudoku.c"
		gboolean _tmp1_ = FALSE;
		SudokuGame* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp10_ = FALSE;
		SudokuGame* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->game;
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = sudoku_game_is_empty (_tmp2_);
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (!_tmp3_) {
#line 1288 "gnome-sudoku.c"
			SudokuGame* _tmp4_ = NULL;
			SudokuBoard* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp4_ = self->priv->game;
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp5_ = _tmp4_->board;
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp6_ = sudoku_board_get_complete (_tmp5_);
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp7_ = _tmp6_;
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp1_ = !_tmp7_;
#line 1303 "gnome-sudoku.c"
		} else {
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp1_ = FALSE;
#line 1307 "gnome-sudoku.c"
		}
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp1_) {
#line 1311 "gnome-sudoku.c"
			SudokuSaver* _tmp8_ = NULL;
			SudokuGame* _tmp9_ = NULL;
#line 232 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp8_ = self->priv->saver;
#line 232 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp9_ = self->priv->game;
#line 232 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			sudoku_saver_save_game (_tmp8_, _tmp9_);
#line 1320 "gnome-sudoku.c"
		}
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = self->priv->game;
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = sudoku_game_is_empty (_tmp11_);
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp12_) {
#line 1328 "gnome-sudoku.c"
			SudokuSaver* _tmp13_ = NULL;
			SudokuGame* _tmp14_ = NULL;
			SudokuGame* _tmp15_ = NULL;
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp13_ = self->priv->saver;
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp14_ = sudoku_saver_get_savedgame (_tmp13_);
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp15_ = _tmp14_;
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp10_ = _tmp15_ != NULL;
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (_tmp15_);
#line 1342 "gnome-sudoku.c"
		} else {
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp10_ = FALSE;
#line 1346 "gnome-sudoku.c"
		}
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp10_) {
#line 1350 "gnome-sudoku.c"
			GFile* file = NULL;
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			GFile* _tmp18_ = NULL;
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp16_ = sudoku_saver_get_savegame_file ();
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp17_ = _tmp16_;
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp18_ = g_file_new_for_path (_tmp17_);
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			file = _tmp18_;
#line 1363 "gnome-sudoku.c"
			{
				GFile* _tmp19_ = NULL;
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp19_ = file;
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_file_delete (_tmp19_, NULL, &_inner_error_);
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1372 "gnome-sudoku.c"
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				e = _inner_error_;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_inner_error_ = NULL;
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp20_ = e;
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp21_ = _tmp20_->message;
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_warning ("gnome-sudoku.vala:244: Failed to delete saved game: %s", _tmp21_);
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_g_error_free0 (e);
#line 1394 "gnome-sudoku.c"
			}
			__finally0:
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_g_object_unref0 (file);
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_clear_error (&_inner_error_);
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				return;
#line 1407 "gnome-sudoku.c"
			}
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (file);
#line 1411 "gnome-sudoku.c"
		}
	}
#line 250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = self->priv->settings;
#line 250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = self->priv->window_width;
#line 250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_int (_tmp22_, "window-width", _tmp23_);
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = self->priv->settings;
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = self->priv->window_height;
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_int (_tmp24_, "window-height", _tmp25_);
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = self->priv->settings;
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = self->priv->is_maximized;
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_boolean (_tmp26_, "window-is-maximized", _tmp27_);
#line 254 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_APPLICATION_CLASS (sudoku_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 1434 "gnome-sudoku.c"
}


static void sudoku_size_allocate_cb (Sudoku* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkApplicationWindow* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (allocation != NULL);
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->is_maximized;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp1_) {
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = TRUE;
#line 1454 "gnome-sudoku.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->is_tiled;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = _tmp2_;
#line 1461 "gnome-sudoku.c"
	}
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_) {
#line 260 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 1467 "gnome-sudoku.c"
	}
#line 261 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->window;
#line 261 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_get_size ((GtkWindow*) _tmp3_, &_tmp4_, &_tmp5_);
#line 261 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->window_width = _tmp4_;
#line 261 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->window_height = _tmp5_;
#line 1477 "gnome-sudoku.c"
}


static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 266 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = event;
#line 266 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 266 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1497 "gnome-sudoku.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = event;
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1506 "gnome-sudoku.c"
	}
#line 269 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = event;
#line 269 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 269 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 1514 "gnome-sudoku.c"
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = event;
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
#line 1523 "gnome-sudoku.c"
	}
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = FALSE;
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 1529 "gnome-sudoku.c"
}


static void sudoku_paused_changed_cb (Sudoku* self) {
	SudokuGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 274 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 276 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 276 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
#line 276 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = _tmp1_;
#line 276 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp2_) {
#line 1547 "gnome-sudoku.c"
		GSimpleAction* _tmp3_ = NULL;
		GSimpleAction* _tmp4_ = NULL;
		GSimpleAction* _tmp5_ = NULL;
		GSimpleAction* _tmp6_ = NULL;
#line 278 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_display_unpause_button (self);
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->clear_action;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp3_, FALSE);
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->undo_action;
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp4_, FALSE);
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = self->priv->redo_action;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp5_, FALSE);
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = self->priv->new_game_action;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp6_, FALSE);
#line 1570 "gnome-sudoku.c"
	} else {
		SudokuGame* _tmp7_ = NULL;
		gdouble _tmp8_ = 0.0;
#line 284 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = self->priv->game;
#line 284 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = sudoku_game_get_total_time_played (_tmp7_);
#line 284 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp8_ > ((gdouble) 0)) {
#line 1580 "gnome-sudoku.c"
			GSimpleAction* _tmp9_ = NULL;
			SudokuGame* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			GSimpleAction* _tmp12_ = NULL;
			SudokuGame* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			GSimpleAction* _tmp15_ = NULL;
			SudokuGame* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			GSimpleAction* _tmp18_ = NULL;
#line 286 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			sudoku_display_pause_button (self);
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp9_ = self->priv->clear_action;
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp10_ = self->priv->game;
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp11_ = sudoku_game_is_empty (_tmp10_);
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_simple_action_set_enabled (_tmp9_, !_tmp11_);
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp12_ = self->priv->undo_action;
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp13_ = self->priv->game;
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp14_ = sudoku_game_is_undostack_null (_tmp13_);
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_simple_action_set_enabled (_tmp12_, !_tmp14_);
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp15_ = self->priv->redo_action;
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp16_ = self->priv->game;
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp17_ = sudoku_game_is_redostack_null (_tmp16_);
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_simple_action_set_enabled (_tmp15_, !_tmp17_);
#line 290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp18_ = self->priv->new_game_action;
#line 290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_simple_action_set_enabled (_tmp18_, TRUE);
#line 1621 "gnome-sudoku.c"
		}
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data1_;
#line 1632 "gnome-sudoku.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1641 "gnome-sudoku.c"
		Sudoku* self;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data1_->self;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data1_->dialog);
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block1Data, _data1_);
#line 1651 "gnome-sudoku.c"
	}
}


static void ____lambda21_ (Block1Data* _data1_, gint response_id) {
	Sudoku* self;
	gint _tmp0_ = 0;
	GtkMessageDialog* _tmp3_ = NULL;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data1_->self;
#line 317 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = response_id;
#line 317 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 1666 "gnome-sudoku.c"
		SudokuGame* _tmp1_ = NULL;
		SudokuBoard* _tmp2_ = NULL;
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->game;
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = _tmp1_->board;
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_custom_game (self, _tmp2_);
#line 1675 "gnome-sudoku.c"
	}
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = _data1_->dialog;
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
#line 1681 "gnome-sudoku.c"
}


static void _____lambda21__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	____lambda21_ (self, response_id);
#line 1688 "gnome-sudoku.c"
}


static void sudoku_play_custom_game_cb (Sudoku* self) {
	gint solutions = 0;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _tmp0_->board;
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = sudoku_board_count_solutions_limited (_tmp1_);
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	solutions = _tmp2_;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = solutions;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp3_ == 1) {
#line 1712 "gnome-sudoku.c"
		SudokuGame* _tmp4_ = NULL;
		SudokuBoard* _tmp5_ = NULL;
#line 298 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->game;
#line 298 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = _tmp4_->board;
#line 298 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_custom_game (self, _tmp5_);
#line 1721 "gnome-sudoku.c"
	} else {
		gint _tmp6_ = 0;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = solutions;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp6_ == 0) {
#line 1728 "gnome-sudoku.c"
			gchar* error_str = NULL;
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			GtkMessageDialog* dialog = NULL;
			GtkApplicationWindow* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			GtkMessageDialog* _tmp12_ = NULL;
			GtkMessageDialog* _tmp13_ = NULL;
			GtkMessageDialog* _tmp14_ = NULL;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp7_ = _ ("The puzzle you have entered is not a valid Sudoku.");
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp8_ = _ ("Please enter a valid puzzle.");
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp9_ = g_strdup_printf ("%s\n%s", _tmp7_, _tmp8_);
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			error_str = _tmp9_;
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp10_ = self->priv->window;
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp11_ = error_str;
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp12_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp10_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp11_);
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_object_ref_sink (_tmp12_);
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			dialog = _tmp12_;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp13_ = dialog;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			gtk_dialog_run ((GtkDialog*) _tmp13_);
#line 306 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp14_ = dialog;
#line 306 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			gtk_widget_destroy ((GtkWidget*) _tmp14_);
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (dialog);
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_free0 (error_str);
#line 1769 "gnome-sudoku.c"
		} else {
			Block1Data* _data1_;
			gchar* warning_str = NULL;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			GtkApplicationWindow* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			GtkMessageDialog* _tmp20_ = NULL;
			GtkMessageDialog* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			GtkMessageDialog* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			GtkMessageDialog* _tmp25_ = NULL;
			GtkMessageDialog* _tmp26_ = NULL;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_data1_ = g_slice_new0 (Block1Data);
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_data1_->_ref_count_ = 1;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_data1_->self = g_object_ref (self);
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp15_ = _ ("The puzzle you have entered has multiple solutions.");
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp16_ = _ ("Valid Sudoku puzzles have exactly one solution.");
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp17_ = g_strdup_printf ("%s\n%s", _tmp15_, _tmp16_);
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			warning_str = _tmp17_;
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp18_ = self->priv->window;
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp19_ = warning_str;
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp20_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp18_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, _tmp19_);
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_object_ref_sink (_tmp20_);
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_data1_->dialog = _tmp20_;
#line 313 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp21_ = _data1_->dialog;
#line 313 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp22_ = _ ("_Back");
#line 313 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			gtk_dialog_add_button ((GtkDialog*) _tmp21_, _tmp22_, (gint) GTK_RESPONSE_REJECT);
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp23_ = _data1_->dialog;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp24_ = _ ("Play _Anyway");
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			gtk_dialog_add_button ((GtkDialog*) _tmp23_, _tmp24_, (gint) GTK_RESPONSE_ACCEPT);
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp25_ = _data1_->dialog;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_signal_connect_data ((GtkDialog*) _tmp25_, "response", (GCallback) _____lambda21__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp26_ = _data1_->dialog;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			gtk_widget_show ((GtkWidget*) _tmp26_);
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_free0 (warning_str);
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			block1_data_unref (_data1_);
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_data1_ = NULL;
#line 1835 "gnome-sudoku.c"
		}
	}
}


static void sudoku_toggle_pause_cb (Sudoku* self) {
	SudokuGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 327 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 329 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 329 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
#line 329 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = _tmp1_;
#line 329 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp2_) {
#line 1855 "gnome-sudoku.c"
		SudokuGame* _tmp3_ = NULL;
#line 330 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->game;
#line 330 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_resume_clock (_tmp3_);
#line 1861 "gnome-sudoku.c"
	} else {
		SudokuGame* _tmp4_ = NULL;
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->game;
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_stop_clock (_tmp4_);
#line 1868 "gnome-sudoku.c"
	}
}


static void sudoku_tick_cb (Sudoku* self) {
	gint elapsed_time = 0;
	SudokuGame* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gint hours = 0;
	gint _tmp2_ = 0;
	gint minutes = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint seconds = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = sudoku_game_get_total_time_played (_tmp0_);
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	elapsed_time = (gint) _tmp1_;
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = elapsed_time;
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	hours = _tmp2_ / 3600;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = elapsed_time;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = hours;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	minutes = (_tmp3_ - (_tmp4_ * 3600)) / 60;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = elapsed_time;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = hours;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = minutes;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	seconds = (_tmp5_ - (_tmp6_ * 3600)) - (_tmp7_ * 60);
#line 341 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = hours;
#line 341 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp8_ > 0) {
#line 1917 "gnome-sudoku.c"
		GtkLabel* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = self->priv->clock_label;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = hours;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = minutes;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = seconds;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", _tmp10_, _tmp11_, _tmp12_);
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = _tmp13_;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_label_set_text (_tmp9_, _tmp14_);
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp14_);
#line 1940 "gnome-sudoku.c"
	} else {
		GtkLabel* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp15_ = self->priv->clock_label;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp16_ = minutes;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp17_ = seconds;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp18_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", _tmp16_, _tmp17_);
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp19_ = _tmp18_;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_label_set_text (_tmp15_, _tmp19_);
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp19_);
#line 1961 "gnome-sudoku.c"
	}
}


static void sudoku_display_pause_button (Sudoku* self) {
	GtkButton* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 347 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->play_pause_button;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->play_pause_label;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = _ ("_Pause");
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_label_set_label (_tmp1_, _tmp2_);
#line 1982 "gnome-sudoku.c"
}


static void sudoku_display_unpause_button (Sudoku* self) {
	GtkButton* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->play_pause_button;
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->play_pause_label;
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = _ ("_Resume");
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_label_set_label (_tmp1_, _tmp2_);
#line 2002 "gnome-sudoku.c"
}


static void sudoku_start_custom_game (Sudoku* self, SudokuBoard* board) {
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (board != NULL);
#line 361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->current_game_mode = GAME_MODE_PLAY;
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_stop_clock (_tmp0_);
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = board;
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_start_game (self, _tmp1_);
#line 2023 "gnome-sudoku.c"
}


static void _sudoku_tick_cb_sudoku_game_tick (SudokuGame* _sender, gpointer self) {
#line 381 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_tick_cb ((Sudoku*) self);
#line 2030 "gnome-sudoku.c"
}


static void _sudoku_paused_changed_cb_sudoku_game_paused_changed (SudokuGame* _sender, gpointer self) {
#line 382 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_paused_changed_cb ((Sudoku*) self);
#line 2037 "gnome-sudoku.c"
}


static void __lambda16_ (Sudoku* self) {
	GSimpleAction* _tmp0_ = NULL;
	SudokuGame* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSimpleAction* _tmp6_ = NULL;
	SudokuGame* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	SudokuGame* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GSimpleAction* _tmp15_ = NULL;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->undo_action;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->game;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = sudoku_game_is_undostack_null (_tmp1_);
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, !_tmp2_);
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->redo_action;
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->clear_action;
#line 401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->game;
#line 401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = sudoku_game_is_empty (_tmp7_);
#line 401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp6_, !_tmp8_);
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = self->priv->game;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = sudoku_game_is_empty (_tmp10_);
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (!_tmp11_) {
#line 2085 "gnome-sudoku.c"
		SudokuGame* _tmp12_ = NULL;
		SudokuBoard* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = self->priv->game;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = _tmp12_->board;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = sudoku_board_is_fully_filled (_tmp13_);
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = !_tmp14_;
#line 2097 "gnome-sudoku.c"
	} else {
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = FALSE;
#line 2101 "gnome-sudoku.c"
	}
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->play_custom_game_action;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp15_, _tmp9_);
#line 2107 "gnome-sudoku.c"
}


static void ___lambda16__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self) {
#line 398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda16_ ((Sudoku*) self);
#line 2114 "gnome-sudoku.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data2_;
#line 2123 "gnome-sudoku.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 2132 "gnome-sudoku.c"
		Sudoku* self;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data2_->self;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data2_->dialog);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block2Data, _data2_);
#line 2142 "gnome-sudoku.c"
	}
}


static void __lambda18_ (Block2Data* _data2_, gint response_id) {
	Sudoku* self;
	gint _tmp0_ = 0;
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data2_->self;
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = response_id;
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 430 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_show_new_game_screen (self);
#line 2158 "gnome-sudoku.c"
	} else {
		gint _tmp1_ = 0;
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = response_id;
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp1_ == ((gint) GTK_RESPONSE_REJECT)) {
#line 432 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_application_quit ((GApplication*) self);
#line 2167 "gnome-sudoku.c"
		}
	}
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data2_->dialog);
#line 2172 "gnome-sudoku.c"
}


static void ___lambda18__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda18_ (self, response_id);
#line 2179 "gnome-sudoku.c"
}


static void __lambda17_ (Sudoku* self) {
	Block2Data* _data2_;
	GtkButton* _tmp0_ = NULL;
	SudokuGame* _tmp1_ = NULL;
	SudokuSaver* _tmp17_ = NULL;
	SudokuGame* _tmp18_ = NULL;
	gint minutes = 0;
	SudokuGame* _tmp19_ = NULL;
	gdouble _tmp20_ = 0.0;
	gint _tmp21_ = 0;
	gchar* time_str = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	GtkApplicationWindow* _tmp24_ = NULL;
	GtkMessageDialog* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->_ref_count_ = 1;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->self = g_object_ref (self);
#line 409 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->play_custom_game_button;
#line 409 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
#line 410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->game;
#line 410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_stop_clock (_tmp1_);
#line 2214 "gnome-sudoku.c"
	{
		gint i = 0;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		i = 0;
#line 2219 "gnome-sudoku.c"
		{
			gboolean _tmp2_ = FALSE;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp2_ = TRUE;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			while (TRUE) {
#line 2226 "gnome-sudoku.c"
				gint _tmp4_ = 0;
				SudokuGame* _tmp5_ = NULL;
				SudokuBoard* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (!_tmp2_) {
#line 2234 "gnome-sudoku.c"
					gint _tmp3_ = 0;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					_tmp3_ = i;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					i = _tmp3_ + 1;
#line 2240 "gnome-sudoku.c"
				}
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp2_ = FALSE;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp4_ = i;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp5_ = self->priv->game;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp6_ = _tmp5_->board;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp7_ = sudoku_board_get_rows (_tmp6_);
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp8_ = _tmp7_;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (!(_tmp4_ < _tmp8_)) {
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					break;
#line 2258 "gnome-sudoku.c"
				}
				{
					gint j = 0;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					j = 0;
#line 2264 "gnome-sudoku.c"
					{
						gboolean _tmp9_ = FALSE;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
						_tmp9_ = TRUE;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
						while (TRUE) {
#line 2271 "gnome-sudoku.c"
							gint _tmp11_ = 0;
							SudokuGame* _tmp12_ = NULL;
							SudokuBoard* _tmp13_ = NULL;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							SudokuView* _tmp16_ = NULL;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							if (!_tmp9_) {
#line 2280 "gnome-sudoku.c"
								gint _tmp10_ = 0;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								_tmp10_ = j;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								j = _tmp10_ + 1;
#line 2286 "gnome-sudoku.c"
							}
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp9_ = FALSE;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp11_ = j;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp12_ = self->priv->game;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp13_ = _tmp12_->board;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp14_ = sudoku_board_get_cols (_tmp13_);
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp15_ = _tmp14_;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							if (!(_tmp11_ < _tmp15_)) {
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								break;
#line 2304 "gnome-sudoku.c"
							}
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp16_ = self->priv->view;
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							g_object_set ((GtkWidget*) _tmp16_, "can-focus", FALSE, NULL);
#line 2310 "gnome-sudoku.c"
						}
					}
				}
			}
		}
	}
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = self->priv->saver;
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = self->priv->game;
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_saver_add_game_to_finished (_tmp17_, _tmp18_, TRUE);
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = self->priv->game;
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = sudoku_game_get_total_time_played (_tmp19_);
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = MAX (1, ((gint) _tmp20_) / 60);
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	minutes = _tmp21_;
#line 420 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = ngettext ("Well done, you completed the puzzle in %d minute!", "Well done, you completed the puzzle in %d minutes!", (gulong) minutes);
#line 420 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = g_strdup_printf (_tmp22_, minutes);
#line 420 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	time_str = _tmp23_;
#line 423 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = self->priv->window;
#line 423 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp24_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, time_str);
#line 423 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp25_);
#line 423 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->dialog = _tmp25_;
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = _ ("_Quit");
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_add_button ((GtkDialog*) _data2_->dialog, _tmp26_, (gint) GTK_RESPONSE_REJECT);
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = _ ("Play _Again");
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_add_button ((GtkDialog*) _data2_->dialog, _tmp27_, (gint) GTK_RESPONSE_ACCEPT);
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data ((GtkDialog*) _data2_->dialog, "response", (GCallback) ___lambda18__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _data2_->dialog);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (time_str);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block2_data_unref (_data2_);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_ = NULL;
#line 2363 "gnome-sudoku.c"
}


static void ___lambda17__sudoku_board_completed (SudokuBoard* _sender, gpointer self) {
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda17_ ((Sudoku*) self);
#line 2370 "gnome-sudoku.c"
}


static void sudoku_start_game (Sudoku* self, SudokuBoard* board) {
	SudokuView* _tmp0_ = NULL;
	SudokuBoard* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	SudokuGame* _tmp5_ = NULL;
	GameMode _tmp6_ = 0;
	GSimpleAction* _tmp7_ = NULL;
	GSimpleAction* _tmp8_ = NULL;
	GSimpleAction* _tmp9_ = NULL;
	SudokuGame* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GSimpleAction* _tmp12_ = NULL;
	SudokuGame* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	SudokuGame* _tmp15_ = NULL;
	SudokuGame* _tmp16_ = NULL;
	SudokuGame* _tmp17_ = NULL;
	SudokuGame* _tmp18_ = NULL;
	SudokuView* _tmp19_ = NULL;
	SudokuView* _tmp20_ = NULL;
	SudokuView* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	GameMode _tmp23_ = 0;
	SudokuView* _tmp28_ = NULL;
	GSettings* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	SudokuView* _tmp31_ = NULL;
	GtkBox* _tmp32_ = NULL;
	SudokuView* _tmp33_ = NULL;
	SudokuGame* _tmp34_ = NULL;
	GameMode _tmp35_ = 0;
	SudokuGame* _tmp36_ = NULL;
	SudokuBoard* _tmp37_ = NULL;
#line 366 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 366 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (board != NULL);
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->view;
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ != NULL) {
#line 2415 "gnome-sudoku.c"
		GtkBox* _tmp1_ = NULL;
		SudokuView* _tmp2_ = NULL;
#line 369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->game_box;
#line 369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->view;
#line 369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_container_remove ((GtkContainer*) _tmp1_, (GtkWidget*) _tmp2_);
#line 2424 "gnome-sudoku.c"
	}
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_show_game_view (self);
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = board;
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = sudoku_game_new (_tmp3_);
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game);
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->game = _tmp4_;
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->game;
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->current_game_mode;
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_->mode = _tmp6_;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->undo_action;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp7_, FALSE);
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = self->priv->redo_action;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp8_, FALSE);
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_set_headerbar_title (self);
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = self->priv->clear_action;
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = self->priv->game;
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = sudoku_game_is_empty (_tmp10_);
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp9_, !_tmp11_);
#line 379 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = self->priv->play_custom_game_action;
#line 379 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = self->priv->game;
#line 379 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = sudoku_game_is_empty (_tmp13_);
#line 379 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp12_, !_tmp14_);
#line 381 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->game;
#line 381 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp15_, "tick", (GCallback) _sudoku_tick_cb_sudoku_game_tick, self, 0);
#line 382 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_ = self->priv->game;
#line 382 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp16_, "paused-changed", (GCallback) _sudoku_paused_changed_cb_sudoku_game_paused_changed, self, 0);
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = self->priv->game;
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_start_clock (_tmp17_);
#line 385 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = self->priv->game;
#line 385 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = sudoku_view_new (_tmp18_);
#line 385 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp19_);
#line 385 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->view);
#line 385 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->view = _tmp19_;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = self->priv->view;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp20_, 480, 480);
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = self->priv->view;
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = self->priv->show_possibilities;
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_show_possibilities (_tmp21_, _tmp22_);
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = self->priv->current_game_mode;
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp23_ == GAME_MODE_CREATE) {
#line 2504 "gnome-sudoku.c"
		SudokuView* _tmp24_ = NULL;
#line 390 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp24_ = self->priv->view;
#line 390 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_set_show_warnings (_tmp24_, TRUE);
#line 2510 "gnome-sudoku.c"
	} else {
		SudokuView* _tmp25_ = NULL;
		GSettings* _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp25_ = self->priv->view;
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp26_ = self->priv->settings;
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp27_ = g_settings_get_boolean (_tmp26_, "show-warnings");
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_set_show_warnings (_tmp25_, _tmp27_);
#line 2523 "gnome-sudoku.c"
	}
#line 393 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_ = self->priv->view;
#line 393 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = self->priv->settings;
#line 393 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp30_ = g_settings_get_boolean (_tmp29_, "highlighter");
#line 393 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_highlighter (_tmp28_, _tmp30_);
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp31_ = self->priv->view;
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp31_);
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp32_ = self->priv->game_box;
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp33_ = self->priv->view;
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_box_pack_start (_tmp32_, (GtkWidget*) _tmp33_, TRUE, TRUE, (guint) 0);
#line 398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp34_ = self->priv->game;
#line 398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp34_, "cell-changed", (GCallback) ___lambda16__sudoku_game_cell_changed, self, 0);
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp35_ = self->priv->current_game_mode;
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp35_ == GAME_MODE_CREATE) {
#line 406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2553 "gnome-sudoku.c"
	}
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp36_ = self->priv->game;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp37_ = _tmp36_->board;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp37_, "completed", (GCallback) ___lambda17__sudoku_board_completed, self, 0);
#line 2561 "gnome-sudoku.c"
}


static void sudoku_show_new_game_screen (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	GtkBox* _tmp3_ = NULL;
	GtkHeaderBar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GSimpleAction* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkImage* _tmp8_ = NULL;
	SudokuGame* _tmp9_ = NULL;
#line 440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 442 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 442 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "start_box");
#line 443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->back_button;
#line 443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, _tmp2_ != NULL);
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->undo_redo_box;
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
#line 445 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->headerbar;
#line 445 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _ ("Select Difficulty");
#line 445 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_header_bar_set_title (_tmp4_, _tmp5_);
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->print_action;
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp6_, FALSE);
#line 447 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->clock_label;
#line 447 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_hide ((GtkWidget*) _tmp7_);
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = self->priv->clock_image;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_hide ((GtkWidget*) _tmp8_);
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = self->priv->game;
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp9_ != NULL) {
#line 2614 "gnome-sudoku.c"
		SudokuGame* _tmp10_ = NULL;
#line 450 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = self->priv->game;
#line 450 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_stop_clock (_tmp10_);
#line 2620 "gnome-sudoku.c"
	}
}


static void sudoku_new_game_cb (Sudoku* self) {
#line 453 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 455 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_show_new_game_screen (self);
#line 2630 "gnome-sudoku.c"
}


static void __lambda19_ (Sudoku* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (res != NULL);
#line 2638 "gnome-sudoku.c"
	{
		GeeList* gen_boards = NULL;
		GAsyncResult* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		gpointer _tmp2_ = NULL;
		SudokuBoard* _tmp3_ = NULL;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = res;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = sudoku_generator_generate_boards_finish (_tmp0_, &_inner_error_);
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gen_boards = _tmp1_;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2653 "gnome-sudoku.c"
			goto __catch1_g_error;
		}
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = gee_list_get (gen_boards, 0);
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = (SudokuBoard*) _tmp2_;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_game (self, _tmp3_);
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_tmp3_);
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (gen_boards);
#line 2666 "gnome-sudoku.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_ = NULL;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 469 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = e->message;
#line 469 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_error ("gnome-sudoku.vala:469: Error: %s", _tmp4_);
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 2683 "gnome-sudoku.c"
	}
	__finally1:
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2694 "gnome-sudoku.c"
	}
}


static void ___lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda19_ ((Sudoku*) self, source_object, res);
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_unref (self);
#line 2704 "gnome-sudoku.c"
}


static void sudoku_create_game_cb (Sudoku* self) {
#line 458 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->current_game_mode = GAME_MODE_CREATE;
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_generator_generate_boards_async (1, DIFFICULTY_CATEGORY_CUSTOM, NULL, ___lambda19__gasync_ready_callback, g_object_ref (self));
#line 2715 "gnome-sudoku.c"
}


static void __lambda15_ (Sudoku* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (res != NULL);
#line 2723 "gnome-sudoku.c"
	{
		GeeList* gen_boards = NULL;
		GAsyncResult* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		GtkButton* _tmp2_ = NULL;
		gpointer _tmp3_ = NULL;
		SudokuBoard* _tmp4_ = NULL;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = res;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = sudoku_generator_generate_boards_finish (_tmp0_, &_inner_error_);
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gen_boards = _tmp1_;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2739 "gnome-sudoku.c"
			goto __catch2_g_error;
		}
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->back_button;
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = gee_list_get (gen_boards, 0);
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = (SudokuBoard*) _tmp3_;
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_game (self, _tmp4_);
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_tmp4_);
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (gen_boards);
#line 2756 "gnome-sudoku.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_ = NULL;
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = e->message;
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_error ("gnome-sudoku.vala:494: Error: %s", _tmp5_);
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 2773 "gnome-sudoku.c"
	}
	__finally2:
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2784 "gnome-sudoku.c"
	}
}


static void ___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda15_ ((Sudoku*) self, source_object, res);
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_unref (self);
#line 2794 "gnome-sudoku.c"
}


static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty) {
	DifficultyCategory selected_difficulty = 0;
	GVariant* _tmp0_ = NULL;
	gint32 _tmp1_ = 0;
	GtkButton* _tmp2_ = NULL;
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (action != NULL);
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = difficulty;
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_variant_get_int32 (_tmp0_);
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	selected_difficulty = (DifficultyCategory) _tmp1_;
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->back_button;
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->current_game_mode = GAME_MODE_PLAY;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_generator_generate_boards_async (1, selected_difficulty, NULL, ___lambda15__gasync_ready_callback, g_object_ref (self));
#line 2821 "gnome-sudoku.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data3_;
#line 2830 "gnome-sudoku.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 2839 "gnome-sudoku.c"
		Sudoku* self;
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data3_->self;
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data3_->dialog);
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block3Data, _data3_);
#line 2849 "gnome-sudoku.c"
	}
}


static void __lambda20_ (Block3Data* _data3_, gint response_id) {
	Sudoku* self;
	gint _tmp0_ = 0;
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data3_->self;
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = response_id;
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 2863 "gnome-sudoku.c"
		SudokuGame* _tmp1_ = NULL;
		SudokuView* _tmp2_ = NULL;
		GSimpleAction* _tmp3_ = NULL;
		GSimpleAction* _tmp4_ = NULL;
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->game;
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_reset (_tmp1_);
#line 507 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->view;
#line 507 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_clear (_tmp2_);
#line 508 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->undo_action;
#line 508 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp3_, FALSE);
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->redo_action;
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp4_, FALSE);
#line 2884 "gnome-sudoku.c"
	}
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data3_->dialog);
#line 2888 "gnome-sudoku.c"
}


static void ___lambda20__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda20_ (self, response_id);
#line 2895 "gnome-sudoku.c"
}


static void sudoku_reset_cb (Sudoku* self) {
	Block3Data* _data3_;
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMessageDialog* _tmp2_ = NULL;
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->_ref_count_ = 1;
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->self = g_object_ref (self);
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _ ("Reset the board to its original state?");
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_OK_CANCEL, _tmp1_);
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp2_);
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->dialog = _tmp2_;
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data ((GtkDialog*) _data3_->dialog, "response", (GCallback) ___lambda20__gtk_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 514 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _data3_->dialog);
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block3_data_unref (_data3_);
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_ = NULL;
#line 2930 "gnome-sudoku.c"
}


static void sudoku_show_game_view (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkBox* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkImage* _tmp5_ = NULL;
	SudokuGame* _tmp6_ = NULL;
	GameMode _tmp8_ = 0;
#line 517 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "frame");
#line 520 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->back_button;
#line 520 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
#line 521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->undo_redo_box;
#line 521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
#line 522 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_action;
#line 522 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, TRUE);
#line 523 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->clock_label;
#line 523 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp4_);
#line 524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->clock_image;
#line 524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp5_);
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->game;
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp6_ != NULL) {
#line 2973 "gnome-sudoku.c"
		SudokuGame* _tmp7_ = NULL;
#line 527 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = self->priv->game;
#line 527 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_resume_clock (_tmp7_);
#line 2979 "gnome-sudoku.c"
	}
#line 529 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = self->priv->current_game_mode;
#line 529 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp8_ == GAME_MODE_PLAY) {
#line 2985 "gnome-sudoku.c"
		GtkButton* _tmp9_ = NULL;
		GtkButton* _tmp10_ = NULL;
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = self->priv->play_custom_game_button;
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp9_, FALSE);
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = self->priv->play_pause_button;
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp10_, TRUE);
#line 2996 "gnome-sudoku.c"
	} else {
		GtkLabel* _tmp11_ = NULL;
		GtkImage* _tmp12_ = NULL;
		GtkButton* _tmp13_ = NULL;
		GtkButton* _tmp14_ = NULL;
#line 536 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = self->priv->clock_label;
#line 536 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_hide ((GtkWidget*) _tmp11_);
#line 537 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = self->priv->clock_image;
#line 537 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_hide ((GtkWidget*) _tmp12_);
#line 538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = self->priv->play_custom_game_button;
#line 538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp13_, TRUE);
#line 539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = self->priv->play_pause_button;
#line 539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp14_, FALSE);
#line 3018 "gnome-sudoku.c"
	}
}


static void sudoku_set_headerbar_title (Sudoku* self) {
	GameMode _tmp0_ = 0;
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->current_game_mode;
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == GAME_MODE_PLAY) {
#line 3031 "gnome-sudoku.c"
		GtkHeaderBar* _tmp1_ = NULL;
		SudokuGame* _tmp2_ = NULL;
		SudokuBoard* _tmp3_ = NULL;
		DifficultyCategory _tmp4_ = 0;
		DifficultyCategory _tmp5_ = 0;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->headerbar;
#line 546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->game;
#line 546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = _tmp2_->board;
#line 546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = sudoku_board_get_difficulty_category (_tmp3_);
#line 546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = _tmp4_;
#line 546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = difficulty_category_to_string (_tmp5_);
#line 546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = _tmp6_;
#line 546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_title (_tmp1_, _tmp7_);
#line 546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp7_);
#line 3057 "gnome-sudoku.c"
	} else {
		GtkHeaderBar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = self->priv->headerbar;
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = _ ("Create Puzzle");
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_title (_tmp8_, _tmp9_);
#line 3067 "gnome-sudoku.c"
	}
}


static void sudoku_back_cb (Sudoku* self) {
#line 551 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_show_game_view (self);
#line 554 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_set_headerbar_title (self);
#line 3079 "gnome-sudoku.c"
}


static void sudoku_undo_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SudokuView* _tmp6_ = NULL;
#line 557 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 559 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 559 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 559 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 3101 "gnome-sudoku.c"
	}
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_undo (_tmp2_);
#line 562 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->undo_action;
#line 562 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 562 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_undostack_null (_tmp4_);
#line 562 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->view;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
#line 3119 "gnome-sudoku.c"
}


static void sudoku_redo_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SudokuView* _tmp6_ = NULL;
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 568 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 568 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 568 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 3141 "gnome-sudoku.c"
	}
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_redo (_tmp2_);
#line 571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->redo_action;
#line 571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
#line 571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->view;
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
#line 3159 "gnome-sudoku.c"
}


static void sudoku_print_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
	SudokuGame* _tmp6_ = NULL;
	SudokuBoard* _tmp7_ = NULL;
	SudokuBoard* _tmp8_ = NULL;
	SudokuBoard* _tmp9_ = NULL;
	SudokuPrinter* printer = NULL;
	GeeArrayList* _tmp10_ = NULL;
	GtkApplicationWindow* _tmp11_ = NULL;
	SudokuPrinter* _tmp12_ = NULL;
	SudokuPrinter* _tmp13_ = NULL;
	GSimpleAction* _tmp14_ = NULL;
	GSimpleAction* _tmp15_ = NULL;
#line 575 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 577 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 577 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 577 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 3192 "gnome-sudoku.c"
	}
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->print_action;
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp2_, FALSE);
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_multiple_action;
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, FALSE);
#line 582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	list = _tmp4_;
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = list;
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->game;
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = _tmp6_->board;
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = sudoku_board_clone (_tmp7_);
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = _tmp8_;
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp9_);
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (_tmp9_);
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = list;
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = self->priv->window;
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = sudoku_printer_new ((GeeList*) _tmp10_, (GtkWindow*) _tmp11_);
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	printer = _tmp12_;
#line 585 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = printer;
#line 585 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_printer_print_sudoku (_tmp13_);
#line 587 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = self->priv->print_action;
#line 587 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp14_, TRUE);
#line 588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->print_multiple_action;
#line 588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp15_, TRUE);
#line 575 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (printer);
#line 575 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (list);
#line 3244 "gnome-sudoku.c"
}


static void __lambda25_ (Sudoku* self) {
	GSimpleAction* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->print_action;
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->main_stack;
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, g_strcmp0 (_tmp2_, "frame") == 0);
#line 598 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_multiple_action;
#line 598 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, TRUE);
#line 3265 "gnome-sudoku.c"
}


static void ___lambda25__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda25_ ((Sudoku*) self);
#line 3272 "gnome-sudoku.c"
}


static void sudoku_print_multiple_cb (Sudoku* self) {
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	PrintDialog* print_dialog = NULL;
	SudokuSaver* _tmp2_ = NULL;
	GtkApplicationWindow* _tmp3_ = NULL;
	PrintDialog* _tmp4_ = NULL;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 593 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->print_action;
#line 593 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, FALSE);
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->print_multiple_action;
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp1_, FALSE);
#line 595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->saver;
#line 595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->window;
#line 595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = print_dialog_new (_tmp2_, (GtkWindow*) _tmp3_);
#line 595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp4_);
#line 595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	print_dialog = _tmp4_;
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GtkWidget*) print_dialog, "destroy", (GCallback) ___lambda25__gtk_widget_destroy, self, 0);
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_run ((GtkDialog*) print_dialog);
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (print_dialog);
#line 3309 "gnome-sudoku.c"
}


static void sudoku_help_cb (Sudoku* self) {
	GError * _inner_error_ = NULL;
#line 603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 3317 "gnome-sudoku.c"
	{
		GtkApplicationWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 607 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = self->priv->window;
#line 607 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 607 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 607 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_show_uri (_tmp1_, "help:gnome-sudoku", _tmp2_, &_inner_error_);
#line 607 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3332 "gnome-sudoku.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 605 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 605 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 611 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = e;
#line 611 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = _tmp3_->message;
#line 611 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_warning ("gnome-sudoku.vala:611: Unable to open help: %s", _tmp4_);
#line 605 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 3354 "gnome-sudoku.c"
	}
	__finally3:
#line 605 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 605 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 605 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 605 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 3365 "gnome-sudoku.c"
	}
}


static void sudoku_about_cb (Sudoku* self) {
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _ ("Sudoku");
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = sudoku_generator_qqwing_version ();
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = _tmp2_;
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = g_strdup_printf ("The popular Japanese logic puzzle\n\nPuzzles generated by QQwing %s", _tmp3_);
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _tmp4_;
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = _ (_tmp5_);
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = _ ("translator-credits");
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp0_, "program-name", _tmp1_, "logo-icon-name", "gnome-sudoku", "version", VERSION, "comments", _tmp6_, "copyright", "Copyright © 2005–2008 Thomas M. Hinkle\n" \
"Copyright © 2010–2011 Robert Ancell\n" \
"Copyright © 2014 Parin Porecha", "license-type", GTK_LICENSE_GPL_3_0, "authors", SUDOKU_authors, "artists", NULL, "translator-credits", _tmp7_, "website", "https://wiki.gnome.org/Apps/Sudoku/", NULL);
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (_tmp5_);
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (_tmp3_);
#line 3403 "gnome-sudoku.c"
}


gint sudoku_main (gchar** args, int args_length1) {
	gint result = 0;
	Sudoku* _tmp0_ = NULL;
	Sudoku* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 641 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = sudoku_new ();
#line 641 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _tmp0_;
#line 641 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = args;
#line 641 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2__length1 = args_length1;
#line 641 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = g_application_run ((GApplication*) _tmp1_, _tmp2__length1, _tmp2_);
#line 641 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = _tmp3_;
#line 641 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (_tmp1_);
#line 641 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = _tmp4_;
#line 641 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 3433 "gnome-sudoku.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 639 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return sudoku_main (argv, argc);
#line 3443 "gnome-sudoku.c"
}


static void sudoku_class_init (SudokuClass * klass) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_type_class_add_private (klass, sizeof (SudokuPrivate));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->handle_local_options = sudoku_real_handle_local_options;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->startup = sudoku_real_startup;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->activate = sudoku_real_activate;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->shutdown = sudoku_real_shutdown;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_finalize;
#line 3462 "gnome-sudoku.c"
}


static void sudoku_instance_init (Sudoku * self) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv = SUDOKU_GET_PRIVATE (self);
#line 60 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->show_possibilities = FALSE;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->current_game_mode = GAME_MODE_PLAY;
#line 3473 "gnome-sudoku.c"
}


static void sudoku_finalize (GObject* obj) {
	Sudoku * self;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU, Sudoku);
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->settings);
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_custom_game_button);
#line 32 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_pause_button);
#line 33 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_pause_label);
#line 34 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clock_label);
#line 35 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clock_image);
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->window);
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game);
#line 40 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->view);
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game_box);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_redo_box);
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->back_button);
#line 49 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->saver);
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_action);
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->redo_action);
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clear_action);
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_action);
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_multiple_action);
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->pause_action);
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_custom_game_action);
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->new_game_action);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_OBJECT_CLASS (sudoku_parent_class)->finalize (obj);
#line 3529 "gnome-sudoku.c"
}


GType sudoku_get_type (void) {
	static volatile gsize sudoku_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sudoku), 0, (GInstanceInitFunc) sudoku_instance_init, NULL };
		GType sudoku_type_id;
		sudoku_type_id = g_type_register_static (gtk_application_get_type (), "Sudoku", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_type_id__volatile, sudoku_type_id);
	}
	return sudoku_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



