--  Copyright 2005-2009 Simon Wright <simon@pushface.org>

--  This package is free software; you can redistribute it and/or
--  modify it under terms of the GNU General Public License as
--  published by the Free Software Foundation; either version 2, or
--  (at your option) any later version. This package is distributed in
--  the hope that it will be useful, but WITHOUT ANY WARRANTY; without
--  even the implied warranty of MERCHANTABILITY or FITNESS FOR A
--  PARTICULAR PURPOSE. See the GNU General Public License for more
--  details. You should have received a copy of the GNU General Public
--  License distributed with this package; see file COPYING.  If not,
--  write to the Free Software Foundation, 59 Temple Place - Suite
--  330, Boston, MA 02111-1307, USA.

--  As a special exception, if other files instantiate generics from
--  this unit, or you link this unit with other files to produce an
--  executable, this unit does not by itself cause the resulting
--  executable to be covered by the GNU General Public License.  This
--  exception does not however invalidate any other reasons why the
--  executable file might be covered by the GNU Public License.

--  $Revision: 1415 $
--  $Date: 2009-06-15 22:10:43 +0200 (Mo, 15. Jun 2009) $
--  $Author: simonjwright $

--  This implementation is for GNAT on Intel i86 hardware (Linux,
--  Windows).

with Ada.Unchecked_Conversion;
with System.Machine_Code;

separate (BC.Support.High_Resolution_Time)
function Clock return Time is

   type Half is (Low, High);
   type Low_High is array (Half) of Interfaces.Unsigned_32;

   Lower, Upper : Interfaces.Unsigned_32;

   function To_Time is new Ada.Unchecked_Conversion (Low_High, Time);

begin

   System.Machine_Code.Asm
     ("rdtsc" & ASCII.LF & ASCII.HT &
        "movl %%eax, %0"& ASCII.LF & ASCII.HT &
        "movl %%edx, %1",
      Outputs => (Interfaces.Unsigned_32'Asm_Output ("=g", Lower),
                  Interfaces.Unsigned_32'Asm_Output ("=g", Upper)),
      Clobber => "eax, edx",
      Volatile => True);

   return To_Time ((Low => Lower, High => Upper));

end Clock;

--  for emacs:
--  Local Variables:
--  mode: ada
--  End:
--  vim: textwidth=0 nowrap tabstop=8 shiftwidth=3 softtabstop=3 expandtab
--  vim: filetype=ada encoding=latin1 fileformat=unix
