#include "epr_api.h"
#include "epr_dddb.h"

static const struct RecordDescriptor MER_LRC_2P_MDSR_cl_thick_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start Time of DSR"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"cl_opt_thick_pix", e_tid_uchar, NULL, 1, "sceneRasterWidth", "cloud optical thickness pixel #1- #281"}
};

static const struct RecordDescriptor MER_LRC_2P_MDSR_cl_top_press_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start Time of DSR"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"cl_top_press_pix", e_tid_uchar, NULL, 1, "sceneRasterWidth", "cloud top pressure pixel #1- #281"}
};

static const struct RecordDescriptor MER_LRC_2P_MDSR_flag_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start Time of DSR"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"pixel_info", e_tid_uchar, "counts", 1, "3*sceneRasterWidth", "Flags associated with pixel #1 - #281"}
};

static const struct RecordDescriptor MER_LRC_2P_MDSR_twv_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start Time of DSR"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"wvapour_cont_pix", e_tid_uchar, NULL, 1, "sceneRasterWidth", "Water Vapour Content pixel #1- #281"}
};

static const struct RecordDescriptor MER_RRC_2P_GADS_sfgi_meris_rec_data[] = {
    {"sf_cl_opt_thick", e_tid_float, NULL, 4, "1", "scaling factor - Cloud optical thickness"},
    {"sf_cloud_top_press", e_tid_float, NULL, 4, "1", "scaling factor - Cloud Top Pressure"},
    {"sf_wvapour", e_tid_float, NULL, 4, "1", "scaling factor - Water vapour"},
    {"off_cl_opt_thick", e_tid_float, NULL, 4, "1", "offset-Cloud optical thickness"},
    {"off_cloud_top_press", e_tid_float, "hPa", 4, "1", "offset - Cloud Top Pressure"},
    {"off_wvapour", e_tid_float, "g.cm-2", 4, "1", "offset-Water vapour"},
    {"spare_1", e_tid_spare, NULL, 52, "1", "Spare"}
};

static const struct RecordDescriptor MER_RRV_2P_GADS_sfgi_meris_rec_data[] = {
    {"sf_toa_veg_ind", e_tid_float, NULL, 4, "1", "scaling factor - TOA Vegetation Index"},
    {"sf_boa_veg_ind", e_tid_float, NULL, 4, "1", "scaling factor - BOA Vegetation Index"},
    {"off_toa_veg_ind", e_tid_float, NULL, 4, "1", "offset-TOA Vegetation Index"},
    {"off_boa_veg_ind", e_tid_float, NULL, 4, "1", "offset-BOA Vegetation Index"},
    {"spare_1", e_tid_spare, NULL, 60, "1", "Spare"}
};

static const struct RecordDescriptor MER_RR__1P_ADSR_sq_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Time of the first line in the MDS corresponding to this record."},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment Flag (Set to 1 if all the records in all the bands are blank for the period corresponding to this record, set to zero otherwise)"},
    {"range_flag", e_tid_ushort, "flag", 2, "5", "Out of Range flag. For every band, when the number of out of range samples is above a given threshold then it is set to TRUE, otherwise it is left to FALSE. The 15 flags for all the bands of a module are stored in an unsigned integer. To have this informati"},
    {"range_blind_flag", e_tid_ushort, "flag", 2, "5", "Out of Range blind flag.  Flags set to TRUE when the number of out of range blind spectral samples per module is above a given threshold. Flag ordering same as described in field 3."}
};

static const struct RecordDescriptor MER_RR__1P_ADSR_tie_pt_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start time of the measurement"},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment Flag (set to 1 if all MDSRs corresponding to this ADSR are blank, set to zero otherwise)"},
    {"lat_tie_pt", e_tid_int, "(1e-6) degrees", 4, "tiePointGridWidth", "Latitude of the tie points WGS84, positive N"},
    {"long_tie_pt", e_tid_int, "(1e-6) degrees", 4, "tiePointGridWidth", "Longitude of the tie points WGS84, Greenwich origin, positive E"},
    {"dem_alt_tie_pt", e_tid_int, "m", 4, "tiePointGridWidth", "DEM altitude"},
    {"dem_rough", e_tid_uint, "m", 4, "tiePointGridWidth", "DEM roughness"},
    {"dem_lat_corrc", e_tid_int, "(1e-6) degrees", 4, "tiePointGridWidth", "DEM latitude corrections"},
    {"dem_long_corrc", e_tid_int, "(1e-6) degrees", 4, "tiePointGridWidth", "DEM longitude corrections"},
    {"sun_zen_ang", e_tid_uint, "(1e-6) degrees", 4, "tiePointGridWidth", "Sun zenith angles"},
    {"sun_azi_ang", e_tid_int, "(1e-6) degrees", 4, "tiePointGridWidth", "Sun azimuth angles"},
    {"vw_zen_ang", e_tid_uint, "(1e-6) degrees", 4, "tiePointGridWidth", "Viewing zenith angles"},
    {"vw_azi_ang", e_tid_int, "(1e-6) degrees", 4, "tiePointGridWidth", "Viewing azimuth angles"},
    {"zon_wind", e_tid_short, "m*s-1", 2, "tiePointGridWidth", "Zonal winds"},
    {"meri_wind", e_tid_short, "m*s-1", 2, "tiePointGridWidth", "Meridional winds"},
    {"atm_pres", e_tid_ushort, "hPa", 2, "tiePointGridWidth", "Mean sea level pressures"},
    {"tot_ozone", e_tid_ushort, "DU", 2, "tiePointGridWidth", "Total ozone"},
    {"rel_humid", e_tid_ushort, "%", 2, "tiePointGridWidth", "Relative humidity"}
};

static const struct RecordDescriptor MER_RR__1P_GADS_sfgi_meris_rec_data[] = {
    {"sf_alt", e_tid_float, NULL, 4, "1", "scaling factor - altitude"},
    {"sf_rough", e_tid_float, NULL, 4, "1", "scaling factor - roughness"},
    {"sf_zon_wind", e_tid_float, NULL, 4, "1", "scaling factor - zonal wind"},
    {"sf_merr_wind", e_tid_float, NULL, 4, "1", "scaling factor - meridional wind"},
    {"sf_atm_pres", e_tid_float, NULL, 4, "1", "scaling factor - atmospheric pressure"},
    {"sf_ozone", e_tid_float, NULL, 4, "1", "scaling factor - ozone"},
    {"sf_rel_hum", e_tid_float, NULL, 4, "1", "scaling factor - relative humidity"},
    {"sf_rad", e_tid_float, NULL, 4, "15", "scaling factor - radiances"},
    {"gain_set", e_tid_uchar, NULL, 1, "5*16", "Gain setting"},
    {"samp_rate", e_tid_uint, "(10-6) s", 4, "1", "sampling rate"},
    {"sun_spec_flux", e_tid_float, "LU", 4, "15", "Sun Spectral Flux (for bands 1-15)"},
    {"spare_1", e_tid_spare, NULL, 60, "1", "Spare"}
};

static const struct RecordDescriptor MER_RR__1P_MDSR_16_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start time of the Data Set Record"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"flags", e_tid_uchar, NULL, 1, "sceneRasterWidth", "Flags and spectral shift index"},
    {"detector_index", e_tid_short, NULL, 2, "sceneRasterWidth", "Flags and spectral shift index"}
};

static const struct RecordDescriptor MER_RR__1P_MDSR_16_IODD5_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start time of the Data Set Record"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"pixel_info", e_tid_uchar, NULL, 1, "2*sceneRasterWidth", "Flags and spectral shift index"}
};

static const struct RecordDescriptor MER_RR__1P_MDSR_1_15_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start time of the Data Set Record"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"toa_rad", e_tid_ushort, "LU", 2, "sceneRasterWidth", "TOA radiance"}
};

static const struct RecordDescriptor MER_RR__2P_ADSR_sq_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start time of the measurement"},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment Flag (set to 1 if all MDSRs corresponding to this ADSR are blank, set to zero otherwise)"},
    {"perc_water_abs_aero", e_tid_uchar, "%", 1, "1", "% of water pixels having absorbing aerosols"},
    {"perc_water", e_tid_uchar, "%", 1, "1", "% of water pixels"},
    {"perc_ddv_land", e_tid_uchar, "%", 1, "1", "% of DDV land pixels"},
    {"perc_land", e_tid_uchar, "%", 1, "1", "% of land pixels"},
    {"perc_cloud", e_tid_uchar, "%", 1, "1", "% of cloud pixels"},
    {"perc_low_poly_press", e_tid_uchar, "%", 1, "1", "% of pixels with low polynomial pressure"},
    {"perc_low_neural_press", e_tid_uchar, "%", 1, "1", "% of pixels with low Neural Network pressure"},
    {"perc_out_ran_inp_wvapour", e_tid_uchar, "%", 1, "1", "% of pixels with out of range inputs for water vapour proc."},
    {"per_out_ran_outp_wvapour", e_tid_uchar, "%", 1, "1", "% of pixels with out of range outputs for water vapour proc."},
    {"perc_out_range_inp_cl", e_tid_uchar, "%", 1, "1", "% of pixels with out of range inputs for Cloud proc."},
    {"perc_out_ran_outp_cl", e_tid_uchar, "%", 1, "1", "% of pixels with out of range outputs for Cloud proc."},
    {"perc_in_ran_inp_land", e_tid_uchar, "%", 1, "1", "% of pixels with out of range inputs for Land proc."},
    {"perc_out_ran_outp_land", e_tid_uchar, "%", 1, "1", "% of pixels with out of range outputs for Land proc."},
    {"perc_out_ran_inp_ocean", e_tid_uchar, "%", 1, "1", "% of pixels with out of range inputs for Ocean proc."},
    {"perc_out_ran_outp_ocean", e_tid_uchar, "%", 1, "1", "% of pixels with out of range outputs for Ocean proc."},
    {"perc_out_ran_inp_case1", e_tid_uchar, "%", 1, "1", "% of pixels with out of range inputs for Case 1 proc."},
    {"perc_out_ran_outp_case1", e_tid_uchar, "%", 1, "1", "% of pixels with out of range outputs for Case 1 proc."},
    {"perc_out_ran_inp_case2", e_tid_uchar, "%", 1, "1", "% of pixels with. out of range inputs for Case 2 proc."},
    {"perc_out_ran_outp_case2", e_tid_uchar, "%", 1, "1", "% of pixels with. out of range outputs for Case 2 proc."}
};

static const struct RecordDescriptor MER_RR__2P_GADS_sfgi_meris_rec_data[] = {
    {"sf_alt", e_tid_float, NULL, 4, "1", "scaling factor - altitude"},
    {"sf_rough", e_tid_float, NULL, 4, "1", "scaling factor - roughness"},
    {"sf_zon_wind", e_tid_float, NULL, 4, "1", "scaling factor - zonal wind"},
    {"sf_merr_wind", e_tid_float, NULL, 4, "1", "scaling factor - meridional wind"},
    {"sf_atm_pres", e_tid_float, NULL, 4, "1", "scaling factor - atmospheric pressure"},
    {"sf_ozone", e_tid_float, NULL, 4, "1", "scaling factor - ozone"},
    {"sf_rel_humid", e_tid_float, NULL, 4, "1", "scaling factor - relative humidity"},
    {"sf_reflec", e_tid_float, NULL, 4, "13", "scaling factor - reflectances"},
    {"sf_algal_pig_ind", e_tid_float, NULL, 4, "1", "scaling factor - Algal pigment index"},
    {"sf_yellow_subs", e_tid_float, NULL, 4, "1", "scaling factor - Yellow substance"},
    {"sf_susp_sed", e_tid_float, NULL, 4, "1", "scaling factor - Suspended sediment"},
    {"sf_aero_epsilon", e_tid_float, NULL, 4, "1", "scaling factor - Aerosol epsilon"},
    {"sf_aer_opt_thick", e_tid_float, NULL, 4, "1", "scaling factor - Aerosol optical thickness"},
    {"sf_cl_opt_thick", e_tid_float, NULL, 4, "1", "scaling factor - Cloud optical thickness"},
    {"sf_surf_pres", e_tid_float, NULL, 4, "1", "scaling factor - Surface pressure"},
    {"sf_wvapour", e_tid_float, NULL, 4, "1", "scaling factor - Water vapour"},
    {"sf_photosyn_rad", e_tid_float, NULL, 4, "1", "scaling factor - Photosynthetically active radiation"},
    {"sf_toa_veg", e_tid_float, NULL, 4, "1", "scaling factor - TOA Vegetation index"},
    {"sf_boa_veg", e_tid_float, NULL, 4, "1", "scaling factor - BOA Vegetation index"},
    {"sf_cloud_albedo", e_tid_float, NULL, 4, "1", "scaling factor - Cloud Albedo"},
    {"sf_cloud_top_press", e_tid_float, NULL, 4, "1", "scaling factor - Cloud Top Pressure"},
    {"off_reflec", e_tid_float, NULL, 4, "13", "offset - reflectances"},
    {"off_algal", e_tid_float, "log10(mg.m-3)", 4, "1", "offset - Algal pigment index"},
    {"off_yellow_subs", e_tid_float, "m-1", 4, "1", "offset - Yellow substance"},
    {"off_total_susp", e_tid_float, "log10(g.m-3)", 4, "1", "offset - Total suspended matter"},
    {"off_aero_epsilon", e_tid_float, NULL, 4, "1", "offset - Aerosol epsilon"},
    {"off_aer_opt_thick", e_tid_float, NULL, 4, "1", "offset - Aerosol optical thickness"},
    {"off_cl_opt_thick", e_tid_float, NULL, 4, "1", "offset - Cloud optical thickness"},
    {"off_surf_pres", e_tid_float, "hPa", 4, "1", "offset - Surface pressure"},
    {"off_wvapour", e_tid_float, "g.cm-2", 4, "1", "offset - Water vapour"},
    {"off_photosyn_rad", e_tid_float, "W.m-2", 4, "1", "offset - Photosynthetically active radiation"},
    {"off_toa_veg", e_tid_float, NULL, 4, "1", "offset - TOA Vegetation index"},
    {"off_boa_veg", e_tid_float, NULL, 4, "1", "offset - BOA Vegetation index"},
    {"off_cloud_albedo", e_tid_float, NULL, 4, "1", "offset - Cloud Albedo"},
    {"off_cloud_top_press", e_tid_float, "hPa", 4, "1", "offset - Cloud Top Pressure"},
    {"gain_set", e_tid_uchar, NULL, 1, "5*16", "Gain setting"},
    {"sampl_rate", e_tid_uint, "(10-6) s", 4, "1", "sampling rate"},
    {"sun_spec_flux", e_tid_float, "LU", 4, "15", "Sun Spectral Flux (for bands 1-15)"},
    {"sf_rect_refl_nir", e_tid_float, NULL, 4, "1", "scaling factor - Rectified near infrared reflectance"},
    {"off_rect_refl_nir", e_tid_float, NULL, 4, "1", "offset - Rectified near infrared reflectance"},
    {"sf_rect_refl_red", e_tid_float, NULL, 4, "1", "scaling factor - Rectified infrared reflectance"},
    {"off_rect_refl_red", e_tid_float, NULL, 4, "1", "offset - Rectified infrared reflectance"},
    {"spare_1", e_tid_spare, NULL, 1, "44", "spare"}
};

static const struct RecordDescriptor MER_RR__2P_MDSR_14_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start Time of DSR"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"wvapour_content_pix", e_tid_uchar, "g.cm-2", 1, "sceneRasterWidth", "Water vapour content pixels"}
};

static const struct RecordDescriptor MER_RR__2P_MDSR_15_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start Time of DSR"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"algal_toavi_cl_pix", e_tid_uchar, "mg.m-3, or -, or hPa", 1, "sceneRasterWidth", "Algal I or TOAVI or cloud top pressure pixels"}
};

static const struct RecordDescriptor MER_RR__2P_MDSR_16_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start Time of DSR"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"ys_tsm_pix", e_tid_uchar, NULL, 1, "2*sceneRasterWidth", "Yellow Substance, Total Suspended Matter or Rectified Reflectances pixels, interleaved by pixel"}
};

static const struct RecordDescriptor MER_RR__2P_MDSR_17_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start Time of DSR"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"algal2_boavi_pix", e_tid_uchar, "mg.m-3 or -", 1, "sceneRasterWidth", "Algal II or BOAVI pixels"}
};

static const struct RecordDescriptor MER_RR__2P_MDSR_18_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start Time of DSR"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"par_sp_cl_albe_pix", e_tid_uchar, "W.m-2 or -", 1, "sceneRasterWidth", "PAR or surface pressure or cloud albedo pixels"}
};

static const struct RecordDescriptor MER_RR__2P_MDSR_19_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start Time of DSR"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"aer_cl_opt_pix", e_tid_uchar, NULL, 1, "2*sceneRasterWidth", "Aerosol Angstrom exponent or cloud type and optical thickness pixels, interleaved by pixel"}
};

static const struct RecordDescriptor MER_RR__2P_MDSR_19_IODD6_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start Time of DSR"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"air_cl_opt_pix", e_tid_uchar, NULL, 1, "2*sceneRasterWidth", "Aerosol epsilon or cloud type and optical thickness pixels, interleaved by pixel"}
};

static const struct RecordDescriptor MER_RR__2P_MDSR_1_13_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start Time of the measurement"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"norm_surf_reflec_pix", e_tid_ushort, NULL, 2, "sceneRasterWidth", "Normalised surface reflectance pixels"}
};

static const struct RecordDescriptor MER_RR__2P_MDSR_20_meris_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Start Time of DSR"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"pixel_info", e_tid_uchar, "counts", 1, "3*sceneRasterWidth", "Flags associated with pixels"}
};

static const struct RecordDescriptor ATS_AR__2P_MDSR_lr_large_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"lat", e_tid_int, "(1e-6) degrees", 4, "1", "Latitude of  cell"},
    {"lon", e_tid_int, "(1e-6) degrees", 4, "1", "Longitude of  cell"},
    {"m_actrk_pix_num", e_tid_short, NULL, 2, "1", "Mean across-track pixel number"},
    {"pix_nad", e_tid_short, NULL, 2, "1", "Number of filled pixels in cell, nadir view"},
    {"pix_ls_nad", e_tid_short, NULL, 2, "1", "Number of filled pixels in cell over land surface, nadir view"},
    {"perc_cl_pix_ls_nad", e_tid_short, NULL, 2, "1", "Percentage of cloudy pixels in cell over land surface, nadir view"},
    {"lat_corr_nad", e_tid_int, "(1e-6) degrees", 4, "1", "Topographic latitude correction, nadir view"},
    {"long_corr_nad", e_tid_int, "(1e-6) degrees", 4, "1", "Topographic longitude correction, nadir view"},
    {"sa_12bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 12 micron BT of all clear pixels (nadir view)"},
    {"sd_12bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_11bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 11 micron BT of all clear pixels (nadir view)"},
    {"sd_11bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_37bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 3.7 micron BT of all clear pixels (nadir view)"},
    {"sd_37bt_clr_nad", e_tid_int, "%/1000", 4, "1", "Standard deviation of above"},
    {"sa_16toa_clr_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 1.6 micron TOA reflectance of all clear pixels (nadir view)"},
    {"sd_16toa_clr_nad", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_87toa_clr_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.87 micron TOA reflectance of all clear pixels (nadir view)"},
    {"sd_87toa_clr_nad", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_67toa_clr_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.67 micron TOA reflectance of all clear pixels (nadir view)"},
    {"sd_67toa_clr_nad", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_55toa_clr_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.55 micron TOA reflectance of all clear pixels (nadir view)"},
    {"sd_55toa_clr_nad", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_12bt_cl_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 12 micron BT of all cloudy pixels (nadir view)"},
    {"sd_12bt_cl_nad", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_11bt_cl_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 11 micron BT of all cloudy pixels (nadir view)"},
    {"sd_11bt_cl_nad", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_37bt_cl_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 3.7 micron BT of all cloudy pixels (nadir view)"},
    {"sd_37bt_cl_nad", e_tid_int, "%/1000", 4, "1", "Standard deviation of above"},
    {"sa_16toa_cl_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 1.6 micron TOA reflectance of all cloudy pixels (nadir view)"},
    {"sd_16toa_cl_nad", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_87toa_cl_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.87 micron TOA reflectance of all cloudy pixels (nadir view)"},
    {"sd_87toa_cl_nad", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_67toa_cl_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.67 micron TOA reflectance of all cloudy pixels (nadir view)"},
    {"sd_67toa_cl_nad", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_55toa_cl_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.55 micron TOA reflectance of all cloudy pixels (nadir view)"},
    {"sd_55toa_cl_nad", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"fail_flag_nad", e_tid_ushort, NULL, 2, "1", "Pixel threshold failure flags for averages, nadir view"},
    {"pix_for", e_tid_short, NULL, 2, "1", "Number of filled pixels in cell, forward view"},
    {"pix_ls_for", e_tid_short, NULL, 2, "1", "Number of filled pixels in cell over land surface, forward view"},
    {"perc_cl_pix_ls_for", e_tid_short, NULL, 2, "1", "Percentage of cloudy pixels in cell over land surface, forward view"},
    {"lat_corr_for", e_tid_int, "(1e-6) degrees", 4, "1", "Topographic latitude correction, forward view"},
    {"long_corr_for", e_tid_int, "(1e-6) degrees", 4, "1", "Topographic longitude correction, forward view"},
    {"sa_12bt_clr_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 12 micron BT of all clear pixels (forward view)"},
    {"sd_12bt_clr_for", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_11bt_clr_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 11 micron BT of all clear pixels (forward view)"},
    {"sd_11bt_clr_for", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_37bt_clr_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 3.7 micron BT of all clear pixels (forward view)"},
    {"sd_37bt_clr_for", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_16toa_clr_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 1.6 micron TOA reflectance of all clear pixels (forward view)"},
    {"sd_16toa_clr_for", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_87toa_clr_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.87 micron TOA reflectance of all clear pixels (forward view)"},
    {"sd_87toa_clr_for", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_67toa_clr_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.67 micron TOA reflectance of all clear pixels (forward view)"},
    {"sd_67toa_clr_for", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_55toa_clr_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.55 micron TOA reflectance of all clear pixels (forward view)"},
    {"sd_55toa_clr_for", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_12bt_cl_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 12 micron BT of all cloudy pixels (forward view)"},
    {"sd_12bt_cl_for", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_11bt_cl_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 11 micron BT of all cloudy pixels (forward view)"},
    {"sd_11bt_cl_for", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_37bt_cl_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 3.7 micron BT of all cloudy pixels (forward view)"},
    {"sd_37bt_cl_for", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_16toa_cl_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 1.6 micron TOA reflectance of all cloudy pixels (forward view)"},
    {"sd_16toa_cl_for", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_87toa_cl_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.87 micron TOA reflectance of all cloudy pixels (forward view)"},
    {"sd_87toa_cl_for", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_67toa_cl_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.67 micron TOA reflectance of all cloudy pixels (forward view)"},
    {"sd_67toa_cl_for", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_55toa_cl_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.55 micron TOA reflectance of all cloudy pixels (forward view)"},
    {"sd_55toa_cl_for", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"fail_flag_for", e_tid_ushort, NULL, 2, "1", "Pixel threshold failure flags for averages, forward view"},
    {"pix_nsig_nad", e_tid_short, NULL, 2, "1", "Number of filled pixels (N-Sigma), nadir view"},
    {"pix_ss", e_tid_short, "%/100", 2, "1", "Percentage filled pixels over land surface"},
    {"low_11bt_cl_nad", e_tid_short, "K/100", 2, "1", "Lowest 11 micron BT of all cloudy pixels, nadir view"},
    {"corr_12bt_nad", e_tid_short, "K/100", 2, "1", "Corresponding 12 micron BT, nadir view"},
    {"corr_37bt_nad", e_tid_short, "K/100", 2, "1", "Corresponding 3.7 micron BT, nadir view"},
    {"corr_16ref_nad", e_tid_short, "%/100", 2, "1", "Corresponding 1.6 micron reflectance, nadir view"},
    {"corr_87ref_nad", e_tid_short, "%/100", 2, "1", "Corresponding 0.87 micron reflectance, nadir view"},
    {"corr_67ref_nad", e_tid_short, "%/100", 2, "1", "Corresponding 0.67 micron reflectance, nadir view"},
    {"corr_55ref_nad", e_tid_short, "%/100", 2, "1", "Corresponding 0.55 micron reflectance, nadir view"},
    {"low_11bt_cl_for", e_tid_short, "K/100", 2, "1", "Lowest 11 micron BT of all cloudy pixels, forward view"},
    {"corr_12bt_for", e_tid_short, "K/100", 2, "1", "Corresponding 12 micron BT, forward view"},
    {"corr_37bt_for", e_tid_short, "K/100", 2, "1", "Corresponding 3.7 micron BT, forward view"},
    {"corr_16ref_for", e_tid_short, "%/100", 2, "1", "Corresponding 1.6 micron reflectance, forward view"},
    {"corr_87ref_for", e_tid_short, "%/100", 2, "1", "Corresponding 0.87 micron reflectance, forward view"},
    {"corr_67ref_for", e_tid_short, "%/100", 2, "1", "Corresponding 0.67 micron reflectance, forward view"},
    {"corr_55ref_for", e_tid_short, "%/100", 2, "1", "Corresponding 0.55 micron reflectance, forward view"}
};

static const struct RecordDescriptor ATS_AR__2P_MDSR_lr_small_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"lat", e_tid_int, "(1e-6) degrees", 4, "1", "Latitude of cell"},
    {"lon", e_tid_int, "(1e-6) degrees", 4, "1", "Longitude of cell"},
    {"m_actrk_pix_num", e_tid_short, NULL, 2, "1", "Mean across-track pixel number"},
    {"pix_nad", e_tid_short, NULL, 2, "1", "Number of filled pixels in cell, nadir view"},
    {"pix_ls_nad", e_tid_short, NULL, 2, "1", "Number of filled pixels in cell over land surface, nadir view"},
    {"perc_cl_pix_ls_nad", e_tid_short, NULL, 2, "1", "Percentage of cloudy pixels in cell over land surface, nadir view"},
    {"lat_corr_nad", e_tid_int, "(1e-6) degrees", 4, "1", "Topographic latitude correction,  nadir view"},
    {"long_corr_nad", e_tid_int, "(1e-6) degrees", 4, "1", "Topographic longitude correction,  nadir view"},
    {"sa_12bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 12 micron BT of all clear pixels  (nadir view)"},
    {"sa_11bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 11 micron BT of all clear pixels  (nadir view)"},
    {"sa_37bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 3.7 micron BT of all clear pixels  (nadir view)"},
    {"sa_16toa_clr_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 1.6 micron TOA reflectance of all clear pixels  (nadir view)"},
    {"sa_87toa_clr_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.87 micron TOA reflectance of all clear pixels  (nadir view)"},
    {"sa_67toa_clr_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.67 micron TOA reflectance of all clear pixels  (nadir view)"},
    {"sa_55toa_clr_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.55 micron TOA reflectance of all clear pixels  (nadir view)"},
    {"sa_12bt_cl_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 12 micron BT of all cloudy pixels  (nadir view)"},
    {"sa_11bt_cl_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 11 micron BT of all cloudy pixels  (nadir view)"},
    {"sa_37bt_cl_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 3.7 micron BT of all cloudy pixels  (nadir view)"},
    {"sa_16toa_cl_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 1.6 micron TOA reflectance of all cloudy pixels  (nadir view)"},
    {"sa_87toa_cl_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.87 micron TOA reflectance of all cloudy pixels  (nadir view)"},
    {"sa_67toa_cl_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.67 micron TOA reflectance of all cloudy pixels  (nadir view)"},
    {"sa_55toa_cl_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.55 micron TOA reflectance of all cloudy pixels  (nadir view)"},
    {"fail_flag_nad", e_tid_ushort, NULL, 2, "1", "Pixel threshold failure flags for averages, nadir view"},
    {"pix_for", e_tid_short, NULL, 2, "1", "Number of filled pixels in cell, forward view"},
    {"pix_ss_for", e_tid_short, NULL, 2, "1", "Number of filled pixels in cell over land surface, forward view"},
    {"perc_cl_pix_ss_for", e_tid_short, NULL, 2, "1", "Percentage of cloudy pixels in cell over land surface, forward view"},
    {"lat_corr_for", e_tid_int, "(1e-6) degrees", 4, "1", "Topographic latitude correction,  forward view"},
    {"long_corr_for", e_tid_int, "(1e-6) degrees", 4, "1", "Topographic longitude correction,  forward view"},
    {"sa_12bt_clr_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 12 micron BT of all clear pixels  (forward view)"},
    {"sa_11bt_clr_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 11 micron BT of all clear pixels  (forward view)"},
    {"sa_37bt_clr_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 3.7 micron BT of all clear pixels  (forward view)"},
    {"sa_16toa_clr_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 1.6 micron TOA reflectance of all clear pixels  (forward view)"},
    {"sa_87toa_clr_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.87 micron TOA reflectance of all clear pixels  (forward view)"},
    {"sa_67toa_clr_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.67 micron TOA reflectance of all clear pixels  (forward view)"},
    {"sa_55toa_clr_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.55 micron TOA reflectance of all clear pixels  (forward view)"},
    {"sa_12bt_cl_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 12 micron BT of all cloudy pixels  (forward view)"},
    {"sa_11bt_cl_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 11 micron BT of all cloudy pixels  (forward view)"},
    {"sa_37bt_cl_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 3.7 micron BT of all cloudy pixels  (forward view)"},
    {"sa_16toa_cl_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 1.6 micron TOA reflectance of all cloudy pixels  (forward view)"},
    {"sa_87toa_cl_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.87 micron TOA reflectance of all cloudy pixels  (forward view)"},
    {"sa_67toa_cl_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.67 micron TOA reflectance of all cloudy pixels  (forward view)"},
    {"sa_55toa_cl_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.55 micron TOA reflectance of all cloudy pixels  (forward view)"},
    {"fail_flag_for", e_tid_ushort, NULL, 2, "1", "Pixel threshold failure flags for averages, forward view"}
};

static const struct RecordDescriptor ATS_AR__2P_MDSR_lst_large_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"lat", e_tid_int, "(1e-6) degrees", 4, "1", "Latitude of cell"},
    {"lon", e_tid_int, "(1e-6) degrees", 4, "1", "Longitude of cell"},
    {"m_actrk_pix_num", e_tid_short, NULL, 2, "1", "Mean across-track pixel number"},
    {"m_lst", e_tid_short, "K/100", 2, "1", "mean land surface temperature (ST)"},
    {"sd_lst", e_tid_short, "K/100", 2, "1", "standard deviation of land ST"},
    {"pix_lst", e_tid_ushort, NULL, 2, "1", "Number of pixels in land surface temperature average"},
    {"m_ndvi", e_tid_short, NULL, 2, "1", "mean NDVI"},
    {"sd_ndvi", e_tid_short, NULL, 2, "1", "standard deviation of NDVI"},
    {"pix_ndvi", e_tid_ushort, NULL, 2, "1", "Number of pixels in NDVI average"},
    {"ast_conf_flags", e_tid_ushort, "flags", 2, "2", "AST confidence word"},
    {"cl_top_temp_nad", e_tid_short, "K/100", 2, "1", "Cloud-top temperature, nadir view"},
    {"perc_cl_cov_nad", e_tid_short, "%/100", 2, "1", "Percentage cloud-cover, nadir view"},
    {"cl_top_temp_for", e_tid_short, "K/100", 2, "1", "Cloud-top temperature, forward view"},
    {"perc_cl_cov_for", e_tid_short, "%/100", 2, "1", "Percentage cloud-cover, forward view"}
};

static const struct RecordDescriptor ATS_AR__2P_MDSR_lst_small_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"lat", e_tid_int, "(1e-6) degrees", 4, "1", "Latitude of cell"},
    {"lon", e_tid_int, "(1e-6) degrees", 4, "1", "Longitude of cell"},
    {"m_actrk_pix_num", e_tid_short, NULL, 2, "1", "Mean across-track pixel number"},
    {"m_lst", e_tid_short, "K/100", 2, "1", "mean land ST in cells"},
    {"pix_lst", e_tid_ushort, NULL, 2, "1", "Number of pixels in land surface temperature average"},
    {"m_ndvi", e_tid_short, NULL, 2, "1", "mean NDVI"},
    {"pix_ndvi", e_tid_ushort, NULL, 2, "1", "Number of pixels in NDVI average"},
    {"ast_conf_flags", e_tid_ushort, "flags", 2, "2", "AST confidence word"}
};

static const struct RecordDescriptor ATS_AR__2P_MDSR_sr_large_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"lat", e_tid_int, "(1e-6) degrees", 4, "1", "Latitude of cell"},
    {"lon", e_tid_int, "(1e-6) degrees", 4, "1", "Longitude of cell"},
    {"m_actrk_pix_num", e_tid_short, NULL, 2, "1", "Mean across-track pixel number"},
    {"pix_nad", e_tid_short, NULL, 2, "1", "Number of filled pixels in cell, nadir view"},
    {"pix_ss_nad", e_tid_short, NULL, 2, "1", "Number of filled pixels in cell over sea surface, nadir view"},
    {"clpix_ss_nad", e_tid_short, NULL, 2, "1", "Percentage of cloudy pixels in cell over sea surface, nadir view"},
    {"sa_12bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 12 micron BT of all clear pixels (nadir view)"},
    {"sd_12bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_11bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 11 micron BT of all clear pixels (nadir view)"},
    {"sd_11bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_37bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 3.7 micron BT of all clear pixels (nadir view)"},
    {"sd_37bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_16toa_clr_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 1.6 micron TOA reflectance of all clear pixels (nadir view)"},
    {"sd_16toa_clr_nad", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_87toa_clr_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.87 micron TOA reflectance of all clear pixels (nadir view)"},
    {"sd_87toa_clr_nad", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_67toa_clr_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.67 micron TOA reflectance of all clear pixels (nadir view)"},
    {"sd_67toa_clr_nad", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_55toa_clr_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.55 micron TOA reflectance of all clear pixels (nadir view)"},
    {"sd_55toa_clr_nad", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_12bt_cl_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 12 micron BT of all cloudy pixels (nadir view)"},
    {"sd_12bt_cl_nad", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_11bt_cl_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 11 micron BT of all cloudy pixels (nadir view)"},
    {"sd_11bt_cl_nad", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_37bt_cl_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 3.7 micron BT of all cloudy pixels (nadir view)"},
    {"sd_37bt_cl_nad", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_16toa_cl_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 1.6 micron TOA reflectance of all cloudy pixels (nadir view)"},
    {"sd_16toa_cl_nad", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_87toa_cl_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.87 micron TOA reflectance of all cloudy pixels (nadir view)"},
    {"sd_87toa_cl_nad", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_67toa_cl_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.67 micron TOA reflectance of all cloudy pixels (nadir view)"},
    {"sd_67toa_cl_nad", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_55toa_cl_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.55 micron TOA reflectance of all cloudy pixels (nadir view)"},
    {"sd_55toa_cl_nad", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"fail_flag_nad", e_tid_ushort, NULL, 2, "1", "Pixel threshold failure flags for averages, nadir view"},
    {"pix_for", e_tid_short, NULL, 2, "1", "Number of filled pixels in cell, forward view"},
    {"pix_ss_for", e_tid_short, NULL, 2, "1", "Number of filled pixels in cell over sea surface, forward view"},
    {"perc_cl_pix_ss_for", e_tid_short, NULL, 2, "1", "Percentage of cloudy pixels in cell over sea surface, forward view"},
    {"sa_12bt_clr_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 12 micron BT of all clear pixels (forward view)"},
    {"sd_12bt_clr_for", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_11bt_clr_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 11 micron BT of all clear pixels (forward view)"},
    {"sd_11bt_clr_for", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_37bt_clr_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 3.7 micron BT of all clear pixels (forward view)"},
    {"sd_37bt_clr_for", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_16toa_clr_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 1.6 micron TOA reflectance of all clear pixels (forward view)"},
    {"sd_16toa_clr_for", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_87toa_clr_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.87 micron TOA reflectance of all clear pixels (forward view)"},
    {"sd_87toa_clr_for", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_67toa_clr_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.67 micron TOA reflectance of all clear pixels (forward view)"},
    {"sd_67toa_clr_for", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_55toa_clr_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.55 micron TOA reflectance of all clear pixels (forward view)"},
    {"sd_55toa_clr_for", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_12bt_cl_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 12 micron BT of all cloudy pixels (forward view)"},
    {"sd_12bt_cl_for", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_11bt_cl_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 11 micron BT of all cloudy pixels (forward view)"},
    {"sd_11bt_cl_for", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_37bt_cl_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 3.7 micron BT of all cloudy pixels (forward view)"},
    {"sd_37bt_cl_for", e_tid_int, "K/1000", 4, "1", "Standard deviation of above"},
    {"sa_16toa_cl_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 1.6 micron TOA reflectance of all cloudy pixels (forward view)"},
    {"sd_16toa_cl_for", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_87toa_cl_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.87 micron TOA reflectance of all cloudy pixels (forward view)"},
    {"sd_87toa_cl_for", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_67toa_cl_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.67 micron TOA reflectance of all cloudy pixels (forward view)"},
    {"sd_67toa_cl_for", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"sa_55toa_cl_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.55 micron TOA reflectance of all cloudy pixels (forward view)"},
    {"sd_55toa_cl_for", e_tid_short, "%/100", 2, "1", "Standard deviation of above"},
    {"fail_flag_for", e_tid_ushort, NULL, 2, "1", "Pixel threshold failure flags for averages, foward view"},
    {"pix_nsig_nad", e_tid_short, NULL, 2, "1", "Number of filled pixels (N-Sigma), nadir view"},
    {"pix_ss", e_tid_short, "%/100", 2, "1", "Percentage filled pixels over sea surface"},
    {"low_11bt_cl_nad", e_tid_short, "K/100", 2, "1", "Lowest 11 micron BT of all cloudy pixels, nadir view"},
    {"corr_12bt_nad", e_tid_short, "K/100", 2, "1", "Corresponding 12 micron BT, nadir view"},
    {"corr_37bt_nad", e_tid_short, "K/100", 2, "1", "Corresponding 3.7 micron BT, nadir view"},
    {"corr_16ref_nad", e_tid_short, "%/100", 2, "1", "Corresponding 1.6 micron reflectance, nadir view"},
    {"corr_87ref_nad", e_tid_short, "%/100", 2, "1", "Corresponding 0.87 micron reflectance, nadir view"},
    {"corr_67ref_nad", e_tid_short, "%/100", 2, "1", "Corresponding 0.67 micron reflectance, nadir view"},
    {"corr_55ref_nad", e_tid_short, "%/100", 2, "1", "Corresponding 0.55 micron reflectance, nadir view"},
    {"low_11bt_cl_for", e_tid_short, "K/100", 2, "1", "Lowest 11 micron BT of all cloudy pixels, forward view"},
    {"corr_12bt_for", e_tid_short, "K/100", 2, "1", "Corresponding 12 micron BT, forward view"},
    {"corr_37bt_for", e_tid_short, "K/100", 2, "1", "Corresponding 3.7 micron BT, forward view"},
    {"corr_16ref_for", e_tid_short, "%/100", 2, "1", "Corresponding 1.6 micron reflectance, forward view"},
    {"corr_87ref_for", e_tid_short, "%/100", 2, "1", "Corresponding 0.87 micron reflectance, forward view"},
    {"corr_67ref_for", e_tid_short, "%/100", 2, "1", "Corresponding 0.67 micron reflectance, forward view"},
    {"corr_55ref_for", e_tid_short, "%/100", 2, "1", "Corresponding 0.55 micron reflectance, forward view"}
};

static const struct RecordDescriptor ATS_AR__2P_MDSR_sr_small_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"lat", e_tid_int, "(1e-6) degrees", 4, "1", "Latitude of cell"},
    {"lon", e_tid_int, "(1e-6) degrees", 4, "1", "Longitude of cell"},
    {"m_actrk_pix_num", e_tid_short, NULL, 2, "1", "Mean across-track pixel number"},
    {"pix_nad", e_tid_short, NULL, 2, "1", "Number of filled pixels in cell, nadir view"},
    {"pix_ss_nad", e_tid_short, NULL, 2, "1", "Number of filled pixels in cell over sea surface, nadir view"},
    {"clpix_ss_nad", e_tid_short, NULL, 2, "1", "Percentage of cloudy pixels in cell over sea surface, nadir view"},
    {"sa_12bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 12 micron BT of all clear pixels (nadir view)"},
    {"sa_11bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 11 micron BT of all clear pixels (nadir view)"},
    {"sa_37bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 3.7 micron BT of all clear pixels (nadir view)"},
    {"sa_16toa_clr_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 1.6 micron TOA reflectance of all clear pixels (nadir view)"},
    {"sa_87toa_clr_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.87 micron TOA reflectance of all clear pixels (nadir view)"},
    {"sa_67toa_clr_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.67 micron TOA reflectance of all clear pixels (nadir view)"},
    {"sa_55toa_clr_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.55 micron TOA reflectance of all clear pixels (nadir view)"},
    {"sa_12bt_cl_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 12 micron BT of all cloudy pixels (nadir view)"},
    {"sa_11bt_cl_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 11 micron BT of all cloudy pixels (nadir view)"},
    {"sa_37bt_cl_nad", e_tid_int, "K/1000", 4, "1", "Spatially averaged 3.7 micron BT of all cloudy pixels (nadir view)"},
    {"sa_16toa_cl_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 1.6 micron TOA reflectance of all cloudy pixels (nadir view)"},
    {"sa_87toa_cl_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.87 micron TOA reflectance of all cloudy pixels (nadir view)"},
    {"sa_67toa_cl_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.67 micron TOA reflectance of all cloudy pixels (nadir view)"},
    {"sa_55toa_cl_nad", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.55 micron TOA reflectance of all cloudy pixels (nadir view)"},
    {"fail_flag_nad", e_tid_ushort, NULL, 2, "1", "Pixel threshold failure flags for averages, nadir view"},
    {"pix_for", e_tid_short, NULL, 2, "1", "Number of filled pixels in cell, forward view"},
    {"pix_ss_for", e_tid_short, NULL, 2, "1", "Number of filled pixels in cell over sea surface, forward view"},
    {"perc_cl_pix_ss_for", e_tid_short, NULL, 2, "1", "Percentage of cloudy pixels in cell over sea surface, forward view"},
    {"sa_12bt_clr_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 12 micron BT of all clear pixels (forward view)"},
    {"sa_11bt_clr_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 11 micron BT of all clear pixels (forward view)"},
    {"sa_37bt_clr_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 3.7 micron BT of all clear pixels (forward view)"},
    {"sa_16toa_clr_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 1.6 micron TOA reflectance of all clear pixels (forward view)"},
    {"sa_87toa_clr_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.87 micron TOA reflectance of all clear pixels (forward view)"},
    {"sa_67toa_clr_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.67 micron TOA reflectance of all clear pixels (forward view)"},
    {"sa_55toa_clr_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.55 micron TOA reflectance of all clear pixels (forward view)"},
    {"sa_12bt_cl_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 12 micron BT of all cloudy pixels (forward view)"},
    {"sa_11bt_cl_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 11 micron BT of all cloudy pixels (forward view)"},
    {"sa_37bt_cl_for", e_tid_int, "K/1000", 4, "1", "Spatially averaged 3.7 micron BT of all cloudy pixels (forward view)"},
    {"sa_16toa_cl_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 1.6 micron TOA reflectance of all cloudy pixels (forward view)"},
    {"sa_87toa_cl_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.87 micron TOA reflectance of all cloudy pixels (forward view)"},
    {"sa_67toa_cl_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.67 micron TOA reflectance of all cloudy pixels (forward view)"},
    {"sa_55toa_cl_for", e_tid_short, "%/100", 2, "1", "Spatially averaged 0.55 micron TOA reflectance of all cloudy pixels (forward view)"},
    {"fail_flag_for", e_tid_ushort, NULL, 2, "1", "Pixel threshold failure flags for averages, foward view"}
};

static const struct RecordDescriptor ATS_AR__2P_MDSR_sst_large_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"lat", e_tid_int, "(1e-6) degrees", 4, "1", "Latitude of cell"},
    {"lon", e_tid_int, "(1e-6) degrees", 4, "1", "Longitude of cell"},
    {"m_actrk_pix_num", e_tid_short, NULL, 2, "1", "Mean across-track pixel number"},
    {"m_nad", e_tid_short, "K/100", 2, "1", "mean nadir-only SST"},
    {"sd_nad", e_tid_short, "K/100", 2, "1", "standard deviation of nadir-only SST"},
    {"pix_nad", e_tid_ushort, NULL, 2, "1", "Number of pixels in nadir-only average"},
    {"m_dual_vw", e_tid_short, "K/100", 2, "1", "mean dual-view SST"},
    {"sd_dual_vw", e_tid_short, "K/100", 2, "1", "standard deviation of dual-view SST"},
    {"pix_dual_vw", e_tid_ushort, NULL, 2, "1", "Number of pixels in dual view average"},
    {"ast_conf_flags", e_tid_ushort, "flags", 2, "2", "AST confidence word"},
    {"cl_top_temp_nad", e_tid_short, "K/100", 2, "1", "Cloud-top temperature, nadir view"},
    {"perc_cl_cov_nad", e_tid_short, "%/100", 2, "1", "Percentage cloud-cover, nadir view"},
    {"cl_top_temp_for", e_tid_short, "K/100", 2, "1", "Cloud-top temperature, forward view"},
    {"perc_cl_cov_for", e_tid_short, "%/100", 2, "1", "Percentage cloud-cover, forward view"}
};

static const struct RecordDescriptor ATS_AR__2P_MDSR_sst_small_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"lat", e_tid_int, "(1e-6) degrees", 4, "1", "Latitude of cell"},
    {"lon", e_tid_int, "(1e-6) degrees", 4, "1", "Longitude of cell"},
    {"m_actrk_pix_num", e_tid_short, NULL, 2, "1", "Mean across-track pixel number"},
    {"m_nad", e_tid_short, "K/100", 2, "1", "mean nadir-only SST"},
    {"pix_nad", e_tid_ushort, NULL, 2, "1", "Number of pixels in nadir-only average"},
    {"m_dual_vw", e_tid_short, "K/100", 2, "1", "mean dual-view SST"},
    {"pix_dual_vw", e_tid_ushort, NULL, 2, "1", "Number of pixels in dual-view average"},
    {"ast_conf_flags", e_tid_ushort, "flags", 2, "2", "AST confidence word"}
};

static const struct RecordDescriptor ATS_MET_2P_meteo_user_prod_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"rec_qua_ind", e_tid_char, NULL, 1, "1", "Record Quality indicator"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"lat", e_tid_int, "(1e-6) degrees", 4, "1", "Latitude of 10 arcmin cell"},
    {"lon", e_tid_int, "(1e-6) degrees", 4, "1", "Longitude of 10 arcmin cell"},
    {"sa_12bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Nadir spatially averaged 12 micron BT of all clear pixels 10 arcmin cells"},
    {"sa_11bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Nadir spatially averaged 11 micron BT of all clear pixels in 10 arcmin cells"},
    {"sa_37bt_clr_nad", e_tid_int, "K/1000", 4, "1", "Nadir spatially averaged 3.7 micron BT of all clear pixels in 10 arcmin cells"},
    {"sa_12bt_clr_for", e_tid_int, "K/1000", 4, "1", "Forward spatially averaged 12 micron BT of all clear pixels in 10 arcmin cells"},
    {"sa_11bt_clr_for", e_tid_int, "K/1000", 4, "1", "Forward spatially averaged 11 micron BT of all clear pixels in 10 arcmin cells"},
    {"sa_37bt_clr_for", e_tid_int, "K/1000", 4, "1", "Forward spatially averaged 3.7 micron BT of all clear pixels in 10 arcmin cells"},
    {"m_actrk_pix_num", e_tid_short, "none", 2, "1", "Mean across-track pixel number"},
    {"m_nad", e_tid_short, "K/100", 2, "1", "Mean nadir-only SST 10 arcmin cells"},
    {"pix_nad", e_tid_ushort, "none", 2, "1", "Number of pixels in nadir-only average, 10 arcmin cells"},
    {"m_dual_vw", e_tid_short, "K/100", 2, "1", "Mean dual-view SST in 10 arcmin cells"},
    {"pix_dual_vw", e_tid_ushort, "none", 2, "1", "Number of pixels in dual-view average, 10 arcmin cells"},
    {"ast_conf_flags", e_tid_ushort, "flags", 2, "2", "AST confidence word"}
};

static const struct RecordDescriptor ATS_NR__2P_ADSR_sq_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment flag(set to 1 if all MDSRs corresponding to this ADSR are blank, set to 0 otherwise)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"scan_num", e_tid_ushort, NULL, 2, "1", "image scan number"},
    {"pv_nad_null_pac", e_tid_short, NULL, 2, "1", "Packet Validation during nadir view number of scans null packet"},
    {"pv_nad_fail_val", e_tid_short, NULL, 2, "1", "Packet Validation during nadir view number of scans failing basic validation"},
    {"pv_nad_fail_crc_chk", e_tid_short, NULL, 2, "1", "Packet Validation during nadir view number of scans failing CRC check"},
    {"pv_nad_show_buf_full", e_tid_short, NULL, 2, "1", "Packet Validation during nadir view number of scans showing buffers full"},
    {"pv_nad_scan_jitt", e_tid_short, NULL, 2, "1", "Packet Validation during nadir view number of scans showing scan jitter"},
    {"per_cloud_pix", e_tid_short, "0.01 %", 2, "1", "percentage of cloudy pixels"},
    {"per_ndvi_inv", e_tid_short, "0.01 %", 2, "1", "percentage of NDVI invalid"},
    {"per_sst_for_inv", e_tid_short, "0.01 %", 2, "1", "percentage of SST (nadir view) invalid"},
    {"per_sst_dual_inv", e_tid_short, "0.01 %", 2, "1", "percentage of SST (dual view) invalid"},
    {"pv_nad_scan_error", e_tid_short, NULL, 2, "1", "Packet Validation during nadir view number of scans - all other errors"},
    {"pv_for_null_pac", e_tid_short, NULL, 2, "1", "Packet Validation during forward view number of scans null packet"},
    {"pv_for_fail_val", e_tid_short, NULL, 2, "1", "Packet Validation during forward view number of scans failing basic validation"},
    {"pv_for_fail_crc_chk", e_tid_short, NULL, 2, "1", "Packet Validation during forward view number of scans failing CRC check"},
    {"pv_for_show_buf_full", e_tid_short, NULL, 2, "1", "Packet Validation during forward view number of scans showing buffers full"},
    {"pv_for_scan_jitt", e_tid_short, NULL, 2, "1", "Packet Validation during forward view number of scans showing scan jitter"},
    {"resv_char_5", e_tid_short, NULL, 2, "1", "reserved for future use"},
    {"resv_char_6", e_tid_short, NULL, 2, "1", "reserved for future use"},
    {"resv_char_7", e_tid_short, NULL, 2, "1", "reserved for future use"},
    {"resv_char_8", e_tid_short, NULL, 2, "1", "reserved for future use"},
    {"pv_for_scan_error", e_tid_short, NULL, 2, "1", "Packet Validation during forward view number of scans - all other errors"},
    {"spare_2", e_tid_spare, NULL, 28, "1", "Spare"}
};

static const struct RecordDescriptor ATS_NR__2P_MDSR_dp_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"img_scan_y", e_tid_int, "m", 4, "1", "image scan y coordinate"},
    {"conf_wd_flags", e_tid_ushort, "flags", 2, "512", "confidence words (Defined in Table 7.5.1.7.8 3)"},
    {"nad_field", e_tid_short, "K/100", 2, "512", "nadir field (Note 1)"},
    {"comb_field", e_tid_short, "See Note 1", 2, "512", "combined field (Note 1)"}
};

static const struct RecordDescriptor ATS_TOA_1P_ADSR_loc_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment Flag (set to 1 if all MDSRs corresponding to this ADSR are blank, set to 0 otherwise)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"img_scan_y", e_tid_int, "m", 4, "1", "image scan y coordinate"},
    {"tie_pt_lat", e_tid_int, "(1e-6) degrees", 4, "23", "tie point latitudes"},
    {"tie_pt_long", e_tid_int, "(1e-6) degrees", 4, "23", "tie point longitudes"},
    {"lat_corr_nadv", e_tid_int, "(1e-6) degrees", 4, "23", "latitude corrections, nadir view"},
    {"long_corr_nadv", e_tid_int, "(1e-6) degrees", 4, "23", "longitude corrections, nadir view"},
    {"lat_corr_forv", e_tid_int, "(1e-6) degrees", 4, "23", "latitude corrections, forward view"},
    {"long_corr_forv", e_tid_int, "(1e-6) degrees", 4, "23", "longitude corrections, forward view"},
    {"topo_alt", e_tid_short, "metres", 2, "23", "Topographic Altitude"},
    {"spare_2", e_tid_spare, NULL, 8, "1", "Spare"}
};

static const struct RecordDescriptor ATS_TOA_1P_ADSR_pix_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment flag (always set to zero for this ADS)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"img_scan_y", e_tid_int, "m", 4, "1", "image scan y coordinate"},
    {"instr_scan_num", e_tid_ushort, NULL, 2, "512", "instrument scan number"},
    {"pix_num", e_tid_ushort, NULL, 2, "512", "pixel number"}
};

static const struct RecordDescriptor ATS_TOA_1P_ADSR_sa_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment Flag (always set to zero for this ADS)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"img_scan_y", e_tid_int, "m", 4, "1", "image scan y coordinate"},
    {"tie_pt_sol_elev", e_tid_int, "mdeg", 4, "11", "tie point solar elevation"},
    {"tie_pt_sat_elev_nad", e_tid_int, "mdeg", 4, "11", "tie point satellite elevation nadir"},
    {"tie_pt_sol_az", e_tid_int, "mdeg", 4, "11", "tie point solar azimuth"},
    {"tie_pt_sat_azi", e_tid_int, "mdeg", 4, "11", "tie point satellite azimuth"},
    {"spare_2", e_tid_spare, NULL, 20, "1", "Spare"}
};

static const struct RecordDescriptor ATS_TOA_1P_ADSR_scan_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Scan UTC time in MJD format"},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment Flag (always set to zero for this ADS)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"instr_scan_num", e_tid_ushort, NULL, 2, "1", "instrument scan number"},
    {"tie_pix_x", e_tid_int, "m", 4, "99", "tie pixel x coordinate"},
    {"tie_pix_y", e_tid_int, "m", 4, "99", "tie pixel y coordinate"},
    {"spare_2", e_tid_spare, NULL, 20, "1", "spare"}
};

static const struct RecordDescriptor ATS_TOA_1P_ADSR_sq_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment flag(set to 1 if all MDSRs corresponding to this ADSR are blank, set to 0 otherwise)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"scan_num", e_tid_ushort, NULL, 2, "1", "scan number"},
    {"pv_nad_null_pac", e_tid_short, NULL, 2, "1", "Packet Validation during nadir view number of scans null packet"},
    {"pv_nad_fail_val", e_tid_short, NULL, 2, "1", "Packet Validation during nadir view number of scans failing basic validation"},
    {"pv_nad_fail_crc_chk", e_tid_short, NULL, 2, "1", "Packet Validation during nadir view number of scans failing CRC check"},
    {"pv_nad_show_buf_full", e_tid_short, NULL, 2, "1", "Packet Validation during nadir view number of scans showing buffers full"},
    {"pv_nad_scan_jitt", e_tid_short, NULL, 2, "1", "Packet Validation during nadir view number of scans showing scan jitter"},
    {"resv_char_1", e_tid_short, NULL, 2, "1", "reserved for future use"},
    {"resv_char_2", e_tid_short, NULL, 2, "1", "reserved for future use"},
    {"resv_char_3", e_tid_short, NULL, 2, "1", "reserved for future use"},
    {"resv_char_4", e_tid_short, NULL, 2, "1", "reserved for future use"},
    {"pv_nad_scan_error", e_tid_short, NULL, 2, "1", "Packet Validation during nadir view number of scans - all other errors"},
    {"pv_for_null_pac", e_tid_short, NULL, 2, "1", "Packet Validation during forward view number of scans null packet"},
    {"pv_for_fail_val", e_tid_short, NULL, 2, "1", "Packet Validation during forward view number of scans failing basic validation"},
    {"pv_for_fail_crc_chk", e_tid_short, NULL, 2, "1", "Packet Validation during forward view number of scans failing CRC check"},
    {"pv_for_show_buf_full", e_tid_short, NULL, 2, "1", "Packet Validation during forward view number of scans showing buffers full"},
    {"pv_for_scan_jitt", e_tid_short, NULL, 2, "1", "Packet Validation during forward view number of scans showing scan jitter"},
    {"resv_char_5", e_tid_short, NULL, 2, "1", "reserved for future use"},
    {"resv_char_6", e_tid_short, NULL, 2, "1", "reserved for future use"},
    {"resv_char_7", e_tid_short, NULL, 2, "1", "reserved for future use"},
    {"resv_char_8", e_tid_short, NULL, 2, "1", "reserved for future use"},
    {"pv_for_scan_error", e_tid_short, NULL, 2, "1", "Packet Validation during forward view number of scans - all other errors"},
    {"spare_2", e_tid_spare, NULL, 28, "1", "Spare"}
};

static const struct RecordDescriptor ATS_TOA_1P_MDSR_brgt_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"img_scan_y", e_tid_int, "m", 4, "1", "image scan y coordinate"},
    {"bt_rad_pix", e_tid_short, "K/100%/100", 2, "512", "BT or refectance for pixel 0 - 511(Units are K/100 for BT, %/100 for reflectance. Small negative values may be used to represent channel-specific exceptional values)."}
};

static const struct RecordDescriptor ATS_TOA_1P_MDSR_cl_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"img_scan_y", e_tid_int, "m", 4, "1", "image scan y coordinate"},
    {"cl_land_flags", e_tid_ushort, "flags", 2, "512", "cloud/land flags"}
};

static const struct RecordDescriptor ATS_TOA_1P_MDSR_conf_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Nadir UTC time in MJD format"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"img_scan_y", e_tid_int, "m", 4, "1", "image scan y coordinate"},
    {"conf_wd_flags", e_tid_ushort, "flags", 2, "512", "Confidence words"}
};

static const struct RecordDescriptor ATS_VC1_AX_GADS_aatsr_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Time of cal in MJD format"},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment flag (always set to zero for this flag)"},
    {"spare_1", e_tid_spare, NULL, 3, "1", "Spare"},
    {"slp_16_mic", e_tid_float, NULL, 4, "1", "1.6 micron slope"},
    {"slp_087_mic", e_tid_float, NULL, 4, "1", "0.870 micron slope"},
    {"slp_067_mic", e_tid_float, NULL, 4, "1", "0.670 micron slope"},
    {"slp_055_mic", e_tid_float, NULL, 4, "1", "0.555 micron slope"},
    {"asc_time", e_tid_time, "MJD", 12, "1", "UTC at ascending node crossing, in MJD format"},
    {"ave_mon_cnt", e_tid_float, NULL, 4, "1", "Average Monitor count"},
    {"sd_mon_cnt", e_tid_float, NULL, 4, "1", "Standard deviation of Monitor count"},
    {"sol_irr_16", e_tid_float, NULL, 4, "1", "Solar irradiance (1.6 micron)"},
    {"sol_irr_087", e_tid_float, NULL, 4, "1", "Solar irradiance (0.870 micron)"},
    {"sol_irr_067", e_tid_float, NULL, 4, "1", "Solar irradiance (0.670 micron)"},
    {"sol_irr_055", e_tid_float, NULL, 4, "1", "Solar irradiance (0.555 micron)"},
    {"ave_vispix_16", e_tid_float, NULL, 4, "1", "Average VISCAL Pixel Counts (1.6 (m)"},
    {"ave_vispix_087", e_tid_float, NULL, 4, "1", "Average VISCAL Pixel Counts (0.87 (m)"},
    {"ave_vispix_067", e_tid_float, NULL, 4, "1", "Average VISCAL Pixel Counts (0.67 (m)"},
    {"ave_vispix_055", e_tid_float, NULL, 4, "1", "Average VISCAL Pixel Counts (0.55 (m)"},
    {"vis_pixnois_16", e_tid_float, NULL, 4, "1", "VISCAL Pixel Noise (1.6 micron)"},
    {"vis_pixnois_087", e_tid_float, NULL, 4, "1", "VISCAL Pixel Noise (0.87 micron)"},
    {"vis_pixnois_067", e_tid_float, NULL, 4, "1", "VISCAL Pixel Noise (0.67 micron)"},
    {"vis_pixnois_055", e_tid_float, NULL, 4, "1", "VISCAL Pixel Noise (0.55 micron)"},
    {"ave_xbb_16", e_tid_float, NULL, 4, "1", "Average -X BB Pixel Counts (1.6 (m)"},
    {"ave_xbb_cnt_087", e_tid_float, NULL, 4, "1", "Average -X BB Pixel Counts (0.87 (m)"},
    {"ave_xbb_cnt_067", e_tid_float, NULL, 4, "1", "Average -X BB Pixel Counts (0.67 (m)"},
    {"ave_xbb_cnt_055", e_tid_float, NULL, 4, "1", "Average -X BB Pixel Counts (0.55 (m)"},
    {"xbb_nois_16", e_tid_float, NULL, 4, "1", "-X BB Pixel Noise (1.6 micron)"},
    {"xbb_nois_087", e_tid_float, NULL, 4, "1", "-X BB Pixel Noise (0.87 micron)"},
    {"xbb_nois_067", e_tid_float, NULL, 4, "1", "-X BB Pixel Noise (0.67 micron)"},
    {"xbb_nois_055", e_tid_float, NULL, 4, "1", "-X BB Pixel Noise (0.55 micron)"},
    {"parity_char", e_tid_short, NULL, 2, "1", "(Reserved for parity indicator)"},
    {"spare_2", e_tid_spare, NULL, 20, "1", "Spare"}
};

static const struct RecordDescriptor ASAR_Antenna_ADSR_asar_rec_data[] = {
    {"zero_doppler_time", e_tid_time, "MJD", 12, "1", "Zero Doppler azimuth time at which pattern applies"},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment Flag (always set to zero for this ADSR)"},
    {"beam_id", e_tid_string, "ascii", 3, "1", "Beam ID to which pattern applies SS1 to SS5 or NS&Oslash;"},
    {"elevation_pattern.slant_range_time", e_tid_float, "ns", 4, "11", "2 way slant range times"},
    {"elevation_pattern.elevation_angles", e_tid_float, "degrees", 4, "11", "Corresponding elevation angles"},
    {"elevation_pattern.antenna_pattern", e_tid_float, "dB", 4, "11", "Corresponding two-way antenna elevation pattern values"},
    {"spare_1", e_tid_spare, NULL, 14, "1", "Spare"}
};

static const struct RecordDescriptor ASAR_Chirp_ADSR_asar_rec_data[] = {
    {"zero_doppler_time", e_tid_time, "MJD", 12, "1", "Zero Doppler azimuth time in azimuth at which estimate applies"},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment Flag (always set to zero for this ADSR)"},
    {"beam_id", e_tid_string, "ascii", 3, "1", "Beam ID: SS1, SS2, SS3, SS4, or SS5 for WS and GM images. Set to NS&Oslash; for AP, IM, and WV images."},
    {"polar", e_tid_string, "ascii", 3, "1", "Tx/Rx polarization H/H, H/V, V/V, or V/H"},
    {"chirp_width", e_tid_float, "samples", 4, "1", "3-dB pulse width of chirp replica cross-correlation function between reconstructed chirp and nominal chirp"},
    {"chirp_sidelobe", e_tid_float, "dB", 4, "1", "First side lobe level of chirp replica cross-correlation function between reconstructed chirp and nominal chirp"},
    {"chirp_islr", e_tid_float, "dB", 4, "1", "ISLR of chirp replica cross-correlation function between reconstructed chirp and nominal chirp"},
    {"chirp_peak_loc", e_tid_float, "samples", 4, "1", "Peak location of cross-correlation function between reconstructed chirp and nominal chirp"},
    {"chirp_power", e_tid_float, "dB", 4, "1", "Chirp power"},
    {"elev_corr_factor", e_tid_float, NULL, 4, "1", "Elevation gain correction scaling factor applied to range compressed samples"},
    {"spare_1", e_tid_spare, NULL, 16, "1", "Spare"},
    {"cal_pulse_info.1.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 1)"},
    {"cal_pulse_info.1.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 1)"},
    {"cal_pulse_info.1.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 1)"},
    {"cal_pulse_info.1.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 1)"},
    {"cal_pulse_info.2.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 2)"},
    {"cal_pulse_info.2.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 2)"},
    {"cal_pulse_info.2.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 2)"},
    {"cal_pulse_info.2.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 2)"},
    {"cal_pulse_info.3.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 3)"},
    {"cal_pulse_info.3.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 3)"},
    {"cal_pulse_info.3.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 3)"},
    {"cal_pulse_info.3.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 3)"},
    {"cal_pulse_info.4.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 4)"},
    {"cal_pulse_info.4.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 4)"},
    {"cal_pulse_info.4.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 4)"},
    {"cal_pulse_info.4.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 4)"},
    {"cal_pulse_info.5.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 5)"},
    {"cal_pulse_info.5.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 5)"},
    {"cal_pulse_info.5.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 5)"},
    {"cal_pulse_info.5.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 5)"},
    {"cal_pulse_info.6.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 6)"},
    {"cal_pulse_info.6.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 6)"},
    {"cal_pulse_info.6.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 6)"},
    {"cal_pulse_info.6.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 6)"},
    {"cal_pulse_info.7.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 7)"},
    {"cal_pulse_info.7.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 7)"},
    {"cal_pulse_info.7.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 7)"},
    {"cal_pulse_info.7.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 7)"},
    {"cal_pulse_info.8.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 8)"},
    {"cal_pulse_info.8.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 8)"},
    {"cal_pulse_info.8.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 8)"},
    {"cal_pulse_info.8.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 8)"},
    {"cal_pulse_info.9.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 9)"},
    {"cal_pulse_info.9.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 9)"},
    {"cal_pulse_info.9.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 9)"},
    {"cal_pulse_info.9.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 9)"},
    {"cal_pulse_info.10.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 10)"},
    {"cal_pulse_info.10.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 10)"},
    {"cal_pulse_info.10.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 10)"},
    {"cal_pulse_info.10.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 10)"},
    {"cal_pulse_info.11.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 11)"},
    {"cal_pulse_info.11.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 11)"},
    {"cal_pulse_info.11.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 11)"},
    {"cal_pulse_info.11.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 11)"},
    {"cal_pulse_info.12.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 12)"},
    {"cal_pulse_info.12.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 12)"},
    {"cal_pulse_info.12.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 12)"},
    {"cal_pulse_info.12.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 12)"},
    {"cal_pulse_info.13.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 13)"},
    {"cal_pulse_info.13.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 13)"},
    {"cal_pulse_info.13.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 13)"},
    {"cal_pulse_info.13.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 13)"},
    {"cal_pulse_info.14.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 14)"},
    {"cal_pulse_info.14.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 14)"},
    {"cal_pulse_info.14.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 14)"},
    {"cal_pulse_info.14.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 14)"},
    {"cal_pulse_info.15.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 15)"},
    {"cal_pulse_info.15.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 15)"},
    {"cal_pulse_info.15.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 15)"},
    {"cal_pulse_info.15.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 15)"},
    {"cal_pulse_info.16.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 16)"},
    {"cal_pulse_info.16.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 16)"},
    {"cal_pulse_info.16.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 16)"},
    {"cal_pulse_info.16.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 16)"},
    {"cal_pulse_info.17.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 17)"},
    {"cal_pulse_info.17.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 17)"},
    {"cal_pulse_info.17.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 17)"},
    {"cal_pulse_info.17.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 17)"},
    {"cal_pulse_info.18.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 18)"},
    {"cal_pulse_info.18.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 18)"},
    {"cal_pulse_info.18.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 18)"},
    {"cal_pulse_info.18.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 18)"},
    {"cal_pulse_info.19.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 19)"},
    {"cal_pulse_info.19.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 19)"},
    {"cal_pulse_info.19.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 19)"},
    {"cal_pulse_info.19.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 19)"},
    {"cal_pulse_info.20.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 20)"},
    {"cal_pulse_info.20.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 20)"},
    {"cal_pulse_info.20.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 20)"},
    {"cal_pulse_info.20.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 20)"},
    {"cal_pulse_info.21.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 21)"},
    {"cal_pulse_info.21.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 21)"},
    {"cal_pulse_info.21.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 21)"},
    {"cal_pulse_info.21.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 21)"},
    {"cal_pulse_info.22.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 22)"},
    {"cal_pulse_info.22.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 22)"},
    {"cal_pulse_info.22.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 22)"},
    {"cal_pulse_info.22.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 22)"},
    {"cal_pulse_info.23.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 23)"},
    {"cal_pulse_info.23.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 23)"},
    {"cal_pulse_info.23.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 23)"},
    {"cal_pulse_info.23.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 23)"},
    {"cal_pulse_info.24.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 24)"},
    {"cal_pulse_info.24.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 24)"},
    {"cal_pulse_info.24.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 24)"},
    {"cal_pulse_info.24.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 24)"},
    {"cal_pulse_info.25.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 25)"},
    {"cal_pulse_info.25.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 25)"},
    {"cal_pulse_info.25.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 25)"},
    {"cal_pulse_info.25.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 25)"},
    {"cal_pulse_info.26.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 26)"},
    {"cal_pulse_info.26.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 26)"},
    {"cal_pulse_info.26.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 26)"},
    {"cal_pulse_info.26.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 26)"},
    {"cal_pulse_info.27.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 27)"},
    {"cal_pulse_info.27.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 27)"},
    {"cal_pulse_info.27.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 27)"},
    {"cal_pulse_info.27.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 27)"},
    {"cal_pulse_info.28.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 28)"},
    {"cal_pulse_info.28.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 28)"},
    {"cal_pulse_info.28.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 28)"},
    {"cal_pulse_info.28.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 28)"},
    {"cal_pulse_info.29.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 29)"},
    {"cal_pulse_info.29.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 29)"},
    {"cal_pulse_info.29.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 29)"},
    {"cal_pulse_info.29.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 29)"},
    {"cal_pulse_info.30.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 30)"},
    {"cal_pulse_info.30.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 30)"},
    {"cal_pulse_info.30.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 30)"},
    {"cal_pulse_info.30.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 30)"},
    {"cal_pulse_info.31.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 31)"},
    {"cal_pulse_info.31.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 31)"},
    {"cal_pulse_info.31.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 31)"},
    {"cal_pulse_info.31.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 31)"},
    {"cal_pulse_info.32.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 32)"},
    {"cal_pulse_info.32.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 32)"},
    {"cal_pulse_info.32.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 32)"},
    {"cal_pulse_info.32.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 32)"},
    {"spare_2", e_tid_spare, NULL, 16, "1", "Spare"}
};

static const struct RecordDescriptor ASAR_Dop_Cen_ADSR_asar_rec_data[] = {
    {"zero_doppler_time", e_tid_time, "MJD", 12, "1", "Zero Doppler azimuth time at which estimate applies"},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment Flag (always set to zero for this ADSR)"},
    {"slant_range_time", e_tid_float, "ns", 4, "1", "2-way slant range time origin (t0)"},
    {"dop_coef", e_tid_float, "HzHz/sHz/s2Hz/s3Hz/s4", 4, "5", "Doppler centroid coefficients as a function of slant range time: D0, D1, D2, D3, and D4. where Doppler Centroid = D0 + D1(tSR-t0) + D2(tSR-t0)2 + D3(tSR-t0)3 + D4(tSR-t0)4"},
    {"dop_conf", e_tid_float, NULL, 4, "1", "Doppler Centroid Confidence Measure. Value between 0 and 1, 0 = poorest confidence, 1= highest confidence. If multiple Doppler Centroid estimates were performed, this value is the lowest confidence value attained."},
    {"dop_thresh_flag", e_tid_uchar, "flag", 1, "1", "Doppler Confidence Below Threshold Flag. 0 = confidence above threshold, Doppler Centroid calculated from data. 1 = confidence below threshold, Doppler Centroid calculated from orbit."},
    {"spare_1", e_tid_spare, NULL, 13, "1", "Spare"}
};

static const struct RecordDescriptor ASAR_Geo_Grid_ADSR_asar_rec_data[] = {
    {"first_zero_doppler_time", e_tid_time, "MJD", 12, "1", "Zero Doppler Time in azimuth of first line of the granule. Gives azimuth location of grid line for first line of the granule."},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment Flag (set to 1 if all MDSRs corresponding to this ADSR are blank, set to zero otherwise)."},
    {"line_num", e_tid_uint, NULL, 4, "1", "Range line number corresponding to the first line of the granule"},
    {"num_lines", e_tid_uint, "lines", 4, "1", "Number of output lines in this granule"},
    {"sub_sat_track", e_tid_float, "deg.", 4, "1", "Subsatellite track heading (relative to North) for first line of granule. This is the heading on the ground (includes Earth rotation)."},
    {"first_line_tie_points.samp_numbers", e_tid_uint, NULL, 4, "11", "Range sample number. Gives the range location of the grid points. First range sample is 1, last is M. Zero filled samples are included."},
    {"first_line_tie_points.slant_range_times", e_tid_float, "ns", 4, "11", "2 way slant range time to range sample"},
    {"first_line_tie_points.angles", e_tid_float, "deg.", 4, "11", "Incidence Angle at range sample"},
    {"first_line_tie_points.lats", e_tid_int, "(1e-6) degrees", 4, "11", "geodetic latitude (positive north)"},
    {"first_line_tie_points.longs", e_tid_int, "(1e-6) degrees", 4, "11", "geodetic longitude (positive east)"},
    {"spare_1", e_tid_spare, NULL, 22, "1", "Spare"},
    {"last_zero_doppler_time", e_tid_time, "MJD", 12, "1", "Zero doppler time for the last line of the granule"},
    {"last_line_tie_points.samp_numbers", e_tid_uint, NULL, 4, "11", "Range sample number. Gives the range location of the grid points. First range sample is 1, last is M."},
    {"last_line_tie_points.slant_range_times", e_tid_float, "ns", 4, "11", "2 way slant range time to range sample"},
    {"last_line_tie_points.angles", e_tid_float, "deg.", 4, "11", "Incidence Angle at range sample"},
    {"last_line_tie_points.lats", e_tid_int, "(1e-6) degrees", 4, "11", "geodetic latitude (positive north)"},
    {"last_line_tie_points.longs", e_tid_int, "(1e-6) degrees", 4, "11", "geodetic longitude (positive east)"},
    {"spare_2", e_tid_spare, NULL, 22, "1", "Spare"}
};

static const struct RecordDescriptor ASAR_Image_MDSR_BP_asar_rec_data[] = {
    {"zero_doppler_time", e_tid_time, "MJD", 12, "1", "Zero Doppler Time (MJD format)"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"line_num", e_tid_uint, NULL, 4, "1", "Range line number. Numbered sequentially, for each product (or slice) first range line in MDS is 1"},
    {"proc_data", e_tid_uchar, NULL, 1, "sceneRasterWidth", "SAR Processed Data for Browse Products (detected data)"}
};

static const struct RecordDescriptor ASAR_Image_MDSR_Gen_asar_rec_data[] = {
    {"zero_doppler_time", e_tid_time, "MJD", 12, "1", "Zero Doppler Time (MJD format)"},
    {"quality_flag", e_tid_char, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"line_num", e_tid_uint, NULL, 4, "1", "Range line number. Numbered sequentially, for each product (or slice) first range line in MDS is 1"},
    {"proc_data", e_tid_ushort, NULL, 2, "sceneRasterWidth", "SAR Processed Data. Real samples (detected products)"}
};

static const struct RecordDescriptor ASAR_Image_MDSR_SLC_asar_rec_data[] = {
    {"zero_doppler_time", e_tid_time, "MJD", 12, "1", "Zero Doppler Time (MJD format)"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"line_num", e_tid_uint, NULL, 4, "1", "Range line number. Numbered sequentially, for each product (or slice) first range line in MDS is 1"},
    {"proc_data", e_tid_short, NULL, 2, "2*sceneRasterWidth", "SAR Processed Data for SLC products.  Alternates Real Part, Imaginary Part, Real Part Imaginary Part)"}
};

static const struct RecordDescriptor ASAR_Main_ADSR_asar_rec_data[] = {
    {"first_zero_doppler_time", e_tid_time, "MJD", 12, "1", "First Zero Doppler Azimuth time of MDS which this data set describes Time of first range line in the MDS described by this data set."},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment Flag (always set to zero for this ADSR)"},
    {"last_zero_doppler_time", e_tid_time, "MJD", 12, "1", "Last Zero Doppler Azimuth time of MDS which this data set describes Time of last range line in the MDS described by this data set"},
    {"work_order_id", e_tid_string, "ascii", 12, "1", "Work Order ID (left-justified)"},
    {"time_diff", e_tid_float, "s", 4, "1", "Time difference between sensing time of first input line and zero Doppler time of first output image line (tdelta). (TBC)May be used during child product extraction from a stripline product (TBC). Left blank (set to zero) for non-stripline products."},
    {"swath_id", e_tid_string, "ascii", 3, "1", "Swath number IS1, IS2, IS3, IS4, IS5, IS6, or IS7 for IM, WV and AP modes.Set to WS&Oslash; for WS and GM modes"},
    {"range_spacing", e_tid_float, "m", 4, "1", "Range sample spacing"},
    {"azimuth_spacing", e_tid_float, "m", 4, "1", "Azimuth sample spacing at image center"},
    {"line_time_interval", e_tid_float, "s", 4, "1", "Azimuth sample spacing in time (Line Time Interval)"},
    {"num_output_lines", e_tid_uint, "lines", 4, "1", "Number of output range lines in the image described by this ADS"},
    {"num_samples_per_line", e_tid_uint, "samples", 4, "1", "Number of samples per output range line (includes zero filled samples)"},
    {"data_type", e_tid_string, "ascii", 5, "1", "Output data type. SWORD, UWORD, or UBYTE"},
    {"spare_1", e_tid_spare, NULL, 51, "1", "Spare"},
    {"data_analysis_flag", e_tid_uchar, "flag", 1, "1", "Raw Data Analysis used for Raw Data Correction. 0 = correction done using default parameters. 1 = correction done using raw data analysis results."},
    {"ant_elev_corr_flag", e_tid_uchar, "flag", 1, "1", "Antenna Elevation Pattern Correction Applied. 0 = no correction applied. 1 = correction applied."},
    {"chirp_extract_flag", e_tid_uchar, "flag", 1, "1", "Reconstructed Chirp used. 0 = nominal chirp replica used. 1 = reconstructed chirp used."},
    {"srgr_flag", e_tid_uchar, "flag", 1, "1", "Slant Range to Ground Range Conversion Applied. 0 = no conversion applied. 1 = conversion applied"},
    {"dop_cen_flag", e_tid_uchar, "flag", 1, "1", "Doppler Centroid Estimation Performed. 0 = no estimation done. 1 = estimation done."},
    {"dop_amb_flag", e_tid_uchar, "flag", 1, "1", "Doppler Ambiguity Estimation Performed. 0 = no estimate done. 1 = estimate done"},
    {"range_spread_comp_flag", e_tid_uchar, "flag", 1, "1", "Range-spreading loss compensation Applied. 0 = no compensation applied. 1 = compensation applied."},
    {"detected_flag", e_tid_uchar, "flag", 1, "1", "Detection Applied. 0 = output product is complex. 1 = output product was detected."},
    {"look_sum_flag", e_tid_uchar, "flag", 1, "1", "Look Summation Performed. 0 = product is single look. 1 = product is multi-looked."},
    {"rms_equal_flag", e_tid_uchar, "flag", 1, "1", "RMS Equalization performed. 0= rms equalization not performed during FBAQ decoding. 1 = rms equalization performed during FBAQ decoding."},
    {"ant_scal_flag", e_tid_uchar, "flag", 1, "1", "Antenna Elevation Gain Scaling Factor Applied. 0= no scaling factor applied. 1 =  scaling factor applied."},
    {"vga_com_echo_flag", e_tid_uchar, "flag", 1, "1", "Receive Gain Droop Compensation Applied to Echo Data. 0 = no compensation applied. 1 = compensation applied."},
    {"vga_com_pulse_2_flag", e_tid_uchar, "flag", 1, "1", "Receive Gain Droop Compensation Applied Calibration Pulse P2. 0 = no compensation applied. 1 = compensation applied."},
    {"vga_com_pulse_zero_flag", e_tid_uchar, "flag", 1, "1", "Receive Gain Droop Compensation Applied Calibration Pulse P2 Order Zero: Nominal Time Delay Applied. 0 = no compensation applied. 1 = compensation applied."},
    {"inv_filt_comp_flag", e_tid_uchar, "flag", 1, "1", "Inverse FIlter used for range compression (GM Mode only). 0 = matched filter used for range compression. 1 = inverse filter used for range compression"},
    {"spare_2", e_tid_spare, NULL, 6, "1", "Spare"},
    {"raw_data_analysis.1.num_gaps", e_tid_uint, "gaps", 4, "1", "Number of input data gaps (a gap is defined as a predetermined number of range lines) (record 1)"},
    {"raw_data_analysis.1.num_missing_lines", e_tid_uint, "lines", 4, "1", "Number of missing lines, excluding data gaps (record 1)"},
    {"raw_data_analysis.1.range_samp_skip", e_tid_uint, "samples", 4, "1", "Range sample skipping factor for raw data analysis (record 1)"},
    {"raw_data_analysis.1.range_lines_skip", e_tid_uint, "lines", 4, "1", "Range lines skipping factor for raw data analysis (record 1)"},
    {"raw_data_analysis.1.calc_i_bias", e_tid_float, NULL, 4, "1", "Calculated I channel bias (record 1)"},
    {"raw_data_analysis.1.calc_q_bias", e_tid_float, NULL, 4, "1", "Calculated Q channel bias (record 1)"},
    {"raw_data_analysis.1.calc_i_std_dev", e_tid_float, NULL, 4, "1", "Calculated I channel standard deviation (record 1)"},
    {"raw_data_analysis.1.calc_q_std_dev", e_tid_float, NULL, 4, "1", "Calculated Q channel standard deviation (record 1)"},
    {"raw_data_analysis.1.calc_gain", e_tid_float, NULL, 4, "1", "Calculated I/Q gain imbalance (record 1)"},
    {"raw_data_analysis.1.calc_quad", e_tid_float, NULL, 4, "1", "Calculated I/Q quadrature departure (record 1)"},
    {"raw_data_analysis.1.i_bias_max", e_tid_float, NULL, 4, "1", "I bias upper bound (record 1)"},
    {"raw_data_analysis.1.i_bias_min", e_tid_float, NULL, 4, "1", "I bias lower bound (record 1)"},
    {"raw_data_analysis.1.q_bias_max", e_tid_float, NULL, 4, "1", "Q bias upper bound (record 1)"},
    {"raw_data_analysis.1.q_bias_min", e_tid_float, NULL, 4, "1", "Q bias lower bound (record 1)"},
    {"raw_data_analysis.1.gain_min", e_tid_float, NULL, 4, "1", "I/Q gain lower bound (record 1)"},
    {"raw_data_analysis.1.gain_max", e_tid_float, NULL, 4, "1", "I/Q gain upper bound (record 1)"},
    {"raw_data_analysis.1.quad_min", e_tid_float, NULL, 4, "1", "I/Q quadrature departure lower bound (record 1)"},
    {"raw_data_analysis.1.quad_max", e_tid_float, NULL, 4, "1", "I/Q quadrature departure upper bound (record 1)"},
    {"raw_data_analysis.1.i_bias_flag", e_tid_uchar, "flag", 1, "1", "I bias significance. 0 = I bias falls within acceptable range. 1 = I bias falls outside acceptable range (record 1)"},
    {"raw_data_analysis.1.q_bias_flag", e_tid_uchar, "flag", 1, "1", "Q bias Significance. 0 = Q bias falls within acceptable range. 1 = Q bias falls outside acceptable range (record 1)"},
    {"raw_data_analysis.1.gain_flag", e_tid_uchar, "flag", 1, "1", "I/Q Gain Significance. 0 = Gain falls within acceptable range. 1 = Gain falls outside acceptable range (record 1)"},
    {"raw_data_analysis.1.quad_flag", e_tid_uchar, "flag", 1, "1", "I/Q Quadrature Departure Significance. 0 = Quadrature departure falls within acceptable range. 1 =Quadrature departure falls outside acceptable range (record 1)"},
    {"raw_data_analysis.1.used_i_bias", e_tid_float, NULL, 4, "1", "I channel bias used for correction (may be different from measured value) (record 1)"},
    {"raw_data_analysis.1.used_q_bias", e_tid_float, NULL, 4, "1", "Q channel bias used for correction (may be different from measured value) (record 1)"},
    {"raw_data_analysis.1.used_gain", e_tid_float, NULL, 4, "1", "I/Q gain imbalance used for correction (may be different from measured value) (record 1)"},
    {"raw_data_analysis.1.used_quad", e_tid_float, NULL, 4, "1", "I/Q quadrature departure used for correction (may be different from measured value) (record 1)"},
    {"raw_data_analysis.2.num_gaps", e_tid_uint, "gaps", 4, "1", "Number of input data gaps (a gap is defined as a predetermined number of range lines) (record 2)"},
    {"raw_data_analysis.2.num_missing_lines", e_tid_uint, "lines", 4, "1", "Number of missing lines, excluding data gaps (record 2)"},
    {"raw_data_analysis.2.range_samp_skip", e_tid_uint, "samples", 4, "1", "Range sample skipping factor for raw data analysis (record 2)"},
    {"raw_data_analysis.2.range_lines_skip", e_tid_uint, "lines", 4, "1", "Range lines skipping factor for raw data analysis (record 2)"},
    {"raw_data_analysis.2.calc_i_bias", e_tid_float, NULL, 4, "1", "Calculated I channel bias (record 2)"},
    {"raw_data_analysis.2.calc_q_bias", e_tid_float, NULL, 4, "1", "Calculated Q channel bias (record 2)"},
    {"raw_data_analysis.2.calc_i_std_dev", e_tid_float, NULL, 4, "1", "Calculated I channel standard deviation (record 2)"},
    {"raw_data_analysis.2.calc_q_std_dev", e_tid_float, NULL, 4, "1", "Calculated Q channel standard deviation (record 2)"},
    {"raw_data_analysis.2.calc_gain", e_tid_float, NULL, 4, "1", "Calculated I/Q gain imbalance (record 2)"},
    {"raw_data_analysis.2.calc_quad", e_tid_float, NULL, 4, "1", "Calculated I/Q quadrature departure (record 2)"},
    {"raw_data_analysis.2.i_bias_max", e_tid_float, NULL, 4, "1", "I bias upper bound (record 2)"},
    {"raw_data_analysis.2.i_bias_min", e_tid_float, NULL, 4, "1", "I bias lower bound (record 2)"},
    {"raw_data_analysis.2.q_bias_max", e_tid_float, NULL, 4, "1", "Q bias upper bound (record 2)"},
    {"raw_data_analysis.2.q_bias_min", e_tid_float, NULL, 4, "1", "Q bias lower bound (record 2)"},
    {"raw_data_analysis.2.gain_min", e_tid_float, NULL, 4, "1", "I/Q gain lower bound (record 2)"},
    {"raw_data_analysis.2.gain_max", e_tid_float, NULL, 4, "1", "I/Q gain upper bound (record 2)"},
    {"raw_data_analysis.2.quad_min", e_tid_float, NULL, 4, "1", "I/Q quadrature departure lower bound (record 2)"},
    {"raw_data_analysis.2.quad_max", e_tid_float, NULL, 4, "1", "I/Q quadrature departure upper bound (record 2)"},
    {"raw_data_analysis.2.i_bias_flag", e_tid_uchar, "flag", 1, "1", "I bias significance. 0 = I bias falls within acceptable range. 1 = I bias falls outside acceptable range (record 2)"},
    {"raw_data_analysis.2.q_bias_flag", e_tid_uchar, "flag", 1, "1", "Q bias Significance. 0 = Q bias falls within acceptable range. 1 = Q bias falls outside acceptable range (record 2)"},
    {"raw_data_analysis.2.gain_flag", e_tid_uchar, "flag", 1, "1", "I/Q Gain Significance. 0 = Gain falls within acceptable range. 1 = Gain falls outside acceptable range (record 2)"},
    {"raw_data_analysis.2.quad_flag", e_tid_uchar, "flag", 1, "1", "I/Q Quadrature Departure Significance. 0 = Quadrature departure falls within acceptable range. 1 =Quadrature departure falls outside acceptable range (record 2)"},
    {"raw_data_analysis.2.used_i_bias", e_tid_float, NULL, 4, "1", "I channel bias used for correction (may be different from measured value) (record 2)"},
    {"raw_data_analysis.2.used_q_bias", e_tid_float, NULL, 4, "1", "Q channel bias used for correction (may be different from measured value) (record 2)"},
    {"raw_data_analysis.2.used_gain", e_tid_float, NULL, 4, "1", "I/Q gain imbalance used for correction (may be different from measured value) (record 2)"},
    {"raw_data_analysis.2.used_quad", e_tid_float, NULL, 4, "1", "I/Q quadrature departure used for correction (may be different from measured value) (record 2)"},
    {"spare_3", e_tid_spare, NULL, 32, "1", "Spare"},
    {"start_time.1.first_obt", e_tid_uint, NULL, 4, "2", "On-board binary time of first input line processed. LSB accurate to 15.26 us. (Contained in two long integers) (record 1)"},
    {"start_time.1.first_mjd", e_tid_time, "MJD", 12, "1", "Sensing time (MJD format) of first input line processed converted from satellite binary time (record 1)"},
    {"start_time.2.first_obt", e_tid_uint, NULL, 4, "2", "On-board binary time of first input line processed. LSB accurate to 15.26 us. (Contained in two long integers) (record 2)"},
    {"start_time.2.first_mjd", e_tid_time, "MJD", 12, "1", "Sensing time (MJD format) of first input line processed converted from satellite binary time (record 2)"},
    {"parameter_codes.first_swst_code", e_tid_ushort, "code", 2, "5", "Sampling Window Start time code of first processed line"},
    {"parameter_codes.last_swst_code", e_tid_ushort, "code", 2, "5", "Sampling Window Start time code of last processed line"},
    {"parameter_codes.pri_code", e_tid_ushort, "code", 2, "5", "Pulse Repetition Interval code"},
    {"parameter_codes.tx_pulse_len_code", e_tid_ushort, "code", 2, "5", "Tx pulse length"},
    {"parameter_codes.tx_bw_code", e_tid_ushort, "code", 2, "5", "Tx pulse bandwidth"},
    {"parameter_codes.echo_win_len_code", e_tid_ushort, "code", 2, "5", "Echo Window Length"},
    {"parameter_codes.up_code", e_tid_ushort, "code", 2, "5", "Upconverter Level - Upconverter gain set on the instrument"},
    {"parameter_codes.down_code", e_tid_ushort, "code", 2, "5", "Downconverter Level - Downconverter gain set on the instrument"},
    {"parameter_codes.resamp_code", e_tid_ushort, "code", 2, "5", "Resampling factor for echo data"},
    {"parameter_codes.beam_adj_code", e_tid_ushort, "code", 2, "5", "Beam adjustment delta"},
    {"parameter_codes.beam_set_num_code", e_tid_ushort, "code", 2, "5", "Antenna Beam Set Number"},
    {"parameter_codes.tx_monitor_code", e_tid_ushort, "code", 2, "5", "Auxiliary Tx Monitor Level"},
    {"spare_4", e_tid_spare, NULL, 60, "1", "Spare"},
    {"error_counters.num_err_swst", e_tid_uint, NULL, 4, "1", "Number of errors detected in Sampling Window start time field."},
    {"error_counters.num_err_pri", e_tid_uint, NULL, 4, "1", "Number of errors detected in PRI code field"},
    {"error_counters.num_err_tx_pulse_len", e_tid_uint, NULL, 4, "1", "Number of errors detected in Tx pulse length field"},
    {"error_counters.num_err_tx_pulse_bw", e_tid_uint, NULL, 4, "1", "Number of errors detected in Tx pulse bandwidth field."},
    {"error_counters.num_err_echo_win_len", e_tid_uint, NULL, 4, "1", "Number of errors detected in Echo Window Length field."},
    {"error_counters.num_err_up", e_tid_uint, NULL, 4, "1", "Number of errors detected in Upconverter Level field."},
    {"error_counters.num_err_down", e_tid_uint, NULL, 4, "1", "Number of errors detected in Downconverter Level field."},
    {"error_counters.num_err_resamp", e_tid_uint, NULL, 4, "1", "Number of errors detected in Resampling factor for echo data field."},
    {"error_counters.num_err_beam_adj", e_tid_uint, NULL, 4, "1", "Number of errors detected in Beam adjustment delta field."},
    {"error_counters.num_err_beam_set_num", e_tid_uint, NULL, 4, "1", "Number of errors detected in Antenna Beam Set Number field."},
    {"spare_5", e_tid_spare, NULL, 26, "1", "Spare"},
    {"image_parameters.first_swst_value", e_tid_float, "s", 4, "5", "Sampling Window Start time of first processed line"},
    {"image_parameters.last_swst_value", e_tid_float, "s", 4, "5", "Sampling Window Start time of last processed line"},
    {"image_parameters.swst_changes", e_tid_uint, NULL, 4, "5", "Number of Sample Window Start Time changes within a beam"},
    {"image_parameters.prf_value", e_tid_float, "Hz", 4, "5", "Pulse Repetition Frequency"},
    {"image_parameters.tx_pulse_len_value", e_tid_float, "s", 4, "5", "Tx pulse length"},
    {"image_parameters.tx_pulse_bw_value", e_tid_float, "Hz", 4, "5", "Tx pulse bandwidth"},
    {"image_parameters.echo_win_len_value", e_tid_float, "s", 4, "5", "Echo Window Length"},
    {"image_parameters.up_value", e_tid_float, "dB", 4, "5", "Upconverter Level - Upconverter gain set on the instrument"},
    {"image_parameters.down_value", e_tid_float, "dB", 4, "5", "Downconverter Level - Downconverter gain set on the instrument"},
    {"image_parameters.resamp_value", e_tid_float, NULL, 4, "5", "Resampling factor"},
    {"image_parameters.beam_adj_value", e_tid_float, "deg.", 4, "5", "Beam adjustment delta"},
    {"image_parameters.beam_set_value", e_tid_ushort, NULL, 2, "5", "Antenna Beam Set Number"},
    {"image_parameters.tx_monitor_value", e_tid_float, NULL, 4, "5", "Auxiliary Tx Monitor Level"},
    {"spare_6", e_tid_spare, NULL, 82, "1", "Spare"},
    {"first_proc_range_samp", e_tid_uint, "samples", 4, "1", "First processed input range sample, first sample is 1"},
    {"range_ref", e_tid_float, "m", 4, "1", "Range spreading loss reference range"},
    {"range_samp_rate", e_tid_float, "Hz", 4, "1", "Range sampling rate"},
    {"radar_freq", e_tid_float, "Hz", 4, "1", "Radar Frequency"},
    {"num_looks_range", e_tid_ushort, "looks", 2, "1", "Number of range looks"},
    {"filter_window", e_tid_string, "ascii", 7, "1", "Matched filter window type:HAMMING or KAISER&Oslash; or NONE&Oslash;&Oslash;&Oslash;"},
    {"window_coef_range", e_tid_float, NULL, 4, "1", "Window coefficient for range-matched filter"},
    {"bandwidth.look_bw_range", e_tid_float, "Hz", 4, "5", "Range Look Bandwidth (null to null)"},
    {"bandwidth.tot_bw_range", e_tid_float, "Hz", 4, "5", "Total processed range bandwidth (null to null)"},
    {"nominal_chirp.1.nom_chirp_amp", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 nominal chirp amplitude coefficients (record 1)"},
    {"nominal_chirp.1.nom_chirp_phs", e_tid_float, "cycles,Hz,Hz/s,Hz/s2", 4, "4", "4 nominal chirp phase coefficients (record 1)"},
    {"nominal_chirp.2.nom_chirp_amp", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 nominal chirp amplitude coefficients (record 2)"},
    {"nominal_chirp.2.nom_chirp_phs", e_tid_float, "cycles,Hz,Hz/s,Hz/s2", 4, "4", "4 nominal chirp phase coefficients (record 2)"},
    {"nominal_chirp.3.nom_chirp_amp", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 nominal chirp amplitude coefficients (record 3)"},
    {"nominal_chirp.3.nom_chirp_phs", e_tid_float, "cycles,Hz,Hz/s,Hz/s2", 4, "4", "4 nominal chirp phase coefficients (record 3)"},
    {"nominal_chirp.4.nom_chirp_amp", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 nominal chirp amplitude coefficients (record 4)"},
    {"nominal_chirp.4.nom_chirp_phs", e_tid_float, "cycles,Hz,Hz/s,Hz/s2", 4, "4", "4 nominal chirp phase coefficients (record 4)"},
    {"nominal_chirp.5.nom_chirp_amp", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 nominal chirp amplitude coefficients (record 5)"},
    {"nominal_chirp.5.nom_chirp_phs", e_tid_float, "cycles,Hz,Hz/s,Hz/s2", 4, "4", "4 nominal chirp phase coefficients (record 5)"},
    {"spare_7", e_tid_spare, NULL, 60, "1", "Spare"},
    {"num_lines_proc", e_tid_uint, "lines", 4, "1", "Number of input lines processed"},
    {"num_look_az", e_tid_ushort, "looks", 2, "1", "Number of Azimuth Looks"},
    {"look_bw_az", e_tid_float, "Hz", 4, "1", "Azimuth Look Bandwidth (null to null) -- this is the nominal value only for GM, WS, and AP."},
    {"to_bw_az", e_tid_float, "Hz", 4, "1", "Processed Azimuth bandwidth (null to null) -- this field is used only for IM products and WV imagettes. Filled with zeros otherwise."},
    {"filter_az", e_tid_string, "ascii", 7, "1", "Matched filter window type:HAMMING or KAISER&Oslash; or NONE&Oslash;&Oslash;&Oslash;"},
    {"filter_coef_az", e_tid_float, NULL, 4, "1", "Window coefficient for azimuth-matched filter"},
    {"az_fm_rate", e_tid_float, "Hz/sHz/s2Hz/s3", 4, "3", "3 co-efficients for Azimuth FM rate: Azimuth FM rate = C0 + C1(tSR-t0) + C2(tSR - t0)2tSR = 2 way slant range time"},
    {"ax_fm_origin", e_tid_float, "ns", 4, "1", "2 way slant range time origin (t0) for Azimuth FM rate calculation"},
    {"dop_amb_conf", e_tid_float, NULL, 4, "1", "Doppler Centroid Ambiguity Confidence Measure. Value between 0 and 1, 0 = poorest confidence, 1= highest confidence"},
    {"spare_8", e_tid_spare, NULL, 68, "1", "Spare"},
    {"calibration_factors.1.proc_scaling_fact", e_tid_float, NULL, 4, "1", "Processor scaling factor (factor units are linear when using Range/Doppler algorithm, dB when Specan is used) (record 1)"},
    {"calibration_factors.1.ext_cal_fact", e_tid_float, NULL, 4, "1", "External Calibration Scaling Factor (mode/swath/polarization dependent) (record 1)"},
    {"calibration_factors.2.proc_scaling_fact", e_tid_float, NULL, 4, "1", "Processor scaling factor (factor units are linear when using Range/Doppler algorithm, dB when Specan is used) (record 2)"},
    {"calibration_factors.2.ext_cal_fact", e_tid_float, NULL, 4, "1", "External Calibration Scaling Factor (mode/swath/polarization dependent) (record 2)"},
    {"noise_estimation.noise_power_corr", e_tid_float, NULL, 4, "5", "Noise power correction factors"},
    {"noise_estimation.num_noise_lines", e_tid_uint, NULL, 4, "5", "Number of noise lines used to calculate factors"},
    {"spare_9", e_tid_spare, NULL, 64, "1", "Spare"},
    {"spare_10", e_tid_spare, NULL, 12, "1", "Spare"},
    {"output_statistics.1.out_mean", e_tid_float, NULL, 4, "1", "Output data mean. Magnitude for detected products, real sample mean for SLC products (record 1)"},
    {"output_statistics.1.out_imag_mean", e_tid_float, NULL, 4, "1", "Output imaginary data mean. Used for SLC products only (set to zero otherwise) (record 1)"},
    {"output_statistics.1.out_std_dev", e_tid_float, NULL, 4, "1", "Output data standard deviation. Magnitude std. dev. for detected products, real sample std. dev. for SLC products (record 1)"},
    {"output_statistics.1.out_imag_std_dev", e_tid_float, NULL, 4, "1", "Output imaginary data standard deviation. Used for SLC products only (set to zero otherwise) (record 1)"},
    {"output_statistics.2.out_mean", e_tid_float, NULL, 4, "1", "Output data mean. Magnitude for detected products, real sample mean for SLC products (record 2)"},
    {"output_statistics.2.out_imag_mean", e_tid_float, NULL, 4, "1", "Output imaginary data mean. Used for SLC products only (set to zero otherwise) (record 2)"},
    {"output_statistics.2.out_std_dev", e_tid_float, NULL, 4, "1", "Output data standard deviation. Magnitude std. dev. for detected products, real sample std. dev. for SLC products (record 2)"},
    {"output_statistics.2.out_imag_std_dev", e_tid_float, NULL, 4, "1", "Output imaginary data standard deviation. Used for SLC products only (set to zero otherwise) (record 2)"},
    {"spare_11", e_tid_spare, NULL, 52, "1", "Spare"},
    {"echo_comp", e_tid_string, "ascii", 4, "1", "Compression Method used for echo samples. FBAQ, S&amp;M&Oslash;, NONE"},
    {"echo_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for echo samples. 8/4, 8/3, 8/2, or 8/8"},
    {"init_cal_comp", e_tid_string, "ascii", 4, "1", "Compression Method used for initial calibration samples. FBAQ, S&amp;M&Oslash;, NONE"},
    {"init_cal_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for initial calibration samples. 8/4, 8/3, 8/2, or 8/8"},
    {"per_cal_comp", e_tid_string, "ascii", 4, "1", "Compression Method used for periodic calibration samples. FBAQ, S&amp;M&Oslash;, NONE"},
    {"per_cal_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for periodic calibration samples. 8/4, 8/3, 8/2, or 8/8"},
    {"noise_comp", e_tid_string, "ascii", 4, "1", "Compression Method used for noise samples. FBAQ, S&amp;M&Oslash;, NONE"},
    {"noise_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for noise samples. 8/4, 8/3, 8/2, or 8/8"},
    {"spare_12", e_tid_spare, NULL, 64, "1", "Spare"},
    {"beam_merge_sl_range", e_tid_uint, NULL, 4, "4", "Number of slant range samples in beam merging, one value per mergae rregion (1-2, 2-3, 3-4, 4-5)"},
    {"beam_merge_alg_param", e_tid_float, NULL, 4, "4", "Beam merge algorithm parameter used for beam merging, one value per merge region (1-2, 2-3, 3-4. 4-5)"},
    {"lines_per_burst", e_tid_uint, "lines", 4, "5", "Number of lines per burst for this image. 5 values for beams SS1 to SS5 in WS and GM modes. Two values for AP mode, all others set to zero."},
    {"spare_13", e_tid_spare, NULL, 28, "1", "Spare"},
    {"orbit_state_vectors.1.state_vect_time_1", e_tid_time, "MJD", 12, "1", "Time of state vector (record 1)"},
    {"orbit_state_vectors.1.x_pos_1", e_tid_int, "10 -2m", 4, "1", "X position in Earth fixed reference frame (record 1)"},
    {"orbit_state_vectors.1.y_pos_1", e_tid_int, "10 -2m", 4, "1", "Y position in Earth fixed reference frame (record 1)"},
    {"orbit_state_vectors.1.z_pos_1", e_tid_int, "10 -2m", 4, "1", "Z position in Earth fixed reference frame (record 1)"},
    {"orbit_state_vectors.1.x_vel_1", e_tid_int, "10 -5m/s", 4, "1", "X velocity relative to Earth fixed reference frame (record 1)"},
    {"orbit_state_vectors.1.y_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Y velocity relative to Earth fixed reference frame (record 1)"},
    {"orbit_state_vectors.1.z_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Z velocity relative to Earth fixed reference frame (record 1)"},
    {"orbit_state_vectors.2.state_vect_time_1", e_tid_time, "MJD", 12, "1", "Time of state vector (record 2)"},
    {"orbit_state_vectors.2.x_pos_1", e_tid_int, "10 -2m", 4, "1", "X position in Earth fixed reference frame (record 2)"},
    {"orbit_state_vectors.2.y_pos_1", e_tid_int, "10 -2m", 4, "1", "Y position in Earth fixed reference frame (record 2)"},
    {"orbit_state_vectors.2.z_pos_1", e_tid_int, "10 -2m", 4, "1", "Z position in Earth fixed reference frame (record 2)"},
    {"orbit_state_vectors.2.x_vel_1", e_tid_int, "10 -5m/s", 4, "1", "X velocity relative to Earth fixed reference frame (record 2)"},
    {"orbit_state_vectors.2.y_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Y velocity relative to Earth fixed reference frame (record 2)"},
    {"orbit_state_vectors.2.z_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Z velocity relative to Earth fixed reference frame (record 2)"},
    {"orbit_state_vectors.3.state_vect_time_1", e_tid_time, "MJD", 12, "1", "Time of state vector (record 3)"},
    {"orbit_state_vectors.3.x_pos_1", e_tid_int, "10 -2m", 4, "1", "X position in Earth fixed reference frame (record 3)"},
    {"orbit_state_vectors.3.y_pos_1", e_tid_int, "10 -2m", 4, "1", "Y position in Earth fixed reference frame (record 3)"},
    {"orbit_state_vectors.3.z_pos_1", e_tid_int, "10 -2m", 4, "1", "Z position in Earth fixed reference frame (record 3)"},
    {"orbit_state_vectors.3.x_vel_1", e_tid_int, "10 -5m/s", 4, "1", "X velocity relative to Earth fixed reference frame (record 3)"},
    {"orbit_state_vectors.3.y_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Y velocity relative to Earth fixed reference frame (record 3)"},
    {"orbit_state_vectors.3.z_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Z velocity relative to Earth fixed reference frame (record 3)"},
    {"orbit_state_vectors.4.state_vect_time_1", e_tid_time, "MJD", 12, "1", "Time of state vector (record 4)"},
    {"orbit_state_vectors.4.x_pos_1", e_tid_int, "10 -2m", 4, "1", "X position in Earth fixed reference frame (record 4)"},
    {"orbit_state_vectors.4.y_pos_1", e_tid_int, "10 -2m", 4, "1", "Y position in Earth fixed reference frame (record 4)"},
    {"orbit_state_vectors.4.z_pos_1", e_tid_int, "10 -2m", 4, "1", "Z position in Earth fixed reference frame (record 4)"},
    {"orbit_state_vectors.4.x_vel_1", e_tid_int, "10 -5m/s", 4, "1", "X velocity relative to Earth fixed reference frame (record 4)"},
    {"orbit_state_vectors.4.y_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Y velocity relative to Earth fixed reference frame (record 4)"},
    {"orbit_state_vectors.4.z_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Z velocity relative to Earth fixed reference frame (record 4)"},
    {"orbit_state_vectors.5.state_vect_time_1", e_tid_time, "MJD", 12, "1", "Time of state vector (record 5)"},
    {"orbit_state_vectors.5.x_pos_1", e_tid_int, "10 -2m", 4, "1", "X position in Earth fixed reference frame (record 5)"},
    {"orbit_state_vectors.5.y_pos_1", e_tid_int, "10 -2m", 4, "1", "Y position in Earth fixed reference frame (record 5)"},
    {"orbit_state_vectors.5.z_pos_1", e_tid_int, "10 -2m", 4, "1", "Z position in Earth fixed reference frame (record 5)"},
    {"orbit_state_vectors.5.x_vel_1", e_tid_int, "10 -5m/s", 4, "1", "X velocity relative to Earth fixed reference frame (record 5)"},
    {"orbit_state_vectors.5.y_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Y velocity relative to Earth fixed reference frame (record 5)"},
    {"orbit_state_vectors.5.z_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Z velocity relative to Earth fixed reference frame (record 5)"},
    {"spare_14", e_tid_spare, NULL, 64, "1", "Spare"}
};

static const struct RecordDescriptor ASAR_Map_GADS_asar_rec_data[] = {
    {"map_descriptor", e_tid_string, "ascii", 32, "1", "Map projection descriptorone of:UNIVERSAL_TRANSVERSE_MERCATOR&Oslash;&Oslash;&Oslash;UNIVERSAL_POLAR_STEREOGRAPHIC&Oslash;&Oslash;&Oslash;LAMBERT_CONFORMAL_CONIC&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;TRANSVERSE_MERCATOR&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;MERCATOR&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;POLAR_STEREOGRAPHIC&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;&Oslash;"},
    {"samples", e_tid_uint, NULL, 4, "1", "Number of samples per line"},
    {"lines", e_tid_uint, NULL, 4, "1", "Number of lines"},
    {"sample_spacing", e_tid_float, "m", 4, "1", "Nominal inter-sample distance"},
    {"line_spacing", e_tid_float, "m", 4, "1", "Nominal inter-line distance"},
    {"orientation", e_tid_float, "deg", 4, "1", "Output scene centre orientation"},
    {"spare_1", e_tid_spare, NULL, 40, "1", "Spare"},
    {"heading", e_tid_float, "deg", 4, "1", "Platform heading, degrees"},
    {"ellipsoid_name", e_tid_string, "ascii", 32, "1", "Reference ellipsoid name"},
    {"semi_major", e_tid_float, "m", 4, "1", "Ellipsoid semi-major axis, metres"},
    {"semi_minor", e_tid_float, "m", 4, "1", "Ellipsoid semi-minor axis, metres"},
    {"shift_dx", e_tid_float, "m", 4, "1", "Datum shift parameter referenced to Greenwich: dx (metres)"},
    {"shift_dy", e_tid_float, "m", 4, "1", "Datum shift parameter perpendicular to Greenwich: dy (metres)"},
    {"shift_dz", e_tid_float, "m", 4, "1", "Datum shift parameter direction of the rotation axis: dz (metres)"},
    {"avg_height", e_tid_float, NULL, 4, "1", "average scene height above ellipsoid used for geocoding"},
    {"spare_2", e_tid_spare, NULL, 12, "1", "Spare"},
    {"projection_description", e_tid_string, "ascii", 32, "1", "Map projection alphanumeric description"},
    {"utm_descriptor", e_tid_string, "ascii", 32, "1", "UTM descriptorUNIVERSAL_TRANSVERSE_MERCATOR&Oslash;&Oslash;&Oslash;"},
    {"utm_zone", e_tid_string, "ascii", 4, "1", "UTM zone signature"},
    {"utm_origin_easting", e_tid_float, "m", 4, "1", "Map origin, false easting"},
    {"utm_origin_northing", e_tid_float, "m", 4, "1", "Map origin, false northing"},
    {"utm_center_long", e_tid_int, "(1e-6) degrees", 4, "1", "Projection centre longitude, deg"},
    {"utm_center_lat", e_tid_int, "(1e-6) degrees", 4, "1", "Projection centre latitude, deg"},
    {"utm_para1", e_tid_float, "deg", 4, "1", "1st standard parallel, deg"},
    {"utm_para2", e_tid_float, "deg", 4, "1", "2nd standard parallel, deg"},
    {"utm_scale", e_tid_float, NULL, 4, "1", "Scale factor"},
    {"ups_descriptor", e_tid_string, "ascii", 32, "1", "UPS descriptor"},
    {"ups_center_long", e_tid_int, "(1e-6) degrees", 4, "1", "Projection centre longitude, deg"},
    {"ups_center_lat", e_tid_int, "(1e-6) degrees", 4, "1", "Projection centre latitude, deg"},
    {"ups_scale", e_tid_float, NULL, 4, "1", "Scale factor"},
    {"nsp_descriptor", e_tid_string, "ascii", 32, "1", "NSP descriptor"},
    {"origin_easting", e_tid_float, "m", 4, "1", "Map origin, false easting"},
    {"origin_northing", e_tid_float, "m", 4, "1", "Map origin, false northing"},
    {"center_long", e_tid_int, "(1e-6) degrees", 4, "1", "Projection centre longitude, deg"},
    {"center_lat", e_tid_int, "(1e-6) degrees", 4, "1", "Projection centre latitude, deg"},
    {"standard_parallel_parameters.para1", e_tid_float, "deg", 4, "1", "Standard parallel1, deg"},
    {"standard_parallel_parameters.para2", e_tid_float, "deg", 4, "1", "Standard parallel2, deg"},
    {"standard_parallel_parameters.para3", e_tid_float, "deg", 4, "1", "Standard parallel3, deg"},
    {"standard_parallel_parameters.para4", e_tid_float, "deg", 4, "1", "Standard parallel4, deg"},
    {"central_meridian_parameters.central_m1", e_tid_float, "deg", 4, "1", "Central meridian1, deg"},
    {"central_meridian_parameters.central_m2", e_tid_float, "deg", 4, "1", "Central meridian2, deg"},
    {"central_meridian_parameters.central_m3", e_tid_float, "deg", 4, "1", "Central meridian3, deg"},
    {"projection_parameters.spare_3", e_tid_spare, NULL, 4, "1", "Spare"},
    {"projection_parameters.spare_4", e_tid_spare, NULL, 4, "1", "Spare"},
    {"projection_parameters.spare_5", e_tid_spare, NULL, 4, "1", "Spare"},
    {"projection_parameters.spare_6", e_tid_spare, NULL, 4, "1", "Spare"},
    {"position_northings_eastings.tl_northing", e_tid_float, "m", 4, "1", "Top left corner northing, meters;"},
    {"position_northings_eastings.tl_easting", e_tid_float, "m", 4, "1", "Top left corner easting, meters;"},
    {"position_northings_eastings.tr_northing", e_tid_float, "m", 4, "1", "Top right corner northing, meters;"},
    {"position_northings_eastings.tr_easting", e_tid_float, "m", 4, "1", "Top right corner easting, meters;"},
    {"position_northings_eastings.br_northing", e_tid_float, "m", 4, "1", "Bottom right corner northing, meters;"},
    {"position_northings_eastings.br_easting", e_tid_float, "m", 4, "1", "Bottom right corner easting, meters;"},
    {"position_northings_eastings.bl_northing", e_tid_float, "m", 4, "1", "Bottom left corner northing, meters;"},
    {"position_northings_eastings.bl_easting", e_tid_float, "m", 4, "1", "Bottom left corner easting, meters;"},
    {"position_lat_long.tl_lat", e_tid_int, "(1e-6) degrees", 4, "1", "Top left corner latitude"},
    {"position_lat_long.tl_long", e_tid_int, "(1e-6) degrees", 4, "1", "Top left corner longitude"},
    {"position_lat_long.tr_lat", e_tid_int, "(1e-6) degrees", 4, "1", "Top right corner latitude"},
    {"position_lat_long.tr_long", e_tid_int, "(1e-6) degrees", 4, "1", "Top right corner longitude"},
    {"position_lat_long.br_lat", e_tid_int, "(1e-6) degrees", 4, "1", "Bottom right corner latitude"},
    {"position_lat_long.br_long", e_tid_int, "(1e-6) degrees", 4, "1", "Bottom right corner longitude"},
    {"position_lat_long.bl_lat", e_tid_int, "(1e-6) degrees", 4, "1", "Bottom left corner latitude"},
    {"position_lat_long.bl_long", e_tid_int, "(1e-6) degrees", 4, "1", "Bottom left corner longitude"},
    {"spare_7", e_tid_spare, NULL, 32, "1", "Spare"},
    {"image_to_map_coefs", e_tid_float, NULL, 4, "8", "8 coefficients to convert a line(L) and sample (S) position to the map projection frame of reference, say (E,N)E = A11 + A12*L + A13 *S + A14 *L*SN = A21 + A22*L + A23 *S + A24 *L*S"},
    {"map_to_image_coefs", e_tid_float, NULL, 4, "8", "8 coefficients to convert from the map projection (E,N) to line (L) and sample(S) position in the imageL = B11 + B12*E + B13 *N + B14 *E*NS = B21 + B22*E + B23 *N + B24 *E*N"},
    {"spare_8", e_tid_spare, NULL, 35, "1", "Spare"}
};

static const struct RecordDescriptor ASAR_Ocean_Spectra_MDSR_asar_rec_data[] = {
    {"zero_doppler_time", e_tid_time, "MJD", 12, "1", "First Zero Doppler Azimuth time of the wave cellTime of first range line in the SLC Imagette MDS described by this data set"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"range_spectral_res", e_tid_float, NULL, 4, "1", "Range spectral bin size of the cartesian cross spectrum"},
    {"az_spectral_res", e_tid_float, NULL, 4, "1", "Azimuth spectral bin size of the cartesian cross spectrum"},
    {"spare_1", e_tid_spare, NULL, 4, "1", "Spare"},
    {"spec_tot_energy", e_tid_float, NULL, 4, "1", "Spectrum Total Energy"},
    {"spec_max_energy", e_tid_float, NULL, 4, "1", "Spectrum Max Energy"},
    {"spec_max_dir", e_tid_float, "deg", 4, "1", "Direction of Spectrum Max (deg)on higher resolution grid"},
    {"spec_max_wl", e_tid_float, "m", 4, "1", "Wavelength of Spectrum Max (m)on higher resolution grid"},
    {"az_image_shift_var", e_tid_float, "m^2", 4, "1", "Variance of the azimuth image shift caused by the orbital velocity"},
    {"az_cutoff", e_tid_float, "m", 4, "1", "Azimuthal Clutter Cut-off length (m)"},
    {"nonlinear_spectral_width", e_tid_float, "m", 4, "1", "Spectral width of the non-linear part of the cross spectra"},
    {"image_intensity", e_tid_float, NULL, 4, "1", "Image intensity"},
    {"image_variance", e_tid_float, NULL, 4, "1", "Normalised image variance"},
    {"spare_2", e_tid_spare, NULL, 56, "1", "Spare"},
    {"min_spectrum", e_tid_float, "m^4", 4, "1", "Min value of ocean wave spectrum"},
    {"max_spectrum", e_tid_float, "m^4", 4, "1", "Max value of ocean wave spectrum"},
    {"spare_3", e_tid_spare, NULL, 8, "1", "Spare"},
    {"wind_speed", e_tid_float, "m/s", 4, "1", "Forcast Wind speed (if provided)"},
    {"wind_direction", e_tid_float, "deg", 4, "1", "Forcast Wind direction (if provided)"},
    {"SAR_wave_height", e_tid_float, "m", 4, "1", "SAR swell wave height"},
    {"SAR_az_shift_var", e_tid_float, "m^2", 4, "1", "Variance of the azimuth shift computed from the SAR swell wave spectra"},
    {"backscatter", e_tid_float, "dB", 4, "1", "Backscattering coefficient"},
    {"confidence", e_tid_int, NULL, 4, "1", "Confidence measure of the swell inversion"},
    {"signal_to_noise", e_tid_float, NULL, 4, "1", "Average signal-to-noise ratio"},
    {"radar_vel_corr", e_tid_float, "m/s", 4, "1", "Radar velocity off-set correction"},
    {"cmod_cal_const", e_tid_float, NULL, 4, "1", "Calibration constant - CMOD"},
    {"spare_4", e_tid_spare, NULL, 28, "1", "Spare"},
    {"ocean_spectra", e_tid_uchar, NULL, 1, "!REF_TBD!", "Ocean Wave Swell spectra polar grid. Number of bins in wavelength and direction defined in SPH (nominally 24 by 36). Arranged as 24 wavelength cells from shortest to longest wavelength, for zero degrees, then 10 degrees, up to 350 degrees."}
};

static const struct RecordDescriptor ASAR_Spectra_MDSR_asar_rec_data[] = {
    {"zero_doppler_time", e_tid_time, "MJD", 12, "1", "First Zero Doppler Azimuth time of the wave cellTime of first range line in the SLC Imagette MDS described by this data set"},
    {"quality_flag", e_tid_uchar, "flag", 1, "1", "Quality Indicator (-1 for blank MDSR, 0 otherwise)"},
    {"range_spectral_res", e_tid_float, NULL, 4, "1", "Range spectral resolution of the cartesian cross spectrum"},
    {"az_spectral_res", e_tid_float, NULL, 4, "1", "Azimuth spectral resolution of the cartesian cross spectrum"},
    {"az_resample_factor", e_tid_float, NULL, 4, "1", "Azimuth re-sampling factor in look extraction(Swath specific)"},
    {"spec_tot_energy", e_tid_float, NULL, 4, "1", "Spectrum Total Energy"},
    {"spec_max_energy", e_tid_float, NULL, 4, "1", "Spectrum Max Energy"},
    {"spec_max_dir", e_tid_float, "deg", 4, "1", "Direction of Spectrum Max (deg)on higher resolution grid"},
    {"spec_max_wl", e_tid_float, "m", 4, "1", "Wavelength of Spectrum Max (m)on higher resolution grid"},
    {"clutter_noise", e_tid_float, NULL, 4, "1", "Clutter Noise"},
    {"az_cutoff", e_tid_float, "m", 4, "1", "Azimuthal Clutter Cut-off length (m)"},
    {"num_iterations", e_tid_float, NULL, 4, "1", "Number of iterations to compute Azimuthal Clutter Cut-off"},
    {"range_offset", e_tid_float, "m", 4, "1", "Range offset of peak of cross covariance function (m)"},
    {"ax_offset", e_tid_float, "m", 4, "1", "Azimuth offset of peak of cross covariance function (m)"},
    {"cc_range_res", e_tid_float, "rad/m", 4, "1", "Range resolution of cross co-variance spectrum (rad/m)"},
    {"cc_azimuth_res", e_tid_float, "rad/m", 4, "1", "Azimuth resolution of cross co-variance spectrum (rad/m)"},
    {"sublook_means", e_tid_float, NULL, 4, "2", "1st and last Sub-look Image Means"},
    {"sublook_variance", e_tid_float, NULL, 4, "2", "1st and last Sub-look Image Variance"},
    {"sublook_skewness", e_tid_float, NULL, 4, "2", "1st and last Sub-look Image Skewness"},
    {"sublook_kurtosis", e_tid_float, NULL, 4, "2", "1st and last Sub-look Image Kurtosis"},
    {"range_sublook_detrend_coeff", e_tid_float, NULL, 4, "2", "1st and last Sub-look de-trend coefficient in range"},
    {"az_sublook_detrend_coeff", e_tid_float, NULL, 4, "2", "1st and last Sub-look de-trend coefficient in azimuth"},
    {"min_imag", e_tid_float, NULL, 4, "1", "Min value of Imaginary part of cross spectrum"},
    {"max_imag", e_tid_float, NULL, 4, "1", "Max value of Imaginary part of cross spectrum"},
    {"min_real", e_tid_float, NULL, 4, "1", "Min value of Real part of cross spectrum"},
    {"max_real", e_tid_float, NULL, 4, "1", "Max value of Real part of cross spectrum"},
    {"spare_1", e_tid_spare, NULL, 64, "1", "Spare"},
    {"real_spectra", e_tid_uchar, NULL, 1, ".SPH.num_wl_bins,.SPH.num_dir_bins", "Real part of cross spectra polar gridNumber of bins in wavelength and direction defined in SPH (nominally 24 by 36). However, only 0 to 180 degree of the spectrum need be supplied (24 by 18). Arranged as: 24 wavelength values for 0-10 deg. sector, 24 valu"},
    {"imag_spectra", e_tid_uchar, NULL, 1, ".SPH.num_wl_bins,.SPH.num_dir_bins", "Complex part of cross spectra polar gridNumber of bins in wavelength and direction defined in SPH (nominally 24 by 36). However, only 0 to 180 degree of the spectrum need be supplied (24 by 18). Arranged as: 24 wavelength values for 0-10 deg. sector, 24 v"}
};

static const struct RecordDescriptor ASAR_SQ1_Image_ADSR_asar_rec_data[] = {
    {"zero_doppler_time", e_tid_time, "MJD", 12, "1", "Zero doppler time at which SQ information applies"},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment Flag (set to 1 if all MDSRs corresponding to this ADSR are blank, set to zero otherwise).Note: in practice for ASAR products, this flag will always be zero since this ADSR is updated once per slice or scene. Therefore, if there are no MDSRs, this ADSR is not produced at all."},
    {"input_mean_flag", e_tid_uchar, "flag", 1, "1", "Input data mean outside nominal range flag. 0 = mean of I and Q input values are both within specified range from expected mean. For expected mean of x, the measured mean must fall between x-threshold to x+threshold. 1 = otherwise"},
    {"input_std_dev_flag", e_tid_uchar, "flag", 1, "1", "Input data standard deviation outside nominal range flag. 0 = standard deviation values of I and Q input values are both within specified range of expected standard deviation. For expected std. dev. x, the measured std. dev. must fall between x-threshold to x+threshold. 1 = otherwise"},
    {"input_gaps_flag", e_tid_uchar, "flag", 1, "1", "Significant gaps in the input data flag. An input data gap is defined as a contiguous block of N missing lines (the value of N is predefined for each product). 0 = number of input gaps &lt;= threshold value. 1 = number of input data gaps &gt; threshold value"},
    {"input_missing_lines_flag", e_tid_uchar, "flag", 1, "1", "Missing lines significant flag. 0 = percentage of missing lines &lt;= threshold value 1 = percentage of missing lines &gt; threshold value. The number of missing lines is the number of lines missing from the input data excluding data gaps."},
    {"dop_cen_flag", e_tid_uchar, "flag", 1, "1", "Doppler Centroid Uncertain flag. 0 = confidence measure &gt;= specified value. 1 = confidence measure &lt; specified value (note: if more than one Doppler centroid estimation is performed in a slice the flag is set if any confidence measure is less than the threshold)."},
    {"dop_amb_flag", e_tid_uchar, "flag", 1, "1", "Doppler ambiguity estimate uncertain flag. 0 = confidence measure &gt;= specified value. 1 = confidence measure &lt; specified value"},
    {"output_mean_flag", e_tid_uchar, "flag", 1, "1", "Output data mean outside nominal range flag. 0 = mean of I and Q output values for SLC image or mean of detected pixels for a detected product, are both within specified range from expected mean. For expected mean of x, the measured mean must fall between x-threshold to x+threshold. 1 = otherwise."},
    {"output_std_dev_flag", e_tid_uchar, "flag", 1, "1", "Output data standard deviation outside nominal range flag. 0 = std. dev. of I and Q output values for SLC image or std. dev. of detected pixels for a detected product, are both within specified range from expected std. dev. For expected std. dev. of x, the measured std. dev must fall between x-threshold and x+threshold. 1 = otherwise."},
    {"chirp_flag", e_tid_uchar, "flag", 1, "1", "Chirp extraction failed or is of low quality flag. 0 = able to extract all chirps or chirp extraction not requested (nominal chirp used) AND all quality measures were acceptable. 1 = unable to extract a chirp during processing and chirp extraction was requequested or the quality is below the acceptable levels."},
    {"missing_data_sets_flag", e_tid_uchar, "flag", 1, "1", "Data sets missing flag. 0 = all data sets which are supposed to be in the product are present. 1 = any data sets (including ADSs) are missing from the product which are supposed to be included under normal circumstances. Which data sets are missing can be determined by an examination of the DSDs in the SPH."},
    {"invalid_downlink_flag", e_tid_uchar, "flag", 1, "1", "Invalid downlink parameters flag. 0 = all parameters read from the downlinked data were valid. 1 = displayed if any downlink parameter is out of range and therefore a default value has been used during processing."},
    {"spare_1", e_tid_spare, NULL, 7, "1", "Spare"},
    {"thresh_chirp_broadening", e_tid_float, "%", 4, "1", "Threshold for setting the chirp quality flag - Maximum percentage broadening permitted in cross-correlation pulse width compared to theoretical width."},
    {"thresh_chirp_sidelobe", e_tid_float, "dB", 4, "1", "Threshold for setting the chirp quality flag - First sidelobe of the chirp cross correlation function"},
    {"thresh_chirp_islr", e_tid_float, "dB", 4, "1", "Threshold for setting the chirp quality flag - ISLR of the chirp cross correlation function"},
    {"thresh_input_mean", e_tid_float, NULL, 4, "1", "Threshold for setting the mean of input data quality flag - For an expected mean value of x, this is the value T, such that the measured mean must fall between the x-T and x+T."},
    {"exp_input_mean", e_tid_float, NULL, 4, "1", "Expected mean input value for this product for both I and Q."},
    {"thresh_input_std_dev", e_tid_float, NULL, 4, "1", "Threshold for setting the standard deviation of input data quality flag - For an expected std. dev. value of y, this is the value D, such that the measured std. dev. must fall between the y-D and y+D."},
    {"exp_input_std_dev", e_tid_float, NULL, 4, "1", "Expected input std. dev. for this product for both I and Q."},
    {"thresh_dop_cen", e_tid_float, NULL, 4, "1", "Threshold for setting the Doppler Centroid quality flag - Threshold for Doppler Centroid confidence"},
    {"thresh_dop_amb", e_tid_float, NULL, 4, "1", "Threshold for setting the Doppler Centroid ambiguity quality flag - Threshold for setting the Doppler Centroid ambiguity confidence flag"},
    {"thresh_output_mean", e_tid_float, NULL, 4, "1", "Threshold for setting the mean of output data quality flag - For an expected mean value of x, this is the value T, such that the measured mean must fall between the x-T and x+T."},
    {"exp_output_mean", e_tid_float, NULL, 4, "1", "Expected mean output value for this product. For an SLC product this is the expected mean of both the I and Q values."},
    {"thresh_output_std_dev", e_tid_float, NULL, 4, "1", "Threshold for setting the standard deviation of output data quality flag - For an expected std. dev. value of y, this is the value D, such that the measured std. dev. must fall between the y-D and y+D."},
    {"exp_output_std_dev", e_tid_float, NULL, 4, "1", "Expected output std. dev. for this product. For an SLC product this is the expected output std. dev. for both I and Q values."},
    {"thresh_input_missing_lines", e_tid_float, "%", 4, "1", "Threshold for setting the missing lines quality flag - maximum percentage of missing lines to total lines."},
    {"thresh_input_gaps", e_tid_float, NULL, 4, "1", "Threshold for setting the missing gaps quality flag - maximum number of missing gaps allowed."},
    {"lines_per_gaps", e_tid_uint, "lines", 4, "1", "Number of missing lines which constitute a gap"},
    {"spare_2", e_tid_spare, NULL, 15, "1", "Spare"},
    {"input_mean", e_tid_float, NULL, 4, "2", "Input data mean (i channel, q channel)"},
    {"input_std_dev", e_tid_float, NULL, 4, "2", "Input data standard deviation (i channel, q channel)"},
    {"num_gaps", e_tid_float, NULL, 4, "1", "Number of gaps (composed of a predetermined number of consecutive missing lines)"},
    {"num_missing_lines", e_tid_float, NULL, 4, "1", "Number of missing lines (excluding gaps)"},
    {"output_mean", e_tid_float, NULL, 4, "2", "Output data mean (detected samples, followed by zero, or i channel followed by q channel for SLC)"},
    {"output_std_dev", e_tid_float, NULL, 4, "2", "Output data standard deviation (detected samples followed by zero,  or i channel followed by q channel for SLC)"},
    {"tot_errors", e_tid_uint, NULL, 4, "1", "Total number of errors detected in ISP headers"},
    {"Spare_3", e_tid_spare, NULL, 16, "1", "Spare"}
};

static const struct RecordDescriptor ASAR_SRGR_ADSR_asar_rec_data[] = {
    {"zero_doppler_time", e_tid_time, "MJD", 12, "1", "Zero Doppler Time in azimuth from which parameters apply"},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment Flag (always set to zero for this ADSR)"},
    {"slant_range_time", e_tid_float, "ns", 4, "1", "2 way slant range time to first range sample"},
    {"ground_range_origin", e_tid_float, "m", 4, "1", "Ground range origin of the polynomial (GR0) measured for the first pixel of the line."},
    {"srgr_coeff", e_tid_float, "m, m-1, m-2, m-3, m-4", 4, "5", "The coefficients S0, S1, S2, S3, and S4 of the ground range to slant range conversion polynomial. Slant range = S0 + S1(GR-GR0) + S2 (GR-GR0)2 + S3(GR-GR0)3 + S4(GR-GR0)4"},
    {"spare_1", e_tid_spare, NULL, 14, "1", "Spare"}
};

static const struct RecordDescriptor ASAR_Wave_Geolocation_ADSR_asar_rec_data[] = {
    {"zero_doppler_time", e_tid_time, "MJD", 12, "1", "Zero Doppler Time of first line of the first line of the imagette"},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment Flag (set to 1 if unable to compute the cross spectra for a given SLC imagette (i.e. no Cross Spectra MDSR corresponding to this ADSR), set to 0 otherwise)"},
    {"center_lat", e_tid_int, "(1e-6) degrees", 4, "1", "Geodetic latitude of center point (positive north) This is the center point of the wave cell. It is calculated after the cross spectra processing, and thus may differ from the center sample latitude of the SLC imagette if slant range to ground range conve"},
    {"center_long", e_tid_int, "(1e-6) degrees", 4, "1", "Geodetic longitude of center point (positive east)This is the center point of the wave cell. It is calculated after the cross spectra processing, and thus may differ from the center sample latitude of the SLC imagette if slant range to ground range conver"},
    {"spare_1", e_tid_spare, NULL, 4, "1", "Spare"}
};

static const struct RecordDescriptor ASAR_Wave_Param_ADSR_asar_rec_data[] = {
    {"first_zero_doppler_time", e_tid_time, "MJD", 12, "1", "First Zero Doppler Azimuth time of MDS which this data set describesTime of first range line in the MDS described by this data set"},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment Flag (always set to zero for this ADSR)"},
    {"last_zero_doppler_time", e_tid_time, "MJD", 12, "1", "Last Zero Doppler Azimuth time of MDS which this data set describesTime of last range line in the MDS described by this data set"},
    {"work_order_id", e_tid_string, "ascii", 12, "1", "Work Order ID (left-justified)"},
    {"time_diff", e_tid_float, "s", 4, "1", "Time difference between sensing time of first input line and zero Doppler time of first output image line (tdelta). (TBC)May be used during child product extraction from a stripline product (TBC). Left blank (set to zero) for non-stripline products"},
    {"swath_id", e_tid_string, "ascii", 3, "1", "Swath number IS1, IS2, IS3, IS4, IS5, IS6, or IS7 for IM, WV and AP modes.Set to WS&Oslash; for WS and GM modes"},
    {"range_spacing", e_tid_float, "m", 4, "1", "Range sample spacing"},
    {"azimuth_spacing", e_tid_float, "m", 4, "1", "Azimuth sample spacing at image center"},
    {"line_time_interval", e_tid_float, "s", 4, "1", "Azimuth sample spacing in time (Line Time Interval)"},
    {"num_output_lines", e_tid_uint, "lines", 4, "1", "Number of output range lines in the image described by this ADS"},
    {"num_samples_per_line", e_tid_uint, "samples", 4, "1", "Number of samples per output range line (includes zero filled samples)"},
    {"data_type", e_tid_string, "ascii", 5, "1", "Output data typeSWORD, UWORD, or UBYTE"},
    {"spare_1", e_tid_spare, NULL, 51, "1", "Spare"},
    {"data_analysis_flag", e_tid_uchar, "flag", 1, "1", "Raw Data Analysis used for Raw Data Correction 0 = correction done using default parameters1 = correction done using raw data analysis results"},
    {"ant_elev_corr_flag", e_tid_uchar, "flag", 1, "1", "Antenna Elevation Pattern Correction Applied 0 = no correction applied1 = correction applied"},
    {"chirp_extract_flag", e_tid_uchar, "flag", 1, "1", "reconstructed Chirp used 0 = nominal chirp replica used1 = reconstructed chirp used"},
    {"srgr_flag", e_tid_uchar, "flag", 1, "1", "Slant Range to Ground Range Conversion Applied0 = no conversion applied1 = conversion applied"},
    {"dop_cen_flag", e_tid_uchar, "flag", 1, "1", "Doppler Centroid Estimation Performed0 = no estimation done1 = estimation done"},
    {"dop_amb_flag", e_tid_uchar, "flag", 1, "1", "Doppler Ambiguity Estimation Performed0 = no estimate done1 = estimate done"},
    {"range_spread_comp_flag", e_tid_uchar, "flag", 1, "1", "Range-spreading loss compensation Applied0 = no compensation applied1 = compensation applied"},
    {"detected_flag", e_tid_uchar, "flag", 1, "1", "Detection Applied0 = output product is complex1 = output product was detected"},
    {"look_sum_flag", e_tid_uchar, "flag", 1, "1", "Look Summation Performed0 = product is single look1 = product is multi-looked"},
    {"rms_equal_flag", e_tid_uchar, "flag", 1, "1", "RMS Equalization performed 0= rms equalization not performed during FBAQ decoding, 1 = rms equalization performed during FBAQ decoding"},
    {"ant_scal_flag", e_tid_uchar, "flag", 1, "1", "Antenna Elevationscaling Factor applied 0= no scaling factor applied, 1 =  scaling factor applied"},
    {"spare_2", e_tid_spare, NULL, 10, "1", "Spare"},
    {"raw_data_analysis.1.num_gaps", e_tid_uint, "gaps", 4, "1", "Number of input data gaps (a gap is defined as a predetermined number of range lines) (record 1)"},
    {"raw_data_analysis.1.num_missing_lines", e_tid_uint, "lines", 4, "1", "Number of missing lines, excluding data gaps (record 1)"},
    {"raw_data_analysis.1.range_samp_skip", e_tid_uint, "samples", 4, "1", "Range sample skipping factor for raw data analysis (record 1)"},
    {"raw_data_analysis.1.range_lines_skip", e_tid_uint, "lines", 4, "1", "Range lines skipping factor for raw data analysis (record 1)"},
    {"raw_data_analysis.1.calc_i_bias", e_tid_float, NULL, 4, "1", "Calculated I channel bias (record 1)"},
    {"raw_data_analysis.1.calc_q_bias", e_tid_float, NULL, 4, "1", "Calculated Q channel bias (record 1)"},
    {"raw_data_analysis.1.calc_i_std_dev", e_tid_float, NULL, 4, "1", "Calculated I channel standard deviation (record 1)"},
    {"raw_data_analysis.1.calc_q_std_dev", e_tid_float, NULL, 4, "1", "Calculated Q channel standard deviation (record 1)"},
    {"raw_data_analysis.1.calc_gain", e_tid_float, NULL, 4, "1", "Calculated I/Q gain imbalance (record 1)"},
    {"raw_data_analysis.1.calc_quad", e_tid_float, NULL, 4, "1", "Calculated I/Q quadrature departure (record 1)"},
    {"raw_data_analysis.1.i_bias_max", e_tid_float, NULL, 4, "1", "I bias upper bound (record 1)"},
    {"raw_data_analysis.1.i_bias_min", e_tid_float, NULL, 4, "1", "I bias lower bound (record 1)"},
    {"raw_data_analysis.1.q_bias_max", e_tid_float, NULL, 4, "1", "Q bias upper bound (record 1)"},
    {"raw_data_analysis.1.q_bias_min", e_tid_float, NULL, 4, "1", "Q bias lower bound (record 1)"},
    {"raw_data_analysis.1.gain_min", e_tid_float, NULL, 4, "1", "I/Q gain lower bound (record 1)"},
    {"raw_data_analysis.1.gain_max", e_tid_float, NULL, 4, "1", "I/Q gain upper bound (record 1)"},
    {"raw_data_analysis.1.quad_min", e_tid_float, NULL, 4, "1", "I/Q quadrature departure lower bound (record 1)"},
    {"raw_data_analysis.1.quad_max", e_tid_float, NULL, 4, "1", "I/Q quadrature departure upper bound (record 1)"},
    {"raw_data_analysis.1.i_bias_flag", e_tid_uchar, "flag", 1, "1", "I bias significance0 = I bias falls within acceptable range1 = I bias falls outside acceptable range (record 1)"},
    {"raw_data_analysis.1.q_bias_flag", e_tid_uchar, "flag", 1, "1", "Q bias Significance0 = Q bias falls within acceptable range1 = Q bias falls outside acceptable range (record 1)"},
    {"raw_data_analysis.1.gain_flag", e_tid_uchar, "flag", 1, "1", "I/Q Gain Significance0 = Gain falls within acceptable range1 = Gain falls outside acceptable range (record 1)"},
    {"raw_data_analysis.1.quad_flag", e_tid_uchar, "flag", 1, "1", "I/Q Quadrature Departure Significance0 = Quadrature departure falls within acceptable range1 =Quadrature departure falls outside acceptable range (record 1)"},
    {"raw_data_analysis.1.used_i_bias", e_tid_float, NULL, 4, "1", "I channel bias used for correction (may be different from measured value) (record 1)"},
    {"raw_data_analysis.1.used_q_bias", e_tid_float, NULL, 4, "1", "Q channel bias used for correction(may be different from measured value) (record 1)"},
    {"raw_data_analysis.1.used_gain", e_tid_float, NULL, 4, "1", "I/Q gain imbalance used for correction(may be different from measured value) (record 1)"},
    {"raw_data_analysis.1.used_quad", e_tid_float, NULL, 4, "1", "I/Q quadrature departure used for correction(may be different from measured value) (record 1)"},
    {"raw_data_analysis.2.num_gaps", e_tid_uint, "gaps", 4, "1", "Number of input data gaps (a gap is defined as a predetermined number of range lines) (record 2)"},
    {"raw_data_analysis.2.num_missing_lines", e_tid_uint, "lines", 4, "1", "Number of missing lines, excluding data gaps (record 2)"},
    {"raw_data_analysis.2.range_samp_skip", e_tid_uint, "samples", 4, "1", "Range sample skipping factor for raw data analysis (record 2)"},
    {"raw_data_analysis.2.range_lines_skip", e_tid_uint, "lines", 4, "1", "Range lines skipping factor for raw data analysis (record 2)"},
    {"raw_data_analysis.2.calc_i_bias", e_tid_float, NULL, 4, "1", "Calculated I channel bias (record 2)"},
    {"raw_data_analysis.2.calc_q_bias", e_tid_float, NULL, 4, "1", "Calculated Q channel bias (record 2)"},
    {"raw_data_analysis.2.calc_i_std_dev", e_tid_float, NULL, 4, "1", "Calculated I channel standard deviation (record 2)"},
    {"raw_data_analysis.2.calc_q_std_dev", e_tid_float, NULL, 4, "1", "Calculated Q channel standard deviation (record 2)"},
    {"raw_data_analysis.2.calc_gain", e_tid_float, NULL, 4, "1", "Calculated I/Q gain imbalance (record 2)"},
    {"raw_data_analysis.2.calc_quad", e_tid_float, NULL, 4, "1", "Calculated I/Q quadrature departure (record 2)"},
    {"raw_data_analysis.2.i_bias_max", e_tid_float, NULL, 4, "1", "I bias upper bound (record 2)"},
    {"raw_data_analysis.2.i_bias_min", e_tid_float, NULL, 4, "1", "I bias lower bound (record 2)"},
    {"raw_data_analysis.2.q_bias_max", e_tid_float, NULL, 4, "1", "Q bias upper bound (record 2)"},
    {"raw_data_analysis.2.q_bias_min", e_tid_float, NULL, 4, "1", "Q bias lower bound (record 2)"},
    {"raw_data_analysis.2.gain_min", e_tid_float, NULL, 4, "1", "I/Q gain lower bound (record 2)"},
    {"raw_data_analysis.2.gain_max", e_tid_float, NULL, 4, "1", "I/Q gain upper bound (record 2)"},
    {"raw_data_analysis.2.quad_min", e_tid_float, NULL, 4, "1", "I/Q quadrature departure lower bound (record 2)"},
    {"raw_data_analysis.2.quad_max", e_tid_float, NULL, 4, "1", "I/Q quadrature departure upper bound (record 2)"},
    {"raw_data_analysis.2.i_bias_flag", e_tid_uchar, "flag", 1, "1", "I bias significance0 = I bias falls within acceptable range1 = I bias falls outside acceptable range (record 2)"},
    {"raw_data_analysis.2.q_bias_flag", e_tid_uchar, "flag", 1, "1", "Q bias Significance0 = Q bias falls within acceptable range1 = Q bias falls outside acceptable range (record 2)"},
    {"raw_data_analysis.2.gain_flag", e_tid_uchar, "flag", 1, "1", "I/Q Gain Significance0 = Gain falls within acceptable range1 = Gain falls outside acceptable range (record 2)"},
    {"raw_data_analysis.2.quad_flag", e_tid_uchar, "flag", 1, "1", "I/Q Quadrature Departure Significance0 = Quadrature departure falls within acceptable range1 =Quadrature departure falls outside acceptable range (record 2)"},
    {"raw_data_analysis.2.used_i_bias", e_tid_float, NULL, 4, "1", "I channel bias used for correction (may be different from measured value) (record 2)"},
    {"raw_data_analysis.2.used_q_bias", e_tid_float, NULL, 4, "1", "Q channel bias used for correction(may be different from measured value) (record 2)"},
    {"raw_data_analysis.2.used_gain", e_tid_float, NULL, 4, "1", "I/Q gain imbalance used for correction(may be different from measured value) (record 2)"},
    {"raw_data_analysis.2.used_quad", e_tid_float, NULL, 4, "1", "I/Q quadrature departure used for correction(may be different from measured value) (record 2)"},
    {"spare_3", e_tid_spare, NULL, 32, "1", "Spare"},
    {"start_time.1.first_obt", e_tid_uint, NULL, 4, "2", "On-board binary time of first input line processedLSB accurate to 15.26 ms. (Contained in two long integers) (record 1)"},
    {"start_time.1.first_mjd", e_tid_time, "MJD", 12, "1", "Sensing time (MJD format) of first input line processedconverted from satellite binary time (record 1)"},
    {"start_time.2.first_obt", e_tid_uint, NULL, 4, "2", "On-board binary time of first input line processedLSB accurate to 15.26 ms. (Contained in two long integers) (record 2)"},
    {"start_time.2.first_mjd", e_tid_time, "MJD", 12, "1", "Sensing time (MJD format) of first input line processedconverted from satellite binary time (record 2)"},
    {"parameter_codes.swst_code", e_tid_ushort, "code", 2, "5", "Sampling Window Start time code of first processed line"},
    {"parameter_codes.last_swst_code", e_tid_ushort, "code", 2, "5", "Sampling Window Start time code of last processed line"},
    {"parameter_codes.pri_code", e_tid_ushort, "code", 2, "5", "Pulse Repetition Interval code"},
    {"parameter_codes.tx_pulse_len_code", e_tid_ushort, "code", 2, "5", "Tx pulse length"},
    {"parameter_codes.tx_bw_code", e_tid_ushort, "code", 2, "5", "Tx pulse bandwidth"},
    {"parameter_codes.echo_win_len_code", e_tid_ushort, "code", 2, "5", "Echo Window Length"},
    {"parameter_codes.up_code", e_tid_ushort, "code", 2, "5", "Upconverter Level - Upconverter gain set on the instrument"},
    {"parameter_codes.down_code", e_tid_ushort, "code", 2, "5", "Downconverter Level - Downconverter gain set on the instrument"},
    {"parameter_codes.resamp_code", e_tid_ushort, "code", 2, "5", "Resampling factor for echo data"},
    {"parameter_codes.beam_adj_code", e_tid_ushort, "code", 2, "5", "Beam adjustment delta"},
    {"parameter_codes.beam_set_num_code", e_tid_ushort, "code", 2, "5", "Antenna Beam Set Number"},
    {"parameter_codes.tx_monitor_code", e_tid_ushort, "code", 2, "5", "Auxiliary Tx Monitor Level"},
    {"spare_4", e_tid_spare, NULL, 60, "1", "Spare"},
    {"error_counters.num_err_swst", e_tid_uint, NULL, 4, "1", "Number of errors detected in Sampling Window start time field."},
    {"error_counters.num_err_pri", e_tid_uint, NULL, 4, "1", "Number of errors detected in PRI code field"},
    {"error_counters.num_err_tx_pulse_len", e_tid_uint, NULL, 4, "1", "Number of errors detected in Tx pulse length field"},
    {"error_counters.num_err_tx_pulse_bw", e_tid_uint, NULL, 4, "1", "Number of errors detected in Tx pulse bandwidth field."},
    {"error_counters.num_err_echo_win_len", e_tid_uint, NULL, 4, "1", "Number of errors detected in Echo Window Length field."},
    {"error_counters.num_err_up", e_tid_uint, NULL, 4, "1", "Number of errors detected in Upconverter Level field."},
    {"error_counters.num_err_down", e_tid_uint, NULL, 4, "1", "Number of errors detected in Downconverter Level field."},
    {"error_counters.num_err_resamp", e_tid_uint, NULL, 4, "1", "Number of errors detected in Resampling factor for echo data field."},
    {"error_counters.num_err_beam_adj", e_tid_uint, NULL, 4, "1", "Number of errors detected in Beam adjustment delta field."},
    {"error_counters.num_err_beam_set_num", e_tid_uint, NULL, 4, "1", "Number of errors detected in Antenna Beam Set Number field."},
    {"spare_5", e_tid_spare, NULL, 26, "1", "Spare"},
    {"image_parameters.swst_value", e_tid_float, "s", 4, "5", "Sampling Window Start time of first processed line"},
    {"image_parameters.last_swst_value", e_tid_float, "s", 4, "5", "Sampling Window Start time of last processed line"},
    {"image_parameters.swst_changes", e_tid_uint, NULL, 4, "5", "Number of Sample Window Start Time changes within a beam"},
    {"image_parameters.prf_value", e_tid_float, "Hz", 4, "5", "Pulse Repetition Frequency"},
    {"image_parameters.tx_pulse_len_value", e_tid_float, "s", 4, "5", "Tx pulse length"},
    {"image_parameters.tx_pulse_bw_value", e_tid_float, "Hz", 4, "5", "Tx pulse bandwidth"},
    {"image_parameters.echo_win_len_value", e_tid_float, "s", 4, "5", "Echo Window Length"},
    {"image_parameters.up_value", e_tid_float, "dB", 4, "5", "Upconverter Level - Upconverter gain set on the instrument"},
    {"image_parameters.down_value", e_tid_float, "dB", 4, "5", "Downconverter Level - Downconverter gain set on the instrument"},
    {"image_parameters.resamp_value", e_tid_float, NULL, 4, "5", "Resampling factor"},
    {"image_parameters.beam_adj_value", e_tid_float, "deg.", 4, "5", "Beam adjustment delta"},
    {"image_parameters.beam_set_value", e_tid_ushort, NULL, 2, "5", "Antenna Beam Set Number"},
    {"image_parameters.tx_monitor_value", e_tid_float, NULL, 4, "5", "Auxiliary Tx Monitor Level"},
    {"spare_6", e_tid_spare, NULL, 82, "1", "Spare"},
    {"first_proc_range_samp", e_tid_uint, "samples", 4, "1", "First processed input range sample, first sample is 1"},
    {"range_ref", e_tid_float, "m", 4, "1", "Range spreading loss reference range"},
    {"range_samp_rate", e_tid_float, "Hz", 4, "1", "Range sampling rate"},
    {"radar_freq", e_tid_float, "Hz", 4, "1", "Radar Frequency"},
    {"num_looks_range", e_tid_ushort, "looks", 2, "1", "Number of range looks"},
    {"filter_range", e_tid_string, "ascii", 7, "1", "Matched filter window type:HAMMING or KAISER&Oslash; or NONE&Oslash;&Oslash;&Oslash;"},
    {"filter_coef_range", e_tid_float, NULL, 4, "1", "Window coefficient for range-matched filter"},
    {"bandwidth.look_bw_range", e_tid_float, "Hz", 4, "5", "Range Look Bandwidth (null to null)"},
    {"bandwidth.tot_bw_range", e_tid_float, "Hz", 4, "5", "Total processed range bandwidth (null to null)"},
    {"nominal_chirp.1.nom_chirp_amp", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 nominal chirp amplitude coefficients (record 1)"},
    {"nominal_chirp.1.nom_chirp_phs", e_tid_float, "cycles,Hz,Hz/s,Hz/s2", 4, "4", "4 nominal chirp phase coefficients (record 1)"},
    {"nominal_chirp.2.nom_chirp_amp", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 nominal chirp amplitude coefficients (record 2)"},
    {"nominal_chirp.2.nom_chirp_phs", e_tid_float, "cycles,Hz,Hz/s,Hz/s2", 4, "4", "4 nominal chirp phase coefficients (record 2)"},
    {"nominal_chirp.3.nom_chirp_amp", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 nominal chirp amplitude coefficients (record 3)"},
    {"nominal_chirp.3.nom_chirp_phs", e_tid_float, "cycles,Hz,Hz/s,Hz/s2", 4, "4", "4 nominal chirp phase coefficients (record 3)"},
    {"nominal_chirp.4.nom_chirp_amp", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 nominal chirp amplitude coefficients (record 4)"},
    {"nominal_chirp.4.nom_chirp_phs", e_tid_float, "cycles,Hz,Hz/s,Hz/s2", 4, "4", "4 nominal chirp phase coefficients (record 4)"},
    {"nominal_chirp.5.nom_chirp_amp", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 nominal chirp amplitude coefficients (record 5)"},
    {"nominal_chirp.5.nom_chirp_phs", e_tid_float, "cycles,Hz,Hz/s,Hz/s2", 4, "4", "4 nominal chirp phase coefficients (record 5)"},
    {"spare_7", e_tid_spare, NULL, 60, "1", "Spare"},
    {"num_lines_proc", e_tid_uint, "lines", 4, "1", "Number of input lines processed"},
    {"num_look_az", e_tid_ushort, "looks", 2, "1", "Number of Azimuth Looks"},
    {"look_bw_az", e_tid_float, "Hz", 4, "1", "Azimuth Look Bandwidth (null to null) -- this is the nominal value only for GM, WS, and AP."},
    {"to_bw_az", e_tid_float, "Hz", 4, "1", "Processed Azimuth bandwidth (null to null) -- this field is used only for IM products and WV imagettes. Filled with zeros otherwise."},
    {"filter_az", e_tid_string, "ascii", 7, "1", "Matched filter window type:HAMMING or KAISER&Oslash; or NONE&Oslash;&Oslash;&Oslash;"},
    {"filter_coef_az", e_tid_float, NULL, 4, "1", "Window coefficient for azimuth-matched filter"},
    {"az_fm_rate", e_tid_float, "Hz/sHz/s2Hz/s3", 4, "3", "3 co-efficients for Azimuth FM rate:Azimuth FM rate = C0 + C1(tSR-t0) + C2(tSR - t0)2tSR = 2 way slant range time"},
    {"ax_fm_origin", e_tid_float, "ns", 4, "1", "2 way slant range time origin (t0) for Azimuth FM rate calculation"},
    {"dop_amb_conf", e_tid_float, NULL, 4, "1", "Doppler Centroid Ambiguity Confidence MeasureValue between 0 and 1, 0 = poorest confidence, 1= highest confidence"},
    {"spare_8", e_tid_spare, NULL, 68, "1", "Spare"},
    {"calibration_factors.1.proc_scaling_fact", e_tid_float, NULL, 4, "1", "Processor scaling factor (record 1)"},
    {"calibration_factors.1.ext_cal_fact", e_tid_float, NULL, 4, "1", "External Calibration Scaling Factor (mode/swath/polarization dependent) (record 1)"},
    {"calibration_factors.2.proc_scaling_fact", e_tid_float, NULL, 4, "1", "Processor scaling factor (record 2)"},
    {"calibration_factors.2.ext_cal_fact", e_tid_float, NULL, 4, "1", "External Calibration Scaling Factor (mode/swath/polarization dependent) (record 2)"},
    {"noise_estimation.noise_power_corr", e_tid_float, NULL, 4, "5", "Noise power correction factors"},
    {"noise_estimation.num_noise_lines", e_tid_uint, NULL, 4, "5", "Number of noise lines used to calculate factors"},
    {"spare_9", e_tid_spare, NULL, 64, "1", "Spare"},
    {"spare_10", e_tid_spare, NULL, 12, "1", "Spare"},
    {"output_statistics.1.out_mean", e_tid_float, NULL, 4, "1", "Output data mean Magnitude for detected products, real sample mean for SLC products (record 1)"},
    {"output_statistics.1.out_imag_mean", e_tid_float, NULL, 4, "1", "Output imaginary data mean Used for SLC products only (set to zero otherwise) (record 1)"},
    {"output_statistics.1.out_std_dev", e_tid_float, NULL, 4, "1", "Output data standard deviation Magnitude std. dev. for detected products, real sample std. dev. for SLC products (record 1)"},
    {"output_statistics.1.out_imag_std_dev", e_tid_float, NULL, 4, "1", "Output imaginary data standard deviation Used for SLC products only (set to zero otherwise) (record 1)"},
    {"output_statistics.2.out_mean", e_tid_float, NULL, 4, "1", "Output data mean Magnitude for detected products, real sample mean for SLC products (record 2)"},
    {"output_statistics.2.out_imag_mean", e_tid_float, NULL, 4, "1", "Output imaginary data mean Used for SLC products only (set to zero otherwise) (record 2)"},
    {"output_statistics.2.out_std_dev", e_tid_float, NULL, 4, "1", "Output data standard deviation Magnitude std. dev. for detected products, real sample std. dev. for SLC products (record 2)"},
    {"output_statistics.2.out_imag_std_dev", e_tid_float, NULL, 4, "1", "Output imaginary data standard deviation Used for SLC products only (set to zero otherwise) (record 2)"},
    {"spare_11", e_tid_spare, NULL, 52, "1", "Spare"},
    {"echo_comp", e_tid_string, "ascii", 4, "1", "Compression Method used for echo samples FBAQ, S&amp;M&Oslash;, NONE"},
    {"echo_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for echo samples8/4, 8/3, 8/2, or 8/8"},
    {"init_cal_comp", e_tid_string, "ascii", 4, "1", "Compression Method used for initial calibration samples FBAQ, S&amp;M&Oslash;, NONE"},
    {"init_cal_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for initial calibration samples8/4, 8/3, 8/2, or 8/8"},
    {"per_cal_comp", e_tid_string, "ascii", 4, "1", "Compression Method used for periodic calibration samples FBAQ, S&amp;M&Oslash;, NONE"},
    {"per_cal_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for periodic calibration samples8/4, 8/3, 8/2, or 8/8"},
    {"noise_comp", e_tid_string, "ascii", 4, "1", "Compression Method used for noise samples FBAQ, S&amp;M&Oslash;, NONE"},
    {"noise_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for noise samples8/4, 8/3, 8/2, or 8/8"},
    {"spare_12", e_tid_spare, NULL, 64, "1", "Spare"},
    {"beam_overlap", e_tid_uint, NULL, 4, "4", "Number of slant range samples in beam overlap(1-2, 2-3, 3-4, 4-5)"},
    {"lines_per_burst", e_tid_uint, "lines", 4, "5", "Number of lines per burst for this image 5 values for beams SS1 to SS5 in WS and GM modes.One value for AP mode, all others set to zero."},
    {"spare_13", e_tid_spare, NULL, 44, "1", "Spare"},
    {"orbit_state_vectors.1.state_vect_time_1", e_tid_time, "MJD", 12, "1", "Time of state vector (record 1)"},
    {"orbit_state_vectors.1.x_pos_1", e_tid_int, "10 -2m", 4, "1", "X position in Earth fixed reference frame (record 1)"},
    {"orbit_state_vectors.1.y_pos_1", e_tid_int, "10 -2m", 4, "1", "Y position in Earth fixed reference frame (record 1)"},
    {"orbit_state_vectors.1.z_pos_1", e_tid_int, "10 -2m", 4, "1", "Z position in Earth fixed reference frame (record 1)"},
    {"orbit_state_vectors.1.x_vel_1", e_tid_int, "10 -5m/s", 4, "1", "X velocity relative to Earth fixed reference frame (record 1)"},
    {"orbit_state_vectors.1.y_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Y velocity relative to Earth fixed reference frame (record 1)"},
    {"orbit_state_vectors.1.z_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Z velocity relative to Earth fixed reference frame (record 1)"},
    {"orbit_state_vectors.2.state_vect_time_1", e_tid_time, "MJD", 12, "1", "Time of state vector (record 2)"},
    {"orbit_state_vectors.2.x_pos_1", e_tid_int, "10 -2m", 4, "1", "X position in Earth fixed reference frame (record 2)"},
    {"orbit_state_vectors.2.y_pos_1", e_tid_int, "10 -2m", 4, "1", "Y position in Earth fixed reference frame (record 2)"},
    {"orbit_state_vectors.2.z_pos_1", e_tid_int, "10 -2m", 4, "1", "Z position in Earth fixed reference frame (record 2)"},
    {"orbit_state_vectors.2.x_vel_1", e_tid_int, "10 -5m/s", 4, "1", "X velocity relative to Earth fixed reference frame (record 2)"},
    {"orbit_state_vectors.2.y_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Y velocity relative to Earth fixed reference frame (record 2)"},
    {"orbit_state_vectors.2.z_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Z velocity relative to Earth fixed reference frame (record 2)"},
    {"orbit_state_vectors.3.state_vect_time_1", e_tid_time, "MJD", 12, "1", "Time of state vector (record 3)"},
    {"orbit_state_vectors.3.x_pos_1", e_tid_int, "10 -2m", 4, "1", "X position in Earth fixed reference frame (record 3)"},
    {"orbit_state_vectors.3.y_pos_1", e_tid_int, "10 -2m", 4, "1", "Y position in Earth fixed reference frame (record 3)"},
    {"orbit_state_vectors.3.z_pos_1", e_tid_int, "10 -2m", 4, "1", "Z position in Earth fixed reference frame (record 3)"},
    {"orbit_state_vectors.3.x_vel_1", e_tid_int, "10 -5m/s", 4, "1", "X velocity relative to Earth fixed reference frame (record 3)"},
    {"orbit_state_vectors.3.y_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Y velocity relative to Earth fixed reference frame (record 3)"},
    {"orbit_state_vectors.3.z_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Z velocity relative to Earth fixed reference frame (record 3)"},
    {"orbit_state_vectors.4.state_vect_time_1", e_tid_time, "MJD", 12, "1", "Time of state vector (record 4)"},
    {"orbit_state_vectors.4.x_pos_1", e_tid_int, "10 -2m", 4, "1", "X position in Earth fixed reference frame (record 4)"},
    {"orbit_state_vectors.4.y_pos_1", e_tid_int, "10 -2m", 4, "1", "Y position in Earth fixed reference frame (record 4)"},
    {"orbit_state_vectors.4.z_pos_1", e_tid_int, "10 -2m", 4, "1", "Z position in Earth fixed reference frame (record 4)"},
    {"orbit_state_vectors.4.x_vel_1", e_tid_int, "10 -5m/s", 4, "1", "X velocity relative to Earth fixed reference frame (record 4)"},
    {"orbit_state_vectors.4.y_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Y velocity relative to Earth fixed reference frame (record 4)"},
    {"orbit_state_vectors.4.z_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Z velocity relative to Earth fixed reference frame (record 4)"},
    {"orbit_state_vectors.5.state_vect_time_1", e_tid_time, "MJD", 12, "1", "Time of state vector (record 5)"},
    {"orbit_state_vectors.5.x_pos_1", e_tid_int, "10 -2m", 4, "1", "X position in Earth fixed reference frame (record 5)"},
    {"orbit_state_vectors.5.y_pos_1", e_tid_int, "10 -2m", 4, "1", "Y position in Earth fixed reference frame (record 5)"},
    {"orbit_state_vectors.5.z_pos_1", e_tid_int, "10 -2m", 4, "1", "Z position in Earth fixed reference frame (record 5)"},
    {"orbit_state_vectors.5.x_vel_1", e_tid_int, "10 -5m/s", 4, "1", "X velocity relative to Earth fixed reference frame (record 5)"},
    {"orbit_state_vectors.5.y_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Y velocity relative to Earth fixed reference frame (record 5)"},
    {"orbit_state_vectors.5.z_vel_1", e_tid_int, "10 -5m/s", 4, "1", "Z velocity relative to Earth fixed reference frame (record 5)"},
    {"spare_14", e_tid_spare, NULL, 64, "1", "Spare"},
    {"slant_range_time", e_tid_float, "ns", 4, "1", "2-way slant range time origin (t0)"},
    {"dop_coef", e_tid_float, "HzHz/sHz/s2Hz/s3Hz/s4", 4, "5", "Doppler centroid coefficients as a function of slant range time: D0, D1, D2, D3, and D4.where Doppler Centroid = D0 + D1(tSR-t0) + D2(tSR-t0)2 + D3(tSR-t0)3 + D4(tSR-t0)4"},
    {"dop_conf", e_tid_float, NULL, 4, "1", "Doppler Centroid Confidence MeasureValue between 0 and 1, 0 = poorest confidence, 1= highest confidence"},
    {"spare_15", e_tid_spare, NULL, 14, "1", "Spare"},
    {"chirp_width", e_tid_float, "samples", 4, "1", "3-dB pulse width of chirp replica cross-correlation function between  extract chirp and nominal chirp"},
    {"chirp_sidelobe", e_tid_float, "dB", 4, "1", "First side lobe level of chirp replica cross-correlation function between  reconstructed chirp and nominal chirp"},
    {"chirp_islr", e_tid_float, "dB", 4, "1", "ISLR of chirp replica cross-correlation function between  reconstructed chirp and nominal chirp"},
    {"chirp_peak_loc", e_tid_float, "samples", 4, "1", "Peak location of cross-correlation function between  reconstructed chirp and nominal chirp"},
    {"chirp_power", e_tid_float, NULL, 4, "1", "Chirp power"},
    {"elev_corr_factor", e_tid_float, NULL, 4, "1", "Elevation gain correction scaling factor applied to range compressed samples"},
    {"spare_16", e_tid_spare, NULL, 16, "1", "Spare"},
    {"cal_info.1.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 1)"},
    {"cal_info.1.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 1)"},
    {"cal_info.1.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 1)"},
    {"cal_info.1.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 1)"},
    {"cal_info.2.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 2)"},
    {"cal_info.2.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 2)"},
    {"cal_info.2.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 2)"},
    {"cal_info.2.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 2)"},
    {"cal_info.3.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 3)"},
    {"cal_info.3.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 3)"},
    {"cal_info.3.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 3)"},
    {"cal_info.3.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 3)"},
    {"cal_info.4.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 4)"},
    {"cal_info.4.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 4)"},
    {"cal_info.4.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 4)"},
    {"cal_info.4.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 4)"},
    {"cal_info.5.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 5)"},
    {"cal_info.5.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 5)"},
    {"cal_info.5.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 5)"},
    {"cal_info.5.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 5)"},
    {"cal_info.6.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 6)"},
    {"cal_info.6.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 6)"},
    {"cal_info.6.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 6)"},
    {"cal_info.6.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 6)"},
    {"cal_info.7.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 7)"},
    {"cal_info.7.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 7)"},
    {"cal_info.7.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 7)"},
    {"cal_info.7.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 7)"},
    {"cal_info.8.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 8)"},
    {"cal_info.8.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 8)"},
    {"cal_info.8.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 8)"},
    {"cal_info.8.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 8)"},
    {"cal_info.9.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 9)"},
    {"cal_info.9.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 9)"},
    {"cal_info.9.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 9)"},
    {"cal_info.9.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 9)"},
    {"cal_info.10.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 10)"},
    {"cal_info.10.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 10)"},
    {"cal_info.10.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 10)"},
    {"cal_info.10.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 10)"},
    {"cal_info.11.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 11)"},
    {"cal_info.11.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 11)"},
    {"cal_info.11.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 11)"},
    {"cal_info.11.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 11)"},
    {"cal_info.12.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 12)"},
    {"cal_info.12.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 12)"},
    {"cal_info.12.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 12)"},
    {"cal_info.12.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 12)"},
    {"cal_info.13.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 13)"},
    {"cal_info.13.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 13)"},
    {"cal_info.13.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 13)"},
    {"cal_info.13.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 13)"},
    {"cal_info.14.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 14)"},
    {"cal_info.14.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 14)"},
    {"cal_info.14.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 14)"},
    {"cal_info.14.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 14)"},
    {"cal_info.15.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 15)"},
    {"cal_info.15.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 15)"},
    {"cal_info.15.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 15)"},
    {"cal_info.15.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 15)"},
    {"cal_info.16.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 16)"},
    {"cal_info.16.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 16)"},
    {"cal_info.16.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 16)"},
    {"cal_info.16.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 16)"},
    {"cal_info.17.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 17)"},
    {"cal_info.17.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 17)"},
    {"cal_info.17.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 17)"},
    {"cal_info.17.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 17)"},
    {"cal_info.18.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 18)"},
    {"cal_info.18.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 18)"},
    {"cal_info.18.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 18)"},
    {"cal_info.18.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 18)"},
    {"cal_info.19.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 19)"},
    {"cal_info.19.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 19)"},
    {"cal_info.19.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 19)"},
    {"cal_info.19.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 19)"},
    {"cal_info.20.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 20)"},
    {"cal_info.20.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 20)"},
    {"cal_info.20.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 20)"},
    {"cal_info.20.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 20)"},
    {"cal_info.21.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 21)"},
    {"cal_info.21.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 21)"},
    {"cal_info.21.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 21)"},
    {"cal_info.21.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 21)"},
    {"cal_info.22.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 22)"},
    {"cal_info.22.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 22)"},
    {"cal_info.22.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 22)"},
    {"cal_info.22.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 22)"},
    {"cal_info.23.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 23)"},
    {"cal_info.23.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 23)"},
    {"cal_info.23.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 23)"},
    {"cal_info.23.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 23)"},
    {"cal_info.24.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 24)"},
    {"cal_info.24.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 24)"},
    {"cal_info.24.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 24)"},
    {"cal_info.24.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 24)"},
    {"cal_info.25.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 25)"},
    {"cal_info.25.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 25)"},
    {"cal_info.25.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 25)"},
    {"cal_info.25.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 25)"},
    {"cal_info.26.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 26)"},
    {"cal_info.26.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 26)"},
    {"cal_info.26.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 26)"},
    {"cal_info.26.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 26)"},
    {"cal_info.27.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 27)"},
    {"cal_info.27.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 27)"},
    {"cal_info.27.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 27)"},
    {"cal_info.27.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 27)"},
    {"cal_info.28.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 28)"},
    {"cal_info.28.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 28)"},
    {"cal_info.28.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 28)"},
    {"cal_info.28.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 28)"},
    {"cal_info.29.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 29)"},
    {"cal_info.29.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 29)"},
    {"cal_info.29.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 29)"},
    {"cal_info.29.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 29)"},
    {"cal_info.30.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 30)"},
    {"cal_info.30.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 30)"},
    {"cal_info.30.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 30)"},
    {"cal_info.30.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 30)"},
    {"cal_info.31.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 31)"},
    {"cal_info.31.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 31)"},
    {"cal_info.31.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 31)"},
    {"cal_info.31.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 31)"},
    {"cal_info.32.max_cal", e_tid_float, NULL, 4, "3", "Max of Cal pulses 1, 2, and 3 amplitude (record 32)"},
    {"cal_info.32.avg_cal", e_tid_float, NULL, 4, "3", "Average of Cal pulse 1, 2, and 3 amplitude over the 3 dB on either side of the max amplitude (record 32)"},
    {"cal_info.32.avg_val_1a", e_tid_float, NULL, 4, "1", "Average of Cal pulse 1A over the sample window (record 32)"},
    {"cal_info.32.phs_cal", e_tid_float, "degrees", 4, "4", "Extracted phase for calibration pulse 1, 1A, 2, and 3 (record 32)"},
    {"spare_17", e_tid_spare, NULL, 16, "1", "Spare"},
    {"first_line_time", e_tid_time, "MJD", 12, "1", "Zero Doppler Time at first line of imagette"},
    {"first_line_tie_points.range_samp_nums_first", e_tid_uint, NULL, 4, "3", "Range sample number Gives the range location of the grid points. First range sample is 1,  is M (includes zero filled samples)"},
    {"first_line_tie_points.slant_range_times_first", e_tid_float, "ns", 4, "3", "2 way slant range time to range sample"},
    {"first_line_tie_points.inc_angles_first", e_tid_float, "deg.", 4, "3", "Incidence Angle at range sample"},
    {"first_line_tie_points.lats_first", e_tid_int, "(1e-6) degrees", 4, "3", "geodetic latitude of range sample (positive north)"},
    {"first_line_tie_points.longs_first", e_tid_int, "(1e-6) degrees", 4, "3", "geodetic longitude of range sample (positive east)"},
    {"mid_line_time", e_tid_time, "MJD", 12, "1", "Zero Doppler Time at centre line of imagette"},
    {"mid_range_line_nums", e_tid_uint, NULL, 4, "1", "Range line number of the center range line"},
    {"mid_line_tie_points.range_samp_nums_mid", e_tid_uint, NULL, 4, "3", "Range sample number Gives the range location of the grid points. First range sample is 1,  is M (includes zero filled samples)"},
    {"mid_line_tie_points.slant_range_times_mid", e_tid_float, "ns", 4, "3", "2 way slant range time to range sample"},
    {"mid_line_tie_points.inc_angles_mid", e_tid_float, "deg.", 4, "3", "Incidence Angle at range sample"},
    {"mid_line_tie_points.lats_mid", e_tid_int, "(1e-6) degrees", 4, "3", "geodetic latitude of range sample (positive north)"},
    {"mid_line_tie_points.longs_mid", e_tid_int, "(1e-6) degrees", 4, "3", "geodetic longitude of range sample (positive east)"},
    {"last_line_time", e_tid_time, "MJD", 12, "1", "Zero Doppler Time at last line of imagette"},
    {"last_line_num", e_tid_uint, NULL, 4, "1", "Range line number of the last range line"},
    {"last_line_tie_points.range_samp_nums_last", e_tid_uint, NULL, 4, "3", "Range sample number Gives the range location of the grid points. First range sample is 1,  is M (includes zero filled samples)"},
    {"last_line_tie_points.slant_range_times_last", e_tid_float, "ns", 4, "3", "2 way slant range time to range sample"},
    {"last_line_tie_points.inc_angles_last", e_tid_float, "deg.", 4, "3", "Incidence Angle at range sample"},
    {"last_line_tie_points.lats_last", e_tid_int, "(1e-6) degrees", 4, "3", "geodetic latitude of range sample (positive north)"},
    {"last_line_tie_points.longs_last", e_tid_int, "(1e-6) degrees", 4, "3", "geodetic longitude of range sample (positive east)"},
    {"swst_offset", e_tid_float, "ns", 4, "1", "Wave cell SWST offset from center of the sub-swath to start of imagette. 208 ns increments"},
    {"ground_range_bias", e_tid_float, "km", 4, "1", "Wave cell Ground range bias from centre of the Sub-Swath to the centre of the imagette (Ground range, km)"},
    {"elev_angle_bias", e_tid_float, "deg", 4, "1", "Wave cell Elevation angle biasfrom centre of the Sub-Swath elevation to the centre of the imagette (deg)"},
    {"imagette_range_len", e_tid_float, "m", 4, "1", "Imagette length in range (m)"},
    {"imagette_az_len", e_tid_float, "m", 4, "1", "Imagette length in azimuth (m)"},
    {"imagette_range_res", e_tid_float, "m", 4, "1", "Nominal Imagette resolution in slant range (m)"},
    {"ground_res", e_tid_float, "m", 4, "1", "Nominal resolution in ground range"},
    {"imagette_az_res", e_tid_float, "m", 4, "1", "Nominal Imagette resolution in azimuth (m)"},
    {"platform_alt", e_tid_float, "m", 4, "1", "Altitude (platform to ellipsoid) in metres (centre of wave cell)"},
    {"platform_vel", e_tid_float, "m/s", 4, "1", "Platform Velocity (m/s)w.r.t moving earth"},
    {"slant_range", e_tid_float, "m", 4, "1", "Range to centre of imagette (m)from platform to target"},
    {"cw_drift", e_tid_float, NULL, 4, "1", "CW signal drift"},
    {"wave_subcycle", e_tid_ushort, NULL, 2, "1", "Wave sub-cycle (1 or 2) of this wave cell"},
    {"earth_radius", e_tid_float, "m", 4, "1", "Earth Radius at imagette center sample"},
    {"sat_height", e_tid_float, "m", 4, "1", "Satellite distance to earth center"},
    {"first_sample_slant_range", e_tid_float, "m", 4, "1", "Distance from satellite to first range pixel in the full SLC image"},
    {"spare_18", e_tid_spare, NULL, 12, "1", "Spare"},
    {"elevation_pattern.slant_range_time", e_tid_float, "ns", 4, "11", "2 way slant range times"},
    {"elevation_pattern.elevation_angles", e_tid_float, "degrees", 4, "11", "Corresponding elevation angles"},
    {"elevation_pattern.antenna_pattern", e_tid_float, "dB", 4, "11", "Corresponding two-way antenna elevation pattern values"},
    {"spare_19", e_tid_spare, NULL, 14, "1", "Spare"}
};

static const struct RecordDescriptor ASAR_Wave_SQ_ADSR_asar_rec_data[] = {
    {"zero_doppler_time", e_tid_time, "MJD", 12, "1", "Zero doppler time at which SQ information applies"},
    {"attach_flag", e_tid_uchar, "flag", 1, "1", "Attachment Flag. Set to 1 if PF-ASAR was unable to produce an imagette for the wave cell. The fields in other DSR's corresponding to this one are set to zero, apart from the Zero Doppler Time."},
    {"input_mean_flag", e_tid_uchar, "flag", 1, "1", "Input data mean outside nominal range flag0 = mean of I and Q input values are both within specified range from expected mean. For expected mean of x, the measured mean must fall between x-threshold to x+threshold.1 = otherwise"},
    {"input_std_dev_flag", e_tid_uchar, "flag", 1, "1", "Input data standard deviation outside nominal range flag0 = standard deviation values of I and Q input values are both within specified range of expected standard deviation. For expected std. dev. x, the measured std. dev. must fall between x-threshold to"},
    {"input_gaps_flag", e_tid_uchar, "flag", 1, "1", "Significant gaps in the input data flagAn input data gap is defined as a contiguous block of N missing lines (the value of N is predefined for each product)0 = number of input gaps &lt;= threshold value1 = number of input data gaps &gt; threshold value"},
    {"input_missing_lines_flag", e_tid_uchar, "flag", 1, "1", "Missing lines significant flag 0 = percentage of missing lines &lt;= threshold value 1 = percentage of missing lines &gt; threshold valueThe number of missing lines is the number of lines missing from the input data excluding data gaps."},
    {"dop_cen_flag", e_tid_uchar, "flag", 1, "1", "Doppler Centroid Uncertain flag0 = confidence measure &gt;= specified value1 = Error message generated if confidence measure &lt; specified value(note: if more than one Doppler centroid estimation is performed in a slice the flag is set if any confidence measur"},
    {"dop_amb_flag", e_tid_uchar, "flag", 1, "1", "Doppler ambiguity estimate uncertain flag0 = confidence measure &gt;= specified value1 = confidence measure &lt; specified value"},
    {"output_mean_flag", e_tid_uchar, "flag", 1, "1", "Output data mean outside nominal range flag0 = mean of I and Q output values for SLC image or mean of detected pixels for a detected product, are both within specified range from expected mean. For expected mean of x, the measured mean must fall between x"},
    {"output_std_dev_flag", e_tid_uchar, "flag", 1, "1", "Output data standard deviation outside nominal range flag0 = std. dev. of I and Q output values for SLC image or std. dev. of detected pixels for a detected product, are both within specified range from expected std. dev. For expected std. dev. of x, the"},
    {"chirp_flag", e_tid_uchar, "flag", 1, "1", "Chirp extraction failed or is of low quality flag 0 = able to extract all chirps or chirp extraction not requested (nominal chirp used) AND all quality measures were acceptable.1 = unable to extract a chirp during processing and chirp extraction was reque"},
    {"missing_data_sets_flag", e_tid_uchar, "flag", 1, "1", "Data sets missing flag0 = all data sets which are supposed to be in the product are present1 = any data sets (including ADSs) are missing from the product which are supposed to be included under normal circumstances. Which data sets are missing can be det"},
    {"invalid_downlink_flag", e_tid_uchar, "flag", 1, "1", "Invalid downlink parameters flag0 = all parameters read from the downlinked data were valid1 = displayed if any downlink parameter is out of range and therefore a default value has been used during processing."},
    {"spare_1", e_tid_spare, NULL, 7, "1", "Spare"},
    {"thresh_chirp_broadening", e_tid_float, "%", 4, "1", "Threshold for setting the chirp quality flag. Maximum percentage broadening permitted in cross-correlation pulse width compared to theoretical width."},
    {"thresh_chirp_sidelobe", e_tid_float, "dB", 4, "1", "Threshold for setting the chirp quality flag - First sidelobe of the chirp cross correlation function"},
    {"thresh_chirp_islr", e_tid_float, "dB", 4, "1", "Threshold for setting the chirp quality flag - ISLR of the chirp cross correlation function"},
    {"thresh_input_mean", e_tid_float, NULL, 4, "1", "Threshold for setting the mean of input data quality flag - For an expected mean value of x, this is the value T, such that the measured mean must fall between the x-T and x+T."},
    {"exp_input_mean", e_tid_float, NULL, 4, "1", "Expected mean input value for this product for both I and Q."},
    {"thresh_input_std_dev", e_tid_float, NULL, 4, "1", "Threshold for setting the standard deviation of input data quality flag - For an expected std. dev. value of y, this is the value D, such that the measured std. dev. must fall between the y-D and y+D."},
    {"exp_input_std_dev", e_tid_float, NULL, 4, "1", "Expected input std. dev. for this product for both I and Q."},
    {"thresh_dop_cen", e_tid_float, NULL, 4, "1", "Threshold for setting the Doppler Centroid quality flag - Threshold for Doppler Centroid confidence"},
    {"thresh_dop_amb", e_tid_float, NULL, 4, "1", "Threshold for setting the Doppler Centroid ambiguity quality flag - Threshold for setting the Doppler Centroid ambiguity confidence flag"},
    {"thresh_output_mean", e_tid_float, NULL, 4, "1", "Threshold for setting the mean of output data quality flag - For an expected mean value of x, this is the value T, such that the measured mean must fall between the x-T and x+T."},
    {"exp_output_mean", e_tid_float, NULL, 4, "1", "Expected mean output value for this product. For an SLC product this is the expected mean of both the I and Q values."},
    {"thresh_output_std_dev", e_tid_float, NULL, 4, "1", "Threshold for setting the standard deviation of output data quality flag - For an expected std. dev. value of y, this is the value D, such that the measured std. dev. must fall between the y-D and y+D."},
    {"exp_output_std_dev", e_tid_float, NULL, 4, "1", "Expected output std. dev. for this product. For an SLC product this is the expected output std. dev. for both I and Q values."},
    {"thresh_input_missing_lines", e_tid_float, "%", 4, "1", "Threshold for setting the missing lines quality flag - maximum percentage of missing lines to total lines."},
    {"thresh_input_gaps", e_tid_float, NULL, 4, "1", "Threshold for setting the missing gaps quality flag - maximum number of missing gaps allowed."},
    {"lines_per_gaps", e_tid_uint, "lines", 4, "1", "Number of missing lines which constitute a gap"},
    {"spare_2", e_tid_spare, NULL, 15, "1", "Spare"},
    {"input_mean", e_tid_float, NULL, 4, "2", "Input data mean (i channel, q channel"},
    {"input_std_dev", e_tid_float, NULL, 4, "2", "Input data standard deviation (i channel, q channel)"},
    {"num_gaps", e_tid_float, NULL, 4, "1", "Number of gaps (composed of a predetermined number of consecutive missing lines)"},
    {"num_missing_lines", e_tid_float, NULL, 4, "1", "Number of missing lines (excluding gaps)"},
    {"output_mean", e_tid_float, NULL, 4, "2", "Output data mean (detected samples, followed by zero, or i channel followed by q channel for SLC)"},
    {"output_std_dev", e_tid_float, NULL, 4, "2", "Output data standard deviation (detected samples followed by zero,  or i channel followed by q channel for SLC)"},
    {"tot_errors", e_tid_uint, NULL, 4, "1", "Total number of errors detected in ISP headers"},
    {"Spare_3", e_tid_spare, NULL, 16, "1", "Spare"},
    {"land_flag", e_tid_uchar, "flag", 1, "1", "Land Flag 0 = no land in imagette1 = land in imagette"},
    {"look_conf_flag", e_tid_uchar, "flag", 1, "1", "Look image statistics confidence parameter flag 1 = The ratio of the standard deviation to the mean of the first look image is outside the range given by a minimum and a maximum threshold.0 =otherwise"},
    {"inter_look_conf_flag", e_tid_uchar, "flag", 1, "1", "Inter-look confidence statistics confidence parameter flag1 = The normalised deviation of the two inter-look sub-images is greater than a maximum threshold.0 = otherwise"},
    {"az_cutoff_flag", e_tid_uchar, "flag", 1, "1", "Azimuth cut-off convergence measure flag1 = The normalised RMS error between the fitted co-variance profile is greater than a maximum threshold.0 = otherwise"},
    {"az_cutoff_iteration_flag", e_tid_uchar, "flag", 1, "1", "Azimuth cut-off Iteration count overflow flag1 = The Azimuth cut-off fit did not converge within a minimum number of iterations.0 = otherwise"},
    {"phase_flag", e_tid_uchar, "flag", 1, "1", "Phase information confidence measure flag1 = The imaginary spectral peak is less than a minimum threshold, and the zero lag shift is greater than a minimum threshold.0 = otherwise"},
    {"spare_4", e_tid_spare, NULL, 4, "1", "Spare"},
    {"look_conf_thresh", e_tid_float, NULL, 4, "2", "Look image statistics confidence parameter thresholds (minimum and maximum)"},
    {"inter_look_conf_thresh", e_tid_float, NULL, 4, "1", "Inter-look confidence statistics confidence parameter threshold"},
    {"az_cutoff_thresh", e_tid_float, NULL, 4, "1", "Azimuth cut-off convergence measure threshold"},
    {"az_cutoff_iterations_thresh", e_tid_uint, NULL, 4, "1", "Azimuth cut-off Iteration count overflow threshold"},
    {"phase_peak_thresh", e_tid_float, NULL, 4, "1", "Phase information confidence measure threshold for the spectral peak"},
    {"phase_cross_thresh", e_tid_float, "m", 4, "1", "Phase information confidence measure threshold for cross covariance peak offset"},
    {"spare_5", e_tid_spare, NULL, 12, "1", "Spare"},
    {"look_conf", e_tid_float, NULL, 4, "1", "Look image statistics confidence parameterThe ratio of the standard deviation to the mean of the first look image"},
    {"inter_look_conf", e_tid_float, NULL, 4, "1", "Inter-look confidence statistics confidence parameter.The normalised deviation of the two inter-look sub-images"},
    {"az_cutoff", e_tid_float, NULL, 4, "1", "Azimuth cut-off convergence measureThe normalised RMS error between the fitted co-variance profile"},
    {"phase_peak_conf", e_tid_float, NULL, 4, "1", "Phase information confidence measure for the spectral peakThe imaginary spectral peak"},
    {"phase_cross_conf", e_tid_float, "m", 4, "1", "Phase information confidence measure for cross covariance peak offset"},
    {"spare_6", e_tid_spare, NULL, 12, "1", "Spare"}
};

static const struct RecordDescriptor ASA_CON_AX_GADS_asar_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Time of creation"},
    {"dsr_length", e_tid_uint, "bytes", 4, "1", "Length of this DSR in bytes"},
    {"thresh_chirp_broadening", e_tid_float, "%", 4, "1", "Threshold for setting the chirp quality flag. Maximum percentage broadening permitted in cross-correlation pulse width compared to theoretical width."},
    {"thresh_chirp_sidelobe", e_tid_float, "dB", 4, "1", "Threshold for setting the chirp quality flag - First sidelobe of the chirp cross correlation function"},
    {"thresh_chirp_islr", e_tid_float, "dB", 4, "1", "Threshold for setting the chirp quality flag - ISLR of the chirp cross correlation function"},
    {"thresh_input_mean", e_tid_float, NULL, 4, "1", "Threshold for setting the mean of input data quality flag - For an expected mean value of x, this is the value T, such that the measured mean must fall between the x-T and x+T. Used for both I and Q channels."},
    {"thresh_input_std_dev", e_tid_float, NULL, 4, "1", "Threshold for setting the standard deviation of input data quality flag - For an expected std. dev. value of y, this is the value D, such that the measured std. dev. must fall between the y-D and y+D. Used for both I and Q channels."},
    {"thresh_dop_cen", e_tid_float, NULL, 4, "1", "Threshold for setting the Doppler Centroid quality flag - Threshold for Doppler Centroid confidence"},
    {"thresh_dop_amb", e_tid_float, NULL, 4, "1", "Threshold for setting the Doppler Centroid ambiguity quality flag - Threshold for setting the Doppler Centroid ambiguity confidence flag"},
    {"thresh_output_mean", e_tid_float, NULL, 4, "1", "Threshold for setting the mean of output data quality flag - For an expected mean value of x, this is the value T, such that the measured mean must fall between the x-T and x+T."},
    {"thresh_output_std_dev", e_tid_float, NULL, 4, "1", "Threshold for setting the standard deviation of output data quality flag - For an expected std. dev. value of y, this is the value D, such that the measured std. dev. must fall between the y-D and y+D."},
    {"thresh_missing_lines", e_tid_float, NULL, 4, "1", "Threshold for setting the missing lines quality flag - maximum percentage of missing lines to total lines."},
    {"thresh_gaps", e_tid_float, NULL, 4, "1", "Threshold for setting the missing gaps quality flag - maximum number of gaps allowed."},
    {"spare_1", e_tid_spare, NULL, 64, "1", "Spare"},
    {"lines_per_gap", e_tid_uint, "lines", 4, "1", "Number of missing lines which constitute a gap"},
    {"exp_im_mean", e_tid_float, NULL, 4, "1", "Expected mean of I and Q samples for IM (and WV) SLC images"},
    {"exp_im_std_dev", e_tid_float, NULL, 4, "1", "Expected standard deviation of I and Q samples for IM (and WV) SLC images"},
    {"exp_ap_mean", e_tid_float, NULL, 4, "1", "Expected mean of I and Q samples for AP SLC images"},
    {"exp_ap_std_dev", e_tid_float, NULL, 4, "1", "Expected standard deviation of I and Q samples for AP SLC images"},
    {"exp_imp_mean", e_tid_float, NULL, 4, "1", "Expected mean of IM PRI samples"},
    {"exp_imp_std_dev", e_tid_float, NULL, 4, "1", "Expected standard deviation of IM PRI samples"},
    {"exp_app_mean", e_tid_float, NULL, 4, "1", "Expected mean of AP PRI samples"},
    {"exp_app_std_dev", e_tid_float, NULL, 4, "1", "Expected standard deviation of AP PRI samples"},
    {"exp_imm_mean", e_tid_float, NULL, 4, "1", "Expected mean of IMM samples"},
    {"exp_imm_std_dev", e_tid_float, NULL, 4, "1", "Expected standard deviation of IMM samples"},
    {"exp_apm_mean", e_tid_float, NULL, 4, "1", "Expected mean of APM samples"},
    {"exp_apm_std_dev", e_tid_float, NULL, 4, "1", "Expected standard deviation of APM samples"},
    {"exp_wsm_mean", e_tid_float, NULL, 4, "1", "Expected mean of WSM samples"},
    {"exp_wsm_std_dev", e_tid_float, NULL, 4, "1", "Expected standard deviation of WSM samples"},
    {"exp_gm1_mean", e_tid_float, NULL, 4, "1", "Expected mean of GM1 samples"},
    {"exp_gm1_std_dev", e_tid_float, NULL, 4, "1", "Expected standard deviation of GM1 samples"},
    {"input_mean", e_tid_float, NULL, 4, "1", "Expected  input mean"},
    {"expected_input_std_dev", e_tid_float, NULL, 4, "1", "Expected input standard deviation"},
    {"look_conf_thresh", e_tid_float, NULL, 4, "2", "Look image statistics confidence parameter thresholds (minimum and maximum)"},
    {"inter_look_conf_thresh", e_tid_float, NULL, 4, "1", "Inter-look confidence statistics confidence parameter threshold"},
    {"az_cutoff_thresh", e_tid_float, NULL, 4, "1", "Azimuth cut-off convergence measure threshold"},
    {"az_cutoff_iterations_thresh", e_tid_float, NULL, 4, "1", "Azimuth cut-off Iteration count overflow threshold"},
    {"phs_peak_thresh", e_tid_float, NULL, 4, "1", "Phase information confidence measure threshold for the spectral peak"},
    {"phs_cross_thresh", e_tid_float, "m", 4, "1", "Phase information confidence measure threshold for the cross covariance peak offset"},
    {"spare_2", e_tid_spare, NULL, 64, "1", "Spare"},
    {"spare_3", e_tid_spare, NULL, 504, "1", "Spare"}
};

static const struct RecordDescriptor ASA_INS_AX_GADS_asar_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Time of creation"},
    {"dsr_length", e_tid_uint, "bytes", 4, "1", "Length of this DSR in bytes"},
    {"radar_freq", e_tid_float, "Hz", 4, "1", "Radar Frequency"},
    {"samp_rate", e_tid_float, "Hz", 4, "1", "Radar Sampling Rate"},
    {"offset_freq", e_tid_float, "Hz", 4, "1", "Offset frequency for wave mode calibration pulses"},
    {"cal_pulse_im_hh_1.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_im_hh_1.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_im_hh_1.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_im_hh_1.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_im_hh_1.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_im_hh_1.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_im_hh_1.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_im_hh_1.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_im_hh_1.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_im_hh_1.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_im_hh_1.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_im_hh_1.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_im_hh_1.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_im_hh_1.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_im_vv_1.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_im_vv_1.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_im_vv_1.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_im_vv_1.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_im_vv_1.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_im_vv_1.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_im_vv_1.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_im_vv_1.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_im_vv_1.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_im_vv_1.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_im_vv_1.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_im_vv_1.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_im_vv_1.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_im_vv_1.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_im_hh_2.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_im_hh_2.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_im_hh_2.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_im_hh_2.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_im_hh_2.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_im_hh_2.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_im_hh_2.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_im_hh_2.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_im_hh_2.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_im_hh_2.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_im_hh_2.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_im_hh_2.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_im_hh_2.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_im_hh_2.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_im_vv_2.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_im_vv_2.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_im_vv_2.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_im_vv_2.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_im_vv_2.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_im_vv_2.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_im_vv_2.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_im_vv_2.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_im_vv_2.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_im_vv_2.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_im_vv_2.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_im_vv_2.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_im_vv_2.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_im_vv_2.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_im_hh_3.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_im_hh_3.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_im_hh_3.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_im_hh_3.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_im_hh_3.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_im_hh_3.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_im_hh_3.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_im_hh_3.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_im_hh_3.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_im_hh_3.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_im_hh_3.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_im_hh_3.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_im_hh_3.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_im_hh_3.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_im_vv_3.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_im_vv_3.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_im_vv_3.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_im_vv_3.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_im_vv_3.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_im_vv_3.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_im_vv_3.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_im_vv_3.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_im_vv_3.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_im_vv_3.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_im_vv_3.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_im_vv_3.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_im_vv_3.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_im_vv_3.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_hh_1.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_hh_1.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_hh_1.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_hh_1.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_hh_1.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_hh_1.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_hh_1.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_hh_1.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_hh_1.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_hh_1.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_hh_1.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_hh_1.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_hh_1.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_hh_1.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_vv_1.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_vv_1.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_vv_1.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_vv_1.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_vv_1.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_vv_1.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_vv_1.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_vv_1.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_vv_1.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_vv_1.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_vv_1.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_vv_1.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_vv_1.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_vv_1.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_hv_1.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_hv_1.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_hv_1.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_hv_1.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_hv_1.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_hv_1.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_hv_1.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_hv_1.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_hv_1.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_hv_1.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_hv_1.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_hv_1.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_hv_1.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_hv_1.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_vh_1.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_vh_1.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_vh_1.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_vh_1.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_vh_1.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_vh_1.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_vh_1.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_vh_1.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_vh_1.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_vh_1.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_vh_1.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_vh_1.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_vh_1.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_vh_1.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_hh_2.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_hh_2.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_hh_2.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_hh_2.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_hh_2.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_hh_2.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_hh_2.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_hh_2.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_hh_2.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_hh_2.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_hh_2.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_hh_2.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_hh_2.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_hh_2.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_vv_2.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_vv_2.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_vv_2.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_vv_2.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_vv_2.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_vv_2.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_vv_2.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_vv_2.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_vv_2.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_vv_2.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_vv_2.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_vv_2.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_vv_2.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_vv_2.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_hv_2.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_hv_2.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_hv_2.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_hv_2.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_hv_2.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_hv_2.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_hv_2.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_hv_2.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_hv_2.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_hv_2.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_hv_2.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_hv_2.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_hv_2.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_hv_2.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_vh_2.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_vh_2.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_vh_2.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_vh_2.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_vh_2.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_vh_2.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_vh_2.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_vh_2.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_vh_2.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_vh_2.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_vh_2.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_vh_2.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_vh_2.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_vh_2.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_hh_3.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_hh_3.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_hh_3.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_hh_3.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_hh_3.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_hh_3.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_hh_3.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_hh_3.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_hh_3.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_hh_3.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_hh_3.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_hh_3.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_hh_3.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_hh_3.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_vv_3.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_vv_3.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_vv_3.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_vv_3.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_vv_3.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_vv_3.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_vv_3.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_vv_3.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_vv_3.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_vv_3.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_vv_3.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_vv_3.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_vv_3.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_vv_3.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_hv_3.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_hv_3.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_hv_3.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_hv_3.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_hv_3.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_hv_3.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_hv_3.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_hv_3.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_hv_3.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_hv_3.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_hv_3.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_hv_3.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_hv_3.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_hv_3.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_vh_3.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_vh_3.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ap_vh_3.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_vh_3.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ap_vh_3.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_vh_3.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ap_vh_3.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_vh_3.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ap_vh_3.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_vh_3.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ap_vh_3.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_vh_3.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_ap_vh_3.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ap_vh_3.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_wv_hh_1.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_wv_hh_1.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_wv_hh_1.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_wv_hh_1.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_wv_hh_1.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_wv_hh_1.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_wv_hh_1.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_wv_hh_1.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_wv_hh_1.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_wv_hh_1.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_wv_hh_1.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_wv_hh_1.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_wv_hh_1.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_wv_hh_1.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_wv_vv_1.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_wv_vv_1.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_wv_vv_1.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_wv_vv_1.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_wv_vv_1.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_wv_vv_1.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_wv_vv_1.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_wv_vv_1.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_wv_vv_1.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_wv_vv_1.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_wv_vv_1.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_wv_vv_1.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_wv_vv_1.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_wv_vv_1.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_wv_hh_2.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_wv_hh_2.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_wv_hh_2.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_wv_hh_2.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_wv_hh_2.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_wv_hh_2.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_wv_hh_2.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_wv_hh_2.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_wv_hh_2.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_wv_hh_2.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_wv_hh_2.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_wv_hh_2.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_wv_hh_2.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_wv_hh_2.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_wv_vv_2.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_wv_vv_2.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_wv_vv_2.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_wv_vv_2.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_wv_vv_2.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_wv_vv_2.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_wv_vv_2.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_wv_vv_2.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_wv_vv_2.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_wv_vv_2.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_wv_vv_2.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_wv_vv_2.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_wv_vv_2.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_wv_vv_2.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_wv_hh_3.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_wv_hh_3.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_wv_hh_3.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_wv_hh_3.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_wv_hh_3.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_wv_hh_3.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_wv_hh_3.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_wv_hh_3.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_wv_hh_3.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_wv_hh_3.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_wv_hh_3.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_wv_hh_3.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_wv_hh_3.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_wv_hh_3.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_wv_vv_3.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_wv_vv_3.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_wv_vv_3.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_wv_vv_3.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_wv_vv_3.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_wv_vv_3.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_wv_vv_3.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_wv_vv_3.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_wv_vv_3.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_wv_vv_3.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_wv_vv_3.6.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_wv_vv_3.6.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 6)"},
    {"cal_pulse_wv_vv_3.7.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_wv_vv_3.7.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 7)"},
    {"cal_pulse_ws_hh_1.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ws_hh_1.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ws_hh_1.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ws_hh_1.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ws_hh_1.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ws_hh_1.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ws_hh_1.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ws_hh_1.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ws_hh_1.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ws_hh_1.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ws_vv_1.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ws_vv_1.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ws_vv_1.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ws_vv_1.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ws_vv_1.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ws_vv_1.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ws_vv_1.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ws_vv_1.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ws_vv_1.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ws_vv_1.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ws_hh_2.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ws_hh_2.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ws_hh_2.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ws_hh_2.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ws_hh_2.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ws_hh_2.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ws_hh_2.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ws_hh_2.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ws_hh_2.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ws_hh_2.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ws_vv_2.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ws_vv_2.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ws_vv_2.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ws_vv_2.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ws_vv_2.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ws_vv_2.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ws_vv_2.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ws_vv_2.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ws_vv_2.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ws_vv_2.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ws_hh_3.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ws_hh_3.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ws_hh_3.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ws_hh_3.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ws_hh_3.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ws_hh_3.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ws_hh_3.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ws_hh_3.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ws_hh_3.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ws_hh_3.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ws_vv_3.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ws_vv_3.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_ws_vv_3.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ws_vv_3.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_ws_vv_3.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ws_vv_3.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_ws_vv_3.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ws_vv_3.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_ws_vv_3.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_ws_vv_3.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_gm_hh_1.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_gm_hh_1.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_gm_hh_1.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_gm_hh_1.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_gm_hh_1.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_gm_hh_1.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_gm_hh_1.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_gm_hh_1.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_gm_hh_1.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_gm_hh_1.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_gm_vv_1.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_gm_vv_1.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_gm_vv_1.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_gm_vv_1.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_gm_vv_1.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_gm_vv_1.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_gm_vv_1.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_gm_vv_1.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_gm_vv_1.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_gm_vv_1.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_gm_hh_2.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_gm_hh_2.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_gm_hh_2.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_gm_hh_2.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_gm_hh_2.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_gm_hh_2.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_gm_hh_2.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_gm_hh_2.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_gm_hh_2.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_gm_hh_2.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_gm_vv_2.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_gm_vv_2.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_gm_vv_2.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_gm_vv_2.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_gm_vv_2.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_gm_vv_2.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_gm_vv_2.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_gm_vv_2.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_gm_vv_2.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_gm_vv_2.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_gm_hh_3.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_gm_hh_3.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_gm_hh_3.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_gm_hh_3.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_gm_hh_3.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_gm_hh_3.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_gm_hh_3.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_gm_hh_3.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_gm_hh_3.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_gm_hh_3.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_gm_vv_3.1.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_gm_vv_3.1.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 1)"},
    {"cal_pulse_gm_vv_3.2.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_gm_vv_3.2.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 2)"},
    {"cal_pulse_gm_vv_3.3.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_gm_vv_3.3.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 3)"},
    {"cal_pulse_gm_vv_3.4.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_gm_vv_3.4.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 4)"},
    {"cal_pulse_gm_vv_3.5.nom_amplitude", e_tid_float, NULL, 4, "32", "Nominal amplitude (ax,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"cal_pulse_gm_vv_3.5.nom_phase", e_tid_float, "cycles", 4, "32", "Nominal value of phase (fx,n,nom) for antenna row 1 to antenna row 32 (where x is the pulse number) (record 5)"},
    {"nom_pulse_im.1.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 1)"},
    {"nom_pulse_im.1.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 1)"},
    {"nom_pulse_im.1.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 1)"},
    {"nom_pulse_im.2.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 2)"},
    {"nom_pulse_im.2.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 2)"},
    {"nom_pulse_im.2.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 2)"},
    {"nom_pulse_im.3.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 3)"},
    {"nom_pulse_im.3.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 3)"},
    {"nom_pulse_im.3.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 3)"},
    {"nom_pulse_im.4.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 4)"},
    {"nom_pulse_im.4.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 4)"},
    {"nom_pulse_im.4.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 4)"},
    {"nom_pulse_im.5.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 5)"},
    {"nom_pulse_im.5.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 5)"},
    {"nom_pulse_im.5.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 5)"},
    {"nom_pulse_im.6.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 6)"},
    {"nom_pulse_im.6.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 6)"},
    {"nom_pulse_im.6.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 6)"},
    {"nom_pulse_im.7.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 7)"},
    {"nom_pulse_im.7.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 7)"},
    {"nom_pulse_im.7.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 7)"},
    {"nom_pulse_ap.1.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 1)"},
    {"nom_pulse_ap.1.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 1)"},
    {"nom_pulse_ap.1.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 1)"},
    {"nom_pulse_ap.2.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 2)"},
    {"nom_pulse_ap.2.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 2)"},
    {"nom_pulse_ap.2.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 2)"},
    {"nom_pulse_ap.3.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 3)"},
    {"nom_pulse_ap.3.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 3)"},
    {"nom_pulse_ap.3.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 3)"},
    {"nom_pulse_ap.4.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 4)"},
    {"nom_pulse_ap.4.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 4)"},
    {"nom_pulse_ap.4.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 4)"},
    {"nom_pulse_ap.5.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 5)"},
    {"nom_pulse_ap.5.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 5)"},
    {"nom_pulse_ap.5.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 5)"},
    {"nom_pulse_ap.6.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 6)"},
    {"nom_pulse_ap.6.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 6)"},
    {"nom_pulse_ap.6.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 6)"},
    {"nom_pulse_ap.7.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 7)"},
    {"nom_pulse_ap.7.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 7)"},
    {"nom_pulse_ap.7.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 7)"},
    {"nom_pulse_wv.1.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 1)"},
    {"nom_pulse_wv.1.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 1)"},
    {"nom_pulse_wv.1.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 1)"},
    {"nom_pulse_wv.2.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 2)"},
    {"nom_pulse_wv.2.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 2)"},
    {"nom_pulse_wv.2.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 2)"},
    {"nom_pulse_wv.3.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 3)"},
    {"nom_pulse_wv.3.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 3)"},
    {"nom_pulse_wv.3.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 3)"},
    {"nom_pulse_wv.4.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 4)"},
    {"nom_pulse_wv.4.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 4)"},
    {"nom_pulse_wv.4.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 4)"},
    {"nom_pulse_wv.5.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 5)"},
    {"nom_pulse_wv.5.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 5)"},
    {"nom_pulse_wv.5.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 5)"},
    {"nom_pulse_wv.6.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 6)"},
    {"nom_pulse_wv.6.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 6)"},
    {"nom_pulse_wv.6.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 6)"},
    {"nom_pulse_wv.7.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 7)"},
    {"nom_pulse_wv.7.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 7)"},
    {"nom_pulse_wv.7.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 7)"},
    {"nom_pulse_ws.1.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 1)"},
    {"nom_pulse_ws.1.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 1)"},
    {"nom_pulse_ws.1.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 1)"},
    {"nom_pulse_ws.2.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 2)"},
    {"nom_pulse_ws.2.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 2)"},
    {"nom_pulse_ws.2.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 2)"},
    {"nom_pulse_ws.3.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 3)"},
    {"nom_pulse_ws.3.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 3)"},
    {"nom_pulse_ws.3.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 3)"},
    {"nom_pulse_ws.4.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 4)"},
    {"nom_pulse_ws.4.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 4)"},
    {"nom_pulse_ws.4.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 4)"},
    {"nom_pulse_ws.5.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 5)"},
    {"nom_pulse_ws.5.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 5)"},
    {"nom_pulse_ws.5.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 5)"},
    {"nom_pulse_gm.1.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 1)"},
    {"nom_pulse_gm.1.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 1)"},
    {"nom_pulse_gm.1.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 1)"},
    {"nom_pulse_gm.2.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 2)"},
    {"nom_pulse_gm.2.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 2)"},
    {"nom_pulse_gm.2.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 2)"},
    {"nom_pulse_gm.3.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 3)"},
    {"nom_pulse_gm.3.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 3)"},
    {"nom_pulse_gm.3.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 3)"},
    {"nom_pulse_gm.4.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 4)"},
    {"nom_pulse_gm.4.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 4)"},
    {"nom_pulse_gm.4.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 4)"},
    {"nom_pulse_gm.5.pulse_amp_coeff", e_tid_float, "-, s-1, s-2, s-3", 4, "4", "4 pulse amplitude coefficients (record 5)"},
    {"nom_pulse_gm.5.pulse_phs_coeff", e_tid_float, "cyclesHz,Hz/s,Hz/s2", 4, "4", "4 pulse phase coefficients (record 5)"},
    {"nom_pulse_gm.5.pulse_duration", e_tid_float, "s", 4, "1", "Nominal pulse duration (record 5)"},
    {"az_pattern", e_tid_float, "dB", 4, "101", "2 way antenna azimuth pattern(pattern values are from beam center - 0.25 deg to beam center + 0.25 deg. in 0.005 degree steps. TBC by ESA)"},
    {"range_gate_bias", e_tid_float, "s", 4, "1", "Range Gate bias"},
    {"adc_lut_i", e_tid_float, NULL, 4, "255", "Look Up Table for ADC Characterization (I Channel)Contains 255 normalized amplitude levels corresponding to voltage thresholds. First value in LUT is for -127, last value is for +127. Format as is given in PO-TN-MMS-SR-0248."},
    {"adc_lut_q", e_tid_float, NULL, 4, "255", "Look Up Table for ADC Characterization (Q Channel)Contains 255 normalized amplitude levels corresponding to voltage thresholds. First value in LUT is for -127, last value is for +127. Format as is given in PO-TN-MMS-SR-0248."},
    {"spare_1", e_tid_spare, NULL, 60, "1", "Spare"},
    {"full8_lut_i", e_tid_float, NULL, 4, "256", "Reconstruction Look Up Table for Full 8-bit Quantization (I Channel)Contains normalized amplitude levels corresponding to sample codewords. First value in LUT is for codeword 0, last value is for +255 (binary offset format). Format as is given in PO-TN-MM"},
    {"full8_lut_q", e_tid_float, NULL, 4, "256", "Reconstruction Look Up Table for Full 8-bit Quantization (Q Channel)Contains normalized amplitude levels corresponding to sample codewords. First value in LUT is for codeword 0, last value is for +255 (binary- offset format). Format as is given in PO-TN-M"},
    {"fbaq4_lut_i", e_tid_float, NULL, 4, "4096", "Reconstruction Look Up Table for FBAQ 4-bit Quantization (I Channel)Gives 4096 normalized amplitude reconstruction levels which include ADC correction. Format as is given in PO-TN-MMS-SR-0248."},
    {"fbaq3_lut_i", e_tid_float, NULL, 4, "2048", "Reconstruction Look Up Table for FBAQ 3-bit Quantization (I Channel)Gives 2048 normalized amplitude reconstruction levels which include ADC correction. Format as is given in PO-TN-MMS-SR-0248."},
    {"fbaq2_lut_i", e_tid_float, NULL, 4, "1024", "Reconstruction Look Up Table for FBAQ 2-bit Quantization (I Channel)Gives 1024 normalized amplitude reconstruction levels which include ADC correction. Format as is given in PO-TN-MMS-SR-0248."},
    {"fbaq4_lut_q", e_tid_float, NULL, 4, "4096", "Reconstruction Look Up Table for FBAQ 4-bit Quantization (Q Channel)Gives 4096 normalized amplitude reconstruction levels which include ADC correction. Format as is given in PO-TN-MMS-SR-0248."},
    {"fbaq3_lut_q", e_tid_float, NULL, 4, "2048", "Reconstruction Look Up Table for FBAQ 3-bit Quantization (Q Channel)Gives 2048 normalized amplitude reconstruction levels which include ADC correction. Format as is given in PO-TN-MMS-SR-0248."},
    {"fbaq2_lut_q", e_tid_float, NULL, 4, "1024", "Reconstruction Look Up Table for FBAQ 2-bit Quantization (Q Channel)Gives 1024 normalized amplitude reconstruction levels which include ADC correction. Format as is given in PO-TN-MMS-SR-0248."},
    {"fbaq4_no_adc", e_tid_float, "values from-127 to +127", 4, "4096", "Reconstruction Look Up Table for FBAQ 4-bit Quantization (no ADC)This is the FBAQ reconstruction LUT which does not have ADC correction incorporated into it. It gives 4096 reconstruction levels which decodes FBAQ codewords to floating point values on the"},
    {"fbaq3_no_adc", e_tid_float, "values from-127 to +127", 4, "2048", "Reconstruction Look Up Table for FBAQ 3-bit Quantization (no ADC)This is the FBAQ reconstruction LUT which does not have ADC correction incorporated into it. It gives 2048 reconstruction levels which decodes FBAQ codewords to floating point values on the"},
    {"fbaq2_no_adc", e_tid_float, "values from-127 to +127-", 4, "1024", "Reconstruction Look Up Table for FBAQ 2-bit Quantization (No ADC)This is the FBAQ reconstruction LUT which does not have ADC correction incorporated into it. It gives 1024 reconstruction levels which decodes FBAQ codewords to floating point values on the"},
    {"sm_lut_i", e_tid_float, NULL, 4, "16", "Reconstruction Look Up Table for Sign + Magnitude Quantization (I Channel)Contains normalized amplitude reconstruction levels corresponding to sample codewords. First value in LUT is for threshold -7, last value is for threshold +7. Format as is given in"},
    {"sm_lut_q", e_tid_float, NULL, 4, "16", "Reconstruction Look Up Table for Sign + Magnitude Quantization (Q Channel)Contains normalized amplitude reconstruction levels corresponding to sample codewords. First value in LUT is for threshold -7, last value is for threshold +7. Format as is given in"},
    {"data_config_im.echo_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for echo samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_im.echo_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for echo samples: 8/4, 8/3, 8/2, 8/8"},
    {"data_config_im.echo_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to echo samples? (1=yes, 0=no)"},
    {"data_config_im.init_cal_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for initial calibration samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_im.init_cal_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for initial calibration samples8/4, 8/3, 8/2, 8/8"},
    {"data_config_im.init_cal_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to initial calibration samples? (1=yes, 0=no)"},
    {"data_config_im.per_cal_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for periodic calibration samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_im.per_cal_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for periodic calibration samples: 8/4, 8/3, 8/2, 8/8"},
    {"data_config_im.per_cal_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to periodic calibration samples? (1=yes, 0=no)"},
    {"data_config_im.noise_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for noise samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_im.noise_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for noise samples: 8/4, 8/3, 8/2, 8/8"},
    {"data_config_im.noise_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to noise samples? (1=yes, 0=no)"},
    {"data_config_ap.echo_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for echo samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_ap.echo_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for echo samples: 8/4, 8/3, 8/2, 8/8"},
    {"data_config_ap.echo_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to echo samples? (1=yes, 0=no)"},
    {"data_config_ap.init_cal_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for initial calibration samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_ap.init_cal_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for initial calibration samples8/4, 8/3, 8/2, 8/8"},
    {"data_config_ap.init_cal_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to initial calibration samples? (1=yes, 0=no)"},
    {"data_config_ap.per_cal_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for periodic calibration samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_ap.per_cal_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for periodic calibration samples: 8/4, 8/3, 8/2, 8/8"},
    {"data_config_ap.per_cal_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to periodic calibration samples? (1=yes, 0=no)"},
    {"data_config_ap.noise_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for noise samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_ap.noise_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for noise samples: 8/4, 8/3, 8/2, 8/8"},
    {"data_config_ap.noise_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to noise samples? (1=yes, 0=no)"},
    {"data_config_ws.echo_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for echo samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_ws.echo_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for echo samples: 8/4, 8/3, 8/2, 8/8"},
    {"data_config_ws.echo_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to echo samples? (1=yes, 0=no)"},
    {"data_config_ws.init_cal_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for initial calibration samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_ws.init_cal_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for initial calibration samples8/4, 8/3, 8/2, 8/8"},
    {"data_config_ws.init_cal_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to initial calibration samples? (1=yes, 0=no)"},
    {"data_config_ws.per_cal_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for periodic calibration samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_ws.per_cal_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for periodic calibration samples: 8/4, 8/3, 8/2, 8/8"},
    {"data_config_ws.per_cal_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to periodic calibration samples? (1=yes, 0=no)"},
    {"data_config_ws.noise_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for noise samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_ws.noise_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for noise samples: 8/4, 8/3, 8/2, 8/8"},
    {"data_config_ws.noise_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to noise samples? (1=yes, 0=no)"},
    {"data_config_gm.echo_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for echo samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_gm.echo_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for echo samples: 8/4, 8/3, 8/2, 8/8"},
    {"data_config_gm.echo_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to echo samples? (1=yes, 0=no)"},
    {"data_config_gm.init_cal_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for initial calibration samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_gm.init_cal_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for initial calibration samples8/4, 8/3, 8/2, 8/8"},
    {"data_config_gm.init_cal_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to initial calibration samples? (1=yes, 0=no)"},
    {"data_config_gm.per_cal_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for periodic calibration samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_gm.per_cal_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for periodic calibration samples: 8/4, 8/3, 8/2, 8/8"},
    {"data_config_gm.per_cal_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to periodic calibration samples? (1=yes, 0=no)"},
    {"data_config_gm.noise_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for noise samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_gm.noise_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for noise samples: 8/4, 8/3, 8/2, 8/8"},
    {"data_config_gm.noise_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to noise samples? (1=yes, 0=no)"},
    {"data_config_wv.echo_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for echo samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_wv.echo_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for echo samples: 8/4, 8/3, 8/2, 8/8"},
    {"data_config_wv.echo_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to echo samples? (1=yes, 0=no)"},
    {"data_config_wv.init_cal_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for initial calibration samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_wv.init_cal_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for initial calibration samples8/4, 8/3, 8/2, 8/8"},
    {"data_config_wv.init_cal_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to initial calibration samples? (1=yes, 0=no)"},
    {"data_config_wv.per_cal_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for periodic calibration samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_wv.per_cal_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for periodic calibration samples: 8/4, 8/3, 8/2, 8/8"},
    {"data_config_wv.per_cal_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to periodic calibration samples? (1=yes, 0=no)"},
    {"data_config_wv.noise_comp_method", e_tid_string, "ascii", 4, "1", "Compression Method used for noise samples FBAQ, S+M&Oslash;, NONE"},
    {"data_config_wv.noise_comp_ratio", e_tid_string, "ascii", 3, "1", "Compression Ratio for noise samples: 8/4, 8/3, 8/2, 8/8"},
    {"data_config_wv.noise_resamp_flag", e_tid_uchar, "flag", 1, "1", "Resampling applied to noise samples? (1=yes, 0=no)"},
    {"swath_config_im.num_samp_windows_echo", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for echo samples, initial calibration samples (from beam 1 (IS1 or SS1) to beam 7 (IS7))"},
    {"swath_config_im.num_samp_windows_init_cal", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for initial calibration samples (from beam 1 to beam 7)"},
    {"swath_config_im.num_samp_windows_per_cal", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for periodic calibration samples (from beam 1 to beam 7)"},
    {"swath_config_im.num_samp_windows_noise", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for noise samples (from beam 1 to beam 7)"},
    {"swath_config_im.resample_factor", e_tid_float, NULL, 4, "7", "Resampling factor (beam 1 to beam 7)"},
    {"swath_config_ap.num_samp_windows_echo", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for echo samples, initial calibration samples (from beam 1 (IS1 or SS1) to beam 7 (IS7))"},
    {"swath_config_ap.num_samp_windows_init_cal", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for initial calibration samples (from beam 1 to beam 7)"},
    {"swath_config_ap.num_samp_windows_per_cal", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for periodic calibration samples (from beam 1 to beam 7)"},
    {"swath_config_ap.num_samp_windows_noise", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for noise samples (from beam 1 to beam 7)"},
    {"swath_config_ap.resample_factor", e_tid_float, NULL, 4, "7", "Resampling factor (beam 1 to beam 7)"},
    {"swath_config_ws.num_samp_windows_echo", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for echo samples, initial calibration samples (from beam 1 (IS1 or SS1) to beam 7 (IS7))"},
    {"swath_config_ws.num_samp_windows_init_cal", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for initial calibration samples (from beam 1 to beam 7)"},
    {"swath_config_ws.num_samp_windows_per_cal", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for periodic calibration samples (from beam 1 to beam 7)"},
    {"swath_config_ws.num_samp_windows_noise", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for noise samples (from beam 1 to beam 7)"},
    {"swath_config_ws.resample_factor", e_tid_float, NULL, 4, "7", "Resampling factor (beam 1 to beam 7)"},
    {"swath_config_gm.num_samp_windows_echo", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for echo samples, initial calibration samples (from beam 1 (IS1 or SS1) to beam 7 (IS7))"},
    {"swath_config_gm.num_samp_windows_init_cal", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for initial calibration samples (from beam 1 to beam 7)"},
    {"swath_config_gm.num_samp_windows_per_cal", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for periodic calibration samples (from beam 1 to beam 7)"},
    {"swath_config_gm.num_samp_windows_noise", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for noise samples (from beam 1 to beam 7)"},
    {"swath_config_gm.resample_factor", e_tid_float, NULL, 4, "7", "Resampling factor (beam 1 to beam 7)"},
    {"swath_config_wv.num_samp_windows_echo", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for echo samples, initial calibration samples (from beam 1 (IS1 or SS1) to beam 7 (IS7))"},
    {"swath_config_wv.num_samp_windows_init_cal", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for initial calibration samples (from beam 1 to beam 7)"},
    {"swath_config_wv.num_samp_windows_per_cal", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for periodic calibration samples (from beam 1 to beam 7)"},
    {"swath_config_wv.num_samp_windows_noise", e_tid_ushort, NULL, 2, "7", "Number of sample windows per source packet for noise samples (from beam 1 to beam 7)"},
    {"swath_config_wv.resample_factor", e_tid_float, NULL, 4, "7", "Resampling factor (beam 1 to beam 7)"},
    {"per_cal_widows_ec", e_tid_ushort, NULL, 2, "1", "Number of periodic calibration sample windows per source packet for External Characterization mode"},
    {"per_cal_windows_ms", e_tid_ushort, NULL, 2, "1", "Number of periodic calibration sample windows per source packet for Module Stepping mode"},
    {"swath_id_im.swath_num", e_tid_ushort, NULL, 2, "7", "Swath numbers (IS1 to IS7 or SS1 to SS5)"},
    {"swath_id_im.beam_set_num", e_tid_ushort, NULL, 2, "7", "Antenna Beam Set numbers (IS1 to IS7 or SS1 to SS5)"},
    {"swath_id_ap.swath_num", e_tid_ushort, NULL, 2, "7", "Swath numbers (IS1 to IS7 or SS1 to SS5)"},
    {"swath_id_ap.beam_set_num", e_tid_ushort, NULL, 2, "7", "Antenna Beam Set numbers (IS1 to IS7 or SS1 to SS5)"},
    {"swath_id_ws.swath_num", e_tid_ushort, NULL, 2, "7", "Swath numbers (IS1 to IS7 or SS1 to SS5)"},
    {"swath_id_ws.beam_set_num", e_tid_ushort, NULL, 2, "7", "Antenna Beam Set numbers (IS1 to IS7 or SS1 to SS5)"},
    {"swath_id_gm.swath_num", e_tid_ushort, NULL, 2, "7", "Swath numbers (IS1 to IS7 or SS1 to SS5)"},
    {"swath_id_gm.beam_set_num", e_tid_ushort, NULL, 2, "7", "Antenna Beam Set numbers (IS1 to IS7 or SS1 to SS5)"},
    {"swath_id_wv.swath_num", e_tid_ushort, NULL, 2, "7", "Swath numbers (IS1 to IS7 or SS1 to SS5)"},
    {"swath_id_wv.beam_set_num", e_tid_ushort, NULL, 2, "7", "Antenna Beam Set numbers (IS1 to IS7 or SS1 to SS5)"},
    {"init_cal_beam_set_wv", e_tid_ushort, NULL, 2, "1", "Beam Set number for Wave Mode initial calibration"},
    {"beam_set_ec", e_tid_ushort, NULL, 2, "1", "Beam Set number for External Characterization Mode"},
    {"beam_set_ms", e_tid_ushort, NULL, 2, "1", "Beam Set number for Module Stepping Mode"},
    {"cal_seq", e_tid_ushort, NULL, 2, "32", "Calibration Row Sequence Table(32 numbers give the Row number sequence used during initial and periodic calibration)"},
    {"timeline_im.swath_nums", e_tid_ushort, NULL, 2, "7", "Swath numbers (IS1 to IS7 or SS1 to SS5)"},
    {"timeline_im.m_values", e_tid_ushort, NULL, 2, "7", "M values (IS1 to IS7 or SS1 to SS5) M is the number of echo sampling PTIs in a cycle or subcycle"},
    {"timeline_im.r_values", e_tid_ushort, NULL, 2, "7", "R values (IS1 to IS7 or SS1 to SS5) R is the rank (i.e., the number of PRI between transmitted pulse and return echo)"},
    {"timeline_im.g_values", e_tid_ushort, NULL, 2, "7", "G values (IS1 to IS7 or SS1 to SS5) G is the number of cycles"},
    {"timeline_ap.swath_nums", e_tid_ushort, NULL, 2, "7", "Swath numbers (IS1 to IS7 or SS1 to SS5)"},
    {"timeline_ap.m_values", e_tid_ushort, NULL, 2, "7", "M values (IS1 to IS7 or SS1 to SS5) M is the number of echo sampling PTIs in a cycle or subcycle"},
    {"timeline_ap.r_values", e_tid_ushort, NULL, 2, "7", "R values (IS1 to IS7 or SS1 to SS5) R is the rank (i.e., the number of PRI between transmitted pulse and return echo)"},
    {"timeline_ap.g_values", e_tid_ushort, NULL, 2, "7", "G values (IS1 to IS7 or SS1 to SS5) G is the number of cycles"},
    {"timeline_ws.swath_nums", e_tid_ushort, NULL, 2, "7", "Swath numbers (IS1 to IS7 or SS1 to SS5)"},
    {"timeline_ws.m_values", e_tid_ushort, NULL, 2, "7", "M values (IS1 to IS7 or SS1 to SS5) M is the number of echo sampling PTIs in a cycle or subcycle"},
    {"timeline_ws.r_values", e_tid_ushort, NULL, 2, "7", "R values (IS1 to IS7 or SS1 to SS5) R is the rank (i.e., the number of PRI between transmitted pulse and return echo)"},
    {"timeline_ws.g_values", e_tid_ushort, NULL, 2, "7", "G values (IS1 to IS7 or SS1 to SS5) G is the number of cycles"},
    {"timeline_gm.swath_nums", e_tid_ushort, NULL, 2, "7", "Swath numbers (IS1 to IS7 or SS1 to SS5)"},
    {"timeline_gm.m_values", e_tid_ushort, NULL, 2, "7", "M values (IS1 to IS7 or SS1 to SS5) M is the number of echo sampling PTIs in a cycle or subcycle"},
    {"timeline_gm.r_values", e_tid_ushort, NULL, 2, "7", "R values (IS1 to IS7 or SS1 to SS5) R is the rank (i.e., the number of PRI between transmitted pulse and return echo)"},
    {"timeline_gm.g_values", e_tid_ushort, NULL, 2, "7", "G values (IS1 to IS7 or SS1 to SS5) G is the number of cycles"},
    {"timeline_wv.swath_nums", e_tid_ushort, NULL, 2, "7", "Swath numbers (IS1 to IS7 or SS1 to SS5)"},
    {"timeline_wv.m_values", e_tid_ushort, NULL, 2, "7", "M values (IS1 to IS7 or SS1 to SS5) M is the number of echo sampling PTIs in a cycle or subcycle"},
    {"timeline_wv.r_values", e_tid_ushort, NULL, 2, "7", "R values (IS1 to IS7 or SS1 to SS5) R is the rank (i.e., the number of PRI between transmitted pulse and return echo)"},
    {"timeline_wv.g_values", e_tid_ushort, NULL, 2, "7", "G values (IS1 to IS7 or SS1 to SS5) G is the number of cycles"},
    {"m_ec", e_tid_ushort, NULL, 2, "1", "M value (see field above) for External Characterization"},
    {"spare_2", e_tid_spare, NULL, 64, "1", "Spare"},
    {"ref_elev_angle_is1", e_tid_float, "deg.", 4, "1", "Reference elevation angle for IS1"},
    {"ref_elev_angle_is2", e_tid_float, "deg.", 4, "1", "Reference elevation angle for IS2"},
    {"ref_elev_angle_is3_ss2", e_tid_float, "deg.", 4, "1", "Reference elevation angle for IS3 / SS2"},
    {"ref_elev_angle_is4_ss3", e_tid_float, "deg.", 4, "1", "Reference elevation angle for IS4 / SS3"},
    {"ref_elev_angle_is5_ss4", e_tid_float, "deg.", 4, "1", "Reference elevation angle for IS5 / SS4"},
    {"ref_elev_angle_is6_ss5", e_tid_float, "deg.", 4, "1", "Reference elevation angle for IS6 / SS5"},
    {"ref_elev_angle_is7", e_tid_float, "deg.", 4, "1", "Reference elevation angle for IS7"},
    {"ref_elev_angle_ss1", e_tid_float, "deg.", 4, "1", "Reference elevation angle for SS1"},
    {"spare_3", e_tid_spare, NULL, 64, "1", "Spare"},
    {"cal_loop_ref_is1", e_tid_float, NULL, 4, "128", "Calibration Loop Characterization Factors at the Swath Reference Elevation Angle for IS1(complex factor characterizing the path through the calibration loop and from the calibration coupler to the antenna face) 32 complex values for H polarization, follow"},
    {"cal_loop_ref_is2", e_tid_float, NULL, 4, "128", "Calibration Loop Characterization Factors at the Swath Reference Elevation Angle for IS2(complex factor characterizing the path through the calibration loop and from the calibration coupler to the antenna face) 32 complex values for H polarization, follow"},
    {"cal_loop_ref_is3_ss2", e_tid_float, NULL, 4, "128", "Calibration Loop Characterization Factors at the Swath Reference Elevation Angle for IS3/SS2(complex factor characterizing the path through the calibration loop and from the calibration coupler to the antenna face) 32 complex values for H polarization, fo"},
    {"cal_loop_ref_is4_ss3", e_tid_float, NULL, 4, "128", "Calibration Loop Characterization Factors at the Swath Reference Elevation Angle for IS4/SS3(complex factor characterizing the path through the calibration loop and from the calibration coupler to the antenna face) 32 complex values for H polarization, fo"},
    {"cal_loop_ref_is5_ss4", e_tid_float, NULL, 4, "128", "Calibration Loop Characterization Factors at the Swath Reference Elevation Angle for IS5/SS4(complex factor characterizing the path through the calibration loop and from the calibration coupler to the antenna face) 32 complex values for H polarization, fo"},
    {"cal_loop_ref_is6_ss5", e_tid_float, NULL, 4, "128", "Calibration Loop Characterization Factors at the Swath Reference Elevation Angle for IS6/SS5(complex factor characterizing the path through the calibration loop and from the calibration coupler to the antenna face) 32 complex values for H polarization, fo"},
    {"cal_loop_ref_is7", e_tid_float, NULL, 4, "128", "Calibration Loop Characterization Factors at the Swath Reference Elevation Angle for IS7(complex factor characterizing the path through the calibration loop and from the calibration coupler to the antenna face) 32 complex values for H polarization, follow"},
    {"cal_loop_ref_iss1", e_tid_float, NULL, 4, "128", "Calibration Loop Characterization Factors at the Swath Reference Elevation Angle for SS1(complex factor characterizing the path through the calibration loop and from the calibration coupler to the antenna face) 32 complex values for H polarization, follow"},
    {"cal_loop_cen_is1", e_tid_float, NULL, 4, "128", "Calibration Loop Characterization Factors at the Center of Swath Elevation Angle for IS1(complex factor characterizing the path through the calibration loop and from the calibration coupler to the antenna face) 32 complex values for H polarization, follow"},
    {"cal_loop_cen_is2", e_tid_float, NULL, 4, "128", "Calibration Loop Characterization Factors at the Center of Swath Elevation Angle for IS2(complex factor characterizing the path through the calibration loop and from the calibration coupler to the antenna face) 32 complex values for H polarization, follow"},
    {"cal_loop_cen_is3_ss2", e_tid_float, NULL, 4, "128", "Calibration Loop Characterization Factors at the Center of Swath Elevation Angle for IS3/SS2(complex factor characterizing the path through the calibration loop and from the calibration coupler to the antenna face) 32 complex values for H polarization, fo"},
    {"cal_loop_cen_is4_ss3", e_tid_float, NULL, 4, "128", "Calibration Loop Characterization Factors at the Center of Swath Elevation Angle for IS4/SS3(complex factor characterizing the path through the calibration loop and from the calibration coupler to the antenna face) 32 complex values for H polarization, fo"},
    {"cal_loop_cen_is5_ss4", e_tid_float, NULL, 4, "128", "Calibration Loop Characterization Factors at the Center of Swath Elevation Angle for IS5/SS4(complex factor characterizing the path through the calibration loop and from the calibration coupler to the antenna face) 32 complex values for H polarization, fo"},
    {"cal_loop_cen_is6_ss5", e_tid_float, NULL, 4, "128", "Calibration Loop Characterization Factors at the Center of Swath Elevation Angle for IS6/SS5(complex factor characterizing the path through the calibration loop and from the calibration coupler to the antenna face) 32 complex values for H polarization, fo"},
    {"cal_loop_cen_is7", e_tid_float, NULL, 4, "128", "Calibration Loop Characterization Factors at the Center of Swath Elevation Angle for IS7(complex factor characterizing the path through the calibration loop and from the calibration coupler to the antenna face) 32 complex values for H polarization, follow"},
    {"cal_loop_cen_iss1", e_tid_float, NULL, 4, "128", "Calibration Loop Characterization Factors at the Center of Swath Elevation Angle for SS1(complex factor characterizing the path through the calibration loop and from the calibration coupler to the antenna face) 32 complex values for H polarization, follow"},
    {"spare_4", e_tid_spare, NULL, 1024, "1", "Spare"}
};

static const struct RecordDescriptor ASA_XCA_AX_GADS_asar_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Time of creation of this file"},
    {"dsr_length", e_tid_uint, "bytes", 4, "1", "Length of this DSR in bytes"},
    {"ext_cal_im_hh", e_tid_float, NULL, 4, "7", "External Calibration scaling factors for IM mode, HH polar. (7 values from swath IS1 to IS7)"},
    {"ext_cal_im_vv", e_tid_float, NULL, 4, "7", "External Calibration scaling factors for IM mode, VV polar. (7 values from swath IS1 to IS7)"},
    {"ext_cal_ap_hh", e_tid_float, NULL, 4, "7", "External Calibration scaling factors for AP mode, HH polar. (7 values from swath IS1 to IS7)"},
    {"ext_cal_ap_vv", e_tid_float, NULL, 4, "7", "External Calibration scaling factors for AP mode, VV polar. (7 values from swath IS1 to IS7)"},
    {"ext_cal_ap_hv", e_tid_float, NULL, 4, "7", "External Calibration scaling factors for AP mode, HV polar. (7 values from swath IS1 to IS7)"},
    {"ext_cal_ap_vh", e_tid_float, NULL, 4, "7", "External Calibration scaling factors for AP mode, VH polar. (7 values from swath IS1 to IS7)"},
    {"ext_cal_wv_hh", e_tid_float, NULL, 4, "7", "External Calibration scaling factors for WV mode, HH polar. (7 values from swath IS1 to IS7)"},
    {"ext_cal_wv_vv", e_tid_float, NULL, 4, "7", "External Calibration scaling factors for WV mode, VV polar. (7 values from swath IS1 to IS7)"},
    {"ext_cal_ws_hh", e_tid_float, NULL, 4, "1", "External Calibration scaling factors for WS mode, HH polar."},
    {"ext_cal_ws_vv", e_tid_float, NULL, 4, "1", "External Calibration scaling factors for WS mode, VV polar."},
    {"ext_cal_gm_hh", e_tid_float, NULL, 4, "1", "External Calibration scaling factors for GM mode, HH polar."},
    {"ext_cal_gm_vv", e_tid_float, NULL, 4, "1", "External Calibration scaling factors for GM mode, VV polar."},
    {"elev_ang_is1", e_tid_float, "deg.", 4, "1", "Center of swath elevation angle for IS1"},
    {"elev_ang_is2", e_tid_float, "deg.", 4, "1", "Center of swath elevation angle for IS2"},
    {"elev_ang_is3_ss2", e_tid_float, "deg.", 4, "1", "Center of swath elevation angle for IS3 / SS2"},
    {"elev_ang_is4_ss3", e_tid_float, "deg.", 4, "1", "Center of swath elevation angle for IS4 / SS3"},
    {"elev_ang_is5_ss4", e_tid_float, "deg.", 4, "1", "Center of swath elevation angle for IS5 / SS4"},
    {"elev_ang_is6_ss5", e_tid_float, "deg.", 4, "1", "Center of swath elevation angle for IS6 / SS5"},
    {"elev_ang_is7", e_tid_float, "deg.", 4, "1", "Center of swath elevation angle for IS7"},
    {"elev_ang_ss1", e_tid_float, "deg.", 4, "1", "Center of swath elevation angle for SS1"},
    {"pattern_is1", e_tid_float, "dB", 4, "201", "Two-way Antenna Elevation Pattern Gain Table for IS1 (pattern is defined from Center of swath elevation angle - 5 deg. to Center of Swath elevation angle + 5 deg. in 0.05 degree steps.)"},
    {"pattern_is2", e_tid_float, "dB", 4, "201", "Two-way Antenna Elevation Pattern Gain Table for IS2 (pattern is defined from Center of swath elevation angle - 5 deg. to Center of Swath elevation angle + 5 deg. in 0.05 degree steps.)"},
    {"pattern_is3_ss2", e_tid_float, "dB", 4, "201", "Two-way Antenna Elevation Pattern Gain Table for IS3 / SS2 (pattern is defined from Center of swath elevation angle - 5 deg. to Center of Swath elevation angle + 5 deg. in 0.05 degree steps.)"},
    {"pattern_is4_ss3", e_tid_float, "dB", 4, "201", "Two-way Antenna Elevation Pattern Gain Table for IS4 / SS3 (pattern is defined from Center of swath elevation angle - 5 deg. to Center of Swath elevation angle + 5 deg. in 0.05 degree steps.)"},
    {"pattern_is5_ss4", e_tid_float, "dB", 4, "201", "Two-way Antenna Elevation Pattern Gain Table for IS5 / SS4 (pattern is defined from Center of swath elevation angle - 5 deg. to Center of Swath elevation angle + 5 deg. in 0.05 degree steps.)"},
    {"pattern_is6_ss5", e_tid_float, "dB", 4, "201", "Two-way Antenna Elevation Pattern Gain Table for IS6 / SS5 (pattern is defined from Center of swath elevation angle - 5 deg. to Center of Swath elevation angle + 5 deg. in 0.05 degree steps.)"},
    {"pattern_is7", e_tid_float, "dB", 4, "201", "Two-way Antenna Elevation Pattern Gain Table for IS7 (pattern is defined from Center of swath elevation angle - 5 deg. to Center of Swath elevation angle + 5 deg. in 0.05 degree steps.)"},
    {"pattern_ss1", e_tid_float, "dB", 4, "201", "Two-way Antenna Elevation Pattern Gain Table for SS1 (pattern is defined from Center of swath elevation angle - 5 deg. to Center of Swath elevation angle + 5 deg. in 0.05 degree steps. )"},
    {"spare_1", e_tid_spare, NULL, 32, "1", "Spare"}
};

static const struct RecordDescriptor ASA_XCH_AX_GADS_asar_rec_data[] = {
    {"dsr_time", e_tid_time, "MJD", 12, "1", "Time of characterization"},
    {"dsr_length", e_tid_uint, "bytes", 4, "1", "Length of this DSR in bytes"},
    {"complex_loop_factors", e_tid_float, NULL, 4, "128", "Complex Loop Paths Characterization Factors relative to free space (from External Characterization data). 64 complex (I,Q) values of gnp where n is the index of the row (1 to 32) and p is the index of the polarization (H=1, V=2) (TBC) Arranged H: 1 to 32, then V: 1-32)"},
    {"pointing_error", e_tid_float, NULL, 4, "1", "Antenna pointing error DP1 (from External Characterization data)"},
    {"spare_1", e_tid_spare, NULL, 64, "1", "Spare"}
};

static const struct DatasetDescriptor ASA_APG_1P_dataset_data[] = {
    {"MDS1_SQ_ADS", "MDS1 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"MDS2_SQ_ADS", "MDS2 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"MAIN_PROCESSING_PARAMS_ADS", "MAIN PROCESSING PARAMS ADS", ASAR_Main_ADSR_asar_rec_data, "Main Processing parameters"},
    {"DOP_CENTROID_COEFFS_ADS", "DOP CENTROID COEFFS ADS", ASAR_Dop_Cen_ADSR_asar_rec_data, "Doppler Centroid Parameters"},
    {"SR_GR_ADS", "SR GR ADS", ASAR_SRGR_ADSR_asar_rec_data, "Slant Range to Ground Range conversion parameters"},
    {"CHIRP_PARAMS_ADS", "CHIRP PARAMS ADS", ASAR_Chirp_ADSR_asar_rec_data, "chirp parameters"},
    {"ANTENNA_ELEV_PATTERN_ADS", "ANTENNA ELEV PATTERN ADS", ASAR_Antenna_ADSR_asar_rec_data, "Antenna Elevation patterns(s)"},
    {"GEOLOCATION_GRID_ADS", "GEOLOCATION GRID ADS", ASAR_Geo_Grid_ADSR_asar_rec_data, "Geolocation Grid ADSRs"},
    {"MAP_PROJECTION_GADS", "MAP PROJECTION GADS", ASAR_Map_GADS_asar_rec_data, "Map Projection parameters"},
    {"MDS1", "MDS1", ASAR_Image_MDSR_Gen_asar_rec_data, "Measurement Data Set 1"},
    {"MDS2", "MDS2", ASAR_Image_MDSR_Gen_asar_rec_data, "Measurement Data Set 2"}
};

static const struct DatasetDescriptor ASA_APM_1P_dataset_data[] = {
    {"MDS1_SQ_ADS", "MDS1 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"MDS2_SQ_ADS", "MDS2 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"MAIN_PROCESSING_PARAMS_ADS", "MAIN PROCESSING PARAMS ADS", ASAR_Main_ADSR_asar_rec_data, "Main Processing parameters"},
    {"DOP_CENTROID_COEFFS_ADS", "DOP CENTROID COEFFS ADS", ASAR_Dop_Cen_ADSR_asar_rec_data, "Doppler Centroid Parameters"},
    {"SR_GR_ADS", "SR GR ADS", ASAR_SRGR_ADSR_asar_rec_data, "Slant Range to Ground Range conversion parameters"},
    {"CHIRP_PARAMS_ADS", "CHIRP PARAMS ADS", ASAR_Chirp_ADSR_asar_rec_data, "chirp parameters"},
    {"ANTENNA_ELEV_PATTERN_ADS", "ANTENNA ELEV PATTERN ADS", ASAR_Antenna_ADSR_asar_rec_data, "Antenna Elevation patterns(s)"},
    {"GEOLOCATION_GRID_ADS", "GEOLOCATION GRID ADS", ASAR_Geo_Grid_ADSR_asar_rec_data, "Geolocation Grid ADSRs"},
    {"MDS1", "MDS1", ASAR_Image_MDSR_Gen_asar_rec_data, "Measurement Data Set 1"},
    {"MDS2", "MDS2", ASAR_Image_MDSR_Gen_asar_rec_data, "Measurement Data Set 2 (if requested)"}
};

static const struct DatasetDescriptor ASA_APP_1P_dataset_data[] = {
    {"MDS1_SQ_ADS", "MDS1 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"MDS2_SQ_ADS", "MDS2 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"MAIN_PROCESSING_PARAMS_ADS", "MAIN PROCESSING PARAMS ADS", ASAR_Main_ADSR_asar_rec_data, "Main Processing parameters"},
    {"DOP_CENTROID_COEFFS_ADS", "DOP CENTROID COEFFS ADS", ASAR_Dop_Cen_ADSR_asar_rec_data, "Doppler Centroid Parameters"},
    {"SR_GR_ADS", "SR GR ADS", ASAR_SRGR_ADSR_asar_rec_data, "Slant Range to Ground Range conversion parameters"},
    {"CHIRP_PARAMS_ADS", "CHIRP PARAMS ADS", ASAR_Chirp_ADSR_asar_rec_data, "chirp parameters"},
    {"ANTENNA_ELEV_PATTERN_ADS", "ANTENNA ELEV PATTERN ADS", ASAR_Antenna_ADSR_asar_rec_data, "Antenna Elevation patterns(s)"},
    {"GEOLOCATION_GRID_ADS", "GEOLOCATION GRID ADS", ASAR_Geo_Grid_ADSR_asar_rec_data, "Geolocation Grid ADSRs"},
    {"MDS1", "MDS1", ASAR_Image_MDSR_Gen_asar_rec_data, "Measurement Data Set 1"},
    {"MDS2", "MDS2", ASAR_Image_MDSR_Gen_asar_rec_data, "Measurement Data Set 2"}
};

static const struct DatasetDescriptor ASA_APS_1P_dataset_data[] = {
    {"MDS1_SQ_ADS", "MDS1 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"MDS2_SQ_ADS", "MDS2 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"MAIN_PROCESSING_PARAMS_ADS", "MAIN PROCESSING PARAMS ADS", ASAR_Main_ADSR_asar_rec_data, "Main Processing parameters"},
    {"DOP_CENTROID_COEFFS_ADS", "DOP CENTROID COEFFS ADS", ASAR_Dop_Cen_ADSR_asar_rec_data, "Doppler Centroid Parameters"},
    {"CHIRP_PARAMS_ADS", "CHIRP PARAMS ADS", ASAR_Chirp_ADSR_asar_rec_data, "chirp parameters"},
    {"GEOLOCATION_GRID_ADS", "GEOLOCATION GRID ADS", ASAR_Geo_Grid_ADSR_asar_rec_data, "Geolocation Grid ADSRs"},
    {"MDS1", "MDS1", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set 1"},
    {"MDS2", "MDS2", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set 2"}
};

static const struct DatasetDescriptor ASA_AP__BP_dataset_data[] = {
    {"MDS1_SQ_ADS", "MDS1 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"MDS2_SQ_ADS", "MDS2 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"GEOLOCATION_GRID_ADS", "GEOLOCATION GRID ADS", ASAR_Geo_Grid_ADSR_asar_rec_data, "Geolocation Grid ADSRs"},
    {"MDS1", "MDS1", ASAR_Image_MDSR_BP_asar_rec_data, "Measurement Data Set 1"},
    {"MDS2", "MDS2", ASAR_Image_MDSR_BP_asar_rec_data, "Measurement Data Set 2"}
};

static const struct DatasetDescriptor ASA_GM1_1P_dataset_data[] = {
    {"MDS1_SQ_ADS", "MDS1 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"MAIN_PROCESSING_PARAMS_ADS", "MAIN PROCESSING PARAMS ADS", ASAR_Main_ADSR_asar_rec_data, "Main Processing parameters"},
    {"DOP_CENTROID_COEFFS_ADS", "DOP CENTROID COEFFS ADS", ASAR_Dop_Cen_ADSR_asar_rec_data, "Doppler Centroid Parameters"},
    {"SR_GR_ADS", "SR GR ADS", ASAR_SRGR_ADSR_asar_rec_data, "Slant Range to Ground Range conversion parameters"},
    {"CHIRP_PARAMS_ADS", "CHIRP PARAMS ADS", ASAR_Chirp_ADSR_asar_rec_data, "chirp parameters"},
    {"ANTENNA_ELEV_PATTERN_ADS", "ANTENNA ELEV PATTERN ADS", ASAR_Antenna_ADSR_asar_rec_data, "Antenna Elevation patterns(s)"},
    {"GEOLOCATION_GRID_ADS", "GEOLOCATION GRID ADS", ASAR_Geo_Grid_ADSR_asar_rec_data, "Geolocation Grid ADSRs"},
    {"MDS1", "MDS1", ASAR_Image_MDSR_Gen_asar_rec_data, "Measurement Data Set 1"}
};

static const struct DatasetDescriptor ASA_IMG_1P_dataset_data[] = {
    {"MDS1_SQ_ADS", "MDS1 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"MAIN_PROCESSING_PARAMS_ADS", "MAIN PROCESSING PARAMS ADS", ASAR_Main_ADSR_asar_rec_data, "Main Processing parameters"},
    {"DOP_CENTROID_COEFFS_ADS", "DOP CENTROID COEFFS ADS", ASAR_Dop_Cen_ADSR_asar_rec_data, "Doppler Centroid Parameters"},
    {"SR_GR_ADS", "SR GR ADS", ASAR_SRGR_ADSR_asar_rec_data, "Slant Range to Ground Range conversion parameters"},
    {"CHIRP_PARAMS_ADS", "CHIRP PARAMS ADS", ASAR_Chirp_ADSR_asar_rec_data, "chirp parameters"},
    {"ANTENNA_ELEV_PATTERN_ADS", "ANTENNA ELEV PATTERN ADS", ASAR_Antenna_ADSR_asar_rec_data, "Antenna Elevation patterns(s)"},
    {"GEOLOCATION_GRID_ADS", "GEOLOCATION GRID ADS", ASAR_Geo_Grid_ADSR_asar_rec_data, "Geolocation Grid ADSRs"},
    {"MAP_PROJECTION_GADS", "MAP PROJECTION GADS", ASAR_Map_GADS_asar_rec_data, "Map Projection parameters"},
    {"MDS1", "MDS1", ASAR_Image_MDSR_Gen_asar_rec_data, "Measurement Data Set 1"}
};

static const struct DatasetDescriptor ASA_IMM_1P_dataset_data[] = {
    {"MDS1_SQ_ADS", "MDS1 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"MAIN_PROCESSING_PARAMS_ADS", "MAIN PROCESSING PARAMS ADS", ASAR_Main_ADSR_asar_rec_data, "Main Processing parameters"},
    {"DOP_CENTROID_COEFFS_ADS", "DOP CENTROID COEFFS ADS", ASAR_Dop_Cen_ADSR_asar_rec_data, "Doppler Centroid Parameters"},
    {"SR_GR_ADS", "SR GR ADS", ASAR_SRGR_ADSR_asar_rec_data, "Slant Range to Ground Range conversion parameters"},
    {"CHIRP_PARAMS_ADS", "CHIRP PARAMS ADS", ASAR_Chirp_ADSR_asar_rec_data, "chirp parameters"},
    {"ANTENNA_ELEV_PATTERN_ADS", "ANTENNA ELEV PATTERN ADS", ASAR_Antenna_ADSR_asar_rec_data, "Antenna Elevation patterns(s)"},
    {"GEOLOCATION_GRID_ADS", "GEOLOCATION GRID ADS", ASAR_Geo_Grid_ADSR_asar_rec_data, "Geolocation Grid ADSRs"},
    {"MDS1", "MDS1", ASAR_Image_MDSR_Gen_asar_rec_data, "Measurement Data Set 1"}
};

static const struct DatasetDescriptor ASA_IMP_1P_dataset_data[] = {
    {"MDS1_SQ_ADS", "MDS1 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"MAIN_PROCESSING_PARAMS_ADS", "MAIN PROCESSING PARAMS ADS", ASAR_Main_ADSR_asar_rec_data, "Main Processing parameters"},
    {"DOP_CENTROID_COEFFS_ADS", "DOP CENTROID COEFFS ADS", ASAR_Dop_Cen_ADSR_asar_rec_data, "Doppler Centroid Parameters"},
    {"SR_GR_ADS", "SR GR ADS", ASAR_SRGR_ADSR_asar_rec_data, "Slant Range to Ground Range conversion parameters"},
    {"CHIRP_PARAMS_ADS", "CHIRP PARAMS ADS", ASAR_Chirp_ADSR_asar_rec_data, "chirp parameters"},
    {"ANTENNA_ELEV_PATTERN_ADS", "ANTENNA ELEV PATTERN ADS", ASAR_Antenna_ADSR_asar_rec_data, "Antenna Elevation patterns(s)"},
    {"GEOLOCATION_GRID_ADS", "GEOLOCATION GRID ADS", ASAR_Geo_Grid_ADSR_asar_rec_data, "Geolocation Grid ADSRs"},
    {"MDS1", "MDS1", ASAR_Image_MDSR_Gen_asar_rec_data, "Measurement Data Set 1"}
};

static const struct DatasetDescriptor ASA_IMS_1P_dataset_data[] = {
    {"MDS1_SQ_ADS", "MDS1 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"MAIN_PROCESSING_PARAMS_ADS", "MAIN PROCESSING PARAMS ADS", ASAR_Main_ADSR_asar_rec_data, "Main Processing parameters"},
    {"DOP_CENTROID_COEFFS_ADS", "DOP CENTROID COEFFS ADS", ASAR_Dop_Cen_ADSR_asar_rec_data, "Doppler Centroid Parameters"},
    {"CHIRP_PARAMS_ADS", "CHIRP PARAMS ADS", ASAR_Chirp_ADSR_asar_rec_data, "chirp parameters"},
    {"GEOLOCATION_GRID_ADS", "GEOLOCATION GRID ADS", ASAR_Geo_Grid_ADSR_asar_rec_data, "Geolocation Grid ADSRs"},
    {"MDS1", "MDS1", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set 1"}
};

static const struct DatasetDescriptor ASA_IM__BP_dataset_data[] = {
    {"MDS1_SQ_ADS", "MDS1 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"GEOLOCATION_GRID_ADS", "GEOLOCATION GRID ADS", ASAR_Geo_Grid_ADSR_asar_rec_data, "Geolocation Grid ADSRs"},
    {"MDS1", "MDS1", ASAR_Image_MDSR_BP_asar_rec_data, "Measurement Data Set 1"}
};

static const struct DatasetDescriptor ASA_WSM_1P_dataset_data[] = {
    {"MDS1_SQ_ADS", "MDS1 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"MAIN_PROCESSING_PARAMS_ADS", "MAIN PROCESSING PARAMS ADS", ASAR_Main_ADSR_asar_rec_data, "Main Processing parameters"},
    {"DOP_CENTROID_COEFFS_ADS", "DOP CENTROID COEFFS ADS", ASAR_Dop_Cen_ADSR_asar_rec_data, "Doppler Centroid Parameters"},
    {"SR_GR_ADS", "SR GR ADS", ASAR_SRGR_ADSR_asar_rec_data, "Slant Range to Ground Range conversion parameters"},
    {"CHIRP_PARAMS_ADS", "CHIRP PARAMS ADS", ASAR_Chirp_ADSR_asar_rec_data, "chirp parameters"},
    {"ANTENNA_ELEV_PATTERN_ADS", "ANTENNA ELEV PATTERN ADS", ASAR_Antenna_ADSR_asar_rec_data, "Antenna Elevation patterns(s)"},
    {"GEOLOCATION_GRID_ADS", "GEOLOCATION GRID ADS", ASAR_Geo_Grid_ADSR_asar_rec_data, "Geolocation Grid ADSRs"},
    {"MDS1", "MDS1", ASAR_Image_MDSR_Gen_asar_rec_data, "Measurement Data Set 1"}
};

static const struct DatasetDescriptor ASA_WS__BP_dataset_data[] = {
    {"MDS1_SQ_ADS", "MDS1 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"MDS2_SQ_ADS", "MDS2 SQ ADS", ASAR_SQ1_Image_ADSR_asar_rec_data, "SQ ADSRs"},
    {"GEOLOCATION_GRID_ADS", "GEOLOCATION GRID ADS", ASAR_Geo_Grid_ADSR_asar_rec_data, "Geolocation Grid ADSRs"},
    {"MDS1", "MDS1", ASAR_Image_MDSR_BP_asar_rec_data, "Measurement Data Set 1"},
    {"MDS2", "MDS2", ASAR_Image_MDSR_BP_asar_rec_data, "Measurement Data Set 2"}
};

static const struct DatasetDescriptor ASA_WVI_1P_dataset_data[] = {
    {"SQ_ADS", "SQ ADS", ASAR_Wave_SQ_ADSR_asar_rec_data, "SQ ADSRs"},
    {"GEOLOCATION_ADS", "GEOLOCATION ADS", ASAR_Wave_Geolocation_ADSR_asar_rec_data, "Wave Mode Geolocation ADS"},
    {"PROCESSING_PARAMS_ADS", "PROCESSING PARAMS ADS", ASAR_Wave_Param_ADSR_asar_rec_data, "Wave Mode processing parameters"},
    {"CROSS_SPECTRA_MDS", "CROSS SPECTRA MDS", ASAR_Spectra_MDSR_asar_rec_data, "Measurement Data Set containing spectra. 1 MDSR per spectra."},
    {"SLC_IMAGETTE_MDS", "SLC IMAGETTE MDS", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_001", "SLC IMAGETTE MDS 001", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_002", "SLC IMAGETTE MDS 002", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_003", "SLC IMAGETTE MDS 003", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_004", "SLC IMAGETTE MDS 004", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_005", "SLC IMAGETTE MDS 005", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_006", "SLC IMAGETTE MDS 006", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_007", "SLC IMAGETTE MDS 007", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_008", "SLC IMAGETTE MDS 008", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_009", "SLC IMAGETTE MDS 009", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_010", "SLC IMAGETTE MDS 010", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_011", "SLC IMAGETTE MDS 011", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_012", "SLC IMAGETTE MDS 012", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_013", "SLC IMAGETTE MDS 013", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_014", "SLC IMAGETTE MDS 014", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_015", "SLC IMAGETTE MDS 015", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_016", "SLC IMAGETTE MDS 016", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_017", "SLC IMAGETTE MDS 017", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_018", "SLC IMAGETTE MDS 018", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_019", "SLC IMAGETTE MDS 019", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_020", "SLC IMAGETTE MDS 020", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_021", "SLC IMAGETTE MDS 021", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_022", "SLC IMAGETTE MDS 022", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_023", "SLC IMAGETTE MDS 023", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_024", "SLC IMAGETTE MDS 024", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_025", "SLC IMAGETTE MDS 025", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_026", "SLC IMAGETTE MDS 026", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_027", "SLC IMAGETTE MDS 027", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_028", "SLC IMAGETTE MDS 028", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_029", "SLC IMAGETTE MDS 029", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_030", "SLC IMAGETTE MDS 030", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_031", "SLC IMAGETTE MDS 031", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_032", "SLC IMAGETTE MDS 032", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_033", "SLC IMAGETTE MDS 033", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_034", "SLC IMAGETTE MDS 034", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_035", "SLC IMAGETTE MDS 035", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_036", "SLC IMAGETTE MDS 036", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_037", "SLC IMAGETTE MDS 037", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_038", "SLC IMAGETTE MDS 038", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_039", "SLC IMAGETTE MDS 039", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_040", "SLC IMAGETTE MDS 040", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_041", "SLC IMAGETTE MDS 041", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_042", "SLC IMAGETTE MDS 042", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_043", "SLC IMAGETTE MDS 043", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_044", "SLC IMAGETTE MDS 044", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_045", "SLC IMAGETTE MDS 045", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_046", "SLC IMAGETTE MDS 046", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_047", "SLC IMAGETTE MDS 047", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_048", "SLC IMAGETTE MDS 048", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_049", "SLC IMAGETTE MDS 049", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_050", "SLC IMAGETTE MDS 050", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_051", "SLC IMAGETTE MDS 051", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_052", "SLC IMAGETTE MDS 052", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_053", "SLC IMAGETTE MDS 053", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_054", "SLC IMAGETTE MDS 054", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_055", "SLC IMAGETTE MDS 055", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_056", "SLC IMAGETTE MDS 056", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_057", "SLC IMAGETTE MDS 057", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_058", "SLC IMAGETTE MDS 058", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_059", "SLC IMAGETTE MDS 059", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_060", "SLC IMAGETTE MDS 060", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_061", "SLC IMAGETTE MDS 061", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_062", "SLC IMAGETTE MDS 062", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_063", "SLC IMAGETTE MDS 063", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_064", "SLC IMAGETTE MDS 064", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_065", "SLC IMAGETTE MDS 065", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_066", "SLC IMAGETTE MDS 066", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_067", "SLC IMAGETTE MDS 067", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_068", "SLC IMAGETTE MDS 068", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_069", "SLC IMAGETTE MDS 069", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_070", "SLC IMAGETTE MDS 070", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_071", "SLC IMAGETTE MDS 071", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_072", "SLC IMAGETTE MDS 072", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_073", "SLC IMAGETTE MDS 073", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_074", "SLC IMAGETTE MDS 074", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_075", "SLC IMAGETTE MDS 075", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_076", "SLC IMAGETTE MDS 076", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_077", "SLC IMAGETTE MDS 077", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_078", "SLC IMAGETTE MDS 078", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_079", "SLC IMAGETTE MDS 079", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_080", "SLC IMAGETTE MDS 080", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_081", "SLC IMAGETTE MDS 081", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_082", "SLC IMAGETTE MDS 082", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_083", "SLC IMAGETTE MDS 083", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_084", "SLC IMAGETTE MDS 084", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_085", "SLC IMAGETTE MDS 085", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_086", "SLC IMAGETTE MDS 086", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_087", "SLC IMAGETTE MDS 087", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_088", "SLC IMAGETTE MDS 088", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_089", "SLC IMAGETTE MDS 089", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_090", "SLC IMAGETTE MDS 090", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_091", "SLC IMAGETTE MDS 091", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_092", "SLC IMAGETTE MDS 092", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_093", "SLC IMAGETTE MDS 093", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_094", "SLC IMAGETTE MDS 094", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_095", "SLC IMAGETTE MDS 095", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_096", "SLC IMAGETTE MDS 096", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_097", "SLC IMAGETTE MDS 097", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_098", "SLC IMAGETTE MDS 098", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_099", "SLC IMAGETTE MDS 099", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_100", "SLC IMAGETTE MDS 100", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_101", "SLC IMAGETTE MDS 101", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_102", "SLC IMAGETTE MDS 102", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_103", "SLC IMAGETTE MDS 103", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_104", "SLC IMAGETTE MDS 104", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_105", "SLC IMAGETTE MDS 105", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_106", "SLC IMAGETTE MDS 106", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_107", "SLC IMAGETTE MDS 107", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_108", "SLC IMAGETTE MDS 108", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_109", "SLC IMAGETTE MDS 109", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_110", "SLC IMAGETTE MDS 110", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_111", "SLC IMAGETTE MDS 111", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_112", "SLC IMAGETTE MDS 112", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_113", "SLC IMAGETTE MDS 113", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_114", "SLC IMAGETTE MDS 114", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_115", "SLC IMAGETTE MDS 115", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_116", "SLC IMAGETTE MDS 116", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_117", "SLC IMAGETTE MDS 117", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_118", "SLC IMAGETTE MDS 118", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_119", "SLC IMAGETTE MDS 119", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_120", "SLC IMAGETTE MDS 120", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_121", "SLC IMAGETTE MDS 121", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_122", "SLC IMAGETTE MDS 122", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_123", "SLC IMAGETTE MDS 123", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_124", "SLC IMAGETTE MDS 124", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_125", "SLC IMAGETTE MDS 125", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_126", "SLC IMAGETTE MDS 126", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_127", "SLC IMAGETTE MDS 127", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_128", "SLC IMAGETTE MDS 128", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_129", "SLC IMAGETTE MDS 129", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_130", "SLC IMAGETTE MDS 130", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_131", "SLC IMAGETTE MDS 131", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_132", "SLC IMAGETTE MDS 132", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_133", "SLC IMAGETTE MDS 133", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_134", "SLC IMAGETTE MDS 134", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_135", "SLC IMAGETTE MDS 135", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_136", "SLC IMAGETTE MDS 136", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_137", "SLC IMAGETTE MDS 137", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_138", "SLC IMAGETTE MDS 138", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_139", "SLC IMAGETTE MDS 139", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_140", "SLC IMAGETTE MDS 140", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_141", "SLC IMAGETTE MDS 141", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_142", "SLC IMAGETTE MDS 142", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_143", "SLC IMAGETTE MDS 143", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_144", "SLC IMAGETTE MDS 144", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_145", "SLC IMAGETTE MDS 145", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_146", "SLC IMAGETTE MDS 146", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_147", "SLC IMAGETTE MDS 147", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_148", "SLC IMAGETTE MDS 148", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_149", "SLC IMAGETTE MDS 149", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_150", "SLC IMAGETTE MDS 150", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_151", "SLC IMAGETTE MDS 151", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_152", "SLC IMAGETTE MDS 152", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_153", "SLC IMAGETTE MDS 153", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_154", "SLC IMAGETTE MDS 154", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_155", "SLC IMAGETTE MDS 155", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_156", "SLC IMAGETTE MDS 156", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_157", "SLC IMAGETTE MDS 157", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_158", "SLC IMAGETTE MDS 158", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_159", "SLC IMAGETTE MDS 159", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_160", "SLC IMAGETTE MDS 160", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_161", "SLC IMAGETTE MDS 161", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_162", "SLC IMAGETTE MDS 162", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_163", "SLC IMAGETTE MDS 163", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_164", "SLC IMAGETTE MDS 164", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_165", "SLC IMAGETTE MDS 165", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_166", "SLC IMAGETTE MDS 166", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_167", "SLC IMAGETTE MDS 167", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_168", "SLC IMAGETTE MDS 168", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_169", "SLC IMAGETTE MDS 169", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_170", "SLC IMAGETTE MDS 170", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_171", "SLC IMAGETTE MDS 171", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_172", "SLC IMAGETTE MDS 172", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_173", "SLC IMAGETTE MDS 173", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_174", "SLC IMAGETTE MDS 174", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_175", "SLC IMAGETTE MDS 175", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_176", "SLC IMAGETTE MDS 176", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_177", "SLC IMAGETTE MDS 177", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_178", "SLC IMAGETTE MDS 178", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_179", "SLC IMAGETTE MDS 179", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_180", "SLC IMAGETTE MDS 180", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_181", "SLC IMAGETTE MDS 181", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_182", "SLC IMAGETTE MDS 182", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_183", "SLC IMAGETTE MDS 183", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_184", "SLC IMAGETTE MDS 184", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_185", "SLC IMAGETTE MDS 185", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_186", "SLC IMAGETTE MDS 186", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_187", "SLC IMAGETTE MDS 187", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_188", "SLC IMAGETTE MDS 188", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_189", "SLC IMAGETTE MDS 189", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_190", "SLC IMAGETTE MDS 190", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_191", "SLC IMAGETTE MDS 191", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_192", "SLC IMAGETTE MDS 192", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_193", "SLC IMAGETTE MDS 193", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_194", "SLC IMAGETTE MDS 194", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_195", "SLC IMAGETTE MDS 195", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_196", "SLC IMAGETTE MDS 196", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_197", "SLC IMAGETTE MDS 197", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_198", "SLC IMAGETTE MDS 198", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_199", "SLC IMAGETTE MDS 199", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_200", "SLC IMAGETTE MDS 200", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_201", "SLC IMAGETTE MDS 201", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_202", "SLC IMAGETTE MDS 202", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_203", "SLC IMAGETTE MDS 203", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_204", "SLC IMAGETTE MDS 204", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_205", "SLC IMAGETTE MDS 205", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_206", "SLC IMAGETTE MDS 206", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_207", "SLC IMAGETTE MDS 207", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_208", "SLC IMAGETTE MDS 208", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_209", "SLC IMAGETTE MDS 209", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_210", "SLC IMAGETTE MDS 210", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_211", "SLC IMAGETTE MDS 211", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_212", "SLC IMAGETTE MDS 212", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_213", "SLC IMAGETTE MDS 213", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_214", "SLC IMAGETTE MDS 214", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_215", "SLC IMAGETTE MDS 215", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_216", "SLC IMAGETTE MDS 216", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_217", "SLC IMAGETTE MDS 217", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_218", "SLC IMAGETTE MDS 218", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_219", "SLC IMAGETTE MDS 219", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_220", "SLC IMAGETTE MDS 220", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_221", "SLC IMAGETTE MDS 221", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_222", "SLC IMAGETTE MDS 222", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_223", "SLC IMAGETTE MDS 223", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_224", "SLC IMAGETTE MDS 224", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_225", "SLC IMAGETTE MDS 225", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_226", "SLC IMAGETTE MDS 226", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_227", "SLC IMAGETTE MDS 227", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_228", "SLC IMAGETTE MDS 228", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_229", "SLC IMAGETTE MDS 229", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_230", "SLC IMAGETTE MDS 230", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_231", "SLC IMAGETTE MDS 231", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_232", "SLC IMAGETTE MDS 232", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_233", "SLC IMAGETTE MDS 233", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_234", "SLC IMAGETTE MDS 234", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_235", "SLC IMAGETTE MDS 235", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_236", "SLC IMAGETTE MDS 236", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_237", "SLC IMAGETTE MDS 237", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_238", "SLC IMAGETTE MDS 238", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_239", "SLC IMAGETTE MDS 239", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_240", "SLC IMAGETTE MDS 240", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_241", "SLC IMAGETTE MDS 241", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_242", "SLC IMAGETTE MDS 242", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_243", "SLC IMAGETTE MDS 243", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_244", "SLC IMAGETTE MDS 244", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_245", "SLC IMAGETTE MDS 245", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_246", "SLC IMAGETTE MDS 246", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_247", "SLC IMAGETTE MDS 247", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_248", "SLC IMAGETTE MDS 248", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_249", "SLC IMAGETTE MDS 249", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_250", "SLC IMAGETTE MDS 250", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_251", "SLC IMAGETTE MDS 251", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_252", "SLC IMAGETTE MDS 252", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_253", "SLC IMAGETTE MDS 253", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_254", "SLC IMAGETTE MDS 254", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_255", "SLC IMAGETTE MDS 255", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_256", "SLC IMAGETTE MDS 256", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_257", "SLC IMAGETTE MDS 257", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_258", "SLC IMAGETTE MDS 258", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_259", "SLC IMAGETTE MDS 259", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_260", "SLC IMAGETTE MDS 260", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_261", "SLC IMAGETTE MDS 261", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_262", "SLC IMAGETTE MDS 262", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_263", "SLC IMAGETTE MDS 263", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_264", "SLC IMAGETTE MDS 264", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_265", "SLC IMAGETTE MDS 265", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_266", "SLC IMAGETTE MDS 266", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_267", "SLC IMAGETTE MDS 267", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_268", "SLC IMAGETTE MDS 268", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_269", "SLC IMAGETTE MDS 269", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_270", "SLC IMAGETTE MDS 270", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_271", "SLC IMAGETTE MDS 271", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_272", "SLC IMAGETTE MDS 272", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_273", "SLC IMAGETTE MDS 273", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_274", "SLC IMAGETTE MDS 274", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_275", "SLC IMAGETTE MDS 275", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_276", "SLC IMAGETTE MDS 276", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_277", "SLC IMAGETTE MDS 277", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_278", "SLC IMAGETTE MDS 278", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_279", "SLC IMAGETTE MDS 279", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_280", "SLC IMAGETTE MDS 280", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_281", "SLC IMAGETTE MDS 281", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_282", "SLC IMAGETTE MDS 282", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_283", "SLC IMAGETTE MDS 283", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_284", "SLC IMAGETTE MDS 284", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_285", "SLC IMAGETTE MDS 285", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_286", "SLC IMAGETTE MDS 286", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_287", "SLC IMAGETTE MDS 287", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_288", "SLC IMAGETTE MDS 288", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_289", "SLC IMAGETTE MDS 289", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_290", "SLC IMAGETTE MDS 290", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_291", "SLC IMAGETTE MDS 291", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_292", "SLC IMAGETTE MDS 292", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_293", "SLC IMAGETTE MDS 293", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_294", "SLC IMAGETTE MDS 294", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_295", "SLC IMAGETTE MDS 295", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_296", "SLC IMAGETTE MDS 296", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_297", "SLC IMAGETTE MDS 297", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_298", "SLC IMAGETTE MDS 298", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_299", "SLC IMAGETTE MDS 299", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_300", "SLC IMAGETTE MDS 300", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_301", "SLC IMAGETTE MDS 301", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_302", "SLC IMAGETTE MDS 302", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_303", "SLC IMAGETTE MDS 303", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_304", "SLC IMAGETTE MDS 304", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_305", "SLC IMAGETTE MDS 305", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_306", "SLC IMAGETTE MDS 306", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_307", "SLC IMAGETTE MDS 307", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_308", "SLC IMAGETTE MDS 308", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_309", "SLC IMAGETTE MDS 309", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_310", "SLC IMAGETTE MDS 310", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_311", "SLC IMAGETTE MDS 311", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_312", "SLC IMAGETTE MDS 312", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_313", "SLC IMAGETTE MDS 313", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_314", "SLC IMAGETTE MDS 314", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_315", "SLC IMAGETTE MDS 315", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_316", "SLC IMAGETTE MDS 316", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_317", "SLC IMAGETTE MDS 317", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_318", "SLC IMAGETTE MDS 318", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_319", "SLC IMAGETTE MDS 319", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_320", "SLC IMAGETTE MDS 320", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_321", "SLC IMAGETTE MDS 321", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_322", "SLC IMAGETTE MDS 322", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_323", "SLC IMAGETTE MDS 323", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_324", "SLC IMAGETTE MDS 324", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_325", "SLC IMAGETTE MDS 325", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_326", "SLC IMAGETTE MDS 326", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_327", "SLC IMAGETTE MDS 327", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_328", "SLC IMAGETTE MDS 328", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_329", "SLC IMAGETTE MDS 329", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_330", "SLC IMAGETTE MDS 330", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_331", "SLC IMAGETTE MDS 331", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_332", "SLC IMAGETTE MDS 332", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_333", "SLC IMAGETTE MDS 333", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_334", "SLC IMAGETTE MDS 334", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_335", "SLC IMAGETTE MDS 335", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_336", "SLC IMAGETTE MDS 336", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_337", "SLC IMAGETTE MDS 337", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_338", "SLC IMAGETTE MDS 338", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_339", "SLC IMAGETTE MDS 339", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_340", "SLC IMAGETTE MDS 340", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_341", "SLC IMAGETTE MDS 341", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_342", "SLC IMAGETTE MDS 342", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_343", "SLC IMAGETTE MDS 343", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_344", "SLC IMAGETTE MDS 344", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_345", "SLC IMAGETTE MDS 345", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_346", "SLC IMAGETTE MDS 346", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_347", "SLC IMAGETTE MDS 347", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_348", "SLC IMAGETTE MDS 348", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_349", "SLC IMAGETTE MDS 349", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_350", "SLC IMAGETTE MDS 350", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_351", "SLC IMAGETTE MDS 351", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_352", "SLC IMAGETTE MDS 352", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_353", "SLC IMAGETTE MDS 353", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_354", "SLC IMAGETTE MDS 354", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_355", "SLC IMAGETTE MDS 355", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_356", "SLC IMAGETTE MDS 356", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_357", "SLC IMAGETTE MDS 357", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_358", "SLC IMAGETTE MDS 358", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_359", "SLC IMAGETTE MDS 359", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_360", "SLC IMAGETTE MDS 360", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_361", "SLC IMAGETTE MDS 361", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_362", "SLC IMAGETTE MDS 362", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_363", "SLC IMAGETTE MDS 363", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_364", "SLC IMAGETTE MDS 364", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_365", "SLC IMAGETTE MDS 365", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_366", "SLC IMAGETTE MDS 366", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_367", "SLC IMAGETTE MDS 367", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_368", "SLC IMAGETTE MDS 368", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_369", "SLC IMAGETTE MDS 369", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_370", "SLC IMAGETTE MDS 370", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_371", "SLC IMAGETTE MDS 371", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_372", "SLC IMAGETTE MDS 372", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_373", "SLC IMAGETTE MDS 373", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_374", "SLC IMAGETTE MDS 374", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_375", "SLC IMAGETTE MDS 375", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_376", "SLC IMAGETTE MDS 376", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_377", "SLC IMAGETTE MDS 377", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_378", "SLC IMAGETTE MDS 378", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_379", "SLC IMAGETTE MDS 379", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_380", "SLC IMAGETTE MDS 380", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_381", "SLC IMAGETTE MDS 381", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_382", "SLC IMAGETTE MDS 382", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_383", "SLC IMAGETTE MDS 383", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_384", "SLC IMAGETTE MDS 384", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_385", "SLC IMAGETTE MDS 385", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_386", "SLC IMAGETTE MDS 386", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_387", "SLC IMAGETTE MDS 387", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_388", "SLC IMAGETTE MDS 388", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_389", "SLC IMAGETTE MDS 389", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_390", "SLC IMAGETTE MDS 390", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_391", "SLC IMAGETTE MDS 391", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_392", "SLC IMAGETTE MDS 392", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_393", "SLC IMAGETTE MDS 393", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_394", "SLC IMAGETTE MDS 394", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_395", "SLC IMAGETTE MDS 395", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_396", "SLC IMAGETTE MDS 396", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_397", "SLC IMAGETTE MDS 397", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_398", "SLC IMAGETTE MDS 398", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_399", "SLC IMAGETTE MDS 399", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"},
    {"SLC_IMAGETTE_MDS_400", "SLC IMAGETTE MDS 400", ASAR_Image_MDSR_SLC_asar_rec_data, "Measurement Data Set for a single imagette (corresponds to one spectrum MDSR)"}
};

static const struct DatasetDescriptor ASA_WVS_1P_dataset_data[] = {
    {"SQ_ADS", "SQ ADS", ASAR_Wave_SQ_ADSR_asar_rec_data, "SQ ADSRs"},
    {"GEOLOCATION_ADS", "GEOLOCATION ADS", ASAR_Wave_Geolocation_ADSR_asar_rec_data, "Wave Mode Geolocation ADS"},
    {"PROCESSING_PARAMS_ADS", "PROCESSING PARAMS ADS", ASAR_Wave_Param_ADSR_asar_rec_data, "Wave Mode processing parameters"},
    {"CROSS_SPECTRA_MDS", "CROSS SPECTRA MDS", ASAR_Spectra_MDSR_asar_rec_data, "Measurement Data Set containing spectra. 1 MDSR per spectra."}
};

static const struct DatasetDescriptor ASA_WVW_2P_dataset_data[] = {
    {"SQ_ADS", "SQ ADS", ASAR_Wave_SQ_ADSR_asar_rec_data, "SQ ADSRs"},
    {"GEOLOCATION_ADS", "GEOLOCATION ADS", ASAR_Wave_Geolocation_ADSR_asar_rec_data, "Wave Mode Geolocation ADS"},
    {"PROCESSING_PARAMS_ADS", "PROCESSING PARAMS ADS", ASAR_Wave_Param_ADSR_asar_rec_data, "Wave Mode processing parameters"},
    {"WAVE_SPECTRA_MDS", "WAVE SPECTRA MDS", ASAR_Ocean_Spectra_MDSR_asar_rec_data, "Ocean Wave Spectra"}
};

static const struct DatasetDescriptor ATS_AR__2P_dataset_data[] = {
    {"SEA_ST_50_KM_CELL_MDS", "SEA_ST_50_KM_CELL_MDS", ATS_AR__2P_MDSR_sst_large_aatsr_rec_data, "SST record 50 km cell MDS"},
    {"SEA_ST_17_KM_CELL_MDS", "SEA_ST_17_KM_CELL_MDS", ATS_AR__2P_MDSR_sst_small_aatsr_rec_data, "SST record 17 km cell MDS"},
    {"SEA_ST_10_MIN_CELL_MDS", "SEA_ST_10_MIN_CELL_MDS", ATS_AR__2P_MDSR_sst_small_aatsr_rec_data, "SST record 10 arc minute cell MDS"},
    {"SEA_ST_30_MIN_CELL_MDS", "SEA_ST_30_MIN_CELL_MDS", ATS_AR__2P_MDSR_sst_large_aatsr_rec_data, "SST record 30 arc minute cell MDS"},
    {"LAND_ST_50_KM_CELL_MDS", "LAND_ST_50_KM_CELL_MDS", ATS_AR__2P_MDSR_lst_large_aatsr_rec_data, "LST record 50 km cell MDS"},
    {"LAND_ST_17_KM_CELL_MDS", "LAND_ST_17_KM_CELL_MDS", ATS_AR__2P_MDSR_lst_small_aatsr_rec_data, "LST record 17 km cell MDS"},
    {"LAND_ST_10_MIN_CELL_MDS", "LAND_ST_10_MIN_CELL_MDS", ATS_AR__2P_MDSR_lst_small_aatsr_rec_data, "LST record 10 arc minute cell MDS"},
    {"LAND_ST_30_MIN_CELL_MDS", "LAND_ST_30_MIN_CELL_MDS", ATS_AR__2P_MDSR_lst_large_aatsr_rec_data, "LST record 30 arc minute cell MDS"},
    {"BT_TOA_LAND_50_KM_CELL_MDS", "BT_TOA_LAND_50_KM_CELL_MDS", ATS_AR__2P_MDSR_lr_large_aatsr_rec_data, "BT/TOA Land record 50 km cell MDS"},
    {"BT_TOA_LAND_17_KM_CELL_MDS", "BT_TOA_LAND_17_KM_CELL_MDS", ATS_AR__2P_MDSR_lr_small_aatsr_rec_data, "BT/TOA Land record 17 km cell MDS"},
    {"BT_TOA_LAND_10_MIN_CELL_MDS", "BT_TOA_LAND_10_MIN_CELL_MDS", ATS_AR__2P_MDSR_lr_small_aatsr_rec_data, "BT/TOA Land record 10 arc minute cell MDS"},
    {"BT_TOA_LAND_30_MIN_CELL_MDS", "BT_TOA_LAND_30_MIN_CELL_MDS", ATS_AR__2P_MDSR_lr_large_aatsr_rec_data, "BT/TOA Land record 30 arc minute cell MDS"},
    {"BT_TOA_SEA_50_KM_CELL_MDS", "BT_TOA_SEA_50_KM_CELL_MDS", ATS_AR__2P_MDSR_sr_large_aatsr_rec_data, "BT/TOA Sea record 50 km cell MDS"},
    {"BT_TOA_SEA_17_KM_CELL_MDS", "BT_TOA_SEA_17_KM_CELL_MDS", ATS_AR__2P_MDSR_sr_small_aatsr_rec_data, "BT/TOA Sea record 17 km cell MDS"},
    {"BT_TOA_SEA_10_MIN_CELL_MDS", "BT_TOA_SEA_10_MIN_CELL_MDS", ATS_AR__2P_MDSR_sr_small_aatsr_rec_data, "BT/TOA Sea record 10 arc minute cell MDS"},
    {"BT_TOA_SEA_30_MIN_CELL_MDS", "BT_TOA_SEA_30_MIN_CELL_MDS", ATS_AR__2P_MDSR_sr_large_aatsr_rec_data, "BT/TOA Sea record 30 arc minute cell MDS"}
};

static const struct DatasetDescriptor ATS_MET_2P_dataset_data[] = {
    {"SEA_ST_10_MIN_CELL_MDS", "SEA_ST_10_MIN_CELL_MDS", ATS_MET_2P_meteo_user_prod_aatsr_rec_data, "10-arcminute mds"}
};

static const struct DatasetDescriptor ATS_NR__2P_dataset_data[] = {
    {"SUMMARY_QUALITY_ADS", "SUMMARY_QUALITY_ADS", ATS_NR__2P_ADSR_sq_aatsr_rec_data, "Summary Quality ADS"},
    {"GEOLOCATION_ADS", "GEOLOCATION_ADS", ATS_TOA_1P_ADSR_loc_aatsr_rec_data, "Grid pixel latitude and longtitude  topographic corrections ADS"},
    {"SCAN_PIXEL_X_AND_Y_ADS", "SCAN_PIXEL_X_AND_Y_ADS", ATS_TOA_1P_ADSR_scan_aatsr_rec_data, "Scan pixel x and y ADS"},
    {"NADIR_VIEW_SOLAR_ANGLES_ADS", "NADIR_VIEW_SOLAR_ANGLES_ADS", ATS_TOA_1P_ADSR_sa_aatsr_rec_data, "Nadir view solar angles ADS"},
    {"FWARD_VIEW_SOLAR_ANGLES_ADS", "FWARD_VIEW_SOLAR_ANGLES_ADS", ATS_TOA_1P_ADSR_sa_aatsr_rec_data, "Forward view solar angles ADS"},
    {"NADIR_VIEW_SCAN_PIX_NUM_ADS", "NADIR_VIEW_SCAN_PIX_NUM_ADS", ATS_TOA_1P_ADSR_pix_aatsr_rec_data, "Scan and pixel number nadir view ADS"},
    {"FWARD_VIEW_SCAN_PIX_NUM_ADS", "FWARD_VIEW_SCAN_PIX_NUM_ADS", ATS_TOA_1P_ADSR_pix_aatsr_rec_data, "Scan and pixel number forward view ADS"},
    {"DISTRIB_SST_CLOUD_LAND_MDS", "DISTRIB_SST_CLOUD_LAND_MDS", ATS_NR__2P_MDSR_dp_aatsr_rec_data, "Distributed product MDS"}
};

static const struct DatasetDescriptor ATS_TOA_1P_dataset_data[] = {
    {"SUMMARY_QUALITY_ADS", "SUMMARY_QUALITY_ADS", ATS_TOA_1P_ADSR_sq_aatsr_rec_data, "Summary Quality ADS"},
    {"GEOLOCATION_ADS", "GEOLOCATION_ADS", ATS_TOA_1P_ADSR_loc_aatsr_rec_data, "Grid pixel latitude and longtitude  topographic corrections ADS"},
    {"SCAN_PIXEL_X_AND_Y_ADS", "SCAN_PIXEL_X_AND_Y_ADS", ATS_TOA_1P_ADSR_scan_aatsr_rec_data, "Scan pixel x and y ADS"},
    {"NADIR_VIEW_SOLAR_ANGLES_ADS", "NADIR_VIEW_SOLAR_ANGLES_ADS", ATS_TOA_1P_ADSR_sa_aatsr_rec_data, "Nadir view solar angles ADS"},
    {"FWARD_VIEW_SOLAR_ANGLES_ADS", "FWARD_VIEW_SOLAR_ANGLES_ADS", ATS_TOA_1P_ADSR_sa_aatsr_rec_data, "Forward view solar angles ADS"},
    {"VISIBLE_CALIB_COEFS_GADS", "VISIBLE_CALIB_COEFS_GADS", ATS_VC1_AX_GADS_aatsr_rec_data, "Visible calibration coefficients GADS"},
    {"NADIR_VIEW_SCAN_PIX_NUM_ADS", "NADIR_VIEW_SCAN_PIX_NUM_ADS", ATS_TOA_1P_ADSR_pix_aatsr_rec_data, "Scan and pixel number  nadir view ADS"},
    {"FWARD_VIEW_SCAN_PIX_NUM_ADS", "FWARD_VIEW_SCAN_PIX_NUM_ADS", ATS_TOA_1P_ADSR_pix_aatsr_rec_data, "Scan and pixel number forward view ADS"},
    {"11500_12500_NM_NADIR_TOA_MDS", "11500_12500_NM_NADIR_TOA_MDS", ATS_TOA_1P_MDSR_brgt_aatsr_rec_data, "12 micron nadir view MDS"},
    {"10400_11300_NM_NADIR_TOA_MDS", "10400_11300_NM_NADIR_TOA_MDS", ATS_TOA_1P_MDSR_brgt_aatsr_rec_data, "11 micron nadir view MDS"},
    {"03505_03895_NM_NADIR_TOA_MDS", "03505_03895_NM_NADIR_TOA_MDS", ATS_TOA_1P_MDSR_brgt_aatsr_rec_data, "3.7 micron nadir view MDS"},
    {"01580_01640_NM_NADIR_TOA_MDS", "01580_01640_NM_NADIR_TOA_MDS", ATS_TOA_1P_MDSR_brgt_aatsr_rec_data, "1.6 micron nadir view MDS"},
    {"00855_00875_NM_NADIR_TOA_MDS", "00855_00875_NM_NADIR_TOA_MDS", ATS_TOA_1P_MDSR_brgt_aatsr_rec_data, "0.87 micron nadir view MDS"},
    {"00649_00669_NM_NADIR_TOA_MDS", "00649_00669_NM_NADIR_TOA_MDS", ATS_TOA_1P_MDSR_brgt_aatsr_rec_data, "0.67 micron nadir view MDS"},
    {"00545_00565_NM_NADIR_TOA_MDS", "00545_00565_NM_NADIR_TOA_MDS", ATS_TOA_1P_MDSR_brgt_aatsr_rec_data, "0.55 micron nadir view MDS"},
    {"11500_12500_NM_FWARD_TOA_MDS", "11500_12500_NM_FWARD_TOA_MDS", ATS_TOA_1P_MDSR_brgt_aatsr_rec_data, "12 micron forward view MDS"},
    {"10400_11300_NM_FWARD_TOA_MDS", "10400_11300_NM_FWARD_TOA_MDS", ATS_TOA_1P_MDSR_brgt_aatsr_rec_data, "11 micron forward view MDS"},
    {"03505_03895_NM_FWARD_TOA_MDS", "03505_03895_NM_FWARD_TOA_MDS", ATS_TOA_1P_MDSR_brgt_aatsr_rec_data, "3.7 micron forward view MDS"},
    {"01580_01640_NM_FWARD_TOA_MDS", "01580_01640_NM_FWARD_TOA_MDS", ATS_TOA_1P_MDSR_brgt_aatsr_rec_data, "1.6 micron forward view MDS"},
    {"00855_00875_NM_FWARD_TOA_MDS", "00855_00875_NM_FWARD_TOA_MDS", ATS_TOA_1P_MDSR_brgt_aatsr_rec_data, "0.87 micron forward view MDS"},
    {"00649_00669_NM_FWARD_TOA_MDS", "00649_00669_NM_FWARD_TOA_MDS", ATS_TOA_1P_MDSR_brgt_aatsr_rec_data, "0.67 micron forward view MDS"},
    {"00545_00565_NM_FWARD_TOA_MDS", "00545_00565_NM_FWARD_TOA_MDS", ATS_TOA_1P_MDSR_brgt_aatsr_rec_data, "0.55 micron forward view MDS"},
    {"NADIR_VIEW_CONFIDENCE_MDS", "NADIR_VIEW_CONFIDENCE_MDS", ATS_TOA_1P_MDSR_conf_aatsr_rec_data, "Confidence words nadir view MDS"},
    {"FWARD_VIEW_CONFIDENCE_MDS", "FWARD_VIEW_CONFIDENCE_MDS", ATS_TOA_1P_MDSR_conf_aatsr_rec_data, "Confidence words forward view MDS"},
    {"NADIR_VIEW_CLOUD_MDS", "NADIR_VIEW_CLOUD_MDS", ATS_TOA_1P_MDSR_cl_aatsr_rec_data, "Cloud flag nadir view MDS"},
    {"FWARD_VIEW_CLOUD_MDS", "FWARD_VIEW_CLOUD_MDS", ATS_TOA_1P_MDSR_cl_aatsr_rec_data, "Cloud flag forward view MDS"}
};

static const struct DatasetDescriptor MER_FR__1P_dataset_data[] = {
    {"Quality_ADS", "Quality ADS", MER_RR__1P_ADSR_sq_meris_rec_data, "Level 1b Summary Quality ADS(SQ ADS)"},
    {"Scaling_Factor_GADS", "Scaling Factor GADS", MER_RR__1P_GADS_sfgi_meris_rec_data, "Level 1b GADS Scaling Factor and General  Info"},
    {"Tie_points_ADS", "Tie points ADS", MER_RR__1P_ADSR_tie_pt_meris_rec_data, "Level 1b ADS Tie Point Location and Auxiliary Data (LADS)"},
    {"Radiance_1", "Radiance MDS(1)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (1) TOA Radiance"},
    {"Radiance_2", "Radiance MDS(2)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (2) TOA Radiance"},
    {"Radiance_3", "Radiance MDS(3)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (3) TOA Radiance"},
    {"Radiance_4", "Radiance MDS(4)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (4) TOA Radiance"},
    {"Radiance_5", "Radiance MDS(5)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (5) TOA Radiance"},
    {"Radiance_6", "Radiance MDS(6)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (6) TOA Radiance"},
    {"Radiance_7", "Radiance MDS(7)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (7) TOA Radiance"},
    {"Radiance_8", "Radiance MDS(8)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (8) TOA Radiance"},
    {"Radiance_9", "Radiance MDS(9)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (9) TOA Radiance"},
    {"Radiance_10", "Radiance MDS(10)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (10) TOA Radiance"},
    {"Radiance_11", "Radiance MDS(11)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (11) TOA Radiance"},
    {"Radiance_12", "Radiance MDS(12)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (12) TOA Radiance"},
    {"Radiance_13", "Radiance MDS(13)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (13) TOA Radiance"},
    {"Radiance_14", "Radiance MDS(14)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (14) TOA Radiance"},
    {"Radiance_15", "Radiance MDS(15)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (15) TOA Radiance"},
    {"Flags", "Flags MDS(16)", MER_RR__1P_MDSR_16_meris_rec_data, "Level 1b MDS (16) Flags & Detector Index"}
};

static const struct DatasetDescriptor MER_FR__1P_IODD5_dataset_data[] = {
    {"Quality_ADS", "Quality ADS", MER_RR__1P_ADSR_sq_meris_rec_data, "Level 1b Summary Quality ADS(SQ ADS)"},
    {"Scaling_Factor_GADS", "Scaling Factor GADS", MER_RR__1P_GADS_sfgi_meris_rec_data, "Level 1b GADS Scaling Factor and General  Info"},
    {"Tie_points_ADS", "Tie points ADS", MER_RR__1P_ADSR_tie_pt_meris_rec_data, "Level 1b ADS Tie Point Location and Auxiliary Data (LADS)"},
    {"Radiance_1", "Radiance MDS(1)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (1) TOA Radiance"},
    {"Radiance_2", "Radiance MDS(2)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (2) TOA Radiance"},
    {"Radiance_3", "Radiance MDS(3)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (3) TOA Radiance"},
    {"Radiance_4", "Radiance MDS(4)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (4) TOA Radiance"},
    {"Radiance_5", "Radiance MDS(5)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (5) TOA Radiance"},
    {"Radiance_6", "Radiance MDS(6)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (6) TOA Radiance"},
    {"Radiance_7", "Radiance MDS(7)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (7) TOA Radiance"},
    {"Radiance_8", "Radiance MDS(8)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (8) TOA Radiance"},
    {"Radiance_9", "Radiance MDS(9)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (9) TOA Radiance"},
    {"Radiance_10", "Radiance MDS(10)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (10) TOA Radiance"},
    {"Radiance_11", "Radiance MDS(11)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (11) TOA Radiance"},
    {"Radiance_12", "Radiance MDS(12)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (12) TOA Radiance"},
    {"Radiance_13", "Radiance MDS(13)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (13) TOA Radiance"},
    {"Radiance_14", "Radiance MDS(14)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (14) TOA Radiance"},
    {"Radiance_15", "Radiance MDS(15)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (15) TOA Radiance"},
    {"Flags", "Flags MDS(16)", MER_RR__1P_MDSR_16_IODD5_meris_rec_data, "Level 1b MDS (16) Flags & Spectral Shift Index"}
};

static const struct DatasetDescriptor MER_FR__2P_dataset_data[] = {
    {"Quality_ADS", "Quality ADS", MER_RR__2P_ADSR_sq_meris_rec_data, "Level 2 ADS Summary Quality (SQ ADS)"},
    {"Scaling_Factor_GADS", "Scaling Factor GADS", MER_RR__2P_GADS_sfgi_meris_rec_data, "Level 2 GADS Scaling Factors and Offsets"},
    {"Tie_points_ADS", "Tie points ADS", MER_RR__1P_ADSR_tie_pt_meris_rec_data, "Level 2 ADS Tie Points Location & Aux. Data(L ADS)"},
    {"Norm_rho_surf_1", "Norm. rho_surf - MDS(1)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(1) normalised surface reflectance"},
    {"Norm_rho_surf_2", "Norm. rho_surf - MDS(2)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(2) normalised surface reflectance"},
    {"Norm_rho_surf_3", "Norm. rho_surf - MDS(3)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(3) normalised surface reflectance"},
    {"Norm_rho_surf_4", "Norm. rho_surf - MDS(4)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(4) normalised surface reflectance"},
    {"Norm_rho_surf_5", "Norm. rho_surf - MDS(5)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(5) normalised surface reflectance"},
    {"Norm_rho_surf_6", "Norm. rho_surf - MDS(6)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(6) normalised surface reflectance"},
    {"Norm_rho_surf_7", "Norm. rho_surf - MDS(7)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(7) normalised surface reflectance"},
    {"Norm_rho_surf_8", "Norm. rho_surf - MDS(8)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(8) normalised surface reflectance"},
    {"Norm_rho_surf_9", "Norm. rho_surf - MDS(9)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(9) normalised surface reflectance"},
    {"Norm_rho_surf_10", "Norm. rho_surf - MDS(10)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(10) normalised surface reflectance"},
    {"Norm_rho_surf_11", "Norm. rho_surf - MDS(11)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(11) normalised surface reflectance"},
    {"Norm_rho_surf_12", "Norm. rho_surf - MDS(12)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(12) normalised surface reflectance"},
    {"Norm_rho_surf_13", "Norm. rho_surf - MDS(13)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(13) normalised surface reflectance"},
    {"Vapour_Content", "Vapour Content - MDS(14)", MER_RR__2P_MDSR_14_meris_rec_data, "Level 2 MDS(14) water vapour content"},
    {"Chl_1_TOAVI_CTP", "Chl_1, TOAVI   - MDS(15)", MER_RR__2P_MDSR_15_meris_rec_data, "Level 2 MDS(15) algal index I or TOAVI"},
    {"YS_SPM_Rect_rho", "YS, SPM, Rect. Rho- MDS(16)", MER_RR__2P_MDSR_16_meris_rec_data, "Level 2 MDS(16) yellow substance total suspended matter"},
    {"Chl_2_BOAVI", "Chl_2, BOAVI   - MDS(17)", MER_RR__2P_MDSR_17_meris_rec_data, "Level 2 MDS(17) algal index II  BOAVI"},
    {"Press_PAR_Alb", "Press PAR Alb  - MDS(18)", MER_RR__2P_MDSR_18_meris_rec_data, "Level 2 MDS(18) surface pressure  PAR  cloud albedo"},
    {"Alpha_OPT", "Alpha, OPT     - MDS(19)", MER_RR__2P_MDSR_19_meris_rec_data, "Level 2 MDS(19) aerosol Angstrom exponent or cloud type and optical thickness"},
    {"Flags", "Flags          - MDS(20)", MER_RR__2P_MDSR_20_meris_rec_data, "Level 2 MDS(20) flags"}
};

static const struct DatasetDescriptor MER_FR__2P_IODD6_dataset_data[] = {
    {"Quality_ADS", "Quality ADS", MER_RR__2P_ADSR_sq_meris_rec_data, "Level 2 ADS Summary Quality (SQ ADS)"},
    {"Scaling_Factor_GADS", "Scaling Factor GADS", MER_RR__2P_GADS_sfgi_meris_rec_data, "Level 2 GADS Scaling Factors and Offsets"},
    {"Tie_points_ADS", "Tie points ADS", MER_RR__1P_ADSR_tie_pt_meris_rec_data, "Level 2 ADS Tie Points Location & Aux. Data(L ADS)"},
    {"Norm_rho_surf_1", "Norm. rho_surf - MDS(1)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(1) normalised surface reflectance"},
    {"Norm_rho_surf_2", "Norm. rho_surf - MDS(2)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(2) normalised surface reflectance"},
    {"Norm_rho_surf_3", "Norm. rho_surf - MDS(3)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(3) normalised surface reflectance"},
    {"Norm_rho_surf_4", "Norm. rho_surf - MDS(4)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(4) normalised surface reflectance"},
    {"Norm_rho_surf_5", "Norm. rho_surf - MDS(5)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(5) normalised surface reflectance"},
    {"Norm_rho_surf_6", "Norm. rho_surf - MDS(6)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(6) normalised surface reflectance"},
    {"Norm_rho_surf_7", "Norm. rho_surf - MDS(7)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(7) normalised surface reflectance"},
    {"Norm_rho_surf_8", "Norm. rho_surf - MDS(8)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(8) normalised surface reflectance"},
    {"Norm_rho_surf_9", "Norm. rho_surf - MDS(9)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(9) normalised surface reflectance"},
    {"Norm_rho_surf_10", "Norm. rho_surf - MDS(10)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(10) normalised surface reflectance"},
    {"Norm_rho_surf_11", "Norm. rho_surf - MDS(11)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(11) normalised surface reflectance"},
    {"Norm_rho_surf_12", "Norm. rho_surf - MDS(12)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(12) normalised surface reflectance"},
    {"Norm_rho_surf_13", "Norm. rho_surf - MDS(13)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(13) normalised surface reflectance"},
    {"Vapour_Content", "Vapour Content - MDS(14)", MER_RR__2P_MDSR_14_meris_rec_data, "Level 2 MDS(14) water vapour content"},
    {"Chl_1_TOAVI_CTP", "Chl_1, TOAVI   - MDS(15)", MER_RR__2P_MDSR_15_meris_rec_data, "Level 2 MDS(15) algal index I or TOAVI"},
    {"YS_SPM_Rect_rho", "YS, SPM, Rect. Rho- MDS(16)", MER_RR__2P_MDSR_16_meris_rec_data, "Level 2 MDS(16) yellow substance total suspended matter"},
    {"Chl_2_BOAVI", "Chl_2, BOAVI   - MDS(17)", MER_RR__2P_MDSR_17_meris_rec_data, "Level 2 MDS(17) algal index II  BOAVI"},
    {"Press_PAR_Alb", "Press PAR Alb  - MDS(18)", MER_RR__2P_MDSR_18_meris_rec_data, "Level 2 MDS(18) surface pressure  PAR  cloud albedo"},
    {"Epsilon_OPT", "Epsilon, OPT   - MDS(19)", MER_RR__2P_MDSR_19_IODD6_meris_rec_data, "Level 2 MDS(19) aerosol epsilon or cloud type and optical thickness"},
    {"Flags", "Flags          - MDS(20)", MER_RR__2P_MDSR_20_meris_rec_data, "Level 2 MDS(20) flags"}
};

static const struct DatasetDescriptor MER_LRC_2P_dataset_data[] = {
    {"Quality_ADS", "Quality ADS", MER_RR__2P_ADSR_sq_meris_rec_data, "Level 2 Summary Quality ADS(SQ ADS)"},
    {"Scaling_Factor_GADS", "Scaling Factor GADS", MER_RRC_2P_GADS_sfgi_meris_rec_data, "Level 2 GADS Scaling Factor and Offsets"},
    {"Tie_points_ADS", "Tie points ADS", MER_RR__1P_ADSR_tie_pt_meris_rec_data, "Level 2 ADS Tie Points Location & Aux. Data ( L ADS)"},
    {"Cloud_Type_OT", "MDS Cloud Type, OT", MER_LRC_2P_MDSR_cl_thick_meris_rec_data, "Level 2 MDS Cloud Optical Thickness"},
    {"Cloud_Top_Pressure", "MDS Cloud Top Pressure", MER_LRC_2P_MDSR_cl_top_press_meris_rec_data, "Level 2 MDS Cloud Top Pressure"},
    {"Vapour_Content", "MDS Vapour Content", MER_LRC_2P_MDSR_twv_meris_rec_data, "Level 2 MDS Total Water vapour"},
    {"Flags", "MDS Flags", MER_LRC_2P_MDSR_flag_meris_rec_data, "Level 2 MDS Flags"}
};

static const struct DatasetDescriptor MER_RRC_2P_dataset_data[] = {
    {"Quality_ADS", "Quality ADS", MER_RR__2P_ADSR_sq_meris_rec_data, "Level 2 Summary Quality ADS (SQ ADS)"},
    {"Scaling_Factor_GADS", "Scaling Factor GADS", MER_RRC_2P_GADS_sfgi_meris_rec_data, "Level 2 GADS Scaling Factor And Offsets"},
    {"Tie_points_ADS", "Tie points ADS", MER_RR__1P_ADSR_tie_pt_meris_rec_data, "Level 2 ADS Tie Points Location & Aux Data( L ADS)"},
    {"Cloud_Type_OT", "MDS Cloud Type, OT", MER_RR__2P_MDSR_19_meris_rec_data, "Level 2 MDS Cloud Optical Thickness"},
    {"Cloud_Top_Pressure", "MDS Cloud Top Pressure", MER_RR__2P_MDSR_15_meris_rec_data, "Level 2 MDS Cloud Top Pressure"},
    {"Vapour_Content", "MDS Vapour Content", MER_RR__2P_MDSR_14_meris_rec_data, "Level 2 MDS Total Water vapour"},
    {"Flags", "MDS Flags", MER_RR__2P_MDSR_20_meris_rec_data, "Level 2 MDS Flags"}
};

static const struct DatasetDescriptor MER_RRV_2P_dataset_data[] = {
    {"Quality_ADS", "Quality ADS", MER_RR__2P_ADSR_sq_meris_rec_data, "Level 2 Summary Quality  ADS (SQ ADS)"},
    {"Scaling_Factor_GADS", "Scaling Factor GADS", MER_RRV_2P_GADS_sfgi_meris_rec_data, "Level 2 GADS Scaling Factor and Offsets"},
    {"Tie_points_ADS", "Tie points ADS", MER_RR__1P_ADSR_tie_pt_meris_rec_data, "Level 2 ADS Tie Points Location & Aux. Data (L ADS)"},
    {"TOAVI", "MDS TOAVI", MER_RR__2P_MDSR_15_meris_rec_data, "Level 2 MDS TOA Vegetable Index"},
    {"BOAVI", "MDS BOAVI", MER_RR__2P_MDSR_17_meris_rec_data, "Level 2 MDS BOA Vegetable Index"},
    {"Flags", "MDS Flags", MER_RR__2P_MDSR_20_meris_rec_data, "Level 2 MDS Flag"}
};

static const struct DatasetDescriptor MER_RR__1P_dataset_data[] = {
    {"Quality_ADS", "Quality ADS", MER_RR__1P_ADSR_sq_meris_rec_data, "Level 1b Summary Quality ADS(SQ ADS)"},
    {"Scaling_Factor_GADS", "Scaling Factor GADS", MER_RR__1P_GADS_sfgi_meris_rec_data, "Level 1b GADS Scaling Factor and General  Info"},
    {"Tie_points_ADS", "Tie points ADS", MER_RR__1P_ADSR_tie_pt_meris_rec_data, "Level 1b ADS Tie Point Location and Auxiliary Data (LADS)"},
    {"Radiance_1", "Radiance MDS(1)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (1) TOA Radiance"},
    {"Radiance_2", "Radiance MDS(2)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (2) TOA Radiance"},
    {"Radiance_3", "Radiance MDS(3)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (3) TOA Radiance"},
    {"Radiance_4", "Radiance MDS(4)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (4) TOA Radiance"},
    {"Radiance_5", "Radiance MDS(5)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (5) TOA Radiance"},
    {"Radiance_6", "Radiance MDS(6)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (6) TOA Radiance"},
    {"Radiance_7", "Radiance MDS(7)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (7) TOA Radiance"},
    {"Radiance_8", "Radiance MDS(8)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (8) TOA Radiance"},
    {"Radiance_9", "Radiance MDS(9)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (9) TOA Radiance"},
    {"Radiance_10", "Radiance MDS(10)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (10) TOA Radiance"},
    {"Radiance_11", "Radiance MDS(11)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (11) TOA Radiance"},
    {"Radiance_12", "Radiance MDS(12)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (12) TOA Radiance"},
    {"Radiance_13", "Radiance MDS(13)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (13) TOA Radiance"},
    {"Radiance_14", "Radiance MDS(14)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (14) TOA Radiance"},
    {"Radiance_15", "Radiance MDS(15)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (15) TOA Radiance"},
    {"Flags", "Flags MDS(16)", MER_RR__1P_MDSR_16_meris_rec_data, "Level 1b MDS (16) Flags & Detector Index"}
};

static const struct DatasetDescriptor MER_RR__1P_IODD5_dataset_data[] = {
    {"Quality_ADS", "Quality ADS", MER_RR__1P_ADSR_sq_meris_rec_data, "Level 1b Summary Quality ADS(SQ ADS)"},
    {"Scaling_Factor_GADS", "Scaling Factor GADS", MER_RR__1P_GADS_sfgi_meris_rec_data, "Level 1b GADS Scaling Factor and General  Info"},
    {"Tie_points_ADS", "Tie points ADS", MER_RR__1P_ADSR_tie_pt_meris_rec_data, "Level 1b ADS Tie Point Location and Auxiliary Data (LADS)"},
    {"Radiance_1", "Radiance MDS(1)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (1) TOA Radiance"},
    {"Radiance_2", "Radiance MDS(2)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (2) TOA Radiance"},
    {"Radiance_3", "Radiance MDS(3)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (3) TOA Radiance"},
    {"Radiance_4", "Radiance MDS(4)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (4) TOA Radiance"},
    {"Radiance_5", "Radiance MDS(5)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (5) TOA Radiance"},
    {"Radiance_6", "Radiance MDS(6)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (6) TOA Radiance"},
    {"Radiance_7", "Radiance MDS(7)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (7) TOA Radiance"},
    {"Radiance_8", "Radiance MDS(8)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (8) TOA Radiance"},
    {"Radiance_9", "Radiance MDS(9)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (9) TOA Radiance"},
    {"Radiance_10", "Radiance MDS(10)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (10) TOA Radiance"},
    {"Radiance_11", "Radiance MDS(11)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (11) TOA Radiance"},
    {"Radiance_12", "Radiance MDS(12)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (12) TOA Radiance"},
    {"Radiance_13", "Radiance MDS(13)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (13) TOA Radiance"},
    {"Radiance_14", "Radiance MDS(14)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (14) TOA Radiance"},
    {"Radiance_15", "Radiance MDS(15)", MER_RR__1P_MDSR_1_15_meris_rec_data, "Level 1b MDS (15) TOA Radiance"},
    {"Flags", "Flags MDS(16)", MER_RR__1P_MDSR_16_IODD5_meris_rec_data, "Level 1b MDS (16) Flags & Spectral Shift Index"}
};

static const struct DatasetDescriptor MER_RR__2P_dataset_data[] = {
    {"Quality_ADS", "Quality ADS", MER_RR__2P_ADSR_sq_meris_rec_data, "Level 2 ADS Summary Quality (SQ ADS)"},
    {"Scaling_Factor_GADS", "Scaling Factor GADS", MER_RR__2P_GADS_sfgi_meris_rec_data, "Level 2 GADS Scaling Factors and Offsets"},
    {"Tie_points_ADS", "Tie points ADS", MER_RR__1P_ADSR_tie_pt_meris_rec_data, "Level 2 ADS Tie Points Location & Aux. Data(L ADS)"},
    {"Norm_rho_surf_1", "Norm. rho_surf - MDS(1)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(1) normalised surface reflectance"},
    {"Norm_rho_surf_2", "Norm. rho_surf - MDS(2)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(2) normalised surface reflectance"},
    {"Norm_rho_surf_3", "Norm. rho_surf - MDS(3)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(3) normalised surface reflectance"},
    {"Norm_rho_surf_4", "Norm. rho_surf - MDS(4)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(4) normalised surface reflectance"},
    {"Norm_rho_surf_5", "Norm. rho_surf - MDS(5)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(5) normalised surface reflectance"},
    {"Norm_rho_surf_6", "Norm. rho_surf - MDS(6)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(6) normalised surface reflectance"},
    {"Norm_rho_surf_7", "Norm. rho_surf - MDS(7)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(7) normalised surface reflectance"},
    {"Norm_rho_surf_8", "Norm. rho_surf - MDS(8)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(8) normalised surface reflectance"},
    {"Norm_rho_surf_9", "Norm. rho_surf - MDS(9)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(9) normalised surface reflectance"},
    {"Norm_rho_surf_10", "Norm. rho_surf - MDS(10)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(10) normalised surface reflectance"},
    {"Norm_rho_surf_11", "Norm. rho_surf - MDS(11)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(11) normalised surface reflectance"},
    {"Norm_rho_surf_12", "Norm. rho_surf - MDS(12)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(12) normalised surface reflectance"},
    {"Norm_rho_surf_13", "Norm. rho_surf - MDS(13)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(13) normalised surface reflectance"},
    {"Vapour_Content", "Vapour Content - MDS(14)", MER_RR__2P_MDSR_14_meris_rec_data, "Level 2 MDS(14) water vapour content"},
    {"Chl_1_TOAVI_CTP", "Chl_1, TOAVI   - MDS(15)", MER_RR__2P_MDSR_15_meris_rec_data, "Level 2 MDS(15) algal index I or TOAVI"},
    {"YS_SPM_Rect_rho", "YS, SPM, Rect. Rho- MDS(16)", MER_RR__2P_MDSR_16_meris_rec_data, "Level 2 MDS(16) yellow substance total suspended matter"},
    {"Chl_2_BOAVI", "Chl_2, BOAVI   - MDS(17)", MER_RR__2P_MDSR_17_meris_rec_data, "Level 2 MDS(17) algal index II  BOAVI"},
    {"Press_PAR_Alb", "Press PAR Alb  - MDS(18)", MER_RR__2P_MDSR_18_meris_rec_data, "Level 2 MDS(18) surface pressure  PAR  cloud albedo"},
    {"Alpha_OPT", "Alpha, OPT     - MDS(19)", MER_RR__2P_MDSR_19_meris_rec_data, "Level 2 MDS(19) aerosol Angstrom exponent or cloud type and optical thickness"},
    {"Flags", "Flags          - MDS(20)", MER_RR__2P_MDSR_20_meris_rec_data, "Level 2 MDS(20) flags"}
};

static const struct DatasetDescriptor MER_RR__2P_IODD6_dataset_data[] = {
    {"Quality_ADS", "Quality ADS", MER_RR__2P_ADSR_sq_meris_rec_data, "Level 2 ADS Summary Quality (SQ ADS)"},
    {"Scaling_Factor_GADS", "Scaling Factor GADS", MER_RR__2P_GADS_sfgi_meris_rec_data, "Level 2 GADS Scaling Factors and Offsets"},
    {"Tie_points_ADS", "Tie points ADS", MER_RR__1P_ADSR_tie_pt_meris_rec_data, "Level 2 ADS Tie Points Location & Aux. Data(L ADS)"},
    {"Norm_rho_surf_1", "Norm. rho_surf - MDS(1)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(1) normalised surface reflectance"},
    {"Norm_rho_surf_2", "Norm. rho_surf - MDS(2)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(2) normalised surface reflectance"},
    {"Norm_rho_surf_3", "Norm. rho_surf - MDS(3)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(3) normalised surface reflectance"},
    {"Norm_rho_surf_4", "Norm. rho_surf - MDS(4)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(4) normalised surface reflectance"},
    {"Norm_rho_surf_5", "Norm. rho_surf - MDS(5)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(5) normalised surface reflectance"},
    {"Norm_rho_surf_6", "Norm. rho_surf - MDS(6)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(6) normalised surface reflectance"},
    {"Norm_rho_surf_7", "Norm. rho_surf - MDS(7)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(7) normalised surface reflectance"},
    {"Norm_rho_surf_8", "Norm. rho_surf - MDS(8)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(8) normalised surface reflectance"},
    {"Norm_rho_surf_9", "Norm. rho_surf - MDS(9)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(9) normalised surface reflectance"},
    {"Norm_rho_surf_10", "Norm. rho_surf - MDS(10)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(10) normalised surface reflectance"},
    {"Norm_rho_surf_11", "Norm. rho_surf - MDS(11)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(11) normalised surface reflectance"},
    {"Norm_rho_surf_12", "Norm. rho_surf - MDS(12)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(12) normalised surface reflectance"},
    {"Norm_rho_surf_13", "Norm. rho_surf - MDS(13)", MER_RR__2P_MDSR_1_13_meris_rec_data, "Level 2 MDS(13) normalised surface reflectance"},
    {"Vapour_Content", "Vapour Content - MDS(14)", MER_RR__2P_MDSR_14_meris_rec_data, "Level 2 MDS(14) water vapour content"},
    {"Chl_1_TOAVI_CTP", "Chl_1, TOAVI   - MDS(15)", MER_RR__2P_MDSR_15_meris_rec_data, "Level 2 MDS(15) algal index I or TOAVI"},
    {"YS_SPM_Rect_rho", "YS, SPM, Rect. Rho- MDS(16)", MER_RR__2P_MDSR_16_meris_rec_data, "Level 2 MDS(16) yellow substance total suspended matter"},
    {"Chl_2_BOAVI", "Chl_2, BOAVI   - MDS(17)", MER_RR__2P_MDSR_17_meris_rec_data, "Level 2 MDS(17) algal index II  BOAVI"},
    {"Press_PAR_Alb", "Press PAR Alb  - MDS(18)", MER_RR__2P_MDSR_18_meris_rec_data, "Level 2 MDS(18) surface pressure  PAR  cloud albedo"},
    {"Epsilon_OPT", "Epsilon, OPT   - MDS(19)", MER_RR__2P_MDSR_19_IODD6_meris_rec_data, "Level 2 MDS(19) aerosol epsilon or cloud type and optical thickness"},
    {"Flags", "Flags          - MDS(20)", MER_RR__2P_MDSR_20_meris_rec_data, "Level 2 MDS(20) flags"}
};

static const struct BandDescriptor ASA_APG_1P_band_data[] = {
    {"slant_range_time", "GEOLOCATION_GRID_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "ns", "2 way slant range time"},
    {"incident_angle", "GEOLOCATION_GRID_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "deg", "Incident angle"},
    {"latitude", "GEOLOCATION_GRID_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "GEOLOCATION_GRID_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"proc_data_1", "MDS1.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, NULL, "Alternating Polarization Geocoded Image"},
    {"proc_data_2", "MDS2.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, NULL, "Alternating Polarization Geocoded Image"}
};

static const struct BandDescriptor ASA_APM_1P_band_data[] = {
    {"slant_range_time", "GEOLOCATION_GRID_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "ns", "2 way slant range time"},
    {"incident_angle", "GEOLOCATION_GRID_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "deg", "Incident angle"},
    {"latitude", "GEOLOCATION_GRID_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "GEOLOCATION_GRID_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"proc_data_1", "MDS1.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, NULL, "Alternating Polarization Medium Resolution Image"},
    {"proc_data_2", "MDS2.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, NULL, "Alternating Polarization Medium Resolution Image"}
};

static const struct BandDescriptor ASA_APP_1P_band_data[] = {
    {"slant_range_time", "GEOLOCATION_GRID_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "ns", "2 way slant range time"},
    {"incident_angle", "GEOLOCATION_GRID_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "deg", "Incident angle"},
    {"latitude", "GEOLOCATION_GRID_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "GEOLOCATION_GRID_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"proc_data_1", "MDS1.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, NULL, "Alternating Polarization Precision Mode Image"},
    {"proc_data_2", "MDS2.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, NULL, "Alternating Polarization Precision Mode Image"}
};

static const struct BandDescriptor ASA_APS_1P_band_data[] = {
    {"slant_range_time", "GEOLOCATION_GRID_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "ns", "2 way slant range time"},
    {"incident_angle", "GEOLOCATION_GRID_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "deg", "Incident angle"},
    {"latitude", "GEOLOCATION_GRID_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "GEOLOCATION_GRID_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"i", "MDS1.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, NULL, "Alternating Polarization SLC Image (i)"},
    {"q", "MDS2.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, NULL, "Alternating Polarization SLC Image (q)"}
};

static const struct BandDescriptor ASA_AP__BP_band_data[] = {
    {"slant_range_time", "GEOLOCATION_GRID_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "ns", "2 way slant range time"},
    {"incident_angle", "GEOLOCATION_GRID_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "deg", "Incident angle"},
    {"latitude", "GEOLOCATION_GRID_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "GEOLOCATION_GRID_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"proc_data", "MDS1.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, NULL, "Alternating Polarization Mode Browse Product"}
};

static const struct BandDescriptor ASA_IMG_1P_band_data[] = {
    {"slant_range_time", "GEOLOCATION_GRID_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "ns", "2 way slant range time"},
    {"incident_angle", "GEOLOCATION_GRID_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "deg", "Incident angle"},
    {"latitude", "GEOLOCATION_GRID_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "GEOLOCATION_GRID_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"proc_data", "MDS1.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, NULL, "Image Mode Geocoded Image"}
};

static const struct BandDescriptor ASA_IMM_1P_band_data[] = {
    {"slant_range_time", "GEOLOCATION_GRID_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "ns", "2 way slant range time"},
    {"incident_angle", "GEOLOCATION_GRID_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "deg", "Incident angle"},
    {"latitude", "GEOLOCATION_GRID_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "GEOLOCATION_GRID_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"proc_data", "MDS1.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, NULL, "Image Mode Medium Resolution Image (stripline)"}
};

static const struct BandDescriptor ASA_IMP_1P_band_data[] = {
    {"slant_range_time", "GEOLOCATION_GRID_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "ns", "2 way slant range time"},
    {"incident_angle", "GEOLOCATION_GRID_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "deg", "Incident angle"},
    {"latitude", "GEOLOCATION_GRID_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "GEOLOCATION_GRID_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"proc_data", "MDS1.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, NULL, "Image Mode Precision Image"}
};

static const struct BandDescriptor ASA_IMS_1P_band_data[] = {
    {"slant_range_time", "GEOLOCATION_GRID_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "ns", "2 way slant range time"},
    {"incident_angle", "GEOLOCATION_GRID_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "deg", "Incident angle"},
    {"latitude", "GEOLOCATION_GRID_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "GEOLOCATION_GRID_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"i", "MDS1.4", e_smod_1OF2, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, NULL, "Image Mode SLC Image (i)"},
    {"q", "MDS1.4", e_smod_2OF2, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, NULL, "Image Mode SLC Image (q)"}
};

static const struct BandDescriptor ASA_IM__BP_band_data[] = {
    {"slant_range_time", "GEOLOCATION_GRID_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "ns", "2 way slant range time"},
    {"incident_angle", "GEOLOCATION_GRID_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "deg", "Incident angle"},
    {"latitude", "GEOLOCATION_GRID_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "GEOLOCATION_GRID_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"proc_data", "MDS1.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, NULL, "Image Mode Browse Image"}
};

static const struct BandDescriptor ASA_WSM_1P_band_data[] = {
    {"slant_range_time", "GEOLOCATION_GRID_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "ns", "2 way slant range time"},
    {"incident_angle", "GEOLOCATION_GRID_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "deg", "Incident angle"},
    {"latitude", "GEOLOCATION_GRID_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "GEOLOCATION_GRID_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"proc_data", "MDS1.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, NULL, "Wide Swath Mode Medium Resolution Image"}
};

static const struct BandDescriptor ASA_WS__BP_band_data[] = {
    {"slant_range_time", "GEOLOCATION_GRID_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "ns", "2 way slant range time"},
    {"incident_angle", "GEOLOCATION_GRID_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "deg", "Incident angle"},
    {"latitude", "GEOLOCATION_GRID_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "GEOLOCATION_GRID_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"proc_data", "MDS1.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, NULL, "Alternating Polarization Mode Browse Product"}
};

static const struct BandDescriptor ATS_NR__2P_band_data[] = {
    {"latitude", "GEOLOCATION_ADS.5", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitudes"},
    {"longitude", "GEOLOCATION_ADS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitudes"},
    {"lat_corr_nadir", "GEOLOCATION_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude corrections, nadir view"},
    {"lon_corr_nadir", "GEOLOCATION_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude corrections, nadir view"},
    {"lat_corr_fward", "GEOLOCATION_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude corrections, forward view"},
    {"lon_corr_fward", "GEOLOCATION_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude corrections, forward view"},
    {"altitude", "GEOLOCATION_ADS.11", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "m", "Topographic altitude"},
    {"sun_elev_nadir", "NADIR_VIEW_SOLAR_ANGLES_ADS.5", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-03", NULL, NULL, "deg", "Solar elevation nadir view"},
    {"view_elev_nadir", "NADIR_VIEW_SOLAR_ANGLES_ADS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-03", NULL, NULL, "deg", "Satellite elevation nadir view"},
    {"sun_azimuth_nadir", "NADIR_VIEW_SOLAR_ANGLES_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-03", NULL, NULL, "deg", "Solar azimuth nadir view"},
    {"view_azimuth_nadir", "NADIR_VIEW_SOLAR_ANGLES_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-03", NULL, NULL, "deg", "Satellite azimuth nadir view"},
    {"sun_elev_fward", "FWARD_VIEW_SOLAR_ANGLES_ADS.5", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-03", NULL, NULL, "deg", "Solar elevation forward view"},
    {"view_elev_fward", "FWARD_VIEW_SOLAR_ANGLES_ADS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-03", NULL, NULL, "deg", "Satellite elevation forward view"},
    {"sun_azimuth_fward", "FWARD_VIEW_SOLAR_ANGLES_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-03", NULL, NULL, "deg", "Solar azimuth forward view"},
    {"view_azimuth_fward", "FWARD_VIEW_SOLAR_ANGLES_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-03", NULL, NULL, "deg", "Satellite azimuth forward view"},
    {"sst_nadir", "DISTRIB_SST_CLOUD_LAND_MDS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.01", "!flags.NADIR_CLOUD and !flags.LAND", NULL, "K", "Sea surface temperature nadir view"},
    {"sst_comb", "DISTRIB_SST_CLOUD_LAND_MDS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.01", "!flags.NADIR_CLOUD and !flags.LAND", NULL, "K", "Sea surface temperature combined views"},
    {"cloud_top_temp", "DISTRIB_SST_CLOUD_LAND_MDS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.01", "flags.NADIR_CLOUD", NULL, "K", "Cloud top temperature"},
    {"cloud_top_height", "DISTRIB_SST_CLOUD_LAND_MDS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.01", "flags.NADIR_CLOUD", NULL, "m", "Cloud top height"},
    {"lst", "DISTRIB_SST_CLOUD_LAND_MDS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.01", "!flags.NADIR_CLOUD and flags.LAND", NULL, "K", "Land surface temperature"},
    {"ndvi", "DISTRIB_SST_CLOUD_LAND_MDS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.0001", "!flags.NADIR_CLOUD and flags.LAND", NULL, NULL, "Normalized difference vegetation index"},
    {"flags", "DISTRIB_SST_CLOUD_LAND_MDS.5", e_smod_1OF1, e_tid_ushort, -1, e_smid_non, NULL, NULL, NULL, "ATS_NR__2P_flags", NULL, "Classification and quality flags"}
};

static const struct BandDescriptor ATS_TOA_1P_band_data[] = {
    {"latitude", "GEOLOCATION_ADS.5", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitudes"},
    {"longitude", "GEOLOCATION_ADS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitudes"},
    {"lat_corr_nadir", "GEOLOCATION_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude corrections, nadir view"},
    {"lon_corr_nadir", "GEOLOCATION_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude corrections, nadir view"},
    {"lat_corr_fward", "GEOLOCATION_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude corrections, forward view"},
    {"lon_corr_fward", "GEOLOCATION_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude corrections, forward view"},
    {"altitude", "GEOLOCATION_ADS.11", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "m", "Topographic altitude"},
    {"sun_elev_nadir", "NADIR_VIEW_SOLAR_ANGLES_ADS.5", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-03", NULL, NULL, "deg", "Solar elevation, nadir view"},
    {"view_elev_nadir", "NADIR_VIEW_SOLAR_ANGLES_ADS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-03", NULL, NULL, "deg", "Satellite elevation, nadir view"},
    {"sun_azimuth_nadir", "NADIR_VIEW_SOLAR_ANGLES_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-03", NULL, NULL, "deg", "Solar azimuth, nadir view"},
    {"view_azimuth_nadir", "NADIR_VIEW_SOLAR_ANGLES_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-03", NULL, NULL, "deg", "Satellite azimuth, nadir view"},
    {"sun_elev_fward", "FWARD_VIEW_SOLAR_ANGLES_ADS.5", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-03", NULL, NULL, "deg", "Solar elevation, forward view"},
    {"view_elev_fward", "FWARD_VIEW_SOLAR_ANGLES_ADS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-03", NULL, NULL, "deg", "Satellite elevation, forward view"},
    {"sun_azimuth_fward", "FWARD_VIEW_SOLAR_ANGLES_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-03", NULL, NULL, "deg", "Solar azimuth, forward view"},
    {"view_azimuth_fward", "FWARD_VIEW_SOLAR_ANGLES_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-03", NULL, NULL, "deg", "Satellite azimuth, forward view"},
    {"btemp_nadir_1200", "11500_12500_NM_NADIR_TOA_MDS.5", e_smod_1OF1, e_tid_float, 7, e_smid_lin, "0.0", "0.01", NULL, NULL, "K", "Brightness temperature, nadir view (11500-12500 nm)"},
    {"btemp_nadir_1100", "10400_11300_NM_NADIR_TOA_MDS.5", e_smod_1OF1, e_tid_float, 6, e_smid_lin, "0.0", "0.01", NULL, NULL, "K", "Brightness temperature, nadir view (10400-11300 nm)"},
    {"btemp_nadir_0370", "03505_03895_NM_NADIR_TOA_MDS.5", e_smod_1OF1, e_tid_float, 5, e_smid_lin, "0.0", "0.01", NULL, NULL, "K", "Brightness temperature, nadir view (3505-3895 nm)"},
    {"reflec_nadir_1600", "01580_01640_NM_NADIR_TOA_MDS.5", e_smod_1OF1, e_tid_float, 4, e_smid_lin, "0.0", "0.01", NULL, NULL, "%", "Refectance, nadir view (1580-1640 nm)"},
    {"reflec_nadir_0870", "00855_00875_NM_NADIR_TOA_MDS.5", e_smod_1OF1, e_tid_float, 3, e_smid_lin, "0.0", "0.01", NULL, NULL, "%", "Refectance, nadir view (855-875 nm)"},
    {"reflec_nadir_0670", "00649_00669_NM_NADIR_TOA_MDS.5", e_smod_1OF1, e_tid_float, 2, e_smid_lin, "0.0", "0.01", NULL, NULL, "%", "Refectance, nadir view (649-669 nm)"},
    {"reflec_nadir_0550", "00545_00565_NM_NADIR_TOA_MDS.5", e_smod_1OF1, e_tid_float, 1, e_smid_lin, "0.0", "0.01", NULL, NULL, "%", "Refectance, nadir view (545-565 nm)"},
    {"btemp_fward_1200", "11500_12500_NM_FWARD_TOA_MDS.5", e_smod_1OF1, e_tid_float, 7, e_smid_lin, "0.0", "0.01", NULL, NULL, "K", "Brightness temperature, forward view (11500-12500 nm)"},
    {"btemp_fward_1100", "10400_11300_NM_FWARD_TOA_MDS.5", e_smod_1OF1, e_tid_float, 6, e_smid_lin, "0.0", "0.01", NULL, NULL, "K", "Brightness temperature, forward view (10400-11300 nm)"},
    {"btemp_fward_0370", "03505_03895_NM_FWARD_TOA_MDS.5", e_smod_1OF1, e_tid_float, 5, e_smid_lin, "0.0", "0.01", NULL, NULL, "K", "Brightness temperature, forward view (3505-3895 nm)"},
    {"reflec_fward_1600", "01580_01640_NM_FWARD_TOA_MDS.5", e_smod_1OF1, e_tid_float, 4, e_smid_lin, "0.0", "0.01", NULL, NULL, "%", "Refectance, forward view (1580-1640 nm)"},
    {"reflec_fward_0870", "00855_00875_NM_FWARD_TOA_MDS.5", e_smod_1OF1, e_tid_float, 3, e_smid_lin, "0.0", "0.01", NULL, NULL, "%", "Refectance, forward view (855-875 nm)"},
    {"reflec_fward_0670", "00649_00669_NM_FWARD_TOA_MDS.5", e_smod_1OF1, e_tid_float, 2, e_smid_lin, "0.0", "0.01", NULL, NULL, "%", "Refectance, forward view (649-669 nm)"},
    {"reflec_fward_0550", "00545_00565_NM_FWARD_TOA_MDS.5", e_smod_1OF1, e_tid_float, 1, e_smid_lin, "0.0", "0.01", NULL, NULL, "%", "Refectance, forward view (545-565 nm)"},
    {"confid_flags_nadir", "NADIR_VIEW_CONFIDENCE_MDS.5", e_smod_1OF1, e_tid_ushort, -1, e_smid_non, NULL, NULL, NULL, "ATS_TOA_1P_confid_flags", NULL, "Confidence flags, nadir view"},
    {"confid_flags_fward", "FWARD_VIEW_CONFIDENCE_MDS.5", e_smod_1OF1, e_tid_ushort, -1, e_smid_non, NULL, NULL, NULL, "ATS_TOA_1P_confid_flags", NULL, "Confidence flags, forward view"},
    {"cloud_flags_nadir", "NADIR_VIEW_CLOUD_MDS.5", e_smod_1OF1, e_tid_ushort, -1, e_smid_non, NULL, NULL, NULL, "ATS_TOA_1P_cloud_flags", NULL, "Cloud flags, nadir view"},
    {"cloud_flags_fward", "FWARD_VIEW_CLOUD_MDS.5", e_smod_1OF1, e_tid_ushort, -1, e_smid_non, NULL, NULL, NULL, "ATS_TOA_1P_cloud_flags", NULL, "Cloud flags, forward view"}
};

static const struct BandDescriptor MER_FR__1P_band_data[] = {
    {"latitude", "Tie_points_ADS.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "Tie_points_ADS.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"dem_alt", "Tie_points_ADS.5", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.1.1", NULL, NULL, "m", "Digital elevation model altitude"},
    {"dem_rough", "Tie_points_ADS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.2.1", NULL, NULL, "m", "Digital elevation model roughness"},
    {"lat_corr", "Tie_points_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model latitude corrections"},
    {"lon_corr", "Tie_points_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model longitude corrections"},
    {"sun_zenith", "Tie_points_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun zenith angle"},
    {"sun_azimuth", "Tie_points_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun azimuth angles"},
    {"view_zenith", "Tie_points_ADS.11", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing zenith angles"},
    {"view_azimuth", "Tie_points_ADS.12", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing azimuth angles"},
    {"zonal_wind", "Tie_points_ADS.13", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.3.1", NULL, NULL, "m/s", "Zonal wind"},
    {"merid_wind", "Tie_points_ADS.14", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.4.1", NULL, NULL, "m/s", "Meridional wind"},
    {"atm_press", "Tie_points_ADS.15", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.5.1", NULL, NULL, "hPa", "Mean sea level pressure"},
    {"ozone", "Tie_points_ADS.16", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.6.1", NULL, NULL, "DU", "Total ozone"},
    {"rel_hum", "Tie_points_ADS.17", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.7.1", NULL, NULL, "%", "Relative humidity"},
    {"radiance_1", "Radiance_1.3", e_smod_1OF1, e_tid_float, 1, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.1", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 1"},
    {"radiance_2", "Radiance_2.3", e_smod_1OF1, e_tid_float, 2, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.2", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 2"},
    {"radiance_3", "Radiance_3.3", e_smod_1OF1, e_tid_float, 3, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.3", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 3"},
    {"radiance_4", "Radiance_4.3", e_smod_1OF1, e_tid_float, 4, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.4", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 4"},
    {"radiance_5", "Radiance_5.3", e_smod_1OF1, e_tid_float, 5, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.5", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 5"},
    {"radiance_6", "Radiance_6.3", e_smod_1OF1, e_tid_float, 6, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.6", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 6"},
    {"radiance_7", "Radiance_7.3", e_smod_1OF1, e_tid_float, 7, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.7", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 7"},
    {"radiance_8", "Radiance_8.3", e_smod_1OF1, e_tid_float, 8, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.8", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 8"},
    {"radiance_9", "Radiance_9.3", e_smod_1OF1, e_tid_float, 9, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.9", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 9"},
    {"radiance_10", "Radiance_10.3", e_smod_1OF1, e_tid_float, 10, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.10", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 10"},
    {"radiance_11", "Radiance_11.3", e_smod_1OF1, e_tid_float, 11, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.11", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 11"},
    {"radiance_12", "Radiance_12.3", e_smod_1OF1, e_tid_float, 12, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.12", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 12"},
    {"radiance_13", "Radiance_13.3", e_smod_1OF1, e_tid_float, 13, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.13", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 13"},
    {"radiance_14", "Radiance_14.3", e_smod_1OF1, e_tid_float, 14, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.14", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 14"},
    {"radiance_15", "Radiance_15.3", e_smod_1OF1, e_tid_float, 15, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.15", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 15"},
    {"l1_flags", "Flags.3", e_smod_1OF1, e_tid_uchar, -1, e_smid_non, NULL, NULL, NULL, "MER_RR__1P_flags", NULL, "Level 1b classification and quality flags"},
    {"detector_index", "Flags.4", e_smod_1OF1, e_tid_short, -1, e_smid_non, NULL, NULL, NULL, NULL, NULL, "Detector index"}
};

static const struct BandDescriptor MER_FR__1P_IODD5_band_data[] = {
    {"latitude", "Tie_points_ADS.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "Tie_points_ADS.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"dem_alt", "Tie_points_ADS.5", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.1.1", NULL, NULL, "m", "Digital elevation model altitude"},
    {"dem_rough", "Tie_points_ADS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.2.1", NULL, NULL, "m", "Digital elevation model roughness"},
    {"lat_corr", "Tie_points_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model latitude corrections"},
    {"lon_corr", "Tie_points_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model longitude corrections"},
    {"sun_zenith", "Tie_points_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun zenith angle"},
    {"sun_azimuth", "Tie_points_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun azimuth angles"},
    {"view_zenith", "Tie_points_ADS.11", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing zenith angles"},
    {"view_azimuth", "Tie_points_ADS.12", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing azimuth angles"},
    {"zonal_wind", "Tie_points_ADS.13", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.3.1", NULL, NULL, "m/s", "Zonal wind"},
    {"merid_wind", "Tie_points_ADS.14", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.4.1", NULL, NULL, "m/s", "Meridional wind"},
    {"atm_press", "Tie_points_ADS.15", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.5.1", NULL, NULL, "hPa", "Mean sea level pressure"},
    {"ozone", "Tie_points_ADS.16", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.6.1", NULL, NULL, "DU", "Total ozone"},
    {"rel_hum", "Tie_points_ADS.17", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.7.1", NULL, NULL, "%", "Relative humidity"},
    {"radiance_1", "Radiance_1.3", e_smod_1OF1, e_tid_float, 1, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.1", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 1"},
    {"radiance_2", "Radiance_2.3", e_smod_1OF1, e_tid_float, 2, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.2", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 2"},
    {"radiance_3", "Radiance_3.3", e_smod_1OF1, e_tid_float, 3, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.3", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 3"},
    {"radiance_4", "Radiance_4.3", e_smod_1OF1, e_tid_float, 4, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.4", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 4"},
    {"radiance_5", "Radiance_5.3", e_smod_1OF1, e_tid_float, 5, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.5", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 5"},
    {"radiance_6", "Radiance_6.3", e_smod_1OF1, e_tid_float, 6, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.6", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 6"},
    {"radiance_7", "Radiance_7.3", e_smod_1OF1, e_tid_float, 7, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.7", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 7"},
    {"radiance_8", "Radiance_8.3", e_smod_1OF1, e_tid_float, 8, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.8", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 8"},
    {"radiance_9", "Radiance_9.3", e_smod_1OF1, e_tid_float, 9, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.9", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 9"},
    {"radiance_10", "Radiance_10.3", e_smod_1OF1, e_tid_float, 10, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.10", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 10"},
    {"radiance_11", "Radiance_11.3", e_smod_1OF1, e_tid_float, 11, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.11", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 11"},
    {"radiance_12", "Radiance_12.3", e_smod_1OF1, e_tid_float, 12, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.12", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 12"},
    {"radiance_13", "Radiance_13.3", e_smod_1OF1, e_tid_float, 13, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.13", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 13"},
    {"radiance_14", "Radiance_14.3", e_smod_1OF1, e_tid_float, 14, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.14", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 14"},
    {"radiance_15", "Radiance_15.3", e_smod_1OF1, e_tid_float, 15, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.15", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 15"},
    {"l1_flags", "Flags.3", e_smod_1OF2, e_tid_uchar, -1, e_smid_non, NULL, NULL, NULL, "MER_RR__1P_flags", NULL, "Level 1b classification and quality flags"},
    {"ssi", "Flags.3", e_smod_2OF2, e_tid_uchar, -1, e_smid_non, NULL, NULL, NULL, NULL, NULL, "Spectral shift index"}
};

static const struct BandDescriptor MER_FR__2P_band_data[] = {
    {"latitude", "Tie_points_ADS.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "Tie_points_ADS.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"dem_alt", "Tie_points_ADS.5", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.1.1", NULL, NULL, "m", "Digital elevation model altitude"},
    {"dem_rough", "Tie_points_ADS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.2.1", NULL, NULL, "m", "Digital elevation model roughness"},
    {"lat_corr", "Tie_points_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model latitude corrections"},
    {"lon_corr", "Tie_points_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model longitude corrections"},
    {"sun_zenith", "Tie_points_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun zenith angle"},
    {"sun_azimuth", "Tie_points_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun azimuth angles"},
    {"view_zenith", "Tie_points_ADS.11", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing zenith angles"},
    {"view_azimuth", "Tie_points_ADS.12", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing azimuth angles"},
    {"zonal_wind", "Tie_points_ADS.13", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.3.1", NULL, NULL, "m/s", "Zonal wind"},
    {"merid_wind", "Tie_points_ADS.14", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.4.1", NULL, NULL, "m/s", "Meridional wind"},
    {"atm_press", "Tie_points_ADS.15", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.5.1", NULL, NULL, "hPa", "Mean sea level pressure"},
    {"ozone", "Tie_points_ADS.16", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.6.1", NULL, NULL, "DU", "Total ozone"},
    {"rel_hum", "Tie_points_ADS.17", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.7.1", NULL, NULL, "%", "Relative humidity"},
    {"reflec_1", "Norm_rho_surf_1.3", e_smod_1OF1, e_tid_float, 1, e_smid_lin, "Scaling_Factor_GADS.22.1", "Scaling_Factor_GADS.8.1", NULL, NULL, "dl", "Normalized surface reflectance, band 1"},
    {"reflec_2", "Norm_rho_surf_2.3", e_smod_1OF1, e_tid_float, 2, e_smid_lin, "Scaling_Factor_GADS.22.2", "Scaling_Factor_GADS.8.2", NULL, NULL, "dl", "Normalized surface reflectance, band 2"},
    {"reflec_3", "Norm_rho_surf_3.3", e_smod_1OF1, e_tid_float, 3, e_smid_lin, "Scaling_Factor_GADS.22.3", "Scaling_Factor_GADS.8.3", NULL, NULL, "dl", "Normalized surface reflectance, band 3"},
    {"reflec_4", "Norm_rho_surf_4.3", e_smod_1OF1, e_tid_float, 4, e_smid_lin, "Scaling_Factor_GADS.22.4", "Scaling_Factor_GADS.8.4", NULL, NULL, "dl", "Normalized surface reflectance, band 4"},
    {"reflec_5", "Norm_rho_surf_5.3", e_smod_1OF1, e_tid_float, 5, e_smid_lin, "Scaling_Factor_GADS.22.5", "Scaling_Factor_GADS.8.5", NULL, NULL, "dl", "Normalized surface reflectance, band 5"},
    {"reflec_6", "Norm_rho_surf_6.3", e_smod_1OF1, e_tid_float, 6, e_smid_lin, "Scaling_Factor_GADS.22.6", "Scaling_Factor_GADS.8.6", NULL, NULL, "dl", "Normalized surface reflectance, band 6"},
    {"reflec_7", "Norm_rho_surf_7.3", e_smod_1OF1, e_tid_float, 7, e_smid_lin, "Scaling_Factor_GADS.22.7", "Scaling_Factor_GADS.8.7", NULL, NULL, "dl", "Normalized surface reflectance, band 7"},
    {"reflec_8", "Norm_rho_surf_8.3", e_smod_1OF1, e_tid_float, 8, e_smid_lin, "Scaling_Factor_GADS.22.8", "Scaling_Factor_GADS.8.8", NULL, NULL, "dl", "Normalized surface reflectance, band 8"},
    {"reflec_9", "Norm_rho_surf_9.3", e_smod_1OF1, e_tid_float, 9, e_smid_lin, "Scaling_Factor_GADS.22.9", "Scaling_Factor_GADS.8.9", NULL, NULL, "dl", "Normalized surface reflectance, band 9"},
    {"reflec_10", "Norm_rho_surf_10.3", e_smod_1OF1, e_tid_float, 10, e_smid_lin, "Scaling_Factor_GADS.22.10", "Scaling_Factor_GADS.8.10", NULL, NULL, "dl", "Normalized surface reflectance, band 10"},
    {"reflec_12", "Norm_rho_surf_11.3", e_smod_1OF1, e_tid_float, 12, e_smid_lin, "Scaling_Factor_GADS.22.11", "Scaling_Factor_GADS.8.11", NULL, NULL, "dl", "Normalized surface reflectance, band 12"},
    {"reflec_13", "Norm_rho_surf_12.3", e_smod_1OF1, e_tid_float, 13, e_smid_lin, "Scaling_Factor_GADS.22.12", "Scaling_Factor_GADS.8.12", NULL, NULL, "dl", "Normalized surface reflectance, band 13"},
    {"reflec_14", "Norm_rho_surf_13.3", e_smod_1OF1, e_tid_float, 14, e_smid_lin, "Scaling_Factor_GADS.22.13", "Scaling_Factor_GADS.8.13", NULL, NULL, "dl", "Normalized surface reflectance, band 14"},
    {"water_vapour", "Vapour_Content.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.30.1", "Scaling_Factor_GADS.16.1", NULL, NULL, "g/cm^2", "Water vapour content"},
    {"algal_1", "Chl_1_TOAVI_CTP.3", e_smod_1OF1, e_tid_float, -1, e_smid_log, "Scaling_Factor_GADS.23.1", "Scaling_Factor_GADS.9.1", "l2_flags.WATER", NULL, "mg/m^3", "Chlorophyll 1 content"},
    {"algal_2", "Chl_2_BOAVI.3", e_smod_1OF1, e_tid_float, -1, e_smid_log, "Scaling_Factor_GADS.23.1", "Scaling_Factor_GADS.9.1", "l2_flags.WATER", NULL, "mg/m^3", "Chlorophyll 2 content"},
    {"yellow_subs", "YS_SPM_Rect_rho.3", e_smod_1OF2, e_tid_float, -1, e_smid_log, "Scaling_Factor_GADS.24.1", "Scaling_Factor_GADS.10.1", "l2_flags.WATER", NULL, "1/m", "Yellow substance"},
    {"total_susp", "YS_SPM_Rect_rho.3", e_smod_2OF2, e_tid_float, -1, e_smid_log, "Scaling_Factor_GADS.25.1", "Scaling_Factor_GADS.11.1", "l2_flags.WATER", NULL, "g/m^3", "Total suspended matter"},
    {"photosyn_rad", "Press_PAR_Alb.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.31.1", "Scaling_Factor_GADS.17.1", "l2_flags.WATER", NULL, "myEinstein/(m^2*s)", "Photosynthetically active radiation"},
    {"toa_veg", "Chl_1_TOAVI_CTP.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.32.1", "Scaling_Factor_GADS.18.1", "l2_flags.LAND", NULL, "1", "MGVI - MERIS global vegetation index"},
    {"boa_veg", "Chl_2_BOAVI.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.33.1", "Scaling_Factor_GADS.19.1", "l2_flags.LAND", NULL, "1", "MTCI - MERIS terrestrial chlorophyll index"},
    {"rect_refl_red", "YS_SPM_Rect_rho.3", e_smod_1OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.40.1", "Scaling_Factor_GADS.39.1", "l2_flags.LAND", NULL, "dl", "Rectified reflectance in a red band"},
    {"rect_refl_nir", "YS_SPM_Rect_rho.3", e_smod_2OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.42.1", "Scaling_Factor_GADS.41.1", "l2_flags.LAND", NULL, "dl", "Rectified reflectances in a near infrared band"},
    {"surf_press", "Press_PAR_Alb.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.29.1", "Scaling_Factor_GADS.15.1", "l2_flags.LAND", NULL, "hPa", "Surface pressure"},
    {"aero_alpha", "Alpha_OPT.3", e_smod_1OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.26.1", "Scaling_Factor_GADS.12.1", "!l2_flags.CLOUD", NULL, "dl", "Aerosol Angstrom exponent"},
    {"aero_opt_thick_443", "Alpha_OPT.3", e_smod_2OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.27.1", "Scaling_Factor_GADS.13.1", "!l2_flags.LAND", NULL, "dl", "Aerosol optical thickness at 443 nm"},
    {"aero_opt_thick_865", "Alpha_OPT.3", e_smod_2OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.27.1", "Scaling_Factor_GADS.13.1", "!l2_flags.WATER", NULL, "dl", "Aerosol optical thickness at 865 nm"},
    {"cloud_albedo", "Press_PAR_Alb.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.34.1", "Scaling_Factor_GADS.20.1", "l2_flags.CLOUD", NULL, "dl", "Cloud albedo"},
    {"cloud_opt_thick", "Alpha_OPT.3", e_smod_2OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.28.1", "Scaling_Factor_GADS.14.1", "l2_flags.CLOUD", NULL, "dl", "Cloud optical thickness"},
    {"cloud_top_press", "Chl_1_TOAVI_CTP.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.35.1", "Scaling_Factor_GADS.21.1", "l2_flags.CLOUD", NULL, "hPa", "Cloud top pressure"},
    {"cloud_type", "Alpha_OPT.3", e_smod_1OF2, e_tid_uchar, -1, e_smid_non, NULL, NULL, "l2_flags.CLOUD", NULL, NULL, "Cloud type"},
    {"l2_flags", "Flags.3", e_smod_3TOI, e_tid_uint, -1, e_smid_non, NULL, NULL, NULL, "MER_RR__2P_flags", NULL, "Level 2 classification and quality flags"}
};

static const struct BandDescriptor MER_FR__2P_IODD6_band_data[] = {
    {"latitude", "Tie_points_ADS.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "Tie_points_ADS.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"dem_alt", "Tie_points_ADS.5", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.1.1", NULL, NULL, "m", "Digital elevation model altitude"},
    {"dem_rough", "Tie_points_ADS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.2.1", NULL, NULL, "m", "Digital elevation model roughness"},
    {"lat_corr", "Tie_points_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model latitude corrections"},
    {"lon_corr", "Tie_points_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model longitude corrections"},
    {"sun_zenith", "Tie_points_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun zenith angle"},
    {"sun_azimuth", "Tie_points_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun azimuth angles"},
    {"view_zenith", "Tie_points_ADS.11", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing zenith angles"},
    {"view_azimuth", "Tie_points_ADS.12", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing azimuth angles"},
    {"zonal_wind", "Tie_points_ADS.13", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.3.1", NULL, NULL, "m/s", "Zonal wind"},
    {"merid_wind", "Tie_points_ADS.14", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.4.1", NULL, NULL, "m/s", "Meridional wind"},
    {"atm_press", "Tie_points_ADS.15", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.5.1", NULL, NULL, "hPa", "Mean sea level pressure"},
    {"ozone", "Tie_points_ADS.16", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.6.1", NULL, NULL, "DU", "Total ozone"},
    {"rel_hum", "Tie_points_ADS.17", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.7.1", NULL, NULL, "%", "Relative humidity"},
    {"reflec_1", "Norm_rho_surf_1.3", e_smod_1OF1, e_tid_float, 1, e_smid_lin, "Scaling_Factor_GADS.22.1", "Scaling_Factor_GADS.8.1", NULL, NULL, "dl", "Normalized surface reflectance, band 1"},
    {"reflec_2", "Norm_rho_surf_2.3", e_smod_1OF1, e_tid_float, 2, e_smid_lin, "Scaling_Factor_GADS.22.2", "Scaling_Factor_GADS.8.2", NULL, NULL, "dl", "Normalized surface reflectance, band 2"},
    {"reflec_3", "Norm_rho_surf_3.3", e_smod_1OF1, e_tid_float, 3, e_smid_lin, "Scaling_Factor_GADS.22.3", "Scaling_Factor_GADS.8.3", NULL, NULL, "dl", "Normalized surface reflectance, band 3"},
    {"reflec_4", "Norm_rho_surf_4.3", e_smod_1OF1, e_tid_float, 4, e_smid_lin, "Scaling_Factor_GADS.22.4", "Scaling_Factor_GADS.8.4", NULL, NULL, "dl", "Normalized surface reflectance, band 4"},
    {"reflec_5", "Norm_rho_surf_5.3", e_smod_1OF1, e_tid_float, 5, e_smid_lin, "Scaling_Factor_GADS.22.5", "Scaling_Factor_GADS.8.5", NULL, NULL, "dl", "Normalized surface reflectance, band 5"},
    {"reflec_6", "Norm_rho_surf_6.3", e_smod_1OF1, e_tid_float, 6, e_smid_lin, "Scaling_Factor_GADS.22.6", "Scaling_Factor_GADS.8.6", NULL, NULL, "dl", "Normalized surface reflectance, band 6"},
    {"reflec_7", "Norm_rho_surf_7.3", e_smod_1OF1, e_tid_float, 7, e_smid_lin, "Scaling_Factor_GADS.22.7", "Scaling_Factor_GADS.8.7", NULL, NULL, "dl", "Normalized surface reflectance, band 7"},
    {"reflec_8", "Norm_rho_surf_8.3", e_smod_1OF1, e_tid_float, 8, e_smid_lin, "Scaling_Factor_GADS.22.8", "Scaling_Factor_GADS.8.8", NULL, NULL, "dl", "Normalized surface reflectance, band 8"},
    {"reflec_9", "Norm_rho_surf_9.3", e_smod_1OF1, e_tid_float, 9, e_smid_lin, "Scaling_Factor_GADS.22.9", "Scaling_Factor_GADS.8.9", NULL, NULL, "dl", "Normalized surface reflectance, band 9"},
    {"reflec_10", "Norm_rho_surf_10.3", e_smod_1OF1, e_tid_float, 10, e_smid_lin, "Scaling_Factor_GADS.22.10", "Scaling_Factor_GADS.8.10", NULL, NULL, "dl", "Normalized surface reflectance, band 10"},
    {"reflec_12", "Norm_rho_surf_11.3", e_smod_1OF1, e_tid_float, 12, e_smid_lin, "Scaling_Factor_GADS.22.11", "Scaling_Factor_GADS.8.11", NULL, NULL, "dl", "Normalized surface reflectance, band 12"},
    {"reflec_13", "Norm_rho_surf_12.3", e_smod_1OF1, e_tid_float, 13, e_smid_lin, "Scaling_Factor_GADS.22.12", "Scaling_Factor_GADS.8.12", NULL, NULL, "dl", "Normalized surface reflectance, band 13"},
    {"reflec_14", "Norm_rho_surf_13.3", e_smod_1OF1, e_tid_float, 14, e_smid_lin, "Scaling_Factor_GADS.22.13", "Scaling_Factor_GADS.8.13", NULL, NULL, "dl", "Normalized surface reflectance, band 14"},
    {"water_vapour", "Vapour_Content.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.30.1", "Scaling_Factor_GADS.16.1", NULL, NULL, "g/cm^2", "Water vapour content"},
    {"algal_1", "Chl_1_TOAVI_CTP.3", e_smod_1OF1, e_tid_float, -1, e_smid_log, "Scaling_Factor_GADS.23.1", "Scaling_Factor_GADS.9.1", "l2_flags.WATER", NULL, "mg/m^3", "Chlorophyll 1 content"},
    {"algal_2", "Chl_2_BOAVI.3", e_smod_1OF1, e_tid_float, -1, e_smid_log, "Scaling_Factor_GADS.23.1", "Scaling_Factor_GADS.9.1", "l2_flags.WATER", NULL, "mg/m^3", "Chlorophyll 2 content"},
    {"yellow_subs", "YS_SPM_Rect_rho.3", e_smod_1OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.24.1", "Scaling_Factor_GADS.10.1", "l2_flags.WATER", NULL, "1/m", "Yellow substance"},
    {"total_susp", "YS_SPM_Rect_rho.3", e_smod_2OF2, e_tid_float, -1, e_smid_log, "Scaling_Factor_GADS.25.1", "Scaling_Factor_GADS.11.1", "l2_flags.WATER", NULL, "g/m^3", "Total suspended matter"},
    {"photosyn_rad", "Press_PAR_Alb.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.31.1", "Scaling_Factor_GADS.17.1", "l2_flags.WATER", NULL, "myEinstein/m^2", "Photosynthetically active radiation"},
    {"toa_veg", "Chl_1_TOAVI_CTP.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.32.1", "Scaling_Factor_GADS.18.1", "l2_flags.LAND", NULL, "1", "TOA vegetation index"},
    {"boa_veg", "Chl_2_BOAVI.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.33.1", "Scaling_Factor_GADS.19.1", "l2_flags.LAND", NULL, "1", "BOA vegetation index"},
    {"rect_refl_nir", "YS_SPM_Rect_rho.3", e_smod_1OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.40.1", "Scaling_Factor_GADS.39.1", "l2_flags.LAND", NULL, "dl", "Rectified surface reflectances"},
    {"rect_refl_red", "YS_SPM_Rect_rho.3", e_smod_2OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.42.1", "Scaling_Factor_GADS.41.1", "l2_flags.LAND", NULL, "dl", "Rectified surface reflectances"},
    {"surf_press", "Press_PAR_Alb.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.29.1", "Scaling_Factor_GADS.15.1", "l2_flags.LAND", NULL, "hPa", "Surface pressure"},
    {"aero_epsilon", "Epsilon_OPT.3", e_smod_1OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.26.1", "Scaling_Factor_GADS.12.1", "!l2_flags.CLOUD", NULL, "dl", "Aerosol epsilon"},
    {"aero_opt_thick", "Epsilon_OPT.3", e_smod_2OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.27.1", "Scaling_Factor_GADS.13.1", "!l2_flags.CLOUD", NULL, "dl", "Aerosol optical thickness"},
    {"cloud_albedo", "Press_PAR_Alb.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.34.1", "Scaling_Factor_GADS.20.1", "l2_flags.CLOUD", NULL, "dl", "Cloud albedo"},
    {"cloud_opt_thick", "Epsilon_OPT.3", e_smod_2OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.28.1", "Scaling_Factor_GADS.14.1", "l2_flags.CLOUD", NULL, "dl", "Cloud optical thickness"},
    {"cloud_top_press", "Chl_1_TOAVI_CTP.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.35.1", "Scaling_Factor_GADS.21.1", "l2_flags.CLOUD", NULL, "hPa", "Cloud top pressure"},
    {"cloud_type", "Epsilon_OPT.3", e_smod_1OF2, e_tid_uchar, -1, e_smid_non, NULL, NULL, "l2_flags.CLOUD", NULL, NULL, "Cloud type"},
    {"l2_flags", "Flags.3", e_smod_3TOI, e_tid_uint, -1, e_smid_non, NULL, NULL, NULL, "MER_RR__2P_flags_IODD6", NULL, "Level 2 classification and quality flags"}
};

static const struct BandDescriptor MER_LRC_2P_band_data[] = {
    {"latitude", "Tie_points_ADS.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "Tie_points_ADS.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"dem_alt", "Tie_points_ADS.5", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "m", "Digital elevation model altitude"},
    {"dem_rough", "Tie_points_ADS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "m", "Digital elevation model roughness"},
    {"lat_corr", "Tie_points_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model latitude corrections"},
    {"lon_corr", "Tie_points_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model longitude corrections"},
    {"sun_zenith", "Tie_points_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun zenith angle"},
    {"sun_azimuth", "Tie_points_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun azimuth angles"},
    {"view_zenith", "Tie_points_ADS.11", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing zenith angles"},
    {"view_azimuth", "Tie_points_ADS.12", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing azimuth angles"},
    {"zonal_wind", "Tie_points_ADS.13", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.1", NULL, NULL, "m/s", "Zonal wind"},
    {"merid_wind", "Tie_points_ADS.14", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.1", NULL, NULL, "m/s", "Meridional wind"},
    {"atm_press", "Tie_points_ADS.15", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.1", NULL, NULL, "hPa", "Mean sea level pressure"},
    {"ozone", "Tie_points_ADS.16", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.01", NULL, NULL, "DU", "Total ozone"},
    {"rel_hum", "Tie_points_ADS.17", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.1", NULL, NULL, "dl", "Relative humidity"},
    {"water_vapour", "Vapour_Content.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.6.1", "Scaling_Factor_GADS.3.1", NULL, NULL, "g/cm^2", "Water vapour content"},
    {"cloud_opt_thick", "Cloud_Type_OT.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.4.1", "Scaling_Factor_GADS.1.1", "l2_flags.CLOUD", NULL, "dl", "Cloud optical thickness"},
    {"cloud_top_press", "Cloud_Top_Pressure.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.5.1", "Scaling_Factor_GADS.2.1", "l2_flags.CLOUD", NULL, "hPa", "Cloud top pressure"},
    {"l2_flags", "Flags.3", e_smod_3TOI, e_tid_uint, -1, e_smid_non, NULL, NULL, NULL, "MER_RR__2P_flags", NULL, "Level 2 classification and quality flags"}
};

static const struct BandDescriptor MER_RRC_2P_band_data[] = {
    {"latitude", "Tie_points_ADS.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "Tie_points_ADS.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"dem_alt", "Tie_points_ADS.5", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "m", "Digital elevation model altitude"},
    {"dem_rough", "Tie_points_ADS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "m", "Digital elevation model roughness"},
    {"lat_corr", "Tie_points_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model latitude corrections"},
    {"lon_corr", "Tie_points_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model longitude corrections"},
    {"sun_zenith", "Tie_points_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun zenith angle"},
    {"sun_azimuth", "Tie_points_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun azimuth angles"},
    {"view_zenith", "Tie_points_ADS.11", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing zenith angles"},
    {"view_azimuth", "Tie_points_ADS.12", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing azimuth angles"},
    {"zonal_wind", "Tie_points_ADS.13", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.1", NULL, NULL, "m/s", "Zonal wind"},
    {"merid_wind", "Tie_points_ADS.14", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.1", NULL, NULL, "m/s", "Meridional wind"},
    {"atm_press", "Tie_points_ADS.15", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.1", NULL, NULL, "hPa", "Mean sea level pressure"},
    {"ozone", "Tie_points_ADS.16", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.01", NULL, NULL, "DU", "Total ozone"},
    {"rel_hum", "Tie_points_ADS.17", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.1", NULL, NULL, "dl", "Relative humidity"},
    {"water_vapour", "Vapour_Content.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.6.1", "Scaling_Factor_GADS.3.1", NULL, NULL, "g/cm^2", "Water vapour content"},
    {"cloud_opt_thick", "Cloud_Type_OT.3", e_smod_2OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.4.1", "Scaling_Factor_GADS.1.1", "l2_flags.CLOUD", NULL, "dl", "Cloud optical thickness"},
    {"cloud_top_press", "Cloud_Top_Pressure.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.5.1", "Scaling_Factor_GADS.2.1", "l2_flags.CLOUD", NULL, "hPa", "Cloud top pressure"},
    {"cloud_type", "Cloud_Type_OT.3", e_smod_1OF2, e_tid_uchar, -1, e_smid_non, NULL, NULL, "l2_flags.CLOUD", NULL, NULL, "Cloud type"},
    {"l2_flags", "Flags.3", e_smod_3TOI, e_tid_uint, -1, e_smid_non, NULL, NULL, NULL, "MER_RR__2P_flags", NULL, "Level 2 Classification and quality flags"}
};

static const struct BandDescriptor MER_RRV_2P_band_data[] = {
    {"latitude", "Tie_points_ADS.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "Tie_points_ADS.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"dem_alt", "Tie_points_ADS.5", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "m", "Digital elevation model altitude"},
    {"dem_rough", "Tie_points_ADS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0", NULL, NULL, "m", "Digital elevation model roughness"},
    {"lat_corr", "Tie_points_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model latitude corrections"},
    {"lon_corr", "Tie_points_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model longitude corrections"},
    {"sun_zenith", "Tie_points_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun zenith angle"},
    {"sun_azimuth", "Tie_points_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun azimuth angles"},
    {"view_zenith", "Tie_points_ADS.11", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing zenith angles"},
    {"view_azimuth", "Tie_points_ADS.12", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing azimuth angles"},
    {"zonal_wind", "Tie_points_ADS.13", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.1", NULL, NULL, "m/s", "Zonal wind"},
    {"merid_wind", "Tie_points_ADS.14", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.1", NULL, NULL, "m/s", "Meridional wind"},
    {"atm_press", "Tie_points_ADS.15", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.1", NULL, NULL, "hPa", "Mean sea level pressure"},
    {"ozone", "Tie_points_ADS.16", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.01", NULL, NULL, "DU", "Total ozone"},
    {"rel_hum", "Tie_points_ADS.17", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "0.1", NULL, NULL, "dl", "Relative humidity"},
    {"toa_veg", "TOAVI.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.3.1", "Scaling_Factor_GADS.1.1", "l2_flags.LAND", NULL, "dl", "TOA vegetation index"},
    {"boa_veg", "BOAVI.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.4.1", "Scaling_Factor_GADS.2.1", "l2_flags.LAND", NULL, "dl", "BOA vegetation index"},
    {"l2_flags", "Flags.3", e_smod_3TOI, e_tid_uint, -1, e_smid_non, NULL, NULL, NULL, "MER_RR__2P_flags", NULL, "Level 2 Classification and quality flags"}
};

static const struct BandDescriptor MER_RR__1P_band_data[] = {
    {"latitude", "Tie_points_ADS.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "Tie_points_ADS.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"dem_alt", "Tie_points_ADS.5", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.1.1", NULL, NULL, "m", "Digital elevation model altitude"},
    {"dem_rough", "Tie_points_ADS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.2.1", NULL, NULL, "m", "Digital elevation model roughness"},
    {"lat_corr", "Tie_points_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model latitude corrections"},
    {"lon_corr", "Tie_points_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model longitude corrections"},
    {"sun_zenith", "Tie_points_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun zenith angle"},
    {"sun_azimuth", "Tie_points_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun azimuth angles"},
    {"view_zenith", "Tie_points_ADS.11", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing zenith angles"},
    {"view_azimuth", "Tie_points_ADS.12", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing azimuth angles"},
    {"zonal_wind", "Tie_points_ADS.13", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.3.1", NULL, NULL, "m/s", "Zonal wind"},
    {"merid_wind", "Tie_points_ADS.14", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.4.1", NULL, NULL, "m/s", "Meridional wind"},
    {"atm_press", "Tie_points_ADS.15", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.5.1", NULL, NULL, "hPa", "Mean sea level pressure"},
    {"ozone", "Tie_points_ADS.16", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.6.1", NULL, NULL, "DU", "Total ozone"},
    {"rel_hum", "Tie_points_ADS.17", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.7.1", NULL, NULL, "%", "Relative humidity"},
    {"radiance_1", "Radiance_1.3", e_smod_1OF1, e_tid_float, 1, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.1", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 1"},
    {"radiance_2", "Radiance_2.3", e_smod_1OF1, e_tid_float, 2, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.2", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 2"},
    {"radiance_3", "Radiance_3.3", e_smod_1OF1, e_tid_float, 3, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.3", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 3"},
    {"radiance_4", "Radiance_4.3", e_smod_1OF1, e_tid_float, 4, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.4", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 4"},
    {"radiance_5", "Radiance_5.3", e_smod_1OF1, e_tid_float, 5, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.5", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 5"},
    {"radiance_6", "Radiance_6.3", e_smod_1OF1, e_tid_float, 6, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.6", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 6"},
    {"radiance_7", "Radiance_7.3", e_smod_1OF1, e_tid_float, 7, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.7", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 7"},
    {"radiance_8", "Radiance_8.3", e_smod_1OF1, e_tid_float, 8, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.8", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 8"},
    {"radiance_9", "Radiance_9.3", e_smod_1OF1, e_tid_float, 9, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.9", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 9"},
    {"radiance_10", "Radiance_10.3", e_smod_1OF1, e_tid_float, 10, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.10", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 10"},
    {"radiance_11", "Radiance_11.3", e_smod_1OF1, e_tid_float, 11, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.11", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 11"},
    {"radiance_12", "Radiance_12.3", e_smod_1OF1, e_tid_float, 12, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.12", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 12"},
    {"radiance_13", "Radiance_13.3", e_smod_1OF1, e_tid_float, 13, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.13", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 13"},
    {"radiance_14", "Radiance_14.3", e_smod_1OF1, e_tid_float, 14, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.14", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 14"},
    {"radiance_15", "Radiance_15.3", e_smod_1OF1, e_tid_float, 15, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.15", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 15"},
    {"l1_flags", "Flags.3", e_smod_1OF1, e_tid_uchar, -1, e_smid_non, NULL, NULL, NULL, "MER_RR__1P_flags", NULL, "Level 1b classification and quality flags"},
    {"detector_index", "Flags.4", e_smod_1OF1, e_tid_short, -1, e_smid_non, NULL, NULL, NULL, NULL, NULL, "Detector index"}
};

static const struct BandDescriptor MER_RR__1P_IODD5_band_data[] = {
    {"latitude", "Tie_points_ADS.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "Tie_points_ADS.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"dem_alt", "Tie_points_ADS.5", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.1.1", NULL, NULL, "m", "Digital elevation model altitude"},
    {"dem_rough", "Tie_points_ADS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.2.1", NULL, NULL, "m", "Digital elevation model roughness"},
    {"lat_corr", "Tie_points_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model latitude corrections"},
    {"lon_corr", "Tie_points_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model longitude corrections"},
    {"sun_zenith", "Tie_points_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun zenith angle"},
    {"sun_azimuth", "Tie_points_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun azimuth angles"},
    {"view_zenith", "Tie_points_ADS.11", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing zenith angles"},
    {"view_azimuth", "Tie_points_ADS.12", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing azimuth angles"},
    {"zonal_wind", "Tie_points_ADS.13", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.3.1", NULL, NULL, "m/s", "Zonal wind"},
    {"merid_wind", "Tie_points_ADS.14", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.4.1", NULL, NULL, "m/s", "Meridional wind"},
    {"atm_press", "Tie_points_ADS.15", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.5.1", NULL, NULL, "hPa", "Mean sea level pressure"},
    {"ozone", "Tie_points_ADS.16", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.6.1", NULL, NULL, "DU", "Total ozone"},
    {"rel_hum", "Tie_points_ADS.17", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.7.1", NULL, NULL, "%", "Relative humidity"},
    {"radiance_1", "Radiance_1.3", e_smod_1OF1, e_tid_float, 1, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.1", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 1"},
    {"radiance_2", "Radiance_2.3", e_smod_1OF1, e_tid_float, 2, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.2", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 2"},
    {"radiance_3", "Radiance_3.3", e_smod_1OF1, e_tid_float, 3, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.3", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 3"},
    {"radiance_4", "Radiance_4.3", e_smod_1OF1, e_tid_float, 4, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.4", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 4"},
    {"radiance_5", "Radiance_5.3", e_smod_1OF1, e_tid_float, 5, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.5", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 5"},
    {"radiance_6", "Radiance_6.3", e_smod_1OF1, e_tid_float, 6, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.6", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 6"},
    {"radiance_7", "Radiance_7.3", e_smod_1OF1, e_tid_float, 7, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.7", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 7"},
    {"radiance_8", "Radiance_8.3", e_smod_1OF1, e_tid_float, 8, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.8", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 8"},
    {"radiance_9", "Radiance_9.3", e_smod_1OF1, e_tid_float, 9, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.9", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 9"},
    {"radiance_10", "Radiance_10.3", e_smod_1OF1, e_tid_float, 10, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.10", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 10"},
    {"radiance_11", "Radiance_11.3", e_smod_1OF1, e_tid_float, 11, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.11", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 11"},
    {"radiance_12", "Radiance_12.3", e_smod_1OF1, e_tid_float, 12, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.12", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 12"},
    {"radiance_13", "Radiance_13.3", e_smod_1OF1, e_tid_float, 13, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.13", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 13"},
    {"radiance_14", "Radiance_14.3", e_smod_1OF1, e_tid_float, 14, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.14", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 14"},
    {"radiance_15", "Radiance_15.3", e_smod_1OF1, e_tid_float, 15, e_smid_lin, "0.0", "Scaling_Factor_GADS.8.15", "!l1_flags.INVALID", NULL, "mW/(m^2*sr*nm)", "TOA radiance band 15"},
    {"l1_flags", "Flags.3", e_smod_1OF2, e_tid_uchar, -1, e_smid_non, NULL, NULL, NULL, "MER_RR__1P_flags", NULL, "Level 1b classification and quality flags"},
    {"ssi", "Flags.3", e_smod_2OF2, e_tid_uchar, -1, e_smid_non, NULL, NULL, NULL, NULL, NULL, "Spectral shift index"}
};

static const struct BandDescriptor MER_RR__2P_band_data[] = {
    {"latitude", "Tie_points_ADS.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "Tie_points_ADS.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"dem_alt", "Tie_points_ADS.5", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.1.1", NULL, NULL, "m", "Digital elevation model altitude"},
    {"dem_rough", "Tie_points_ADS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.2.1", NULL, NULL, "m", "Digital elevation model roughness"},
    {"lat_corr", "Tie_points_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model latitude corrections"},
    {"lon_corr", "Tie_points_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model longitude corrections"},
    {"sun_zenith", "Tie_points_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun zenith angle"},
    {"sun_azimuth", "Tie_points_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun azimuth angles"},
    {"view_zenith", "Tie_points_ADS.11", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing zenith angles"},
    {"view_azimuth", "Tie_points_ADS.12", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing azimuth angles"},
    {"zonal_wind", "Tie_points_ADS.13", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.3.1", NULL, NULL, "m/s", "Zonal wind"},
    {"merid_wind", "Tie_points_ADS.14", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.4.1", NULL, NULL, "m/s", "Meridional wind"},
    {"atm_press", "Tie_points_ADS.15", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.5.1", NULL, NULL, "hPa", "Mean sea level pressure"},
    {"ozone", "Tie_points_ADS.16", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.6.1", NULL, NULL, "DU", "Total ozone"},
    {"rel_hum", "Tie_points_ADS.17", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.7.1", NULL, NULL, "%", "Relative humidity"},
    {"reflec_1", "Norm_rho_surf_1.3", e_smod_1OF1, e_tid_float, 1, e_smid_lin, "Scaling_Factor_GADS.22.1", "Scaling_Factor_GADS.8.1", NULL, NULL, "dl", "Normalized surface reflectance, band 1"},
    {"reflec_2", "Norm_rho_surf_2.3", e_smod_1OF1, e_tid_float, 2, e_smid_lin, "Scaling_Factor_GADS.22.2", "Scaling_Factor_GADS.8.2", NULL, NULL, "dl", "Normalized surface reflectance, band 2"},
    {"reflec_3", "Norm_rho_surf_3.3", e_smod_1OF1, e_tid_float, 3, e_smid_lin, "Scaling_Factor_GADS.22.3", "Scaling_Factor_GADS.8.3", NULL, NULL, "dl", "Normalized surface reflectance, band 3"},
    {"reflec_4", "Norm_rho_surf_4.3", e_smod_1OF1, e_tid_float, 4, e_smid_lin, "Scaling_Factor_GADS.22.4", "Scaling_Factor_GADS.8.4", NULL, NULL, "dl", "Normalized surface reflectance, band 4"},
    {"reflec_5", "Norm_rho_surf_5.3", e_smod_1OF1, e_tid_float, 5, e_smid_lin, "Scaling_Factor_GADS.22.5", "Scaling_Factor_GADS.8.5", NULL, NULL, "dl", "Normalized surface reflectance, band 5"},
    {"reflec_6", "Norm_rho_surf_6.3", e_smod_1OF1, e_tid_float, 6, e_smid_lin, "Scaling_Factor_GADS.22.6", "Scaling_Factor_GADS.8.6", NULL, NULL, "dl", "Normalized surface reflectance, band 6"},
    {"reflec_7", "Norm_rho_surf_7.3", e_smod_1OF1, e_tid_float, 7, e_smid_lin, "Scaling_Factor_GADS.22.7", "Scaling_Factor_GADS.8.7", NULL, NULL, "dl", "Normalized surface reflectance, band 7"},
    {"reflec_8", "Norm_rho_surf_8.3", e_smod_1OF1, e_tid_float, 8, e_smid_lin, "Scaling_Factor_GADS.22.8", "Scaling_Factor_GADS.8.8", NULL, NULL, "dl", "Normalized surface reflectance, band 8"},
    {"reflec_9", "Norm_rho_surf_9.3", e_smod_1OF1, e_tid_float, 9, e_smid_lin, "Scaling_Factor_GADS.22.9", "Scaling_Factor_GADS.8.9", NULL, NULL, "dl", "Normalized surface reflectance, band 9"},
    {"reflec_10", "Norm_rho_surf_10.3", e_smod_1OF1, e_tid_float, 10, e_smid_lin, "Scaling_Factor_GADS.22.10", "Scaling_Factor_GADS.8.10", NULL, NULL, "dl", "Normalized surface reflectance, band 10"},
    {"reflec_12", "Norm_rho_surf_11.3", e_smod_1OF1, e_tid_float, 12, e_smid_lin, "Scaling_Factor_GADS.22.11", "Scaling_Factor_GADS.8.11", NULL, NULL, "dl", "Normalized surface reflectance, band 12"},
    {"reflec_13", "Norm_rho_surf_12.3", e_smod_1OF1, e_tid_float, 13, e_smid_lin, "Scaling_Factor_GADS.22.12", "Scaling_Factor_GADS.8.12", NULL, NULL, "dl", "Normalized surface reflectance, band 13"},
    {"reflec_14", "Norm_rho_surf_13.3", e_smod_1OF1, e_tid_float, 14, e_smid_lin, "Scaling_Factor_GADS.22.13", "Scaling_Factor_GADS.8.13", NULL, NULL, "dl", "Normalized surface reflectance, band 14"},
    {"water_vapour", "Vapour_Content.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.30.1", "Scaling_Factor_GADS.16.1", NULL, NULL, "g/cm^2", "Water vapour content"},
    {"algal_1", "Chl_1_TOAVI_CTP.3", e_smod_1OF1, e_tid_float, -1, e_smid_log, "Scaling_Factor_GADS.23.1", "Scaling_Factor_GADS.9.1", "l2_flags.WATER", NULL, "mg/m^3", "Chlorophyll 1 content"},
    {"algal_2", "Chl_2_BOAVI.3", e_smod_1OF1, e_tid_float, -1, e_smid_log, "Scaling_Factor_GADS.23.1", "Scaling_Factor_GADS.9.1", "l2_flags.WATER", NULL, "mg/m^3", "Chlorophyll 2 content"},
    {"yellow_subs", "YS_SPM_Rect_rho.3", e_smod_1OF2, e_tid_float, -1, e_smid_log, "Scaling_Factor_GADS.24.1", "Scaling_Factor_GADS.10.1", "l2_flags.WATER", NULL, "1/m", "Yellow substance"},
    {"total_susp", "YS_SPM_Rect_rho.3", e_smod_2OF2, e_tid_float, -1, e_smid_log, "Scaling_Factor_GADS.25.1", "Scaling_Factor_GADS.11.1", "l2_flags.WATER", NULL, "g/m^3", "Total suspended matter"},
    {"photosyn_rad", "Press_PAR_Alb.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.31.1", "Scaling_Factor_GADS.17.1", "l2_flags.WATER", NULL, "myEinstein/(m^2*s)", "Photosynthetically active radiation"},
    {"toa_veg", "Chl_1_TOAVI_CTP.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.32.1", "Scaling_Factor_GADS.18.1", "l2_flags.LAND", NULL, "1", "MGVI - MERIS global vegetation index"},
    {"boa_veg", "Chl_2_BOAVI.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.33.1", "Scaling_Factor_GADS.19.1", "l2_flags.LAND", NULL, "1", "MTCI - MERIS terrestrial chlorophyll index"},
    {"rect_refl_red", "YS_SPM_Rect_rho.3", e_smod_1OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.40.1", "Scaling_Factor_GADS.39.1", "l2_flags.LAND", NULL, "dl", "Rectified reflectance in a red band"},
    {"rect_refl_nir", "YS_SPM_Rect_rho.3", e_smod_2OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.42.1", "Scaling_Factor_GADS.41.1", "l2_flags.LAND", NULL, "dl", "Rectified reflectances in a near infrared band"},
    {"surf_press", "Press_PAR_Alb.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.29.1", "Scaling_Factor_GADS.15.1", "l2_flags.LAND", NULL, "hPa", "Surface pressure"},
    {"aero_alpha", "Alpha_OPT.3", e_smod_1OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.26.1", "Scaling_Factor_GADS.12.1", "!l2_flags.CLOUD", NULL, "dl", "Aerosol Angstrom exponent"},
    {"aero_opt_thick_443", "Alpha_OPT.3", e_smod_2OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.27.1", "Scaling_Factor_GADS.13.1", "!l2_flags.LAND", NULL, "dl", "Aerosol optical thickness at 443 nm"},
    {"aero_opt_thick_865", "Alpha_OPT.3", e_smod_2OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.27.1", "Scaling_Factor_GADS.13.1", "!l2_flags.WATER", NULL, "dl", "Aerosol optical thickness at 865 nm"},
    {"cloud_albedo", "Press_PAR_Alb.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.34.1", "Scaling_Factor_GADS.20.1", "l2_flags.CLOUD", NULL, "dl", "Cloud albedo"},
    {"cloud_opt_thick", "Alpha_OPT.3", e_smod_2OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.28.1", "Scaling_Factor_GADS.14.1", "l2_flags.CLOUD", NULL, "dl", "Cloud optical thickness"},
    {"cloud_top_press", "Chl_1_TOAVI_CTP.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.35.1", "Scaling_Factor_GADS.21.1", "l2_flags.CLOUD", NULL, "hPa", "Cloud top pressure"},
    {"cloud_type", "Alpha_OPT.3", e_smod_1OF2, e_tid_uchar, -1, e_smid_non, NULL, NULL, "l2_flags.CLOUD", NULL, NULL, "Cloud type"},
    {"l2_flags", "Flags.3", e_smod_3TOI, e_tid_uint, -1, e_smid_non, NULL, NULL, NULL, "MER_RR__2P_flags", NULL, "Level 2 classification and quality flags"}
};

static const struct BandDescriptor MER_RR__2P_IODD6_band_data[] = {
    {"latitude", "Tie_points_ADS.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Latitude of the tie points (WGS-84), positive N"},
    {"longitude", "Tie_points_ADS.4", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Longitude of the tie points (WGS-84), Greenwich origin, positive E"},
    {"dem_alt", "Tie_points_ADS.5", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.1.1", NULL, NULL, "m", "Digital elevation model altitude"},
    {"dem_rough", "Tie_points_ADS.6", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.2.1", NULL, NULL, "m", "Digital elevation model roughness"},
    {"lat_corr", "Tie_points_ADS.7", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model latitude corrections"},
    {"lon_corr", "Tie_points_ADS.8", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Digital elevation model longitude corrections"},
    {"sun_zenith", "Tie_points_ADS.9", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun zenith angle"},
    {"sun_azimuth", "Tie_points_ADS.10", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Sun azimuth angles"},
    {"view_zenith", "Tie_points_ADS.11", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing zenith angles"},
    {"view_azimuth", "Tie_points_ADS.12", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "1.0E-06", NULL, NULL, "deg", "Viewing azimuth angles"},
    {"zonal_wind", "Tie_points_ADS.13", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.3.1", NULL, NULL, "m/s", "Zonal wind"},
    {"merid_wind", "Tie_points_ADS.14", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.4.1", NULL, NULL, "m/s", "Meridional wind"},
    {"atm_press", "Tie_points_ADS.15", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.5.1", NULL, NULL, "hPa", "Mean sea level pressure"},
    {"ozone", "Tie_points_ADS.16", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.6.1", NULL, NULL, "DU", "Total ozone"},
    {"rel_hum", "Tie_points_ADS.17", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "0.0", "Scaling_Factor_GADS.7.1", NULL, NULL, "%", "Relative humidity"},
    {"reflec_1", "Norm_rho_surf_1.3", e_smod_1OF1, e_tid_float, 1, e_smid_lin, "Scaling_Factor_GADS.22.1", "Scaling_Factor_GADS.8.1", NULL, NULL, "dl", "Normalized surface reflectance, band 1"},
    {"reflec_2", "Norm_rho_surf_2.3", e_smod_1OF1, e_tid_float, 2, e_smid_lin, "Scaling_Factor_GADS.22.2", "Scaling_Factor_GADS.8.2", NULL, NULL, "dl", "Normalized surface reflectance, band 2"},
    {"reflec_3", "Norm_rho_surf_3.3", e_smod_1OF1, e_tid_float, 3, e_smid_lin, "Scaling_Factor_GADS.22.3", "Scaling_Factor_GADS.8.3", NULL, NULL, "dl", "Normalized surface reflectance, band 3"},
    {"reflec_4", "Norm_rho_surf_4.3", e_smod_1OF1, e_tid_float, 4, e_smid_lin, "Scaling_Factor_GADS.22.4", "Scaling_Factor_GADS.8.4", NULL, NULL, "dl", "Normalized surface reflectance, band 4"},
    {"reflec_5", "Norm_rho_surf_5.3", e_smod_1OF1, e_tid_float, 5, e_smid_lin, "Scaling_Factor_GADS.22.5", "Scaling_Factor_GADS.8.5", NULL, NULL, "dl", "Normalized surface reflectance, band 5"},
    {"reflec_6", "Norm_rho_surf_6.3", e_smod_1OF1, e_tid_float, 6, e_smid_lin, "Scaling_Factor_GADS.22.6", "Scaling_Factor_GADS.8.6", NULL, NULL, "dl", "Normalized surface reflectance, band 6"},
    {"reflec_7", "Norm_rho_surf_7.3", e_smod_1OF1, e_tid_float, 7, e_smid_lin, "Scaling_Factor_GADS.22.7", "Scaling_Factor_GADS.8.7", NULL, NULL, "dl", "Normalized surface reflectance, band 7"},
    {"reflec_8", "Norm_rho_surf_8.3", e_smod_1OF1, e_tid_float, 8, e_smid_lin, "Scaling_Factor_GADS.22.8", "Scaling_Factor_GADS.8.8", NULL, NULL, "dl", "Normalized surface reflectance, band 8"},
    {"reflec_9", "Norm_rho_surf_9.3", e_smod_1OF1, e_tid_float, 9, e_smid_lin, "Scaling_Factor_GADS.22.9", "Scaling_Factor_GADS.8.9", NULL, NULL, "dl", "Normalized surface reflectance, band 9"},
    {"reflec_10", "Norm_rho_surf_10.3", e_smod_1OF1, e_tid_float, 10, e_smid_lin, "Scaling_Factor_GADS.22.10", "Scaling_Factor_GADS.8.10", NULL, NULL, "dl", "Normalized surface reflectance, band 10"},
    {"reflec_12", "Norm_rho_surf_11.3", e_smod_1OF1, e_tid_float, 12, e_smid_lin, "Scaling_Factor_GADS.22.11", "Scaling_Factor_GADS.8.11", NULL, NULL, "dl", "Normalized surface reflectance, band 12"},
    {"reflec_13", "Norm_rho_surf_12.3", e_smod_1OF1, e_tid_float, 13, e_smid_lin, "Scaling_Factor_GADS.22.12", "Scaling_Factor_GADS.8.12", NULL, NULL, "dl", "Normalized surface reflectance, band 13"},
    {"reflec_14", "Norm_rho_surf_13.3", e_smod_1OF1, e_tid_float, 14, e_smid_lin, "Scaling_Factor_GADS.22.13", "Scaling_Factor_GADS.8.13", NULL, NULL, "dl", "Normalized surface reflectance, band 14"},
    {"water_vapour", "Vapour_Content.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.30.1", "Scaling_Factor_GADS.16.1", NULL, NULL, "g/cm^2", "Water vapour content"},
    {"algal_1", "Chl_1_TOAVI_CTP.3", e_smod_1OF1, e_tid_float, -1, e_smid_log, "Scaling_Factor_GADS.23.1", "Scaling_Factor_GADS.9.1", "l2_flags.WATER", NULL, "mg/m^3", "Chlorophyll 1 content"},
    {"algal_2", "Chl_2_BOAVI.3", e_smod_1OF1, e_tid_float, -1, e_smid_log, "Scaling_Factor_GADS.23.1", "Scaling_Factor_GADS.9.1", "l2_flags.WATER", NULL, "mg/m^3", "Chlorophyll 2 content"},
    {"yellow_subs", "YS_SPM_Rect_rho.3", e_smod_1OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.24.1", "Scaling_Factor_GADS.10.1", "l2_flags.WATER", NULL, "1/m", "Yellow substance"},
    {"total_susp", "YS_SPM_Rect_rho.3", e_smod_2OF2, e_tid_float, -1, e_smid_log, "Scaling_Factor_GADS.25.1", "Scaling_Factor_GADS.11.1", "l2_flags.WATER", NULL, "g/m^3", "Total suspended matter"},
    {"photosyn_rad", "Press_PAR_Alb.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.31.1", "Scaling_Factor_GADS.17.1", "l2_flags.WATER", NULL, "myEinstein/m^2", "Photosynthetically active radiation"},
    {"toa_veg", "Chl_1_TOAVI_CTP.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.32.1", "Scaling_Factor_GADS.18.1", "l2_flags.LAND", NULL, "1", "TOA vegetation index"},
    {"boa_veg", "Chl_2_BOAVI.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.33.1", "Scaling_Factor_GADS.19.1", "l2_flags.LAND", NULL, "1", "BOA vegetation index"},
    {"rect_refl_nir", "YS_SPM_Rect_rho.3", e_smod_1OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.40.1", "Scaling_Factor_GADS.39.1", "l2_flags.LAND", NULL, "dl", "Rectified surface reflectances"},
    {"rect_refl_red", "YS_SPM_Rect_rho.3", e_smod_2OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.42.1", "Scaling_Factor_GADS.41.1", "l2_flags.LAND", NULL, "dl", "Rectified surface reflectances"},
    {"surf_press", "Press_PAR_Alb.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.29.1", "Scaling_Factor_GADS.15.1", "l2_flags.LAND", NULL, "hPa", "Surface pressure"},
    {"aero_epsilon", "Epsilon_OPT.3", e_smod_1OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.26.1", "Scaling_Factor_GADS.12.1", "!l2_flags.CLOUD", NULL, "dl", "Aerosol epsilon"},
    {"aero_opt_thick", "Epsilon_OPT.3", e_smod_2OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.27.1", "Scaling_Factor_GADS.13.1", "!l2_flags.CLOUD", NULL, "dl", "Aerosol optical thickness"},
    {"cloud_albedo", "Press_PAR_Alb.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.34.1", "Scaling_Factor_GADS.20.1", "l2_flags.CLOUD", NULL, "dl", "Cloud albedo"},
    {"cloud_opt_thick", "Epsilon_OPT.3", e_smod_2OF2, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.28.1", "Scaling_Factor_GADS.14.1", "l2_flags.CLOUD", NULL, "dl", "Cloud optical thickness"},
    {"cloud_top_press", "Chl_1_TOAVI_CTP.3", e_smod_1OF1, e_tid_float, -1, e_smid_lin, "Scaling_Factor_GADS.35.1", "Scaling_Factor_GADS.21.1", "l2_flags.CLOUD", NULL, "hPa", "Cloud top pressure"},
    {"cloud_type", "Epsilon_OPT.3", e_smod_1OF2, e_tid_uchar, -1, e_smid_non, NULL, NULL, "l2_flags.CLOUD", NULL, NULL, "Cloud type"},
    {"l2_flags", "Flags.3", e_smod_3TOI, e_tid_uint, -1, e_smid_non, NULL, NULL, NULL, "MER_RR__2P_flags_IODD6", NULL, "Level 2 classification and quality flags"}
};

static const struct FlagDescriptor ATS_NR__2P_flags_data[] = {
    {"NADIR_SST_ONLY_VALID", 1, {0, 0}, "Nadir-only SST is valid"},
    {"NADIR_SST_ONLY_37_MY_VALID", 1, {1, 0}, "Nadir-only SST retrieval includes 3.7 micron channel"},
    {"DUAL_SST_VALID", 1, {2, 0}, "Dual-view SST is valid"},
    {"DUAL_SST_VALID_37_MY", 1, {3, 0}, "Dual-view SST retrieval includes 3.7 micron channel"},
    {"LAND", 1, {4, 0}, "Pixel is over land"},
    {"NADIR_CLOUD", 1, {5, 0}, "Nadir-view pixel is cloudy"},
    {"NADIR_BLANKING", 1, {6, 0}, "Nadir-view pixel has blanking pulse"},
    {"NADIR_COSMETIC", 1, {7, 0}, "Nadir-view pixel is cosmetic fill"},
    {"FWARD_CLOUD", 1, {8, 0}, "Forward-view pixel is cloudy"},
    {"FWARD_BLANKING", 1, {9, 0}, "Forward-view pixel has blanking pulse"},
    {"FWARD_COSMETIC", 1, {10, 0}, "Forward-view pixel is cosmetic fill"},
    {"CLOUDY_16_MY", 1, {11, 0}, "One or both views flagged cloudy by 1.6 micron test (daytime only)"},
    {"CLOUDY_11_12_MY", 1, {12, 0}, "Cloud flagged by 11 micron/12 micron nadir-forward test"},
    {"CLOUDY_HISTO", 1, {13, 0}, "One or both views flagged cloudy by infra-red histogram test"}
};

static const struct FlagDescriptor ATS_TOA_1P_cloud_flags_data[] = {
    {"LAND", 1, {0, 0}, "Pixel is over land"},
    {"CLOUDY", 1, {1, 0}, "Pixel is cloudy (result of all cloud tests)"},
    {"SUN_GLINT", 1, {2, 0}, "Sunglint detected in pixel"},
    {"CLOUDY_REFL_HIST", 1, {3, 0}, "1.6 micron reflectance histogram test shows pixel cloudy (day-time only)"},
    {"CLOUDY_SPAT_COHER_16", 1, {4, 0}, "1.6 micron spatial coherence test shows pixel cloudy (day-time only)"},
    {"CLOUDY_SPAT_COHER_11", 1, {5, 0}, "11 micron spatial coherence test shows pixel cloudy"},
    {"CLOUDY_GROSS_12", 1, {6, 0}, "12 micron gross cloud test shows pixel cloudy"},
    {"CLOUDY_CIRRUS_11_12", 1, {7, 0}, "11/12 micron thin cirrus test shows pixel cloudy"},
    {"CLOUDY_MED_HI_LEVEL_37_12", 1, {8, 0}, "3.7/12 micron medium/high level test shows pixel cloudy (night-time only)"},
    {"CLOUDY_FOG_LOW_STRATUS_11_37", 1, {9, 0}, "11/3.7 micron fog/low stratus test shows pixel cloudy (night-time only)"},
    {"CLOUDY_VW_DIFF_11_12", 1, {10, 0}, "11/12 micron view-difference test shows pixel cloudy"},
    {"CLOUDY_VW_DIFF_37_11", 1, {11, 0}, "3.7/11 micron view-difference test shows pixel cloudy (night-time only)"},
    {"CLOUDY_THERM_HIST_11_12", 1, {12, 0}, "11/12 micron thermal histogram test shows pixel cloudy"}
};

static const struct FlagDescriptor ATS_TOA_1P_confid_flags_data[] = {
    {"BLANKING", 1, {0, 0}, "Blanking Pulse"},
    {"COSMETIC", 1, {1, 0}, "Cosmetic Fill Pixel"},
    {"SCAN_ABSENT", 1, {2, 0}, "Entire scan absent from telemetry"},
    {"ABSENT", 1, {3, 0}, "Pixel absent from telemetry"},
    {"NOT_DECOMPR", 1, {4, 0}, "Pixel not decompressed owing to error in packet validation"},
    {"NO_SIGNAL", 1, {5, 0}, "No signal in some channel (zero count)"},
    {"SATURATION", 1, {6, 0}, "Saturation in some channel (maximum count)"},
    {"OUT_OF_RANGE", 1, {7, 0}, "Derived radiance of some channel outside range of calibration"},
    {"NO_CALIB_PARAM", 1, {8, 0}, "Calibration Parameters unavailable for pixel"},
    {"UNFILLED", 1, {9, 0}, "Pixel unfilled (cosmetic fill algorithm unable to find nearest neighbour pixel)"}
};

static const struct FlagDescriptor MER_RR__1P_flags_data[] = {
    {"COSMETIC", 1, {0, 0}, "Pixel is cosmetic"},
    {"DUPLICATED", 1, {1, 0}, "Pixel has been duplicated (filled in)"},
    {"GLINT_RISK", 1, {2, 0}, "Pixel has glint risk"},
    {"SUSPECT", 1, {3, 0}, "Pixel is suspect"},
    {"LAND_OCEAN", 1, {4, 0}, "Pixel is over land, not ocean"},
    {"BRIGHT", 1, {5, 0}, "Pixel is bright (saturation)"},
    {"COASTLINE", 1, {6, 0}, "Pixel is part of a coastline"},
    {"INVALID", 1, {7, 0}, "Pixel is invalid"}
};

static const struct FlagDescriptor MER_RR__2P_flags_data[] = {
    {"LAND", 1, {23, 0}, "Land product available"},
    {"CLOUD", 1, {22, 0}, "Cloud product available"},
    {"WATER", 1, {21, 0}, "Water product available"},
    {"PCD_1_13", 1, {20, 0}, "Uncertain normalized surface reflectance"},
    {"PCD_14", 1, {19, 0}, "Uncertain total water vapour content"},
    {"PCD_15", 1, {18, 0}, "Uncertain algal pigment index 1 or cloud top pressure or top of atmosphere vegetation index"},
    {"PCD_16", 1, {17, 0}, "Uncertain yellow substance and total suspended matter or rectified reflectances"},
    {"PCD_17", 1, {16, 0}, "Uncertain algal pigment index 2 or bottom of atmosphere vegetation index"},
    {"PCD_18", 1, {15, 0}, "Uncertain PAR or cloud albedo or land surface pressure"},
    {"PCD_19", 1, {14, 0}, "Uncertain aerosol type and optical thickness or cloud optical thickness"},
    {"COASTLINE", 1, {13, 0}, "Coastline pixel"},
    {"COSMETIC", 1, {12, 0}, "Cosmetic pixel (from level-1b)"},
    {"SUSPECT", 1, {11, 0}, "Suspect pixel (from level-1b)"},
    {"OOADB", 1, {10, 0}, "Aerosol model is out of aerosol model database"},
    {"ABSOA_DUST", 1, {9, 0}, "Dust-like absorbing aerosol selected for atmosphere correction"},
    {"CASE2_S", 1, {8, 0}, "Turbid (sediment dominated Case 2) water"},
    {"CASE2_ANOM", 2, {7, 21}, "Anomalous scattering water"},
    {"TOAVI_BRIGHT", 2, {7, 23}, "Bright pixel flagged by MGVI processing"},
    {"CASE2_Y", 2, {6, 21}, "Yellow substance loaded water"},
    {"TOAVI_BAD", 2, {6, 23}, "Bad pixel flagged by MGVI processing"},
    {"ICE_HAZE", 2, {5, 21}, "Ice or high aerosol load pixel"},
    {"TOAVI_CSI", 2, {5, 23}, "Cloud, snow or ice over land pixel acc. to MGVI processing"},
    {"MEDIUM_GLINT", 2, {4, 21}, "Corrected for glint (water)"},
    {"TOAVI_WS", 2, {4, 23}, "Water/shadow pixel acc. to MGVI processing (land)"},
    {"LARS_ON", 2, {3, 23}, "Land aerosol remote sensing turned on"},
    {"BPAC_ON", 2, {3, 21}, "Bright pixels atmospheric correction activated (water)"},
    {"HIGH_GLINT", 2, {2, 21}, "High (uncorrected) glint (water)"},
    {"TOAVI_INVAL_REC", 2, {2, 23}, "Invalid rectification (land)"},
    {"LOW_SUN", 1, {1, 0}, "Sun low above horizon (or conversely high sun zenith angle)"},
    {"LOW_PRESSURE", 1, {0, 0}, "Computed pressure is lower than ECMWF one (land, cloud)"},
    {"WHITE_SCATTERER", 2, {0, 21}, "Presense of white scatterer in water"}
};

static const struct FlagDescriptor MER_RR__2P_flags_IODD6_data[] = {
    {"LAND", 1, {23, 0}, "Land product available"},
    {"CLOUD", 1, {22, 0}, "Cloud product available"},
    {"WATER", 1, {21, 0}, "Water product available"},
    {"PCD_1_13", 1, {20, 0}, "Uncertain normalized surface reflectance"},
    {"PCD_14", 1, {19, 0}, "Uncertain total water vapour content"},
    {"PCD_15", 1, {18, 0}, "Uncertain algal pigment index 1 or cloud top pressure or top of atmosphere vegetation index"},
    {"PCD_16", 1, {17, 0}, "Uncertain yellow substance and total suspended matter or rectified reflectances"},
    {"PCD_17", 1, {16, 0}, "Uncertain algal pigment index 2 or bottom of atmosphere vegetation index"},
    {"PCD_18", 1, {15, 0}, "Uncertain PAR or cloud albedo or land surface pressure"},
    {"PCD_19", 1, {14, 0}, "Uncertain aerosol type and optical thickness or cloud optical thickness"},
    {"COASTLINE", 1, {13, 0}, "Coastline pixel"},
    {"COSMETIC", 1, {12, 0}, "Cosmetic pixel (from level-1B)"},
    {"SUSPECT", 1, {11, 0}, "Suspect pixel (from level-1B)"},
    {"ABSOA_CONT", 1, {10, 0}, "Continental absorbing aerosol"},
    {"ABSOA_DUST", 1, {9, 0}, "Dust-like absorbing aerosol"},
    {"CASE2_S", 1, {8, 0}, "Turbid water"},
    {"CASE2_ANOM", 2, {7, 21}, "Anomalous scattering water"},
    {"TOAVI_BRIGHT", 2, {7, 23}, "Bright pixel flagged by TOAVI processing"},
    {"CASE2_Y", 2, {6, 21}, "Yellow substance loaded water"},
    {"TOAVI_BAD", 2, {6, 23}, "Bad pixel flagged by TOAVI processing"},
    {"ICE_HAZE", 2, {5, 21}, "Ice at high aerosol load pixel"},
    {"TOAVI_CSI", 2, {5, 23}, "Cloud, snow or ice flagged by TOAVI"},
    {"MEDIUM_GLINT", 2, {4, 21}, "Corrected for glint"},
    {"TOAVI_WS", 2, {4, 23}, "Water or deep shadow flagged by TOAVI"},
    {"DDV", 1, {3, 0}, "Dense dark vegetation"},
    {"HIGH_GLINT", 2, {2, 21}, "High (uncorrected) glint"},
    {"TOAVI_INVAL_REC", 2, {2, 23}, "Invalid rectification flagged by TOAVI"},
    {"P_CONFIDENCE", 1, {1, 0}, "The two pressure estimates do not compare successfully"},
    {"LOW_PRESSURE", 1, {0, 0}, "Computed pressure lower than ECMWF one"}
};

const struct DatasetDescriptorTable dddb_product_tables[46] = {
    {"ASA_APG_1P", "ASAR Alternating Polarization Ellipsoid Geocoded Image", 11, ASA_APG_1P_dataset_data},
    {"ASA_APM_1P", "ASAR Alternating Polarization Medium Resolution Image product", 10, ASA_APM_1P_dataset_data},
    {"ASA_APP_1P", "ASAR Alternating Polarization Mode Precision Image", 10, ASA_APP_1P_dataset_data},
    {"ASA_APS_1P", "ASAR Alternating Polarization Mode Single Look Complex", 8, ASA_APS_1P_dataset_data},
    {"ASA_AP__BP", "ASAR Alternating Polarization Browse Product", 5, ASA_AP__BP_dataset_data},
	{"ASA_GM1_1P", "ASAR Global Monitoring Mode Image", 8, ASA_GM1_1P_dataset_data},
    {"ASA_IMG_1P", "ASAR Image Mode Ellipsoid Geocoded Image", 9, ASA_IMG_1P_dataset_data},
    {"ASA_IMM_1P", "ASAR Image Mode Medium Resolution Image", 8, ASA_IMM_1P_dataset_data},
    {"ASA_IMP_1P", "ASAR Image Mode Precision Image", 8, ASA_IMP_1P_dataset_data},
    {"ASA_IMS_1P", "ASAR Image Mode Single Look Complex", 6, ASA_IMS_1P_dataset_data},
	{"ASA_IM__BP", "ASAR Image Mode Browse Product", 3, ASA_IM__BP_dataset_data},
    {"ASA_WSM_1P", "ASAR Wide Swath Medium Resolution Image", 8, ASA_WSM_1P_dataset_data},
    {"ASA_WS__BP", "ASAR Wide Swath Mode Browse Image", 5, ASA_WS__BP_dataset_data},
    {"ASA_WVI_1P", "ASAR Wave Mode SLC Imagette and Imagette Cross Spectra", 405, ASA_WVI_1P_dataset_data},
    {"ASA_WVS_1P", "ASAR Wave Mode Imagette Cross Spectra", 4, ASA_WVS_1P_dataset_data},
	{"ASA_WVW_2P", "ASAR Wave Mode Wave Spectra", 4, ASA_WVW_2P_dataset_data},
    {"ATS_AR__2P", "AATSR averaged geophysical product", 16, ATS_AR__2P_dataset_data},
    {"ATS_MET_2P", "AATSR Spatially Averaged Sea Surface Temperature for Meteo Users", 1, ATS_MET_2P_dataset_data},
    {"ATS_NR__2P", "AATSR geophysical product (full resolution)", 8, ATS_NR__2P_dataset_data},
    {"ATS_TOA_1P", "AATSR Gridded brightness temperature and reflectance", 26, ATS_TOA_1P_dataset_data},
	{"MER_FR__1P", "MERIS Full Resolution Geolocated and Calibrated TOA Radiance", 19, MER_FR__1P_dataset_data},
    {"MER_FRS_1P", "MERIS Full Resolution Full Swath Geolocated and Calibrated TOA Radiance", 19, MER_FR__1P_dataset_data},
    {"MER_FR__1P_IODD5", "MERIS Full Resolution Geolocated and Calibrated TOA Radiance", 19, MER_FR__1P_IODD5_dataset_data},
    {"MER_FR__2P", "MERIS Full Resolution Geophysical Product", 23, MER_FR__2P_dataset_data},
    {"MER_FRS_2P", "MERIS Full Resolution Full Swath Geophysical Product", 23, MER_FR__2P_dataset_data},
	{"MER_FR__2P_IODD6", "MERIS Full Resolution Geophysical Product", 23, MER_FR__2P_IODD6_dataset_data},
    {"MER_LRC_2P", "MERIS Extracted Cloud Thickness and Water Vapour for Meteo Users", 7, MER_LRC_2P_dataset_data},
    {"MER_RRC_2P", "MERIS Extracted Cloud Thickness and Water Vapour", 7, MER_RRC_2P_dataset_data},
    {"MER_RRV_2P", "MERIS Extracted Vegetation Indices", 6, MER_RRV_2P_dataset_data},
    {"MER_RR__1P", "MERIS Reduced Resolution Geolocated and Calibrated TOA Radiance", 19, MER_RR__1P_dataset_data},
	{"MER_RR__1P_IODD5", "MERIS Reduced Resolution Geolocated and Calibrated TOA Radiance", 19, MER_RR__1P_IODD5_dataset_data},
    {"MER_RR__2P", "MERIS Reduced Resolution Geophysical Product", 23, MER_RR__2P_dataset_data},
    {"MER_RR__2P_IODD6", "MERIS Reduced Resolution Geophysical Product", 23, MER_RR__2P_IODD6_dataset_data},
    {"SAR_APG_1P", "ERS Simulated Alternating Polarization Ellipsoid Geocoded Image", 11, ASA_APG_1P_dataset_data},
    {"SAR_APM_1P", "ERS Simulated Alternating Polarization Medium Resolution Image product", 10, ASA_APM_1P_dataset_data},
    {"SAR_APP_1P", "ERS Simulated Alternating Polarization Mode Precision Image", 10, ASA_APP_1P_dataset_data},
    {"SAR_APS_1P", "ERS Simulated Alternating Polarization Mode Single Look Complex", 8, ASA_APS_1P_dataset_data},
    {"SAR_AP__BP", "ERS Simulated Alternating Polarization Browse Product", 5, ASA_AP__BP_dataset_data},
    {"SAR_IMG_1P", "ERS Image Mode Ellipsoid Geocoded Image", 9, ASA_IMG_1P_dataset_data},
    {"SAR_IMM_1P", "ERS Image Mode Medium Resolution Image", 8, ASA_IMM_1P_dataset_data},
    {"SAR_IMP_1P", "ERS Image Mode Precision Image", 8, ASA_IMP_1P_dataset_data},
    {"SAR_IMS_1P", "ERS Image Mode Single Look Complex", 6, ASA_IMS_1P_dataset_data},
    {"SAR_IM__BP", "ERS Image Mode Browse Product", 3, ASA_IM__BP_dataset_data},
    {"SAR_WVI_1P", "ERS Wave Mode SLC Imagette and Imagette Cross Spectra", 405, ASA_WVI_1P_dataset_data},
    {"SAR_WVS_1P", "ERS Wave Mode Imagette Cross Spectra", 4, ASA_WVS_1P_dataset_data},
    {"SAR_WVW_2P", "ERS Wave Mode Wave Spectra", 4, ASA_WVW_2P_dataset_data},
};
const struct BandDescriptorTable dddb_band_tables[37] = {
    {"ASA_APG_1P", "ASAR Alternating Polarization Geocoded Image", 6, ASA_APG_1P_band_data},
    {"ASA_APM_1P", "ASAR Alternating Polarization Medium Resolution Image", 6, ASA_APM_1P_band_data},
    {"ASA_APP_1P", "ASAR Alternating Polarization Precision Image", 6, ASA_APP_1P_band_data},
    {"ASA_APS_1P", "ASAR Alternating Polarization SLC Image", 6, ASA_APS_1P_band_data},
    {"ASA_AP__BP", "ASAR Alternatin Polarization Mode Browse Product", 5, ASA_AP__BP_band_data},
    {"ASA_IMG_1P", "ASAR Image Mode Geocoded Image", 5, ASA_IMG_1P_band_data},
    {"ASA_IMM_1P", "ASAR Image Mode Medium Resolution Image", 5, ASA_IMM_1P_band_data},
    {"ASA_IMP_1P", "ASAR Image Mode Precision Image", 5, ASA_IMP_1P_band_data},
    {"ASA_IMS_1P", "ASAR Image Mode SLC Image", 6, ASA_IMS_1P_band_data},
    {"ASA_IM__BP", "ASAR Image Mode Browse Product", 5, ASA_IM__BP_band_data},
    {"ASA_WSM_1P", "ASAR Wide Swath Mode Medium Resolution Image", 5, ASA_WSM_1P_band_data},
    {"ASA_WS__BP", "ASAR Wide Swap Mode Browse Image", 5, ASA_WS__BP_band_data},
    {"ATS_NR__2P", "AATSR Geophysical Level 2 Product", 22, ATS_NR__2P_band_data},
    {"ATS_TOA_1P", "AATSR Gridded brightness temperature and reflectance", 33, ATS_TOA_1P_band_data},
    {"MER_FR__1P", "MERIS Level 1b Full Resolution Geophysical Product", 32, MER_FR__1P_band_data},
    {"MER_FRS_1P", "MERIS Level 1b Full Resolution Full Swath Geophysical Product", 32, MER_FR__1P_band_data},
    {"MER_FR__1P_IODD5", "MERIS Level 1b Full Resolution Geophysical Product", 32, MER_FR__1P_IODD5_band_data},
    {"MER_FR__2P", "MERIS Level 2 Full Resolution Geophysical Product", 47, MER_FR__2P_band_data},
    {"MER_FRS_2P", "MERIS Level 2 Full Resolution Full Swath Geophysical Product", 47, MER_FR__2P_band_data},
    {"MER_FR__2P_IODD6", "MERIS Level 2 Full Resolution Geophysical Product", 46, MER_FR__2P_IODD6_band_data},
    {"MER_LRC_2P", "MERIS Level 2 Extracted Cloud Thickness and Water Vapour for Meteo Users", 19, MER_LRC_2P_band_data},
    {"MER_RRC_2P", "MERIS Level 2 Extracted Cloud Thickness and Water Vapour", 20, MER_RRC_2P_band_data},
    {"MER_RRV_2P", "MERIS Level 2 Extracted Vegetation Indices", 18, MER_RRV_2P_band_data},
    {"MER_RR__1P", "MERIS Level 1b Reduced Resolution Geophysical Product", 32, MER_RR__1P_band_data},
    {"MER_RR__1P_IODD5", "MERIS Level 1b Reduced Resolution Geophysical Product", 32, MER_RR__1P_IODD5_band_data},
    {"MER_RR__2P", "MERIS Level 2 Reduced Resolution Geophysical Product", 47, MER_RR__2P_band_data},
    {"MER_RR__2P_IODD6", "MERIS Level 2 Reduced Resolution Geophysical Product", 46, MER_RR__2P_IODD6_band_data},
    {"SAR_APG_1P", "ERS Simulated Alternating Polarization Geocoded Image", 6, ASA_APG_1P_band_data},
    {"SAR_APM_1P", "ERS Simulated Alternating Polarization Medium Resolution Image", 6, ASA_APM_1P_band_data},
    {"SAR_APP_1P", "ERS Simulated Alternating Polarization Precision Image", 6, ASA_APP_1P_band_data},
    {"SAR_APS_1P", "ERS Simulated Alternating Polarization SLC Image", 6, ASA_APS_1P_band_data},
    {"SAR_AP__BP", "ERS Simulated Alternatin Polarization Mode Browse Product", 5, ASA_AP__BP_band_data},
    {"SAR_IMG_1P", "ERS Image Mode Geocoded Image", 5, ASA_IMG_1P_band_data},
    {"SAR_IMM_1P", "ERS Image Mode Medium Resolution Image", 5, ASA_IMM_1P_band_data},
    {"SAR_IMP_1P", "ERS Image Mode Precision Image", 5, ASA_IMP_1P_band_data},
    {"SAR_IMS_1P", "ERS Image Mode SLC Image", 6, ASA_IMS_1P_band_data},
    {"SAR_IM__BP", "ERS Image Mode Browse Product", 5, ASA_IM__BP_band_data},
};
const struct FlagDescriptorTable dddb_flag_coding_tables[6] = {
    {"ATS_NR__2P_flags", "AATSR Level 2 Flags Codings", 14, ATS_NR__2P_flags_data},
    {"ATS_TOA_1P_cloud_flags", "AATSR TOA Level 1b Cloud Flags Codings", 13, ATS_TOA_1P_cloud_flags_data},
    {"ATS_TOA_1P_confid_flags", "AATSR TOA Level 1b Confidence Flag Codings", 10, ATS_TOA_1P_confid_flags_data},
    {"MER_RR__1P_flags", "MERIS RR Level 1b Flag Codings", 8, MER_RR__1P_flags_data},
    {"MER_RR__2P_flags", "MERIS Level 2 Flag Codings", 31, MER_RR__2P_flags_data},
    {"MER_RR__2P_flags_IODD6", "MERIS Level 2 Flag Codings", 29, MER_RR__2P_flags_IODD6_data},
};

const struct RecordDescriptorTable dddb_meris_rec_tables[23] = {
    {"MER_LRC_2P_MDSR_cl_thick", "Level 2 MDS Cloud Optical Thickness", 3, MER_LRC_2P_MDSR_cl_thick_meris_rec_data},
    {"MER_LRC_2P_MDSR_cl_top_press", "Level 2 MDS Cloud Top Pressure", 3, MER_LRC_2P_MDSR_cl_top_press_meris_rec_data},
    {"MER_LRC_2P_MDSR_flag", "Level 2 MDS Flags", 3, MER_LRC_2P_MDSR_flag_meris_rec_data},
    {"MER_LRC_2P_MDSR_twv", "Level 2 MDS Total Water vapour", 3, MER_LRC_2P_MDSR_twv_meris_rec_data},
    {"MER_RRC_2P_GADS_sfgi", "Level 2 GADS Scaling Factor and Offsets", 7, MER_RRC_2P_GADS_sfgi_meris_rec_data},
    {"MER_RRV_2P_GADS_sfgi", "Level 2 GADS Scaling Factor and Offsets", 5, MER_RRV_2P_GADS_sfgi_meris_rec_data},
    {"MER_RR__1P_ADSR_sq", "Level 1b Summary Quality ADS(SQ ADS)", 4, MER_RR__1P_ADSR_sq_meris_rec_data},
    {"MER_RR__1P_ADSR_tie_pt", "Level 2 ADS Tie Points Location & Aux. Data ( L ADS)", 17, MER_RR__1P_ADSR_tie_pt_meris_rec_data},
    {"MER_RR__1P_GADS_sfgi", "Level 1b GADS Scaling Factor and General Info", 12, MER_RR__1P_GADS_sfgi_meris_rec_data},
    {"MER_RR__1P_MDSR_16", "Level 1b MDS (16) Flags & Spectral Shift Index", 4, MER_RR__1P_MDSR_16_meris_rec_data},
    {"MER_RR__1P_MDSR_16_IODD5", "Level 1b MDS (16) Flags & Detector Index", 3, MER_RR__1P_MDSR_16_IODD5_meris_rec_data},
    {"MER_RR__1P_MDSR_1_15", "Level 1b MDS (1) TOA Radiance", 3, MER_RR__1P_MDSR_1_15_meris_rec_data},
    {"MER_RR__2P_ADSR_sq", "Level 2 ADS Summary Quality ADS (SQ ADS)", 21, MER_RR__2P_ADSR_sq_meris_rec_data},
    {"MER_RR__2P_GADS_sfgi", "Level 2 GADS Scaling Factors and Offsets", 43, MER_RR__2P_GADS_sfgi_meris_rec_data},
    {"MER_RR__2P_MDSR_14", "Level 2 MDS(14) water vapour content", 3, MER_RR__2P_MDSR_14_meris_rec_data},
    {"MER_RR__2P_MDSR_15", "Level 2 MDS(15) algal index I  TOAVI", 3, MER_RR__2P_MDSR_15_meris_rec_data},
    {"MER_RR__2P_MDSR_16", "Level 2 MDS(16) yellow substance  total suspended matter  or rectified reflectances", 3, MER_RR__2P_MDSR_16_meris_rec_data},
    {"MER_RR__2P_MDSR_17", "Level 2 MDS(17) algal index II  BOAVI", 3, MER_RR__2P_MDSR_17_meris_rec_data},
    {"MER_RR__2P_MDSR_18", "Level 2 MDS(18) surface pressure  PAR  cloud albedo", 3, MER_RR__2P_MDSR_18_meris_rec_data},
    {"MER_RR__2P_MDSR_19", "Level 2 MDS(19) aerosol epsilon or cloud type and optical thickness", 3, MER_RR__2P_MDSR_19_meris_rec_data},
    {"MER_RR__2P_MDSR_19_IODD6", "Level 2 MDS(19) aerosol epsilon or cloud type and optical thickness", 3, MER_RR__2P_MDSR_19_IODD6_meris_rec_data},
    {"MER_RR__2P_MDSR_1_13", "Level 2 MDS(1) normalised surface reflectance", 3, MER_RR__2P_MDSR_1_13_meris_rec_data},
    {"MER_RR__2P_MDSR_20", "Level 2 MDS(20) flags", 3, MER_RR__2P_MDSR_20_meris_rec_data}
};

const struct RecordDescriptorTable dddb_aatsr_rec_tables[20] = {
    {"ATS_AR__2P_MDSR_lr_large", "BT/TOA Land record 50 km cell MDS", 90, ATS_AR__2P_MDSR_lr_large_aatsr_rec_data},
    {"ATS_AR__2P_MDSR_lr_small", "BT/TOA Land record 17 km cell MDS", 46, ATS_AR__2P_MDSR_lr_small_aatsr_rec_data},
    {"ATS_AR__2P_MDSR_lst_large", "LST record 50 km cell MDS", 17, ATS_AR__2P_MDSR_lst_large_aatsr_rec_data},
    {"ATS_AR__2P_MDSR_lst_small", "LST record 17 km cell MDS", 11, ATS_AR__2P_MDSR_lst_small_aatsr_rec_data},
    {"ATS_AR__2P_MDSR_sr_large", "BT/TOA Sea record 50 km cell MDS", 86, ATS_AR__2P_MDSR_sr_large_aatsr_rec_data},
    {"ATS_AR__2P_MDSR_sr_small", "BT/TOA Sea record 17 km cell MDS", 42, ATS_AR__2P_MDSR_sr_small_aatsr_rec_data},
    {"ATS_AR__2P_MDSR_sst_large", "SST record 50 km cell MDS", 17, ATS_AR__2P_MDSR_sst_large_aatsr_rec_data},
    {"ATS_AR__2P_MDSR_sst_small", "SST record 17 km cell MDS", 11, ATS_AR__2P_MDSR_sst_small_aatsr_rec_data},
    {"ATS_MET_2P_meteo_user_prod", "10-arcminute mds", 17, ATS_MET_2P_meteo_user_prod_aatsr_rec_data},
    {"ATS_NR__2P_ADSR_sq", "Summary Quality ADS", 25, ATS_NR__2P_ADSR_sq_aatsr_rec_data},
    {"ATS_NR__2P_MDSR_dp", "Distributed product MDS", 7, ATS_NR__2P_MDSR_dp_aatsr_rec_data},
    {"ATS_TOA_1P_ADSR_loc", "Grid pixel latitude and longtitude  topographic corrections ADS", 12, ATS_TOA_1P_ADSR_loc_aatsr_rec_data},
    {"ATS_TOA_1P_ADSR_pix", "Scan and pixel number nadir view ADS", 6, ATS_TOA_1P_ADSR_pix_aatsr_rec_data},
    {"ATS_TOA_1P_ADSR_sa", "Nadir view solar angles ADS", 9, ATS_TOA_1P_ADSR_sa_aatsr_rec_data},
    {"ATS_TOA_1P_ADSR_scan", "Scan pixel x and y ADS", 7, ATS_TOA_1P_ADSR_scan_aatsr_rec_data},
    {"ATS_TOA_1P_ADSR_sq", "Summary quality ADS", 25, ATS_TOA_1P_ADSR_sq_aatsr_rec_data},
    {"ATS_TOA_1P_MDSR_brgt", "12 micron nadir view MDS", 5, ATS_TOA_1P_MDSR_brgt_aatsr_rec_data},
    {"ATS_TOA_1P_MDSR_cl", "Cloud flag nadir view MDS", 5, ATS_TOA_1P_MDSR_cl_aatsr_rec_data},
    {"ATS_TOA_1P_MDSR_conf", "Confidence words nadir view MDS", 5, ATS_TOA_1P_MDSR_conf_aatsr_rec_data},
    {"ATS_VC1_AX_GADS", "Visible calibration coefficients GADS", 32, ATS_VC1_AX_GADS_aatsr_rec_data}
};

const struct RecordDescriptorTable dddb_asar_rec_tables[20] = {
    {"ASAR_Antenna_ADSR", "Antenna Elevation patterns(s)", 7, ASAR_Antenna_ADSR_asar_rec_data},
    {"ASAR_Chirp_ADSR", "chirp parameters", 140, ASAR_Chirp_ADSR_asar_rec_data},
    {"ASAR_Dop_Cen_ADSR", "Doppler Centroid Parameters", 7, ASAR_Dop_Cen_ADSR_asar_rec_data},
    {"ASAR_Geo_Grid_ADSR", "Geolocation Grid ADSRs", 18, ASAR_Geo_Grid_ADSR_asar_rec_data},
    {"ASAR_Image_MDSR_BP", "Measurement Data Set 1", 4, ASAR_Image_MDSR_BP_asar_rec_data},
    {"ASAR_Image_MDSR_Gen", "Measurement Data Set 1", 4, ASAR_Image_MDSR_Gen_asar_rec_data},
    {"ASAR_Image_MDSR_SLC", "Measurement Data Set 1", 4, ASAR_Image_MDSR_SLC_asar_rec_data},
    {"ASAR_Main_ADSR", "Main Processing parameters", 220, ASAR_Main_ADSR_asar_rec_data},
    {"ASAR_Map_GADS", "Map Projection parameters", 66, ASAR_Map_GADS_asar_rec_data},
    {"ASAR_Ocean_Spectra_MDSR", "Ocean Wave spectrum.", 29, ASAR_Ocean_Spectra_MDSR_asar_rec_data},
    {"ASAR_SQ1_Image_ADSR", "SQ ADSRs", 39, ASAR_SQ1_Image_ADSR_asar_rec_data},
    {"ASAR_SRGR_ADSR", "Slant Range to Ground Range conversion parameters", 6, ASAR_SRGR_ADSR_asar_rec_data},
    {"ASAR_Spectra_MDSR", "Measurement Data Set containing spectra. 1 MDSR per spectra.", 29, ASAR_Spectra_MDSR_asar_rec_data},
    {"ASAR_Wave_Geolocation_ADSR", "Wave Mode Geolocation ADS", 5, ASAR_Wave_Geolocation_ADSR_asar_rec_data},
    {"ASAR_Wave_Param_ADSR", "Wave Mode processing parameters", 396, ASAR_Wave_Param_ADSR_asar_rec_data},
    {"ASAR_Wave_SQ_ADSR", "SQ ADSRs", 59, ASAR_Wave_SQ_ADSR_asar_rec_data},
    {"ASA_CON_AX_GADS", "Contains ASAR processor configuration data", 41, ASA_CON_AX_GADS_asar_rec_data},
    {"ASA_INS_AX_GADS", "Contains ASAR instrument characterization data", 721, ASA_INS_AX_GADS_asar_rec_data},
    {"ASA_XCA_AX_GADS", "Contains ASAR external calibration data", 31, ASA_XCA_AX_GADS_asar_rec_data},
    {"ASA_XCH_AX_GADS", "Contains ASAR external characterization data", 5, ASA_XCH_AX_GADS_asar_rec_data}
};

