id = "3dc971a085afdbf06b44fb463ed08036270bf377"
date = "2015-07-22 20:37:02 +0000"
branch = "glue-1-49-branch"
tag = "glue-release-1-49"
if tag == "None":
    tag = None
author = "Ryan Fisher <ryan.fisher@ligo.org>"
builder = "Ryan Fisher <ryan.fisher@ligo.org>"
committer = "Ryan Fisher <ryan.fisher@ligo.org>"
status = "UNCLEAN: Modified working tree"
version = id
verbose_msg = """Branch: glue-1-49-branch
Tag: glue-release-1-49
Id: 3dc971a085afdbf06b44fb463ed08036270bf377

Builder: Ryan Fisher <ryan.fisher@ligo.org>
Build date: 2015-07-23 22:58:03 +0000
Repository status: UNCLEAN: Modified working tree"""

import warnings

class VersionMismatchError(ValueError):
    pass

def check_match(foreign_id, onmismatch="raise"):
    """
    If foreign_id != id, perform an action specified by the onmismatch
    kwarg. This can be useful for validating input files.

    onmismatch actions:
      "raise": raise a VersionMismatchError, stating both versions involved
      "warn": emit a warning, stating both versions involved
    """
    if onmismatch not in ("raise", "warn"):
        raise ValueError, onmismatch + " is an unrecognized value of onmismatch"
    if foreign_id == "3dc971a085afdbf06b44fb463ed08036270bf377":
        return
    msg = "Program id (3dc971a085afdbf06b44fb463ed08036270bf377) does not match given id (%s)." % foreign_id
    if onmismatch == "raise":
        raise VersionMismatchError, msg

    # in the backtrace, show calling code
    warnings.warn(msg, UserWarning)

