id = "5fd44d9165c1083e35c615f1eb95979a07e0e3d0"
date = "2015-05-22 20:41:05 +0000"
branch = "None"
tag = "glue-release-1-48"
if tag == "None":
    tag = None
author = "Ryan Fisher <ryan.fisher@ligo.org>"
builder = "Ryan Fisher <ryan.fisher@ligo.org>"
committer = "Ryan Fisher <ryan.fisher@ligo.org>"
status = "CLEAN: All modifications committed"
version = id
verbose_msg = """Branch: None
Tag: glue-release-1-48
Id: 5fd44d9165c1083e35c615f1eb95979a07e0e3d0

Builder: Ryan Fisher <ryan.fisher@ligo.org>
Build date: 2015-05-22 20:42:30 +0000
Repository status: CLEAN: All modifications committed"""

import warnings

class VersionMismatchError(ValueError):
    pass

def check_match(foreign_id, onmismatch="raise"):
    """
    If foreign_id != id, perform an action specified by the onmismatch
    kwarg. This can be useful for validating input files.

    onmismatch actions:
      "raise": raise a VersionMismatchError, stating both versions involved
      "warn": emit a warning, stating both versions involved
    """
    if onmismatch not in ("raise", "warn"):
        raise ValueError, onmismatch + " is an unrecognized value of onmismatch"
    if foreign_id == "5fd44d9165c1083e35c615f1eb95979a07e0e3d0":
        return
    msg = "Program id (5fd44d9165c1083e35c615f1eb95979a07e0e3d0) does not match given id (%s)." % foreign_id
    if onmismatch == "raise":
        raise VersionMismatchError, msg

    # in the backtrace, show calling code
    warnings.warn(msg, UserWarning)

