/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper.util;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.SnapshotArray;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.GameState;
import com.esotericsoftware.gloomhavenhelper.MonsterBox;
import com.esotericsoftware.gloomhavenhelper.MonsterRow;
import com.esotericsoftware.gloomhavenhelper.PlayerRow;
import com.esotericsoftware.gloomhavenhelper.Rows;
import com.esotericsoftware.gloomhavenhelper.model.AttackModifier;
import com.esotericsoftware.gloomhavenhelper.model.CharacterClass;
import com.esotericsoftware.gloomhavenhelper.model.Condition;
import com.esotericsoftware.gloomhavenhelper.model.ElementState;
import com.esotericsoftware.gloomhavenhelper.model.Monster;
import com.esotericsoftware.gloomhavenhelper.model.MonsterAbility;
import com.esotericsoftware.gloomhavenhelper.model.MonsterAbilityDeck;
import com.esotericsoftware.gloomhavenhelper.model.MonsterData;
import com.esotericsoftware.gloomhavenhelper.model.MonsterType;
import com.esotericsoftware.gloomhavenhelper.model.Player;
import com.esotericsoftware.gloomhavenhelper.model.PlayerInit;
import com.esotericsoftware.gloomhavenhelper.model.SummonColor;
import com.esotericsoftware.gloomhavenhelper.util.Input;
import com.esotericsoftware.gloomhavenhelper.util.Output;
import com.esotericsoftware.gloomhavenhelper.util.Row;

public class Serialization {
    public static final Input input = new Input(8192);
    public static Output lastOutput = new Output(8192);
    public static Output output = new Output(8192);

    public static void write(Output output, GameState state) {
        output.writeInt(state.round, true);
        output.writeInt(state.scenarioNumber, true);
        output.writeInt(state.scenarioLevel, true);
        output.writeBoolean(state.trackStandees);
        output.writeBoolean(state.abilityCards);
        output.writeBoolean(state.randomStandees);
        output.writeBoolean(state.elitesFirst);
        output.writeBoolean(state.expireConditions);
        output.writeBoolean(state.solo);
        output.writeBoolean(state.hideStats);
        output.writeBoolean(state.calculateStats);
        output.writeBoolean(state.canDraw);
        output.writeBoolean(state.needsShuffle);
        Serialization.writeEnum(output, state.playerInit);
        Serialization.writeEnumArray(output, state.attackModifiers);
        Serialization.writeEnumArray(output, state.attackModifiersDiscard);
        Serialization.writeEnum(output, state.fire);
        Serialization.writeEnum(output, state.ice);
        Serialization.writeEnum(output, state.air);
        Serialization.writeEnum(output, state.earth);
        Serialization.writeEnum(output, state.light);
        Serialization.writeEnum(output, state.dark);
        Serialization.writeIntArray(output, state.removedAbilities, true);
        output.writeInt(state.badOmen, true);
        output.writeBoolean(state.jotl);
        output.writeInt(state.abilityDecks.size, true);
        for (MonsterAbilityDeck deck : state.abilityDecks.values()) {
            output.writeInt(deck.id, true);
            output.writeBoolean(deck.shuffle);
            Serialization.writeMonsterAbility(output, deck.shownAbility);
            int i = 0;
            int n = Serialization.writeArrayStart(output, deck.abilities);
            while (i < n) {
                output.writeInt(deck.abilities.get((int)i).id, true);
                ++i;
            }
            i = 0;
            n = Serialization.writeArrayStart(output, deck.abilitiesDiscard);
            while (i < n) {
                output.writeInt(deck.abilitiesDiscard.get((int)i).id, true);
                ++i;
            }
        }
        SnapshotArray<Actor> children = App.gloom.rows.getChildren();
        int i = 0;
        int n = Serialization.writeArrayStart(output, children);
        while (i < n) {
            Actor actor = (Actor)children.get(i);
            if (actor instanceof PlayerRow) {
                output.writeBoolean(true);
                Serialization.writePlayerRow(output, (PlayerRow)actor);
            } else {
                output.writeBoolean(false);
                Serialization.writeMonsterRow(output, (MonsterRow)actor);
            }
            ++i;
        }
    }

    public static GameState read(Input input) {
        GameState state = new GameState();
        state.round = input.readInt(true);
        state.scenarioNumber = input.readInt(true);
        state.scenarioLevel = input.readInt(true);
        state.trackStandees = input.readBoolean();
        state.abilityCards = input.readBoolean();
        state.randomStandees = input.readBoolean();
        state.elitesFirst = input.readBoolean();
        state.expireConditions = input.readBoolean();
        state.solo = input.readBoolean();
        state.hideStats = input.readBoolean();
        state.calculateStats = input.readBoolean();
        state.canDraw = input.readBoolean();
        state.needsShuffle = input.readBoolean();
        state.playerInit = (PlayerInit)Serialization.readEnum((Input)input, (Enum[])PlayerInit.values);
        Serialization.readEnumArray((Input)input, state.attackModifiers, (Enum[])AttackModifier.values);
        Serialization.readEnumArray((Input)input, state.attackModifiersDiscard, (Enum[])AttackModifier.values);
        state.fire = (ElementState)Serialization.readEnum((Input)input, (Enum[])ElementState.values);
        state.ice = (ElementState)Serialization.readEnum((Input)input, (Enum[])ElementState.values);
        state.air = (ElementState)Serialization.readEnum((Input)input, (Enum[])ElementState.values);
        state.earth = (ElementState)Serialization.readEnum((Input)input, (Enum[])ElementState.values);
        state.light = (ElementState)Serialization.readEnum((Input)input, (Enum[])ElementState.values);
        state.dark = (ElementState)Serialization.readEnum((Input)input, (Enum[])ElementState.values);
        Serialization.readIntArray(input, state.removedAbilities, true);
        state.badOmen = input.readInt(true);
        state.jotl = input.readBoolean();
        int i = 0;
        int n = input.readInt(true);
        while (i < n) {
            MonsterAbilityDeck deck = new MonsterAbilityDeck(App.findMonsterAbilityDeck(input.readInt(true)));
            state.abilityDecks.put(deck.id, deck);
            deck.shuffle = input.readBoolean();
            deck.shownAbility = Serialization.readMonsterAbility(input, deck);
            deck.abilities.clear();
            int ii = 0;
            int nn = input.readInt(true);
            while (ii < nn) {
                deck.abilities.add(App.monsterAbilities.get(input.readInt(true)));
                ++ii;
            }
            ii = 0;
            nn = input.readInt(true);
            while (ii < nn) {
                deck.abilitiesDiscard.add(App.monsterAbilities.get(input.readInt(true)));
                ++ii;
            }
            ++i;
        }
        Rows rows = App.gloom.rows;
        rows.clearChildren();
        App.gloom.playerRows.clear();
        App.gloom.monsterRows.clear();
        int i2 = 0;
        int n2 = input.readInt(true);
        while (i2 < n2) {
            Row row;
            if (input.readBoolean()) {
                row = Serialization.readPlayerRow(input);
                rows.addActor(row);
                App.gloom.playerRows.add((PlayerRow)row);
            } else {
                row = Serialization.readMonsterRow(input);
                rows.addActor(row);
                App.gloom.monsterRows.add((MonsterRow)row);
            }
            ++i2;
        }
        return state;
    }

    private static void writePlayerRow(Output output, PlayerRow row) {
        Player player = row.player;
        if (player.name.equals(player.characterClass.toString())) {
            output.writeString(null);
        } else {
            output.writeString(player.name);
        }
        Serialization.writeEnum(output, player.characterClass);
        output.writeInt(player.xp, true);
        output.writeInt(player.hp, true);
        output.writeInt(player.hpMax, true);
        output.writeInt(player.level, true);
        output.writeInt(player.loot, true);
        output.writeInt(player.init, true);
        Serialization.writeEnumArray(output, player.conditions);
        Serialization.writeEnumArray(output, player.expiredConditions);
        Serialization.writeEnumArray(output, player.currentTurnConditions);
        output.writeBoolean(player.exhausted);
        Serialization.writeRow(output, row);
    }

    private static PlayerRow readPlayerRow(Input input) {
        Player player = new Player();
        player.name = input.readString();
        player.characterClass = (CharacterClass)Serialization.readEnum((Input)input, (Enum[])CharacterClass.values);
        if (player.name == null) {
            player.name = player.characterClass.toString();
        }
        player.xp = input.readInt(true);
        player.hp = input.readInt(true);
        player.hpMax = input.readInt(true);
        player.level = input.readInt(true);
        player.loot = input.readInt(true);
        player.init(input.readInt(true));
        Serialization.readEnumArray((Input)input, player.conditions, (Enum[])Condition.values);
        Serialization.readEnumArray((Input)input, player.expiredConditions, (Enum[])Condition.values);
        Serialization.readEnumArray((Input)input, player.currentTurnConditions, (Enum[])Condition.values);
        player.exhausted = input.readBoolean();
        PlayerRow row = new PlayerRow(player);
        Serialization.readRow(input, row);
        return row;
    }

    private static void writeMonsterRow(Output output, MonsterRow row) {
        output.writeInt(-(row.data.id + 1), true);
        output.writeInt(row.level, true);
        output.writeBoolean(row.hasNormal);
        output.writeBoolean(row.hasElite);
        Serialization.writeMonsterAbility(output, row.ability);
        Serialization.writeRow(output, row);
    }

    private static MonsterRow readMonsterRow(Input input) {
        MonsterData data = App.monsterDatas.get(input.readInt(true));
        MonsterRow row = new MonsterRow(data, input.readInt(true));
        row.hasNormal = input.readBoolean();
        row.hasElite = input.readBoolean();
        row.ability = Serialization.readMonsterAbility(input, App.findMonsterAbilityDeck(data.deckID));
        Serialization.readRow(input, row);
        return row;
    }

    private static void writeMonsterAbility(Output output, MonsterAbility ability) {
        output.writeInt(ability == null ? 0 : ability.id + 1, true);
    }

    private static MonsterAbility readMonsterAbility(Input input, MonsterAbilityDeck deck) {
        int abilityID = input.readInt(true);
        if (abilityID == 0) {
            return null;
        }
        --abilityID;
        Array<MonsterAbility> abilities = deck.abilities;
        int i = 0;
        int n = abilities.size;
        while (i < n) {
            if (abilities.get((int)i).id == abilityID) {
                return abilities.get(i);
            }
            ++i;
        }
        throw new RuntimeException("Ability not found: " + abilityID);
    }

    private static void writeRow(Output output, Row row) {
        output.writeBoolean(row.turnComplete);
        int i = 0;
        int n = Serialization.writeArrayStart(output, row.boxes);
        while (i < n) {
            Monster monster = row.boxes.get((int)i).monster;
            output.writeInt(monster.number, true);
            Serialization.writeEnum(output, monster.type);
            if (monster.type == MonsterType.summon) {
                Serialization.writeEnum(output, monster.summonColor);
                output.writeInt(monster.summonMove, true);
                output.writeInt(monster.summonAttack, true);
                output.writeInt(monster.summonRange, true);
            }
            output.writeBoolean(monster.isNew);
            output.writeInt(monster.hp, true);
            output.writeInt(monster.hpMax, true);
            Serialization.writeEnumArray(output, monster.conditions);
            Serialization.writeEnumArray(output, monster.expiredConditions);
            Serialization.writeEnumArray(output, monster.currentTurnConditions);
            ++i;
        }
    }

    private static void readRow(Input input, Row row) {
        row.setTurnComplete(input.readBoolean(), false);
        int ii = 0;
        int nn = input.readInt(true);
        while (ii < nn) {
            Monster monster = new Monster();
            monster.number = input.readInt(true);
            monster.type = (MonsterType)Serialization.readEnum((Input)input, (Enum[])MonsterType.values);
            if (monster.type == MonsterType.summon) {
                monster.summonColor = (SummonColor)Serialization.readEnum((Input)input, (Enum[])SummonColor.values);
                monster.summonMove = input.readInt(true);
                monster.summonAttack = input.readInt(true);
                monster.summonRange = input.readInt(true);
            }
            monster.isNew = input.readBoolean();
            monster.hp = input.readInt(true);
            monster.hpMax = input.readInt(true);
            Serialization.readEnumArray((Input)input, monster.conditions, (Enum[])Condition.values);
            Serialization.readEnumArray((Input)input, monster.expiredConditions, (Enum[])Condition.values);
            Serialization.readEnumArray((Input)input, monster.currentTurnConditions, (Enum[])Condition.values);
            if (row instanceof MonsterRow) {
                MonsterRow monsterRow = (MonsterRow)row;
                monster.data = monsterRow.data;
                monster.stats = monsterRow.data.stats[monster.type.ordinal()][monsterRow.level];
            } else {
                monster.data = App.summonData;
                monster.stats = App.summonStats;
            }
            MonsterBox box = new MonsterBox(row, monster, row.monstersGroup.getScaleX());
            row.boxes.add(box);
            row.monstersGroup.addActor(box);
            ++ii;
        }
    }

    private static void writeEnum(Output output, Enum value) {
        output.writeInt(value.ordinal(), true);
    }

    private static <T extends Enum> T readEnum(Input input, T[] values) {
        return values[input.readInt(true)];
    }

    private static void writeEnumOrNull(Output output, Enum value) {
        if (value == null) {
            output.writeByte(0);
        } else {
            output.writeInt(value.ordinal() + 1, true);
        }
    }

    private static <T extends Enum> T readEnumOrNull(Input input, T[] values) {
        int value = input.readInt(true);
        if (value == 0) {
            return null;
        }
        return values[value - 1];
    }

    private static int writeArrayStart(Output output, Array array) {
        int size = array.size;
        output.writeInt(size, true);
        return size;
    }

    private static int writeIntArray(Output output, IntArray array, boolean optimizePositive) {
        int size = array.size;
        output.writeInt(size, true);
        int i = 0;
        int n = array.size;
        while (i < n) {
            output.writeInt(array.get(i), optimizePositive);
            ++i;
        }
        return size;
    }

    private static IntArray readIntArray(Input input, IntArray array, boolean optimizePositive) {
        int length = input.readInt(true);
        array.ensureCapacity(length);
        int i = 0;
        while (i < length) {
            array.add(input.readInt(optimizePositive));
            ++i;
        }
        return array;
    }

    private static void writeEnumArray(Output output, Array<? extends Enum> array) {
        int length = array.size;
        output.writeInt(length, true);
        if (length == 0) {
            return;
        }
        int i = 0;
        int n = array.size;
        while (i < n) {
            Serialization.writeEnum(output, array.get(i));
            ++i;
        }
    }

    private static <T extends Enum> Array<T> readEnumArray(Input input, Array<T> array, T[] values) {
        int length = input.readInt(true);
        array.ensureCapacity(length);
        int i = 0;
        while (i < length) {
            array.add(Serialization.readEnum((Input)input, values));
            ++i;
        }
        return array;
    }
}

