/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.SnapshotArray;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.MonsterAbilityCard;
import com.esotericsoftware.gloomhavenhelper.MonsterAddMenu;
import com.esotericsoftware.gloomhavenhelper.MonsterBlessCurseMenu;
import com.esotericsoftware.gloomhavenhelper.MonsterBox;
import com.esotericsoftware.gloomhavenhelper.MonsterStatsCard;
import com.esotericsoftware.gloomhavenhelper.Text;
import com.esotericsoftware.gloomhavenhelper.model.Condition;
import com.esotericsoftware.gloomhavenhelper.model.Monster;
import com.esotericsoftware.gloomhavenhelper.model.MonsterAbility;
import com.esotericsoftware.gloomhavenhelper.model.MonsterAbilityDeck;
import com.esotericsoftware.gloomhavenhelper.model.MonsterData;
import com.esotericsoftware.gloomhavenhelper.model.MonsterType;
import com.esotericsoftware.gloomhavenhelper.model.SummonColor;
import com.esotericsoftware.gloomhavenhelper.util.Animator;
import com.esotericsoftware.gloomhavenhelper.util.Row;
import com.esotericsoftware.gloomhavenhelper.util.builders.ImageButtonBuilder;
import com.esotericsoftware.minlog.Log;

public class MonsterRow
extends Row {
    String levelString = "";
    Image image;
    private Label nameLabel;
    Stack imageStack;
    Stack abilityCardStack;
    float glowAlpha;
    MonsterAbilityCard abilityCard;
    MonsterAbilityCard.Ability3D ability1;
    MonsterAbilityCard.Ability3D ability2;
    private MonsterStatsCard statsTable;
    Button addNormalButton;
    Button addEliteButton;
    TextButton oozeSplitButton;
    Container oozeSplitContainer;
    boolean oozeSplit;
    public MonsterData data;
    public int level;
    public boolean hasNormal;
    public boolean hasElite;
    public MonsterAbility ability;

    public MonsterRow(MonsterData data, int level) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        this.data = data;
        this.level = level;
        this.levelString = String.valueOf(level);
        this.create();
        this.layoutUI();
        this.events();
        this.setTransform(true);
    }

    private void create() {
        block8: {
            this.image = new Image(){
                TextureRegion glowRegion = App.skin.getRegion("monsters/monster-glow");

                @Override
                public void draw(Batch batch, float a) {
                    super.draw(batch, a);
                    if (MonsterRow.this.glowAlpha != 0.0f) {
                        batch.setColor(1.0f, 1.0f, 1.0f, MonsterRow.this.glowAlpha * a);
                        batch.draw(this.glowRegion, this.getX() - 16.0f, this.getY() - 13.0f);
                    }
                }
            };
            try {
                FileHandle file;
                String name = this.data.english.replaceAll(" \\([^)]+\\)", "");
                if (name.startsWith("Common ")) {
                    name = name.substring(7);
                } else if (name.startsWith("Basic ")) {
                    name = name.substring(6);
                }
                if (Gdx.app.getType() == Application.ApplicationType.Desktop && (file = new FileHandle("monsters/" + name + ".png")).exists()) {
                    try {
                        this.image.setDrawable(new TextureRegionDrawable(new TextureRegion(new Texture(file))));
                        break block8;
                    }
                    catch (RuntimeException ex) {
                        Log.error("ghh", "Unable to read image: " + file, ex);
                    }
                }
                this.image.setDrawable(App.skin.getDrawable("monsters/" + name));
            }
            catch (RuntimeException name) {
                // empty catch block
            }
        }
        this.nameLabel = new Label((CharSequence)this.data.display, App.skin, "fancyLargeOutline", Color.WHITE);
        this.nameLabel.setWrap(true);
        this.nameLabel.setAlignment(1);
        this.imageStack = new Stack(){

            @Override
            public void draw(Batch batch, float parentAlpha) {
                MonsterRow.this.beginDesat(batch);
                super.draw(batch, parentAlpha);
            }
        };
        ImageButtonBuilder addButton = App.imageButton().imageUp("psd/add", App.buttonGray).imageOver("psd/add").imageDisabled("psd/add", App.disabledGray).imageChecked("psd/add", Color.WHITE);
        this.addNormalButton = addButton.create();
        this.addEliteButton = addButton.create();
        this.abilityCard = new MonsterAbilityCard(this, true);
        this.abilityCardStack = new Stack(this.abilityCard);
        this.oozeSplitButton = App.textButton(Text.split).create();
        this.oozeSplitButton.addListener(App.tooltip("Applies wound if needed, then if not stunned, applies 2 damage and spawns new Oozes."));
        this.oozeSplitButton.getLabelCell().padRight(10.0f).padTop(2.0f);
        this.oozeSplitContainer = new Container<TextButton>(this.oozeSplitButton).top().right();
        this.ability1 = new MonsterAbilityCard.Ability3D(this.data.deckID, this.abilityCardStack);
        this.ability2 = new MonsterAbilityCard.Ability3D(this.data.deckID, this.abilityCardStack);
        this.statsTable = new MonsterStatsCard(this);
    }

    private void layoutUI() {
        this.statsTable.defaults().bottom();
        this.statsTable.add(this.addNormalButton).size(102.0f).expand().left();
        if (!this.data.isBoss()) {
            this.statsTable.add(this.addEliteButton).size(102.0f);
        }
        this.addNormalButton.padRight(23.0f).padTop(22.0f);
        this.addEliteButton.padLeft(23.0f).padTop(22.0f);
        this.imageStack.add(new Container<Image>(this.image).size(207.0f, 209.0f).top());
        Container<Label> nameContainer = new Container<Label>(this.nameLabel).bottom().fillX();
        if (App.config.isRussian() || this.data.english.equals("Manifestation of Corruption")) {
            nameContainer.padLeft(-10.0f).padRight(-10.0f);
        }
        this.imageStack.add(nameContainer);
        this.row().padBottom(-4.0f);
        this.add(this.imageStack).fill();
        this.add(this.abilityCardStack).padLeft(6.0f);
        this.add(this.statsTable).padLeft(6.0f).row();
        this.add();
        this.monstersCell = this.add(this.monstersGroup).colspan(2).pad(0.0f, 5.0f, 0.0f, 5.0f).fillX();
        this.abilityCardStack.toFront();
        this.monstersGroup.toBack();
    }

    private void events() {
        this.dragStartActor = this.imageStack;
        this.imageStack.addListener(this.dragListener);
        this.imageStack.addListener(new ClickListener(){

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                super.touchDragged(event, x, y, pointer);
                if (MonsterRow.this.dragListener.isDragging()) {
                    this.cancel();
                }
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!MonsterRow.this.isAlive()) {
                    return;
                }
                if (!App.state.canDraw) {
                    if (MonsterRow.this.turnComplete) {
                        MonsterRow.this.turnEndRevert();
                    } else {
                        MonsterRow.this.turnEnd(false);
                    }
                    App.state.changed();
                }
            }
        });
        this.addNormalButton.addListener(new InputListener(){

            @Override
            public boolean handle(Event e) {
                e.stop();
                return super.handle(e);
            }
        });
        this.addNormalButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!App.state.trackStandees) {
                    boolean bl = MonsterRow.this.hasNormal = !MonsterRow.this.hasNormal;
                    if (!App.state.canDraw && MonsterRow.this.getAbilityDeck().shownAbility == null) {
                        MonsterRow.this.showAbility();
                    }
                    App.state.changed();
                    return;
                }
                MonsterRow.this.addNormalButton.setChecked(false);
                IntArray free = MonsterRow.this.freeNumbers();
                if (free.size == 1) {
                    MonsterRow.this.addMonsterBox(free.first(), MonsterRow.this.data, MonsterRow.this.level, false, false, SummonColor.blue, true);
                    App.state.changed();
                    return;
                }
                if (App.state.randomStandees) {
                    MonsterRow.this.addMonsterBox(free.random(), MonsterRow.this.data, MonsterRow.this.level, false, false, SummonColor.blue, true);
                    App.state.changed();
                    return;
                }
                MonsterAddMenu menu = new MonsterAddMenu(MonsterRow.this, free, false);
                menu.setBackgroundOffset(2.0f, 5.0f, -24.0f, -27.0f);
                menu.show(MonsterRow.this.addNormalButton, 19.0f, -22.0f, -41.0f, 0.0f, true);
            }
        });
        this.addEliteButton.addListener(new InputListener(){

            @Override
            public boolean handle(Event e) {
                e.stop();
                return super.handle(e);
            }
        });
        this.addEliteButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!App.state.trackStandees) {
                    boolean bl = MonsterRow.this.hasElite = !MonsterRow.this.hasElite;
                    if (!App.state.canDraw && MonsterRow.this.getAbilityDeck().shownAbility == null) {
                        MonsterRow.this.showAbility();
                    }
                    App.state.changed();
                    return;
                }
                MonsterRow.this.addEliteButton.setChecked(false);
                IntArray free = MonsterRow.this.freeNumbers();
                if (free.size == 1) {
                    MonsterRow.this.addMonsterBox(free.first(), MonsterRow.this.data, MonsterRow.this.level, true, false, SummonColor.blue, true);
                    App.state.changed();
                    return;
                }
                if (App.state.randomStandees) {
                    MonsterRow.this.addMonsterBox(free.random(), MonsterRow.this.data, MonsterRow.this.level, true, false, SummonColor.blue, true);
                    App.state.changed();
                    return;
                }
                MonsterAddMenu menu = new MonsterAddMenu(MonsterRow.this, free, true);
                menu.setBackgroundOffset(24.0f, 5.0f, -2.0f, -27.0f);
                menu.show(MonsterRow.this.addEliteButton, 41.0f, -22.0f, -41.0f, 0.0f, false);
            }
        });
        this.statsTable.setTouchable(Touchable.enabled);
        this.statsTable.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!App.state.trackStandees) {
                    new MonsterBlessCurseMenu(MonsterRow.this).show(MonsterRow.this.image, 0.0f, 0.0f, 0.0f, 0.0f, true);
                }
            }
        });
        this.oozeSplitButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                MonsterRow.this.oozeSplit = true;
                App.state.ignoreChanges = true;
                Array boxes = new Array(MonsterRow.this.boxes);
                boolean elitesFirstOld = App.state.elitesFirst;
                App.state.elitesFirst = true;
                boxes.sort();
                App.state.elitesFirst = elitesFirstOld;
                for (MonsterBox box : boxes) {
                    IntArray free;
                    boolean wound = box.monster.conditions.contains(Condition.wound, true);
                    boolean regenerate = box.monster.conditions.contains(Condition.regenerate, true);
                    if (wound && regenerate) {
                        box.flashIcon("wound");
                    } else if (regenerate) {
                        box.flashIcon("regenerate");
                    } else if (wound) {
                        box.flashIcon("wound");
                    }
                    if (box.monster.conditions.contains(Condition.stun, true)) {
                        if (!wound) continue;
                        box.hpAdjust.adjust(-1);
                        continue;
                    }
                    box.lastAnimateIcon = System.currentTimeMillis();
                    box.hpAdjust.adjust(wound ? -3 : -2);
                    box.checkDead(false);
                    if (box.monster.hp <= 0 || (free = MonsterRow.this.freeNumbers()).isEmpty()) continue;
                    free.shuffle();
                    MonsterBox newBox = MonsterRow.this.addMonsterBox(free.removeIndex(0), MonsterRow.this.data, MonsterRow.this.level, false, true, SummonColor.blue, false);
                    newBox.monster.hp = Math.min(box.monster.hp, newBox.monster.hpMax);
                }
                App.state.ignoreChanges = false;
                App.state.changed();
            }
        });
    }

    IntArray freeNumbers() {
        IntArray numbers = new IntArray();
        int nn = this.boxes.size;
        int i = 1;
        int n = this.data.count;
        while (i <= n) {
            block3: {
                int ii = 0;
                while (ii < nn) {
                    if (i != ((MonsterBox)this.boxes.get((int)ii)).monster.number) {
                        ++ii;
                        continue;
                    }
                    break block3;
                }
                numbers.add(i);
            }
            ++i;
        }
        return numbers;
    }

    private void flipStore1() {
        this.desatDisabled = true;
        if (App.state.abilityCards) {
            this.ability1.update(App.stage.getBatch(), this.abilityCardStack, 1.0f);
            this.ability1.start(false);
        }
        this.addActor(this.ability1);
        this.addActor(this.ability2);
    }

    private void flipStore2() {
        this.updateExtraButtons();
        if (App.state.abilityCards) {
            this.ability2.update(App.stage.getBatch(), this.abilityCardStack, 1.0f);
            this.ability2.start(true);
        }
        this.abilityCardStack.setVisible(false);
        this.desatDisabled = false;
    }

    private void updateExtraButtons() {
        if (this.ability != null && (this.ability.id == 156 || this.ability.id == 157 || !App.state.abilityCards && this.ability.deck.name.equals("Ooze"))) {
            this.oozeSplitButton.setDisabled(this.oozeSplit || this.desat() != 0.0f);
            this.abilityCardStack.addActor(this.oozeSplitContainer);
        } else {
            this.oozeSplit = false;
            if (this.oozeSplitContainer.getParent() == this.abilityCardStack) {
                this.abilityCardStack.removeActor(this.oozeSplitContainer);
            }
        }
    }

    public void showAbility() {
        if (!this.isAlive()) {
            return;
        }
        this.showAbility(true, this.getAbilityDeck());
    }

    private void showAbility(boolean flipOthers, MonsterAbilityDeck deck) {
        MonsterRow row;
        int n;
        if (this.ability != null) {
            return;
        }
        if (deck.shownAbility == null) {
            int i = 0;
            n = App.gloom.monsterRows.size;
            while (i < n) {
                row = App.gloom.monsterRows.get(i);
                if (row.data.deckID == deck.id) {
                    row.flipStore1();
                }
                ++i;
            }
        }
        if (deck.shownAbility != null && !this.data.isBoss()) {
            this.ability = deck.shownAbility;
        } else {
            Array<MonsterAbility> abilities = deck.abilities;
            if (abilities.size == 0) {
                abilities.clear();
                abilities.addAll(App.findMonsterAbilityDeck((int)deck.id).abilities);
                App.state.removeAbilities(deck.abilities);
                abilities.shuffle();
                deck.abilitiesDiscard.clear();
            }
            this.ability = abilities.pop();
            deck.abilitiesDiscard.add(this.ability);
            if (!deck.shuffle) {
                boolean bl = deck.shuffle = this.ability.shuffle || abilities.isEmpty();
            }
        }
        if (deck.shownAbility == null) {
            deck.shownAbility = this.ability;
            int i = 0;
            n = App.gloom.monsterRows.size;
            while (i < n) {
                row = App.gloom.monsterRows.get(i);
                if (row.data.deckID == deck.id) {
                    if (flipOthers && row != this) {
                        row.showAbility(false, deck);
                    }
                    row.flipStore2();
                }
                ++i;
            }
        }
    }

    @Override
    public void roundEnd() {
        MonsterAbilityDeck deck = this.getAbilityDeck();
        if (deck.shownAbility != null) {
            MonsterRow row;
            this.flipStore1();
            int i = 0;
            int n = App.gloom.monsterRows.size;
            while (i < n) {
                row = App.gloom.monsterRows.get(i);
                if (row != this && row.data.deckID == deck.id) {
                    row.flipStore1();
                }
                ++i;
            }
            deck.shownAbility = null;
            this.flipStore2();
            i = 0;
            n = App.gloom.monsterRows.size;
            while (i < n) {
                row = App.gloom.monsterRows.get(i);
                if (row != this && row.data.deckID == deck.id) {
                    row.flipStore2();
                }
                ++i;
            }
        }
        if (deck.shuffle) {
            Array<MonsterAbility> abilities = deck.abilities;
            abilities.clear();
            abilities.addAll(App.findMonsterAbilityDeck((int)this.data.deckID).abilities);
            App.state.removeAbilities(abilities);
            abilities.shuffle();
            deck.abilitiesDiscard.clear();
            deck.shuffle = false;
        }
        this.ability = null;
        super.roundEnd();
    }

    public MonsterAbilityDeck getAbilityDeck() {
        return App.state.getAbilityDeck(this.data.deckID);
    }

    @Override
    public boolean remove() {
        this.getAbilityDeck().shownAbility = null;
        return super.remove();
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (!App.state.ignoreChanges) {
            this.glowAlpha = App.animate(this.glowAlpha, this.isCurrentTurn() ? 1 : 0, 0.2f, 2.0f, 2.0f, delta);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        HorizontalGroup monstersActor;
        this.updateExtraButtons();
        HorizontalGroup horizontalGroup = monstersActor = App.state.trackStandees ? this.monstersGroup : null;
        if (this.monstersCell.getActor() != monstersActor) {
            this.monstersCell.setActor(monstersActor);
            this.abilityCardStack.toFront();
            this.monstersGroup.toBack();
            if (App.state.trackStandees) {
                this.addNormalButton.setChecked(false);
                this.addEliteButton.setChecked(false);
            }
        }
        if (!App.state.trackStandees) {
            this.addNormalButton.setChecked(this.hasNormal);
            this.addEliteButton.setChecked(this.hasElite);
        }
        boolean full = this.boxes.size >= this.data.count && App.state.trackStandees;
        this.addNormalButton.setDisabled(full);
        this.addEliteButton.setDisabled(full);
        super.draw(batch, parentAlpha);
        this.endDesat(batch);
    }

    @Override
    public int getInitiative() {
        if (!this.isAlive()) {
            return 101;
        }
        if (App.state.canDraw) {
            return 100;
        }
        if (this.ability == null) {
            return 100;
        }
        if (!App.state.abilityCards) {
            return 100;
        }
        return this.ability.initiative;
    }

    @Override
    public float desat() {
        if (!this.isAlive()) {
            return 1.0f;
        }
        return super.desat();
    }

    @Override
    public boolean hasExpiringConditions() {
        for (MonsterBox box : this.boxes) {
            int i = box.monster.conditions.size - 1;
            while (i >= 0) {
                switch (box.monster.conditions.get(i)) {
                    case stun: 
                    case immobilize: 
                    case disarm: 
                    case muddle: 
                    case strengthen: 
                    case invisible: {
                        return true;
                    }
                }
                --i;
            }
        }
        return false;
    }

    public boolean hasElite() {
        if (!App.state.trackStandees) {
            return this.hasElite;
        }
        if (this.data.isBoss()) {
            return false;
        }
        for (MonsterBox box : this.boxes) {
            if (box.monster.type != MonsterType.elite) continue;
            return true;
        }
        return false;
    }

    public boolean hasNormal() {
        if (!App.state.trackStandees) {
            return this.hasNormal;
        }
        if (this.data.isBoss()) {
            return this.boxes.size > 0;
        }
        for (MonsterBox box : this.boxes) {
            if (box.monster.type != MonsterType.normal) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAlive() {
        if (App.state.trackStandees) {
            return this.boxes.size > 0;
        }
        return this.addNormalButton.isChecked() || this.addEliteButton.isChecked();
    }

    @Override
    public float getPrefHeight() {
        if (App.state.trackStandees && animatedHeight && Animator.enabled && this.animateHeight != 0.0f) {
            return this.animateHeight;
        }
        return super.getPrefHeight();
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
        this.levelString = String.valueOf(level);
        for (MonsterBox box : this.boxes) {
            Monster monster = box.monster;
            int oldMax = monster.hpMax;
            monster.stats = monster.data.stats[monster.type.ordinal()][level];
            monster.hpMax = monster.stats.hpMax();
            if (monster.hp < oldMax && oldMax != 0) continue;
            monster.hp = monster.hpMax;
        }
        App.state.changed();
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    protected void monsterAdded() {
        boolean allSummons = true;
        for (MonsterBox box : this.boxes) {
            if (box.monster.conditions.contains(Condition.summonNew, true)) continue;
            allSummons = false;
            break;
        }
        if (!allSummons && !App.state.canDraw && this.getAbilityDeck().shownAbility == null) {
            this.showAbility();
            if (App.state.abilityCards) {
                int initiative = this.ability.initiative;
                SnapshotArray<Actor> children = App.gloom.rows.getChildren();
                children.removeValue(this, true);
                int index = 0;
                int i = 0;
                int n = children.size;
                while (i < n) {
                    Row row = (Row)children.get(i);
                    if (row.isAlive()) {
                        if (row.getInitiative() > initiative) {
                            index = i;
                            break;
                        }
                        index = i + 1;
                    }
                    ++i;
                }
                children.insert(index, this);
            }
            Animator.storeChildren(App.gloom.rows, 0.5f);
        }
    }

    @Override
    public String toString() {
        return this.data.name;
    }
}

