/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.Game;
import com.esotericsoftware.gloomhavenhelper.GameConfig;
import com.esotericsoftware.gloomhavenhelper.network.Network;
import com.esotericsoftware.gloomhavenhelper.util.Serialization;
import com.esotericsoftware.minlog.Log;
import java.io.File;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class GameDesktop
extends Game {
    public static final ExecutorService threadPool = GameDesktop.newThreadPool(1, 60, "Pool", true);
    public static FileHandle configFile = new FileHandle(new File(System.getProperty("user.home"), ".ghh/config"));
    public static FileHandle configFileTemp = new FileHandle(new File(System.getProperty("user.home"), ".ghh/config.temp"));
    public static FileHandle stateFile = new FileHandle(new File(System.getProperty("user.home"), ".ghh/state"));
    public static FileHandle stateFileTemp = new FileHandle(new File(System.getProperty("user.home"), ".ghh/state.temp"));

    @Override
    public void loadConfig() {
        block5: {
            if (configFile.exists()) {
                try {
                    App.config = json.fromJson(GameConfig.class, configFile);
                }
                catch (Exception ex) {
                    if (Log.ERROR) {
                        Log.error("game", "Unable to read game config file.", ex);
                    }
                    if (!App.eclipse) break block5;
                    Gdx.app.exit();
                }
            }
        }
        if (App.config == null) {
            App.config = new GameConfig();
        }
    }

    @Override
    public void saveConfig() {
        block2: {
            Network.update();
            configFile.parent().mkdirs();
            try {
                json.toJson((Object)App.config, configFileTemp.writer(false));
                configFileTemp.copyTo(configFile);
                configFileTemp.delete();
            }
            catch (Exception ex) {
                if (!Log.ERROR) break block2;
                Log.error("game", "Unable to write game config file.", ex);
            }
        }
    }

    @Override
    public synchronized void loadState() {
        App.gameThread();
        if (stateFile.exists()) {
            byte[] bytes = stateFile.readBytes();
            Serialization.input.setBuffer(bytes);
            try {
                int changeNumber = Serialization.input.readInt();
                App.state = Serialization.read(Serialization.input);
                App.state.changeNumber = changeNumber;
                App.state.apply(false);
                Serialization.lastOutput.clear();
                Serialization.lastOutput.writeBytes(bytes, 0, (int)Serialization.input.total());
                this.storeUndo();
                return;
            }
            catch (Exception ex) {
                if (Log.ERROR) {
                    Log.error("game", "Unable to load game state from file.", ex);
                }
                App.toast("Unable to load game state!");
                this.stateLoaded(false);
                return;
            }
        }
        this.stateLoaded(true);
    }

    @Override
    public synchronized void saveState(byte[] bytes, int count) {
        block2: {
            try {
                stateFileTemp.writeBytes(bytes, 0, count, false);
                stateFileTemp.copyTo(stateFile);
                stateFileTemp.delete();
            }
            catch (Exception ex) {
                if (!Log.ERROR) break block2;
                Log.error("game", "Unable to write game state file.", ex);
            }
        }
    }

    @Override
    public Object currentThread() {
        return Thread.currentThread();
    }

    @Override
    public void thread(Runnable runnable) {
        threadPool.submit(runnable);
    }

    @Override
    public void close() {
        Runtime.getRuntime().halt(0);
    }

    @Override
    public boolean canOpenURL() {
        if (System.getProperty("os.name").contains("Mac")) {
            return false;
        }
        try {
            Object desktop = Class.forName("java.awt.Desktop").getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            return (Boolean)desktop.getClass().getMethod("isDesktopSupported", new Class[0]).invoke(desktop, new Object[0]);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    public void openURL(String url) {
        block2: {
            try {
                Object desktop = Class.forName("java.awt.Desktop").getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                desktop.getClass().getMethod("browse", URI.class).invoke(desktop, new URI(url));
            }
            catch (Throwable ex) {
                if (!Log.ERROR) break block2;
                Log.error("Unable to open URL: " + url, ex);
            }
        }
    }

    @Override
    public void packAtlas() {
        if (!App.eclipse) {
            return;
        }
        try {
            Class<?> settingsClass = Class.forName("com.badlogic.gdx.tools.texturepacker.TexturePacker$Settings");
            Object settings = settingsClass.newInstance();
            Class.forName("com.badlogic.gdx.tools.texturepacker.TexturePacker").getMethod("processIfModified", settingsClass, String.class, String.class, String.class).invoke(null, settings, "../ghh-core/assets-raw/skin", "../ghh-core/assets", "skin");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ThreadPoolExecutor newThreadPool(int maxThreads, int liveSeconds, final String name, final boolean daemon) {
        ThreadPoolExecutor pool = new ThreadPoolExecutor(maxThreads, maxThreads, liveSeconds, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, name);
                thread.setDaemon(daemon);
                return thread;
            }
        }, new ThreadPoolExecutor.AbortPolicy());
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }
}

