/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen;

import com.badlogic.gdx.jnigen.SharedLibraryFinder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JniGenSharedLibraryLoader {
    private static Set<String> loadedLibraries = new HashSet<String>();
    private String nativesJar;
    private SharedLibraryFinder libraryFinder;
    private ZipFile nativesZip = null;

    public JniGenSharedLibraryLoader() {
    }

    public JniGenSharedLibraryLoader(String nativesJar) {
        this.nativesJar = nativesJar;
    }

    public JniGenSharedLibraryLoader(String nativesJar, SharedLibraryFinder libraryFinder) {
        this.nativesJar = nativesJar;
        this.libraryFinder = libraryFinder;
        if (nativesJar != null) {
            try {
                this.nativesZip = new ZipFile(nativesJar);
            }
            catch (IOException e) {
                this.nativesZip = null;
            }
        }
    }

    public void setSharedLibraryFinder(SharedLibraryFinder libraryFinder) {
        this.libraryFinder = libraryFinder;
        if (this.nativesJar != null) {
            try {
                this.nativesZip = new ZipFile(this.nativesJar);
            }
            catch (IOException e) {
                this.nativesZip = null;
            }
        }
    }

    public String crc(InputStream input) {
        if (input == null) {
            return "" + System.nanoTime();
        }
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[4096];
        try {
            int length;
            while ((length = input.read(buffer)) != -1) {
                crc.update(buffer, 0, length);
            }
        }
        catch (Exception ex) {
            try {
                input.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Long.toString(crc.getValue());
    }

    private boolean loadLibrary(String sharedLibName) {
        if (sharedLibName == null) {
            return false;
        }
        String path = this.extractLibrary(sharedLibName);
        if (path != null) {
            System.load(path);
        }
        return path != null;
    }

    private String extractLibrary(String sharedLibName) {
        String srcCrc = this.crc(JniGenSharedLibraryLoader.class.getResourceAsStream("/" + sharedLibName));
        File nativesDir = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + "/jnigen/" + srcCrc);
        File nativeFile = new File(nativesDir, sharedLibName);
        String extractedCrc = null;
        if (nativeFile.exists()) {
            try {
                extractedCrc = this.crc(new FileInputStream(nativeFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (extractedCrc == null || !extractedCrc.equals(srcCrc)) {
            InputStream input;
            block8: {
                input = null;
                input = this.nativesJar == null ? JniGenSharedLibraryLoader.class.getResourceAsStream("/" + sharedLibName) : this.getFromJar(this.nativesJar, sharedLibName);
                if (input != null) break block8;
                return null;
            }
            try {
                int length;
                nativeFile.getParentFile().mkdirs();
                FileOutputStream output = new FileOutputStream(nativeFile);
                byte[] buffer = new byte[4096];
                while ((length = input.read(buffer)) != -1) {
                    output.write(buffer, 0, length);
                }
                input.close();
                output.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }
        return nativeFile.exists() ? nativeFile.getAbsolutePath() : null;
    }

    private InputStream getFromJar(String jarFile, String sharedLibrary) throws IOException {
        ZipFile file = new ZipFile(this.nativesJar);
        ZipEntry entry = file.getEntry(sharedLibrary);
        return file.getInputStream(entry);
    }

    public synchronized void load(String sharedLibName) {
        if (loadedLibraries.contains(sharedLibName)) {
            return;
        }
        boolean isWindows = System.getProperty("os.name").contains("Windows");
        boolean isLinux = System.getProperty("os.name").contains("Linux");
        boolean isMac = System.getProperty("os.name").contains("Mac");
        boolean isAndroid = false;
        boolean is64Bit = System.getProperty("os.arch").equals("amd64") || System.getProperty("os.arch").equals("x86_64");
        boolean isArm = System.getProperty("os.arch").equals("arm");
        String vm = System.getProperty("java.vm.name");
        if (vm != null && vm.contains("Dalvik")) {
            isAndroid = true;
            isWindows = false;
            isLinux = false;
            isMac = false;
            is64Bit = false;
        }
        boolean loaded = false;
        if (isWindows) {
            loaded = this.libraryFinder != null ? this.loadLibrary(this.libraryFinder.getSharedLibraryNameWindows(sharedLibName, is64Bit, this.nativesZip)) : (!is64Bit ? this.loadLibrary(String.valueOf(sharedLibName) + ".dll") : this.loadLibrary(String.valueOf(sharedLibName) + "64.dll"));
        }
        if (isLinux) {
            loaded = this.libraryFinder != null ? this.loadLibrary(this.libraryFinder.getSharedLibraryNameLinux(sharedLibName, is64Bit, isArm, this.nativesZip)) : (!is64Bit ? (isArm ? this.loadLibrary("lib" + sharedLibName + "Arm.so") : this.loadLibrary("lib" + sharedLibName + ".so")) : (isArm ? this.loadLibrary("lib" + sharedLibName + "Arm64.so") : this.loadLibrary("lib" + sharedLibName + "64.so")));
        }
        if (isMac) {
            loaded = this.libraryFinder != null ? this.loadLibrary(this.libraryFinder.getSharedLibraryNameMac(sharedLibName, is64Bit, this.nativesZip)) : (!is64Bit ? this.loadLibrary("lib" + sharedLibName + ".dylib") : this.loadLibrary("lib" + sharedLibName + "64.dylib"));
        }
        if (isAndroid) {
            if (this.libraryFinder != null) {
                System.loadLibrary(this.libraryFinder.getSharedLibraryNameAndroid(sharedLibName, this.nativesZip));
            } else {
                System.loadLibrary(sharedLibName);
            }
            loaded = true;
        }
        if (loaded) {
            loadedLibraries.add(sharedLibName);
        }
    }
}

