// Generated by gmmproc 2.74.1 -- DO NOT MODIFY!
#ifndef _GIOMM_BUFFEREDOUTPUTSTREAM_H
#define _GIOMM_BUFFEREDOUTPUTSTREAM_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2008 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <giomm/filteroutputstream.h>
#include <giomm/seekable.h>
#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GBufferedOutputStream = struct _GBufferedOutputStream;
using GBufferedOutputStreamClass = struct _GBufferedOutputStreamClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gio
{ class GIOMM_API BufferedOutputStream_Class; } // namespace Gio
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gio
{

/** The buffered output stream implements FilterOutputStream and provides for buffered writes.
 * By default, BufferedOutputStream's buffer size is set at 4 kilobytes, but you
 * can specify this to the constructor.
 *
 * To get the size of a buffer within a buffered input stream, use get_buffer_size().
 * To change the size of a buffered output stream's buffer, use set_buffer_size().
 * Note that the buffer's size cannot be reduced below the size of the data within the buffer.
 *
 * @ingroup Streams
 *
 * @newin{2,16}
 */

class GIOMM_API BufferedOutputStream : public Gio::FilterOutputStream, public Gio::Seekable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = BufferedOutputStream;
  using CppClassType = BufferedOutputStream_Class;
  using BaseObjectType = GBufferedOutputStream;
  using BaseClassType = GBufferedOutputStreamClass;

  // noncopyable
  BufferedOutputStream(const BufferedOutputStream&) = delete;
  BufferedOutputStream& operator=(const BufferedOutputStream&) = delete;

private:  friend class BufferedOutputStream_Class;
  static CppClassType bufferedoutputstream_class_;

protected:
  explicit BufferedOutputStream(const Glib::ConstructParams& construct_params);
  explicit BufferedOutputStream(GBufferedOutputStream* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  BufferedOutputStream(BufferedOutputStream&& src) noexcept;
  BufferedOutputStream& operator=(BufferedOutputStream&& src) noexcept;

  ~BufferedOutputStream() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GBufferedOutputStream*       gobj()       { return reinterpret_cast<GBufferedOutputStream*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GBufferedOutputStream* gobj() const { return reinterpret_cast<GBufferedOutputStream*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GBufferedOutputStream* gobj_copy();

private:

  
protected:
    explicit BufferedOutputStream(const Glib::RefPtr<OutputStream>& base_stream);


  //Note that we rename the size parameter to buffer_size because that is the actual name of the property.
    explicit BufferedOutputStream(const Glib::RefPtr<OutputStream>& base_stream, gsize buffer_size);


public:
  /** Creates a new buffered output stream for a base stream.
   *
   * @param base_stream An InputStream.
   * @result an OutputStream for the given base stream.
	 */
  
  static Glib::RefPtr<BufferedOutputStream> create(const Glib::RefPtr<OutputStream>& base_stream);


  /** Creates a new buffered output stream with a given buffer size.
   *
   * @param base_stream An InputStream.
   * @param buffer_size A size.
   * @result an OutputStream with an internal buffer set to size.
	 */
  static Glib::RefPtr<BufferedOutputStream> create_sized(const Glib::RefPtr<OutputStream>& base_stream, gsize buffer_size);

  
  /** Gets the size of the buffer in the @a stream.
   * 
   * @return The current size of the buffer.
   */
  gsize get_buffer_size() const;
  
  /** Sets the size of the internal buffer to @a size.
   * 
   * @param size A #gsize.
   */
  void set_buffer_size(gsize size);

  
  /** Sets whether or not the @a stream's buffer should automatically grow.
   * If @a auto_grow is true, then each write will just make the buffer
   * larger, and you must manually flush the buffer to actually write out
   * the data to the underlying stream.
   * 
   * @param auto_grow A <tt>bool</tt>.
   */
  void set_auto_grow(bool auto_grow = true);
  
  /** Checks if the buffer automatically grows as data is added.
   * 
   * @return <tt>true</tt> if the @a stream's buffer automatically grows,
   * <tt>false</tt> otherwise.
   */
  bool get_auto_grow() const;

  /** The size of the backend buffer.
   *
   * Default value: 4096
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_buffer_size() ;

/** The size of the backend buffer.
   *
   * Default value: 4096
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_buffer_size() const;

  /** Whether the buffer should automatically grow.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_auto_grow() ;

/** Whether the buffer should automatically grow.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_auto_grow() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::BufferedOutputStream
   */
  GIOMM_API
  Glib::RefPtr<Gio::BufferedOutputStream> wrap(GBufferedOutputStream* object, bool take_copy = false);
}


#endif /* _GIOMM_BUFFEREDOUTPUTSTREAM_H */

