// Generated by gmmproc 2.58.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <glibmm/varianttype.h>
#include <glibmm/private/varianttype_p.h>


/* Copyright 2010 The glibmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glibmm/varianttype.h>
#include <glibmm/utility.h>
#include <glib.h>

namespace Glib
{

VariantType::VariantType(const GVariantType* castitem)
{
  if (castitem)
    gobject_ = g_variant_type_copy(castitem);
  else
    gobject_ = nullptr;
}

VariantType::VariantType(const std::string& type_string)
: gobject_(g_variant_type_new(type_string.c_str()))
{
}

VariantType&
VariantType::operator=(const GVariantType* castitem)
{
  if (gobject_)
  {
    g_variant_type_free(gobject_);
  }

  if (castitem)
    gobject_ = g_variant_type_copy(castitem);
  else
    gobject_ = nullptr;

  return *this;
}

VariantType
VariantType::create_tuple(const std::vector<VariantType>& items)
{
  using var_ptr = GVariantType*;
  const auto var_array = new var_ptr[items.size()];

  for (std::vector<VariantType>::size_type i = 0; i < items.size(); i++)
  {
    var_array[i] = const_cast<GVariantType*>(items[i].gobj());
  }

  auto result = Glib::wrap(g_variant_type_new_tuple(var_array, items.size()));
  delete[] var_array;
  return result;
}

const VariantType VARIANT_TYPE_BOOL(G_VARIANT_TYPE_BOOLEAN);

const VariantType VARIANT_TYPE_BYTE(G_VARIANT_TYPE_BYTE);

const VariantType VARIANT_TYPE_INT16(G_VARIANT_TYPE_INT16);

const VariantType VARIANT_TYPE_UINT16(G_VARIANT_TYPE_UINT16);

const VariantType VARIANT_TYPE_INT32(G_VARIANT_TYPE_INT32);

const VariantType VARIANT_TYPE_UINT32(G_VARIANT_TYPE_UINT32);

const VariantType VARIANT_TYPE_INT64(G_VARIANT_TYPE_INT64);

const VariantType VARIANT_TYPE_UINT64(G_VARIANT_TYPE_UINT64);

const VariantType VARIANT_TYPE_DOUBLE(G_VARIANT_TYPE_DOUBLE);

const VariantType VARIANT_TYPE_STRING(G_VARIANT_TYPE_STRING);

const VariantType VARIANT_TYPE_OBJECT_PATH(G_VARIANT_TYPE_OBJECT_PATH);

const VariantType VARIANT_TYPE_SIGNATURE(G_VARIANT_TYPE_SIGNATURE);

const VariantType VARIANT_TYPE_VARIANT(G_VARIANT_TYPE_VARIANT);

const VariantType VARIANT_TYPE_HANDLE(G_VARIANT_TYPE_HANDLE);

const VariantType VARIANT_TYPE_UNIT(G_VARIANT_TYPE_UNIT);

const VariantType VARIANT_TYPE_ANY(G_VARIANT_TYPE_ANY);

const VariantType VARIANT_TYPE_BASIC(G_VARIANT_TYPE_BASIC);

const VariantType VARIANT_TYPE_MAYBE(G_VARIANT_TYPE_MAYBE);

const VariantType VARIANT_TYPE_ARRAY(G_VARIANT_TYPE_ARRAY);

const VariantType VARIANT_TYPE_TUPLE(G_VARIANT_TYPE_TUPLE);

const VariantType VARIANT_TYPE_DICT_ENTRY(G_VARIANT_TYPE_DICT_ENTRY);

const VariantType VARIANT_TYPE_DICTIONARY(G_VARIANT_TYPE_DICTIONARY);

const VariantType VARIANT_TYPE_STRING_ARRAY(G_VARIANT_TYPE_STRING_ARRAY);

const VariantType VARIANT_TYPE_OBJECT_PATH_ARRAY(G_VARIANT_TYPE_OBJECT_PATH_ARRAY);

const VariantType VARIANT_TYPE_BYTESTRING(G_VARIANT_TYPE_BYTESTRING);

const VariantType VARIANT_TYPE_BYTESTRING_ARRAY(G_VARIANT_TYPE_BYTESTRING_ARRAY);

std::string
VariantType::get_string() const
{
  return std::string(g_variant_type_peek_string(gobj()), g_variant_type_get_string_length(gobj()));
}

std::vector<VariantType> VariantType::get_item_types() const
{
  std::vector<VariantType> result;
  auto next_item_type = g_variant_type_first(gobj());
  while (next_item_type)
  {
    result.emplace_back(const_cast<GVariantType*>(next_item_type), true);
    next_item_type = g_variant_type_next(next_item_type);
  }
  return result;
}

} // namespace GLib

namespace
{
} // anonymous namespace


namespace Glib
{

Glib::VariantType wrap(GVariantType* object, bool take_copy /* = false */)
{
  return Glib::VariantType(object, take_copy);
}

} // namespace Glib


namespace Glib
{


VariantType::VariantType()
:
  gobject_ (nullptr) // Allows creation of invalid wrapper, e.g. for output arguments to methods.
{}

VariantType::VariantType(const VariantType& src)
:
  gobject_ ((src.gobject_) ? g_variant_type_copy(src.gobject_) : nullptr)
{}

VariantType::VariantType(GVariantType* castitem, bool make_a_copy /* = false */)
{
  if(!make_a_copy)
  {
    // It was given to us by a function which has already made a copy for us to keep.
    gobject_ = castitem;
  }
  else
  {
    // We are probably getting it via direct access to a struct,
    // so we can not just take it - we have to take a copy of it.
    if(castitem)
      gobject_ = g_variant_type_copy(castitem);
    else
      gobject_ = nullptr;
  }
}


VariantType& VariantType::operator=(const VariantType& src)
{
  const auto new_gobject = (src.gobject_) ? g_variant_type_copy(src.gobject_) : nullptr;

  if(gobject_)
    g_variant_type_free(gobject_);

  gobject_ = new_gobject;

  return *this;
}

VariantType::VariantType(VariantType&& other) noexcept
:
  gobject_(other.gobject_)
{
  other.gobject_ = nullptr;
}

VariantType& VariantType::operator=(VariantType&& other) noexcept
{
  VariantType temp (other);
  swap(temp);
  return *this;
}

VariantType::~VariantType() noexcept
{
  if(gobject_)
    g_variant_type_free(gobject_);
}

void VariantType::swap(VariantType& other) noexcept
{
  std::swap(gobject_, other.gobject_);
}

GVariantType* VariantType::gobj_copy() const
{
  return g_variant_type_copy(gobject_);
}


VariantType VariantType::create_array(const VariantType& element)
{
  return Glib::wrap(g_variant_type_new_array((element).gobj()));
}

VariantType VariantType::create_maybe(const VariantType& element)
{
  return Glib::wrap(g_variant_type_new_maybe((element).gobj()));
}

VariantType VariantType::create_dict_entry(const VariantType& key, const VariantType& value)
{
  return Glib::wrap(g_variant_type_new_dict_entry((key).gobj(), (value).gobj()));
}

gsize VariantType::_get_string_length() const
{
  return g_variant_type_get_string_length(const_cast<GVariantType*>(gobj()));
}

bool VariantType::is_definite() const
{
  return g_variant_type_is_definite(const_cast<GVariantType*>(gobj()));
}

bool VariantType::is_container() const
{
  return g_variant_type_is_container(const_cast<GVariantType*>(gobj()));
}

bool VariantType::is_basic() const
{
  return g_variant_type_is_basic(const_cast<GVariantType*>(gobj()));
}

bool VariantType::is_maybe() const
{
  return g_variant_type_is_maybe(const_cast<GVariantType*>(gobj()));
}

bool VariantType::is_array() const
{
  return g_variant_type_is_array(const_cast<GVariantType*>(gobj()));
}

bool VariantType::is_tuple() const
{
  return g_variant_type_is_tuple(const_cast<GVariantType*>(gobj()));
}

bool VariantType::is_dict_entry() const
{
  return g_variant_type_is_dict_entry(const_cast<GVariantType*>(gobj()));
}

bool VariantType::is_variant() const
{
  return g_variant_type_is_variant(const_cast<GVariantType*>(gobj()));
}

guint VariantType::hash() const
{
  return g_variant_type_hash(const_cast<GVariantType*>(gobj()));
}

bool VariantType::equal(const VariantType& other) const
{
  return g_variant_type_equal(const_cast<GVariantType*>(gobj()), const_cast<GVariantType*>((other).gobj()));
}

bool VariantType::is_subtype_of(const VariantType& supertype) const
{
  return g_variant_type_is_subtype_of(const_cast<GVariantType*>(gobj()), (supertype).gobj());
}

VariantType VariantType::element() const
{
  return Glib::wrap(const_cast<GVariantType*>(g_variant_type_element(const_cast<GVariantType*>(gobj()))), true);
}

#ifndef GLIBMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
VariantType VariantType::first() const
{
  return Glib::wrap(const_cast<GVariantType*>(g_variant_type_first(const_cast<GVariantType*>(gobj()))), true);
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GLIBMM_DISABLE_DEPRECATED

#ifndef GLIBMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
VariantType VariantType::next() const
{
  return Glib::wrap(const_cast<GVariantType*>(g_variant_type_next(const_cast<GVariantType*>(gobj()))), true);
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GLIBMM_DISABLE_DEPRECATED

gsize VariantType::n_items() const
{
  return g_variant_type_n_items(const_cast<GVariantType*>(gobj()));
}

VariantType VariantType::key() const
{
  return Glib::wrap(const_cast<GVariantType*>(g_variant_type_key(const_cast<GVariantType*>(gobj()))), true);
}

VariantType VariantType::value() const
{
  return Glib::wrap(const_cast<GVariantType*>(g_variant_type_value(const_cast<GVariantType*>(gobj()))), true);
}


} // namespace Glib


