/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.sfsb.initialization;

import com.sun.ejb.base.container.util.CacheProperties;
import com.sun.ejb.base.sfsb.initialization.AbstractPersistenceStrategyBuilder;
import com.sun.ejb.base.sfsb.store.FileStoreManager;
import com.sun.ejb.spi.container.SFSBContainerInitialization;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service(name="file")
public class FileStrategyBuilder
extends AbstractPersistenceStrategyBuilder {
    @Inject
    CacheProperties cacheProps;

    public void initializePersistenceStrategy(SFSBContainerInitialization container, EjbDescriptor descriptor) {
        try {
            super.initializeStrategy(container, descriptor, this.cacheProps);
            SFSBStoreManager storeManager = this.createStoreManager(container, descriptor);
            container.setSFSBStoreManager(storeManager);
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "Could not initialize container using FilestrategyBuilder", th);
        }
    }

    private SFSBStoreManager createStoreManager(SFSBContainerInitialization container, EjbDescriptor descriptor) {
        FileStoreManager manager = new FileStoreManager();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("com.sun.ejb.spi.sfsb.store.name", descriptor.getName());
        map.put("com.sun.ejb.spi.sfsb.store.containerid", new Long(descriptor.getUniqueId()));
        this.cacheProps.init(descriptor);
        map.put("com.sun.ejb.spi.sfsb.store.timeout", new Integer(this.cacheProps.getRemovalTimeoutInSeconds()));
        map.put("com.sun.ejb.spi.sfsb.store.grace.timeout", new Integer(super.getRemovalGracePeriodInSeconds()));
        map.put("com.sun.ejb.spi.sfsb.store.directory", this.getPassivationDirectoryName(descriptor));
        _logger.log(Level.FINE, "Initialzing FileStoreManager with: " + map);
        manager.initSessionStore(map);
        _logger.log(Level.FINE, "INITIALZED FileStoreManager: " + manager);
        return manager;
    }

    private String getPassivationDirectoryName(EjbDescriptor desc) {
        String passivationDirName = null;
        try {
            Application application = desc.getApplication();
            Object dirName = null;
            String componentSeparator = "_";
            if (application.isVirtual()) {
                String archURI = desc.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
                passivationDirName = this.cacheProps.getPassivationStorePath() + File.separator + FileUtils.makeFriendlyFilename((String)archURI) + componentSeparator + desc.getName();
            } else {
                passivationDirName = this.cacheProps.getPassivationStorePath() + File.separator + application.getRegistrationName() + componentSeparator + desc.getName() + componentSeparator + desc.getUniqueId();
            }
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "ejb.sfsb_helper_get_passivation_dir_failed", th);
        }
        return passivationDirName;
    }
}

