/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VersionExtracter {
    private static final StringManager stringManager = StringManager.getManager(VersionExtracter.class);
    private static final Logger logger = LogService.getLogger();
    private final CommonInfoModel common;

    public VersionExtracter(CommonInfoModel common) {
        this.common = common;
    }

    public String formatVersionEditionStrings(String v, String e) {
        return v + ";" + e;
    }

    public String extractVersionFromConfigFile(String cfgFilename) {
        String verEdStr = null;
        String versionString = null;
        File configFile = new File(cfgFilename);
        if (!configFile.exists() || !configFile.isFile()) {
            return verEdStr;
        }
        UpgradeUtils upgrUtils = UpgradeUtils.getUpgradeUtils(this.common);
        Document adminServerDoc = upgrUtils.getDomainDocumentElement(configFile.toString());
        try {
            String publicID = adminServerDoc.getDoctype().getPublicId();
            String appservString = stringManager.getString("common.versionextracter.appserver.string");
            int indx = publicID.indexOf(appservString);
            if (indx > -1) {
                String tmpS = publicID.substring(indx + appservString.length()).trim();
                String[] s = tmpS.split(" ");
                versionString = s[0];
            }
            verEdStr = this.formatVersionEditionStrings(versionString, "All");
        }
        catch (Exception ex) {
            Element rootElement = adminServerDoc.getDocumentElement();
            if (!"domain".equals(rootElement.getTagName())) {
                logger.log(Level.SEVERE, stringManager.getString("common.versionextracter.dtd_product_version_find_failured"), ex);
            }
            verEdStr = this.formatVersionEditionStrings("3.0", "All");
        }
        return verEdStr;
    }
}

