/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.util;

import com.sun.faces.facelets.tag.TagLibrary;
import com.sun.faces.util.Util;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionLibrary
implements TagLibrary {
    private String namespace;
    private Map<String, Method> functions;

    public FunctionLibrary(Class<?> functionsClass, String namespace) {
        Util.notNull("functionsClass", functionsClass);
        Util.notNull("namespace", namespace);
        this.namespace = namespace;
        try {
            Method[] methods = functionsClass.getMethods();
            this.functions = new HashMap<String, Method>(methods.length, 1.0f);
            for (Method method : methods) {
                if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) continue;
                this.functions.put(method.getName(), method);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean containsNamespace(String ns, Tag t) {
        return this.namespace.equals(ns);
    }

    @Override
    public boolean containsTagHandler(String ns, String localName) {
        return false;
    }

    @Override
    public TagHandler createTagHandler(String ns, String localName, TagConfig tag) throws FacesException {
        return null;
    }

    @Override
    public boolean containsFunction(String ns, String name) {
        return this.namespace.equals(ns) && this.functions.containsKey(name);
    }

    @Override
    public Method createFunction(String ns, String name) {
        if (this.namespace.equals(ns)) {
            return this.functions.get(name);
        }
        return null;
    }
}

