/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.BasicQueue;
import com.sun.messaging.BasicTopic;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.JMSPacket;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.net.IPAddress;
import com.sun.messaging.jms.Message;
import com.sun.messaging.jms.ra.ConvertValue;
import com.sun.messaging.jms.ra.DirectBytesPacket;
import com.sun.messaging.jms.ra.DirectMapPacket;
import com.sun.messaging.jms.ra.DirectObjectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import com.sun.messaging.jms.ra.DirectStreamPacket;
import com.sun.messaging.jms.ra.DirectTextPacket;
import com.sun.messaging.jms.ra.DirectXAResource;
import com.sun.messaging.jms.ra.TemporaryQueue;
import com.sun.messaging.jms.ra.TemporaryTopic;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;

public class DirectPacket
implements JMSPacket,
javax.jms.Message,
Message {
    protected Packet pkt = null;
    private SysMessageID receivedSysMessageID = null;
    private Hashtable<String, Object> properties = null;
    private long consumerId = 0L;
    private javax.jms.Destination jmsDestination = null;
    private javax.jms.Destination jmsReplyTo = null;
    private String jmsMessageID = null;
    private boolean jmsMessageIDSet = false;
    private boolean readOnlyBody = false;
    private boolean readOnlyProperties = false;
    private DirectSession ds = null;
    private boolean browserMessage = false;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectPacket";
    private static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final transient String _lgrNameJMSMessage = "javax.jms.Message.mqjmsra";
    protected static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    protected static final transient Logger _loggerJM = Logger.getLogger("javax.jms.Message.mqjmsra");
    private static final transient String _lgrMIDPrefix = "MQJMSRA_DM";
    protected static final transient String _lgrMID_EET = "MQJMSRA_DM1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_DM1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_DM2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_DM3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_DM4001: ";
    protected static int _logLevel;
    protected static boolean _logFINE;
    protected static final String UTF8 = "UTF8";
    protected static final int DIRECT_PACKET_LOCAL_PORT = 1;
    protected static final byte[] pktIPAddress;
    protected static final byte[] pktMacAddress;

    public DirectPacket(DirectSession directSession, JMSService jMSService) throws JMSException {
        if (_logFINE) {
            Object[] objectArray = new Object[]{directSession, jMSService};
            _loggerOC.entering(_className, "constructor()", objectArray);
        }
        this.ds = directSession;
        this.pkt = new Packet();
        this._setDefaultValues();
    }

    public DirectPacket(JMSPacket jMSPacket, long l, DirectSession directSession, JMSService jMSService) throws JMSException {
        if (jMSPacket == null) {
            String string = "MQJMSRA_DM4001: DirectPacket:Construct on deliver:Failed due to invalid JMSPacket.";
            JMSException jMSException = new JMSException(string);
            throw jMSException;
        }
        this.pkt = jMSPacket.getPacket();
        this.consumerId = l;
        this.ds = directSession;
        this._getPropertiesFromPacket();
        this.readOnlyProperties = true;
        this.readOnlyBody = true;
    }

    protected static final javax.jms.Message constructMessage(JMSPacket jMSPacket, long l, DirectSession directSession, JMSService jMSService, boolean bl) throws JMSException {
        DirectPacket directPacket = null;
        boolean bl2 = true;
        Exception exception = null;
        int n = 0;
        try {
            n = jMSPacket.getPacket().getPacketType();
            switch (n) {
                case 6: {
                    directPacket = new DirectPacket(jMSPacket, l, directSession, jMSService);
                    break;
                }
                case 2: {
                    directPacket = new DirectBytesPacket(jMSPacket, l, directSession, jMSService);
                    break;
                }
                case 3: {
                    directPacket = new DirectMapPacket(jMSPacket, l, directSession, jMSService);
                    break;
                }
                case 5: {
                    directPacket = new DirectObjectPacket(jMSPacket, l, directSession, jMSService);
                    break;
                }
                case 4: {
                    directPacket = new DirectStreamPacket(jMSPacket, l, directSession, jMSService);
                    break;
                }
                case 1: {
                    directPacket = new DirectTextPacket(jMSPacket, l, directSession, jMSService);
                    break;
                }
                default: {
                    bl2 = false;
                    break;
                }
            }
        }
        catch (Exception exception2) {
            bl2 = false;
            exception = exception2;
        }
        if (!bl2) {
            String string = "MQJMSRA_DM4001: DirectPacket:constructMessage():Failed on " + (!bl2 ? " invalid " : "") + "PacketType=" + n + (exception != null ? " due to Exception=" + exception.getMessage() : "") + ".";
            JMSException jMSException = new JMSException(string);
            if (exception != null) {
                jMSException.initCause((Throwable)exception);
            }
            throw jMSException;
        }
        ((DirectPacket)directPacket).browserMessage = bl;
        if (!bl) {
            directPacket.setReceivedSysMessageID((SysMessageID)jMSPacket.getPacket().getSysMessageID().clone());
        }
        return directPacket;
    }

    protected static final DirectPacket constructFromForeignMessage(JMSService jMSService, DirectSession directSession, javax.jms.Message message) throws JMSException {
        Object object;
        Object object2;
        Object object3;
        Object object4 = null;
        boolean bl = true;
        Object var5_5 = null;
        if (message instanceof TextMessage) {
            object4 = object3 = new DirectTextPacket(directSession, jMSService, ((TextMessage)message).getText());
        } else if (message instanceof MapMessage) {
            object3 = new DirectMapPacket(directSession, jMSService);
            object2 = null;
            object = ((MapMessage)message).getMapNames();
            while (object.hasMoreElements()) {
                object2 = (String)object.nextElement();
                ((DirectMapPacket)object3).setObject((String)object2, ((MapMessage)message).getObject((String)object2));
            }
            object4 = object3;
        } else if (message instanceof ObjectMessage) {
            object4 = object3 = new DirectObjectPacket(directSession, jMSService, ((ObjectMessage)message).getObject());
        } else if (message instanceof BytesMessage) {
            object3 = new DirectBytesPacket(directSession, jMSService);
            ((BytesMessage)message).reset();
            try {
                while (true) {
                    byte by = ((BytesMessage)message).readByte();
                    ((DirectBytesPacket)object3).writeByte(by);
                }
            }
            catch (MessageEOFException messageEOFException) {
            }
            catch (Exception exception) {
                String string = "MQJMSRA_DM4001: DirectPacket:+constructFromForeignMessage():Failed on converting foreign BytesMessage due to Exception=" + exception.getMessage();
                JMSException jMSException = new JMSException(string);
                jMSException.initCause((Throwable)exception);
                throw jMSException;
            }
            object4 = object3;
        } else if (message instanceof StreamMessage) {
            object3 = new DirectStreamPacket(directSession, jMSService);
            ((StreamMessage)message).reset();
            object2 = null;
            try {
                while (true) {
                    object2 = ((StreamMessage)message).readObject();
                    ((DirectStreamPacket)object3).writeObject(object2);
                }
            }
            catch (MessageEOFException messageEOFException) {
            }
            catch (Exception exception) {
                String string = "MQJMSRA_DM4001: DirectPacket:+constructFromForeignMessage():Failed on converting foreign StreamMessage due to Exception=" + exception.getMessage();
                JMSException jMSException = new JMSException(string);
                jMSException.initCause((Throwable)exception);
                throw jMSException;
            }
            object4 = object3;
        } else {
            object4 = object3 = new DirectPacket(directSession, jMSService);
        }
        if (object4 != null) {
            ((DirectPacket)object4).setJMSCorrelationID(message.getJMSCorrelationID());
            ((DirectPacket)object4).setJMSType(message.getJMSType());
            object3 = message.getPropertyNames();
            object2 = null;
            object = null;
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                object = message.getObjectProperty((String)object2);
                ((DirectPacket)object4).setObjectProperty((String)object2, object);
            }
        }
        return object4;
    }

    protected static final void updateForeignMessageAfterSend(DirectPacket directPacket, javax.jms.Message message) throws JMSException {
        message.setJMSDeliveryMode(directPacket.getJMSDeliveryMode());
        message.setJMSExpiration((long)directPacket.getJMSPriority());
        message.setJMSPriority(directPacket.getJMSPriority());
        message.setJMSTimestamp(directPacket.getJMSTimestamp());
        message.setJMSMessageID(directPacket.getJMSMessageID());
        message.setJMSDestination(directPacket.getJMSDestination());
    }

    public Packet getPacket() {
        return this.pkt;
    }

    public javax.jms.Message getMessage() {
        return this;
    }

    protected SysMessageID getReceivedSysMessageID() {
        return this.receivedSysMessageID;
    }

    protected void setReceivedSysMessageID(SysMessageID sysMessageID) {
        this.receivedSysMessageID = sysMessageID;
    }

    public void acknowledge() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: acknowledge()");
        }
        if (this.browserMessage) {
            return;
        }
    }

    public void clearBody() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: clearBody()");
        }
        this.pkt.clearMessageBody();
        this._setReadOnlyBody(false);
    }

    public void clearProperties() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: clearProperties()");
        }
        this._setReadOnlyProperties(false);
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    public boolean getBooleanProperty(String string) throws JMSException {
        Object object;
        if (_logFINE) {
            object = "getBooleanProperty()";
            _loggerJM.fine(_lgrMID_INF + (String)object + string);
        }
        object = null;
        if (this.properties != null) {
            object = this.properties.get(string);
        }
        return ConvertValue.toBoolean(object);
    }

    public byte getByteProperty(String string) throws JMSException {
        Object object;
        if (_logFINE) {
            object = "getByteProperty()";
            _loggerJM.fine(_lgrMID_INF + (String)object + string);
        }
        object = null;
        if (this.properties != null) {
            object = this.properties.get(string);
        }
        return ConvertValue.toByte(object);
    }

    public double getDoubleProperty(String string) throws JMSException {
        Object object;
        if (_logFINE) {
            object = "getDoubleProperty()";
            _loggerJM.fine(_lgrMID_INF + (String)object + string);
        }
        object = null;
        if (this.properties != null) {
            object = this.properties.get(string);
        }
        return ConvertValue.toDouble(object);
    }

    public float getFloatProperty(String string) throws JMSException {
        Object object;
        if (_logFINE) {
            object = "getFloatProperty()";
            _loggerJM.fine(_lgrMID_INF + (String)object + string);
        }
        object = null;
        if (this.properties != null) {
            object = this.properties.get(string);
        }
        return ConvertValue.toFloat(object);
    }

    public int getIntProperty(String string) throws JMSException {
        Object object;
        if (_logFINE) {
            object = "getIntProperty()";
            _loggerJM.fine(_lgrMID_INF + (String)object + string);
        }
        object = null;
        if (this.properties != null) {
            object = this.properties.get(string);
        }
        return ConvertValue.toInt(object);
    }

    public String getJMSCorrelationID() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSCorrelationID()");
        }
        return this.pkt.getCorrelationID();
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSCorrelationIDAsBytes()");
        }
        byte[] byArray = null;
        try {
            byArray = this.pkt.getCorrelationID().getBytes(UTF8);
        }
        catch (Exception exception) {
            String string = "MQJMSRA_DM4001: getJMSCorrelationIDAsBytes() failed :due to " + exception.getMessage();
            JMSException jMSException = new JMSException(string);
            _loggerJM.severe(string);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        return byArray;
    }

    public int getJMSDeliveryMode() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSDeliveryMode()=" + (this.pkt.getPersistent() ? 2 : 1));
        }
        if (this.pkt.getPersistent()) {
            return 2;
        }
        return 1;
    }

    public javax.jms.Destination getJMSDestination() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSDestination()");
        }
        String string = null;
        String string2 = null;
        if (this.jmsDestination == null && (this.getReceivedSysMessageID() != null || this.browserMessage)) {
            try {
                string = this.pkt.getDestination();
                string2 = this.pkt.getDestinationClass();
                this.jmsDestination = (Destination)Class.forName(string2).newInstance();
                ((Destination)this.jmsDestination).setProperty("imqDestinationName", string);
            }
            catch (Exception exception) {
                this.jmsDestination = this._constructMQDestination(string);
            }
        }
        return this.jmsDestination;
    }

    public long getJMSExpiration() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSExpiration()");
        }
        return this.pkt.getExpiration();
    }

    public String getJMSMessageID() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSMessageID()");
        }
        if (this.jmsMessageIDSet) {
            return this.jmsMessageID;
        }
        return "ID:" + this.pkt.getMessageID();
    }

    public int getJMSPriority() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSPriority()");
        }
        return this.pkt.getPriority();
    }

    public boolean getJMSRedelivered() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSRedelivered()");
        }
        return this.pkt.getRedelivered();
    }

    public javax.jms.Destination getJMSReplyTo() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSReplyTo()");
        }
        String string = null;
        String string2 = null;
        if (this.jmsReplyTo == null && (this.getReceivedSysMessageID() != null || this.browserMessage)) {
            if (this.pkt.getReplyTo() == null) {
                return null;
            }
            try {
                string = this.pkt.getReplyTo();
                string2 = this.pkt.getReplyToClass();
                this.jmsReplyTo = (Destination)Class.forName(string2).newInstance();
                ((Destination)this.jmsReplyTo).setProperty("imqDestinationName", string);
            }
            catch (Exception exception) {
                this.jmsReplyTo = this._constructMQDestination(string);
            }
        }
        return this.jmsReplyTo;
    }

    public long getJMSTimestamp() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSTimestamp()");
        }
        return this.pkt.getTimestamp();
    }

    public String getJMSType() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSType()");
        }
        return this.pkt.getMessageType();
    }

    public long getLongProperty(String string) throws JMSException {
        Object object;
        if (_logFINE) {
            object = "getLongProperty()";
            _loggerJM.fine(_lgrMID_INF + (String)object + string);
        }
        object = null;
        if (this.properties != null) {
            object = this.properties.get(string);
        }
        return ConvertValue.toLong(object);
    }

    public Object getObjectProperty(String string) throws JMSException {
        if (_logFINE) {
            String string2 = "getObjectProperty()";
            _loggerJM.fine(_lgrMID_INF + string2 + string);
        }
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public Enumeration getPropertyNames() throws JMSException {
        if (_logFINE) {
            String string = "getPropertyNames()";
            _loggerJM.fine(_lgrMID_INF + string);
        }
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties.keys();
    }

    public short getShortProperty(String string) throws JMSException {
        Object object;
        if (_logFINE) {
            object = "getShortProperty()";
            _loggerJM.fine(_lgrMID_INF + (String)object + string);
        }
        object = null;
        if (this.properties != null) {
            object = this.properties.get(string);
        }
        return ConvertValue.toShort(object);
    }

    public String getStringProperty(String string) throws JMSException {
        Object object;
        if (_logFINE) {
            object = "getStringProperty()";
            _loggerJM.fine(_lgrMID_INF + (String)object + string);
        }
        if (this.properties == null || (object = this.properties.get(string)) == null) {
            return null;
        }
        return ConvertValue.toString(object);
    }

    public boolean propertyExists(String string) throws JMSException {
        if (_logFINE) {
            String string2 = "propertyExists()";
            _loggerJM.fine(_lgrMID_INF + string2 + string);
        }
        if (this.properties == null) {
            return false;
        }
        try {
            return this.properties.containsKey(string);
        }
        catch (Exception exception) {
            String string3 = "MQJMSRA_DM4001: propertyExists() failed :due to " + exception.getMessage();
            JMSException jMSException = new JMSException(string3);
            _loggerJM.severe(string3);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
    }

    public void setBooleanProperty(String string, boolean bl) throws JMSException {
        this._checkAndSetProperty("setBooleanProperty()", string, bl);
    }

    public void setByteProperty(String string, byte by) throws JMSException {
        this._checkAndSetProperty("setByteProperty()", string, by);
    }

    public void setDoubleProperty(String string, double d) throws JMSException {
        this._checkAndSetProperty("setDoubleProperty()", string, d);
    }

    public void setFloatProperty(String string, float f) throws JMSException {
        this._checkAndSetProperty("setFloatProperty()", string, Float.valueOf(f));
    }

    public void setIntProperty(String string, int n) throws JMSException {
        this._checkAndSetProperty("setIntProperty()", string, n);
    }

    public void setJMSCorrelationID(String string) throws JMSException {
        _loggerJM.fine("MQJMSRA_DM1101: setJMSCorrelationID()" + string);
        this.pkt.setCorrelationID(string);
    }

    public void setJMSCorrelationIDAsBytes(byte[] byArray) throws JMSException {
        if (_logFINE) {
            String string = "setJMSCorrelationIDAsBytes()";
            _loggerJM.fine(_lgrMID_INF + string + byArray);
        }
        try {
            this.pkt.setCorrelationID(new String(byArray, UTF8));
        }
        catch (Exception exception) {
            String string = "setJMSCorrelationIDAsBytes()";
            String string2 = _lgrMID_EXC + string + ":Caught Exception:" + string + ":" + exception.getMessage();
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)exception);
            _loggerJM.severe(string2);
            throw jMSException;
        }
    }

    public void setJMSDeliveryMode(int n) throws JMSException {
        String string;
        if (_logFINE) {
            string = "setJMSDeliveryMode()";
            _loggerJM.fine(_lgrMID_INF + string + ":" + n);
        }
        if (n == 2) {
            this.pkt.setPersistent(true);
        } else if (n == 1) {
            this.pkt.setPersistent(false);
        } else {
            string = "setJMSDeliveryMode()";
            String string2 = _lgrMID_EXC + string + ":Invalid deliveryMode=" + n;
            _loggerJM.severe(string2);
            throw new JMSException(string2);
        }
    }

    public void setJMSDestination(javax.jms.Destination destination) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: setJMSDestination()" + destination);
        }
        this.jmsDestination = destination;
    }

    public void setJMSExpiration(long l) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: setJMSExpiration()" + l);
        }
        this.pkt.setExpiration(l);
    }

    public void setJMSMessageID(String string) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: setJMSMessageID()" + string);
        }
        this.jmsMessageIDSet = true;
        this.jmsMessageID = string;
    }

    public void setJMSPriority(int n) throws JMSException {
        String string;
        if (_logFINE) {
            string = "setJMSPriority()";
            _loggerJM.fine(_lgrMID_INF + string + n);
        }
        if (n < 0 || n > 9) {
            string = "setJMSPriority()";
            String string2 = _lgrMID_EXC + string + ":Invalid priority=" + n;
            _loggerJM.severe(string2);
            throw new JMSException(string2);
        }
        this.pkt.setPriority(n);
    }

    public void setJMSRedelivered(boolean bl) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: setJMSRedelivered()" + bl);
        }
        this.pkt.setRedelivered(bl);
    }

    public void setJMSReplyTo(javax.jms.Destination destination) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: setJMSReplyTo()" + destination);
        }
        this.jmsReplyTo = destination;
    }

    public void setJMSTimestamp(long l) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: setJMSTimestamp()" + l);
        }
    }

    public void setJMSType(String string) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: setJMSType()" + string);
        }
        this.pkt.setMessageType(string);
    }

    public void setLongProperty(String string, long l) throws JMSException {
        this._checkAndSetProperty("setLongProperty()", string, l);
    }

    public void setObjectProperty(String string, Object object) throws JMSException {
        this._checkAndSetProperty("setObjectProperty()", string, object);
    }

    public void setShortProperty(String string, short s) throws JMSException {
        this._checkAndSetProperty("setShortProperty()", string, s);
    }

    public void setStringProperty(String string, String string2) throws JMSException {
        this._checkAndSetProperty("setStringProperty()", string, string2);
    }

    public void acknowledgeThisMessage() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: acknowledgeThisMessage()");
        }
        if (!this.browserMessage) {
            this.ds._acknowledgeThisMessage(this, this.consumerId, JMSService.MessageAckType.ACKNOWLEDGE);
        }
    }

    public void acknowledgeUpThroughThisMessage() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: acknowledge()");
        }
        this._unsupported("acknowledgeUpThroughThisMessage");
        if (this.consumerId != 0L) {
            this.ds._acknowledgeThisMessage(this, this.consumerId, JMSService.MessageAckType.ACKNOWLEDGE);
        }
    }

    protected void _setDefaultValues() throws JMSException {
        this.setJMSDeliveryMode(2);
        this.setJMSPriority(4);
        this.setJMSExpiration(0L);
        if (pktMacAddress == null) {
            this.pkt.setIP(pktIPAddress);
        } else {
            this.pkt.setIP(pktIPAddress, pktMacAddress);
        }
        this.pkt.setPort(1);
        this.pkt.setPacketType(6);
    }

    protected void _setReadOnlyBody(boolean bl) {
        this.readOnlyBody = bl;
    }

    protected void _setReadOnlyProperties(boolean bl) {
        this.readOnlyProperties = bl;
    }

    protected void _resetJMSMessageID() {
        this.jmsMessageIDSet = false;
    }

    private javax.jms.Destination _constructMQDestination(String string) throws JMSException {
        Destination destination = null;
        boolean bl = this.pkt.getIsQueue();
        if (string.startsWith("temporary_destination://queue/") || string.startsWith("temporary_destination://" + (Object)((Object)Destination.Type.QUEUE))) {
            destination = new TemporaryQueue(string);
            return destination;
        }
        if (string.startsWith("temporary_destination://topic/") || string.startsWith("temporary_destination://" + (Object)((Object)Destination.Type.TOPIC))) {
            destination = new TemporaryTopic(string);
            return destination;
        }
        destination = bl ? new BasicQueue(string) : new BasicTopic(string);
        return destination;
    }

    protected void _checkAndSetProperty(String string, String string2, Object object) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine(_lgrMID_INF + string + ":name=" + string2 + ":value=" + object);
        }
        if (string2 == null || "".equals(string2)) {
            String string3 = _lgrMID_EXC + string + ":name=" + string2 + ":value=" + object + ":IllegalArgument.";
            _loggerJM.severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (this.readOnlyProperties) {
            String string4 = _lgrMID_EXC + string + ":name=" + string2 + ":value=" + object + ":Properties are Read Only.";
            _loggerJM.severe(string4);
            throw new MessageNotWriteableException(string4);
        }
        if (!(object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof String)) {
            String string5 = _lgrMID_EXC + string + ":name=" + string2 + ":value=" + object + ":Bad Type for Property Value=" + object.getClass();
            _loggerJM.severe(string5);
            throw new MessageFormatException(string5);
        }
        this._checkValidPropertyName(string, string2);
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(string2, object);
    }

    protected void _checkValidPropertyName(String string, String string2) throws JMSException {
        if ("NULL".equalsIgnoreCase(string2) || "TRUE".equalsIgnoreCase(string2) || "FALSE".equalsIgnoreCase(string2) || "NOT".equalsIgnoreCase(string2) || "AND".equalsIgnoreCase(string2) || "OR".equalsIgnoreCase(string2) || "BETWEEN".equalsIgnoreCase(string2) || "LIKE".equalsIgnoreCase(string2) || "IN".equalsIgnoreCase(string2) || "IS".equalsIgnoreCase(string2)) {
            String string3 = _lgrMID_EXC + string + ":Illegal to use Reserved word as property name:" + string2;
            _loggerJM.severe(string3);
            throw new JMSException(string3);
        }
        char[] cArray = string2.toCharArray();
        if (Character.isJavaIdentifierStart(cArray[0])) {
            for (int i = 1; i < cArray.length; ++i) {
                if (Character.isJavaIdentifierPart(cArray[i])) continue;
                String string4 = _lgrMID_EXC + string + ":Invalid character:'" + cArray[i] + "' used in property name:" + string2;
                _loggerJM.severe(string4);
                throw new JMSException(string4);
            }
        } else {
            String string5 = _lgrMID_EXC + string + ":Invalid start character:'" + cArray[0] + "' used in property name:" + string2;
            _loggerJM.severe(string5);
            throw new JMSException(string5);
        }
    }

    protected void checkForReadOnlyMessageBody(String string) throws JMSException {
        if (this.readOnlyBody) {
            String string2 = _lgrMID_EXC + string + ":Illegal to set JMS Message body when it is read only:";
            _loggerJM.severe(string2);
            throw new MessageNotWriteableException(string2);
        }
    }

    protected void checkForWriteOnlyMessageBody(String string) throws JMSException {
        if (!this.readOnlyBody) {
            String string2 = _lgrMID_EXC + string + ":Illegal to read JMS Message body or length when it is write only:";
            _loggerJM.severe(string2);
            throw new MessageNotReadableException(string2);
        }
    }

    protected String _getJMSDestinationName() throws JMSException {
        if (this.jmsDestination instanceof Queue) {
            return ((Queue)this.jmsDestination).getQueueName();
        }
        if (this.jmsDestination instanceof Topic) {
            return ((Topic)this.jmsDestination).getTopicName();
        }
        return null;
    }

    protected String _getJMSReplyToName() throws JMSException {
        if (this.jmsReplyTo instanceof Queue) {
            return ((Queue)this.jmsReplyTo).getQueueName();
        }
        if (this.jmsReplyTo instanceof Topic) {
            return ((Topic)this.jmsReplyTo).getTopicName();
        }
        return null;
    }

    protected void _setConsumerId(long l) {
        this.consumerId = l;
    }

    protected long _getConsumerId() {
        return this.consumerId;
    }

    protected void preparePacketForSend() throws JMSException {
        this.pkt.setDestination(this._getJMSDestinationName());
        if (this.jmsDestination instanceof Queue) {
            this.pkt.setIsQueue(true);
        } else {
            this.pkt.setIsQueue(false);
        }
        this.pkt.setDestinationClass(this.jmsDestination.getClass().getName());
        if (this.jmsReplyTo != null && (this.jmsReplyTo instanceof Queue || this.jmsReplyTo instanceof Topic)) {
            this.pkt.setReplyTo(this._getJMSReplyToName());
            this.pkt.setReplyToClass(this.jmsReplyTo.getClass().getName());
        }
        this._setBodyToPacket();
        this.pkt.setProperties(this.properties);
        this.jmsMessageIDSet = false;
        this.pkt.prepareToSend();
        this._resetJMSMessageID();
        long l = this.getJMSExpiration();
        if (l != 0L) {
            this.setJMSExpiration(l += System.currentTimeMillis());
        }
    }

    protected void _setBodyToPacket() throws JMSException {
    }

    protected void _getMessageBodyFromPacket() throws JMSException {
    }

    protected void _setMessageBodyOfPacket(byte[] byArray) {
        this.pkt.setMessageBody(byArray);
    }

    protected void _setMessageBodyOfPacket(byte[] byArray, int n, int n2) {
        this.pkt.setMessageBody(byArray, n, n2);
    }

    protected byte[] _getMessageBodyByteArray() {
        return this.pkt.getMessageBodyByteArray();
    }

    protected void _getPropertiesFromPacket() {
        try {
            this.properties = this.pkt.getProperties();
        }
        catch (IOException iOException) {
            this.properties = null;
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.properties = null;
            classNotFoundException.printStackTrace();
        }
    }

    protected void _acknowledgeThisMessageForMDB(DirectXAResource directXAResource) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: acknowledgeThisMessageForMDB()");
        }
        this.ds._acknowledgeThisMessageForMDB(this, this.consumerId, JMSService.MessageAckType.ACKNOWLEDGE, directXAResource);
    }

    protected void _acknowledgeThisMessageAsDeadForMDB(DirectXAResource directXAResource) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: acknowledgeThisMessageAsDeadForMDB()");
        }
        this.ds._acknowledgeThisMessageForMDB(this, this.consumerId, JMSService.MessageAckType.DEAD, directXAResource);
    }

    private void _unsupported(String string) throws JMSException {
        String string2 = "MQJMSRA_DM2001: messageId=" + this.pkt.getMessageID() + ":" + string;
        _loggerJM.warning(string2);
        throw new JMSException(string2);
    }

    static {
        _logFINE = false;
        pktMacAddress = (byte[])(System.getProperty("imq.useMac", "true").equalsIgnoreCase("true") ? IPAddress.getRandomMac() : null);
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        pktIPAddress = inetAddress == null ? null : inetAddress.getAddress();
        Level level = _loggerJM.getLevel();
        if (level != null && (_logLevel = level.intValue()) <= Level.FINE.intValue()) {
            _logFINE = true;
        }
    }
}

