/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggedMessageHelper {
    public static final Logger logger = Globals.getLogger();
    Map<SysMessageID, SysMessageID> loggedSendsSinceLastCheckpoint = new ConcurrentHashMap<SysMessageID, SysMessageID>();
    Set<SysMessageID> pendingRemove = Collections.synchronizedSet(new HashSet());
    TransactionLogManager txnLogManager;

    public LoggedMessageHelper(TransactionLogManager transactionLogManager) {
        this.txnLogManager = transactionLogManager;
    }

    public void preMessageRemoved(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " preMessageRemoved() dest=" + destinationUID + " mid=" + sysMessageID;
            logger.log(4, string);
        }
        if (!TransactionLogManager.logNonTransactedMsgAck && this.loggedSendsSinceLastCheckpoint.containsKey(sysMessageID)) {
            this.txnLogManager.logMsgRemoval(destinationUID, sysMessageID);
        }
        this.loggedSendsSinceLastCheckpoint.remove(sysMessageID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMessageRemoved(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        Set<SysMessageID> set = this.pendingRemove;
        synchronized (set) {
            Boolean bl = this.pendingRemove.remove(sysMessageID);
            if (bl != null) {
                if (Store.getDEBUG()) {
                    String string = this.getPrefix() + " postMessageRemoved() dest=" + destinationUID + " id=" + sysMessageID + " pendingRemoves=" + this.pendingRemove.size();
                    logger.log(4, string);
                }
                if (this.pendingRemove.size() == 0) {
                    this.pendingRemove.notify();
                }
            }
        }
    }

    public void lastAckLogged(DestinationUID destinationUID, SysMessageID sysMessageID) {
        this.pendingRemove.add(sysMessageID);
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " lastAckLogged() dest=" + destinationUID + " id=" + sysMessageID + " pendingRemoves=" + this.pendingRemove.size();
            logger.log(4, string);
        }
        this.loggedSendsSinceLastCheckpoint.remove(sysMessageID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPendingRemoveCompletion() {
        Set<SysMessageID> set = this.pendingRemove;
        synchronized (set) {
            String string;
            if (Store.getDEBUG()) {
                string = this.getPrefix() + " num pendingRemove =" + this.pendingRemove.size();
                logger.log(4, string);
            }
            try {
                while (this.pendingRemove.size() > 0) {
                    if (Store.getDEBUG()) {
                        string = this.getPrefix() + " waiting for " + this.pendingRemove.size() + " pendingRemove";
                        logger.log(4, string);
                    }
                    this.pendingRemove.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    void messageListLogged(List<TransactionWorkMessage> list) {
        for (TransactionWorkMessage transactionWorkMessage : list) {
            this.messageLogged(transactionWorkMessage);
        }
    }

    public void messageLogged(TransactionWorkMessage transactionWorkMessage) {
        Object object;
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " messageLogged()" + transactionWorkMessage;
            logger.log(4, (String)object);
        }
        object = transactionWorkMessage.getMessage().getSysMessageID();
        this.loggedSendsSinceLastCheckpoint.put((SysMessageID)object, (SysMessageID)object);
    }

    public void onCheckpoint() {
        this.loggedSendsSinceLastCheckpoint.clear();
    }

    String getPrefix() {
        return "LoggedMessageHelper: " + Thread.currentThread().getName();
    }
}

