/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.DestinationUpdateChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.InterestUpdateChangeRecord;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class ChangeRecord {
    protected GPacket gp;
    protected boolean discard = false;
    protected int operation = 31;

    ChangeRecord() {
    }

    protected static ChangeRecord makeChangeRecord(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GPacket gPacket = GPacket.getInstance();
        gPacket.read(byteArrayInputStream);
        ChangeRecord changeRecord = null;
        if (gPacket.getType() == 5 || gPacket.getType() == 7) {
            changeRecord = new InterestUpdateChangeRecord(gPacket);
        } else if (gPacket.getType() == 13 || gPacket.getType() == 15) {
            changeRecord = new DestinationUpdateChangeRecord(gPacket);
        } else if (gPacket.getType() == 31) {
            changeRecord = new ChangeRecord();
        }
        changeRecord.gp = gPacket;
        changeRecord.discard = false;
        return changeRecord;
    }

    protected byte[] getBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.gp.write(byteArrayOutputStream);
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected String getUniqueKey() {
        return "???";
    }

    protected boolean isAddOp() {
        return false;
    }

    protected int getOperation() {
        return this.operation;
    }

    public String toString() {
        return this.getUniqueKey() + ", isAddOp() = " + this.isAddOp();
    }
}

