/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.intf.config.Config;
import org.glassfish.admin.amx.intf.config.VirtualServer;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkConfig;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkListener;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class V3AMXUtil {
    public static String getInstallDir() {
        return V3AMX.getInstance().getDomainRoot().getInstallDir();
    }

    public static Integer getAdminPort() {
        NetworkListener amx = V3AMX.getInstance().getAdminListener();
        String port = amx.resolveAttribute("Port");
        return Integer.valueOf(port);
    }

    public static String getHttpPortNumber(String serverName, String configName) {
        StringBuffer ports = new StringBuffer();
        try {
            Config config = V3AMX.getServerConfig(configName);
            Map nls = ((NetworkConfig)config.getNetworkConfig().as(NetworkConfig.class)).getNetworkListeners().getNetworkListener();
            for (NetworkListener listener : nls.values()) {
                String port = (String)listener.attributesMap().get("Port");
                ports = ports.append("," + port);
            }
            if (ports.length() > 0) {
                ports.deleteCharAt(0);
            }
            return ports.toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getLaunchLink(String serverName, String appName) {
        try {
            String vsId;
            AMXProxy server = (AMXProxy)V3AMX.getInstance().getDomain().getServers().getServer().get("server");
            AMXProxy appRef = (AMXProxy)server.childrenMap("application-ref").get(appName);
            Map result = null;
            result = appRef == null ? V3AMXUtil.getListener() : ((vsId = (String)appRef.attributesMap().get("VirtualServers")) == null || vsId.length() == 0 ? V3AMXUtil.getListener() : V3AMXUtil.getListener(vsId));
            if (result == null) {
                return null;
            }
            String vs = (String)result.get("vs");
            if (vs.equals("server")) {
                vs = serverName;
            }
            String port = (String)result.get("port");
            String protocol = (String)result.get("protocol");
            return protocol + "://" + vs + ":" + port;
        }
        catch (Exception ex) {
            GuiUtil.getLogger().warning(ex.getMessage());
            return null;
        }
    }

    private static Map getListener() {
        Map vsMap = V3AMX.getServerConfig("server-config").getHttpService().childrenMap(VirtualServer.class);
        return V3AMXUtil.getOneVsWithNetworkListener(new ArrayList<String>(vsMap.keySet()));
    }

    private static Map getListener(String vsIds) {
        return V3AMXUtil.getOneVsWithNetworkListener(GuiUtil.parseStringList(vsIds, ","));
    }

    private static Map getOneVsWithNetworkListener(List<String> vsList) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (vsList == null || vsList.size() == 0) {
            return null;
        }
        if (vsList.contains("server")) {
            vsList.remove("server");
            vsList.add(0, "server");
        }
        boolean found = false;
        Map vsMap = V3AMX.getServerConfig("server-config").getHttpService().childrenMap(VirtualServer.class);
        for (String vsName : vsList) {
            VirtualServer vs;
            String listener;
            if (vsName.equals("__asadmin") || GuiUtil.isEmpty(listener = (String)(vs = (VirtualServer)vsMap.get(vsName)).attributesMap().get("NetworkListeners"))) continue;
            List hpList = GuiUtil.parseStringList(listener, ",");
            for (String one : hpList) {
                NetworkListener oneListener = (NetworkListener)((NetworkConfig)V3AMX.getServerConfig("server-config").getNetworkConfig().as(NetworkConfig.class)).getNetworkListeners().getNetworkListener().get(one);
                if (!"true".equals(oneListener.attributesMap().get("Enabled"))) continue;
                String security = (String)oneListener.findProtocol().attributesMap().get("SecurityEnabled");
                if ("true".equals(security)) {
                    result.put("protocol", "https");
                    result.put("port", oneListener.resolveAttribute("Port"));
                    result.put("vs", vsName);
                    found = true;
                    continue;
                }
                result.put("protocol", "http");
                result.put("port", oneListener.resolveAttribute("Port"));
                result.put("vs", vsName);
                return result;
            }
        }
        return found ? result : null;
    }
}

