/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.servlet.SessionCookieConfig;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.StringManager;

public class SessionCookieConfigImpl
implements SessionCookieConfig {
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private String name;
    private String domain;
    private String path;
    private String comment;
    private boolean httpOnly;
    private boolean secure;
    private StandardContext ctx;
    private int maxAge = -1;

    SessionCookieConfigImpl(StandardContext ctx) {
        this.ctx = ctx;
    }

    public void setName(String name) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("sessionCookieConfig.alreadyInitialized", (Object)"name", this.ctx.getName()));
        }
        this.name = name;
        this.ctx.setSessionCookieName(name);
        this.ctx.setSessionCookieConfigInitialized(true);
    }

    public String getName() {
        return this.name;
    }

    public void setDomain(String domain) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("sessionCookieConfig.alreadyInitialized", (Object)"dnmain", this.ctx.getName()));
        }
        this.domain = domain;
        this.ctx.setSessionCookieConfigInitialized(true);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setPath(String path) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("sessionCookieConfig.alreadyInitialized", (Object)"path", this.ctx.getName()));
        }
        this.path = path;
        this.ctx.setSessionCookieConfigInitialized(true);
    }

    public String getPath() {
        return this.path;
    }

    public void setComment(String comment) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("sessionCookieConfig.alreadyInitialized", (Object)"comment", this.ctx.getName()));
        }
        this.comment = comment;
        this.ctx.setSessionCookieConfigInitialized(true);
    }

    public String getComment() {
        return this.comment;
    }

    public void setHttpOnly(boolean httpOnly) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("sessionCookieConfig.alreadyInitialized", (Object)"httpOnly", this.ctx.getName()));
        }
        this.httpOnly = httpOnly;
        this.ctx.setSessionCookieConfigInitialized(true);
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setSecure(boolean secure) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("sessionCookieConfig.alreadyInitialized", (Object)"secure", this.ctx.getName()));
        }
        this.secure = secure;
        this.ctx.setSessionCookieConfigInitialized(true);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setMaxAge(int maxAge) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("sessionCookieConfig.alreadyInitialized", (Object)"maxAge", this.ctx.getName()));
        }
        this.maxAge = maxAge;
        this.ctx.setSessionCookieConfigInitialized(true);
    }

    public int getMaxAge() {
        return this.maxAge;
    }
}

