/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.JMQByteBufferInputStream;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.io.VRFileRAF;
import com.sun.messaging.jmq.io.VRecord;
import com.sun.messaging.jmq.io.VRecordRAF;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.DstMsgStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class MessageInfo {
    static final short PENDING = -1;
    static final short DONE = 0;
    private static final int INT_SIZE = 4;
    private static final int LONG_SIZE = 8;
    private static final int ENTRY_SIZE = 12;
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private Packet msg;
    private WeakReference msgBytes = null;
    private SysMessageID mid;
    private int packetSize;
    private DstMsgStore parent = null;
    private VRecordRAF vrecord = null;
    private HashMap iidMap = null;
    private int[] statearray = null;

    MessageInfo(DstMsgStore dstMsgStore, byte[] byArray, byte[] byArray2) throws IOException {
        this.parent = dstMsgStore;
        try {
            Packet packet;
            this.msg = packet = this.parseMessage(byArray);
            this.mid = (SysMessageID)packet.getSysMessageID().clone();
            this.parseInterestList(byArray2);
        }
        catch (IOException iOException) {
            this.logger.log(32, this.parent.myDestination + ":failed to parse message from byte array", (Throwable)iOException);
            throw iOException;
        }
    }

    MessageInfo(DstMsgStore dstMsgStore, VRecordRAF vRecordRAF) throws IOException {
        this.parent = dstMsgStore;
        this.vrecord = vRecordRAF;
        try {
            Packet packet;
            this.msg = packet = this.parseMessage(vRecordRAF);
            this.mid = (SysMessageID)packet.getSysMessageID().clone();
            this.parseInterestList(vRecordRAF);
        }
        catch (IOException iOException) {
            this.parent.getVRFile().free((VRecord)this.vrecord);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageInfo(DstMsgStore dstMsgStore, VRFileRAF vRFileRAF, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException {
        this.parent = dstMsgStore;
        this.mid = (SysMessageID)packet.getSysMessageID().clone();
        this.packetSize = packet.getPacketSize();
        int n = 4 + this.packetSize + 4 + consumerUIDArray.length * 12;
        if (bl && Store.getDEBUG_SYNC()) {
            Globals.getLogger().log(4, "sync new MessageInfo " + this.mid + "with VRFileRAF");
        }
        if (!Globals.isMinimizeWrites()) {
            VRFileRAF vRFileRAF2 = vRFileRAF;
            synchronized (vRFileRAF2) {
                this.vrecord = (VRecordRAF)vRFileRAF.allocate(n);
                this.vrecord.setCookie((short)-1);
                this.vrecord.writeInt(this.packetSize);
                if (DstMsgStore.useFileChannel) {
                    packet.writePacket((GatheringByteChannel)this.vrecord.getChannel(), false);
                } else {
                    byte[] byArray = packet.getBytes();
                    this.vrecord.write(byArray);
                    if (Globals.txnLogEnabled()) {
                        this.msgBytes = new WeakReference<byte[]>(byArray);
                    }
                }
                this.storeStates(this.vrecord, consumerUIDArray, nArray, false);
                this.vrecord.setCookie((short)0);
                if (bl) {
                    this.vrecord.force();
                }
            }
        }
        VRFileRAF vRFileRAF3 = vRFileRAF;
        synchronized (vRFileRAF3) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(n + 4);
            byteBuffer.putShort((short)2);
            byteBuffer.putShort((short)0);
            byteBuffer.putInt(this.packetSize);
            byte[] byArray = packet.getBytes();
            byteBuffer.put(byArray);
            if (Globals.txnLogEnabled()) {
                this.msgBytes = new WeakReference<byte[]>(byArray);
            }
            ByteBuffer byteBuffer2 = this.serializeStates(consumerUIDArray, nArray);
            byteBuffer2.rewind();
            byteBuffer.put(byteBuffer2);
            byte[] byArray2 = byteBuffer.array();
            this.vrecord = (VRecordRAF)vRFileRAF.allocateAndWrite(n, byArray2);
            if (bl) {
                this.vrecord.force();
            }
        }
    }

    MessageInfo(DstMsgStore dstMsgStore, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException {
        Object object;
        this.parent = dstMsgStore;
        this.mid = (SysMessageID)packet.getSysMessageID().clone();
        this.packetSize = packet.getPacketSize();
        ByteBuffer byteBuffer = this.serializeStates(consumerUIDArray, nArray);
        byteBuffer.rewind();
        if (bl && Store.getDEBUG_SYNC()) {
            object = "sync new MessageInfo msg id " + this.mid + " with individual files";
            Globals.getLogger().log(4, (String)object);
        }
        if (DstMsgStore.useFileChannel) {
            object = this.parent.getRAF(this.mid);
            DstMsgStore.markWriting((RandomAccessFile)object);
            ((RandomAccessFile)object).writeLong(this.packetSize);
            packet.writePacket((GatheringByteChannel)((RandomAccessFile)object).getChannel(), false);
            long l = ((RandomAccessFile)object).getFilePointer();
            if (byteBuffer != null) {
                ((RandomAccessFile)object).writeLong(byteBuffer.remaining());
                ((RandomAccessFile)object).getChannel().write(byteBuffer);
            } else {
                ((RandomAccessFile)object).writeLong(0L);
            }
            long l2 = ((RandomAccessFile)object).getFilePointer();
            DstMsgStore.markGood((RandomAccessFile)object);
            if (bl) {
                ((RandomAccessFile)object).getChannel().force(false);
            }
            this.parent.releaseRAF(this.mid, (RandomAccessFile)object, l, l2);
        } else {
            object = byteBuffer != null ? byteBuffer.array() : null;
            byte[] byArray = packet.getBytes();
            if (Globals.txnLogEnabled()) {
                this.msgBytes = new WeakReference<byte[]>(byArray);
            }
            this.parent.writeData(this.mid, byArray, (byte[])object, bl);
        }
    }

    synchronized Packet getMessage() throws IOException {
        if (this.msg == null) {
            if (this.vrecord != null) {
                try {
                    return this.parseMessage(this.vrecord);
                }
                catch (IOException iOException) {
                    this.logger.log(32, this.parent.myDestination + ":failed to parse message from vrecord(" + this.vrecord + ")", (Throwable)iOException);
                    throw iOException;
                }
            }
            try {
                byte[] byArray = this.parent.loadData(this.mid);
                return this.parseMessage(byArray);
            }
            catch (IOException iOException) {
                this.logger.log(32, this.parent.myDestination + ":failed to parse message from byte array", (Throwable)iOException);
                throw iOException;
            }
        }
        Packet packet = this.msg;
        this.msg = null;
        return packet;
    }

    byte[] getCachedMessageBytes() {
        byte[] byArray = null;
        if (this.msgBytes != null) {
            byArray = (byte[])this.msgBytes.get();
            this.msgBytes = null;
        }
        return byArray;
    }

    int getSize() {
        return this.packetSize;
    }

    SysMessageID getID() {
        return this.mid;
    }

    synchronized void free(boolean bl) throws IOException {
        if (bl && Store.getDEBUG_SYNC()) {
            String string = "sync free msg " + this.mid;
            Globals.getLogger().log(4, string);
        }
        if (this.vrecord != null) {
            this.parent.getVRFile().free((VRecord)this.vrecord);
            if (bl) {
                this.parent.getVRFile().force();
            }
            this.vrecord = null;
        } else {
            this.parent.removeData(this.mid, bl);
        }
        this.mid = null;
        this.statearray = null;
        if (this.iidMap != null) {
            this.iidMap.clear();
            this.iidMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void storeStates(ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        if (this.iidMap.size() != 0) {
            this.logger.log(16, "B3084", (Object)this.mid.toString());
            throw new BrokerException(this.br.getString("B3084", this.mid.toString()));
        }
        if (this.vrecord != null) {
            VRFileRAF vRFileRAF;
            int n = 4 + this.packetSize + 4 + consumerUIDArray.length * 12;
            VRFileRAF vRFileRAF2 = vRFileRAF = this.parent.getVRFile();
            synchronized (vRFileRAF2) {
                if (this.vrecord.getDataCapacity() < n) {
                    this.vrecord.rewind();
                    byte[] byArray = new byte[4 + this.packetSize];
                    this.vrecord.read(byArray);
                    VRecordRAF vRecordRAF = (VRecordRAF)vRFileRAF.allocate(n);
                    vRecordRAF.write(byArray);
                    vRFileRAF.free((VRecord)this.vrecord);
                    this.vrecord = vRecordRAF;
                }
                this.storeStates(this.vrecord, consumerUIDArray, nArray, bl);
            }
        } else {
            byte[] byArray = this.serializeStates(consumerUIDArray, nArray).array();
            if (Store.getDEBUG_SYNC()) {
                String string = "MessageInfo storeState writeAttachment with sync " + this.mid;
                this.logger.log(4, string);
            }
            if (!this.parent.writeAttachment(this.mid, byArray, bl)) {
                this.iidMap = null;
                this.statearray = null;
                this.logger.log(32, "B3007", (Object)this.mid, (Object)this.parent.myDestination);
                throw new BrokerException(this.br.getString("B3007", this.mid, this.parent.myDestination));
            }
        }
    }

    synchronized void updateState(ConsumerUID consumerUID, int n, boolean bl) throws IOException, BrokerException {
        Integer n2 = null;
        if (this.iidMap == null || (n2 = (Integer)this.iidMap.get(consumerUID)) == null) {
            this.logger.log(32, "B3014", (Object)consumerUID.toString(), (Object)this.mid.toString());
            throw new BrokerException(this.br.getString("B3014", consumerUID.toString(), this.mid.toString()));
        }
        int n3 = n2;
        if (this.statearray[n3] != n) {
            this.statearray[n3] = n;
            if (n == 1 && Globals.isDeliveryStateNotPersisted()) {
                return;
            }
            if (this.vrecord != null) {
                long l = 4 + this.packetSize + 4 + n3 * 12 + 8;
                this.vrecord.writeInt((int)l, n);
                if (bl) {
                    if (Store.getDEBUG_SYNC()) {
                        String string = "MessageInfo updateState sync called for msg id " + this.mid + "consumer " + consumerUID;
                        Globals.getLogger().log(4, string);
                    }
                    this.vrecord.force();
                }
            } else {
                long l = 4 + n3 * 12 + 8;
                if (!this.parent.writeAttachmentData(this.mid, l, n, bl)) {
                    this.logger.log(32, "B3007", (Object)this.mid, (Object)this.parent.myDestination);
                    throw new BrokerException(this.br.getString("B3007", this.mid, this.parent.myDestination));
                }
            }
        }
    }

    synchronized int getInterestState(ConsumerUID consumerUID) throws BrokerException {
        Integer n = null;
        if (this.iidMap == null || (n = (Integer)this.iidMap.get(consumerUID)) == null) {
            this.logger.log(32, "B3014", (Object)consumerUID.toString(), (Object)this.mid.toString());
            throw new BrokerException(this.br.getString("B3014", consumerUID.toString(), this.mid.toString()));
        }
        return this.statearray[n];
    }

    synchronized HashMap getInterestStates() {
        HashMap hashMap = new HashMap();
        if (this.iidMap != null) {
            Set set = this.iidMap.entrySet();
            for (Map.Entry entry : set) {
                int n = (Integer)entry.getValue();
                hashMap.put(entry.getKey(), this.statearray[n]);
            }
        }
        return hashMap;
    }

    synchronized ConsumerUID[] getConsumerUIDs() {
        ConsumerUID[] consumerUIDArray = new ConsumerUID[]{};
        if (this.iidMap != null) {
            ArrayList arrayList = new ArrayList();
            Set set = this.iidMap.entrySet();
            for (Map.Entry entry : set) {
                Integer n = (Integer)entry.getValue();
                if (this.statearray[n] == 2) continue;
                arrayList.add(entry.getKey());
            }
            consumerUIDArray = arrayList.toArray(consumerUIDArray);
        }
        return consumerUIDArray;
    }

    synchronized boolean hasMessageBeenAck() {
        if (this.statearray != null && this.statearray.length > 0) {
            int n = this.statearray.length;
            for (int i = 0; i < n; ++i) {
                if (this.statearray[i] == 2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void parseInterestList(VRecordRAF vRecordRAF) throws IOException {
        int n = 0;
        try {
            vRecordRAF.position(4 + this.packetSize);
            n = vRecordRAF.readInt();
            long l = (long)(4 + this.packetSize + 4) + (long)n * 12L;
            if (l > (long)vRecordRAF.getDataCapacity()) {
                throw new Exception("size of interest list is corrupted");
            }
            this.iidMap = new HashMap(n);
            this.statearray = new int[n];
            for (int i = 0; i < n; ++i) {
                ConsumerUID consumerUID = new ConsumerUID(vRecordRAF.readLong());
                this.statearray[i] = vRecordRAF.readInt();
                this.iidMap.put(consumerUID, new Integer(i));
            }
            if (Store.getDEBUG()) {
                this.logger.log(4, "loaded " + n + " interest states");
            }
        }
        catch (Throwable throwable) {
            this.logger.log(32, "failed to parse interest list(size=" + n + ") for msg(size=" + this.packetSize + ") from vrecord(" + vRecordRAF + ")", throwable);
            IOException iOException = new IOException(throwable.toString());
            iOException.setStackTrace(throwable.getStackTrace());
            throw iOException;
        }
    }

    private void parseInterestList(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            if (Store.getDEBUG()) {
                this.logger.log(1, "No interest list to load");
            }
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n = dataInputStream.readInt();
        this.iidMap = new HashMap(n);
        this.statearray = new int[n];
        for (int i = 0; i < n; ++i) {
            ConsumerUID consumerUID = new ConsumerUID(dataInputStream.readLong());
            this.statearray[i] = dataInputStream.readInt();
            this.iidMap.put(consumerUID, new Integer(i));
        }
        dataInputStream.close();
        byteArrayInputStream.close();
        if (Store.getDEBUG()) {
            this.logger.log(4, "loaded " + n + " interest states");
        }
    }

    private Packet parseMessage(byte[] byArray) throws IOException {
        this.packetSize = byArray.length;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        JMQByteBufferInputStream jMQByteBufferInputStream = new JMQByteBufferInputStream(byteBuffer);
        Packet packet = new Packet(false);
        packet.generateTimestamp(false);
        packet.generateSequenceNumber(false);
        packet.readPacket((InputStream)jMQByteBufferInputStream);
        jMQByteBufferInputStream.close();
        return packet;
    }

    private Packet parseMessage(VRecordRAF vRecordRAF) throws IOException {
        try {
            vRecordRAF.rewind();
            this.packetSize = vRecordRAF.readInt();
            Packet packet = new Packet();
            packet.generateTimestamp(false);
            packet.generateSequenceNumber(false);
            if (DstMsgStore.useFileChannel) {
                packet.readPacket((ScatteringByteChannel)vRecordRAF.getChannel(), false);
            } else {
                ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[this.packetSize]);
                vRecordRAF.read(byteBuffer.array());
                JMQByteBufferInputStream jMQByteBufferInputStream = new JMQByteBufferInputStream(byteBuffer);
                packet.readPacket((InputStream)jMQByteBufferInputStream);
                jMQByteBufferInputStream.close();
            }
            return packet;
        }
        catch (Throwable throwable) {
            this.logger.log(32, this.parent.myDestination + ":failed to parse message(size=" + this.packetSize + ") from vrecord(" + vRecordRAF + ")", throwable);
            IOException iOException = new IOException(throwable.toString());
            iOException.setStackTrace(throwable.getStackTrace());
            throw iOException;
        }
    }

    private void storeStates(VRecordRAF vRecordRAF, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException {
        ByteBuffer byteBuffer = this.serializeStates(consumerUIDArray, nArray);
        byteBuffer.rewind();
        vRecordRAF.position(4 + this.packetSize);
        vRecordRAF.write(byteBuffer);
        if (bl) {
            if (Store.getDEBUG_SYNC()) {
                Globals.getLogger().log(4, "sync storeStates mid=" + this.mid);
            }
            vRecordRAF.force();
        }
    }

    private ByteBuffer serializeStates(ConsumerUID[] consumerUIDArray, int[] nArray) {
        int n = consumerUIDArray.length;
        this.iidMap = new HashMap(n);
        this.statearray = new int[n];
        int n2 = 4 + n * 12;
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[n2]);
        byteBuffer.putInt(n);
        for (int i = 0; i < n; ++i) {
            byteBuffer.putLong(consumerUIDArray[i].longValue());
            byteBuffer.putInt(nArray[i]);
            this.iidMap.put(consumerUIDArray[i], new Integer(i));
            this.statearray[i] = nArray[i];
        }
        return byteBuffer;
    }
}

