/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.remote;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.Set;
import org.apache.felix.shell.remote.Activator;
import org.apache.felix.shell.remote.AtomicInteger;
import org.apache.felix.shell.remote.Shell;
import org.osgi.framework.BundleContext;

class Listener {
    private int m_Port;
    private String m_Ip;
    private Thread m_ListenerThread;
    private boolean m_Stop = false;
    private ServerSocket m_ServerSocket;
    private AtomicInteger m_UseCounter;
    private int m_MaxConnections;
    private int m_SoTimeout;
    private Set m_connections;
    private static final String INUSE_MESSAGE = "Connection refused.\r\nAll possible connections are currently being used.\r\n";

    Listener() {
    }

    public void activate(BundleContext bundleContext) {
        this.m_Ip = this.getProperty(bundleContext, "osgi.shell.telnet.ip", "127.0.0.1");
        this.m_Port = this.getProperty(bundleContext, "osgi.shell.telnet.port", 6666);
        this.m_SoTimeout = this.getProperty(bundleContext, "osgi.shell.telnet.socketTimeout", 0);
        this.m_MaxConnections = this.getProperty(bundleContext, "osgi.shell.telnet.maxconn", 2);
        this.m_UseCounter = new AtomicInteger(0);
        this.m_connections = new HashSet();
        this.m_ListenerThread = new Thread((Runnable)new Acceptor(), "telnetconsole.Listener");
        this.m_ListenerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        Shell[] connections;
        try {
            this.m_Stop = true;
            this.m_ServerSocket.close();
            this.m_ListenerThread.join();
        }
        catch (Exception ex) {
            Activator.getServices().error("Listener::deactivate()", ex);
        }
        Set set = this.m_connections;
        synchronized (set) {
            connections = this.m_connections.toArray(new Shell[this.m_connections.size()]);
            this.m_connections.clear();
        }
        for (int i = 0; i < connections.length; ++i) {
            connections[i].terminate();
        }
    }

    private int getProperty(BundleContext bundleContext, String propName, int defaultValue) {
        String propValue = bundleContext.getProperty(propName);
        if (propValue != null) {
            try {
                return Integer.parseInt(propValue);
            }
            catch (NumberFormatException ex) {
                Activator.getServices().error("Listener::activate()", ex);
            }
        }
        return defaultValue;
    }

    private String getProperty(BundleContext bundleContext, String propName, String defaultValue) {
        String propValue = bundleContext.getProperty(propName);
        if (propValue != null) {
            return propValue;
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerConnection(Shell connection) {
        Set set = this.m_connections;
        synchronized (set) {
            this.m_connections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterConnection(Shell connection) {
        Set set = this.m_connections;
        synchronized (set) {
            this.m_connections.remove(connection);
        }
    }

    private class Acceptor
    implements Runnable {
        private Acceptor() {
        }

        public void run() {
            try {
                Listener.this.m_ServerSocket = new ServerSocket(Listener.this.m_Port, 1, InetAddress.getByName(Listener.this.m_Ip));
                Listener.this.m_ServerSocket.setSoTimeout(Listener.this.m_SoTimeout);
                do {
                    try {
                        Socket s = Listener.this.m_ServerSocket.accept();
                        if (Listener.this.m_UseCounter.get() >= Listener.this.m_MaxConnections) {
                            PrintStream out = new PrintStream(s.getOutputStream());
                            out.print(Listener.INUSE_MESSAGE);
                            out.flush();
                            out.close();
                            s.close();
                            continue;
                        }
                        Listener.this.m_UseCounter.increment();
                        Thread connectionThread = new Thread(new Shell(Listener.this, s, Listener.this.m_UseCounter));
                        connectionThread.setName("telnetconsole.shell remote=" + s.getRemoteSocketAddress());
                        connectionThread.start();
                    }
                    catch (SocketException ex) {
                    }
                    catch (SocketTimeoutException ste) {
                        // empty catch block
                    }
                } while (!Listener.this.m_Stop);
            }
            catch (IOException e) {
                Activator.getServices().error("Listener.Acceptor::activate()", e);
            }
        }
    }
}

