/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.registry;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Properties;
import javax.xml.registry.Connection;
import javax.xml.registry.FederatedConnection;
import javax.xml.registry.JAXRException;

public abstract class ConnectionFactory {
    private static final String CONNECTION_FACTORY_CLASS = "javax.xml.registry.ConnectionFactoryClass";
    private static final String DEFAULT_CONNECTION_FACTORY = "com.sun.xml.registry.common.ConnectionFactoryImpl";

    public abstract void setProperties(Properties var1) throws JAXRException;

    public abstract Properties getProperties() throws JAXRException;

    public abstract Connection createConnection() throws JAXRException;

    public abstract FederatedConnection createFederatedConnection(Collection var1) throws JAXRException;

    public static ConnectionFactory newInstance() throws JAXRException {
        try {
            return (ConnectionFactory)ConnectionFactory.find(CONNECTION_FACTORY_CLASS, DEFAULT_CONNECTION_FACTORY);
        }
        catch (Exception exception) {
            throw new JAXRException("Unable to create ConnectionFactory: " + exception.getMessage());
        }
    }

    private static Object newInstance(String string2, ClassLoader classLoader) throws JAXRException {
        try {
            Class<?> clazz = classLoader == null ? Class.forName(string2) : classLoader.loadClass(string2);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXRException("Provider " + string2 + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new JAXRException("Provider " + string2 + " could not be instantiated: " + exception, exception);
        }
    }

    static Object find(String string2, String string3) throws JAXRException {
        Object object;
        Object object2;
        String string4;
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            throw new JAXRException(exception.toString(), exception);
        }
        try {
            string4 = System.getProperty(string2);
            if (string4 != null) {
                return ConnectionFactory.newInstance(string4, classLoader);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            string4 = System.getProperty("java.home");
            object2 = string4 + File.separator + "lib" + File.separator + "jaxr.properties";
            object = new File((String)object2);
            if (((File)object).exists()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream((File)object));
                String string5 = properties.getProperty(string2);
                return ConnectionFactory.newInstance(string5, classLoader);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string4 = "META-INF/services/" + string2;
        try {
            object2 = null;
            object2 = classLoader == null ? ClassLoader.getSystemResourceAsStream(string4) : classLoader.getResourceAsStream(string4);
            if (object2 != null) {
                object = new BufferedReader(new InputStreamReader((InputStream)object2, "UTF-8"));
                String string6 = ((BufferedReader)object).readLine();
                ((BufferedReader)object).close();
                if (string6 != null && !"".equals(string6)) {
                    return ConnectionFactory.newInstance(string6, classLoader);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 == null) {
            throw new JAXRException("Provider for " + string2 + " cannot be found", null);
        }
        return ConnectionFactory.newInstance(string3, classLoader);
    }
}

