/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management.server;

import com.sun.istack.logging.Logger;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.ws.api.config.management.EndpointCreationAttributes;
import com.sun.xml.ws.api.config.management.ManagedEndpoint;
import com.sun.xml.ws.api.config.management.NamedParameters;
import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.config.management.server.ManagementWSDLPatcher;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.sourcemodel.attach.ExternalAttachmentsUnmarshaller;
import com.sun.xml.ws.server.EndpointFactory;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReDelegate {
    private static final Logger LOGGER = Logger.getLogger(ReDelegate.class);
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();

    public static <T> void recreate(NamedParameters parameters) {
        ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = (ClassLoader)parameters.get("CLASS_LOADER");
            Thread.currentThread().setContextClassLoader(classLoader);
            String newConfig = (String)parameters.get("CONFIGURATION_DATA");
            Map<URI, Policy> urnToPolicy = ExternalAttachmentsUnmarshaller.unmarshal(new StringReader(newConfig));
            ManagedEndpoint managedEndpoint = (ManagedEndpoint)parameters.get("ENDPOINT_INSTANCE");
            EndpointCreationAttributes creationAttributes = (EndpointCreationAttributes)parameters.get("CREATION_ATTRIBUTES");
            WSEndpoint<T> delegate = ReDelegate.recreateEndpoint(managedEndpoint, creationAttributes, urnToPolicy);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(ManagementMessages.WSM_5092_NEW_ENDPOINT_DELEGATE(delegate));
            }
            managedEndpoint.swapEndpointDelegate(delegate);
        }
        catch (Throwable e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5091_ENDPOINT_CREATION_FAILED(), e));
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedClassLoader);
        }
    }

    private static <T> WSEndpoint<T> recreateEndpoint(WSEndpoint<T> endpoint, EndpointCreationAttributes creationAttributes, Map<URI, Policy> urnToPolicy) {
        ServiceDefinition serviceDefinition = endpoint.getServiceDefinition();
        if (serviceDefinition == null) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5093_NO_SERVICE_DEFINITION()));
        }
        LinkedList<SDDocumentSource> documentSources = new LinkedList<SDDocumentSource>();
        for (SDDocument doc : serviceDefinition) {
            if (doc.isWSDL()) {
                documentSources.add(ReDelegate.replacePolicies(doc, urnToPolicy));
                continue;
            }
            documentSources.add(ReDelegate.convertDocument(doc));
        }
        endpoint.closeManagedObjectManager();
        return EndpointFactory.createEndpoint(endpoint.getImplementationClass(), creationAttributes.isProcessHandlerAnnotation(), creationAttributes.getInvoker(), endpoint.getServiceName(), endpoint.getPortName(), endpoint.getContainer(), endpoint.getBinding(), null, documentSources, creationAttributes.getEntityResolver(), creationAttributes.isTransportSynchronous());
    }

    private static SDDocumentSource replacePolicies(SDDocument doc, Map<URI, Policy> urnToPolicy) {
        try {
            StringWriter writer = new StringWriter();
            XMLStreamWriter xmlWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter(writer);
            doc.writeTo((PortAddressResolver)new MockPortAddressResolver(), (DocumentAddressResolver)new MockDocumentAddressResolver(), xmlWriter);
            xmlWriter.flush();
            ManagementWSDLPatcher patcher = new ManagementWSDLPatcher(urnToPolicy);
            StringReader reader = new StringReader(writer.toString());
            XMLStreamReader xmlReader = XML_INPUT_FACTORY.createXMLStreamReader(reader);
            StringWriter newWSDLWriter = new StringWriter();
            XMLStreamWriter newWSDLXMLWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter(newWSDLWriter);
            newWSDLXMLWriter.writeStartDocument();
            patcher.bridge(xmlReader, newWSDLXMLWriter);
            newWSDLXMLWriter.writeEndDocument();
            newWSDLXMLWriter.flush();
            XMLStreamReader newWSDLXMLReader = XML_INPUT_FACTORY.createXMLStreamReader(new StringReader(newWSDLWriter.toString()));
            XMLStreamBuffer buffer = XMLStreamBuffer.createNewBufferFromXMLStreamReader(newWSDLXMLReader);
            return SDDocumentSource.create(doc.getURL(), buffer);
        }
        catch (IOException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5094_FAILED_POLICIES_REPLACE(doc), (Throwable)e));
        }
        catch (XMLStreamException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5094_FAILED_POLICIES_REPLACE(doc), (Throwable)e));
        }
    }

    private static SDDocumentSource convertDocument(SDDocument doc) {
        try {
            if (doc instanceof SDDocumentSource) {
                return (SDDocumentSource)((Object)doc);
            }
            StringWriter writer = new StringWriter();
            XMLStreamWriter xmlWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter(writer);
            doc.writeTo((PortAddressResolver)new MockPortAddressResolver(), (DocumentAddressResolver)new MockDocumentAddressResolver(), xmlWriter);
            writer.flush();
            StringReader reader = new StringReader(writer.toString());
            XMLStreamReader xmlReader = XML_INPUT_FACTORY.createXMLStreamReader(reader);
            XMLStreamBuffer buffer = XMLStreamBuffer.createNewBufferFromXMLStreamReader(xmlReader);
            return SDDocumentSource.create(doc.getURL(), buffer);
        }
        catch (IOException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5095_FAILED_SDDOCUMENT_CONVERSION(doc), (Throwable)e));
        }
        catch (XMLStreamException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5095_FAILED_SDDOCUMENT_CONVERSION(doc), (Throwable)e));
        }
    }

    private static class MockDocumentAddressResolver
    implements DocumentAddressResolver {
        private MockDocumentAddressResolver() {
        }

        public String getRelativeAddressFor(SDDocument current, SDDocument referenced) {
            return referenced.getURL().toExternalForm();
        }
    }

    private static class MockPortAddressResolver
    extends PortAddressResolver {
        private MockPortAddressResolver() {
        }

        public String getAddressFor(QName serviceName, String portName) {
            return "temporary address after web service reconfiguration";
        }
    }
}

