/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap.impl;

import com.sun.org.apache.xerces.internal.dom.ElementNSImpl;
import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.soap.SOAPDocument;
import com.sun.xml.messaging.saaj.soap.SOAPDocumentImpl;
import com.sun.xml.messaging.saaj.soap.name.NameImpl;
import com.sun.xml.messaging.saaj.util.JaxmURI;
import com.sun.xml.messaging.saaj.util.NamespaceContextIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Text;

public class ElementImpl
extends ElementNSImpl
implements SOAPElement,
SOAPBodyElement {
    public static final String DSIG_NS = "http://www.w3.org/2000/09/xmldsig#".intern();
    public static final String XENC_NS = "http://www.w3.org/2001/04/xmlenc#".intern();
    public static final String WSU_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".intern();
    private AttributeManager encodingStyleAttribute = new AttributeManager();
    protected QName elementQName;
    protected static final Logger log = Logger.getLogger("javax.xml.messaging.saaj.soap.impl", "com.sun.xml.messaging.saaj.soap.impl.LocalStrings");
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/".intern();
    public static final String XML_URI = "http://www.w3.org/XML/1998/namespace".intern();

    public ElementImpl(SOAPDocumentImpl ownerDoc, Name name) {
        super(ownerDoc, name.getURI(), name.getQualifiedName(), name.getLocalName());
        this.elementQName = NameImpl.convertToQName(name);
    }

    public ElementImpl(SOAPDocumentImpl ownerDoc, QName name) {
        super(ownerDoc, name.getNamespaceURI(), ElementImpl.getQualifiedName(name), name.getLocalPart());
        this.elementQName = name;
    }

    public ElementImpl(SOAPDocumentImpl ownerDoc, String uri, String qualifiedName) {
        super(ownerDoc, uri, qualifiedName);
        this.elementQName = new QName(uri, ElementImpl.getLocalPart(qualifiedName), ElementImpl.getPrefix(qualifiedName));
    }

    public void ensureNamespaceIsDeclared(String prefix, String uri) {
        String alreadyDeclaredUri = this.getNamespaceURI(prefix);
        if (alreadyDeclaredUri == null || !alreadyDeclaredUri.equals(uri)) {
            try {
                this.addNamespaceDeclaration(prefix, uri);
            }
            catch (SOAPException e) {
                // empty catch block
            }
        }
    }

    public Document getOwnerDocument() {
        SOAPDocument ownerSOAPDocument = (SOAPDocument)((Object)super.getOwnerDocument());
        if (ownerSOAPDocument == null) {
            return null;
        }
        return ownerSOAPDocument.getDocument();
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        return this.addElement(name);
    }

    public SOAPElement addChildElement(QName qname) throws SOAPException {
        return this.addElement(qname);
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        return this.addChildElement(NameImpl.createFromUnqualifiedName(localName));
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        String uri = this.getNamespaceURI(prefix);
        if (uri == null) {
            log.log(Level.SEVERE, "SAAJ0101.impl.parent.of.body.elem.mustbe.body", new String[]{prefix});
            throw new SOAPExceptionImpl("Unable to locate namespace for prefix " + prefix);
        }
        return this.addChildElement(localName, prefix, uri);
    }

    public String getNamespaceURI(String prefix) {
        block6: {
            block5: {
                if ("xmlns".equals(prefix)) {
                    return XMLNS_URI;
                }
                if ("xml".equals(prefix)) {
                    return XML_URI;
                }
                if (!"".equals(prefix)) break block5;
                for (org.w3c.dom.Node currentAncestor = this; currentAncestor != null && !(currentAncestor instanceof Document); currentAncestor = currentAncestor.getParentNode()) {
                    if (!(currentAncestor instanceof ElementImpl)) continue;
                    QName name = currentAncestor.getElementQName();
                    if (!((Element)currentAncestor).hasAttributeNS(XMLNS_URI, "xmlns")) continue;
                    String uri = ((Element)currentAncestor).getAttributeNS(XMLNS_URI, "xmlns");
                    if ("".equals(uri)) {
                        return null;
                    }
                    return uri;
                }
                break block6;
            }
            if (prefix == null) break block6;
            for (org.w3c.dom.Node currentAncestor = this; currentAncestor != null && !(currentAncestor instanceof Document); currentAncestor = currentAncestor.getParentNode()) {
                if (!((Element)currentAncestor).hasAttributeNS(XMLNS_URI, prefix)) continue;
                return ((Element)currentAncestor).getAttributeNS(XMLNS_URI, prefix);
            }
        }
        return null;
    }

    public SOAPElement setElementQName(QName newName) throws SOAPException {
        ElementImpl copy = new ElementImpl((SOAPDocumentImpl)this.getOwnerDocument(), newName);
        return ElementImpl.replaceElementWithSOAPElement(this, copy);
    }

    public QName createQName(String localName, String prefix) throws SOAPException {
        String uri = this.getNamespaceURI(prefix);
        if (uri == null) {
            log.log(Level.SEVERE, "SAAJ0102.impl.cannot.locate.ns", new Object[]{prefix});
            throw new SOAPException("Unable to locate namespace for prefix " + prefix);
        }
        return new QName(uri, localName, prefix);
    }

    public String getNamespacePrefix(String uri) {
        NamespaceContextIterator eachNamespace = this.getNamespaceContextNodes();
        while (eachNamespace.hasNext()) {
            Attr namespaceDecl = eachNamespace.nextNamespaceAttr();
            if (!namespaceDecl.getNodeValue().equals(uri)) continue;
            String candidatePrefix = namespaceDecl.getLocalName();
            if ("xmlns".equals(candidatePrefix)) {
                return "";
            }
            return candidatePrefix;
        }
        for (org.w3c.dom.Node currentAncestor = this; currentAncestor != null && !(currentAncestor instanceof Document); currentAncestor = currentAncestor.getParentNode()) {
            if (!uri.equals(currentAncestor.getNamespaceURI())) continue;
            return currentAncestor.getPrefix();
        }
        return null;
    }

    protected Attr getNamespaceAttr(String prefix) {
        NamespaceContextIterator eachNamespace = this.getNamespaceContextNodes();
        if (!"".equals(prefix)) {
            prefix = ":" + prefix;
        }
        while (eachNamespace.hasNext()) {
            Attr namespaceDecl = eachNamespace.nextNamespaceAttr();
            if (!(!"".equals(prefix) ? namespaceDecl.getNodeName().endsWith(prefix) : namespaceDecl.getNodeName().equals("xmlns"))) continue;
            return namespaceDecl;
        }
        return null;
    }

    public NamespaceContextIterator getNamespaceContextNodes() {
        return this.getNamespaceContextNodes(true);
    }

    public NamespaceContextIterator getNamespaceContextNodes(boolean traverseStack) {
        return new NamespaceContextIterator(this, traverseStack);
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        SOAPElement newElement = this.createElement(NameImpl.create(localName, prefix, uri));
        this.addNode(newElement);
        return this.convertToSoapElement(newElement);
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        String elementURI = element.getElementName().getURI();
        String localName = element.getLocalName();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(elementURI) || "http://www.w3.org/2003/05/soap-envelope".equals(elementURI)) {
            if ("Envelope".equalsIgnoreCase(localName) || "Header".equalsIgnoreCase(localName) || "Body".equalsIgnoreCase(localName)) {
                log.severe("SAAJ0103.impl.cannot.add.fragements");
                throw new SOAPExceptionImpl("Cannot add fragments which contain elements which are in the SOAP namespace");
            }
            if ("Fault".equalsIgnoreCase(localName) && !"Body".equalsIgnoreCase(this.getLocalName())) {
                log.severe("SAAJ0154.impl.adding.fault.to.nonbody");
                throw new SOAPExceptionImpl("Cannot add a SOAPFault as a child of " + this.getLocalName());
            }
            if ("Detail".equalsIgnoreCase(localName) && !"Fault".equalsIgnoreCase(this.getLocalName())) {
                log.severe("SAAJ0155.impl.adding.detail.nonfault");
                throw new SOAPExceptionImpl("Cannot add a Detail as a child of " + this.getLocalName());
            }
            if ("Fault".equalsIgnoreCase(localName)) {
                if (!elementURI.equals(this.getElementName().getURI())) {
                    log.severe("SAAJ0158.impl.version.mismatch.fault");
                    throw new SOAPExceptionImpl("SOAP Version mismatch encountered when trying to add SOAPFault to SOAPBody");
                }
                Iterator it = this.getChildElements();
                if (it.hasNext()) {
                    log.severe("SAAJ0156.impl.adding.fault.error");
                    throw new SOAPExceptionImpl("Cannot add SOAPFault as a child of a non-Empty SOAPBody");
                }
            }
        }
        String encodingStyle = element.getEncodingStyle();
        ElementImpl importedElement = (ElementImpl)this.importElement(element);
        this.addNode(importedElement);
        if (encodingStyle != null) {
            importedElement.setEncodingStyle(encodingStyle);
        }
        return this.convertToSoapElement(importedElement);
    }

    protected Element importElement(Element element) {
        Document document = this.getOwnerDocument();
        Document oldDocument = element.getOwnerDocument();
        if (!oldDocument.equals(document)) {
            return (Element)document.importNode(element, true);
        }
        return element;
    }

    protected SOAPElement addElement(Name name) throws SOAPException {
        SOAPElement newElement = this.createElement(name);
        this.addNode(newElement);
        return this.circumventBug5034339(newElement);
    }

    protected SOAPElement addElement(QName name) throws SOAPException {
        SOAPElement newElement = this.createElement(name);
        this.addNode(newElement);
        return this.circumventBug5034339(newElement);
    }

    protected SOAPElement createElement(Name name) {
        if (this.isNamespaceQualified(name)) {
            return (SOAPElement)this.getOwnerDocument().createElementNS(name.getURI(), name.getQualifiedName());
        }
        return (SOAPElement)this.getOwnerDocument().createElement(name.getQualifiedName());
    }

    protected SOAPElement createElement(QName name) {
        if (this.isNamespaceQualified(name)) {
            return (SOAPElement)this.getOwnerDocument().createElementNS(name.getNamespaceURI(), ElementImpl.getQualifiedName(name));
        }
        return (SOAPElement)this.getOwnerDocument().createElement(ElementImpl.getQualifiedName(name));
    }

    protected void addNode(org.w3c.dom.Node newElement) throws SOAPException {
        ElementImpl element;
        QName elementName;
        this.insertBefore(newElement, null);
        if (this.getOwnerDocument() instanceof DocumentFragment) {
            return;
        }
        if (newElement instanceof ElementImpl && !"".equals((elementName = (element = (ElementImpl)newElement).getElementQName()).getNamespaceURI())) {
            element.ensureNamespaceIsDeclared(elementName.getPrefix(), elementName.getNamespaceURI());
        }
    }

    protected SOAPElement findChild(NameImpl name) {
        Iterator eachChild = this.getChildElementNodes();
        while (eachChild.hasNext()) {
            SOAPElement child = (SOAPElement)eachChild.next();
            if (!child.getElementName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public SOAPElement addTextNode(String text) throws SOAPException {
        if (text.startsWith("<![CDATA[") || text.startsWith("<![cdata[")) {
            return this.addCDATA(text.substring("<![CDATA[".length(), text.length() - 3));
        }
        return this.addText(text);
    }

    protected SOAPElement addCDATA(String text) throws SOAPException {
        CDATASection cdata = this.getOwnerDocument().createCDATASection(text);
        this.addNode(cdata);
        return this;
    }

    protected SOAPElement addText(String text) throws SOAPException {
        Text textNode = this.getOwnerDocument().createTextNode(text);
        this.addNode(textNode);
        return this;
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        this.addAttributeBare(name, value);
        if (!"".equals(name.getURI())) {
            this.ensureNamespaceIsDeclared(name.getPrefix(), name.getURI());
        }
        return this;
    }

    public SOAPElement addAttribute(QName qname, String value) throws SOAPException {
        this.addAttributeBare(qname, value);
        if (!"".equals(qname.getNamespaceURI())) {
            this.ensureNamespaceIsDeclared(qname.getPrefix(), qname.getNamespaceURI());
        }
        return this;
    }

    private void addAttributeBare(Name name, String value) {
        this.addAttributeBare(name.getURI(), name.getPrefix(), name.getQualifiedName(), value);
    }

    private void addAttributeBare(QName name, String value) {
        this.addAttributeBare(name.getNamespaceURI(), name.getPrefix(), ElementImpl.getQualifiedName(name), value);
    }

    private void addAttributeBare(String uri, String prefix, String qualifiedName, String value) {
        String string2 = uri = uri.length() == 0 ? null : uri;
        if (qualifiedName.equals("xmlns")) {
            uri = XMLNS_URI;
        }
        if (uri == null) {
            this.setAttribute(qualifiedName, value);
        } else {
            this.setAttributeNS(uri, qualifiedName, value);
        }
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String uri) throws SOAPException {
        if (prefix.length() > 0) {
            this.setAttributeNS(XMLNS_URI, "xmlns:" + prefix, uri);
        } else {
            this.setAttributeNS(XMLNS_URI, "xmlns", uri);
        }
        return this;
    }

    public String getAttributeValue(Name name) {
        return ElementImpl.getAttributeValueFrom(this, name);
    }

    public String getAttributeValue(QName qname) {
        return ElementImpl.getAttributeValueFrom(this, qname.getNamespaceURI(), qname.getLocalPart(), qname.getPrefix(), ElementImpl.getQualifiedName(qname));
    }

    public Iterator getAllAttributes() {
        Iterator i = ElementImpl.getAllAttributesFrom(this);
        ArrayList<Name> list = new ArrayList<Name>();
        while (i.hasNext()) {
            Name name = (Name)i.next();
            if ("xmlns".equalsIgnoreCase(name.getPrefix())) continue;
            list.add(name);
        }
        return list.iterator();
    }

    public Iterator getAllAttributesAsQNames() {
        Iterator i = ElementImpl.getAllAttributesFrom(this);
        ArrayList<QName> list = new ArrayList<QName>();
        while (i.hasNext()) {
            Name name = (Name)i.next();
            if ("xmlns".equalsIgnoreCase(name.getPrefix())) continue;
            list.add(NameImpl.convertToQName(name));
        }
        return list.iterator();
    }

    public Iterator getNamespacePrefixes() {
        return this.doGetNamespacePrefixes(false);
    }

    public Iterator getVisibleNamespacePrefixes() {
        return this.doGetNamespacePrefixes(true);
    }

    protected Iterator doGetNamespacePrefixes(final boolean deep) {
        return new Iterator(){
            String next = null;
            String last = null;
            NamespaceContextIterator eachNamespace = ElementImpl.this.getNamespaceContextNodes(deep);

            void findNext() {
                while (this.next == null && this.eachNamespace.hasNext()) {
                    String attributeKey = this.eachNamespace.nextNamespaceAttr().getNodeName();
                    if (!attributeKey.startsWith("xmlns:")) continue;
                    this.next = attributeKey.substring("xmlns:".length());
                }
            }

            public boolean hasNext() {
                this.findNext();
                return this.next != null;
            }

            public Object next() {
                this.findNext();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.last = this.next;
                this.next = null;
                return this.last;
            }

            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                this.eachNamespace.remove();
                this.next = null;
                this.last = null;
            }
        };
    }

    public Name getElementName() {
        return NameImpl.convertToName(this.elementQName);
    }

    public QName getElementQName() {
        return this.elementQName;
    }

    public boolean removeAttribute(Name name) {
        return this.removeAttribute(name.getURI(), name.getLocalName());
    }

    public boolean removeAttribute(QName name) {
        return this.removeAttribute(name.getNamespaceURI(), name.getLocalPart());
    }

    private boolean removeAttribute(String uri, String localName) {
        String nonzeroLengthUri = uri == null || uri.length() == 0 ? null : uri;
        Attr attribute = this.getAttributeNodeNS(nonzeroLengthUri, localName);
        if (attribute == null) {
            return false;
        }
        this.removeAttributeNode(attribute);
        return true;
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        Attr declaration = this.getNamespaceAttr(prefix);
        if (declaration == null) {
            return false;
        }
        try {
            this.removeAttributeNode(declaration);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return true;
    }

    public Iterator getChildElements() {
        return ElementImpl.getChildElementsFrom(this);
    }

    protected SOAPElement convertToSoapElement(Element element) {
        if (element instanceof SOAPElement) {
            return (SOAPElement)element;
        }
        return ElementImpl.replaceElementWithSOAPElement(element, (ElementImpl)this.createElement(NameImpl.copyElementName(element)));
    }

    protected static SOAPElement replaceElementWithSOAPElement(Element element, ElementImpl copy) {
        Iterator eachAttribute = ElementImpl.getAllAttributesFrom(element);
        while (eachAttribute.hasNext()) {
            Name name = (Name)eachAttribute.next();
            copy.addAttributeBare(name, ElementImpl.getAttributeValueFrom(element, name));
        }
        Iterator eachChild = ElementImpl.getChildElementsFrom(element);
        while (eachChild.hasNext()) {
            org.w3c.dom.Node nextChild = (org.w3c.dom.Node)eachChild.next();
            copy.insertBefore(nextChild, null);
        }
        org.w3c.dom.Node parent = element.getParentNode();
        if (parent != null) {
            parent.replaceChild(copy, element);
        }
        return copy;
    }

    protected Iterator getChildElementNodes() {
        return new Iterator(){
            Iterator eachNode;
            org.w3c.dom.Node next;
            org.w3c.dom.Node last;
            {
                this.eachNode = ElementImpl.this.getChildElements();
                this.next = null;
                this.last = null;
            }

            public boolean hasNext() {
                if (this.next == null) {
                    while (this.eachNode.hasNext()) {
                        org.w3c.dom.Node node = (org.w3c.dom.Node)this.eachNode.next();
                        if (!(node instanceof SOAPElement)) continue;
                        this.next = node;
                        break;
                    }
                }
                return this.next != null;
            }

            public Object next() {
                if (this.hasNext()) {
                    this.last = this.next;
                    this.next = null;
                    return this.last;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                org.w3c.dom.Node target = this.last;
                this.last = null;
                ElementImpl.this.removeChild(target);
            }
        };
    }

    public Iterator getChildElements(Name name) {
        return this.getChildElements(name.getURI(), name.getLocalName());
    }

    public Iterator getChildElements(QName qname) {
        return this.getChildElements(qname.getNamespaceURI(), qname.getLocalPart());
    }

    private Iterator getChildElements(final String nameUri, final String nameLocal) {
        return new Iterator(){
            Iterator eachElement;
            org.w3c.dom.Node next;
            org.w3c.dom.Node last;
            {
                this.eachElement = ElementImpl.this.getChildElementNodes();
                this.next = null;
                this.last = null;
            }

            public boolean hasNext() {
                if (this.next == null) {
                    while (this.eachElement.hasNext()) {
                        org.w3c.dom.Node element = (org.w3c.dom.Node)this.eachElement.next();
                        String elementUri = element.getNamespaceURI();
                        elementUri = elementUri == null ? "" : elementUri;
                        String elementName = element.getLocalName();
                        if (!elementUri.equals(nameUri) || !elementName.equals(nameLocal)) continue;
                        this.next = element;
                        break;
                    }
                }
                return this.next != null;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.next;
                this.next = null;
                return this.last;
            }

            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                org.w3c.dom.Node target = this.last;
                this.last = null;
                ElementImpl.this.removeChild(target);
            }
        };
    }

    public void removeContents() {
        org.w3c.dom.Node currentChild = this.getFirstChild();
        while (currentChild != null) {
            org.w3c.dom.Node temp = currentChild.getNextSibling();
            if (currentChild instanceof Node) {
                ((Node)currentChild).detachNode();
            } else {
                org.w3c.dom.Node parent = currentChild.getParentNode();
                if (parent != null) {
                    parent.removeChild(currentChild);
                }
            }
            currentChild = temp;
        }
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        if (!"".equals(encodingStyle)) {
            try {
                JaxmURI uri = new JaxmURI(encodingStyle);
            }
            catch (JaxmURI.MalformedURIException m) {
                log.log(Level.SEVERE, "SAAJ0105.impl.encoding.style.mustbe.valid.URI", new String[]{encodingStyle});
                throw new IllegalArgumentException("Encoding style (" + encodingStyle + ") should be a valid URI");
            }
        }
        this.encodingStyleAttribute.setValue(encodingStyle);
        this.tryToFindEncodingStyleAttributeName();
    }

    public String getEncodingStyle() {
        Attr attr;
        String encodingStyle = this.encodingStyleAttribute.getValue();
        if (encodingStyle != null) {
            return encodingStyle;
        }
        String soapNamespace = this.getSOAPNamespace();
        if (soapNamespace != null && (attr = this.getAttributeNodeNS(soapNamespace, "encodingStyle")) != null) {
            encodingStyle = attr.getValue();
            try {
                this.setEncodingStyle(encodingStyle);
            }
            catch (SOAPException se) {
                // empty catch block
            }
            return encodingStyle;
        }
        return null;
    }

    public String getValue() {
        Node valueNode = this.getValueNode();
        return valueNode == null ? null : valueNode.getValue();
    }

    public void setValue(String value) {
        org.w3c.dom.Node valueNode = this.getValueNodeStrict();
        if (valueNode != null) {
            valueNode.setNodeValue(value);
        } else {
            try {
                this.addTextNode(value);
            }
            catch (SOAPException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    protected org.w3c.dom.Node getValueNodeStrict() {
        org.w3c.dom.Node node = this.getFirstChild();
        if (node != null) {
            if (node.getNextSibling() == null && node.getNodeType() == 3) {
                return node;
            }
            log.severe("SAAJ0107.impl.elem.child.not.single.text");
            throw new IllegalStateException();
        }
        return null;
    }

    protected Node getValueNode() {
        Iterator i = this.getChildElements();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            if (n.getNodeType() != 3 && n.getNodeType() != 4) continue;
            this.normalize();
            return n;
        }
        return null;
    }

    public void setParentElement(SOAPElement element) throws SOAPException {
        if (element == null) {
            log.severe("SAAJ0106.impl.no.null.to.parent.elem");
            throw new SOAPException("Cannot pass NULL to setParentElement");
        }
        element.addChildElement(this);
        this.findEncodingStyleAttributeName();
    }

    protected void findEncodingStyleAttributeName() throws SOAPException {
        String soapNamespacePrefix;
        String soapNamespace = this.getSOAPNamespace();
        if (soapNamespace != null && (soapNamespacePrefix = this.getNamespacePrefix(soapNamespace)) != null) {
            this.setEncodingStyleNamespace(soapNamespace, soapNamespacePrefix);
        }
    }

    protected void setEncodingStyleNamespace(String soapNamespace, String soapNamespacePrefix) throws SOAPException {
        NameImpl encodingStyleAttributeName = NameImpl.create("encodingStyle", soapNamespacePrefix, soapNamespace);
        this.encodingStyleAttribute.setName(encodingStyleAttributeName);
    }

    public SOAPElement getParentElement() {
        org.w3c.dom.Node parentNode = this.getParentNode();
        if (parentNode instanceof SOAPDocument) {
            return null;
        }
        return (SOAPElement)parentNode;
    }

    protected String getSOAPNamespace() {
        String soapNamespace = null;
        for (SOAPElement antecedent = this; antecedent != null; antecedent = antecedent.getParentElement()) {
            Name antecedentName = antecedent.getElementName();
            String antecedentNamespace = antecedentName.getURI();
            if (!"http://schemas.xmlsoap.org/soap/envelope/".equals(antecedentNamespace) && !"http://www.w3.org/2003/05/soap-envelope".equals(antecedentNamespace)) continue;
            soapNamespace = antecedentNamespace;
            break;
        }
        return soapNamespace;
    }

    public void detachNode() {
        org.w3c.dom.Node parent = this.getParentNode();
        if (parent != null) {
            parent.removeChild(this);
        }
        this.encodingStyleAttribute.clearNameAndValue();
    }

    public void tryToFindEncodingStyleAttributeName() {
        try {
            this.findEncodingStyleAttributeName();
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
    }

    public void recycleNode() {
        this.detachNode();
    }

    protected static Attr getNamespaceAttrFrom(Element element, String prefix) {
        NamespaceContextIterator eachNamespace = new NamespaceContextIterator(element);
        while (eachNamespace.hasNext()) {
            Attr namespaceDecl = eachNamespace.nextNamespaceAttr();
            String declaredPrefix = NameImpl.getLocalNameFromTagName(namespaceDecl.getNodeName());
            if (!declaredPrefix.equals(prefix)) continue;
            return namespaceDecl;
        }
        return null;
    }

    protected static Iterator getAllAttributesFrom(Element element) {
        final NamedNodeMap attributes = element.getAttributes();
        return new Iterator(){
            int attributesLength;
            int attributeIndex;
            String currentName;
            {
                this.attributesLength = attributes.getLength();
                this.attributeIndex = 0;
            }

            public boolean hasNext() {
                return this.attributeIndex < this.attributesLength;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                org.w3c.dom.Node current = attributes.item(this.attributeIndex++);
                this.currentName = current.getNodeName();
                String prefix = NameImpl.getPrefixFromTagName(this.currentName);
                if (prefix.length() == 0) {
                    return NameImpl.createFromUnqualifiedName(this.currentName);
                }
                Name attributeName = NameImpl.createFromQualifiedName(this.currentName, current.getNamespaceURI());
                return attributeName;
            }

            public void remove() {
                if (this.currentName == null) {
                    throw new IllegalStateException();
                }
                attributes.removeNamedItem(this.currentName);
            }
        };
    }

    protected static String getAttributeValueFrom(Element element, Name name) {
        return ElementImpl.getAttributeValueFrom(element, name.getURI(), name.getLocalName(), name.getPrefix(), name.getQualifiedName());
    }

    private static String getAttributeValueFrom(Element element, String uri, String localName, String prefix, String qualifiedName) {
        boolean mustUseGetAttributeNodeNS;
        String nonzeroLengthUri = uri == null || uri.length() == 0 ? null : uri;
        boolean bl = mustUseGetAttributeNodeNS = nonzeroLengthUri != null;
        if (mustUseGetAttributeNodeNS) {
            if (!element.hasAttributeNS(uri, localName)) {
                return null;
            }
            String attrValue = element.getAttributeNS(nonzeroLengthUri, localName);
            return attrValue;
        }
        Attr attribute = null;
        attribute = element.getAttributeNode(qualifiedName);
        return attribute == null ? null : attribute.getValue();
    }

    protected static Iterator getChildElementsFrom(final Element element) {
        return new Iterator(){
            org.w3c.dom.Node next;
            org.w3c.dom.Node nextNext;
            org.w3c.dom.Node last;
            {
                this.next = element.getFirstChild();
                this.nextNext = null;
                this.last = null;
            }

            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                if (this.next == null && this.nextNext != null) {
                    this.next = this.nextNext;
                }
                return this.next != null;
            }

            public Object next() {
                if (this.hasNext()) {
                    this.last = this.next;
                    this.next = null;
                    if (element instanceof ElementImpl && this.last instanceof Element) {
                        this.last = ((ElementImpl)element).convertToSoapElement((Element)this.last);
                    }
                    this.nextNext = this.last.getNextSibling();
                    return this.last;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                org.w3c.dom.Node target = this.last;
                this.last = null;
                element.removeChild(target);
            }
        };
    }

    public static String getQualifiedName(QName name) {
        String prefix = name.getPrefix();
        String localName = name.getLocalPart();
        String qualifiedName = null;
        qualifiedName = prefix != null && prefix.length() > 0 ? prefix + ":" + localName : localName;
        return qualifiedName;
    }

    public static String getLocalPart(String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Cannot get local name for a \"null\" qualified name");
        }
        int index = qualifiedName.indexOf(58);
        if (index < 0) {
            return qualifiedName;
        }
        return qualifiedName.substring(index + 1);
    }

    public static String getPrefix(String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Cannot get prefix for a  \"null\" qualified name");
        }
        int index = qualifiedName.indexOf(58);
        if (index < 0) {
            return "";
        }
        return qualifiedName.substring(0, index);
    }

    protected boolean isNamespaceQualified(Name name) {
        return !"".equals(name.getURI());
    }

    protected boolean isNamespaceQualified(QName name) {
        return !"".equals(name.getNamespaceURI());
    }

    protected SOAPElement circumventBug5034339(SOAPElement element) {
        String prefix;
        String defaultNamespace;
        Name elementName = element.getElementName();
        if (!this.isNamespaceQualified(elementName) && (defaultNamespace = this.getNamespaceURI(prefix = elementName.getPrefix())) != null) {
            NameImpl newElementName = NameImpl.create(elementName.getLocalName(), elementName.getPrefix(), defaultNamespace);
            SOAPElement newElement = this.createElement(newElementName);
            this.replaceChild(newElement, element);
            return newElement;
        }
        return element;
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        String localName;
        int index = qualifiedName.indexOf(58);
        if (index < 0) {
            Object prefix = null;
            localName = qualifiedName;
        } else {
            String prefix = qualifiedName.substring(0, index);
            localName = qualifiedName.substring(index + 1);
        }
        super.setAttributeNS(namespaceURI, qualifiedName, value);
        String tmpURI = this.getNamespaceURI();
        boolean isIDNS = false;
        if (tmpURI != null && (tmpURI.equals(DSIG_NS) || tmpURI.equals(XENC_NS))) {
            isIDNS = true;
        }
        if (localName.equals("Id")) {
            if (namespaceURI == null || namespaceURI.equals("")) {
                this.setIdAttribute(localName, true);
            } else if (isIDNS || WSU_NS.equals(namespaceURI)) {
                this.setIdAttributeNS(namespaceURI, localName, true);
            }
        }
    }

    class AttributeManager {
        Name attributeName = null;
        String attributeValue = null;

        AttributeManager() {
        }

        public void setName(Name newName) throws SOAPException {
            this.clearAttribute();
            this.attributeName = newName;
            this.reconcileAttribute();
        }

        public void clearName() {
            this.clearAttribute();
            this.attributeName = null;
        }

        public void setValue(String value) throws SOAPException {
            this.attributeValue = value;
            this.reconcileAttribute();
        }

        public Name getName() {
            return this.attributeName;
        }

        public String getValue() {
            return this.attributeValue;
        }

        public void clearNameAndValue() {
            this.attributeName = null;
            this.attributeValue = null;
        }

        private void reconcileAttribute() throws SOAPException {
            if (this.attributeName != null) {
                ElementImpl.this.removeAttribute(this.attributeName);
                if (this.attributeValue != null) {
                    ElementImpl.this.addAttribute(this.attributeName, this.attributeValue);
                }
            }
        }

        private void clearAttribute() {
            if (this.attributeName != null) {
                ElementImpl.this.removeAttribute(this.attributeName);
            }
        }
    }
}

