/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import com.sun.grizzly.tcp.Request;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jk.common.JniHandler;
import org.apache.jk.core.JkChannel;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;

public class ChannelJni
extends JniHandler
implements JkChannel {
    int receivedNote = 1;
    private static Logger log = Logger.getLogger(ChannelJni.class.getName());

    public void init() throws IOException {
        super.initNative("channel.jni:jni");
        if (this.apr == null) {
            return;
        }
        this.apr.addJkHandler("channelJni", this);
        log.info("JK: listening on channel.jni:jni");
        if (this.next == null) {
            if (this.nextName != null) {
                this.setNext(this.wEnv.getHandler(this.nextName));
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("dispatch");
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("request");
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Setting default next " + this.next.getClass().getName());
            }
        }
    }

    public int receive(Msg msg, MsgContext ep) throws IOException {
        Msg sentResponse = (Msg)ep.getNote(this.receivedNote);
        ep.setNote(this.receivedNote, null);
        if (sentResponse == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("No send() prior to receive(), no data buffer");
            }
            msg.reset();
            msg.end();
            sentResponse = msg;
        }
        sentResponse.processHeader();
        if (log.isLoggable(Level.FINEST)) {
            sentResponse.dump("received response ");
        }
        if (msg != sentResponse) {
            log.severe("Error, in JNI mode the msg used for receive() must be identical with the one used for send()");
        }
        return 0;
    }

    public int send(Msg msg, MsgContext ep) throws IOException {
        ep.setNote(this.receivedNote, null);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("ChannelJni.send: " + msg);
        }
        int rc = super.nativeDispatch(msg, ep, 21, 0);
        ep.setNote(this.receivedNote, msg);
        return rc;
    }

    public int flush(Msg msg, MsgContext ep) throws IOException {
        ep.setNote(this.receivedNote, null);
        return 0;
    }

    public boolean isSameAddress(MsgContext ep) {
        return true;
    }

    public void registerRequest(Request req, MsgContext ep, int count) {
    }

    public String getChannelName() {
        return this.getName();
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        if (this.apr == null) {
            return -1;
        }
        long xEnv = ep.getJniEnv();
        long cEndpointP = ep.getJniContext();
        int type = ep.getType();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("ChannelJni.invoke: " + ep + " " + type);
        }
        switch (type) {
            case 10: {
                return this.receive(msg, ep);
            }
            case 11: {
                return this.send(msg, ep);
            }
            case 12: {
                return this.flush(msg, ep);
            }
        }
        ep.setNote(this.receivedNote, null);
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Received request " + xEnv);
            }
            msg.processHeader();
            if (log.isLoggable(Level.FINEST)) {
                msg.dump("Incoming msg ");
            }
            int status = this.next.invoke(msg, ep);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("after processCallbacks " + status);
            }
            return status;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }
}

